/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.event.util.DBUtils;
import com.kingdee.eas.fi.gr.cslrpt.app.AbstractEliminationEntryCheckFacadeControllerBean;
import com.kingdee.eas.fi.gr.cslrpt.util.RptProperties;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class EliminationEntryCheckFacadeControllerBean
extends AbstractEliminationEntryCheckFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.cslrpt.app.EliminationEntryCheckFacadeControllerBean");
    private static final String RESOURCE = "com.kingdee.eas.fi.gr.cslrpt.ElimiEntryCheckResource";

    @Override
    protected RptRowSet _createTempTable(Context ctx, RptProperties params) throws BOSException {
        int year = params.getInt("year");
        int period = params.getInt("period");
        int periodType = params.getInt("periodType");
        String currencyId = params.getString("currencyId");
        String orgBoundId = params.getString("orgBoundId");
        String orgUnitId = params.getString("orgUnitId");
        String templateId = params.getString("templateId");
        String rptDate = params.getString("rptDate");
        List templateIDs = this.getTemplateID(ctx, templateId);
        HashMap mapCompFn = new HashMap();
        HashMap mapIdMoney = new HashMap();
        HashMap mapFdc = new HashMap();
        String tableName = params.getString("tableName");
        tableName = this.createTemporaryTable(ctx, year, period, periodType, currencyId, orgBoundId, orgUnitId, mapCompFn, tableName);
        try {
            this.insertNewRecord(ctx, tableName);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        IRowSet rs_invest = null;
        ArrayList<Object> listInvest = new ArrayList<Object>();
        ArrayList<String> listcompanyid = new ArrayList<String>();
        rs_invest = this.queryInvestData(ctx, year, period, periodType, orgBoundId, orgUnitId, rptDate, mapCompFn, tableName);
        try {
            if (rs_invest != null) {
                while (rs_invest.next()) {
                    listInvest.add(rs_invest.getString(1));
                    listInvest.add(rs_invest.getString(2));
                    listInvest.add(rs_invest.getDate(3));
                    listcompanyid.add(rs_invest.getString("fcompanyid"));
                }
            }
        }
        catch (SQLException e1) {
            throw new SQLDataException(e1);
        }
        this.insertInvestData(ctx, currencyId, mapCompFn, tableName, listInvest, listcompanyid);
        try {
            this.addDataToElimination(ctx, params, tableName, mapCompFn);
            this.addDataToInvestElim(ctx, params, tableName, mapCompFn);
            this.addDataToInvestIncoming(ctx, params, tableName, mapCompFn);
        }
        catch (Exception e1) {
            throw new BOSException((Throwable)e1);
        }
        this.insertDataToTable(ctx, year, period, periodType, currencyId, orgBoundId, orgUnitId, templateIDs, tableName);
        this.updateCompanyDataToTable(ctx, year, period, periodType, currencyId, orgBoundId, orgUnitId, templateIDs, mapIdMoney, mapFdc);
        IRowSet sel_rs = null;
        sel_rs = this.getIdsFromTable(ctx, tableName, sel_rs);
        this.costructUpdateTable(ctx, mapCompFn, mapIdMoney, tableName, sel_rs);
        this.insertTemplateNumberToTable(ctx, tableName);
        IRowSet diffrs = null;
        diffrs = this.queryTheOnLoanData(ctx, mapCompFn, tableName);
        this.updateTheOnLoanData(ctx, mapCompFn, tableName, diffrs);
        RptRowSet rst = new RptRowSet(new String[0], (Object[][])new Object[0][]);
        rst.setProperty("tableName", (Object)tableName);
        return rst;
    }

    private void updateTheOnLoanData(Context ctx, Map mapCompFn, String tableName, IRowSet diffrs) throws BOSException, SQLDataException {
        try {
            if (diffrs != null) {
                while (diffrs.next()) {
                    StringBuffer upSql = new StringBuffer();
                    upSql.append(" update " + tableName);
                    if (mapCompFn.get(diffrs.getString("ftargetcompanyid")) == null) continue;
                    upSql.append(" set " + mapCompFn.get(diffrs.getString("ftargetcompanyid")));
                    if (diffrs.getString("ftargetcompanyid") == null) {
                        upSql.append(" = 0 ");
                    } else {
                        upSql.append(" = " + diffrs.getBigDecimal(mapCompFn.get(diffrs.getString("ftargetcompanyid")).toString()));
                    }
                    upSql.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"188_EliminationEntryCheckFacadeControllerBean", (Locale)ctx.getOriginLocale()));
                    upSql.append(", FsortColumn='").append(diffrs.getString("FTemplateNumber")).append("' ");
                    upSql.append(" where ftemplateid='").append(diffrs.getString("ftemplateid")).append("' ");
                    upSql.append(" and FOffsetContents is null\t\t\t");
                    upSql.append(" and FOffsetContentsId is null\t\t");
                    upSql.append(" and  FOffsetItem is null \t\t\t");
                    upSql.append(" and FOffsetItemId is null \t\t\t");
                    upSql.append(" and FPeckType is null \t\t\t\t");
                    upSql.append(" and FPeckTypeId is null \t\t\t\t");
                    DbUtil.execute((Context)ctx, (String)upSql.toString());
                }
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private void insertTemplateNumberToTable(Context ctx, String tableName) throws BOSException {
        StringBuffer indiffSql = new StringBuffer();
        indiffSql.append("insert into " + tableName);
        indiffSql.append(" (FTemplateId)\t\t\t\t\t");
        indiffSql.append(" select distinct (ftemplateid) \t");
        indiffSql.append(" from " + tableName);
        indiffSql.append(" where ftemplateid is not NULL \t");
        indiffSql.append(" and ftemplateid != ' '");
        if (!tableName.equals("temporaryTable")) {
            DbUtil.execute((Context)ctx, (String)indiffSql.toString());
        }
    }

    private IRowSet queryTheOnLoanData(Context ctx, Map mapCompFn, String tableName) throws BOSException {
        String key;
        StringBuffer diffSql = new StringBuffer();
        diffSql.append(" select tb2.ftemplatenumber, \t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        Iterator it = mapCompFn.keySet().iterator();
        while (it.hasNext()) {
            key = String.valueOf(it.next());
            diffSql.append(" (isnull(tb1.").append(mapCompFn.get(key)).append(",0)-isnull(tb2.").append(mapCompFn.get(key)).append(",0)) as ").append(mapCompFn.get(key)).append(",");
        }
        diffSql.append(" tb1.ftargetcompanyid,tb1.ftemplateid as ftemplateid\t\t\t\t\t\t\r\n");
        diffSql.append(" from \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        diffSql.append(" (select ftemplatenumber,ftemplateid,foffsetcontents,ftargetcompanyid, \t\t\r\n");
        it = mapCompFn.keySet().iterator();
        while (it.hasNext()) {
            key = String.valueOf(it.next());
            diffSql.append(" sum(").append(mapCompFn.get(key)).append(") as ").append(mapCompFn.get(key)).append(",");
        }
        diffSql.append(" fdc ");
        diffSql.append(" from " + tableName);
        diffSql.append(" where fdc = 1 ");
        diffSql.append(" group by ftemplatenumber,ftemplateid,ftargetcompanyid,foffsetcontents,fdc ) ");
        diffSql.append("  as tb1 ");
        diffSql.append(" full outer join ");
        diffSql.append(" (select ftemplatenumber,foffsetcontents,  \t");
        it = mapCompFn.keySet().iterator();
        while (it.hasNext()) {
            key = String.valueOf(it.next());
            diffSql.append(" sum(").append(mapCompFn.get(key)).append(") as ").append(mapCompFn.get(key)).append(",");
        }
        diffSql.append(" fdc ");
        diffSql.append(" from " + tableName);
        diffSql.append(" where fdc = 2 ");
        diffSql.append(" group by ftemplatenumber,foffsetcontents,fdc ) ");
        diffSql.append("  as tb2 ");
        diffSql.append(" on tb1.ftemplatenumber = tb2.ftemplatenumber \t");
        IRowSet diffrs = null;
        if (!tableName.equals("temporaryTable")) {
            diffrs = DbUtil.executeQuery((Context)ctx, (String)diffSql.toString());
        }
        return diffrs;
    }

    private void costructUpdateTable(Context ctx, Map mapCompFn, Map mapIdMoney, String tableName, IRowSet sel_rs) throws BOSException, SQLDataException {
        try {
            if (sel_rs != null) {
                while (sel_rs.next()) {
                    String key = sel_rs.getInt("fdc") + "!" + sel_rs.getString(1) + "!" + sel_rs.getString(2) + "!" + sel_rs.getString(3) + "!" + sel_rs.getString(4);
                    int fdc = sel_rs.getInt("fdc");
                    StringBuffer updateSql = new StringBuffer();
                    if (sel_rs.getString(5) == null || sel_rs.getString(1) == null || sel_rs.getString(2) == null || sel_rs.getString(3) == null || sel_rs.getString(4) == null || sel_rs.getString(5) == null) continue;
                    updateSql.append(" update " + tableName);
                    updateSql.append(" set " + mapCompFn.get(sel_rs.getString(5)));
                    updateSql.append("=" + mapIdMoney.get(key + "!" + sel_rs.getString(5)));
                    updateSql.append(" where ");
                    updateSql.append(" FTemplateId='" + sel_rs.getString(1) + "'");
                    updateSql.append(" and FOffsetContentsId='" + sel_rs.getString(2) + "'");
                    updateSql.append(" and FOffsetItemId='" + sel_rs.getString(3) + "'");
                    updateSql.append(" and FPeckTypeId='" + sel_rs.getString(4) + "'");
                    updateSql.append(" and FtargetCompanyId='" + sel_rs.getString(5) + "'");
                    updateSql.append(" and Fdc=" + fdc);
                    DbUtil.execute((Context)ctx, (String)updateSql.toString());
                }
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private IRowSet getIdsFromTable(Context ctx, String tableName, IRowSet sel_rs) throws BOSException {
        StringBuffer selSql = new StringBuffer();
        selSql.append(" select ");
        selSql.append(" FTemplateId,FOffsetContentsId,FOffsetItemId,FPeckTypeId,FtargetCompanyId,fdc ");
        selSql.append(" from " + tableName);
        if (!tableName.equals("temporaryTable")) {
            sel_rs = DbUtil.executeQuery((Context)ctx, (String)selSql.toString());
        }
        return sel_rs;
    }

    private void updateCompanyDataToTable(Context ctx, int year, int period, int periodType, String currencyId, String orgBoundId, String orgUnitId, List templateIDs, Map mapIdMoney, Map mapFdc) throws BOSException, SQLDataException {
        IRowSet value = null;
        value = this.queryCompanyData(ctx, year, period, periodType, currencyId, orgBoundId, orgUnitId, templateIDs);
        try {
            while (value.next()) {
                String key = value.getInt("fdc") + "!" + value.getString("templateid") + "!" + value.getString("OffsetContentsId") + "!" + value.getString("ItemID") + "!" + value.getString("PeckTypeID") + "!" + value.getString("TargetCompanyID");
                BigDecimal mValue = value.getBigDecimal("money");
                mapIdMoney.put(key, mValue);
                mapFdc.put(key.toString() + mValue.toString(), value.getString("fdc"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private IRowSet queryCompanyData(Context ctx, int year, int period, int periodType, String currencyId, String orgBoundId, String orgUnitId, List templateIDs) throws BOSException {
        StringBuffer mapSql = new StringBuffer();
        mapSql.append(" select                                           \t\r\n");
        mapSql.append(" t1.ftempletid as templateId,     \r\n");
        mapSql.append(" t4.fid as OffsetContentsId,     \t\r\n");
        mapSql.append(" t3.fid as ItemID, \t\t\t\t\t\r\n");
        mapSql.append(" t5.fid as PeckTypeID, \t\t\t\t\t\t\t\t\r\n");
        mapSql.append(" t6.fid as TargetCompanyID,\t\t\t\t\t\t\r\n");
        mapSql.append(" case when t7.fdctype=1 then sum(isnull(fdebit,0)-isnull(fcredit,0)) ");
        mapSql.append(" else sum(isnull(fcredit,0)-isnull(fdebit,0)) end ");
        mapSql.append(" as money ,\t\t\t\r\n");
        mapSql.append(" t7.fdctype as fdc\t\t\t\t\t\t\t\t\t\r\n");
        mapSql.append(" from  t_csl_investtemplet t4   \r\n");
        mapSql.append(" join t_csl_investtempletEntry t7 on t4.fid=t7.ftempletid\r\n");
        mapSql.append(" join t_csl_elimination t1  on t1.ftempletid=t4.fid\r\n");
        mapSql.append(" left join T_CSL_EliminationEntry t2 on t1.fid=t2.feliminationid  and t7.fitemid=t2.fitemid \r\n");
        mapSql.append(" and t7.fdataelement=t2.fdataelement \r\n");
        mapSql.append(" join t_csl_rptitem t3 on t7.fitemid=t3.fid                  \t\t\t\t\t\t\t\r\n");
        mapSql.append(" join t_csl_dataelement t5 on t7.FDATAELEMENT=t5.finterseq      \t\t\t\t\t\t\t\r\n");
        mapSql.append(" left join t_org_baseunit t6 on t2.ftargetcompanyid=t6.fid                    \t\r\n");
        mapSql.append(" where t1.felimtype=7                        \t\t\t\t\t\t\t\t\t\t\t\r\n");
        if (templateIDs.size() > 0) {
            mapSql.append(" and t1.ftempletid in (");
            for (int i = 0; i < templateIDs.size(); ++i) {
                mapSql.append("'").append(templateIDs.get(i)).append("'");
                if (i == templateIDs.size() - 1) continue;
                mapSql.append(",");
            }
            mapSql.append(") ");
        }
        mapSql.append(" and forgboundid='").append(orgBoundId).append("' \t\t\t\t\t\t\t\t\t\t\r\n");
        mapSql.append("  and forgunit='").append(orgUnitId).append("'               \t\t\t\t\t\t\t\r\n");
        mapSql.append(" and fyear=").append(year);
        mapSql.append(" and fperiod=").append(period);
        mapSql.append(" and fperiodtype=").append(periodType);
        mapSql.append(" and FCurrencyID='").append(currencyId).append("'");
        mapSql.append(" group by t1.ftempletid, t2.fitemid,           \t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        mapSql.append(" t2.ftargetcompanyid,t3.fid,t4.fid,     \t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        mapSql.append(" t5.fid,t6.fid,t7.fdctype \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        IRowSet value = DbUtil.executeQuery((Context)ctx, (String)mapSql.toString());
        return value;
    }

    private void insertDataToTable(Context ctx, int year, int period, int periodType, String currencyId, String orgBoundId, String orgUnitId, List templateIDs, String tableName) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tableName);
        sql.append(" (FsortColumn,\t\t");
        sql.append(" FTemplateNumber,\t");
        sql.append(" FTemplateId,\t\t");
        sql.append(" FOffsetContents,\t");
        sql.append(" FOffsetContentsId,\t");
        sql.append(" FOffsetItem,\t\t");
        sql.append(" FOffsetItemId,\t\t");
        sql.append(" FPeckType,\t\t\t");
        sql.append(" FPeckTypeId,\t   \t");
        sql.append(" Fdc,\t\t\t   \t");
        sql.append(" FTargetCompanyID)\t");
        sql.append(" select                                             \r\n");
        sql.append(" t4.fnumber as templateNumber,      \t\t\t\t\r\n");
        sql.append(" t4.fnumber as templateNumber,      \t\t\t\t\r\n");
        sql.append(" t1.ftempletid as templateId,                 \t\t\t\t\r\n");
        sql.append(" t4.fname as OffsetContents,                 \t\t\r\n");
        sql.append(" t4.fid as OffsetContentsId,     \t\t\t\t\t\r\n");
        sql.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"189_EliminationEntryCheckFacadeControllerBean", (Locale)ctx.getOriginLocale()));
        sql.append(" ");
        sql.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"190_EliminationEntryCheckFacadeControllerBean", (Locale)ctx.getOriginLocale()));
        sql.append("\r\n");
        sql.append(" t3.fid as ItemID, \t\t\t\t\t\t\t\t\t\r\n");
        sql.append(" t5.fname_" + ctx.getLocale() + " as PeckType,  \t\t\t\t\t\t\t\r\n");
        sql.append(" t5.fid as PeckTypeID, \t\t\t\t\t\t\t\t\r\n");
        sql.append(" t7.fdctype as fdc,\t\t\t\t\t\t\t\t\t\r\n");
        sql.append(" t6.fid as TargetCompanyID \t\t\t\t\t\t\t\r\n");
        sql.append(" from  t_csl_investtemplet t4   \r\n");
        sql.append(" join t_csl_investtempletEntry t7 on t4.fid=t7.ftempletid\r\n");
        sql.append(" join t_csl_elimination t1  on t1.ftempletid=t4.fid\r\n");
        sql.append(" left join t_csl_eliminationentry t2 on t1.fid=t2.feliminationid  and t7.fitemid=t2.fitemid \r\n");
        sql.append(" and t7.fdataelement=t2.fdataelement \r\n");
        sql.append(" join t_csl_rptitem t3 on t7.fitemid=t3.fid                  \t\t\t\t\t\t\t\r\n");
        sql.append(" join t_csl_dataelement t5 on t7.FDATAELEMENT=t5.finterseq      \t\t\t\t\t\t\t\r\n");
        sql.append(" left join t_org_baseunit t6 on t2.ftargetcompanyid=t6.fid                    \t\r\n");
        sql.append(" where t1.felimtype=7                        \t\t\t\t\t\t\t\t\t\t\t\r\n");
        if (templateIDs.size() > 0) {
            sql.append(" and t1.ftempletid in(");
            for (int i = 0; i < templateIDs.size(); ++i) {
                sql.append("'").append(templateIDs.get(i)).append("'");
                if (i == templateIDs.size() - 1) continue;
                sql.append(",");
            }
            sql.append(") ");
        }
        sql.append(" and forgboundid='").append(orgBoundId).append("' \t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("  and forgunit='").append(orgUnitId).append("'               \t\t\t\t\t\t\t\r\n");
        sql.append(" and fyear=").append(year);
        sql.append(" and fperiod=").append(period);
        sql.append(" and fperiodtype=").append(periodType);
        sql.append(" and FCurrencyID='").append(currencyId).append("' ");
        sql.append(" group by t4.fnumber,t1.ftempletid, t2.fitemid,t2.fdataelement,           \t\t\t\t\t\t\r\n");
        sql.append(" t2.ftargetcompanyid,t3.fname_" + ctx.getLocale() + ",t3.fid,t4.fname,t4.fid,     \t\t\t\t\t\t\t\r\n");
        sql.append(" t5.fname_" + ctx.getLocale() + ",t5.fid,t6.fid,t7.fdctype \t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        if (!tableName.equals("temporaryTable")) {
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    private void insertInvestData(Context ctx, String currencyId, Map mapCompFn, String tableName, List listInvest, List listcompanyid) throws BOSException, SQLDataException {
        StringBuffer strItem = new StringBuffer();
        BigDecimal count = new BigDecimal(0);
        String thrID = null;
        for (int i = 0; i < listInvest.size(); ++i) {
            strItem.append(" select sum(FSumInvestAmout),ftargetcompanyid ");
            strItem.append(" from t_csl_investday ");
            strItem.append(" where ftargetcompanyid ='").append(listInvest.get(i)).append("' ");
            strItem.append(" and fcompanyid ='").append(listInvest.get(++i)).append("' ");
            strItem.append(" and fchangedate ={ts '").append(listInvest.get(++i)).append("'} ");
            strItem.append(" and fcompanyid in (");
            for (int j = 0; j < listcompanyid.size(); ++j) {
                strItem.append("'").append(listcompanyid.get(j)).append("'");
                if (j == listcompanyid.size() - 1) continue;
                strItem.append(",");
            }
            strItem.append(")");
            strItem.append(" and fcurrencyid='").append(currencyId).append("' ");
            strItem.append(" group by ftargetcompanyid ");
            IRowSet rs_inv = DbUtil.executeQuery((Context)ctx, (String)strItem.toString());
            strItem.delete(0, strItem.length());
            try {
                while (rs_inv.next()) {
                    StringBuffer strval = new StringBuffer();
                    strval.append(" update " + tableName);
                    strval.append(" set " + mapCompFn.get(rs_inv.getString(2)));
                    if (thrID == null || thrID.equals(rs_inv.getString(2))) {
                        count = count.add(rs_inv.getBigDecimal(1));
                    } else {
                        count = new BigDecimal(0);
                        count = count.add(rs_inv.getBigDecimal(1));
                    }
                    thrID = rs_inv.getString(2);
                    strval.append("=" + count);
                    strval.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"191_EliminationEntryCheckFacadeControllerBean", (Locale)ctx.getOriginLocale()));
                    strval.append(" and ftemplateid=' '");
                    DbUtil.execute((Context)ctx, (String)strval.toString());
                }
                continue;
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
    }

    private IRowSet queryInvestData(Context ctx, int year, int period, int periodType, String orgBoundId, String orgUnitId, String rptDate, Map mapCompFn, String tableName) throws BOSException {
        StringBuffer investSql = new StringBuffer();
        investSql.append(" select ftargetcompanyid,fcompanyid,max(fchangedate) ");
        investSql.append(" from t_csl_investday  t1 ");
        investSql.append(" where \tfcompanyid in ");
        investSql.append(" (select fcompany from ");
        investSql.append(" (select distinct fcompany,ftargetcompany from T_CSL_ElimInvestRate  ");
        investSql.append(" where ftargetcompany in  (");
        Iterator it = mapCompFn.keySet().iterator();
        while (it.hasNext()) {
            investSql.append("'").append(it.next()).append("'");
            if (!it.hasNext()) continue;
            investSql.append(",");
        }
        investSql.append(")");
        investSql.append(" and FOrgBoundId='").append(orgBoundId).append("' ");
        investSql.append(" and forgunit='").append(orgUnitId).append("' ");
        investSql.append(" and fyear=").append(year);
        investSql.append(" and fperiod=").append(period);
        investSql.append(" and fperiodType=").append(periodType);
        investSql.append(") as t2) ");
        investSql.append(" and ftargetcompanyid in ");
        investSql.append(" (select ftargetcompany from ");
        investSql.append(" (select distinct fcompany,ftargetcompany from T_CSL_ElimInvestRate  ");
        investSql.append(" where ftargetcompany in (");
        it = mapCompFn.keySet().iterator();
        while (it.hasNext()) {
            investSql.append("'").append(it.next()).append("'");
            if (!it.hasNext()) continue;
            investSql.append(",");
        }
        investSql.append(")) as t3 ) ");
        investSql.append(" and fchangedate<={").append(rptDate).append("} ");
        investSql.append(" group by ftargetcompanyid,fcompanyid ");
        IRowSet rs_invest = null;
        if (!tableName.equals("temporaryTable")) {
            rs_invest = DbUtil.executeQuery((Context)ctx, (String)investSql.toString());
        }
        return rs_invest;
    }

    private String createTemporaryTable(Context ctx, int year, int period, int periodType, String currencyId, String orgBoundId, String orgUnitId, Map mapCompFn, String tableName) throws BOSException, SQLDataException {
        StringBuffer create = new StringBuffer();
        create.append("create table " + tableName);
        create.append(" (FsortColumn varchar(44),");
        create.append(" FTemplateNumber varchar(256),");
        create.append(" FTemplateId varchar(44) ,");
        create.append(" FOffsetContents nvarchar(510),");
        create.append(" FOffsetContentsId varchar(44),");
        create.append(" FOffsetItem nvarchar(510),");
        create.append(" FOffsetItemId varchar(44),");
        create.append(" FPeckType nvarchar(510),");
        create.append(" FPeckTypeId varchar(44),");
        create.append(" Fdc int,");
        create.append(" FtargetCompanyId varchar(44),");
        IRowSet rs_tc = null;
        rs_tc = this.getCompany(ctx, year, period, periodType, currencyId, orgBoundId, orgUnitId);
        if (rs_tc.size() == 0) {
            rs_tc = this.getCompanyFromBaseUnit(ctx, year, period, periodType, orgBoundId, orgUnitId);
        }
        int index = 1;
        try {
            while (rs_tc.next()) {
                if (index == 1) {
                    create.append(" F").append(index).append(" NUMERIC(21,6) default 0 \t\t");
                } else {
                    create.append(", F").append(index).append(" NUMERIC(21,6) default 0 \t");
                }
                mapCompFn.put(rs_tc.getString("FtargetCompanyId"), "F" + index);
                ++index;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        create.append(")");
        try {
            tableName = TempTablePool.getInstance((Context)ctx).createTempTable(create.toString());
        }
        catch (Exception e1) {
            logger.error((Object)"createTempTable_Exception", (Throwable)e1);
        }
        return tableName;
    }

    private IRowSet getCompanyFromBaseUnit(Context ctx, int year, int period, int periodType, String orgBoundId, String orgUnitId) throws BOSException {
        IRowSet rs_tc = null;
        StringBuffer sql = new StringBuffer();
        sql.append("  select distinct t.ftargetcompany as ftargetcompanyid,b.fname_" + ctx.getLocale() + ",b.fnumber from T_CSL_ElimInvestRate t ");
        sql.append(" inner join t_org_baseunit b on b.fid=t.ftargetcompany ");
        sql.append(" where FOrgBoundId='").append(orgBoundId).append("' ");
        sql.append(" and forgunit='").append(orgUnitId).append("' ");
        sql.append(" and fyear=").append(year);
        sql.append(" and fperiod=").append(period);
        sql.append(" and fperiodType=").append(periodType);
        sql.append(" order by b.fnumber asc ");
        rs_tc = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return rs_tc;
    }

    private IRowSet getCompany(Context ctx, int year, int period, int periodType, String currencyId, String orgBoundId, String orgUnitId) throws BOSException {
        StringBuffer sqltarCompany = new StringBuffer();
        sqltarCompany.append(" select  distinct t2.ftargetcompanyid ,b.fname_" + ctx.getLocale() + ", b.fnumber ");
        sqltarCompany.append(" from t_csl_elimination t1 join t_csl_eliminationentry t2 on t1.fid=t2.feliminationid ");
        sqltarCompany.append(" inner join t_org_baseunit b on b.fid=t2.ftargetcompanyid  ");
        sqltarCompany.append(" where t1.felimtype=7 ");
        sqltarCompany.append(" and forgboundid='").append(orgBoundId).append("' and forgunit='").append(orgUnitId).append("' ");
        sqltarCompany.append(" and fyear=").append(year).append(" and fperiod=").append(period);
        sqltarCompany.append(" and fperiodtype=").append(periodType);
        sqltarCompany.append(" and FCurrencyID='").append(currencyId).append("'");
        sqltarCompany.append(" order by b.fnumber asc ");
        IRowSet rs_tc = DbUtil.executeQuery((Context)ctx, (String)sqltarCompany.toString());
        return rs_tc;
    }

    private List getTemplateID(Context ctx, String templateId) throws BOSException, SQLDataException {
        String[] templateNumber;
        ArrayList<String> templateIDs = new ArrayList<String>();
        if (templateId != null && !templateId.equals("") && !templateId.equals("removeAll") && (templateNumber = templateId.split(",")).length != 0) {
            StringBuffer strID = new StringBuffer();
            strID.append(" select FID ");
            strID.append(" from T_CSL_InvestTemplet ");
            strID.append(" where FNumber in (");
            for (int i = 0; i < templateNumber.length; ++i) {
                strID.append("'").append(templateNumber[i]).append("'");
                if (i == templateNumber.length - 1) continue;
                strID.append(",");
            }
            strID.append(") ");
            IRowSet rs_temID = DbUtil.executeQuery((Context)ctx, (String)strID.toString());
            try {
                while (rs_temID.next()) {
                    templateIDs.add(rs_temID.getString("fid"));
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return templateIDs;
    }

    private void addDataToInvestElim(Context ctx, RptProperties params, String tableName, Map mapCompFn) throws SQLDataException, BOSException {
        String orgBoundId = params.getString("orgBoundId");
        String orgUnitId = params.getString("orgUnitId");
        int year = params.getInt("year");
        int period = params.getInt("period");
        int periodType = params.getInt("periodType");
        String currencyId = params.getString("currencyId");
        List listTarCom = this.getTargetCompany(ctx, orgBoundId, orgUnitId, year, period, periodType, currencyId, mapCompFn);
        String creditField = "fcredit";
        String debitField = "fdebit";
        int fundedInvestType = 1;
        int businessHonerType = 14;
        BigDecimal proportion = new BigDecimal(0);
        String tarID = null;
        String enumName = ResourceBase.getString((String)RESOURCE, (String)"labInvestDataProportion", (Locale)ctx.getOriginLocale());
        if (listTarCom != null && listTarCom.size() > 0) {
            int n = listTarCom.size();
            for (int i = 0; i < n; ++i) {
                BigDecimal fundedInvestValue = this.getDebitOrCreditValue(ctx, params, listTarCom.get(i).toString(), fundedInvestType, creditField);
                BigDecimal businessHonerValueDebit = this.getDebitOrCreditValue(ctx, params, listTarCom.get(i).toString(), businessHonerType, debitField);
                BigDecimal businessHonerValueCredit = this.getDebitOrCreditValue(ctx, params, listTarCom.get(i).toString(), businessHonerType, creditField);
                BigDecimal businessHonerValue = businessHonerValueDebit.add(businessHonerValueCredit.multiply(new BigDecimal(-1)));
                BigDecimal ownerEquitySumValue = this.getOwnerEquitySumValue(ctx, params, listTarCom.get(i).toString());
                if (ownerEquitySumValue.compareTo(new BigDecimal(0)) == 0) continue;
                BigDecimal proportionValue = fundedInvestValue.subtract(businessHonerValue).divide(ownerEquitySumValue, 4, 4).abs().multiply(new BigDecimal(100));
                this.updateFields(ctx, tableName, mapCompFn.get(listTarCom.get(i).toString()), tarID, listTarCom.get(i).toString(), proportion, proportionValue, enumName);
            }
        }
    }

    private void addDataToInvestIncoming(Context ctx, RptProperties params, String tableName, Map mapCompFn) throws SQLDataException, BOSException {
        String orgBoundId = params.getString("orgBoundId");
        String orgUnitId = params.getString("orgUnitId");
        int year = params.getInt("year");
        int period = params.getInt("period");
        int periodType = params.getInt("periodType");
        String currencyId = params.getString("currencyId");
        List listTarCom = this.getTargetCompany(ctx, orgBoundId, orgUnitId, year, period, periodType, currencyId, mapCompFn);
        String debitField = "fdebit";
        int investIncomeType = 9;
        int minpartnerProfitType = 13;
        BigDecimal incomeProportion = new BigDecimal(0);
        String tarID = null;
        String enumName = ResourceBase.getString((String)RESOURCE, (String)"labInvestIncomingProportion", (Locale)ctx.getOriginLocale());
        if (listTarCom != null && listTarCom.size() > 0) {
            int n = listTarCom.size();
            for (int i = 0; i < n; ++i) {
                BigDecimal minpartnerProfitValue;
                BigDecimal investIncomeValue = this.getDebitOrCreditValue(ctx, params, listTarCom.get(i).toString(), investIncomeType, debitField);
                if (investIncomeValue.add(minpartnerProfitValue = this.getDebitOrCreditValue(ctx, params, listTarCom.get(i).toString(), minpartnerProfitType, debitField)).compareTo(new BigDecimal(0)) == 0) continue;
                BigDecimal incomeProportionValue = investIncomeValue.divide(investIncomeValue.add(minpartnerProfitValue), 4, 4).abs().multiply(new BigDecimal(100));
                this.updateFields(ctx, tableName, mapCompFn.get(listTarCom.get(i).toString()), tarID, listTarCom.get(i).toString(), incomeProportion, incomeProportionValue, enumName);
            }
        }
    }

    private BigDecimal getOwnerEquitySumValue(Context ctx, RptProperties params, String targetCompany) throws BOSException {
        BigDecimal sumValue = new BigDecimal(0);
        StringBuffer strBuf = new StringBuffer();
        ArrayList judge = new ArrayList();
        int ownerEquitySumType = 20;
        strBuf.append("select fissumitem,fsumitemformula   \r\n");
        strBuf.append(" from t_csl_rptitem     \r\n");
        strBuf.append(" where fcontrol =").append(ownerEquitySumType);
        IRowSet rs_sumitem = DbUtil.executeQuery((Context)ctx, (String)strBuf.toString());
        try {
            while (rs_sumitem.next()) {
                if (!"1".equals(rs_sumitem.getString("fissumitem").toString().trim())) continue;
                String[] str = rs_sumitem.getString("fsumitemformula").toString().trim().split("\\+|\\-|\\*|\\/");
                int n = str.length;
                for (int i = 0; i < n; ++i) {
                    this.getItemFormula(judge, ctx, str[i]);
                }
            }
            if (judge != null && judge.size() > 0) {
                int l = judge.size();
                for (int k = 0; k < l; ++k) {
                    sumValue = sumValue.add(this.getSumDebit(ctx, judge.get(k).toString(), params, targetCompany));
                }
            } else {
                sumValue = new BigDecimal(0);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return sumValue;
    }

    private BigDecimal getSumDebit(Context ctx, String item, RptProperties params, String targetCompany) throws SQLDataException, BOSException {
        BigDecimal sumDebit = new BigDecimal(0);
        StringBuffer sumDebitItem = new StringBuffer();
        String orgBoundId = params.getString("orgBoundId");
        String orgUnitId = params.getString("orgUnitId");
        int year = params.getInt("year");
        int period = params.getInt("period");
        int periodType = params.getInt("periodType");
        String currencyId = params.getString("currencyId");
        sumDebitItem.append("select ");
        sumDebitItem.append(" ISNULL (sum(t1.fdebit),0)");
        sumDebitItem.append(" from T_CSL_Eliminationentry as t1        \r\n");
        sumDebitItem.append(" inner join T_CSL_Elimination as t2       \r\n");
        sumDebitItem.append(" on t1.feliminationid = t2.fid            \r\n");
        sumDebitItem.append(" inner join T_CSL_RptItem as t3           \r\n");
        sumDebitItem.append(" on t1.fitemid = t3.fid                   \r\n");
        sumDebitItem.append(" where t2.forgboundid ='").append(orgBoundId).append("'");
        sumDebitItem.append(" and t2.forgunit ='").append(orgUnitId).append("'");
        sumDebitItem.append(" and t2.fyear =").append(year);
        sumDebitItem.append(" and t2.fperiod =").append(period);
        sumDebitItem.append(" and t2.fperiodType =").append(periodType);
        sumDebitItem.append(" and t2.felimtype = 7");
        sumDebitItem.append(" and t2.fcurrencyid ='").append(currencyId).append("'");
        sumDebitItem.append(" and t2.finvestnewtype =").append(2);
        sumDebitItem.append(" and t1.ftargetcompanyid ='").append(targetCompany).append("'");
        sumDebitItem.append(" and t3.fnumber ='").append(item).append("'");
        IRowSet rs_debitValue = DbUtil.executeQuery((Context)ctx, (String)sumDebitItem.toString());
        try {
            if (rs_debitValue.next()) {
                sumDebit = sumDebit.add(rs_debitValue.getBigDecimal(1));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return sumDebit;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private void getItemFormula(List judge, Context ctx, String item) throws BOSException {
        if (item == null) return;
        if (item.length() <= 0) return;
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("select fissumitem,fsumitemformula   \r\n");
        strBuf.append(" from t_csl_rptitem     \r\n");
        strBuf.append(" where fnumber = '").append(item).append("'");
        IRowSet rs_sumitem = DbUtil.executeQuery((Context)ctx, (String)strBuf.toString());
        try {
            block2: while (rs_sumitem.next()) {
                if ("1".equals(rs_sumitem.getString("fissumitem").toString().trim())) {
                    String[] str = rs_sumitem.getString("fsumitemformula").toString().trim().split("\\+|\\-|\\*|\\/");
                    int i = 0;
                    int n = str.length;
                    while (true) {
                        if (i >= n) continue block2;
                        this.getItemFormula(judge, ctx, str[i]);
                        ++i;
                    }
                }
                if (!"0".equals(rs_sumitem.getString("fissumitem").toString().trim())) continue;
                judge.add(item);
            }
            return;
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private BigDecimal getDebitOrCreditValue(Context ctx, RptProperties params, String targetCompany, int valueType, String field) throws BOSException {
        StringBuffer valueItem = new StringBuffer();
        BigDecimal value = new BigDecimal(0);
        String orgBoundId = params.getString("orgBoundId");
        String orgUnitId = params.getString("orgUnitId");
        int year = params.getInt("year");
        int period = params.getInt("period");
        int periodType = params.getInt("periodType");
        String currencyId = params.getString("currencyId");
        valueItem.append("select ");
        valueItem.append(" ISNULL (sum(t1.").append(field).append("),0)");
        valueItem.append(" from T_CSL_Eliminationentry as t1        \r\n");
        valueItem.append(" inner join T_CSL_Elimination as t2       \r\n");
        valueItem.append(" on t1.feliminationid = t2.fid            \r\n");
        valueItem.append(" inner join T_CSL_RptItem as t3           \r\n");
        valueItem.append(" on t1.fitemid = t3.fid                   \r\n");
        valueItem.append(" where t2.forgboundid ='").append(orgBoundId).append("'");
        valueItem.append(" and t2.forgunit ='").append(orgUnitId).append("'");
        valueItem.append(" and t2.fyear =").append(year);
        valueItem.append(" and t2.fperiod =").append(period);
        valueItem.append(" and t2.fperiodType =").append(periodType);
        valueItem.append(" and t2.felimtype = 7");
        valueItem.append(" and t2.fcurrencyid ='").append(currencyId).append("'");
        valueItem.append(" and t2.finvestnewtype =").append(2);
        valueItem.append(" and t1.ftargetcompanyid ='").append(targetCompany).append("'");
        valueItem.append(" and t3.fcontrol=").append(valueType);
        IRowSet rs_value = DbUtil.executeQuery((Context)ctx, (String)valueItem.toString());
        try {
            if (rs_value.next()) {
                value = value.add(rs_value.getBigDecimal(1));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return value;
    }

    private void addDataToElimination(Context ctx, RptProperties params, String tableName, Map mapCompFn) throws BOSException, SQLDataException {
        StringBuffer elimItem = new StringBuffer();
        BigDecimal rate = new BigDecimal(0);
        String orgBoundId = params.getString("orgBoundId");
        String orgUnitId = params.getString("orgUnitId");
        int year = params.getInt("year");
        int period = params.getInt("period");
        int periodType = params.getInt("periodType");
        String enumName = ResourceBase.getString((String)RESOURCE, (String)"labElimDataProportion", (Locale)ctx.getOriginLocale());
        ArrayList listTarcom = new ArrayList();
        ArrayList listRate = new ArrayList();
        String temp = null;
        this.getTarCompanyFromElimInvestRate(ctx, mapCompFn, orgBoundId, orgUnitId, year, period, periodType, listTarcom);
        this.updateInvestRateData(ctx, tableName, mapCompFn, elimItem, rate, orgBoundId, orgUnitId, year, period, periodType, enumName, listTarcom, listRate, temp);
    }

    private void updateInvestRateData(Context ctx, String tableName, Map mapCompFn, StringBuffer elimItem, BigDecimal rate, String orgBoundId, String orgUnitId, int year, int period, int periodType, String enumName, List listTarcom, List listRate, String temp) throws BOSException, SQLDataException {
        IRowSet rs_elim = null;
        if (listTarcom != null && listTarcom.size() > 0) {
            try {
                int n = listTarcom.size();
                for (int i = 0; i < n; ++i) {
                    if (i % 2 != 0) continue;
                    rs_elim = this.getTheInvestRate(ctx, elimItem, orgBoundId, orgUnitId, year, period, periodType, listTarcom, i);
                    while (rs_elim.next()) {
                        listRate.add(rs_elim.getString(1));
                        temp = rs_elim.getString(2) == null || "".equals(rs_elim.getString(2)) ? "0" : rs_elim.getString(2);
                        listRate.add(temp);
                        StringBuffer strelim = new StringBuffer();
                        strelim.append(" update " + tableName);
                        strelim.append(" set " + mapCompFn.get(rs_elim.getString(1)));
                        int m = listRate.size();
                        for (int j = 0; j < m; ++j) {
                            if (j % 2 != 0 || !rs_elim.getString(1).toString().equals(listRate.get(j).toString())) continue;
                            rate = rate.add(new BigDecimal(listRate.get(j + 1).toString()));
                        }
                        strelim.append("=" + rate);
                        strelim.append(" where FTemplateNumber='" + enumName + "'");
                        strelim.append(" and ftemplateid=' '");
                        DbUtil.execute((Context)ctx, (String)strelim.toString());
                        rate = new BigDecimal(0);
                    }
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
    }

    private IRowSet getTheInvestRate(Context ctx, StringBuffer elimItem, String orgBoundId, String orgUnitId, int year, int period, int periodType, List listTarcom, int i) throws BOSException {
        elimItem.append("select ftargetcompany,frate");
        elimItem.append(" from t_csl_elimInvestRate ");
        elimItem.append(" where FOrgBoundId='").append(orgBoundId).append("' ");
        elimItem.append(" and forgunit='").append(orgUnitId).append("' ");
        elimItem.append(" and fyear=").append(year);
        elimItem.append(" and fperiod=").append(period);
        elimItem.append(" and fperiodType=").append(periodType);
        elimItem.append(" and fislatest = 1");
        elimItem.append(" and ftargetcompany ='");
        elimItem.append(listTarcom.get(i));
        elimItem.append("' ");
        elimItem.append(" and fcompany ='");
        elimItem.append(listTarcom.get(i + 1));
        elimItem.append("' ");
        IRowSet rs_elim = DbUtil.executeQuery((Context)ctx, (String)elimItem.toString());
        elimItem.delete(0, elimItem.length());
        return rs_elim;
    }

    private void getTarCompanyFromElimInvestRate(Context ctx, Map mapCompFn, String orgBoundId, String orgUnitId, int year, int period, int periodType, List listTarcom) throws BOSException, SQLDataException {
        StringBuffer tarItem = new StringBuffer();
        tarItem.append("select ftargetcompany,fcompany");
        tarItem.append(" from t_csl_elimInvestRate ");
        tarItem.append(" where FOrgBoundId='").append(orgBoundId).append("' ");
        tarItem.append(" and forgunit='").append(orgUnitId).append("' ");
        tarItem.append(" and fyear=").append(year);
        tarItem.append(" and fperiod=").append(period);
        tarItem.append(" and fperiodType=").append(periodType);
        tarItem.append(" and fislatest = 1");
        tarItem.append(" and ftemplate is not null");
        tarItem.append(" and ftargetcompany in  (");
        Iterator it = mapCompFn.keySet().iterator();
        while (it.hasNext()) {
            tarItem.append("'").append(it.next()).append("'");
            if (!it.hasNext()) continue;
            tarItem.append(",");
        }
        tarItem.append(")");
        tarItem.append("  and fcompany in ");
        tarItem.append(" (select distinct fcompany from T_CSL_ElimInvestRate  ");
        tarItem.append(" where ftargetcompany in  (");
        it = mapCompFn.keySet().iterator();
        while (it.hasNext()) {
            tarItem.append("'").append(it.next()).append("'");
            if (!it.hasNext()) continue;
            tarItem.append(",");
        }
        tarItem.append("))");
        IRowSet rs_tar = DbUtil.executeQuery((Context)ctx, (String)tarItem.toString());
        try {
            while (rs_tar.next()) {
                listTarcom.add(rs_tar.getString("ftargetcompany"));
                listTarcom.add(rs_tar.getString("fcompany"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private List getTargetCompany(Context ctx, String orgBoundId, String orgUnitId, int year, int period, int periodType, String currencyId, Map mapCompFn) throws BOSException, SQLDataException {
        ArrayList<String> listTarcom = new ArrayList<String>();
        StringBuffer tarItem = new StringBuffer();
        tarItem.append("select distinct ftargetcompany");
        tarItem.append(" from t_csl_elimInvestRate ");
        tarItem.append(" where FOrgBoundId='").append(orgBoundId).append("' ");
        tarItem.append(" and forgunit='").append(orgUnitId).append("' ");
        tarItem.append(" and fyear=").append(year);
        tarItem.append(" and fperiod=").append(period);
        tarItem.append(" and fperiodType=").append(periodType);
        tarItem.append(" and fislatest = 1");
        tarItem.append(" and ftargetcompany in  (");
        Iterator it = mapCompFn.keySet().iterator();
        while (it.hasNext()) {
            tarItem.append("'").append(it.next()).append("'");
            if (!it.hasNext()) continue;
            tarItem.append(",");
        }
        tarItem.append(")");
        IRowSet rs_tar = DbUtil.executeQuery((Context)ctx, (String)tarItem.toString());
        try {
            while (rs_tar.next()) {
                listTarcom.add(rs_tar.getString("ftargetcompany"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return listTarcom;
    }

    private void updateFields(Context ctx, String tableName, Object field, String tarID, String targetCompany, BigDecimal rate, BigDecimal result, String enumName) throws BOSException {
        StringBuffer strelim = new StringBuffer();
        strelim.append(" update " + tableName);
        strelim.append(" set " + field);
        if (tarID == null || tarID.equals(targetCompany)) {
            rate = rate.add(result);
        } else {
            rate = new BigDecimal(0);
            rate = rate.add(result);
        }
        strelim.append("=" + rate);
        strelim.append(" where FTemplateNumber='" + enumName + "'");
        strelim.append(" and ftemplateid=' '");
        DbUtil.execute((Context)ctx, (String)strelim.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertNewRecord(Context ctx, String tableName) throws SQLException {
        boolean flag = false;
        ArrayList<String> list = new ArrayList<String>();
        list.add(ResourceBase.getString((String)RESOURCE, (String)"labInvestDay", (Locale)ctx.getOriginLocale()));
        list.add(ResourceBase.getString((String)RESOURCE, (String)"labElimDataProportion", (Locale)ctx.getOriginLocale()));
        list.add(ResourceBase.getString((String)RESOURCE, (String)"labInvestDataProportion", (Locale)ctx.getOriginLocale()));
        list.add(ResourceBase.getString((String)RESOURCE, (String)"labInvestIncomingProportion", (Locale)ctx.getOriginLocale()));
        String sqltemp = "insert into " + tableName + " (FsortColumn,FTemplateNumber,ftemplateid) values (?,?,?)";
        Connection conn = null;
        Statement ps = null;
        try {
            conn = DBUtils.getConnection((Context)ctx);
            ps = conn.prepareStatement(sqltemp);
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                ps.setString(1, "-0000000000" + String.valueOf(i + 1));
                ps.setString(2, list.get(i).toString().trim());
                ps.setString(3, " ");
                ps.addBatch();
                flag = true;
            }
            if (!tableName.equals("temporaryTable") && flag) {
                ps.executeBatch();
            }
        }
        catch (SQLException e) {
            logger.error((Object)"getConnection_SQLException", (Throwable)e);
        }
        finally {
            if (ps != null) {
                ps.clearBatch();
                ps.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Override
    protected void _releaseTempTable(Context ctx, String tableName) throws BOSException {
        this._dropTable(ctx, tableName);
    }

    @Override
    protected RptRowSet _queryEliminationEntryCheck(Context ctx, String tableName, int fromIndex, int length, boolean showZeroDiff, RptProperties params) throws BOSException {
        int i;
        StringBuffer sql = new StringBuffer();
        IRowSet dyrs = this.getDynamicCompany(ctx, params);
        sql.append(" select FTemplateNumber,FOffsetContents, FOffsetItem,FPeckType ");
        for (i = 1; i <= dyrs.size(); ++i) {
            sql.append(" ,f" + i);
        }
        sql.append(" from (");
        sql.append("select FTemplateNumber,FOffsetContents,  ");
        sql.append("FOffsetItem,FPeckType,FsortColumn,fdc ");
        params.setString("tableName", tableName);
        for (i = 1; i <= dyrs.size(); ++i) {
            sql.append(",sum(f" + i).append(") as f" + i);
        }
        sql.append(" from " + tableName);
        sql.append("  group by  FTemplateNumber,FOffsetContents,  FOffsetItem,FPeckType,FsortColumn,fdc) as t2 ");
        sql.append(" order by FsortColumn,ftemplatenumber,fdc");
        RptRowSet rst = null;
        Connection con = null;
        try {
            con = this.getConnection(ctx);
            if (!tableName.equals("temporaryTable")) {
                rst = DBUtil.executeQuery((String)sql.toString(), null, (int)fromIndex, (int)length, (Connection)con);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
        if (fromIndex > 0) {
            return rst;
        }
        return rst;
    }

    @Override
    protected IRowSet _getDynamicCompany(Context ctx, RptProperties params) throws BOSException {
        int year = params.getInt("year");
        int period = params.getInt("period");
        int periodType = params.getInt("periodType");
        String currencyId = params.getString("currencyId");
        String orgBoundId = params.getString("orgBoundId");
        String orgUnitId = params.getString("orgUnitId");
        IRowSet rs = null;
        IRowSet rsv = null;
        rs = this.getTarCompanyFromElimination(ctx, year, period, periodType, currencyId, orgBoundId, orgUnitId);
        if (rs.size() == 0) {
            rsv = this.getTarCompanyFromBaseUnit(ctx, year, period, periodType, orgBoundId, orgUnitId);
            return rsv;
        }
        return rs;
    }

    private IRowSet getTarCompanyFromBaseUnit(Context ctx, int year, int period, int periodType, String orgBoundId, String orgUnitId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("  select distinct t1.ftargetcompany as companyid,t2.fname_" + ctx.getLocale() + " as companyName ,t2.fnumber from T_CSL_ElimInvestRate t1 ");
        sql.append(" inner join t_org_baseunit t2 on t2.fid = t1.ftargetcompany ");
        sql.append(" where FOrgBoundId='").append(orgBoundId).append("' ");
        sql.append(" and forgunit='").append(orgUnitId).append("' ");
        sql.append(" and fyear=").append(year);
        sql.append(" and fperiod=").append(period);
        sql.append(" and fperiodType=").append(periodType);
        sql.append(" order by t2.fnumber asc ");
        IRowSet rsv = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return rsv;
    }

    private IRowSet getTarCompanyFromElimination(Context ctx, int year, int period, int periodType, String currencyId, String orgBoundId, String orgUnitId) throws BOSException {
        StringBuffer sqltarCompany = new StringBuffer();
        sqltarCompany.append(" select  distinct t2.ftargetcompanyid as companyId,b.fname_" + ctx.getLocale() + " as companyName, b.fnumber ");
        sqltarCompany.append(" from t_csl_elimination t1 join t_csl_eliminationentry t2 on t1.fid=t2.feliminationid ");
        sqltarCompany.append(" inner join t_org_baseunit b on b.fid=t2.ftargetcompanyid  ");
        sqltarCompany.append(" where t1.felimtype=7 ");
        sqltarCompany.append(" and forgboundid='").append(orgBoundId).append("' and forgunit='").append(orgUnitId).append("' ");
        sqltarCompany.append(" and fyear=").append(year).append(" and fperiod=").append(period);
        sqltarCompany.append(" and fperiodtype=").append(periodType);
        sqltarCompany.append(" and FCurrencyID='").append(currencyId).append("' ");
        sqltarCompany.append(" order by b.fnumber asc ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqltarCompany.toString());
        return rs;
    }
}

