/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.ArchivedStatusEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectInfo;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.ElimDynaItemEntryFactory;
import com.kingdee.eas.fi.gr.cslrpt.ElimDynaItemEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.ElimTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.EliminationEntryCollection;
import com.kingdee.eas.fi.gr.cslrpt.EliminationEntryFactory;
import com.kingdee.eas.fi.gr.cslrpt.EliminationEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.EliminationFactory;
import com.kingdee.eas.fi.gr.cslrpt.EliminationInfo;
import com.kingdee.eas.fi.gr.cslrpt.EliminationModeInfo;
import com.kingdee.eas.fi.gr.cslrpt.IElimDynaItemEntry;
import com.kingdee.eas.fi.gr.cslrpt.IElimination;
import com.kingdee.eas.fi.gr.cslrpt.IEliminationEntry;
import com.kingdee.eas.fi.gr.cslrpt.IRPTItem;
import com.kingdee.eas.fi.gr.cslrpt.InvestNewAdjustElimTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.IsCitedByLaterEnum;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.ServerException;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.app.CSLServerHelper;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.DisplayTemplateTypeEnum;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateTypeInfo;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import com.kingdee.util.enums.IntEnum;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class EliminationImport
extends AbstractDataTransmission {
    private static final Logger logger = CoreUIObject.getLogger(EliminationImport.class);
    private static final String ELIMI_NUMBER = "FNUMBER";
    private static final String ELIMI_BIZDATE = "FBIZDATE";
    private static final String ELIMI_CURRENCY = "FCURRENCY";
    private static final String ELIMI_SOURCECURRENCY = "FSOURCECURRENCY";
    private static final String ELIMI_TYPE = "FELIMTYPE";
    private static final String ELIMI_DATASOURCE = "FDATASOURCE";
    private static final String ELIMI_VALUETYPE = "FVALUETYPE";
    private static final String ELIMI_TEMPLATETYPELONGNUMBER = "FTEMPLATETYPELONGNUMBER";
    private static final String ELIMI_REPORTTYPE = "FREPORTTYPE";
    private static final String ELIMI_ISCITEDBYLATER = "FISCITEDBYLATER";
    private static final String ELIMI_REMARK = "FREMARK";
    private static final String ELIMI_ENTRY_SUMMARY = "FSUMMARY";
    private static final String ELIMI_ENTRY_COMPANY = "FCOMPANY";
    private static final String ELIMI_ENTRY_TARGETCOMPANY = "FTARGETCOMPANY";
    private static final String ELIMI_ENTRY_INVCOMPANY = "FINVCOMPANY";
    private static final String ELIMI_ENTRY_ITEM = "FITEM";
    private static final String ELIMI_ENTRY_DATAELEMENT = "FDATAELEMENT";
    private static final String ELIMI_ENTRY_DEBIT = "FDEBIT";
    private static final String ELIMI_ENTRY_CREDIT = "FCREDIT";
    private static final String ELIMI_DYN_KEYNUMBER = "FKEYNUMBER";
    private static final String ELIMI_DYN_KEYLONGNUMBER = "FKEYLONGNUMBER";
    private static final String ELIMI_DYN_KEYNAME = "FKEYNAME";
    private static final String ELIMI_DYN_VALUE = "FVALUE";
    private static final String ELIMI_DYN_REMARK = "FDYNAREMARK";
    private static final String ELIMI_MODE_NAME = "FELIMINATIONMODE";
    private static final String ELIMI_CUSTOMNUMBER = "FCUSTOMNUMBER";
    private static final String ELIMI_DYN_ASSTACTTYPENUMBER = "FASSTACTTYPENUMBER";
    private static final String ELIMI_ENTRY_TYPE = "FINVESTNEWTYPE";
    private static final String KEY_FLAG = "kingdee_eas_rpt";
    private String companyKey;
    private OrgTreeInfo orgtree;
    private RptPeriodTypeEnum periodType;
    private int year;
    private int period;
    private Date rptdate;
    private OrgUnitInfo orgUnit;
    private Map cachedCompanyNumber = new HashMap();
    private Map cachedItemNumber = new HashMap();
    private Map cachedSourceCurrencyNumber = new HashMap();
    private Map cachedCurrencyNumber = new HashMap();
    private Map cachedEliminationModeName = new HashMap();
    private Map cachedTemplateType = new HashMap();
    private Map cachedElement = new HashMap();
    private Timestamp ts = new Timestamp(System.currentTimeMillis());
    private DataCollectInfo dataCollect;
    private boolean hasCodeRule = false;
    private IElimination iElimi = null;
    private IEliminationEntry iElimiEntry = null;
    private IElimDynaItemEntry iElimiDynamic = null;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        return null;
    }

    private void initParams(Context ctx) throws EASBizException, BOSException {
        if (this.orgtree != null) {
            return;
        }
        String orgtree_id = (String)this.getContextParameter().get("ORGTREE_ID");
        this.orgtree = OrgTreeFactory.getLocalInstance((Context)ctx).getOrgTreeInfo((IObjectPK)new ObjectUuidPK(orgtree_id));
        this.periodType = (RptPeriodTypeEnum)this.getContextParameter().get("PERIOD_TYPE");
        this.year = (Integer)this.getContextParameter().get("YEAR");
        this.period = (Integer)this.getContextParameter().get("PERIOD");
        this.rptdate = (Date)this.getContextParameter().get("DATE");
        this.orgUnit = (OrgUnitInfo)this.getContextParameter().get("ORGUNIT");
        if (this.orgUnit != null && StringUtils.isEmpty((String)this.orgUnit.getLongNumber())) {
            String orgUnitid = this.orgUnit.getId().toString();
            FullOrgUnitInfo fullOrgUnitInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo("select longNumber where id = '" + orgUnitid + "'");
            this.orgUnit.setLongNumber(fullOrgUnitInfo.getLongNumber());
        }
        this.dataCollect = (DataCollectInfo)this.getContextParameter().get("DATACOLLECT");
    }

    protected String getNumberByCodingRule(Hashtable hsData, Context ctx) {
        EliminationInfo caller = new EliminationInfo();
        caller.setOrgBound((OrgTreeInfo)ctx.get((Object)"KEY_ORGTREE_INFO"));
        caller.setOrgUnit((OrgUnitInfo)ctx.get((Object)OrgType.UnionDebt));
        String number = null;
        try {
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            number = this.hasCodeRule ? iCodingRuleManager.getNumber((IObjectValue)caller, CSLServerHelper.getRootOrgIDForRootCU(ctx)) : (String)((DataToken)((Hashtable)hsData.get((Object)new Integer((int)0))).get((Object)ELIMI_NUMBER)).data;
        }
        catch (Exception e) {
            logger.error((Object)"iCodingRuleManager.getNumber_Exception", (Throwable)e);
        }
        return number;
    }

    private void initCodeRule(Context ctx) throws EASBizException, BOSException {
        this.hasCodeRule = CSLServerHelper.isHasCodingRuleByOrg(ctx, (IObjectValue)new EliminationInfo(), CSLServerHelper.getRootOrgIDForRootCU(ctx));
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        String elimiCurrencyNumber;
        CurrencyInfo currencyInfo;
        try {
            this.initCodeRule(ctx);
            this.initParams(ctx);
        }
        catch (EASBizException e1) {
            throw new TaskExternalException(e1.getMessage());
        }
        catch (BOSException e1) {
            throw new TaskExternalException(e1.getMessage());
        }
        String elimiNumber = (String)((DataToken)((Hashtable)hsData.get((Object)new Integer((int)0))).get((Object)ELIMI_NUMBER)).data;
        if (StringUtils.isEmpty((String)elimiNumber)) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"192_EliminationImport", (Locale)ctx.getOriginLocale()));
        }
        String elimiBizdate = (String)((DataToken)((Hashtable)hsData.get((Object)new Integer((int)0))).get((Object)ELIMI_BIZDATE)).data;
        Date bizDate = null;
        if (!StringUtils.isEmpty((String)elimiBizdate)) {
            SimpleDateFormat sdf = new SimpleDateFormat();
            sdf.applyPattern("yyyy-MM-dd");
            try {
                bizDate = sdf.parse(elimiBizdate);
            }
            catch (Exception e) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"100_AdjustImport", (Locale)ctx.getOriginLocale()));
            }
        }
        if ((currencyInfo = this.getCurrencyInfo(ctx, elimiCurrencyNumber = (String)((DataToken)((Hashtable)hsData.get((Object)new Integer((int)0))).get((Object)ELIMI_CURRENCY)).data)) == null) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"107_AdjustImport", (Locale)ctx.getOriginLocale()));
        }
        String adjSourceCurrencyNumber = (String)((DataToken)((Hashtable)hsData.get((Object)new Integer((int)0))).get((Object)ELIMI_SOURCECURRENCY)).data;
        CurrencyInfo sourceCurrencyInfo = this.getSourceCurrencyInfo(ctx, adjSourceCurrencyNumber);
        if (sourceCurrencyInfo == null) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"108_AdjustImport", (Locale)ctx.getOriginLocale()));
        }
        String elimiTypeName = (String)((DataToken)((Hashtable)hsData.get((Object)new Integer((int)0))).get((Object)ELIMI_TYPE)).data;
        ElimTypeEnum elimiType = this.getElimiEnumByAlias(elimiTypeName, ctx.getOriginLocale());
        if (elimiType == null) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"193_EliminationImport", (Locale)ctx.getOriginLocale()));
        }
        String elimiDataSourceName = (String)((DataToken)((Hashtable)hsData.get((Object)new Integer((int)0))).get((Object)ELIMI_DATASOURCE)).data;
        RptSrcTypeEnum dataSource = this.getRptEnumByAlias(elimiDataSourceName, ctx.getOriginLocale());
        if (dataSource == null) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"194_EliminationImport", (Locale)ctx.getOriginLocale()));
        }
        String elimiValueTypeName = (String)((DataToken)((Hashtable)hsData.get((Object)new Integer((int)0))).get((Object)ELIMI_VALUETYPE)).data;
        ValueTypeEnum valueType = this.getValueEnumByAlias(elimiValueTypeName, ctx.getOriginLocale());
        if (valueType == null) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"195_EliminationImport", (Locale)ctx.getOriginLocale()));
        }
        String elimiTemplateTypeName = (String)((DataToken)((Hashtable)hsData.get((Object)new Integer((int)0))).get((Object)ELIMI_REPORTTYPE)).data;
        DisplayTemplateTypeEnum templateType = null;
        if (!(StringUtils.isEmpty((String)elimiTemplateTypeName) || (templateType = this.getTemplateTypeEnuByAlias(elimiTemplateTypeName, ctx.getOriginLocale())) != null && templateType.getValue() == 74)) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"196_EliminationImport", (Locale)ctx.getOriginLocale()));
        }
        String templateTypeLongNumber = (String)((DataToken)((Hashtable)hsData.get((Object)new Integer((int)0))).get((Object)ELIMI_TEMPLATETYPELONGNUMBER)).data;
        TemplateTypeInfo templateTypeInfo = null;
        if (templateType != null) {
            if (StringUtils.isEmpty((String)templateTypeLongNumber)) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"197_EliminationImport", (Locale)ctx.getOriginLocale()));
            }
            templateTypeInfo = this.getTemplateTypeInfo(ctx, templateTypeLongNumber, templateType);
            if (templateTypeInfo == null) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"198_EliminationImport", (Locale)ctx.getOriginLocale()));
            }
        } else if (!StringUtils.isEmpty((String)templateTypeLongNumber)) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"199_EliminationImport", (Locale)ctx.getOriginLocale()));
        }
        String elimiModeName = (String)((DataToken)((Hashtable)hsData.get((Object)new Integer((int)0))).get((Object)ELIMI_MODE_NAME)).data;
        EliminationModeInfo eliminationModeInfo = null;
        if (!StringUtils.isEmpty((String)elimiModeName) && (eliminationModeInfo = this.getEliminationModeInfo(ctx, elimiModeName)) == null) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"NO_Elimination_MOde", (Locale)ctx.getOriginLocale()));
        }
        String isCitedByLater = (String)((DataToken)((Hashtable)hsData.get((Object)new Integer((int)0))).get((Object)ELIMI_ISCITEDBYLATER)).data;
        boolean isCitedLater = RptUtil.isTrue((Object)isCitedByLater, (boolean)false);
        String HeadRemark = (String)((DataToken)((Hashtable)hsData.get((Object)new Integer((int)0))).get((Object)ELIMI_REMARK)).data;
        if (!StringUtils.isEmpty((String)HeadRemark) && HeadRemark.startsWith("=")) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.ElimiEntryCheckResource", (String)"remarkUnallowStartWithEqual-sign", (Locale)ctx.getLocale()));
        }
        String customNumber = (String)((DataToken)((Hashtable)hsData.get((Object)new Integer((int)0))).get((Object)ELIMI_CUSTOMNUMBER)).data;
        String entryType = (String)((DataToken)((Hashtable)hsData.get((Object)new Integer((int)0))).get((Object)ELIMI_ENTRY_TYPE)).data;
        InvestNewAdjustElimTypeEnum elimEntryType = this.getInvestEnumByAlias(entryType, ctx.getOriginLocale());
        EliminationInfo elimiInfo = new EliminationInfo();
        elimiInfo.setNumber(elimiNumber);
        elimiInfo.setYear(this.year);
        elimiInfo.setPeriod(this.period);
        elimiInfo.setDate(this.rptdate);
        elimiInfo.setPeriodType(this.periodType);
        elimiInfo.setOrgBound(this.orgtree);
        elimiInfo.setBizDate(bizDate == null ? new Date(this.ts.getTime()) : bizDate);
        elimiInfo.setCurrency(currencyInfo);
        elimiInfo.setSourceCurrency(sourceCurrencyInfo);
        elimiInfo.setElimType(elimiType);
        elimiInfo.setDataSource(dataSource);
        elimiInfo.setValueType(valueType);
        elimiInfo.setDisplayTemplateType(templateTypeInfo);
        elimiInfo.setIsCitedByLater(isCitedLater ? IsCitedByLaterEnum.ISTRUE : IsCitedByLaterEnum.ISFALSE);
        elimiInfo.setRemark(HeadRemark);
        elimiInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        elimiInfo.setArchivedStatus(ArchivedStatusEnum.UNARCHIVED);
        elimiInfo.setOrgUnit(this.orgUnit);
        elimiInfo.setCreateTime(this.ts);
        UserInfo uInfo = new UserInfo();
        uInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        elimiInfo.setCreator(uInfo);
        elimiInfo.setLastUpdateTime(this.ts);
        elimiInfo.setLastUpdateUser(uInfo);
        elimiInfo.setEliminationMode(eliminationModeInfo);
        if (this.dataCollect != null) {
            elimiInfo.setDataCollect(this.dataCollect);
            elimiInfo.setDataCollectNumber(this.dataCollect.getNumber());
        }
        elimiInfo.setCustomNumber(customNumber);
        elimiInfo.setInvestNewType(elimEntryType);
        String summary = null;
        String entryCompanyNumber = null;
        String targetCompanyNumber = null;
        String invCompanyNumber = null;
        String itemNumber = null;
        String dataElementNumber = null;
        String debitStr = null;
        String creditStr = null;
        String keynumber = null;
        String keyLongNumber = null;
        String keyName = null;
        String value = null;
        String remark = null;
        String asstActTypeNumber = null;
        HashMap<String, EliminationEntryInfo> entryMap = new HashMap<String, EliminationEntryInfo>();
        ArrayList<String> entryList = new ArrayList<String>();
        Hashtable entryData = null;
        for (int i = 0; i < hsData.size(); ++i) {
            String entryKey;
            entryData = (Hashtable)hsData.get(new Integer(i));
            summary = (String)((DataToken)entryData.get((Object)ELIMI_ENTRY_SUMMARY)).data;
            if (!StringUtils.isEmpty((String)summary) && summary.startsWith("=")) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.ElimiEntryCheckResource", (String)"summaryUnallowStartWithEqual-sign", (Locale)ctx.getLocale()));
            }
            entryCompanyNumber = (String)((DataToken)entryData.get((Object)ELIMI_ENTRY_COMPANY)).data;
            FullOrgUnitInfo entryOrgUnitInfo = this.getCompanyNumber(ctx, entryCompanyNumber);
            this.companyKey = entryOrgUnitInfo != null ? entryOrgUnitInfo.getNumber() : "null";
            targetCompanyNumber = (String)((DataToken)entryData.get((Object)ELIMI_ENTRY_TARGETCOMPANY)).data;
            FullOrgUnitInfo targetOrgUnitInfo = this.getCompanyNumber(ctx, targetCompanyNumber);
            invCompanyNumber = (String)((DataToken)entryData.get((Object)ELIMI_ENTRY_INVCOMPANY)).data;
            FullOrgUnitInfo invOrgUnitInfo = this.getCompanyNumber(ctx, invCompanyNumber);
            itemNumber = (String)((DataToken)entryData.get((Object)ELIMI_ENTRY_ITEM)).data;
            RPTItemInfo iteminfo = this.getItemByNumber(ctx, itemNumber);
            if (iteminfo == null) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"109_AdjustImport", (Locale)ctx.getOriginLocale()));
            }
            dataElementNumber = (String)((DataToken)entryData.get((Object)ELIMI_ENTRY_DATAELEMENT)).data;
            DataElementInfo dataElementInfo = this.getDataElementInfo(ctx, dataElementNumber);
            if (dataElementInfo == null) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"110_AdjustImport", (Locale)ctx.getOriginLocale()));
            }
            debitStr = (String)((DataToken)entryData.get((Object)ELIMI_ENTRY_DEBIT)).data;
            BigDecimal debitValue = null;
            try {
                if (!StringUtils.isEmpty((String)debitStr)) {
                    debitValue = new BigDecimal(debitStr);
                }
            }
            catch (Exception e) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"111_AdjustImport", (Locale)ctx.getOriginLocale()));
            }
            creditStr = (String)((DataToken)entryData.get((Object)ELIMI_ENTRY_CREDIT)).data;
            BigDecimal creditValue = null;
            try {
                if (!StringUtils.isEmpty((String)creditStr)) {
                    creditValue = new BigDecimal(creditStr);
                }
            }
            catch (Exception e) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"112_AdjustImport", (Locale)ctx.getOriginLocale()));
            }
            if (debitValue == null && creditValue == null) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"113_AdjustImport", (Locale)ctx.getOriginLocale()));
            }
            if (debitValue != null && creditValue != null) {
                if (debitValue.compareTo(new BigDecimal(0.0)) == 0 && creditValue.compareTo(new BigDecimal(0.0)) == 0) {
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"114_AdjustImport", (Locale)ctx.getOriginLocale()));
                }
                if (debitValue.compareTo(new BigDecimal(0.0)) != 0 && creditValue.compareTo(new BigDecimal(0.0)) != 0) {
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"115_AdjustImport", (Locale)ctx.getOriginLocale()));
                }
            }
            EliminationEntryInfo elimiEntryInfo = new EliminationEntryInfo();
            elimiEntryInfo.setElimination(elimiInfo);
            String ElimRelevanceSummary = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.ElimUIMsg", (String)"Elim_Relevance_Summary", (Locale)ctx.getOriginLocale());
            if (summary.indexOf(ElimRelevanceSummary) != -1) {
                elimiEntryInfo.setSummary(ElimRelevanceSummary.substring(0, ElimRelevanceSummary.length() - 1));
                elimiEntryInfo.setSummaryExtend(summary.substring(9, summary.length()));
            } else {
                elimiEntryInfo.setSummary(summary);
            }
            int precision = currencyInfo.getPrecision();
            if (creditValue != null) {
                creditValue = creditValue.setScale(precision, 4);
            }
            if (debitValue != null) {
                debitValue = debitValue.setScale(precision, 4);
            }
            elimiEntryInfo.setCompany(entryOrgUnitInfo);
            elimiEntryInfo.setTargetCompany(targetOrgUnitInfo);
            elimiEntryInfo.setInvCompany(invOrgUnitInfo);
            elimiEntryInfo.setCompany(entryOrgUnitInfo);
            elimiEntryInfo.setItem(iteminfo);
            elimiEntryInfo.setCredit(creditValue);
            elimiEntryInfo.setDebit(debitValue);
            elimiEntryInfo.setDataElement(dataElementInfo.getInterSeq());
            if (summary.equals(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.ElimUIMsg", (String)"Elim_Auto_Summary", (Locale)ctx.getOriginLocale()))) {
                elimiEntryInfo.setIsVisible(false);
            } else {
                elimiEntryInfo.setIsVisible(true);
            }
            keyLongNumber = (String)((DataToken)entryData.get((Object)ELIMI_DYN_KEYLONGNUMBER)).data;
            keynumber = (String)((DataToken)entryData.get((Object)ELIMI_DYN_KEYNUMBER)).data;
            keyName = (String)((DataToken)entryData.get((Object)ELIMI_DYN_KEYNAME)).data;
            value = (String)((DataToken)entryData.get((Object)ELIMI_DYN_VALUE)).data;
            remark = (String)((DataToken)entryData.get((Object)ELIMI_DYN_REMARK)).data;
            asstActTypeNumber = (String)((DataToken)entryData.get((Object)ELIMI_DYN_ASSTACTTYPENUMBER)).data;
            BigDecimal bigValue = null;
            boolean isAllEmpty = false;
            if (StringUtils.isEmpty((String)keyLongNumber) && StringUtils.isEmpty((String)keynumber) && StringUtils.isEmpty((String)keyName) && StringUtils.isEmpty((String)value) && StringUtils.isEmpty((String)asstActTypeNumber)) {
                isAllEmpty = true;
            } else {
                if (StringUtils.isEmpty((String)keyLongNumber)) {
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"116_AdjustImport", (Locale)ctx.getOriginLocale()));
                }
                if (StringUtils.isEmpty((String)keynumber)) {
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"117_AdjustImport", (Locale)ctx.getOriginLocale()));
                }
                if (StringUtils.isEmpty((String)keyName)) {
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"118_AdjustImport", (Locale)ctx.getOriginLocale()));
                }
                try {
                    if (!StringUtils.isEmpty((String)value)) {
                        bigValue = new BigDecimal(value);
                    }
                }
                catch (Exception e) {
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"119_AdjustImport", (Locale)ctx.getOriginLocale()));
                }
            }
            ElimDynaItemEntryInfo elimiDynItemInfo = new ElimDynaItemEntryInfo();
            elimiDynItemInfo.setEliminationEntry(elimiEntryInfo);
            elimiDynItemInfo.setRptItem(iteminfo);
            elimiDynItemInfo.setKeyLongNumber(keyLongNumber);
            elimiDynItemInfo.setKeyNumber(keynumber);
            elimiDynItemInfo.setKeyName(keyName);
            elimiDynItemInfo.setValue(bigValue);
            elimiDynItemInfo.setAsstActTypeNumber(asstActTypeNumber);
            elimiDynItemInfo.setRemark(remark);
            String dynKey = KEY_FLAG + new Integer(i).toString();
            if (!isAllEmpty) {
                elimiEntryInfo.put(dynKey, elimiDynItemInfo);
            }
            if (entryMap.containsKey(entryKey = this.companyKey + elimiEntryInfo.getItem().getNumber() + new Integer(elimiEntryInfo.getDataElement()).toString())) {
                if (isAllEmpty) continue;
                EliminationEntryInfo entryInfo = (EliminationEntryInfo)entryMap.get(entryKey);
                entryInfo.put(dynKey, elimiDynItemInfo);
                entryMap.remove(entryKey);
                entryMap.put(entryKey, entryInfo);
                entryList.add(entryKey);
                continue;
            }
            entryMap.put(entryKey + i, elimiEntryInfo);
            entryList.add(entryKey + i);
        }
        Iterator iter = entryList.iterator();
        while (iter.hasNext()) {
            elimiInfo.getEntries().add((EliminationEntryInfo)entryMap.get(iter.next()));
        }
        return elimiInfo;
    }

    private TemplateTypeInfo getTemplateTypeInfo(Context ctx, String longNumber, DisplayTemplateTypeEnum templateType) throws TaskExternalException {
        if (this.cachedTemplateType.containsKey(longNumber + new Integer(templateType.getValue()).toString())) {
            return (TemplateTypeInfo)this.cachedTemplateType.get(longNumber + new Integer(templateType.getValue()).toString());
        }
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("select distinct b.FId");
            sql.append(" from t_org_structure s join t_org_tree t");
            sql.append(" on s.FTreeId = t.FId");
            sql.append(" join t_org_baseunit b on s.FUnitId = b.FId");
            sql.append(" where t.FNumber = ? and b.FNumber = ?");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{this.orgtree.getNumber(), this.orgUnit.getNumber()});
            StringBuffer buf = new StringBuffer();
            boolean isFirst = true;
            while (rowSet.next()) {
                String id = rowSet.getString("FId");
                if (!isFirst) {
                    buf.append(",");
                } else {
                    isFirst = false;
                }
                buf.append("'").append(id).append("'");
            }
            sql = new StringBuffer();
            sql.append("select fid, flongnumber, FReportType");
            sql.append(" from T_RPT_TemplateType where flongnumber = ? and FReportType = ?");
            sql.append(" and FOrgUnitId in (").append(buf.toString()).append(")");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{longNumber, new Integer(templateType.getValue())});
            TemplateTypeInfo templateTypeInfo = null;
            if (rs != null && rs.next()) {
                templateTypeInfo = new TemplateTypeInfo();
                templateTypeInfo.setId(BOSUuid.read((String)rs.getString("fid")));
                templateTypeInfo.setLongNumber(rs.getString("flongnumber"));
                templateTypeInfo.setReportType(DisplayTemplateTypeEnum.getEnum((int)rs.getInt("FReportType")));
                this.cachedTemplateType.put(longNumber + new Integer(templateType.getValue()).toString(), templateTypeInfo);
            }
            return templateTypeInfo;
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    private FullOrgUnitInfo getCompanyNumber(Context ctx, String companyNumber) throws TaskExternalException {
        if (StringUtils.isEmpty((String)companyNumber)) {
            return null;
        }
        if (this.cachedCompanyNumber.containsKey(companyNumber)) {
            return (FullOrgUnitInfo)this.cachedCompanyNumber.get(companyNumber);
        }
        try {
            String sql = "select orgUnit.fid as orgUnitId, orgUnit.fnumber as orgUnitNumber, orgUnit.fIsCompanyOrgUnit as isCompanyOrgUnit \r\n, orgUnit.fname_" + ctx.getLocale() + " as orgUnitname from t_org_structure orgStruct left outer join T_ORG_BaseUnit orgUnit \r\non orgStruct.Funitid = orgUnit.Fid where orgStruct.Ftreeid = ? and orgUnit.Fnumber = ? and orgUnit.fIsCompanyOrgUnit=1 and charindex('" + this.orgUnit.getLongNumber() + "!',orgStruct.FLongNumber)=1";
            sql = this.orgtree.getLayerType().equals((Object)OrgViewType.PROFITCENTER) ? sql + " and orgUnit.fIsProfitOrgUnit=1" : sql + " and orgUnit.fIsCompanyOrgUnit=1";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{this.orgtree.getId().toString(), companyNumber});
            FullOrgUnitInfo orgUnitInfo = null;
            if (rs != null && rs.next()) {
                orgUnitInfo = new FullOrgUnitInfo();
                orgUnitInfo.setId(BOSUuid.read((String)rs.getString("orgUnitId")));
                orgUnitInfo.setNumber(rs.getString("orgUnitNumber"));
                orgUnitInfo.setName(rs.getString("orgUnitname"));
                orgUnitInfo.setIsCompanyOrgUnit(RptUtil.isTrue((Object)new Integer(rs.getInt("isCompanyOrgUnit")), (boolean)false));
                this.cachedCompanyNumber.put(companyNumber, orgUnitInfo);
            }
            return orgUnitInfo;
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public FullOrgUnitInfo getCompanyByID(Context ctx, String id) throws TaskExternalException {
        if (StringUtils.isEmpty((String)id)) {
            return null;
        }
        if (this.cachedCompanyNumber.containsKey(id)) {
            return (FullOrgUnitInfo)this.cachedCompanyNumber.get(id);
        }
        try {
            FullOrgUnitInfo o = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(id));
            this.cachedCompanyNumber.put(id, o);
            return o;
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    private EliminationModeInfo getEliminationModeInfo(Context ctx, String eliminationModeName) throws TaskExternalException {
        if (StringUtils.isEmpty((String)eliminationModeName)) {
            return null;
        }
        if (this.cachedEliminationModeName.containsKey(eliminationModeName)) {
            return (EliminationModeInfo)this.cachedEliminationModeName.get(eliminationModeName);
        }
        try {
            String sql = "select fid, FName_l2, FName_l1, FName_l3 from T_CSL_EliminationMode where (fName_l1 = ? or fName_l2 = ? or fName_l3 = ?)";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{eliminationModeName, eliminationModeName, eliminationModeName});
            EliminationModeInfo modeInfo = null;
            if (rs != null && rs.next()) {
                modeInfo = new EliminationModeInfo();
                modeInfo.setId(BOSUuid.read((String)rs.getString("fid")));
                modeInfo.setName(eliminationModeName);
                this.cachedEliminationModeName.put(eliminationModeName, modeInfo);
            }
            return modeInfo;
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    private CurrencyInfo getCurrencyInfo(Context ctx, String currencyNumber) throws TaskExternalException {
        if (StringUtils.isEmpty((String)currencyNumber)) {
            return null;
        }
        if (this.cachedCurrencyNumber.containsKey(currencyNumber)) {
            return (CurrencyInfo)this.cachedCurrencyNumber.get(currencyNumber);
        }
        try {
            String sql = "select fid, fnumber, FPrecision from T_BD_Currency where fnumber = ?";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{currencyNumber});
            CurrencyInfo currencyInfo = null;
            if (rs != null && rs.next()) {
                currencyInfo = new CurrencyInfo();
                currencyInfo.setId(BOSUuid.read((String)rs.getString("fid")));
                currencyInfo.setNumber(rs.getString("fnumber"));
                currencyInfo.setPrecision(rs.getInt("FPrecision"));
                this.cachedCurrencyNumber.put(currencyNumber, currencyInfo);
            }
            return currencyInfo;
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    private CurrencyInfo getSourceCurrencyInfo(Context ctx, String currencyNumber) throws TaskExternalException {
        if (StringUtils.isEmpty((String)currencyNumber)) {
            return null;
        }
        if (this.cachedSourceCurrencyNumber.containsKey(currencyNumber)) {
            return (CurrencyInfo)this.cachedSourceCurrencyNumber.get(currencyNumber);
        }
        try {
            String sql = "select fid, fnumber, FPrecision from T_BD_Currency where fnumber = ?";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{currencyNumber});
            CurrencyInfo currencyInfo = null;
            if (rs != null && rs.next()) {
                currencyInfo = new CurrencyInfo();
                currencyInfo.setId(BOSUuid.read((String)rs.getString("fid")));
                currencyInfo.setNumber(rs.getString("fnumber"));
                currencyInfo.setPrecision(rs.getInt("FPrecision"));
                this.cachedSourceCurrencyNumber.put(currencyNumber, currencyInfo);
            }
            return currencyInfo;
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    private DataElementInfo getDataElementInfo(Context ctx, String dataElementNumber) throws TaskExternalException {
        if (StringUtils.isEmpty((String)dataElementNumber)) {
            return null;
        }
        if (this.cachedElement.containsKey(dataElementNumber)) {
            return (DataElementInfo)this.cachedElement.get(dataElementNumber);
        }
        try {
            String sql = "select fid, fnumber, FInterSeq from T_CSL_DataElement where fnumber = ?";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{dataElementNumber});
            DataElementInfo dataElementInfo = null;
            if (rs != null && rs.next()) {
                dataElementInfo = new DataElementInfo();
                dataElementInfo.setId(BOSUuid.read((String)rs.getString("fid")));
                dataElementInfo.setNumber(rs.getString("fnumber"));
                dataElementInfo.setInterSeq(rs.getInt("FInterSeq"));
                this.cachedElement.put(dataElementNumber, dataElementInfo);
            }
            return dataElementInfo;
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    private RPTItemInfo getItemByNumber(Context ctx, String itemNumber) throws TaskExternalException {
        if (StringUtils.isEmpty((String)itemNumber)) {
            return null;
        }
        if (this.cachedItemNumber.containsKey(itemNumber)) {
            return (RPTItemInfo)this.cachedItemNumber.get(itemNumber);
        }
        try {
            IRPTItem iItem = RPTItemFactory.getLocalInstance(ctx);
            CoreBaseCollection collection = iItem.getCollection(" where number = '" + itemNumber + "'");
            if (collection.isEmpty()) {
                throw new ServerException(ServerException.ITEMNUMBER_NOTFIND, new Object[]{itemNumber});
            }
            this.cachedItemNumber.put(itemNumber, collection.get(0));
            return (RPTItemInfo)collection.get(0);
        }
        catch (Exception e1) {
            throw new TaskExternalException(e1.getMessage());
        }
    }

    private ElimTypeEnum getElimiEnumByAlias(String alias, Locale l) {
        List ls = ElimTypeEnum.getEnumList();
        return (ElimTypeEnum)this.getEnumByAlias(alias, ls, l);
    }

    private RptSrcTypeEnum getRptEnumByAlias(String alias, Locale l) {
        List ls = RptSrcTypeEnum.getEnumList();
        return (RptSrcTypeEnum)this.getEnumByAlias(alias, ls, l);
    }

    private ValueTypeEnum getValueEnumByAlias(String alias, Locale l) {
        List ls = ValueTypeEnum.getEnumList();
        return (ValueTypeEnum)this.getEnumByAlias(alias, ls, l);
    }

    private DisplayTemplateTypeEnum getTemplateTypeEnuByAlias(String alias, Locale l) {
        List ls = DisplayTemplateTypeEnum.getEnumList();
        return (DisplayTemplateTypeEnum)this.getEnumByAlias(alias, ls, l);
    }

    private InvestNewAdjustElimTypeEnum getInvestEnumByAlias(String alias, Locale l) {
        List ls = InvestNewAdjustElimTypeEnum.getEnumList();
        return (InvestNewAdjustElimTypeEnum)this.getEnumByAlias(alias, ls, l);
    }

    private IntEnum getEnumByAlias(String alias, List ls, Locale l) {
        if (StringUtils.isEmpty((String)alias)) {
            return null;
        }
        for (int i = 0; i < ls.size(); ++i) {
            IntEnum t = (IntEnum)ls.get(i);
            if (alias.equals(t.getAlias(l))) {
                return t;
            }
            if (alias.equals(t.getAlias(new Locale("L2")))) {
                return t;
            }
            if (!alias.equals(t.getAlias(new Locale("L3")))) continue;
            return t;
        }
        return null;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        EliminationInfo elimiInfo = (EliminationInfo)coreBaseInfo;
        EliminationEntryCollection elimiEntryCol = elimiInfo.getEntries();
        boolean isDisplay = false;
        try {
            EliminationEntryCollection allRows;
            EliminationInfo hasExistElimiInfo = this.getHasExistElimiInfo(ctx, elimiInfo);
            if (this.isSltImportUpdate()) {
                if (hasExistElimiInfo != null) {
                    if (hasExistElimiInfo.getCheckedStatus().getValue() == 2) {
                        throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"200_EliminationImport", (Locale)ctx.getOriginLocale()));
                    }
                    if (hasExistElimiInfo.getArchivedStatus().getValue() == 2) {
                        throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"201_EliminationImport", (Locale)ctx.getOriginLocale()));
                    }
                    this.getElimiController(ctx).delete((IObjectPK)new ObjectUuidPK(hasExistElimiInfo.getId()));
                } else if (this.hasCodeRule) {
                    elimiInfo.setNumber(null);
                }
            }
            if (elimiInfo != null && (allRows = elimiInfo.getEntries()) != null && allRows.size() > 0) {
                int count = allRows.size();
                for (int i = 0; i < count; ++i) {
                    String cr;
                    String de;
                    int len;
                    EliminationEntryInfo info = allRows.get(i);
                    BigDecimal debit = info.getDebit();
                    BigDecimal credit = info.getCredit();
                    if (debit != null && (len = this.getBeforePointLen(de = debit.toString())) > 15) {
                        isDisplay = true;
                        break;
                    }
                    if (credit == null || (len = this.getBeforePointLen(cr = credit.toString())) <= 15) continue;
                    isDisplay = true;
                    break;
                }
            }
            IObjectPK pk = null;
            if (hasExistElimiInfo != null && !this.hasCodeRule) {
                pk = this.getElimiController(ctx).addnew((CoreBaseInfo)elimiInfo);
            } else if (this.hasCodeRule && !this.isSltImportUpdate()) {
                EliminationFactory.getLocalInstance(ctx).checkNumberDup(null, (CoreBillBaseInfo)elimiInfo);
                elimiInfo.setNumber(null);
                pk = this.getElimiController(ctx).submit((CoreBaseInfo)elimiInfo);
            } else {
                pk = this.hasCodeRule && this.isSltImportUpdate() ? (elimiInfo.getNumber() == null ? this.getElimiController(ctx).submit((CoreBaseInfo)elimiInfo) : this.getElimiController(ctx).addnew((CoreBaseInfo)elimiInfo)) : this.getElimiController(ctx).addnew((CoreBaseInfo)elimiInfo);
            }
            EliminationEntryCollection pkElimiEntryCol = this.getElimiController(ctx).getEliminationInfo(pk).getEntries();
            EliminationEntryInfo elimiEntryInfo = null;
            EliminationEntryInfo pkElimiEntryInfo = null;
            for (int i = 0; i < pkElimiEntryCol.size(); ++i) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("*"));
                sic.add(new SelectorItemInfo("item.number"));
                sic.add(new SelectorItemInfo("company.number"));
                pkElimiEntryInfo = this.getElimiEntryController(ctx).getEliminationEntryInfo((IObjectPK)new ObjectUuidPK(pkElimiEntryCol.get(i).getId()), sic);
                for (int j = 0; j < elimiEntryCol.size(); ++j) {
                    elimiEntryInfo = elimiEntryCol.get(j);
                    ElimDynaItemEntryInfo elimiDynItemInfo = null;
                    String key = null;
                    Enumeration enumn = elimiEntryInfo.keys();
                    while (enumn.hasMoreElements()) {
                        String pkCompanyKey;
                        key = enumn.nextElement().toString();
                        if (!key.startsWith(KEY_FLAG)) continue;
                        elimiDynItemInfo = (ElimDynaItemEntryInfo)elimiEntryInfo.get(key);
                        String companyKey = elimiDynItemInfo.getEliminationEntry().getCompany() == null ? "null" : elimiDynItemInfo.getEliminationEntry().getCompany().getNumber();
                        String string = pkCompanyKey = pkElimiEntryInfo.getCompany() == null ? "null" : pkElimiEntryInfo.getCompany().getNumber();
                        if (!(companyKey + elimiDynItemInfo.getEliminationEntry().getItem().getNumber() + new Integer(elimiDynItemInfo.getEliminationEntry().getDataElement()).toString()).equals(pkCompanyKey + pkElimiEntryInfo.getItem().getNumber() + new Integer(pkElimiEntryInfo.getDataElement()).toString())) continue;
                        elimiDynItemInfo.getEliminationEntry().setId(pkElimiEntryInfo.getId());
                        this.getElimiDynamicController(ctx).addnew((CoreBaseInfo)elimiDynItemInfo);
                    }
                }
            }
        }
        catch (Exception e) {
            if (isDisplay) {
                Exception e1 = new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"202_EliminationImport", (Locale)ctx.getOriginLocale()));
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"202_EliminationImport", (Locale)ctx.getOriginLocale()), (Throwable)e1);
            }
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    private int getBeforePointLen(String src) {
        int len = 0;
        if (src != null && (len = src.indexOf(".")) == -1) {
            len = src.length();
        }
        return len;
    }

    protected EliminationInfo getHasExistElimiInfo(Context ctx, EliminationInfo info) throws EASBizException, BOSException {
        EliminationInfo adjInfo = new EliminationInfo();
        String sql = "select adj.fid as adjId, adj.FCheckedStatus as adjCheckedStatus, adj.FArchivedStatus as adjArchivedStatus, \r\n adjEntry.fid as adjEntryId from T_CSL_Elimination adj inner join T_CSL_eliminationEntry adjEntry \r\n on adj.fid = adjEntry.FEliminationID where adj.fnumber = ? and adj.FOrgBoundID = ? \r\nand adj.FPeriodType = ? and adj.FYear = ? and adj.FPeriod = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{info.getNumber(), info.getOrgBound().getId().toString(), new Integer(info.getPeriodType().getValue()), new Integer(info.getYear()), new Integer(info.getPeriod())});
        EliminationEntryInfo adjEntryInfo = null;
        try {
            while (rs != null && rs.next()) {
                adjInfo.setId(BOSUuid.read((String)rs.getString("adjId")));
                adjInfo.setCheckedStatus(CheckedStatusEnum.getEnum((int)rs.getInt("adjCheckedStatus")));
                adjInfo.setArchivedStatus(ArchivedStatusEnum.getEnum(rs.getInt("adjArchivedStatus")));
                adjEntryInfo = new EliminationEntryInfo();
                adjEntryInfo.setId(BOSUuid.read((String)rs.getString("adjEntryId")));
                adjInfo.getEntries().add(adjEntryInfo);
            }
        }
        catch (UuidException e) {
            logger.error((Object)"BOSUuid.read_UuidException", (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)"getHasExistElimiInfo_SQLException", (Throwable)e);
        }
        return adjInfo.getId() == null ? null : adjInfo;
    }

    private IElimination getElimiController(Context ctx) throws BOSException {
        if (this.iElimi == null) {
            this.iElimi = EliminationFactory.getLocalInstance(ctx);
        }
        return this.iElimi;
    }

    private IEliminationEntry getElimiEntryController(Context ctx) throws BOSException {
        if (this.iElimiEntry == null) {
            this.iElimiEntry = EliminationEntryFactory.getLocalInstance(ctx);
        }
        return this.iElimiEntry;
    }

    private IElimDynaItemEntry getElimiDynamicController(Context ctx) throws BOSException {
        if (this.iElimiDynamic == null) {
            this.iElimiDynamic = ElimDynaItemEntryFactory.getLocalInstance(ctx);
        }
        return this.iElimiDynamic;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        try {
            SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
            Hashtable result = new Hashtable();
            this.setData(result, ELIMI_NUMBER, rs.getObject("number"));
            this.setData(result, ELIMI_BIZDATE, sf.format(rs.getObject("date")));
            this.setData(result, ELIMI_CURRENCY, rs.getObject("currency.number"));
            this.setData(result, ELIMI_SOURCECURRENCY, rs.getObject("sourceCurrency.number"));
            this.setData(result, ELIMI_TYPE, ElimTypeEnum.getEnum(rs.getInt("elimType")) == null ? null : ElimTypeEnum.getEnum(rs.getInt("elimType")).getAlias(ctx.getOriginLocale()));
            this.setData(result, ELIMI_DATASOURCE, RptSrcTypeEnum.getEnum((int)rs.getInt("dataSource")) == null ? null : RptSrcTypeEnum.getEnum((int)rs.getInt("dataSource")).getAlias(ctx.getOriginLocale()));
            this.setData(result, ELIMI_VALUETYPE, ValueTypeEnum.getEnum(rs.getInt("valueType")) == null ? null : ValueTypeEnum.getEnum(rs.getInt("valueType")).getAlias(ctx.getOriginLocale()));
            this.setData(result, ELIMI_TEMPLATETYPELONGNUMBER, rs.getObject("templateType.longNumber"));
            this.setData(result, ELIMI_REPORTTYPE, DisplayTemplateTypeEnum.getEnum((int)rs.getInt("templateType.reportType")) == null ? null : DisplayTemplateTypeEnum.getEnum((int)rs.getInt("templateType.reportType")).getAlias(ctx.getOriginLocale()));
            this.setData(result, ELIMI_ISCITEDBYLATER, Boolean.valueOf(rs.getBoolean("isCitedByLater")) == true ? IsCitedByLaterEnum.ISTRUE.getAlias() : IsCitedByLaterEnum.ISFALSE.getAlias());
            this.setData(result, ELIMI_REMARK, rs.getObject("remark"));
            this.setData(result, ELIMI_MODE_NAME, rs.getObject("eliminationMode.name"));
            this.setData(result, ELIMI_CUSTOMNUMBER, rs.getObject("customNumber"));
            this.setData(result, ELIMI_ENTRY_TYPE, InvestNewAdjustElimTypeEnum.getEnum(rs.getInt("investNewType")) == null ? null : InvestNewAdjustElimTypeEnum.getEnum(rs.getInt("investNewType")).getAlias(ctx.getOriginLocale()));
            this.setData(result, ELIMI_ENTRY_SUMMARY, rs.getObject("summaryAndRemark"));
            this.setData(result, ELIMI_ENTRY_COMPANY, rs.getObject("company.number"));
            this.setData(result, ELIMI_ENTRY_TARGETCOMPANY, rs.getObject("targetCompany.number"));
            this.setData(result, ELIMI_ENTRY_INVCOMPANY, rs.getObject("invCompany.number"));
            this.setData(result, ELIMI_ENTRY_ITEM, rs.getObject("item.number"));
            this.setData(result, ELIMI_ENTRY_DATAELEMENT, rs.getObject("dataElement.number"));
            this.setData(result, ELIMI_ENTRY_DEBIT, rs.getObject("entries.debit"));
            this.setData(result, ELIMI_ENTRY_CREDIT, rs.getObject("entries.credit"));
            this.setData(result, ELIMI_DYN_KEYNUMBER, rs.getObject("dynaItem.keyNumber"));
            this.setData(result, ELIMI_DYN_KEYLONGNUMBER, rs.getObject("dynaItem.keyLongNumber"));
            this.setData(result, ELIMI_DYN_KEYNAME, rs.getObject("dynaItem.keyName"));
            this.setData(result, ELIMI_DYN_VALUE, rs.getObject("dynaItem.value"));
            this.setData(result, ELIMI_DYN_REMARK, rs.getObject("dynaItem.remark"));
            this.setData(result, ELIMI_DYN_ASSTACTTYPENUMBER, rs.getObject("dynaItem.asstActTypeNumber"));
            return result;
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    private void setData(Hashtable result, String key, Object value) {
        if (value != null) {
            if (value instanceof BigDecimal) {
                result.put(key, CslRptUtil.ReduceBigDecimalZeros((BigDecimal)value));
            } else {
                result.put(key, value.toString());
            }
        }
    }

    public Hashtable getContextParameter() {
        Hashtable p = super.getContextParameter();
        return p;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return super.getExportFilterForQuery(ctx);
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.fi.gr.cslrpt.EliminationQueryForExport";
    }

    public String getMainField() {
        return ELIMI_NUMBER;
    }

    public int getSubmitType() {
        return 1;
    }

    public boolean isSameBlock(Hashtable firstData, Hashtable currenctData) {
        return super.isSameBlock(firstData, currenctData);
    }

    public void setContextParameter(Hashtable param) {
        param.put("mainQueryPK", MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fi.gr.cslrpt.EliminationQueryForExport"));
        super.setContextParameter((Map)param);
    }
}

