/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorProvider;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorResultProvider;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CSLPropertyAdapter;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.ElimTempletCollection;
import com.kingdee.eas.fi.gr.cslrpt.ElimTempletEntryCollection;
import com.kingdee.eas.fi.gr.cslrpt.ElimTempletFactory;
import com.kingdee.eas.fi.gr.cslrpt.ElimTempletInfo;
import com.kingdee.eas.fi.gr.cslrpt.ElimTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.EliminationCollection;
import com.kingdee.eas.fi.gr.cslrpt.EliminationEntryCollection;
import com.kingdee.eas.fi.gr.cslrpt.EliminationEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.EliminationInfo;
import com.kingdee.eas.fi.gr.cslrpt.IElimTemplet;
import com.kingdee.eas.fi.gr.cslrpt.app.CslElimUtil;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.formula.define.FormulaDefinition;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateTypeInfo;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class EliminationTmpBatchImport {
    private Book book = null;

    public IObjectPK[] doTemplateBatchImportElimRecords(Context ctx, List idList, Map valueMap, UserInfo userInfo) throws BOSException, EASBizException {
        int i;
        IObjectPK[] ObjectPKs = null;
        OrgTreeInfo orgTreeInfo = null;
        FullOrgUnitInfo orgUnitInfo = null;
        FullOrgUnitInfo fullOrgUnit = null;
        CompanyOrgUnitInfo companyOrgUnit = null;
        CurrencyInfo sourceCurrency = null;
        CurrencyInfo currency = null;
        Date bizDate = null;
        Timestamp createTime = null;
        int periodType = -1;
        int year = -1;
        int period = -1;
        TemplateTypeInfo displayType = null;
        HashMap entryCompanyMap = null;
        String cslRptGenerate = null;
        boolean param = false;
        if (valueMap != null) {
            if (valueMap.get("orgTreeInfo") != null) {
                orgTreeInfo = (OrgTreeInfo)valueMap.get("orgTreeInfo");
            }
            if (valueMap.get("fullOrgUnit") != null) {
                orgUnitInfo = fullOrgUnit = (FullOrgUnitInfo)valueMap.get("fullOrgUnit");
            }
            if (valueMap.get("companyOrgUnit") != null) {
                companyOrgUnit = (CompanyOrgUnitInfo)valueMap.get("companyOrgUnit");
                orgUnitInfo = companyOrgUnit;
            }
            if (valueMap.get("sourceCurrency") != null) {
                sourceCurrency = (CurrencyInfo)valueMap.get("sourceCurrency");
            }
            if (valueMap.get("currency") != null) {
                currency = (CurrencyInfo)valueMap.get("currency");
            }
            if (valueMap.get("dateBizDate") != null) {
                bizDate = (Date)valueMap.get("dateBizDate");
            }
            if (valueMap.get("dateCreateTime") != null) {
                createTime = new Timestamp(((Date)valueMap.get("dateCreateTime")).getTime());
            }
            if (valueMap.get("periodType") != null) {
                periodType = (Integer)valueMap.get("periodType");
            }
            if (valueMap.get("year") != null) {
                year = (Integer)valueMap.get("year");
            }
            if (valueMap.get("period") != null) {
                period = (Integer)valueMap.get("period");
            }
            if (valueMap.get("entryCompanyMap") != null) {
                entryCompanyMap = (HashMap)valueMap.get("entryCompanyMap");
            }
            if (valueMap.get("displayType") != null) {
                displayType = (TemplateTypeInfo)valueMap.get("displayType");
            }
            if (valueMap.get("csl_Rpt_Generate_Entry") != null) {
                cslRptGenerate = String.valueOf(valueMap.get("csl_Rpt_Generate_Entry"));
            }
            if (valueMap.get("GR_CSL_DCBalance") != null) {
                param = Boolean.valueOf(valueMap.get("GR_CSL_DCBalance").toString());
            }
        }
        EliminationInfo elim = new EliminationInfo();
        elim.setOrgBound(orgTreeInfo);
        if (fullOrgUnit != null) {
            elim.setOrgUnit(fullOrgUnit);
        } else if (companyOrgUnit != null) {
            elim.setOrgUnit((OrgUnitInfo)companyOrgUnit);
        }
        IElimTemplet iElimTemplet = ElimTempletFactory.getLocalInstance(ctx);
        ElimTempletInfo templateInfo = null;
        ElimTempletCollection tempCol = null;
        ElimTempletEntryCollection templeEntryCollection = null;
        String templateId = null;
        EliminationCollection elimCollection = null;
        EliminationInfo elimInfo = null;
        int rowIndex = 0;
        if (idList != null && idList.size() > 0) {
            Sheet sheet = null;
            try {
                sheet = this.initBook(ctx, (OrgUnitInfo)orgUnitInfo, orgTreeInfo, year, (short)period, RptPeriodTypeEnum.getEnum((int)periodType), currency);
            }
            catch (Exception exception) {
                // empty catch block
            }
            elimCollection = new EliminationCollection();
            HashMap<String, ElimTempletInfo> templateMap = new HashMap<String, ElimTempletInfo>();
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("*"));
            selector.add(new SelectorItemInfo("entries.*"));
            selector.add(new SelectorItemInfo("entries.item.id"));
            selector.add(new SelectorItemInfo("entries.item.number"));
            selector.add(new SelectorItemInfo("entries.item.isProfitAndLosses"));
            selector.add(new SelectorItemInfo("entries.company.number"));
            selector.add(new SelectorItemInfo("eliminationMode.id"));
            view.setSelector(selector);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("", new HashSet(idList), CompareType.INCLUDE));
            tempCol = iElimTemplet.getElimTempletCollection(view);
            int size = tempCol.size();
            for (i = 0; i < size; ++i) {
                ElimTempletInfo templet = tempCol.get(i);
                templateMap.put(templet.getId().toString(), templet);
            }
            for (i = 0; i < idList.size(); ++i) {
                templateId = (String)idList.get(i);
                templateInfo = (ElimTempletInfo)templateMap.get(templateId);
                if (templateInfo == null) continue;
                elimInfo = new EliminationInfo();
                elimInfo.setId(null);
                elimInfo.setNumber(null);
                elimInfo.setOrgBound(orgTreeInfo);
                if (fullOrgUnit != null) {
                    elimInfo.setOrgUnit(fullOrgUnit);
                } else if (companyOrgUnit != null) {
                    elimInfo.setOrgUnit((OrgUnitInfo)companyOrgUnit);
                }
                elimInfo.setCreator(userInfo);
                elimInfo.setCreateTime(createTime);
                elimInfo.setDate(bizDate);
                elimInfo.setSourceCurrency(sourceCurrency);
                elimInfo.setCurrency(currency);
                elimInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
                if (null != cslRptGenerate && cslRptGenerate.equals("csl_Rpt_Generate_Entry")) {
                    elimInfo.setCheckedStatus(CheckedStatusEnum.AUDITED);
                    elimInfo.setTempletID(templateId);
                    elimInfo.setAuditor((UserInfo)ctx.get((Object)"UserInfo"));
                    elimInfo.setAuditDate(new Timestamp(System.currentTimeMillis()));
                } else {
                    elimInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
                }
                elimInfo.setElimType(ElimTypeEnum.General);
                elimInfo.setValueType(templateInfo.getValueType());
                elimInfo.setIsCitedByLater(templateInfo.getIsCitedByLater());
                elimInfo.setPeriodType(RptPeriodTypeEnum.getEnum((int)periodType));
                elimInfo.setYear(year);
                elimInfo.setPeriod(period);
                elimInfo.setDisplayTemplateType(displayType);
                elimInfo.setEliminationMode(templateInfo.getEliminationMode());
                templeEntryCollection = templateInfo.getEntries();
                if (templeEntryCollection != null && templeEntryCollection.size() > 0) {
                    EliminationEntryInfo elimEntryInfo = null;
                    for (int j = 0; j < templeEntryCollection.size(); ++j) {
                        elimEntryInfo = new EliminationEntryInfo();
                        elimEntryInfo.setId(null);
                        if (null != cslRptGenerate && cslRptGenerate.equals("csl_Rpt_Generate_Entry")) {
                            elimEntryInfo.setCompany(fullOrgUnit);
                        } else if (entryCompanyMap != null) {
                            elimEntryInfo.setCompany((FullOrgUnitInfo)entryCompanyMap.get(templeEntryCollection.get(j).getId().toString()));
                        }
                        elimEntryInfo.setItem(templeEntryCollection.get(j).getItem());
                        elimEntryInfo.setSummary(templeEntryCollection.get(j).getSummary());
                        elimEntryInfo.setDataElement(templeEntryCollection.get(j).getDataElement());
                        elimEntryInfo.setIsVisible(true);
                        elimInfo.getEntries().add(elimEntryInfo);
                        if (sheet != null) {
                            Cell cell = null;
                            if (templeEntryCollection.get(j).getDebitFormula() != null) {
                                cell = sheet.getCell(rowIndex, 0, true);
                                cell.setFormula("=" + templeEntryCollection.get(j).getDebitFormula());
                            } else {
                                cell = sheet.getCell(rowIndex, 0, true);
                                cell.setFormula(null);
                                cell.setValue(Variant.nullVariant);
                            }
                            if (templeEntryCollection.get(j).getCreditFormula() != null) {
                                cell = sheet.getCell(rowIndex, 1, true);
                                cell.setFormula("=" + templeEntryCollection.get(j).getCreditFormula());
                            } else {
                                cell = sheet.getCell(rowIndex, 1, true);
                                cell.setFormula(null);
                                cell.setValue(Variant.nullVariant);
                            }
                        }
                        ++rowIndex;
                    }
                }
                elimCollection.add(elimInfo);
            }
        }
        Object[][] values = this.getCalcValues(rowIndex);
        if (elimCollection != null && orgTreeInfo != null) {
            rowIndex = 0;
            int size = elimCollection.size();
            String[] numbers = CslElimUtil.getBatchNumber(ctx, orgTreeInfo.getId().toString(), year, period, periodType, size, orgTreeInfo, (OrgUnitInfo)orgUnitInfo);
            Connection cn = null;
            try {
                cn = EJBFactory.getConnection((Context)ctx);
                IORMappingDAO iORMapping = ORMappingDAO.getInstance((BOSObjectType)new EliminationInfo().getBOSType(), (Context)ctx, (Connection)cn);
                for (i = 0; i < size; ++i) {
                    int k;
                    EliminationEntryCollection elimEntryCollection = elimCollection.get(i).getEntries();
                    int entrySize = elimEntryCollection.size();
                    ArrayList<EliminationEntryInfo> allEmptyEntryList = new ArrayList<EliminationEntryInfo>();
                    BigDecimal debitSum = new BigDecimal(0.0);
                    BigDecimal creditSum = new BigDecimal(0.0);
                    ArrayList<EliminationEntryInfo> allZeroEntryList = new ArrayList<EliminationEntryInfo>();
                    BigDecimal zero = new BigDecimal("0");
                    for (k = 0; k < entrySize; ++k) {
                        if (values[rowIndex][0] instanceof Number) {
                            elimEntryCollection.get(k).setDebit((BigDecimal)values[rowIndex][0]);
                            debitSum = debitSum.add((BigDecimal)values[rowIndex][0]);
                        }
                        if (values[rowIndex][1] instanceof Number) {
                            elimEntryCollection.get(k).setCredit((BigDecimal)values[rowIndex][1]);
                            creditSum = creditSum.add((BigDecimal)values[rowIndex][1]);
                        }
                        BigDecimal debit = elimEntryCollection.get(k).getDebit();
                        BigDecimal credit = elimEntryCollection.get(k).getCredit();
                        if (debit == null && credit == null) {
                            allEmptyEntryList.add(elimEntryCollection.get(k));
                        }
                        if (debit != null && debit.compareTo(zero) == 0 || credit != null && credit.compareTo(zero) == 0) {
                            allZeroEntryList.add(elimEntryCollection.get(k));
                        }
                        ++rowIndex;
                    }
                    if (allEmptyEntryList.size() == entrySize && allZeroEntryList.size() == entrySize && allEmptyEntryList.size() + allZeroEntryList.size() == entrySize || param && debitSum.compareTo(creditSum) != 0 && "csl_Rpt_Generate_Entry".equals(cslRptGenerate)) continue;
                    for (k = 0; k < allEmptyEntryList.size(); ++k) {
                        if (!elimEntryCollection.contains((EliminationEntryInfo)allEmptyEntryList.get(k))) continue;
                        elimEntryCollection.removeObject((IObjectValue)((EliminationEntryInfo)allEmptyEntryList.get(k)));
                    }
                    for (k = 0; k < allZeroEntryList.size(); ++k) {
                        if (!elimEntryCollection.contains((EliminationEntryInfo)allZeroEntryList.get(k))) continue;
                        elimEntryCollection.removeObject((IObjectValue)((EliminationEntryInfo)allZeroEntryList.get(k)));
                    }
                    elimCollection.get(i).setNumber(numbers[i]);
                    elimCollection.get(i).setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
                    elimCollection.get(i).setCreateTime(new Timestamp(new Date().getTime()));
                    if (elimEntryCollection.size() <= 0) continue;
                    iORMapping.addNewBatch((IObjectValue)elimCollection.get(i));
                }
                ObjectPKs = iORMapping.executeBatchWithReturn();
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            finally {
                SQLUtils.cleanup((Connection)cn);
            }
        }
        return ObjectPKs;
    }

    private Sheet initBook(final Context ctx, final OrgUnitInfo orgUnitInfo, final OrgTreeInfo orgTreeInfo, final int year, final short period, final RptPeriodTypeEnum periodType, final CurrencyInfo currency) throws Exception {
        if (this.book == null) {
            this.book = Book.Manager.getNewBook((String)"Sheet1", (int)1);
            this.book.setCalculate(false);
        }
        Sheet sheet = this.book.getSheet(0);
        FormulaDefinition.registerFormulaToBook((Book)this.book, (ICalculateContextProvider)new ICalculateContextProvider(){
            private static final long serialVersionUID = 2342600610859269292L;

            public IErrorProvider getErrorProvider() {
                return null;
            }

            public IErrorResultProvider getErrorResultProvider() {
                return null;
            }

            public IReportPropertyAdapter getReportAdapter() {
                CslReportInfo cslReport = new CslReportInfo();
                cslReport.setOrgTree(orgTreeInfo);
                cslReport.setOrgUnit(orgUnitInfo);
                cslReport.setYear(year);
                cslReport.setPeriod(period);
                cslReport.setPeriodType(periodType);
                cslReport.setCurrency(currency);
                cslReport.setSourceType(RptSrcTypeEnum.CONSOLIDATION);
                CSLPropertyAdapter adapter = new CSLPropertyAdapter(cslReport, ctx);
                return adapter;
            }

            public ReportVariables getReportVariables() {
                return new ReportVariables();
            }

            public Context getServerContext() {
                return ctx;
            }
        });
        return sheet;
    }

    private Object[][] getCalcValues(int entrySize) {
        this.book.calc();
        Sheet sheet = this.book.getSheet(0);
        Cell cell = null;
        Object[][] values = new Object[entrySize][2];
        for (int i = 0; i < entrySize; ++i) {
            cell = sheet.getCell(i, 0, false);
            if (cell != null && cell.getValue() != null) {
                values[i][0] = cell.getValue().getValue();
            }
            if ((cell = sheet.getCell(i, 1, false)) == null || cell.getValue() == null) continue;
            values[i][1] = cell.getValue().getValue();
        }
        return values;
    }
}

