/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorProvider;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.FunctionManager;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CSLPropertyAdapter;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CslConstant;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.ICalculator;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.formula.ReportCalculateContext;
import com.kingdee.eas.fi.newrpt.formula.define.FormulaDefinition;
import com.kingdee.eas.fi.newrpt.report.VariablesHelper;
import com.kingdee.eas.fi.rpt.ElimDataInvTypeEnum;
import com.kingdee.eas.fi.rpt.ReportCalculateErrorProvider;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSheetParamCollection;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.expr.Area3DExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.BoolExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.IntExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Ref3DExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.UnaryOperationExpr;
import com.kingdee.eas.fi.rpt.util.BookProperties;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.fi.rpt.util.VariableEntry;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class FormulaUtil {
    private static Logger logger = Logger.getLogger((String)FormulaUtil.class.getName());

    public static Expression fillFormulas(Expression stmt, Map params) throws EASBizException, BOSException {
        if (stmt instanceof FunctionExpr) {
            String funName = ((FunctionExpr)stmt).funcionName;
            if (funName.equalsIgnoreCase("AcctItem")) {
                stmt = FormulaUtil.fillAcctItem((FunctionExpr)stmt, params);
            } else if (funName.equalsIgnoreCase("DyItem")) {
                stmt = FormulaUtil.fillDyItem((FunctionExpr)stmt, params);
            } else if (funName.equalsIgnoreCase("ESP")) {
                stmt = FormulaUtil.fillESP((FunctionExpr)stmt, params);
            } else if (funName.equalsIgnoreCase("InvData")) {
                stmt = FormulaUtil.fillInvData((FunctionExpr)stmt, params);
            } else if (funName.equalsIgnoreCase("ElimData")) {
                stmt = FormulaUtil.fillElimData((FunctionExpr)stmt, params);
            } else if (funName.equalsIgnoreCase("ElimRpt")) {
                stmt = FormulaUtil.fillElimRpt((FunctionExpr)stmt, params);
            } else if (funName.equalsIgnoreCase("EqtData")) {
                stmt = FormulaUtil.fillEqtData((FunctionExpr)stmt, params);
            } else if (funName.equalsIgnoreCase("AdjustData")) {
                stmt = FormulaUtil.fillAdjustData((FunctionExpr)stmt, params);
            } else if (funName.equalsIgnoreCase("CsRef")) {
                stmt = FormulaUtil.fillCsRef((FunctionExpr)stmt, params);
            } else if (funName.equalsIgnoreCase("IF") || funName.equalsIgnoreCase("Round")) {
                try {
                    String formula = stmt.toString();
                    String result = stmt.toString();
                    int index = 0;
                    result = FormulaUtil.getFormula("ACCTITEM", formula, result, params, index);
                    result = FormulaUtil.getFormula("ESP", formula, result, params, index);
                    result = FormulaUtil.getFormula("INVDATA", formula, result, params, index);
                    result = FormulaUtil.getFormula("ELIMDATA", formula, result, params, index);
                    result = FormulaUtil.getFormula("ELIMRPT", formula, result, params, index);
                    result = FormulaUtil.getFormula("EQTDATA", formula, result, params, index);
                    result = FormulaUtil.getFormula("CSREF", formula, result, params, index);
                    stmt = ExcelFormulaPaserHelper.parse((String)result);
                }
                catch (Exception e) {
                    logger.error((Object)"FormulaUtil-fillFormulas(IF): ", (Throwable)e);
                }
            }
        } else if (stmt instanceof BinaryOperationExpr) {
            Expression expr = FormulaUtil.fillFormulas(((BinaryOperationExpr)stmt).left, params);
            if (expr == null) {
                return null;
            }
            ((BinaryOperationExpr)stmt).left = expr;
            expr = FormulaUtil.fillFormulas(((BinaryOperationExpr)stmt).right, params);
            if (expr == null) {
                return null;
            }
            ((BinaryOperationExpr)stmt).right = expr;
        } else if (stmt instanceof UnaryOperationExpr) {
            Expression expr = FormulaUtil.fillFormulas(((UnaryOperationExpr)stmt).operand, params);
            if (expr == null) {
                return null;
            }
            ((UnaryOperationExpr)stmt).operand = expr;
        }
        return stmt;
    }

    private static String getFormula(String funName, String formula, String result, Map params, int index) throws Exception {
        if (formula.indexOf(funName, 0) > 0) {
            int beginIndex = result.indexOf(funName, index);
            int endIndex = result.indexOf(")", beginIndex);
            String acctitem = result.substring(beginIndex, endIndex + 1);
            String search = result.substring(endIndex + 1, result.length());
            Expression expr = ExcelFormulaPaserHelper.parse((String)acctitem);
            expr = FormulaUtil.fillFormulas((Expression)((FunctionExpr)expr), params);
            result = result.substring(0, beginIndex) + expr.toString() + result.substring(endIndex + 1);
            int beginIndex1 = result.indexOf(funName, index);
            int endIndex1 = result.indexOf(")", beginIndex1);
            result = FormulaUtil.getFormula(funName, search, result, params, endIndex1);
        }
        return result;
    }

    public static FunctionExpr fillElimRpt(FunctionExpr expr, Map params) {
        StringExpr se;
        ArrayList param = new ArrayList();
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(0))) {
            param.add(expr.parameters.get(0));
        } else {
            se = new StringExpr((String)params.get("KeyOrgTree"));
            param.add(se);
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(1))) {
            param.add(expr.parameters.get(1));
        } else {
            se = new StringExpr((String)params.get("SRCCOMPANY"));
            param.add(se);
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(2))) {
            param.add(expr.parameters.get(2));
        } else {
            se = new StringExpr((String)params.get("TARCOMPANY"));
            param.add(se);
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(3))) {
            param.add(expr.parameters.get(3));
        } else {
            se = new StringExpr((String)params.get("KEY_SOURCECURRENCY"));
            param.add(se);
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(4))) {
            param.add(expr.parameters.get(4));
        } else {
            se = new StringExpr((String)params.get("KEY_CURRENCY"));
            param.add(se);
        }
        param.add(expr.parameters.get(5));
        param.add(expr.parameters.get(6));
        param.add(expr.parameters.get(7));
        param.add(expr.parameters.get(8));
        param.add(expr.parameters.get(9));
        param.add(expr.parameters.get(10));
        if (expr.parameters.size() > 11) {
            param.add(expr.parameters.get(11));
        }
        expr.parameters = param;
        return expr;
    }

    public static FunctionExpr fillInvData(FunctionExpr expr, Map params) throws EASBizException {
        ArrayList<Object> param = new ArrayList<Object>();
        Context ctx = (Context)params.get("KEY_CONTEXT");
        StringExpr se = new StringExpr((String)params.get("SRCCOMPANY"));
        param.add(se);
        se = new StringExpr((String)params.get("TARCOMPANY"));
        param.add(se);
        se = new StringExpr((String)params.get("Day"));
        param.add(se);
        se = new StringExpr((String)params.get("KEY_SOURCECURRENCY"));
        param.add(se);
        try {
            param.add(expr.parameters.get(4));
        }
        catch (IndexOutOfBoundsException e) {
            throw new EASBizException(new NumericExceptionSubItem("1", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"208_FormulaUtil", (Locale)ctx.getOriginLocale())));
        }
        expr.parameters = param;
        return expr;
    }

    public static FunctionExpr fillEqtData(FunctionExpr expr, Map params) throws EASBizException {
        StringExpr se;
        ArrayList param = new ArrayList();
        Context ctx = (Context)params.get("KEY_CONTEXT");
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(0))) {
            param.add(expr.parameters.get(0));
        } else {
            se = new StringExpr((String)params.get("SRCCOMPANY"));
            param.add(se);
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(1))) {
            param.add(expr.parameters.get(1));
        } else {
            se = new StringExpr((String)params.get("TARCOMPANY"));
            param.add(se);
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(2))) {
            param.add(expr.parameters.get(2));
        } else {
            se = new StringExpr((String)params.get("Day"));
            param.add(se);
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(3))) {
            param.add(expr.parameters.get(3));
        } else {
            se = new StringExpr((String)params.get("KEY_SOURCECURRENCY"));
            param.add(se);
        }
        try {
            param.add(expr.parameters.get(4));
        }
        catch (IndexOutOfBoundsException e) {
            throw new EASBizException(new NumericExceptionSubItem("1", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"208_FormulaUtil", (Locale)ctx.getOriginLocale())));
        }
        expr.parameters = param;
        return expr;
    }

    private static FunctionExpr fillAdjustData(FunctionExpr expr, Map params) {
        StringExpr se;
        ArrayList para = new ArrayList();
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(0))) {
            para.add(expr.parameters.get(0));
        } else {
            se = new StringExpr((String)params.get("KeyOrgTree"));
            para.add(se);
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(1))) {
            para.add(expr.parameters.get(1));
        } else {
            se = new StringExpr((String)params.get("KEY_COMPANY"));
            para.add(se);
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(2))) {
            para.add(expr.parameters.get(2));
        } else {
            se = new StringExpr((String)params.get("KEY_SOURCECURRENCY"));
            para.add(se);
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(3))) {
            para.add(expr.parameters.get(3));
        } else {
            se = new StringExpr((String)params.get("KEY_CURRENCY"));
            para.add(se);
        }
        para.add(expr.parameters.get(4));
        para.add(expr.parameters.get(5));
        para.add(expr.parameters.get(6));
        para.add(expr.parameters.get(7));
        para.add(expr.parameters.get(8));
        para.add(expr.parameters.get(9));
        para.add(expr.parameters.get(10));
        para.add(expr.parameters.get(11));
        para.add(expr.parameters.get(12));
        para.add(expr.parameters.get(13));
        para.add(expr.parameters.get(14));
        if (expr.parameters.size() > 15) {
            para.add(expr.parameters.get(15));
        }
        expr.parameters = para;
        return expr;
    }

    public static FunctionExpr fillCsRef(FunctionExpr expr, Map params) throws EASBizException {
        StringExpr se;
        ArrayList para = new ArrayList();
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(0))) {
            para.add(expr.parameters.get(0));
        } else {
            se = new StringExpr((String)params.get("KeyOrgTree"));
            para.add(se);
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(1))) {
            para.add(expr.parameters.get(1));
        } else {
            se = new StringExpr((String)params.get("KEY_COMPANY"));
            para.add(se);
        }
        para.add(expr.parameters.get(2));
        para.add(expr.parameters.get(3));
        para.add(expr.parameters.get(4));
        para.add(expr.parameters.get(5));
        para.add(expr.parameters.get(6));
        para.add(expr.parameters.get(7));
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(8))) {
            para.add(expr.parameters.get(8));
        } else {
            se = new StringExpr((String)params.get("KEY_SOURCECURRENCY"));
            para.add(se);
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(9))) {
            para.add(expr.parameters.get(9));
        } else {
            se = new StringExpr((String)params.get("KEY_CURRENCY"));
            para.add(se);
        }
        para.add(expr.parameters.get(10));
        if (expr.parameters.size() > 11) {
            para.add(expr.parameters.get(11));
        }
        if (expr.parameters.size() > 12) {
            para.add(expr.parameters.get(12));
        }
        expr.parameters = para;
        return expr;
    }

    public static FunctionExpr fillElimData(FunctionExpr expr, Map params) {
        StringExpr se;
        ArrayList para = new ArrayList();
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(0))) {
            para.add(expr.parameters.get(0));
        } else {
            se = new StringExpr((String)params.get("KeyOrgTree"));
            para.add(se);
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(1))) {
            para.add(expr.parameters.get(1));
        } else {
            se = new StringExpr((String)params.get("KeyOrgUnit"));
            para.add(se);
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(2))) {
            para.add(expr.parameters.get(2));
        } else {
            se = expr.parameters.size() > 16 && FormulaUtil.isAdjustOrElimType(expr.parameters.get(13)) ? new StringExpr((String)params.get("SRCCOMPANY")) : new StringExpr((String)params.get("KeyOrgUnit"));
            para.add(se);
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(3))) {
            para.add(expr.parameters.get(3));
        } else {
            se = new StringExpr((String)params.get("KEY_SOURCECURRENCY"));
            para.add(se);
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(4))) {
            para.add(expr.parameters.get(4));
        } else {
            se = new StringExpr((String)params.get("KEY_CURRENCY"));
            para.add(se);
        }
        para.add(expr.parameters.get(5));
        para.add(expr.parameters.get(6));
        para.add(expr.parameters.get(7));
        para.add(expr.parameters.get(8));
        para.add(expr.parameters.get(9));
        para.add(expr.parameters.get(10));
        para.add(expr.parameters.get(11));
        para.add(expr.parameters.get(12));
        para.add(expr.parameters.get(13));
        para.add(expr.parameters.get(14));
        para.add(expr.parameters.get(15));
        if (expr.parameters.size() > 16) {
            if (FormulaUtil.hasDispenseParameter(expr.parameters.get(16))) {
                para.add(expr.parameters.get(16));
            } else {
                se = new StringExpr((String)params.get("TARCOMPANY"));
                para.add(se);
            }
        }
        expr.parameters = para;
        return expr;
    }

    private static boolean isAdjustOrElimType(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof StringExpr) {
            StringExpr se = (StringExpr)obj;
            String param = se.toString();
            ElimDataInvTypeEnum elimType = ElimDataInvTypeEnum.getEnum((String)(param = param.replaceAll("\"", "")));
            return ElimDataInvTypeEnum.ADJUST.equals((Object)elimType) || ElimDataInvTypeEnum.ELIM.equals((Object)elimType);
        }
        return false;
    }

    public static FunctionExpr fillAcctItem(FunctionExpr expr, Map params) throws BOSException {
        boolean isClearCompany;
        StringExpr se;
        ArrayList para = new ArrayList();
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(0))) {
            para.add(expr.parameters.get(0));
        } else {
            se = new StringExpr((String)params.get("KeyOrgTree"));
            para.add(se);
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(1))) {
            para.add(expr.parameters.get(1));
        } else {
            se = new StringExpr((String)params.get("KEY_COMPANY"));
            para.add(se);
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(2))) {
            para.add(expr.parameters.get(2));
        } else {
            se = new StringExpr((String)params.get("KEY_SOURCECURRENCY"));
            para.add(se);
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(3))) {
            para.add(expr.parameters.get(3));
        } else {
            se = new StringExpr((String)params.get("KEY_CURRENCY"));
            para.add(se);
        }
        para.add(expr.parameters.get(4));
        para.add(expr.parameters.get(5));
        para.add(expr.parameters.get(6));
        Boolean isNew = (Boolean)params.get("isNew");
        boolean bl = isClearCompany = params.containsKey("KEY_IS_CLEARCOMPANY") ? (Boolean)params.get("KEY_IS_CLEARCOMPANY") : false;
        if (isNew.booleanValue() && !isClearCompany) {
            para.add(expr.parameters.get(7));
            para.add(expr.parameters.get(8));
            para.add(expr.parameters.get(9));
        } else {
            se = new StringExpr(String.valueOf(params.get("Year")));
            para.add(se);
            se = new StringExpr(String.valueOf(params.get("Period")));
            para.add(se);
            se = new StringExpr(String.valueOf(params.get("Period")));
            para.add(se);
        }
        para.add(expr.parameters.get(10));
        para.add(expr.parameters.get(11));
        para.add(expr.parameters.get(12));
        para.add(expr.parameters.get(13));
        if (expr.parameters.size() > 14) {
            para.add(expr.parameters.get(14));
        }
        if (expr.parameters.size() > 15) {
            para.add(expr.parameters.get(15));
        }
        if (expr.parameters.size() > 16) {
            para.add(expr.parameters.get(16));
        }
        expr.parameters = para;
        int companyType = (Integer)params.get("KEY_INVEST_COMPANYTYPE");
        if (companyType == 2 && isNew.booleanValue()) {
            FormulaUtil.AcctItemCompanyNumHandle(expr, params);
        }
        return expr;
    }

    public static FunctionExpr fillDyItem(FunctionExpr expr, Map params) throws BOSException {
        boolean isClearCompany;
        StringExpr se;
        ArrayList para = new ArrayList();
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(0))) {
            para.add(expr.parameters.get(0));
        } else {
            se = new StringExpr((String)params.get("KeyOrgTree"));
            para.add(se);
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(1))) {
            para.add(expr.parameters.get(1));
        } else {
            se = new StringExpr((String)params.get("KEY_COMPANY"));
            para.add(se);
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(2))) {
            para.add(expr.parameters.get(2));
        } else {
            para.add(new StringExpr(""));
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(3))) {
            para.add(expr.parameters.get(3));
        } else {
            para.add(new StringExpr(""));
        }
        para.add(expr.parameters.get(4));
        para.add(expr.parameters.get(5));
        para.add(expr.parameters.get(6));
        Boolean isNew = (Boolean)params.get("isNew");
        boolean bl = isClearCompany = params.containsKey("KEY_IS_CLEARCOMPANY") ? (Boolean)params.get("KEY_IS_CLEARCOMPANY") : false;
        if (isNew.booleanValue() && !isClearCompany) {
            para.add(expr.parameters.get(7));
            para.add(expr.parameters.get(8));
            para.add(expr.parameters.get(9));
        } else {
            se = new StringExpr(String.valueOf(params.get("Year")));
            para.add(se);
            se = new StringExpr(String.valueOf(params.get("Period")));
            para.add(se);
            se = new StringExpr(String.valueOf(params.get("Period")));
            para.add(se);
        }
        para.add(expr.parameters.get(10));
        para.add(expr.parameters.get(11));
        para.add(expr.parameters.get(12));
        para.add(expr.parameters.get(13));
        if (expr.parameters.size() > 14) {
            para.add(expr.parameters.get(14));
        }
        if (expr.parameters.size() > 15) {
            para.add(expr.parameters.get(15));
        }
        if (expr.parameters.size() > 16) {
            para.add(expr.parameters.get(16));
        }
        if (expr.parameters.size() > 17) {
            para.add(expr.parameters.get(17));
        }
        if (expr.parameters.size() > 18) {
            para.add(expr.parameters.get(18));
        }
        expr.parameters = para;
        return expr;
    }

    private static void AcctItemCompanyNumHandle(FunctionExpr e, Map params) throws BOSException {
        RptSrcTypeEnum rptTypeEnum;
        OrgTreeInfo orgTree = (OrgTreeInfo)params.get("KEY_ORGTREE_INFO");
        Context ctx = (Context)params.get("KEY_CONTEXT");
        String compNum = (String)params.get("KEY_COMPANY");
        ArrayList<String> param = new ArrayList<String>();
        String rptType = e.parameters.get(10).toString();
        if (rptType != null && rptType.indexOf("\"") != -1) {
            rptType = rptType.replaceAll("\"", "");
        }
        if ((rptTypeEnum = RptSrcTypeEnum.getEnum((String)rptType)) != null && rptTypeEnum.equals((Object)RptSrcTypeEnum.COMMITREPORT)) {
            return;
        }
        if (rptTypeEnum == null || rptTypeEnum.getValue() == RptSrcTypeEnum.NORMAL.getValue()) {
            rptType = RptSrcTypeEnum.COMMITREPORT.getName();
            StringExpr se = new StringExpr(rptType);
            e.parameters.set(10, se);
            return;
        }
        StringBuffer sql = new StringBuffer(100);
        sql.append(" select unit0.FNumber unitNum from t_org_OupartUnionGroup p \n");
        sql.append(" join t_org_BaseUnit company on p.FStockControlCompanyId= company.FId \n");
        sql.append(" join t_org_Structure s0 on p.FUnitId = s0.FUnitId \n");
        sql.append(" join t_org_BaseUnit unit0 on p.funitid = unit0.fid \n");
        sql.append(" where s0.FTreeId = ? \n");
        sql.append(" and company.fnumber = ? \n");
        param.add(orgTree.getId().toString());
        param.add(compNum);
        try {
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param.toArray());
            if (rowset == null || rowset.size() == 0) {
                return;
            }
            if (rowset.next()) {
                String unitNumber = rowset.getString("unitNum");
                StringExpr se = new StringExpr(unitNumber);
                e.parameters.set(1, se);
            }
        }
        catch (Exception e1) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"209_FormulaUtil", (Locale)ctx.getOriginLocale()) + e.toString() + ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"210_FormulaUtil", (Locale)ctx.getOriginLocale()) + e1));
            }
            throw new BOSException((Throwable)e1);
        }
    }

    public static boolean hasDispenseParameter(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof StringExpr) {
            StringExpr se = (StringExpr)obj;
            String param = se.toString();
            return !(param = param.replaceAll("\"", "")).trim().equals("");
        }
        if (obj instanceof IntExpr) {
            IntExpr ie = (IntExpr)obj;
            if (ie.value.abs().compareTo(new BigInteger("0")) > 0) {
                return true;
            }
        } else {
            if (obj instanceof BoolExpr) {
                return true;
            }
            if (obj instanceof FunctionExpr || obj instanceof BinaryOperationExpr || obj instanceof UnaryOperationExpr || obj instanceof Area3DExpr || obj instanceof Ref3DExpr) {
                return true;
            }
        }
        return false;
    }

    public static FunctionExpr fillESP(FunctionExpr expr, Map params) throws EASBizException {
        Context ctx = (Context)params.get("KEY_CONTEXT");
        ArrayList para = new ArrayList();
        StringExpr se = null;
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(0))) {
            para.add(expr.parameters.get(0));
        } else {
            se = new StringExpr((String)params.get("KeyOrgTree"));
            para.add(se);
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(1))) {
            para.add(expr.parameters.get(1));
        } else {
            se = new StringExpr((String)params.get("SRCCOMPANY"));
            para.add(se);
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(2))) {
            para.add(expr.parameters.get(2));
        } else {
            se = new StringExpr((String)params.get("TARCOMPANY"));
            para.add(se);
        }
        try {
            para.add(expr.parameters.get(3));
        }
        catch (IndexOutOfBoundsException e) {
            throw new EASBizException(new NumericExceptionSubItem("1", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"211_FormulaUtil", (Locale)ctx.getOriginLocale())));
        }
        se = new StringExpr(String.valueOf(params.get("Year")));
        para.add(se);
        se = new StringExpr(String.valueOf(params.get("CUR_Period")));
        para.add(se);
        se = new StringExpr((String)params.get("Day"));
        para.add(se);
        expr.parameters = para;
        return expr;
    }

    public static int getBranchCalculateType(Expression expr, Map params) {
        int branchType = 0;
        String elimInvestType = (String)params.get("AdjustElimType");
        if (!String.valueOf(1).equals(elimInvestType) && !String.valueOf(2).equals(elimInvestType)) {
            return branchType;
        }
        if (FormulaUtil.isYtdAmoundNumber(params)) {
            branchType = 1;
        } else if (FormulaUtil.isEndBalanceNumber(params) && !String.valueOf(2).equals(elimInvestType)) {
            branchType = 2;
        } else if (FormulaUtil.isEndBalanceNumber(params) && String.valueOf(2).equals(elimInvestType)) {
            branchType = 0;
        }
        if (expr instanceof BinaryOperationExpr) {
            Expression formulaExpr = ((BinaryOperationExpr)expr).left;
            if (formulaExpr instanceof FunctionExpr) {
                branchType = FormulaUtil.isRightAcctItem(formulaExpr) ? branchType : 0;
            } else if (formulaExpr instanceof UnaryOperationExpr && (1 == ((UnaryOperationExpr)formulaExpr).operationType || 2 == ((UnaryOperationExpr)formulaExpr).operationType) && !FormulaUtil.isRightAcctItem(((UnaryOperationExpr)formulaExpr).operand)) {
                branchType = 0;
            }
        }
        return branchType;
    }

    private static boolean isYtdAmoundNumber(Map params) {
        return FormulaUtil.isSpecifiedDataElement("YTDAMOUNT", params);
    }

    private static boolean isEndBalanceNumber(Map params) {
        return FormulaUtil.isSpecifiedDataElement("ENDBALANCE", params);
    }

    private static boolean isSpecifiedDataElement(String specifiedDataElementNum, Map params) {
        String dataElementNum = (String)params.get("DataElement");
        return !StringUtils.isEmpty((String)dataElementNum) && specifiedDataElementNum.equals(dataElementNum);
    }

    private static boolean isRightAcctItem(Expression formulaExpr) {
        if (formulaExpr instanceof FunctionExpr && "AcctItem".equalsIgnoreCase(((FunctionExpr)formulaExpr).funcionName)) {
            String rptItemNum = FormulaUtil.getRptItemNumOfAcctItem(formulaExpr, 4);
            String rptItemNum2 = FormulaUtil.getRptItemNumOfAcctItem(formulaExpr, 5);
            return rptItemNum.equals(rptItemNum2);
        }
        return false;
    }

    public static String getformulaEspStr(Expression formulaExpr) {
        String espExpr = "";
        if (formulaExpr instanceof BinaryOperationExpr) {
            Expression formulaEsp = ((BinaryOperationExpr)formulaExpr).left;
            Pattern p = Pattern.compile("\\d+-");
            Matcher m = p.matcher(formulaEsp.toString());
            if (m.find() && formulaEsp.toString().toUpperCase().indexOf("ESP") > -1) {
                espExpr = formulaEsp.toString();
                espExpr = espExpr.substring(espExpr.toUpperCase().indexOf("ESP"));
            } else {
                formulaEsp = ((BinaryOperationExpr)formulaExpr).right;
                m = p.matcher(formulaEsp.toString());
                if (m.find() && formulaEsp.toString().toUpperCase().indexOf("ESP") > -1) {
                    espExpr = formulaEsp.toString();
                    espExpr = espExpr.substring(espExpr.toUpperCase().indexOf("ESP"));
                }
            }
        }
        if (espExpr != null && espExpr.endsWith("))")) {
            espExpr = espExpr.substring(0, espExpr.length() - 1);
        }
        return espExpr;
    }

    private static String getRptItemNumOfAcctItem(Expression formulaExpr, int index) {
        FunctionExpr fExpr = (FunctionExpr)formulaExpr;
        if (fExpr.parameters.get(index) instanceof StringExpr) {
            return ((StringExpr)fExpr.parameters.get(index)).toString().replaceAll("\"", "");
        }
        if (fExpr.parameters.get(index) instanceof String) {
            return ((String)fExpr.parameters.get(index)).replaceAll("\"", "");
        }
        return "";
    }

    public static void constructFirstPeriodFormula(List formulas, Map keyDateMap, Expression expr, Map params, String formulaKey, int year, int period, RptPeriodTypeEnum periodType, Date firstPeriodDate) throws EASBizException, BOSException {
        String key = (String)params.get("KEY_COMPANY_ID") + (String)params.get("KEY_TARGETCOMPANY_ID");
        if (!keyDateMap.containsKey(key)) {
            return;
        }
        if (expr instanceof BinaryOperationExpr) {
            Expression formulaExpr = ((BinaryOperationExpr)expr).left;
            if (period == 1) {
                StringExpr se = new StringExpr("YTBEGIN");
                FormulaUtil.setParams4FormulaExpr(formulaExpr, 11, se);
                String[] arrformula = new String[]{formulaKey, "-" + expr.toString()};
                formulas.add(arrformula);
            } else {
                if (firstPeriodDate == null) {
                    firstPeriodDate = RPTDateUtil.getPeriodLastDate(year, 1, periodType);
                }
                params.put("Day", RPTDateUtil.formateDate(firstPeriodDate, "yyyy-MM-dd"));
                params.put("Period", new Integer(1));
                params.put("isNew", false);
                Expression temp = FormulaUtil.fillFormulas(expr, params);
                String[] arrformula = new String[]{formulaKey, temp.toString()};
                formulas.add(arrformula);
                StringExpr se = new StringExpr("YTBEGIN");
                FormulaUtil.setParams4FormulaExpr(formulaExpr, 11, se);
                arrformula = new String[]{formulaKey, "-" + temp.toString()};
                formulas.add(arrformula);
            }
        }
    }

    private static void setParams4FormulaExpr(Expression formulaExpr, int index, Object param) {
        if (formulaExpr instanceof UnaryOperationExpr) {
            ((FunctionExpr)((UnaryOperationExpr)formulaExpr).operand).parameters.set(11, param);
        } else {
            ((FunctionExpr)formulaExpr).parameters.set(11, param);
        }
    }

    public static Book putFormulaToTable(List Formulas, Book book, Context ctx) throws EASBizException, BOSException {
        Sheet sheet = book.getSheet(0);
        int row = sheet.getMaxRowIndex() + 1;
        for (String[] formula : Formulas) {
            if (!RptUtil.isFormulaValid((String)formula[1], (Sheet)sheet)) {
                throw new EASBizException(new NumericExceptionSubItem("1", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"125_CheckFormulaControllerBean", (Locale)ctx.getOriginLocale()) + formula[1] + ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"212_FormulaUtil", (Locale)ctx.getOriginLocale())));
            }
            sheet.getRange(row, 1).setFormula("=" + formula[1]);
            sheet.getRange(row, 0).setValue(new Variant((Object)formula[0]));
            ++row;
        }
        return book;
    }

    public static Map getResult(Book table, Context ctx, CurrencyInfo currency) throws EASBizException, BOSException {
        return FormulaUtil.getResult(table, ctx, currency, false);
    }

    public static Map getResult(Book table, Context ctx, CurrencyInfo currency, boolean isCheckESP) throws EASBizException, BOSException {
        table.calc();
        Sheet sheet = table.getSheet(0);
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
        int Precision = 2;
        if (currency != null) {
            Precision = currency.getPrecision();
        }
        for (int m = 0; m <= sheet.getMaxRowIndex(); ++m) {
            BigDecimal value;
            String formula;
            Variant objValue = sheet.getRange(m, 1).getValue();
            if (objValue == null || objValue.isNull()) {
                objValue = new Variant((Object)CslConstant.BGZERO);
            }
            String key = sheet.getRange(m, 0).getValue().toString();
            if (DebugLogger.isDebug) {
                FormulaUtil.printStrack(sheet.getRange(m, 1).getFormula(), objValue, key);
            }
            if (objValue.isString() || objValue.isError()) {
                logger.info((Object)sheet.getRange(m, 1).getFormula());
                logger.error((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"213_FormulaUtil", (Locale)ctx.getOriginLocale()) + objValue.getVtAsString()));
                throw new EASBizException(new NumericExceptionSubItem("1011", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"214_FormulaUtil", (Locale)ctx.getOriginLocale()) + ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"215_FormulaUtil", (Locale)ctx.getOriginLocale()) + sheet.getRange(m, 1).getFormula() + ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"216_FormulaUtil", (Locale)ctx.getOriginLocale()) + objValue.getValue()));
            }
            BigDecimal lValue = CslRptUtil.toBigDecimal(objValue).setScale(Precision, 4);
            if (isCheckESP && (formula = sheet.getRange(m, 1).getFormula()) != null && formula.contains("ESP")) {
                lValue = CslRptUtil.toBigDecimal(objValue).setScale(Precision + 2, 4);
            }
            if (result.containsKey(key)) {
                value = (BigDecimal)result.get(key);
                value = value.add(lValue);
            } else {
                value = lValue;
            }
            result.put(key, value);
        }
        return result;
    }

    private static void printStrack(String formula, Variant objValue, String key) {
        logger.error((Object)("NewInvestEliminateLog:key=" + key + " Formula =" + formula + ";value = " + objValue + "\r\n"));
    }

    public static Book initBook(Context ctx, CslReportInfo rptInfo) throws BOSException {
        int i;
        Book book = Book.Manager.getNewBook(null, (int)1);
        FunctionManager fm = book.getDeps().getFunctionManager();
        ReportCalculateErrorProvider errorhandler = BookProperties.loadFromBook((Book)book).getErrorProvider();
        if (errorhandler != null) {
            fm.setErrorProvider(Exception.class, (IErrorProvider)errorhandler);
        }
        ReportCalculateErrorProvider.clear();
        ReportCalculateErrorProvider.addErrorProvider(EASBizException.class, (IErrorProvider)errorhandler);
        ReportCalculateContext calcContext = new ReportCalculateContext(ctx);
        calcContext.setReportAdapter((IReportPropertyAdapter)new CSLPropertyAdapter(rptInfo, ctx));
        calcContext.setErrorProvider((IErrorProvider)errorhandler);
        RptSheetParamCollection param = rptInfo.getSheetParam();
        ReportVariables iv = new ReportVariables();
        for (i = 0; param != null && i < param.size(); ++i) {
            ReportVariables variables = VariablesHelper.sheetParams2Variables((RptSheetParamInfo)param.get(i), (RptPeriodTypeEnum)rptInfo.getPeriodType());
            iv.addAll(variables, false);
        }
        for (i = 0; i < iv.getAllVariables().size(); ++i) {
            ((VariableEntry)iv.getAllVariables().get(i)).setSheetName(book.getSheet(0).getSheetName());
        }
        calcContext.setReportVariables(iv);
        try {
            FormulaUtil.registerFormulaToBook((ICalculateContextProvider)calcContext, fm);
        }
        catch (Exception e) {
            logger.error((Object)"registerFormulaToBook: ", (Throwable)e);
        }
        book.setCalculate(false);
        return book;
    }

    public static void registerFormulaToBook(ICalculateContextProvider context, FunctionManager fm) throws Exception {
        List implClass = FormulaDefinition.getInstance().getImplClass();
        for (int i = 0; i < implClass.size(); ++i) {
            String cname = (String)implClass.get(i);
            Class<?> clazz = Class.forName(cname);
            Object obj = clazz.newInstance();
            if (obj instanceof ICalculator) {
                ((ICalculator)obj).initCalculateContext(context);
            }
            fm.addFunctionProvider(obj, true);
        }
        List batchImplClass = FormulaDefinition.getInstance().getBatchImplClass();
        for (int i = 0; i < batchImplClass.size(); ++i) {
            String cname = (String)batchImplClass.get(i);
            Class<?> clazz = Class.forName(cname);
            Object obj = clazz.newInstance();
            if (obj instanceof ICalculator) {
                ((ICalculator)obj).initCalculateContext(context);
            }
            fm.addFunctionProvider(obj, true);
        }
    }

    public static void main(String[] args) throws Exception {
        String formula = "(AcctItem(\"\",\"\",\"\",\"\",\"X\",\"X\",\"MONTHLY\",0,0,0,\"COMMITREPORT\",\"ENDBALANCE\",\"MONEY\",false,false)-AcctItem(\"\",\"\",\"\",\"\",\"X\",\"X\",\"MONTHLY\",0,0,0,\"COMMITREPORT\",\"ENDBALANCE\",\"MONEY\",false,false))*ESP(\"\",\"\",\"\",\"MONTHLY\",0,0,\"\")";
        String formula2 = "--AcctItem(\"\",\"\",\"\",\"\",\"X\",\"X\",\"MONTHLY\",0,0,0,\"COMMITREPORT\",\"ENDBALANCE\",\"MONEY\",false,false))*ESP(\"\",\"\",\"\",\"MONTHLY\",0,0,\"\")";
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("AdjustElimType", "1");
        Expression exp = ExcelFormulaPaserHelper.parse((String)formula2);
        int type = FormulaUtil.getBranchCalculateType(exp, params);
        logger.info((Object)String.valueOf(type));
    }

    public static class BranchCalTypeDefined {
        public static final int BRANCH_NONE = 0;
        public static final int BRANCH_YTDAMOUNT = 1;
        public static final int BRANCH_ENDBALANCE = 2;
    }
}

