/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.ElimInvestRateCollection;
import com.kingdee.eas.fi.gr.cslrpt.ElimInvestRateFactory;
import com.kingdee.eas.fi.gr.cslrpt.ElimInvestRateInfo;
import com.kingdee.eas.fi.gr.cslrpt.MergeModeEnum;
import com.kingdee.eas.fi.gr.cslrpt.app.CalculateEquivShareRateHelper;
import com.kingdee.eas.fi.gr.cslrpt.app.ElimInvestRateGenerateHandle;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.batch.OneToManyMap;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class GenerateElimInvestRateInDirectHelper {
    private final Context _ctx;
    private final Map _params;
    private OneToManyMap shareRelaMap;
    private CompanyOrgUnitInfo HoldingCompany;
    private FullOrgUnitInfo topUnit;
    private MergeModeEnum mergeMode;
    private String tempTblName;
    private Logger logger = Logger.getLogger(GenerateElimInvestRateInDirectHelper.class);

    public GenerateElimInvestRateInDirectHelper(Context ctx, Map params, MergeModeEnum mergeMode) {
        this._ctx = ctx;
        this._params = params;
        this.mergeMode = mergeMode;
    }

    public void generateElimInvestRate() throws EASBizException, BOSException {
        this.HoldingCompany = this.getTopHoldingCompany();
        this.InitRelaRateByHoldingCompany();
        Map newElimRate = this.transformRelaRate2ElimInvestRate();
        this.handleElimInvestRateRecord(newElimRate);
        ArrayList IDs = new ArrayList();
        this.getLatestRateIDs(IDs);
        this.calculateEquiveRate(IDs);
        this.synchronizedRateVal();
        this.shareRelaMap.clear();
    }

    private void handleElimInvestRateRecord(Map newElimRate) throws BOSException, EASBizException {
        ElimInvestRateGenerateHandle handle = new ElimInvestRateGenerateHandle(this._ctx, this._params, newElimRate, this.mergeMode);
        handle.sortElimInvestRateOprt();
        handle.generateElimRateRecords();
        handle.clear();
    }

    private void calculateEquiveRate(List IDs) throws EASBizException, BOSException {
        CalculateEquivShareRateHelper helper = new CalculateEquivShareRateHelper(IDs, this._params, this._ctx);
        helper.calculate();
    }

    private Map transformRelaRate2ElimInvestRate() throws BOSException {
        HashMap<String, ElimInvestRateInfo> investRelation = new HashMap<String, ElimInvestRateInfo>();
        FullOrgUnitInfo company = new FullOrgUnitInfo();
        company.setId(this.HoldingCompany.getId());
        for (Map.Entry entry : this.shareRelaMap.entrySet()) {
            String key = (String)entry.getKey();
            List value = (List)entry.getValue();
            if (value == null) continue;
            int size = value.size();
            for (int k = 0; k < size; ++k) {
                ShareRela2Info info = (ShareRela2Info)value.get(k);
                ElimInvestRateInfo rateInfo = new ElimInvestRateInfo();
                rateInfo.setCompany(company);
                FullOrgUnitInfo targetCompany = new FullOrgUnitInfo();
                targetCompany.setId(BOSUuid.read((String)info.getInvesteeCompany()));
                rateInfo.setTargetCompany(targetCompany);
                rateInfo.setRate(null);
                rateInfo.setYear(this.getYear());
                rateInfo.setPeriodType(this.getPeriodType());
                rateInfo.setPeriod(this.getPeriod());
                rateInfo.setDate(this.getRptDateInfo());
                rateInfo.setRptDate(this.getRptDateInfo());
                rateInfo.setOrgBound(this.getOrgTreeInfo());
                rateInfo.setOrgUnit((FullOrgUnitInfo)this.getOrgUnitInfo());
                rateInfo.setIsMonthLatest(true);
                rateInfo.setIsLatest(true);
                key = key + info.getInvesteeCompany();
                investRelation.put(key, rateInfo);
            }
        }
        return investRelation;
    }

    private CompanyOrgUnitInfo getTopHoldingCompany() throws BOSException, EASBizException {
        this.topUnit = this.getTopUnit(this._ctx, this.getOrgTreeInfo());
        CompanyOrgUnitInfo holdingCompany = this.topUnit.getPartUnionGroup().getStockControlCompany();
        if (null == holdingCompany) {
            throw new ReportException(ReportException.HOLDING_COMPANY_NULL, new Object[]{this.topUnit.getName()});
        }
        return holdingCompany;
    }

    private FullOrgUnitInfo getTopUnit(Context ctx, OrgTreeInfo orgBound) throws BOSException, EASBizException {
        IOrgStructure iStruct = OrgStructureFactory.getLocalInstance((Context)ctx);
        OrgStructureCollection col = iStruct.getOrgStructureCollection("select id,name,,unit,unit.id,unit.name, unit.partUnionGroup,unit.partUnionGroup.id,unit.partUnionGroup.stockControlCompany,unit.partUnionGroup.stockControlCompany.id,unit.partUnionGroup.stockControlCompany.name where parent = null and tree.id = '" + orgBound.getId().toString() + "'");
        if (null == col || 0 == col.size()) {
            return null;
        }
        OrgStructureInfo structureInfo = col.get(0);
        FullOrgUnitInfo unit = structureInfo.getUnit();
        return unit;
    }

    public void InitRelaRateByHoldingCompany() throws BOSException {
        this.shareRelaMap = new OneToManyMap();
        String topHolderComp = this.HoldingCompany.getId().toString();
        HashSet targCompanys = new HashSet();
        ArrayList investRelaTbl = new ArrayList();
        Connection con = null;
        PreparedStatement ps = null;
        try {
            this.insertInvestRateRecord2Tmptbl();
            String preSql = "select companyId,targCompanyId,rate from " + this.tempTblName + " where CompanyId = ? ";
            con = EJBFactory.getConnection((Context)this._ctx);
            ps = con.prepareStatement(preSql);
            this.cycleCollectInvestRate(ps, 0, topHolderComp, targCompanys, investRelaTbl);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            this.releaseTempTble();
        }
        for (String InvesteeComp : targCompanys) {
            ShareRela2Info sharerelaInfo = new ShareRela2Info(InvesteeComp);
            this.shareRelaMap.put((Object)topHolderComp, (Object)sharerelaInfo);
        }
    }

    private void insertInvestRateRecord2Tmptbl() throws Exception {
        StringBuffer sql = new StringBuffer(400);
        sql.append(" Select rela.FShareHolderId,rela.FInvesteeCompanyId,rela.FShareScale,rela.FChangeDate \n").append(" from t_org_tree tree \t\t\t\t\t\t\t\t\t\t\t\t         \t       \n").append(" join t_org_structure s on tree.Fid = s.FTreeId \t\t\t\t\t         \t       \n").append(" join t_org_BaseUnit unit on unit.Fid = s.FUnitId \t\t\t\t\t         \t       \n").append(" join t_csl_ShareRela rela on unit.FId = rela.FInvesteeCompanyId \t\t               \n").append(" join (select r.FshareHolderId shareHolderId,                                         \n").append(" r.FInvesteeCompanyId InvesteeCompanyId,max(r.fchangeDate) changeDate                 \n").append(" from t_csl_shareRela r \t\t\t\t\t\t\t\t\t\t\t\t\t           \n").append(" where  r.fisout = 0 and r.fchangedate <= ? \t\t\t\t\t\t\t\t           \n").append(" group by  r.FshareHolderId,r.FInvesteeCompanyId ) t2\t\t\t\t\t\t           \n").append(" on rela.FshareHolderId=t2.shareHolderId \t\t\t\t\t\t\t\t               \n").append(" and rela.FInvesteeCompanyId= t2.InvesteeCompanyId                                    \n").append(" and rela.fchangeDate = t2.changeDate                                                 \n").append(" join (select unit1.Fid shareHolderId from t_org_Tree tree1                           \n").append(" join t_org_structure s1 on tree1.Fid = s1.FtreeId                                    \n").append(" join t_org_baseunit unit1 on s1.FunitId = unit1.Fid                                  \n").append(" where tree1.Fid = ? ) holderComp                                                     \n").append(" on holderComp.shareHolderId = rela.FShareHolderId                                    \n").append(" where tree.Fid = ? and unit.FIsCompanyOrgUnit = 1  \t\t\t\t\t\t           \n").append(" and tree.FType = 8 and rela.FIsOut = 0 and rela.FChangeDate <= ?   \t\t           \n");
        ArrayList<Object> params = new ArrayList<Object>(4);
        params.add(new Timestamp(this.getRptDateInfo().getTime()));
        params.add(this.getOrgTreeInfo().getId().toString());
        params.add(this.getOrgTreeInfo().getId().toString());
        params.add(new Timestamp(this.getRptDateInfo().getTime()));
        this.createTemTbl();
        StringBuffer sb = new StringBuffer();
        sb.append("insert into ").append(this.tempTblName).append("\n").append(sql.toString());
        DbUtil.execute((Context)this._ctx, (String)sb.toString(), (Object[])params.toArray());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void cycleCollectInvestRate(PreparedStatement ps, int level, String currCompanyId, Set result, List investRelaTbl) throws BOSException, EASBizException {
        String tempCompanyId = currCompanyId;
        ResultSet rs = null;
        try {
            ps.clearParameters();
            ps.setString(1, BOSUuid.read((String)tempCompanyId).toString());
            rs = ps.executeQuery();
            ArrayList<String> tempMap = new ArrayList<String>();
            while (rs.next()) {
                String tempTarg = rs.getString("targCompanyId");
                tempMap.add(tempTarg);
                result.add(tempTarg);
            }
            if (tempCompanyId.equals(this.HoldingCompany.getId().toString()) && tempMap.isEmpty()) {
                throw new ReportException(ReportException.HOLDING_COMPANY_RATE_NULL, new Object[]{this.topUnit.getName(), this.HoldingCompany.getName()});
            }
            String tempTargCompany = null;
            String key = null;
            Iterator it = tempMap.iterator();
            while (it.hasNext()) {
                if (level == 0) {
                    investRelaTbl.clear();
                }
                tempTargCompany = (String)it.next();
                key = currCompanyId + tempTargCompany;
                if (!investRelaTbl.contains(key)) {
                    investRelaTbl.add(key);
                    this.cycleCollectInvestRate(ps, level + 1, tempTargCompany, result, investRelaTbl);
                }
            }
        }
        catch (SQLException e) {
            try {
                this.logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"774_GenerateElimInvestRateInDirectHelper", (Locale)this._ctx.getOriginLocale()) + e));
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, null, null);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, null, null);
        return;
        SQLUtils.cleanup((ResultSet)rs, null, null);
    }

    private void createTemTbl() throws Exception {
        StringBuffer createSql = new StringBuffer();
        String tempTblName = "T_CSL_ELIMINVESTRATE_001";
        createSql.append("create table ").append(tempTblName).append("(companyId varchar(44),targCompanyId varchar(44),rate NUMERIC(21,15),changeDate DateTime)");
        TempTablePool pool = TempTablePool.getInstance((Context)this._ctx);
        this.tempTblName = tempTblName = pool.createTempTable(createSql.toString());
    }

    private void getLatestRateIDs(List IDs) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add("id");
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("rptDate", (Object)new Timestamp(this.getRptDateInfo().getTime())));
        filterInfo.getFilterItems().add(new FilterItemInfo("orgBound.id", (Object)this.getOrgTreeInfo().getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)this.getOrgUnitInfo().getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("isLatest", (Object)new Integer(1)));
        RptPeriodTypeEnum rptType = this.getPeriodType();
        if (rptType != null && RptPeriodTypeEnum.MONTHLY.equals((Object)rptType)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("period", (Object)new Integer(this.getPeriod())));
        }
        view.setFilter(filterInfo);
        view.setSelector(selectorItemCollection);
        ElimInvestRateCollection col = ElimInvestRateFactory.getLocalInstance(this._ctx).getElimInvestRateCollection(view);
        Iterator it = col.iterator();
        while (it.hasNext()) {
            IDs.add(((ElimInvestRateInfo)it.next()).getId().toString());
        }
    }

    private void synchronizedRateVal() throws BOSException {
        StringBuffer sql = new StringBuffer();
        ArrayList<Object> params = new ArrayList<Object>();
        sql.append(" update T_Csl_ElimInvestRate set FRate = FEquivRate     \n").append(" where ForgBoundId = ? and FOrgUnit = ?  and FYear = ?  \n").append(" and FperiodType = ? and Fperiod = ? ");
        params.add(this.getOrgTreeInfo().getId().toString());
        params.add(this.getOrgUnitInfo().getId().toString());
        params.add(new Integer(this.getYear()));
        params.add(new Integer(this.getPeriodType().getValue()));
        params.add(new Integer(this.getPeriod()));
        DbUtil.execute((Context)this._ctx, (String)sql.toString(), (Object[])params.toArray());
    }

    private OrgTreeInfo getOrgTreeInfo() {
        return (OrgTreeInfo)this._params.get("orgBound");
    }

    private OrgUnitInfo getOrgUnitInfo() {
        return (OrgUnitInfo)this._params.get("orgUnit");
    }

    private Date getRptDateInfo() {
        return (Date)this._params.get("reportDate");
    }

    private int getYear() {
        return (Integer)this._params.get("rptYear");
    }

    private RptPeriodTypeEnum getPeriodType() {
        return (RptPeriodTypeEnum)this._params.get("rptPeriodType");
    }

    private int getPeriod() {
        return (Integer)this._params.get("rptPeriod");
    }

    private void releaseTempTble() {
        TempTablePool.getInstance((Context)this._ctx).releaseTable(this.tempTblName);
    }

    class ShareRela2Info {
        private BigDecimal _shareScale;
        private Date _changeDate;
        private String _InvesteeCompany;

        public ShareRela2Info(String InvesteeCompany) {
            this._shareScale = new BigDecimal("0");
            this._changeDate = null;
            this._InvesteeCompany = InvesteeCompany;
        }

        public ShareRela2Info(BigDecimal shareScale, Date changeDate, String InvesteeCompany) {
            this._shareScale = shareScale;
            this._changeDate = changeDate;
            this._InvesteeCompany = InvesteeCompany;
        }

        public BigDecimal getShareScale() {
            return this._shareScale;
        }

        public Date getChangeDate() {
            return this._changeDate;
        }

        public String getInvesteeCompany() {
            return this._InvesteeCompany;
        }
    }
}

