/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ElimTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.InterCheckSolutionEntryCollection;
import com.kingdee.eas.fi.gr.cslrpt.InterCheckSolutionEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.InterCheckSolutionFactory;
import com.kingdee.eas.fi.gr.cslrpt.InterCheckSolutionInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.AbstractInterDataProviderControllerBean;
import com.kingdee.eas.fi.gr.cslrpt.app.QueryHisBudgetUtils;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ColumnInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ParamTempTblService;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.TableInfo;
import com.kingdee.eas.fi.gr.cslrpt.util.RelatingAdjustElimHelper;
import com.kingdee.eas.fi.gr.cslrpt.util.RptProperties;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.samecontrol.SameControlUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class InterDataProviderControllerBean
extends AbstractInterDataProviderControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.cslrpt.app.InterDataProviderControllerBean");

    @Override
    protected RptRowSet _getCAGItemData(Context ctx, RptProperties params) throws BOSException, EASBizException {
        this.updateInterItemData(ctx);
        int from = params.getInt("from");
        int length = params.getInt("length");
        String tempTable = params.getString("tempTable");
        RptRowSet rst = null;
        Connection con = null;
        SqlParams sp = new SqlParams();
        StringBuffer sqlBuffer = new StringBuffer(100);
        sqlBuffer.append("select FCompany,FTargetCompany,FItemNumber,FItemName,FDataElement,FromCurrency,").append("FTargetCurrency,BeforeAdjustData,adjustData,afterAdjustData,FID,FPrecision,").append("DataCollectName,FimpName from ").append(tempTable);
        sqlBuffer.append(" ORDER BY FromCurrency, FCompany, FTargetCompany, FItemNumber, FDataElement");
        try {
            con = this.getConnection(ctx);
            rst = DBUtil.executeQuery((String)sqlBuffer.toString(), (SqlParams)sp, (int)from, (int)length, (Connection)con);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
        return rst;
    }

    private void updateInterItemData(Context ctx) throws BOSException, EASBizException {
        String sql = "select FId, FOrgBoundID, FReport from t_csl_interItemData where FSourceType = 2 and FImportedGroup is null";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            sql = "Update t_csl_interItemData set FImportedGroup = ? where FId = ?";
            HashMap<String, String> cache = new HashMap<String, String>();
            while (rowSet.next()) {
                String id = rowSet.getString("FId");
                String treeId = rowSet.getString("FOrgBoundID");
                String reportId = rowSet.getString("FReport");
                String groupId = (String)cache.get(treeId + "-" + reportId);
                if (groupId == null) {
                    groupId = this.getCurGroup(ctx, treeId, reportId);
                    cache.put(treeId + "-" + reportId, groupId);
                }
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{groupId, id});
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private String getCurGroup(Context ctx, String treeId, String reportId) throws EASBizException, BOSException {
        CslReportInfo report = CslReportFactory.getLocalInstance(ctx).getCslReportInfo("select orgUnit.id, orgUnit.isGrouping where id = '" + reportId + "'");
        if (report == null) {
            String oql = "select unit.id where tree.id = '" + treeId + "' and level = 1";
            OrgStructureInfo stru = OrgStructureFactory.getLocalInstance((Context)ctx).getOrgStructureInfo(oql);
            return stru.getUnit().getId().toString();
        }
        String unitId = report.getOrgUnit().getId().toString();
        if (report.getOrgUnit().isIsGrouping()) {
            return unitId;
        }
        String oql = "select parent.* where tree.id = '" + treeId + "' and unit.id = '" + unitId + "'";
        OrgStructureInfo stru = OrgStructureFactory.getLocalInstance((Context)ctx).getOrgStructureInfo(oql);
        return stru.getParent().getUnit().getId().toString();
    }

    private StringBuffer getParamCompanyUnionSql(Context ctx, String treeId, String longNumber, int level, String tableAliasNames) throws BOSException, EASBizException {
        StringBuffer sbSQL = null;
        sbSQL = new StringBuffer();
        sbSQL.append(" select distinct t1.FLongNumber \r\n");
        sbSQL.append(" from t_org_structure t1 join t_org_baseunit t2 on t1.FUnitId=t2.FId \r\n");
        sbSQL.append(" where t1.FTreeId = '").append(treeId).append("'");
        sbSQL.append(" And t1.FLongNumber like '").append(longNumber).append("%'");
        sbSQL.append(" And t1.FLevel = ").append(level + 1);
        sbSQL.append(" And t2.FIsCompanyOrgUnit = 0");
        IRowSet rsTemp = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString());
        StringBuffer rtSql = new StringBuffer();
        String[] tbNames = tableAliasNames.split(";");
        String t1 = tbNames[0];
        String t2 = tbNames.length > 1 ? tbNames[1] : t1;
        String filed = tbNames.length > 1 ? "FLongNumber" : "FTargetLongNumber";
        try {
            while (rsTemp.next()) {
                rtSql.append(" and (Left(Replace(").append(t1).append(".FLongNumber,'").append(rsTemp.getString("FLongNumber")).append("!','@#$'),3)<>'@#$' \r\n");
                rtSql.append(" or Left(Replace(").append(t2).append(".").append(filed).append(",'").append(rsTemp.getString("FLongNumber")).append("!','@#$'),3)<>'@#$'");
                rtSql.append(" ) \r\n ");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return rtSql;
    }

    @Override
    protected RptRowSet _getExchItemData(Context ctx, RptProperties params) throws BOSException, EASBizException {
        this.updateExchItemData(ctx);
        int from = params.getInt("from");
        int length = params.getInt("length");
        String tempTable = params.getString("tempTable");
        RptRowSet rst = null;
        Connection con = null;
        SqlParams sp = new SqlParams();
        StringBuffer sqlBuffer = new StringBuffer(100);
        sqlBuffer.append("select FCompany,FTargetCompany,FItemNumber,FItemName,FDataElement,FromCurrency,").append("FTargetCurrency,BeforeAdjustData,adjustData,afterAdjustData,FID,FPrecision,").append("FDataCollectName,FimpName from ").append(tempTable);
        sqlBuffer.append(" ORDER BY FromCurrency, FCompany, FTargetCompany, FItemNumber, FDataElement");
        try {
            con = this.getConnection(ctx);
            rst = DBUtil.executeQuery((String)sqlBuffer.toString(), (SqlParams)sp, (int)from, (int)length, (Connection)con);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
        return rst;
    }

    protected RptRowSet getAllIds(Context ctx, RptProperties params, boolean isInterAndExch) throws BOSException, EASBizException {
        block6: {
            StringBuffer sqlBuffer = new StringBuffer();
            String tempTable = params.getString("tempTable");
            RptRowSet rst = null;
            Connection con = null;
            if (!params.containsKey("isGetAllIds") || !params.getBoolean("isGetAllIds")) break block6;
            try {
                sqlBuffer.append("select distinct fid,fnumber,fconfirmstatus ");
                if (isInterAndExch) {
                    sqlBuffer.append(",felimtype");
                }
                sqlBuffer.append(" from ").append(tempTable);
                sqlBuffer.append(" order by fnumber ");
                con = this.getConnection(ctx);
                rst = DBUtil.executeQuery((String)sqlBuffer.toString(), (Connection)con);
            }
            catch (Exception e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(con);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Connection)con);
            if (rst == null) {
                rst = new RptRowSet();
            }
            return rst;
        }
        return null;
    }

    @Override
    protected RptRowSet _getExchCheckData(Context ctx, RptProperties params) throws BOSException, EASBizException {
        RptRowSet allIds;
        boolean isInterAndExch = false;
        if (params.containsKey("isInterAndExch")) {
            isInterAndExch = params.getBoolean("isInterAndExch");
        }
        if ((allIds = this.getAllIds(ctx, params, isInterAndExch)) != null) {
            return allIds;
        }
        int from = params.getInt("from");
        int length = params.getInt("length");
        String tempTable = params.getString("tempTable");
        boolean isFastMerge = params.getBoolean("isFastMerge");
        Collection ids = params.getCollection("ids");
        if (!isFastMerge && ids != null && !ids.isEmpty()) {
            RptProperties preperties = this.prepareFetchExchChkageDataToTmpTbl(ctx, params);
            tempTable = preperties.getString("tempTable");
            from = 0;
        } else if (StringUtils.isEmpty((String)tempTable)) {
            this._prepareFetchExchItemData(ctx, params);
        }
        boolean isQueryHisBudget = params.getBoolean("isQueryHisBudget");
        RptRowSet rst = null;
        Connection con = null;
        SqlParams sp = new SqlParams();
        StringBuffer sqlBuffer = new StringBuffer();
        String sortNumber = "z999999999";
        String sortID = "zzzzzzzzzzzz";
        String decimal = "0E-13";
        if (isFastMerge) {
            boolean isHandleAll = params.containsKey("isHandleAll");
            sqlBuffer.append(" select fid,fnumber from (");
            sqlBuffer.append("select fid,fnumber, fvalidebit = isnull(SUM(fvalidebit),0), fvalicredit = isnull(SUM(fvalicredit),0) \n");
            sqlBuffer.append("   from ").append(tempTable).append(" group by fid,fnumber) tab \n");
            sqlBuffer.append("where  ").append(isHandleAll ? "fvalidebit<>fvalicredit" : "fvalidebit=fvalicredit");
            try {
                con = this.getConnection(ctx);
                rst = isHandleAll ? DBUtil.executeQuery((String)sqlBuffer.toString(), (Connection)con) : DBUtil.executeQuery((String)sqlBuffer.toString(), (SqlParams)sp, (int)from, (int)length, (Connection)con);
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            finally {
                SQLUtils.cleanup((Connection)con);
            }
            return rst;
        }
        sqlBuffer.append("select * from (");
        sqlBuffer.append("select fid,fnumber,felimtemplet,fcurrency,fcompany,ftargetcompany,fitemnumber,     \n");
        sqlBuffer.append("fitemname,fdataelement,fbeforeAdjustData,fadjustdata,fdebit,fcredit,fvalidebit,fvalicredit,fdiff,             \n");
        sqlBuffer.append("fdiffmode,fcheckperson,fcheckdate,fconfirmstatus,fconfirmperson,fconfirmdate,fremark,         \n");
        sqlBuffer.append("fsingledc,fcurrencyprecision,FDataCollect,fitemDC,fassessor,fassessDate, fauditPartyId,fauditPartyName,fconfirmDiff,flimitAmount \n");
        sqlBuffer.append(" from ").append(tempTable).append("\n");
        sqlBuffer.append(" union    \n");
        sqlBuffer.append(" select 'zzzzzzzzzzzz' fid,case when fnumber is null then N'z999999999' else fnumber end fnumber,null felimtemplet,null fcurrency,null fcompany,                 \n");
        sqlBuffer.append(" null ftargetcompany,null fitemnumber,null fitemname,0 fdataelement,          \n");
        if (!isQueryHisBudget) {
            sqlBuffer.append(" fbeforeAdjustData=isnull(SUM(fbeforeAdjustData),0), fadjustdata=isnull(SUM(fadjustdata),0),  \n");
        } else {
            sqlBuffer.append(" null fbeforeAdjustData, null  fadjustdata,  \n");
        }
        sqlBuffer.append(" fdebit=isnull(SUM(fdebit),0),fcredit = isnull(SUM(fcredit),0),fvalidebit = isnull(SUM(fvalidebit),0),          \n");
        sqlBuffer.append(" fvalicredit = isnull(SUM(fvalicredit),0),fdiff = isnull(SUM(fdiff)/COUNT(FNUMBER),0),0 fdiffmode,                \n");
        sqlBuffer.append(" null fcheckperson,null fcheckdate,0 fconfirmstatus,                           \n");
        sqlBuffer.append(" null fconfirmperson,null fconfirmdate,null fremark,0 fsingledc,0 fcurrencyprecision,null FDataCollect,3 fitemDC,  \n");
        sqlBuffer.append(" null fassessor,null fassessDate, null fauditPartyId, null fauditPartyName,fconfirmDiff = isnull(SUM(fconfirmDiff)/COUNT(FNUMBER),0),0 flimitAmount \n");
        sqlBuffer.append(" from ").append(tempTable).append("\n");
        sqlBuffer.append(" group by fnumber with rollup ) total   \n");
        sqlBuffer.append(" order by fnumber ASC, fid, fitemnumber");
        try {
            con = this.getConnection(ctx);
            rst = DBUtil.executeQuery((String)sqlBuffer.toString(), (SqlParams)sp, (int)from, (int)length, (Connection)con);
            if (rst.next() && rst.getRowCount() == 1 && sortID.equals(rst.getString("fid")) && sortNumber.equals(rst.getString("fnumber")) && BigDecimal.ZERO.compareTo(rst.getBigDecimal("fdebit")) == 0 && BigDecimal.ZERO.compareTo(rst.getBigDecimal("fcredit")) == 0 && BigDecimal.ZERO.compareTo(rst.getBigDecimal("fvalidebit")) == 0 && BigDecimal.ZERO.compareTo(rst.getBigDecimal("fvalicredit")) == 0 && BigDecimal.ZERO.compareTo(rst.getBigDecimal("fdiff")) == 0 && BigDecimal.ZERO.compareTo(rst.getBigDecimal("fconfirmDiff")) == 0) {
                rst = DBUtil.executeQuery((String)("select * from " + tempTable + " where 1=2 "), (SqlParams)sp, (int)from, (int)length, (Connection)con);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
        return rst;
    }

    @Override
    protected RptRowSet _getCAGCheckData(Context ctx, RptProperties params) throws BOSException, EASBizException {
        RptRowSet allIds;
        boolean isInterAndExch = false;
        if (params.containsKey("isInterAndExch")) {
            isInterAndExch = params.getBoolean("isInterAndExch");
        }
        if ((allIds = this.getAllIds(ctx, params, isInterAndExch)) != null) {
            return allIds;
        }
        int from = params.getInt("from");
        int length = params.getInt("length");
        String tempTable = params.getString("tempTable");
        String prmpCompanyId = params.getString("companyId");
        boolean isQueryHisBudget = params.getBoolean("isQueryHisBudget");
        RptRowSet rst = null;
        Connection con = null;
        SqlParams sp = new SqlParams();
        StringBuffer sqlBuffer = new StringBuffer();
        String sortNumber = "z999999999";
        String sortID = "zzzzzzzzzzzz";
        String decimal = "0E-13";
        boolean isFastMerge = params.getBoolean("isFastMerge");
        if (isFastMerge) {
            boolean isHandleAll = params.containsKey("isHandleAll");
            sqlBuffer.append(" select fid,fnumber from (");
            sqlBuffer.append("select fid,fnumber, fvalidebit = isnull(SUM(fvalidebit),0), fvalicredit = isnull(SUM(fvalicredit),0) \n");
            sqlBuffer.append("   from ").append(tempTable).append(" group by fid,fnumber ) tab \n");
            sqlBuffer.append("where  ").append(isHandleAll ? "fvalidebit<>fvalicredit" : "fvalidebit=fvalicredit");
            try {
                con = this.getConnection(ctx);
                rst = isHandleAll ? DBUtil.executeQuery((String)sqlBuffer.toString(), (Connection)con) : DBUtil.executeQuery((String)sqlBuffer.toString(), (SqlParams)sp, (int)from, (int)length, (Connection)con);
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            finally {
                SQLUtils.cleanup((Connection)con);
            }
            return rst;
        }
        Collection ids = params.getCollection("ids");
        if (ids != null && !ids.isEmpty()) {
            RptProperties preperties = this.prepareFetchInterCheckDataToTmptbl(ctx, params);
            tempTable = preperties.getString("tempTable");
            from = 0;
        }
        sqlBuffer.append("select * from (");
        sqlBuffer.append("select fid,fnumber,felimtemplet,felimtype,fcurrency,fcompany,ftargetcompany,fitemnumber,     \n");
        sqlBuffer.append("fitemname,fdataelement,fbeforeAdjustData,fadjustdata,fdebit,fcredit,fvalidebit,fvalicredit,fdiff, \n");
        sqlBuffer.append("fdiffmode,fcheckperson,fcheckdate,fconfirmstatus,fconfirmperson,fconfirmdate,fremark,         \n");
        sqlBuffer.append("fsingledc,fcurrencyprecision,FDataCollect,fitemDC,fassessor,fassessDate, fauditPartyId,fauditPartyName,fconfirmDiff,flimitAmount   \n");
        sqlBuffer.append(" from ").append(tempTable).append("\n");
        if (ids == null && !StringUtils.isEmpty((String)prmpCompanyId)) {
            sqlBuffer.append(" where (fCompanyID = '" + prmpCompanyId + "' OR fTargetCompanyID = '" + prmpCompanyId + "') \n");
        }
        sqlBuffer.append(" union    \n");
        sqlBuffer.append(" select 'zzzzzzzzzzzz' fid,case when fnumber is null then N'z999999999' else fnumber end fnumber,null felimtemplet,null felimtype,null fcurrency,null fcompany,                 \n");
        sqlBuffer.append(" null ftargetcompany,null fitemnumber,null fitemname,0 fdataelement, \n");
        if (!isQueryHisBudget) {
            sqlBuffer.append("  fbeforeAdjustData=isnull(SUM(fbeforeAdjustData),0), fadjustdata=isnull(SUM(fadjustdata),0),  \n");
        } else {
            sqlBuffer.append(" null fbeforeAdjustData, null  fadjustdata,  \n");
        }
        sqlBuffer.append(" fdebit=isnull(SUM(fdebit),0),fcredit = isnull(SUM(fcredit),0),fvalidebit = isnull(SUM(fvalidebit),0),          \n");
        sqlBuffer.append(" fvalicredit = isnull(SUM(fvalicredit),0),fdiff = isnull(SUM(fdiff)/COUNT(FNUMBER),0),0 fdiffmode,                \n");
        sqlBuffer.append(" null fcheckperson,null fcheckdate,0 fconfirmstatus,                           \n");
        sqlBuffer.append(" null fconfirmperson,null fconfirmdate,null fremark,0 fsingledc,0 fcurrencyprecision,null FDataCollect,3 fitemDC, \n");
        sqlBuffer.append(" null fassessor,null fassessDate, null fauditPartyId, null fauditPartyName,fconfirmDiff = isnull(SUM(fvalidebit),0)-isnull(SUM(fvalicredit),0),0 flimitAmount \n");
        sqlBuffer.append(" from ").append(tempTable).append("\n");
        if (!StringUtils.isEmpty((String)prmpCompanyId)) {
            sqlBuffer.append(" where (fCompanyID = '" + prmpCompanyId + "' OR fTargetCompanyID = '" + prmpCompanyId + "') \n");
        }
        sqlBuffer.append(" group by fnumber with rollup ) total   \n");
        sqlBuffer.append(" order by fnumber ASC,fid,fitemnumber");
        try {
            con = this.getConnection(ctx);
            rst = DBUtil.executeQuery((String)sqlBuffer.toString(), (SqlParams)sp, (int)from, (int)length, (Connection)con);
            if (rst.next() && rst.getRowCount() == 1 && sortID.equals(rst.getString("fid")) && sortNumber.equals(rst.getString("fnumber")) && BigDecimal.ZERO.compareTo(rst.getBigDecimal("fdebit")) == 0 && BigDecimal.ZERO.compareTo(rst.getBigDecimal("fcredit")) == 0 && BigDecimal.ZERO.compareTo(rst.getBigDecimal("fvalidebit")) == 0 && BigDecimal.ZERO.compareTo(rst.getBigDecimal("fvalicredit")) == 0 && BigDecimal.ZERO.compareTo(rst.getBigDecimal("fdiff")) == 0 && BigDecimal.ZERO.compareTo(rst.getBigDecimal("fconfirmDiff")) == 0) {
                rst = DBUtil.executeQuery((String)("select * from " + tempTable + " where 1=2 "), (SqlParams)sp, (int)from, (int)length, (Connection)con);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
        return rst;
    }

    private RptProperties prepareFetchInterAndExchCheckDataToTmptbl(Context ctx, RptProperties params) throws BOSException, EASBizException {
        String interCheckSoluID = null;
        if (params.containsKey("interCheckSolu")) {
            interCheckSoluID = params.getString("interCheckSolu");
        }
        Map rtnMap = this.getTmpTypeByInterCheckSoluID(ctx, interCheckSoluID);
        List interTemList = null;
        List exchTemList = null;
        if (rtnMap != null) {
            if (rtnMap.containsKey("interTemList")) {
                interTemList = (List)rtnMap.get("interTemList");
            }
            if (rtnMap.containsKey("exchTemList")) {
                exchTemList = (List)rtnMap.get("exchTemList");
            }
        }
        if (interTemList != null && interTemList.size() > 0 && (exchTemList == null || exchTemList.size() == 0)) {
            params.setObject("interTemList", interTemList);
            params = this.prepareFetchInterCheckDataToTmptbl(ctx, params);
            return params;
        }
        if ((interTemList == null || interTemList.size() == 0) && exchTemList != null && exchTemList.size() > 0) {
            params.setObject("exchTemList", exchTemList);
            params = this.prepareFetchExchChkageDataToTmpTbl(ctx, params);
            return params;
        }
        if (interTemList != null && interTemList.size() > 0 && exchTemList != null && exchTemList.size() > 0 || (interTemList == null || interTemList.size() == 0) && (exchTemList == null || exchTemList.size() == 0)) {
            params = this.prepareFetchInterCheckDataToTmptbl(ctx, params);
            String interTempTable = params.getString("tempTable");
            params.remove("tempTable");
            params = this.prepareFetchExchChkageDataToTmpTbl(ctx, params);
            String exchTempTable = params.getString("tempTable");
            StringBuffer innerSQL = new StringBuffer();
            innerSQL.append("insert into ").append(exchTempTable).append(" select * from ").append(interTempTable);
            Connection con = null;
            try {
                con = this.getConnection(ctx);
                DBUtil.execute((String)innerSQL.toString(), (Connection)con);
                TempTablePool.getInstance((Context)ctx).releaseTable(interTempTable);
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            finally {
                SQLUtils.cleanup((Connection)con);
            }
        }
        return params;
    }

    private Map getTmpTypeByInterCheckSoluID(Context ctx, String interCheckSoluID) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)interCheckSoluID)) {
            return null;
        }
        InterCheckSolutionInfo interCheckSoluInfo = InterCheckSolutionFactory.getLocalInstance(ctx).getInterCheckSolutionInfo((IObjectPK)new ObjectUuidPK(interCheckSoluID));
        ArrayList<String> interTemList = new ArrayList<String>();
        ArrayList<String> exchTemList = new ArrayList<String>();
        if (interCheckSoluInfo == null) {
            return null;
        }
        InterCheckSolutionEntryCollection interCheckSoluEntryCollection = interCheckSoluInfo.getEntries();
        int temCount = interCheckSoluEntryCollection.size();
        InterCheckSolutionEntryInfo interCheckSoluEntryInfo = null;
        for (int i = 0; i < temCount; ++i) {
            interCheckSoluEntryInfo = interCheckSoluEntryCollection.get(i);
            if (interCheckSoluEntryInfo.getTemType() == ElimTypeEnum.ComeAndGo) {
                interTemList.add(interCheckSoluEntryInfo.getTemNumber());
                continue;
            }
            if (interCheckSoluEntryInfo.getTemType() != ElimTypeEnum.exchange) continue;
            exchTemList.add(interCheckSoluEntryInfo.getTemNumber());
        }
        HashMap<String, ArrayList<String>> rtnMap = new HashMap<String, ArrayList<String>>();
        rtnMap.put("interTemList", interTemList);
        rtnMap.put("exchTemList", exchTemList);
        return rtnMap;
    }

    private RptProperties prepareFetchInterCheckDataToTmptbl(Context ctx, RptProperties params) throws BOSException, EASBizException {
        int mergeType = params.getInt("MERGETYPE");
        int year = params.getInt("year");
        int period = params.getInt("period");
        int periodType = params.getInt("periodType");
        boolean isByCompany = params.getBoolean("isByCompany");
        String treeId = params.getString("treeId");
        String dataCollectNumber = params.getString("dataCollectNumber");
        String orgUnitId = params.getString("orgUnitId");
        String companyId = params.getString("company");
        String fromCurrency = params.getString("fromCurrency");
        String templetId = params.getString("templet");
        List items = (List)params.getObject("Items");
        Integer checkedParty = (Integer)params.getObject("checkedParty");
        boolean isShowNotZero = params.getBoolean("isShowNotZero");
        String c1 = (String)params.getObject("company");
        String c2 = (String)params.getObject("targetCompany");
        boolean isQueryHisBudget = params.getBoolean("isQueryHisBudget");
        String interCheckage = QueryHisBudgetUtils.getInterCheckageTabName(isQueryHisBudget);
        String dataCheckEntr = isQueryHisBudget ? "T_CSL_HisDataCheckageEntry" : "T_CSL_DataCheckageEntry";
        String sortCol = (String)params.getObject("sortCol");
        String sortType = (String)params.getObject("sortType");
        SqlParams sp = new SqlParams();
        Collection ids = params.getCollection("ids");
        String longNumber = null;
        int level = -1;
        IRowSet rsTemp = DbUtil.executeQuery((Context)ctx, (String)" select FLongNumber,FLevel From t_org_structure where ftreeid = ? and funitid = ?", (Object[])new Object[]{treeId, orgUnitId});
        try {
            while (rsTemp.next()) {
                longNumber = rsTemp.getString("FLongNumber");
                level = rsTemp.getInt("FLevel");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        String lang = ctx.getLocale().toString();
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" SELECT                                                 \r\n");
        sqlBuffer.append(" INTERDATACHECKAGE.FID as fid,                          \r\n");
        sqlBuffer.append(" 'WL-'||INTERDATACHECKAGE.FNumber as fNumber,                  \r\n");
        sqlBuffer.append(" TEMPLET.FName as fElimTemplet,                         \r\n");
        sqlBuffer.append(" TEMPLET.FELIMTYPE as FELIMTYPE,                         \r\n");
        sqlBuffer.append(" CURRENCY.FName_" + lang + " as fCurrency,              \r\n");
        sqlBuffer.append(" COMPANY1.FID as  fCompanyID, \t\t\t\t\t\t\t  \r\n");
        sqlBuffer.append(" COMPANY1.FName_" + lang + " as fCompany,               \r\n");
        sqlBuffer.append(" TARGETCOMPANY.FID as fTargetCompanyID,  \t\t\t\t  \r\n");
        sqlBuffer.append(" TARGETCOMPANY.FName_" + lang + " as fTargetCompany,    \r\n");
        sqlBuffer.append(" ITEM.FNumber as fItemNumber,                           \r\n");
        sqlBuffer.append(" ITEM.FName_" + lang + " as fItemName,                  \r\n");
        sqlBuffer.append(" ENTRIES.FDataElement as fDataElement,                  \r\n");
        sqlBuffer.append(" ENTRIES.FDebit as fDebit,                              \r\n");
        sqlBuffer.append(" ENTRIES.FCredit as fCredit ,                           \r\n");
        sqlBuffer.append(" ENTRIES.FValiDebit as fValiDebit,                      \r\n");
        sqlBuffer.append(" ENTRIES.FValiCredit as fValiCredit,                    \r\n");
        sqlBuffer.append(" INTERDATACHECKAGE.FDiffValue as fDiff,                 \r\n");
        sqlBuffer.append(" INTERDATACHECKAGE.FDiffMode as fDiffMode,              \r\n");
        sqlBuffer.append(" CREATOR.FName_" + lang + " as fCheckPerson ,           \r\n");
        sqlBuffer.append(" INTERDATACHECKAGE.FCreateTime as fCheckDate,           \r\n");
        sqlBuffer.append(" INTERDATACHECKAGE.FCheckedStatus as fConfirmStatus,    \r\n");
        sqlBuffer.append(" AUDITOR.FName_" + lang + " as fConfirmPerson,          \r\n");
        sqlBuffer.append(" INTERDATACHECKAGE.FAuditDate as fConfirmDate,          \r\n");
        sqlBuffer.append("  INTERDATACHECKAGE.FDescription as fRemark,            \r\n");
        sqlBuffer.append(" INTERDATACHECKAGE.FSingleDC as fSingleDC,              \r\n");
        sqlBuffer.append(" CURRENCY.FPrecision as fCurrencyPrecision,              \r\n");
        sqlBuffer.append(" Company1.FNumber as FCompany1Number,    \r\n");
        sqlBuffer.append(" DATACOLLECT.FName_" + lang + " as DataCollectName,     \r\n");
        if (!isQueryHisBudget) {
            sqlBuffer.append(" ENTRIES.FBeforeAdjustData as FBeforeAdjustData,   \r\n");
            sqlBuffer.append(" ENTRIES.FAdjustData as FAdjustData ,              \r\n");
        } else {
            sqlBuffer.append(" NULL as FBeforeAdjustData,   NULL as FAdjustData ,\r\n");
        }
        sqlBuffer.append(" ITEM.FDC as fitemDC,     \r\n");
        sqlBuffer.append(" ass.FName_").append(ctx.getLocale() + "  as assessor,     \r\n");
        sqlBuffer.append(" INTERDATACHECKAGE.FAssessDate as assessDate,     \r\n");
        sqlBuffer.append(" PARTY.FID as auditPartyId,     \r\n");
        sqlBuffer.append(" PARTY.FName_").append(ctx.getLocale() + " as auditPartyName, \r\n");
        sqlBuffer.append(" INTERDATACHECKAGE.FConfirmDiffVal as FConfirmDiff, \r\n");
        sqlBuffer.append(" INTERDATACHECKAGE.FLimitAmount as limitAmount \r\n");
        sqlBuffer.append(" FROM ").append(interCheckage).append(" AS INTERDATACHECKAGE   \t  \r\n");
        sqlBuffer.append(" LEFT OUTER JOIN T_PM_User AS CREATOR                   \r\n");
        sqlBuffer.append(" ON INTERDATACHECKAGE.FCreatorID = CREATOR.FID          \r\n");
        sqlBuffer.append(" LEFT OUTER JOIN T_PM_User AS AUDITOR                   \r\n");
        sqlBuffer.append(" ON INTERDATACHECKAGE.FAuditorID = AUDITOR.FID          \r\n");
        sqlBuffer.append(" INNER JOIN T_ORG_Tree AS ORGBOUND                      \r\n");
        sqlBuffer.append(" ON INTERDATACHECKAGE.FOrgBoundID = ORGBOUND.FID        \r\n");
        sqlBuffer.append(" INNER JOIN ").append(dataCheckEntr).append(" AS ENTRIES          \r\n");
        sqlBuffer.append(" ON INTERDATACHECKAGE.FID = ENTRIES.FCheckageID         \r\n");
        sqlBuffer.append(" INNER JOIN T_BD_Currency AS CURRENCY                   \r\n");
        sqlBuffer.append(" ON INTERDATACHECKAGE.FCurrencyID = CURRENCY.FID        \r\n");
        sqlBuffer.append(" LEFT OUTER JOIN T_CSL_ElimTemplet AS TEMPLET           \r\n");
        sqlBuffer.append(" ON INTERDATACHECKAGE.FTempletID = TEMPLET.FID          \r\n");
        sqlBuffer.append(" INNER JOIN T_CSL_DATACOLLECT AS DATACOLLECT         \r\n");
        sqlBuffer.append(" ON INTERDATACHECKAGE.FDATACOLLECTNUMBER = DATACOLLECT.FNUMBER \r\n");
        sqlBuffer.append(" LEFT OUTER JOIN T_CSL_ElimTempletENTRY AS TEMPLETENTRY \r\n");
        sqlBuffer.append(" ON TEMPLETENTRY.FTempletID = TEMPLET.FID And TEMPLETENTRY.FItemID = ENTRIES.FItemID  \r\n");
        sqlBuffer.append(" And TEMPLETENTRY.FDataElement = ENTRIES.FDataElement   \r\n");
        sqlBuffer.append(" INNER JOIN T_CSL_RptItem AS ITEM                       \r\n");
        sqlBuffer.append(" ON ENTRIES.FItemID = ITEM.FID                          \r\n");
        sqlBuffer.append(" INNER JOIN T_ORG_BaseUnit AS COMPANY1                  \r\n");
        sqlBuffer.append(" ON ENTRIES.FCompanyID = COMPANY1.FID                   \r\n");
        if (ids == null) {
            sqlBuffer.append(" INNER JOIN t_org_structure t1\t\t\t\t\t\t  \r\n");
            sqlBuffer.append(" ON t1.funitid = COMPANY1.fid AND t1.fisleaf = 1\t\t  \r\n");
            sqlBuffer.append(" AND t1.ftreeid = '").append(treeId).append("'\t\t  \r\n");
            if (!isByCompany) {
                sqlBuffer.append(" AND t1.flongnumber LIKE '").append(longNumber).append("!%'\r\n");
            }
        }
        sqlBuffer.append(" INNER JOIN T_ORG_BaseUnit AS TARGETCOMPANY             \t\t\r\n");
        sqlBuffer.append(" ON ENTRIES.FTargetCompanyID = TARGETCOMPANY.FID        \t\t\r\n");
        if (ids == null) {
            sqlBuffer.append(" INNER JOIN t_org_structure t2\t\t\t\t\t\t  \t\t\r\n");
            sqlBuffer.append(" ON t2.funitid = TARGETCOMPANY.fid AND t2.fisleaf = 1\t  \t\t\r\n");
            sqlBuffer.append(" AND t2.ftreeid = '").append(treeId).append("'\t\t  \t\t\r\n");
            if (!isByCompany) {
                sqlBuffer.append(" AND t2.flongnumber LIKE '").append(longNumber).append("%'\r\n");
            }
        }
        sqlBuffer.append(" LEFT  JOIN T_ORG_BaseUnit AS PARTY          \t\t\t\t\r\n");
        sqlBuffer.append(" ON INTERDATACHECKAGE.FcheckedParty = PARTY.FID \r\n");
        sqlBuffer.append(" LEFT  JOIN T_PM_User AS ass          \t\t\t\t\r\n");
        sqlBuffer.append(" ON INTERDATACHECKAGE.FASSESSORID = ass.FID \r\n");
        if (ids == null) {
            boolean isFromMerge;
            sqlBuffer.append(" WHERE INTERDATACHECKAGE.FOrgBoundID = ?   \t\t\t  \t\t\r\n");
            if (!isByCompany) {
                sqlBuffer.append(" and INTERDATACHECKAGE.FOrgUnitID = ?                   \t\t\r\n");
            }
            sqlBuffer.append(" and INTERDATACHECKAGE.FYear = ?                        \t\t\r\n");
            sqlBuffer.append(" and INTERDATACHECKAGE.FPeriod = ?   \t\t\t\t\t  \t\t\r\n");
            sqlBuffer.append(" and INTERDATACHECKAGE.FPeriodType = ?   \t\t\t\t  \t\t\r\n");
            sp.addString(treeId);
            if (!isByCompany) {
                sp.addString(orgUnitId);
            }
            sp.addInt(year).addInt(period).addInt(periodType);
            if (!StringUtils.isEmpty((String)companyId)) {
                sqlBuffer.append(" and (COMPANY1.FID = ? or TARGETCOMPANY.FID = ? )\t    \t\r\n");
                sp.addString(companyId);
                sp.addString(companyId);
            }
            if (fromCurrency != null && !fromCurrency.trim().equals("")) {
                sqlBuffer.append("    and INTERDATACHECKAGE.FCurrencyID = ?   \t\t\t\t\r\n");
                sp.addString(fromCurrency);
            }
            if (templetId != null && !templetId.trim().equals("")) {
                sqlBuffer.append(" \tand INTERDATACHECKAGE.FTempletID = ?   \t\t\t\t\t\r\n");
                sp.addString(templetId);
            }
            if (params.containsKey("interTemList")) {
                List interTemList = null;
                interTemList = (List)params.getObject("interTemList");
                StringBuffer strInterTemListNum = new StringBuffer();
                if (interTemList != null && interTemList.size() > 0) {
                    for (int i = 0; i < interTemList.size(); ++i) {
                        strInterTemListNum.append("'").append(interTemList.get(i)).append("'");
                        strInterTemListNum.append(",");
                    }
                    sqlBuffer.append(" \tand TEMPLET.fnumber in(").append(strInterTemListNum.toString().substring(0, strInterTemListNum.lastIndexOf(","))).append(") \t\t\t\t\t\t\r\n");
                }
            }
            if (isShowNotZero) {
                sqlBuffer.append(" \tand INTERDATACHECKAGE.FDiffValue <> 0   \t\t\t\t\r\n");
            }
            if (params.containsKey("compare")) {
                String compare = params.getString("compare");
                BigDecimal value = new BigDecimal(params.getString("value"));
                sqlBuffer.append(" \tand INTERDATACHECKAGE.FDiffValue ").append(compare).append(" ").append(value).append("   \r\n");
            }
            if (params.containsKey("confirmStatus")) {
                sqlBuffer.append(" and INTERDATACHECKAGE.FCheckedStatus = ").append(params.getInt("confirmStatus")).append("   \r\n");
            }
            if (mergeType == 1) {
                sqlBuffer.append(this.getParamCompanyUnionSql(ctx, treeId, longNumber, level, "t1;t2"));
            }
            if (isByCompany) {
                if (c2 == null) {
                    sqlBuffer.append(" and (ENTRIES.FCompanyId = ? or ENTRIES.FTargetCompanyId = ? )");
                    sp.addString(c1).addString(c1);
                } else {
                    sqlBuffer.append(" and ((ENTRIES.FCompanyId = ? and ENTRIES.FTargetCompanyId = ? )");
                    sqlBuffer.append(" or (ENTRIES.FCompanyId = ? and ENTRIES.FTargetCompanyId = ? ))");
                    sp.addString(c1).addString(c2).addString(c2).addString(c1);
                }
                if (checkedParty != null && 0 != checkedParty) {
                    if (1 == checkedParty) {
                        sqlBuffer.append(" and INTERDATACHECKAGE.FcheckedParty = ? \n");
                        sp.addString(c1);
                    } else if (2 == checkedParty) {
                        sqlBuffer.append(" and INTERDATACHECKAGE.FcheckedParty <> ? \n");
                        sp.addString(c1);
                    } else if (3 == checkedParty) {
                        sqlBuffer.append(" and INTERDATACHECKAGE.FcheckedParty IS NULL \n");
                    }
                }
            }
            if (params.containsKey("isFromMerge") && (isFromMerge = params.getBoolean("isFromMerge")) && c2 != null) {
                sqlBuffer.append(" and (ENTRIES.FCompanyId = ? or ENTRIES.FTargetCompanyId = ? )");
                sp.addString(c2).addString(c2);
            }
            if (dataCollectNumber != null && dataCollectNumber.length() != 0) {
                sqlBuffer.append(" and INTERDATACHECKAGE.FdataCollectNumber = ? ");
                sp.addString(dataCollectNumber);
            }
            if (items != null) {
                sqlBuffer.append(" and ITEM.FNumber in(").append(CslRptUtil.AryToItemString(items));
                sqlBuffer.append(")");
            }
        } else {
            sqlBuffer.append(" where INTERDATACHECKAGE.fid in(").append(CslRptUtil.collection2String(ids, ",", true)).append(")");
        }
        sqlBuffer.append(" and ((ENTRIES.FDebit <> 0) OR (ENTRIES.FCredit <> 0) \t\t\r\n");
        sqlBuffer.append(" OR (ENTRIES.FValiDebit <> 0) OR (ENTRIES.FValiCredit <> 0)\t\r\n");
        if (!isQueryHisBudget) {
            sqlBuffer.append(" or(ENTRIES.FBeforeAdjustData <>0)  \r\n");
            sqlBuffer.append(" or(ENTRIES.FAdjustData <>0 )       \r\n");
        }
        sqlBuffer.append(" ) \t\r\n");
        String tempTable = this.getTemplateTable(ctx, this.getCreateInterCheckTmpTbleSql());
        StringBuffer insertSql = new StringBuffer(5000);
        insertSql.append("insert into ").append(tempTable).append(sqlBuffer.toString());
        Connection con = null;
        try {
            con = this.getConnection(ctx);
            DbUtil.execute((String)insertSql.toString(), (SqlParams)sp, (Connection)con, (Context)ctx);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
        params.setString("tempTable", tempTable);
        return params;
    }

    private RptProperties prepareFetchInterItemDataToTempTable(Context ctx, RptProperties params) throws BOSException, EASBizException {
        int mergeType = params.getInt("MERGETYPE");
        int year = params.getInt("year");
        int period = params.getInt("period");
        int periodType = params.getInt("periodType");
        boolean isByCompany = params.getBoolean("isByCompany");
        String treeId = params.getString("treeId");
        String dataCollectNumber = params.getString("dataCollectNumber");
        String orgUnitId = params.getString("orgUnitId");
        String authicateSql = params.getString("authicateSql");
        String fromCurrency = params.getString("fromCurrency");
        String toCurrency = params.getString("toCurrency");
        String c1 = (String)params.getObject("company");
        String c2 = (String)params.getObject("targetCompany");
        boolean isQueryHisBudget = params.getBoolean("isQueryHisBudget");
        String rptReceiveTabName = QueryHisBudgetUtils.getRptReceiveTabName(isQueryHisBudget);
        String itemdataTableName = isQueryHisBudget ? "T_CSL_HisInterItemdata" : "T_CSL_InterItemdata";
        SqlParams sp = new SqlParams();
        String longNumber = null;
        int level = 0;
        IRowSet rsTemp = DbUtil.executeQuery((Context)ctx, (String)" select FLongNumber,FLevel From t_org_structure where ftreeid = ? and funitid = ?", (Object[])new Object[]{treeId, orgUnitId});
        try {
            while (rsTemp.next()) {
                longNumber = rsTemp.getString("FLongNumber");
                level = rsTemp.getInt("FLevel");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        String interAdjustDataSql = RelatingAdjustElimHelper.getInterAdjustDataSql(params);
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("(");
        sqlBuffer.append(" SELECT \t\t\t\t\t\t\t\t   \r\n");
        sqlBuffer.append(" fromcompany.FName_" + ctx.getLocale() + " as Company,          \r\n");
        sqlBuffer.append(" targetcompany.FName_" + ctx.getLocale() + " as TargetCompany,    \r\n");
        sqlBuffer.append(" interitemdata.FItemNumber as ItemNumber,                     \r\n");
        sqlBuffer.append(" rptitem.FName_" + ctx.getLocale() + " as ItemName,              \r\n");
        sqlBuffer.append(" interitemdata.FDataElement as DataElement,                     \r\n");
        sqlBuffer.append(" fromcurrency.FName_" + ctx.getLocale() + " as FromCurrency,     \r\n");
        sqlBuffer.append(" targetcurrency.FName_" + ctx.getLocale() + " as TargetCurrency,  \r\n");
        sqlBuffer.append(" interitemdata.FMoney as BeforeAdjustData,                         \r\n");
        sqlBuffer.append(" isnull(interAdjustData.adjustdata,0) as adjustData, \r\n");
        sqlBuffer.append(" isnull(interitemdata.FMoney,0)+isnull(interAdjustData.adjustdata,0) as afterAdjustData, \r\n");
        sqlBuffer.append(" interitemdata.FID ,                                     \r\n");
        sqlBuffer.append(" targetcurrency.FPrecision,           \r\n");
        sqlBuffer.append(" datacollect.FName_" + ctx.getLocale() + " as dataCollectName,   \r\n");
        sqlBuffer.append(" ig.FName_" + ctx.getLocale() + "            \r\n");
        sqlBuffer.append(" FROM " + itemdataTableName + " AS interitemdata                        \r\n");
        sqlBuffer.append(" left join (").append(interAdjustDataSql).append(") as interAdjustData ");
        sqlBuffer.append(" on interAdjustData.fid=interitemdata.fid ");
        sqlBuffer.append(" INNER JOIN T_BD_Currency AS fromcurrency                                \r\n");
        sqlBuffer.append(" ON interitemdata.FCurrencyID = fromcurrency.FID                  \r\n");
        sqlBuffer.append(" INNER JOIN T_BD_Currency AS targetcurrency                          \r\n");
        sqlBuffer.append(" ON interitemdata.FTargetCurrencyID = targetcurrency.FID            \r\n");
        sqlBuffer.append(" INNER JOIN T_CSL_DATACOLLECT AS datacollect                          \r\n");
        sqlBuffer.append(" ON interitemdata.FDataCollectNumber = datacollect.FNumber            \r\n");
        sqlBuffer.append(" INNER JOIN ").append(rptReceiveTabName).append(" AS rptreceived                         \r\n");
        sqlBuffer.append(" ON interitemdata.FReport = rptreceived.FReportID             \r\n");
        sqlBuffer.append(" INNER JOIN T_CSL_RptItem AS rptitem                                    \r\n");
        sqlBuffer.append(" ON interitemdata.FItemNumber = rptitem.FNumber                  \r\n");
        sqlBuffer.append(" INNER JOIN T_ORG_BaseUnit AS fromcompany                                \r\n");
        sqlBuffer.append(" ON interitemdata.FCompanyID = fromcompany.FID                    \r\n");
        sqlBuffer.append(" INNER JOIN T_ORG_BaseUnit AS targetcompany                          \r\n");
        sqlBuffer.append(" ON interitemdata.FTargetCompanyID = targetcompany.FID        \r\n");
        sqlBuffer.append(" left join t_org_baseunit ig                                  \r\n");
        sqlBuffer.append(" on interitemData.FImportedGroup = ig.FId                     \r\n");
        sqlBuffer.append(" INNER JOIN T_CSL_CslReport AS CslReport                       \r\n");
        sqlBuffer.append(" ON interitemdata.FReport = CslReport.FID        \r\n");
        if (!isByCompany && mergeType == 1) {
            sqlBuffer.append(" INNER Join (");
            sqlBuffer.append(" Select f1.FCompanyId,f1.FLongNumber as FLongNumber,f2.FTargetCompanyId,f2.FlongNumber As FTargetLongNumber \r\n");
            sqlBuffer.append(" From \r\n");
            sqlBuffer.append(" (Select t1.FUnitId As FCompanyId,t1.FLongNumber From t_org_structure t1 join t_org_baseunit t2 on t1.funitid=t2.fid where t2.fisgrouping=0 and t1.fisleaf=1 and t1.flongnumber like '").append(longNumber).append("!%' and t1.ftreeid='").append(treeId).append("') f1, \r\n");
            sqlBuffer.append(" (Select t1.FUnitId As FTargetCompanyId,t1.FLongNumber From t_org_structure t1 join t_org_baseunit t2 on t1.funitid=t2.fid where t2.fisgrouping=0 and t1.fisleaf=1 and  t1.flongnumber like '").append(longNumber).append("!%' and t1.ftreeid='").append(treeId).append("') f2 \r\n");
            sqlBuffer.append(" ) f \r\n");
            sqlBuffer.append(" ON interitemdata.fcompanyid = f.fcompanyid And interitemdata.ftargetcompanyid=f.ftargetcompanyid");
        }
        sqlBuffer.append(" WHERE interitemdata.FMoney <> 0                                \r\n");
        if (isByCompany) {
            sqlBuffer.append("    and (CslReport.FAuditedStatus = 2 or CslReport.fAdjustStatus = 1)  \r\n");
        } else {
            sqlBuffer.append("    and (CslReport.FCommittedStatus = 3 or exists(select 1\u3000from T_CSL_CslReport AS CslReport1 where  CslReport.fsourcerptid=CslReport1.fid and CslReport1.FCommittedStatus = 3))  \r\n");
        }
        sqlBuffer.append("    and (interitemdata.FOrgBoundId = ? or interitemdata.FOrgBoundId is null) \r\n");
        sp.addString(treeId);
        sqlBuffer.append("    and rptreceived.FOrgTreeID = ?   \r\n");
        sqlBuffer.append("    and interitemdata.FYear = ?   \r\n");
        sqlBuffer.append("    and interitemdata.FPeriod = ?   \r\n");
        sqlBuffer.append("    and interitemdata.FPeriodType = ?   \r\n");
        sp.addString(treeId).addInt(year).addInt(period).addInt(periodType);
        String tableAliasName = "interitemdata";
        ParamTempTblService service = null;
        service = this.constructTmpTblStr(ctx, params, authicateSql, sqlBuffer, tableAliasName, service);
        if (fromCurrency != null && !fromCurrency.trim().equals("")) {
            sqlBuffer.append("    and interitemdata.FCurrencyID = ?   \r\n");
            sp.addString(fromCurrency);
        }
        if (toCurrency != null && !toCurrency.trim().equals("")) {
            sqlBuffer.append("    and interitemdata.FTargetCurrencyID = ?   \r\n");
            sp.addString(toCurrency);
        }
        if (!isByCompany && mergeType == 1) {
            sqlBuffer.append(this.getParamCompanyUnionSql(ctx, treeId, longNumber, level, "f"));
        }
        sqlBuffer.append(" and interitemdata.FCompanyId IN (select funitid from t_org_structure where ftreeid = ? )     ");
        sqlBuffer.append(" and interitemdata.FTargetCompanyId IN (select funitid from t_org_structure where ftreeid = ? )     ");
        sp.addString(treeId).addString(treeId);
        if (isByCompany) {
            if (c2 == null) {
                sqlBuffer.append(" and (interitemdata.FCompanyId = ? or interItemdata.FTargetCompanyId = ? )");
                sp.addString(c1).addString(c1);
            } else {
                sqlBuffer.append(" and ((interitemdata.FCompanyId = ? and interitemdata.FTargetCompanyId = ? )");
                sqlBuffer.append(" or (interitemdata.FCompanyId = ? and interItemdata.FTargetCompanyId = ? ))");
                sp.addString(c1).addString(c2).addString(c2).addString(c1);
            }
        }
        if (dataCollectNumber != null && dataCollectNumber.length() != 0) {
            sqlBuffer.append(" and interitemdata.FDataCollectNumber = ? ");
            sp.addString(dataCollectNumber);
        }
        this.addAdjustNoReportDataSql(sqlBuffer, sp, params, longNumber, level, 1);
        String lc = ctx.getLocale().toString();
        sqlBuffer.append(" ORDER BY FROMCURRENCY, COMPANY, TARGETCOMPANY, ItemNumber   \r\n");
        String tempTable = this.getTemplateTable(ctx, this.getCreateInterTmpTblSql());
        StringBuffer insertSql = new StringBuffer(5000);
        insertSql.append("insert into ").append(tempTable).append("(FCompany,FTargetCompany,FItemNumber,FItemName,FDataElement,").append("FromCurrency,FTargetCurrency,").append("BeforeAdjustData,adjustData,afterAdjustData,").append("FID,FPrecision,DataCollectName,FimpName)").append(sqlBuffer.toString());
        Connection con = null;
        try {
            if (!StringUtils.isEmpty((String)interAdjustDataSql)) {
                con = this.getConnection(ctx);
                DbUtil.execute((String)insertSql.toString(), (SqlParams)sp, (Connection)con, (Context)ctx);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup(con);
            if (service != null) {
                service.release();
            }
        }
        params.setString("tempTable", tempTable);
        return params;
    }

    private ParamTempTblService constructTmpTblStr(Context ctx, RptProperties params, String authicateSql, StringBuffer sqlBuffer, String tableAliasName, ParamTempTblService service) throws BOSException {
        if ("ComeFromGroup".equals(params.getString("InterOrExchComeType"))) {
            List cmpIdlist = (List)params.getObject("companyIdListForTmpTbl");
            if (cmpIdlist != null && cmpIdlist.size() > 0) {
                TableInfo table = new TableInfo("T_TMPTBL_CPYIDS");
                table.addColumn(new ColumnInfo("ID"));
                service = new ParamTempTblService(ctx, table, cmpIdlist, null);
                String tmptableSql = service.getParamsSql();
                sqlBuffer.append("and ( ");
                sqlBuffer.append(tableAliasName).append(".FCompanyID in (").append(tmptableSql).append(")");
                sqlBuffer.append(" or ").append(tableAliasName).append(".FTargetCompanyID in (").append(tmptableSql).append(")");
                sqlBuffer.append(" )");
            }
        } else if ("ComeFromCmpNotTargetCmp".equals(params.getString("InterOrExchComeType"))) {
            List cmpIdlist = (List)params.getObject("companyIdListForTmpTbl");
            if (cmpIdlist != null && cmpIdlist.size() > 0) {
                TableInfo table = new TableInfo("T_TMPTBL_CPYIDS");
                table.addColumn(new ColumnInfo("ID"));
                service = new ParamTempTblService(ctx, table, cmpIdlist, null);
                String curOrgId = ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString();
                String tmptableSql = service.getParamsSql();
                sqlBuffer.append(" and ");
                sqlBuffer.append("(");
                sqlBuffer.append(" ( ").append(tableAliasName).append(".FCompanyID in (").append(tmptableSql).append(")");
                sqlBuffer.append(" and ").append(tableAliasName).append(".FTargetCompanyID = '").append(curOrgId).append("')");
                sqlBuffer.append(" or ( ").append(tableAliasName).append(".FTargetCompanyID in (").append(tmptableSql).append(")");
                sqlBuffer.append(" and ").append(tableAliasName).append(".FCompanyID ='").append(curOrgId).append("')");
                sqlBuffer.append(")");
            }
        } else {
            sqlBuffer.append(authicateSql);
        }
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RptProperties prepareFetchExchItemDataToTempTable(Context ctx, RptProperties params) throws BOSException, EASBizException {
        Object[] objectArray;
        int mergeType = params.getInt("MERGETYPE");
        int year = params.getInt("year");
        int period = params.getInt("period");
        int periodType = params.getInt("periodType");
        boolean isByCompany = params.getBoolean("isByCompany");
        String treeId = params.getString("treeId");
        String orgUnitId = params.getString("orgUnitId");
        String authicateSql = params.getString("authicateSql");
        String fromCurrency = params.getString("fromCurrency");
        String toCurrency = params.getString("toCurrency");
        String c1 = (String)params.getObject("company");
        String c2 = (String)params.getObject("targetCompany");
        String dataCollectNumber = params.getString("dataCollectNumber");
        boolean isQueryHisBudget = params.getBoolean("isQueryHisBudget");
        String rptReceiveTabName = QueryHisBudgetUtils.getRptReceiveTabName(isQueryHisBudget);
        String itemdataTableName = isQueryHisBudget ? "T_CSL_HisExchItemdata" : "T_CSL_ExchItemdata";
        SqlParams sp = new SqlParams();
        String longNumber = null;
        int level = 0;
        String unitNumber = null;
        String treeNumber = null;
        String sql = null;
        sql = !isByCompany ? " select struct.FLongNumber,struct.FLevel,tree.fnumber treeNumber,unit.fnumber unitNumber From t_org_structure struct inner join t_org_baseunit unit on unit.fid=struct.funitid inner join t_org_tree tree on tree.fid=struct.ftreeid where struct.ftreeid = ? and struct.funitid = ?" : " select fnumber treeNumber From t_org_tree where fid=? ";
        if (isByCompany) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = treeId;
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = treeId;
            objectArray = objectArray3;
            objectArray3[1] = orgUnitId;
        }
        IRowSet rsTemp = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])objectArray);
        try {
            while (rsTemp.next()) {
                treeNumber = rsTemp.getString("treeNumber");
                if (isByCompany) continue;
                longNumber = rsTemp.getString("FLongNumber");
                level = rsTemp.getInt("FLevel");
                unitNumber = rsTemp.getString("unitNumber");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        ArrayList clearCompanys = new ArrayList();
        String elimOrgUnitsTable = SameControlUtil.getElimOrgUnitsTable((Context)ctx, (String)treeId, (String)orgUnitId, (String)longNumber, (String)unitNumber, (String)treeNumber, clearCompanys, (int)year, (int)period, (int)periodType, (int)level, (ElimTypeEnum)ElimTypeEnum.exchange, (int)mergeType, (boolean)isByCompany);
        try {
            String exchAdjustDataSql = RelatingAdjustElimHelper.getExchAdjustDataSql(params);
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append(" (SELECT \t\t\t\t\t\t\t\t   \t\t\t\t\t\t\t\t\t\r\n");
            sqlBuffer.append(" fromcompany.FName_" + ctx.getLocale() + " as Company,        \t\t\t\r\n");
            sqlBuffer.append(" targetcompany.FName_" + ctx.getLocale() + " as TargetCompany,  \t\t\t\r\n");
            sqlBuffer.append(" exchitemdata.FItemNumber as ItemNumber,                     \t\t\t\t\r\n");
            sqlBuffer.append(" rptitem.FName_" + ctx.getLocale() + " as ItemName,           \t\t\t\r\n");
            sqlBuffer.append(" exchitemdata.FDataElement as DataElement,                     \t\t\t\r\n");
            sqlBuffer.append(" fromcurrency.FName_" + ctx.getLocale() + " as FromCurrency,   \t\t\t\r\n");
            sqlBuffer.append(" targetcurrency.FName_" + ctx.getLocale() + " as TargetCurrency,  \t\t\r\n");
            sqlBuffer.append(" exchitemdata.FMoney as BeforeAdjustData,                               \t\r\n");
            sqlBuffer.append(" isnull(exchAdjustData.adjustdata,0) as adjustData, \r\n");
            sqlBuffer.append(" isnull(exchitemdata.FMoney,0)+isnull(exchAdjustData.adjustdata,0) as afterAdjustData, \r\n");
            sqlBuffer.append(" exchitemdata.FID ,                                     \t\t\t\t\t\r\n");
            sqlBuffer.append(" targetcurrency.FPrecision ,          \t\t\t\t\t\t\t\t\t\r\n");
            sqlBuffer.append(" DATACOLLECT.FName_" + ctx.getLocale() + " as DataCollectName,    \t\t\r\n");
            sqlBuffer.append(" ig.FName_" + ctx.getLocale() + "    \t\t\t\t\t\t\t\t\t\t\r\n");
            sqlBuffer.append(" FROM ").append(itemdataTableName).append(" AS exchitemdata               \r\n");
            sqlBuffer.append(" left join (").append(exchAdjustDataSql).append(") as exchAdjustData ");
            sqlBuffer.append(" on exchAdjustData.fid=exchitemdata.fid ");
            sqlBuffer.append(" INNER JOIN T_BD_Currency AS fromcurrency                                 \r\n");
            sqlBuffer.append(" ON exchitemdata.FCurrencyID = fromcurrency.FID                  \t\t\t\r\n");
            sqlBuffer.append(" INNER JOIN T_BD_Currency AS targetcurrency                          \t\t\r\n");
            sqlBuffer.append(" ON exchitemdata.FTargetCurrencyID = targetcurrency.FID            \t\t\r\n");
            sqlBuffer.append(" INNER JOIN ").append(rptReceiveTabName).append(" AS rptreceived                         \t\t\r\n");
            sqlBuffer.append(" ON exchitemdata.FReport = rptreceived.FReportID             \t\t\t\t\r\n");
            sqlBuffer.append(" INNER JOIN T_CSL_RptItem AS rptitem                                    \t\r\n");
            sqlBuffer.append(" ON exchitemdata.FItemNumber = rptitem.FNumber                  \t\t\t\r\n");
            sqlBuffer.append(" INNER JOIN T_ORG_BaseUnit AS fromcompany                                \t\r\n");
            sqlBuffer.append(" ON exchitemdata.FCompanyID = fromcompany.FID                    \t\t\t\r\n");
            sqlBuffer.append(" INNER JOIN T_ORG_BaseUnit AS targetcompany                          \t\t\r\n");
            sqlBuffer.append(" ON exchitemdata.FTargetCompanyID = targetcompany.FID        \t\t\t\t\r\n");
            sqlBuffer.append(" INNER JOIN T_ORG_Tree AS orgbound                                   \t\t\r\n");
            sqlBuffer.append(" ON rptreceived.FOrgTreeID = orgbound.FID                        \t\t\t\r\n");
            sqlBuffer.append(" left JOIN T_ORG_baseunit AS ig                                   \t\t\r\n");
            sqlBuffer.append(" ON exchitemdata.FImportedGroup = ig.FID                        \t\t\t\r\n");
            sqlBuffer.append(" INNER JOIN T_CSL_DATACOLLECT AS DATACOLLECT         \r\n");
            sqlBuffer.append(" ON exchitemdata.FDATACOLLECTNUMBER = DATACOLLECT.FNUMBER \r\n");
            sqlBuffer.append(" INNER JOIN T_CSL_CslReport AS CslReport                       \r\n");
            sqlBuffer.append(" ON exchitemdata.FReport = CslReport.FID        \r\n");
            if (!isByCompany && mergeType == 1) {
                sqlBuffer.append(" INNER Join ").append(elimOrgUnitsTable).append(" f \r\n");
                sqlBuffer.append(" ON exchitemdata.fcompanyid = f.fcompanyid And exchitemdata.ftargetcompanyid=f.ftargetcompanyid");
            }
            sqlBuffer.append(" WHERE exchitemdata.FMoney <> 0                                \r\n");
            if (!isByCompany && mergeType == 0) {
                sqlBuffer.append(" and exchitemdata.fcompanyid in(select fcompanyid from ").append(elimOrgUnitsTable).append(") ");
                sqlBuffer.append(" and exchitemdata.ftargetcompanyid in(select fcompanyid from ").append(elimOrgUnitsTable).append(") ");
            }
            if (isByCompany) {
                sqlBuffer.append("    and (CslReport.FAuditedStatus = 2 or CslReport.fAdjustStatus = 1)  \r\n");
            } else {
                sqlBuffer.append("    and (CslReport.FCommittedStatus = 3  or exists(select 1\u3000from T_CSL_CslReport AS CslReport1 where  CslReport.fsourcerptid=CslReport1.fid and CslReport1.FCommittedStatus = 3)) \r\n");
            }
            sqlBuffer.append("    and (exchitemdata.FOrgBoundId = ? or exchitemdata.FOrgBoundId is null) \r\n");
            sp.addString(treeId);
            sqlBuffer.append("    and rptreceived.FOrgTreeID = ?   \t\t   \t\t\r\n");
            sqlBuffer.append("    and exchitemdata.FYear = ?   \t\t\t   \t\t\r\n");
            sqlBuffer.append("    and exchitemdata.FPeriod = ?             \t\t\r\n");
            sqlBuffer.append("    and exchitemdata.FPeriodType = ?         \t\t\r\n");
            sp.addString(treeId).addInt(year).addInt(period).addInt(periodType);
            if (dataCollectNumber != null && dataCollectNumber.length() != 0) {
                sqlBuffer.append(" and exchitemdata.FDataCollectNumber = ? ");
                sp.addString(dataCollectNumber);
            }
            ParamTempTblService service = null;
            String tableAliasName = "exchitemdata";
            service = this.constructTmpTblStr(ctx, params, authicateSql, sqlBuffer, tableAliasName, service);
            if (fromCurrency != null && !fromCurrency.trim().equals("")) {
                sqlBuffer.append("    and exchitemdata.FCurrencyID = ?    \t\t\r\n");
                sp.addString(fromCurrency);
            }
            if (toCurrency != null && !toCurrency.trim().equals("")) {
                sqlBuffer.append("    and exchitemdata.FTargetCurrencyID = ?   \r\n");
                sp.addString(toCurrency);
            }
            if (isByCompany) {
                if (c2 == null) {
                    sqlBuffer.append(" and (exchitemdata.FCompanyId = ? or exchitemdata.FTargetCompanyId = ? )");
                    sp.addString(c1).addString(c1);
                } else {
                    sqlBuffer.append(" and ((exchitemdata.FCompanyId = ? and exchitemdata.FTargetCompanyId = ? )");
                    sqlBuffer.append(" or (exchitemdata.FCompanyId = ? and exchitemdata.FTargetCompanyId = ? ))");
                    sp.addString(c1).addString(c2).addString(c2).addString(c1);
                }
                SameControlUtil.buildClearCompanySql((Object)sqlBuffer, clearCompanys, (String)"exchitemdata", (ElimTypeEnum)ElimTypeEnum.exchange);
            }
            this.addAdjustNoReportDataSql(sqlBuffer, sp, params, longNumber, level, 3);
            sqlBuffer.append(" ORDER BY FROMCURRENCY, COMPANY, TARGETCOMPANY, ItemNumber,DataElement   \r\n");
            String tempTable = this.getTemplateTable(ctx, this.getCreateExchTmpTblSql());
            StringBuffer insertSql = new StringBuffer(5000);
            insertSql.append("insert into ").append(tempTable).append("(FCompany,FTargetCompany,FItemNumber,FItemName,").append("FDataElement,FromCurrency,FTargetCurrency,").append("BeforeAdjustData,adjustData,afterAdjustData,FID,FPrecision,FDataCollectName,FimpName)").append(sqlBuffer.toString());
            Connection con = null;
            try {
                if (!StringUtils.isEmpty((String)exchAdjustDataSql)) {
                    con = this.getConnection(ctx);
                    DbUtil.execute((String)insertSql.toString(), (SqlParams)sp, (Connection)con, (Context)ctx);
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            finally {
                SQLUtils.cleanup(con);
                if (service != null) {
                    service.release();
                }
            }
            params.setString("tempTable", tempTable);
        }
        finally {
            if (!DebugLogger.isDebug && elimOrgUnitsTable != null) {
                TempTablePool.getInstance((Context)ctx).releaseTable(elimOrgUnitsTable);
            }
        }
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RptProperties prepareFetchExchChkageDataToTmpTbl(Context ctx, RptProperties params) throws BOSException, EASBizException {
        Object[] objectArray;
        int mergeType = params.getInt("MERGETYPE");
        String sortCol = (String)params.getObject("sortCol");
        String sortType = (String)params.getObject("sortType");
        int year = params.getInt("year");
        int period = params.getInt("period");
        int periodType = params.getInt("periodType");
        boolean isByCompany = params.getBoolean("isByCompany");
        String treeId = params.getString("treeId");
        String orgUnitId = params.getString("orgUnitId");
        String companyId = params.getString("company");
        String dataCollectNumber = params.getString("dataCollectNumber");
        String fromCurrency = params.getString("fromCurrency");
        String templetId = params.getString("templet");
        List items = (List)params.getObject("Items");
        Integer checkedParty = (Integer)params.getObject("checkedParty");
        boolean isShowNotZero = params.getBoolean("isShowNotZero");
        String c1 = (String)params.getObject("company");
        String c2 = (String)params.getObject("targetCompany");
        Collection ids = params.getCollection("ids");
        boolean isQueryHisBudget = params.getBoolean("isQueryHisBudget");
        String exchcheckage = isQueryHisBudget ? "T_CSL_Hisexchcheckage" : "T_CSL_exchcheckage";
        String exchCheckageEntry = isQueryHisBudget ? "T_CSL_HisExchCheckageEntry" : "T_CSL_ExchCheckageEntry";
        SqlParams sp = new SqlParams();
        String longNumber = null;
        String orgTreeNumber = null;
        String orgUnitNumber = null;
        int level = -1;
        String sql = null;
        sql = !isByCompany ? " select struct.FLongNumber,struct.FLevel,tree.fnumber treeNumber,unit.fnumber unitNumber From t_org_structure struct inner join t_org_baseunit unit on unit.fid=struct.funitid inner join t_org_tree tree on tree.fid=struct.ftreeid where struct.ftreeid = ? and struct.funitid = ?" : " select fnumber treeNumber From t_org_tree where fid=? ";
        if (isByCompany) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = treeId;
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = treeId;
            objectArray = objectArray3;
            objectArray3[1] = orgUnitId;
        }
        IRowSet rsTemp = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])objectArray);
        try {
            while (rsTemp.next()) {
                orgTreeNumber = rsTemp.getString("treeNumber");
                if (isByCompany) continue;
                longNumber = rsTemp.getString("FLongNumber");
                level = rsTemp.getInt("FLevel");
                orgUnitNumber = rsTemp.getString("unitNumber");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        ArrayList clearCompays = new ArrayList();
        String elimOrgUnitsTable = SameControlUtil.getElimOrgUnitsTable((Context)ctx, (String)treeId, (String)orgUnitId, (String)longNumber, (String)orgUnitNumber, (String)orgTreeNumber, clearCompays, (int)year, (int)period, (int)periodType, (int)level, (ElimTypeEnum)ElimTypeEnum.exchange, (int)mergeType, (boolean)isByCompany);
        try {
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append(" SELECT                                              \t\t\t  \t\r\n");
            sqlBuffer.append(" exchcheckage.FID as fid,                             \t\t  \t\r\n");
            sqlBuffer.append(" 'JY-'||exchcheckage.FNumber as fNumber,                               \t\r\n");
            sqlBuffer.append(" TEMPLET.FName as fElimTemplet,                                 \t\r\n");
            sqlBuffer.append(" TEMPLET.FELIMTYPE as FELIMTYPE,                                  \r\n");
            sqlBuffer.append(" CURRENCY.FName_" + ctx.getLocale() + " as fCurrency,           \t\r\n");
            sqlBuffer.append(" COMPANY1.FID as  fCompanyID, \t\t\t\t\t\t\t        \r\n");
            sqlBuffer.append(" COMPANY1.FName_" + ctx.getLocale() + " as fCompany,            \t\r\n");
            sqlBuffer.append(" TARGETCOMPANY.FID as fTargetCompanyID,  \t\t\t\t\t\t    \r\n");
            sqlBuffer.append(" TARGETCOMPANY.FName_" + ctx.getLocale() + " as fTargetCompany, \t\r\n");
            sqlBuffer.append(" ITEM.FNumber as fItemNumber,                                     \r\n");
            sqlBuffer.append(" ITEM.FName_" + ctx.getLocale() + " as fItemName,               \t\r\n");
            sqlBuffer.append(" ENTRIES.FDataElement as fDataElement,                            \r\n");
            sqlBuffer.append(" ENTRIES.FDebit as fDebit,                                    \t\r\n");
            sqlBuffer.append(" ENTRIES.FCredit as fCredit ,                                   \t\r\n");
            sqlBuffer.append(" ENTRIES.FValiDebit as fValiDebit,                                \r\n");
            sqlBuffer.append(" ENTRIES.FValiCredit as fValiCredit,                              \r\n");
            sqlBuffer.append(" exchcheckage.FDiffValue as fDiff,                      \t\t\t\r\n");
            sqlBuffer.append(" exchcheckage.FDiffMode as fDiffMode,                        \t\t\r\n");
            sqlBuffer.append(" CREATOR.FName_" + ctx.getLocale() + " as fCheckPerson ,     \t\t\r\n");
            sqlBuffer.append(" exchcheckage.FCreateTime as fCheckDate,                     \t\t\r\n");
            sqlBuffer.append(" exchcheckage.FCheckedStatus as fConfirmStatus,                   \r\n");
            sqlBuffer.append(" AUDITOR.FName_" + ctx.getLocale() + " as fConfirmPerson,         \r\n");
            sqlBuffer.append(" exchcheckage.FAuditDate as fConfirmDate,                      \t\r\n");
            sqlBuffer.append("  exchcheckage.FDescription as fRemark,                   \t\t\r\n");
            sqlBuffer.append(" exchcheckage.FSingleDC as fSingleDC,                        \t\t\r\n");
            sqlBuffer.append(" CURRENCY.FPrecision as fCurrencyPrecision,                       \r\n");
            sqlBuffer.append(" Company1.FNumber as FCompany1Number,    \r\n");
            sqlBuffer.append(" DATACOLLECT.FName_" + ctx.getLocale() + " as DataCollectName,    \r\n");
            if (!isQueryHisBudget) {
                sqlBuffer.append(" ENTRIES.FBeforeAdjustData as FBeforeAdjustData,   \r\n");
                sqlBuffer.append(" ENTRIES.FAdjustData as FAdjustData ,              \r\n");
            } else {
                sqlBuffer.append(" NULL as FBeforeAdjustData,   NULL as FAdjustData ,\r\n");
            }
            sqlBuffer.append(" ITEM.FDC as fitemDC,            \r\n");
            sqlBuffer.append(" ass.FName_").append(ctx.getLocale() + "  as assessor,     \r\n");
            sqlBuffer.append(" exchcheckage.FAssessDate as assessDate,     \r\n");
            sqlBuffer.append(" PARTY.FID as auditPartyId,     \r\n");
            sqlBuffer.append(" PARTY.FName_").append(ctx.getLocale() + " as auditPartyName, \r\n");
            sqlBuffer.append(" exchcheckage.FConfirmDiffVal as FConfirmDiff, \r\n");
            sqlBuffer.append(" exchcheckage.FLimitAmount as limitAmount \r\n");
            sqlBuffer.append(" FROM " + exchcheckage + " AS exchcheckage   \t\t\t\t\t\t\r\n");
            sqlBuffer.append(" LEFT OUTER JOIN T_PM_User AS CREATOR                \t\t\t\t\r\n");
            sqlBuffer.append(" ON exchcheckage.FCreatorID = CREATOR.FID       \t\t\t\t\t\r\n");
            sqlBuffer.append(" LEFT OUTER JOIN T_PM_User AS AUDITOR                \t\t\t\t\r\n");
            sqlBuffer.append(" ON exchcheckage.FAuditorID = AUDITOR.FID       \t\t\t\t\t\r\n");
            sqlBuffer.append(" INNER JOIN T_ORG_Tree AS ORGBOUND                   \t\t\t\t\r\n");
            sqlBuffer.append(" ON exchcheckage.FOrgBoundID = ORGBOUND.FID     \t\t\t\t\t\r\n");
            sqlBuffer.append(" INNER JOIN " + exchCheckageEntry + " AS ENTRIES       \t\t\t\t\r\n");
            sqlBuffer.append(" ON exchcheckage.FID = ENTRIES.FCheckageID      \t\t\t\t\t\r\n");
            sqlBuffer.append(" INNER JOIN T_BD_Currency AS CURRENCY                \t\t\t\t\r\n");
            sqlBuffer.append(" ON exchcheckage.FCurrencyID = CURRENCY.FID     \t\t\t\t\t\r\n");
            sqlBuffer.append(" LEFT OUTER JOIN T_CSL_ElimTemplet AS TEMPLET        \t\t\t\t\r\n");
            sqlBuffer.append(" ON exchcheckage.FTempletID = TEMPLET.FID       \t\t\t\t\t\r\n");
            sqlBuffer.append(" INNER JOIN T_CSL_DATACOLLECT AS DATACOLLECT         \r\n");
            sqlBuffer.append(" ON exchcheckage.FDataCollectNumber = DATACOLLECT.FNumber  \r\n");
            sqlBuffer.append(" LEFT OUTER JOIN T_CSL_ElimTempletENTRY AS TEMPLETENTRY        \t\r\n");
            sqlBuffer.append(" ON TEMPLETENTRY.FTempletID = TEMPLET.FID And TEMPLETENTRY.FItemID = ENTRIES.FItemID  \r\n");
            sqlBuffer.append(" And TEMPLETENTRY.FDataElement = ENTRIES.FDataElement");
            sqlBuffer.append(" INNER JOIN T_CSL_RptItem AS ITEM                    \t\t\t\t\r\n");
            sqlBuffer.append(" ON ENTRIES.FItemID = ITEM.FID                       \t\t\t\t\r\n");
            sqlBuffer.append(" INNER JOIN T_ORG_BaseUnit AS COMPANY1               \t\t\t\t\r\n");
            sqlBuffer.append(" ON ENTRIES.FCompanyID = COMPANY1.FID                \t\t\t\t\r\n");
            sqlBuffer.append(" INNER JOIN T_ORG_BaseUnit AS TARGETCOMPANY          \t\t\t\t\r\n");
            sqlBuffer.append(" ON ENTRIES.FTargetCompanyID = TARGETCOMPANY.FID     \t\t\t\t\r\n");
            if (ids == null && !isByCompany && mergeType == 1) {
                sqlBuffer.append(" inner join ").append(elimOrgUnitsTable).append(" t on t.fcompanyid=COMPANY1.fid and t.ftargetCompanyid=TARGETCOMPANY.fid");
            }
            sqlBuffer.append(" LEFT  JOIN T_ORG_BaseUnit AS PARTY          \t\t\t\t\r\n");
            sqlBuffer.append(" ON exchcheckage.FcheckedParty = PARTY.FID \r\n");
            sqlBuffer.append(" LEFT  JOIN T_PM_User AS ass          \t\t\t\t\r\n");
            sqlBuffer.append(" ON exchcheckage.FASSESSORID = ass.FID \r\n");
            if (ids == null) {
                boolean isFromMerge;
                sqlBuffer.append(" WHERE exchcheckage.FOrgBoundID = ?   \t\t\t\t\t\t\r\n");
                if (!isByCompany) {
                    sqlBuffer.append(" and exchcheckage.FOrgUnitID = ?   \t\t\t\t\t\t\r\n");
                    if (mergeType == 0) {
                        sqlBuffer.append(" and  COMPANY1.fid in (select fcompanyid from ").append(elimOrgUnitsTable).append(" ) ");
                        sqlBuffer.append(" and  TARGETCOMPANY.fid in (select fcompanyid from ").append(elimOrgUnitsTable).append(" ) ");
                    }
                }
                sqlBuffer.append(" and exchcheckage.FYear = ?   \t\t\t\t\t\t\t\t\r\n");
                sqlBuffer.append(" and exchcheckage.FPeriod = ?   \t\t\t\t\t\t\t\t\r\n");
                sqlBuffer.append(" and exchcheckage.FPeriodType = ?   \t\t\t\t\t\t\t\r\n");
                if (params.containsKey("confirmStatus")) {
                    sqlBuffer.append("    and exchcheckage.FCheckedStatus = ").append(params.getInt("confirmStatus")).append("   \r\n");
                }
                sp.addString(treeId);
                if (!isByCompany) {
                    sp.addString(orgUnitId);
                }
                sp.addInt(year).addInt(period).addInt(periodType);
                if (!StringUtils.isEmpty((String)companyId)) {
                    sqlBuffer.append(" and (COMPANY1.FID = ? or TARGETCOMPANY.FID = ? )\t\t\t\r\n");
                    sp.addString(companyId);
                    sp.addString(companyId);
                }
                if (fromCurrency != null && !fromCurrency.trim().equals("")) {
                    sqlBuffer.append("    and exchcheckage.FCurrencyID = ?   \t\t\t\t\t\r\n");
                    sp.addString(fromCurrency);
                }
                if (templetId != null && !templetId.trim().equals("")) {
                    sqlBuffer.append(" \tand exchcheckage.FTempletID = ?   \t\t\t\t\t\t\r\n");
                    sp.addString(templetId);
                }
                if (params.containsKey("exchTemList")) {
                    List exchTemList = null;
                    exchTemList = (List)params.getObject("exchTemList");
                    StringBuffer strExchTemListNum = new StringBuffer();
                    if (exchTemList != null && exchTemList.size() > 0) {
                        for (int i = 0; i < exchTemList.size(); ++i) {
                            strExchTemListNum.append("'").append(exchTemList.get(i)).append("'");
                            strExchTemListNum.append(",");
                        }
                        sqlBuffer.append(" \tand TEMPLET.fnumber in(").append(strExchTemListNum.toString().substring(0, strExchTemListNum.lastIndexOf(","))).append(") \t\t\t\t\t\t\r\n");
                    }
                }
                if (params.containsKey("compare")) {
                    String compare = params.getString("compare");
                    BigDecimal value = new BigDecimal(params.getString("value"));
                    sqlBuffer.append(" \tand exchcheckage.FDiffValue ").append(compare).append(" ").append(value).append("   \r\n");
                }
                if (isByCompany) {
                    if (c2 == null) {
                        sqlBuffer.append(" and (ENTRIES.FCompanyId = ? or ENTRIES.FTargetCompanyId = ? )");
                        sp.addString(c1).addString(c1);
                    } else {
                        sqlBuffer.append(" and ((ENTRIES.FCompanyId = ? and ENTRIES.FTargetCompanyId = ? )");
                        sqlBuffer.append(" or (ENTRIES.FCompanyId = ? and ENTRIES.FTargetCompanyId = ? ))");
                        sp.addString(c1).addString(c2).addString(c2).addString(c1);
                    }
                    if (checkedParty != null && 0 != checkedParty) {
                        if (1 == checkedParty) {
                            sqlBuffer.append(" and exchcheckage.FcheckedParty = ? \n");
                            sp.addString(c1);
                        } else if (2 == checkedParty) {
                            sqlBuffer.append(" and exchcheckage.FcheckedParty <> ? \n");
                            sp.addString(c1);
                        } else if (3 == checkedParty) {
                            sqlBuffer.append(" and exchcheckage.FcheckedParty IS NULL \n");
                        }
                    }
                    SameControlUtil.buildClearCompanySql((Object)sqlBuffer, clearCompays, (String)"ENTRIES", (ElimTypeEnum)ElimTypeEnum.exchange);
                }
                if (params.containsKey("isFromMerge") && (isFromMerge = params.getBoolean("isFromMerge")) && c2 != null) {
                    sqlBuffer.append(" and (ENTRIES.FCompanyId = ? or ENTRIES.FTargetCompanyId = ? )");
                    sp.addString(c2).addString(c2);
                }
                if (dataCollectNumber != null && dataCollectNumber.length() != 0) {
                    sqlBuffer.append(" and exchcheckage.fdatacollectnumber=? ");
                    sp.addString(dataCollectNumber);
                }
                if (items != null) {
                    sqlBuffer.append(" and ITEM.FNumber in(").append(CslRptUtil.AryToItemString(items));
                    sqlBuffer.append(")");
                }
            } else {
                sqlBuffer.append(" WHERE exchcheckage.fid in(").append(CslRptUtil.collection2String(ids, ",", true)).append(")");
            }
            if (isShowNotZero) {
                sqlBuffer.append(" \tand exchcheckage.FDiffValue <> 0   \t\t\t\t\t\t\r\n");
            }
            sqlBuffer.append(" and ((ENTRIES.FDebit <> 0) OR (ENTRIES.FCredit <> 0) \t\t\r\n");
            sqlBuffer.append(" OR (ENTRIES.FValiDebit <> 0) OR (ENTRIES.FValiCredit <> 0) \t\r\n");
            if (!isQueryHisBudget) {
                sqlBuffer.append(" or(ENTRIES.FBeforeAdjustData <>0)  \r\n");
                sqlBuffer.append(" or(ENTRIES.FAdjustData <>0 )       \r\n");
            }
            sqlBuffer.append(" ) \t\r\n");
            String tempTable = this.getTemplateTable(ctx, this.getCreateExchCheckageTmpTbleSql());
            StringBuffer insertSql = new StringBuffer();
            insertSql.append("insert into ").append(tempTable).append(sqlBuffer.toString());
            Connection con = null;
            try {
                con = this.getConnection(ctx);
                DbUtil.execute((String)insertSql.toString(), (SqlParams)sp, (Connection)con, (Context)ctx);
            }
            catch (SQLException e) {
                logger.error((Object)"execute error", (Throwable)e);
                throw new SQLDataException(e);
            }
            finally {
                SQLUtils.cleanup((Connection)con);
            }
            params.setString("tempTable", tempTable);
        }
        finally {
            if (!DebugLogger.isDebug && elimOrgUnitsTable != null) {
                TempTablePool.getInstance((Context)ctx).releaseTable(elimOrgUnitsTable);
            }
        }
        return params;
    }

    private String getTemplateTable(Context ctx, String createSql) throws BOSException {
        String tableName;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            tableName = pool.createTempTable(createSql);
            pool.createIndex(tableName, "FID", false, false);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tableName;
    }

    private String getCreateInterTmpTblSql() {
        StringBuffer sql = new StringBuffer();
        sql.append("create table T_CSL_InterItemData(FCompany NVARCHAR(255),FTargetCompany NVARCHAR(255),").append("FItemNumber NVARCHAR(80),FITEMNAME NVARCHAR(255),FDataElement INT,FromCurrency NVARCHAR(255),FTargetCurrency NVARCHAR(255),").append("BeforeAdjustData NUMERIC(28,13),adjustData NUMERIC(28,13),afterAdjustData NUMERIC(28,13),").append("FID VARCHAR(40),FPrecision INT,DataCollectName NVARCHAR(80),FimpName NVARCHAR(255))");
        return sql.toString();
    }

    private String getCreateExchTmpTblSql() {
        StringBuffer sql = new StringBuffer();
        sql.append("create table t_csl_exchItemData(FCompany NVARCHAR(255),FTargetCompany NVARCHAR(255),").append("FItemNumber NVARCHAR(80),FITEMNAME NVARCHAR(255),FDataElement INT,FromCurrency NVARCHAR(255),FTargetCurrency NVARCHAR(255),").append("BeforeAdjustData NUMERIC(28,13),adjustData NUMERIC(28,13),afterAdjustData NUMERIC(28,13),").append("FID VARCHAR(44),FPrecision INT,FDataCollectName NVARCHAR(80),FimpName NVARCHAR(255))");
        return sql.toString();
    }

    private String getCreateInterCheckTmpTbleSql() {
        StringBuffer sql = new StringBuffer();
        sql.append("create table T_CSL_InterDataCheckage(").append("FID VARCHAR(44),FNUMBER NVARCHAR(80),fElimTemplet NVARCHAR(80),fElimType INT,fCurrency NVARCHAR(80),").append("fCompanyID VARCHAR(44), fCompany NVARCHAR(510),fTargetCompanyID VARCHAR(44),fTargetCompany NVARCHAR(510),fItemNumber NVARCHAR(80),fItemName NVARCHAR(80),").append("fDataElement INT,fDebit NUMERIC(28,13),fCredit NUMERIC(28,13),").append("fValiDebit NUMERIC(28,13),fValiCredit NUMERIC(28,13),fDiff NUMERIC(28,13),fDiffMode INT,fCheckPerson NVARCHAR(80),").append("fCheckDate DateTime,fConfirmStatus INT,fConfirmPerson NVARCHAR(80),fConfirmDate DateTime,").append("fRemark NVARCHAR(200),fSingleDC INT,fCurrencyPrecision INT,FCompany1Number NVARCHAR(80),FDataCollect NVARCHAR(80),");
        sql.append("FBeforeAdjustData NUMERIC(21,6),FAdjustData NUMERIC(21,6), fitemDC INT,FAssessor NVARCHAR(80),FAssessDate DateTime,");
        sql.append("FauditPartyId VARCHAR(44),FauditPartyName NVARCHAR(80),FconfirmDiff NUMERIC(21,6),FLimitAmount NUMERIC(21,6))");
        return sql.toString();
    }

    private String getCreateExchCheckageTmpTbleSql() {
        StringBuffer sql = new StringBuffer();
        sql.append("create table T_CSL_InterDataCheckage(").append("FID VARCHAR(44),FNUMBER NVARCHAR(80),fElimTemplet NVARCHAR(80),fElimType INT,fCurrency NVARCHAR(80),").append("fCompanyID VARCHAR(44), fCompany NVARCHAR(510),fTargetCompanyID VARCHAR(44),fTargetCompany NVARCHAR(510),fItemNumber NVARCHAR(80),fItemName NVARCHAR(80),").append("fDataElement INT,fDebit NUMERIC(28,13),fCredit NUMERIC(28,13),fValiDebit NUMERIC(28,13),").append("fValiCredit NUMERIC(28,13),fDiff NUMERIC(28,13),fDiffMode INT,fCheckPerson NVARCHAR(80),").append("fCheckDate DateTime,fConfirmStatus INT,fConfirmPerson NVARCHAR(80),fConfirmDate DateTime,").append("fRemark NVARCHAR(200),fSingleDC INT,fCurrencyPrecision INT,FCompany1Number NVARCHAR(80),FDataCollect NVARCHAR(80),");
        sql.append("FBeforeAdjustData NUMERIC(21,6),FAdjustData NUMERIC(21,6), fitemDC INT,FAssessor NVARCHAR(80),FAssessDate DateTime,");
        sql.append("FauditPartyId VARCHAR(44),FauditPartyName NVARCHAR(80),FconfirmDiff NUMERIC(21,6),FLimitAmount NUMERIC(21,6))");
        return sql.toString();
    }

    private void updateExchItemData(Context ctx) throws BOSException, EASBizException {
        String sql = "select FId, FOrgBoundID, FReport from t_csl_exchItemData where FSourceType = 2 and FImportedGroup is null";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            sql = "Update t_csl_exchItemData set FImportedGroup = ? where FId = ?";
            HashMap<String, String> cache = new HashMap<String, String>();
            while (rowSet.next()) {
                String id = rowSet.getString("FId");
                String treeId = rowSet.getString("FOrgBoundID");
                String reportId = rowSet.getString("FReport");
                String groupId = (String)cache.get(treeId + "-" + reportId);
                if (groupId == null) {
                    groupId = this.getCurGroup(ctx, treeId, reportId);
                    cache.put(treeId + "-" + reportId, groupId);
                }
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{groupId, id});
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    @Override
    protected List _getAllInterDataCheckageIDs(Context ctx, RptProperties params) throws BOSException, EASBizException {
        int mergeType = params.getInt("MERGETYPE");
        int year = params.getInt("year");
        int period = params.getInt("period");
        int periodType = params.getInt("periodType");
        boolean isByCompany = params.getBoolean("isByCompany");
        String treeId = params.getString("treeId");
        if (isByCompany) {
            treeId = CslRptUtil.getBasicTree(ctx, FiscalPeriodHelper.getRptLastDate(treeId, year, period, RptPeriodTypeEnum.getEnum((int)periodType), ctx));
        }
        String orgUnitId = params.getString("orgUnitId");
        String companyId = params.getString("company");
        String fromCurrency = params.getString("fromCurrency");
        String templetId = params.getString("templet");
        boolean isShowNotZero = params.getBoolean("isShowNotZero");
        String c1 = (String)params.getObject("company");
        String c2 = (String)params.getObject("targetCompany");
        SqlParams sp = new SqlParams();
        String longNumber = null;
        int level = -1;
        IRowSet rsTemp = DbUtil.executeQuery((Context)ctx, (String)" select FLongNumber,FLevel From t_org_structure where ftreeid = ? and funitid = ?", (Object[])new Object[]{treeId, orgUnitId});
        try {
            while (rsTemp.next()) {
                longNumber = rsTemp.getString("FLongNumber");
                level = rsTemp.getInt("FLevel");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" SELECT                                              \r\n");
        sqlBuffer.append(" INTERDATACHECKAGE.FID as fid                        \r\n");
        sqlBuffer.append(" FROM T_CSL_InterDataCheckage AS INTERDATACHECKAGE   \r\n");
        sqlBuffer.append(" LEFT OUTER JOIN T_PM_User AS CREATOR                \r\n");
        sqlBuffer.append(" ON INTERDATACHECKAGE.FCreatorID = CREATOR.FID       \r\n");
        sqlBuffer.append(" LEFT OUTER JOIN T_PM_User AS AUDITOR                \r\n");
        sqlBuffer.append(" ON INTERDATACHECKAGE.FAuditorID = AUDITOR.FID       \r\n");
        sqlBuffer.append(" INNER JOIN T_ORG_Tree AS ORGBOUND                   \r\n");
        sqlBuffer.append(" ON INTERDATACHECKAGE.FOrgBoundID = ORGBOUND.FID     \r\n");
        sqlBuffer.append(" INNER JOIN T_CSL_DataCheckageEntry AS ENTRIES       \r\n");
        sqlBuffer.append(" ON INTERDATACHECKAGE.FID = ENTRIES.FCheckageID      \r\n");
        sqlBuffer.append(" INNER JOIN T_BD_Currency AS CURRENCY                \r\n");
        sqlBuffer.append(" ON INTERDATACHECKAGE.FCurrencyID = CURRENCY.FID     \r\n");
        sqlBuffer.append(" LEFT OUTER JOIN T_CSL_ElimTemplet AS TEMPLET        \r\n");
        sqlBuffer.append(" ON INTERDATACHECKAGE.FTempletID = TEMPLET.FID       \r\n");
        sqlBuffer.append(" LEFT OUTER JOIN T_CSL_ElimTempletENTRY AS TEMPLETENTRY        \r\n");
        sqlBuffer.append(" ON TEMPLETENTRY.FTempletID = TEMPLET.FID And TEMPLETENTRY.FItemID = ENTRIES.FItemID  \r\n");
        sqlBuffer.append(" INNER JOIN T_CSL_RptItem AS ITEM                    \r\n");
        sqlBuffer.append(" ON ENTRIES.FItemID = ITEM.FID                       \r\n");
        sqlBuffer.append(" INNER JOIN T_ORG_BaseUnit AS COMPANY1               \r\n");
        sqlBuffer.append(" ON ENTRIES.FCompanyID = COMPANY1.FID                \r\n");
        sqlBuffer.append(" INNER JOIN t_org_structure t1\t\t\t\t\t   \r\n");
        sqlBuffer.append(" ON t1.funitid = COMPANY1.fid AND t1.fisleaf = 1\t   \r\n");
        sqlBuffer.append(" AND t1.ftreeid = '").append(treeId).append("'\t   \r\n");
        if (!isByCompany) {
            sqlBuffer.append(" AND t1.flongnumber LIKE '").append(longNumber).append("!%'\r\n");
        }
        sqlBuffer.append(" INNER JOIN T_ORG_BaseUnit AS TARGETCOMPANY               \t\r\n");
        sqlBuffer.append(" ON ENTRIES.FTargetCompanyID = TARGETCOMPANY.FID          \t\r\n");
        sqlBuffer.append(" INNER JOIN t_org_structure t2\t\t\t\t\t\t        \r\n");
        sqlBuffer.append(" ON t2.funitid = TARGETCOMPANY.fid AND t2.fisleaf = 1\t\t\t\r\n");
        sqlBuffer.append(" AND t2.ftreeid = '").append(treeId).append("'\t\t\t\t\r\n");
        if (!isByCompany) {
            sqlBuffer.append(" AND t2.flongnumber LIKE '").append(longNumber).append("!%'\r\n");
        }
        sqlBuffer.append(" WHERE INTERDATACHECKAGE.FOrgBoundID = ?                  \t\r\n");
        if (!isByCompany) {
            sqlBuffer.append(" and INTERDATACHECKAGE.FOrgUnitID = ?                     \t\r\n");
        }
        sqlBuffer.append(" and INTERDATACHECKAGE.FYear = ?   \t\t\t\t\t\t\t\r\n");
        sqlBuffer.append(" and INTERDATACHECKAGE.FPeriod = ?   \t\t\t\t\t\t\t\r\n");
        sqlBuffer.append(" and INTERDATACHECKAGE.FPeriodType = ?   \t\t\t\t\t\t\r\n");
        sqlBuffer.append(" and ((ENTRIES.FDebit <> 0) OR (ENTRIES.FCredit <> 0) \t\t\r\n");
        sqlBuffer.append(" OR (ENTRIES.FValiDebit <> 0) OR (ENTRIES.FValiCredit <> 0)) \t\r\n");
        sp.addString(treeId);
        if (!isByCompany) {
            sp.addString(orgUnitId);
        }
        sp.addInt(year).addInt(period).addInt(periodType);
        if (!StringUtils.isEmpty((String)companyId)) {
            sqlBuffer.append(" and (COMPANY1.FID = ? or TARGETCOMPANY.FID = ? )\t\t\t\r\n");
            sp.addString(companyId);
            sp.addString(companyId);
        }
        if (!StringUtils.isEmpty((String)companyId)) {
            sqlBuffer.append(" and (COMPANY1.FID = ? or TARGETCOMPANY.FID = ? )\t\t\t\r\n");
            sp.addString(companyId);
            sp.addString(companyId);
        }
        if (fromCurrency != null && !fromCurrency.trim().equals("")) {
            sqlBuffer.append("    and INTERDATACHECKAGE.FCurrencyID = ?   \t\t\t\t\r\n");
            sp.addString(fromCurrency);
        }
        if (templetId != null && !templetId.trim().equals("")) {
            sqlBuffer.append(" \tand INTERDATACHECKAGE.FTempletID = ?   \t\t\t\t\t\r\n");
            sp.addString(templetId);
        }
        if (isShowNotZero) {
            sqlBuffer.append(" \tand INTERDATACHECKAGE.FDiffValue <> 0   \t\t\t\t\r\n");
        }
        if (params.containsKey("confirmStatus")) {
            sqlBuffer.append(" and INTERDATACHECKAGE.FCheckedStatus = ").append(params.getInt("confirmStatus")).append("   \r\n");
        }
        if (mergeType == 1) {
            sqlBuffer.append(this.getParamCompanyUnionSql(ctx, treeId, longNumber, level, "t1;t2"));
        }
        if (isByCompany) {
            if (c2 == null) {
                sqlBuffer.append(" and (ENTRIES.FCompanyId = ? or ENTRIES.FTargetCompanyId = ? )");
                sp.addString(c1).addString(c1);
            } else {
                sqlBuffer.append(" and ((ENTRIES.FCompanyId = ? and ENTRIES.FTargetCompanyId = ? )");
                sqlBuffer.append(" or (ENTRIES.FCompanyId = ? and ENTRIES.FTargetCompanyId = ? ))");
                sp.addString(c1).addString(c2).addString(c2).addString(c1);
            }
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString(), (Object[])sp.getParams());
        ArrayList<String> result = new ArrayList<String>();
        try {
            while (rowSet.next()) {
                result.add(rowSet.getString("fid"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return result;
    }

    @Override
    protected RptProperties _prepareFetchExchItemData(Context ctx, RptProperties params) throws BOSException, EASBizException {
        this.releaseTempTable(params, ctx);
        String inType = params.getString("WINDOWNAME");
        if (!StringUtils.isEmpty((String)inType)) {
            if (inType.equals("RPTEXCHITEMDATALISTUI")) {
                return this.prepareFetchExchItemDataToTempTable(ctx, params);
            }
            if (inType.equals("RPTINTERITEMDATALISTUI")) {
                return this.prepareFetchInterItemDataToTempTable(ctx, params);
            }
            if (inType.equals("INTERCHECKNEWLISTUI")) {
                return this.prepareFetchInterCheckDataToTmptbl(ctx, params);
            }
            if (inType.equals("EXCHCHECKAGELISTUI")) {
                return this.prepareFetchExchChkageDataToTmpTbl(ctx, params);
            }
            if (inType.equals("INTERANDEXCHCHECKNEWLISTUI")) {
                return this.prepareFetchInterAndExchCheckDataToTmptbl(ctx, params);
            }
            throw new IllegalArgumentException("WindowName argument is Illegal!");
        }
        throw new IllegalArgumentException("WindowName argument is Illegal!");
    }

    private void releaseTempTable(RptProperties params, Context ctx) {
        String temptable = params.getString("tempTable");
        if (StringUtils.isEmpty((String)temptable)) {
            return;
        }
        TempTablePool.getInstance((Context)ctx).releaseTable(temptable);
    }

    @Override
    protected RptRowSet _getAfterElimData(Context ctx, RptProperties params, List keys, int elimType) throws BOSException, EASBizException {
        String year = params.getObject("year") instanceof String ? params.getString("year") : String.valueOf(params.getInt("year"));
        String period = params.getObject("period") instanceof String ? params.getString("period") : String.valueOf(params.getInt("period"));
        String periodType = params.getObject("periodType") instanceof String ? params.getString("periodType") : String.valueOf(params.getInt("periodType"));
        String dataElement = params.getObject("dataElement") instanceof String ? params.getString("dataElement") : String.valueOf(params.getInt("dataElement"));
        String treeId = params.getString("treeId");
        String orgUnitLongNumber = params.getString("orgUnitLongNumber");
        String currencyId = params.getString("currencyId");
        String dataCollect = params.getString("dataCollection");
        String strIdCondition = "";
        String[] tempIds = null;
        int size = keys.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                strIdCondition = strIdCondition + " or ";
            }
            tempIds = keys.get(i).toString().split("@@");
            strIdCondition = strIdCondition + "(fromcompany.fid = '" + tempIds[0] + "' and targetcompany.fid = '" + tempIds[1] + "')";
        }
        if (!strIdCondition.equals("")) {
            strIdCondition = "(" + strIdCondition + ")";
        }
        boolean isQueryHisBudget = params.getBoolean("isQueryHisBudget");
        String rptReceiveTabName = QueryHisBudgetUtils.getRptReceiveTabName(isQueryHisBudget);
        String itemDataTableName = null;
        itemDataTableName = isQueryHisBudget ? (elimType == 3 ? "T_CSL_HisExchItemData" : "T_CSL_HisInterItemData") : (elimType == 3 ? "T_CSL_ExchItemData" : "T_CSL_InterItemData");
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT fromcompany.fid as fromCompanyId,targetcompany.fid as targetCompanyId, ");
        sql.append(" fromcompany.fnumber || '-' || fromcompany.FName_" + ctx.getLocale() + " as Company, ");
        sql.append(" targetcompany.fnumber || '-' || targetcompany.FName_" + ctx.getLocale() + " as TargetCompany, ");
        sql.append(" rptitem.Fid as ItemId,itemdata.FMoney as Money,fromcurrency.FPrecision as currencyPrecision ");
        sql.append(" FROM " + itemDataTableName + " itemdata ");
        sql.append(" INNER JOIN T_BD_Currency  fromcurrency  ON itemdata.FCurrencyID = fromcurrency.FID ");
        sql.append(" INNER JOIN T_BD_Currency  targetcurrency  ON itemdata.FTargetCurrencyID = targetcurrency.FID ");
        sql.append(" INNER JOIN T_CSL_DATACOLLECT  datacollect ON itemdata.FDataCollectNumber = datacollect.FNumber ");
        sql.append(" INNER JOIN ").append(rptReceiveTabName).append("  rptreceived ON itemdata.FReport = rptreceived.FReportID ");
        sql.append(" INNER JOIN T_CSL_RptItem  rptitem ON itemdata.FItemNumber = rptitem.FNumber ");
        sql.append(" INNER JOIN T_ORG_BaseUnit  fromcompany ON itemdata.FCompanyID = fromcompany.FID ");
        sql.append(" INNER JOIN T_ORG_BaseUnit  targetcompany ON itemdata.FTargetCompanyID = targetcompany.FID ");
        sql.append(" INNER Join ( ");
        sql.append(" \tSelect f1.FCompanyId,f1.FLongNumber as FLongNumber From ");
        sql.append(" \t(Select t1.FUnitId As FCompanyId,t1.FLongNumber ");
        sql.append(" \tFrom t_org_structure t1  ");
        sql.append(" \tjoin t_org_baseunit t2 on t1.funitid=t2.fid ");
        sql.append(" \twhere (t1.flongnumber = '" + orgUnitLongNumber + "' or t1.flongnumber like '" + orgUnitLongNumber + "!%') and t1.ftreeid='" + treeId + "') f1 ");
        sql.append(" ) fromRange on itemdata.fcompanyid = fromRange.fcompanyid ");
        sql.append(" WHERE fromcompany.FID!=targetcompany.FID and (itemdata.FMoney <> 0) ");
        sql.append(" and itemdata.FCommitStatus = 3");
        sql.append(" and rptreceived.FOrgTreeID = '" + treeId + "' ");
        sql.append(" and itemdata.FYear = " + year);
        sql.append(" and itemdata.FPeriod = " + period);
        sql.append(" and itemdata.FPeriodType = " + periodType);
        sql.append(" and itemdata.fdataelement = " + dataElement);
        sql.append(" and itemdata.fdatacollectnumber = '" + dataCollect + "' ");
        sql.append(" and itemdata.FCurrencyID = '" + currencyId + "' ");
        sql.append(" and not exists (");
        sql.append(" \tSelect t1.FUnitId ");
        sql.append(" \tFrom t_org_structure t1  ");
        sql.append(" \tjoin t_org_baseunit t2 on t1.funitid=t2.fid ");
        sql.append(" \twhere (t1.flongnumber = '" + orgUnitLongNumber + "' or t1.flongnumber like '" + orgUnitLongNumber + "!%') and t1.ftreeid='" + treeId + "' ");
        sql.append(" \tand itemdata.ftargetcompanyid = t1.FUnitId ");
        sql.append(" ) \r\n");
        sql.append(" and " + strIdCondition + "  \r\n");
        sql.append(" order by fromcompany.fnumber,targetcompany.fnumber ");
        RptRowSet rst = null;
        Connection con = null;
        try {
            con = this.getConnection(ctx);
            rst = DBUtil.executeQuery((String)sql.toString(), (Connection)con);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
        return rst;
    }

    @Override
    protected List _getAfterElimKeys(Context ctx, RptProperties params, int elimType) throws BOSException, EASBizException {
        int from = params.getInt("from");
        int length = params.getInt("length");
        String year = params.getObject("year") instanceof String ? params.getString("year") : String.valueOf(params.getInt("year"));
        String period = params.getObject("period") instanceof String ? params.getString("period") : String.valueOf(params.getInt("period"));
        String periodType = params.getObject("periodType") instanceof String ? params.getString("periodType") : String.valueOf(params.getInt("periodType"));
        String dataElement = params.getObject("dataElement") instanceof String ? params.getString("dataElement") : String.valueOf(params.getInt("dataElement"));
        String treeId = params.getString("treeId");
        String orgUnitLongNumber = params.getString("orgUnitLongNumber");
        String currencyId = params.getString("currencyId");
        String dataCollect = params.getString("dataCollection");
        boolean isQueryHisBudget = params.getBoolean("isQueryHisBudget");
        String rptReceiveTabName = QueryHisBudgetUtils.getRptReceiveTabName(isQueryHisBudget);
        String itemDataTableName = null;
        itemDataTableName = isQueryHisBudget ? (elimType == 3 ? "T_CSL_HisExchItemData" : "T_CSL_HisInterItemData") : (elimType == 3 ? "T_CSL_ExchItemData" : "T_CSL_InterItemData");
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT distinct itemdata.fcompanyid as fromCompanyId,itemdata.ftargetcompanyid as targetCompanyId, ");
        sql.append(" fromcompany.fnumber as fromComNumber,targetcompany.fnumber as targetComNumber ");
        sql.append(" FROM " + itemDataTableName + " itemdata ");
        sql.append(" INNER JOIN T_BD_Currency  fromcurrency  ON itemdata.FCurrencyID = fromcurrency.FID ");
        sql.append(" INNER JOIN T_BD_Currency  targetcurrency  ON itemdata.FTargetCurrencyID = targetcurrency.FID ");
        sql.append(" INNER JOIN T_CSL_DATACOLLECT  datacollect ON itemdata.FDataCollectNumber = datacollect.FNumber ");
        sql.append(" INNER JOIN ").append(rptReceiveTabName).append("  rptreceived ON itemdata.FReport = rptreceived.FReportID ");
        sql.append(" INNER JOIN T_CSL_RptItem  rptitem ON itemdata.FItemNumber = rptitem.FNumber ");
        sql.append(" INNER JOIN T_ORG_BaseUnit  fromcompany ON itemdata.FCompanyID = fromcompany.FID ");
        sql.append(" INNER JOIN T_ORG_BaseUnit  targetcompany ON itemdata.FTargetCompanyID = targetcompany.FID ");
        sql.append(" INNER Join ( ");
        sql.append(" \tSelect f1.FCompanyId,f1.FLongNumber as FLongNumber From ");
        sql.append(" \t(Select t1.FUnitId As FCompanyId,t1.FLongNumber ");
        sql.append(" \tFrom t_org_structure t1  ");
        sql.append(" \tjoin t_org_baseunit t2 on t1.funitid=t2.fid ");
        sql.append(" \twhere (t1.flongnumber = '" + orgUnitLongNumber + "' or t1.flongnumber like '" + orgUnitLongNumber + "!%') and t1.ftreeid='" + treeId + "') f1 ");
        sql.append(" ) fromRange on itemdata.fcompanyid = fromRange.fcompanyid ");
        sql.append(" WHERE fromcompany.FID!=targetcompany.FID and (itemdata.FMoney <> 0) ");
        sql.append(" and itemdata.FCommitStatus = 3");
        sql.append(" and rptreceived.FOrgTreeID = '" + treeId + "' ");
        sql.append(" and itemdata.FYear = " + year);
        sql.append(" and itemdata.FPeriod = " + period);
        sql.append(" and itemdata.FPeriodType = " + periodType);
        sql.append(" and itemdata.fdataelement = " + dataElement);
        sql.append(" and itemdata.fdatacollectnumber = '" + dataCollect + "' ");
        sql.append(" and itemdata.FCurrencyID = '" + currencyId + "' ");
        sql.append(" and not exists (");
        sql.append(" \tSelect t1.FUnitId ");
        sql.append(" \tFrom t_org_structure t1  ");
        sql.append(" \tjoin t_org_baseunit t2 on t1.funitid=t2.fid ");
        sql.append(" \twhere (t1.flongnumber = '" + orgUnitLongNumber + "' or t1.flongnumber like '" + orgUnitLongNumber + "!%') and t1.ftreeid='" + treeId + "' ");
        sql.append(" \tand itemdata.ftargetcompanyid = t1.FUnitId ");
        sql.append(" ) ");
        ArrayList<String> lstRtn = new ArrayList<String>();
        RptRowSet rst = null;
        Connection con = null;
        try {
            con = this.getConnection(ctx);
            String strForTopSql = "select TKeys.* from (" + sql.toString() + ") TKeys order by TKeys.fromComNumber,TKeys.targetComNumber ";
            rst = DbUtil.executeQuery((Context)ctx, (String)strForTopSql, null, (int)from, (int)length, (Connection)con);
            while (rst.next()) {
                lstRtn.add(rst.getString("fromCompanyId") + "@@" + rst.getString("targetCompanyId"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
        return lstRtn;
    }

    @Override
    protected RptRowSet _getAfterElimRptData4Exch(Context ctx, RptProperties params) throws BOSException, EASBizException {
        int dataElement;
        int from = params.getInt("from");
        int length = params.getInt("length");
        int year = params.getInt("year");
        int period = params.getInt("period");
        int periodType = params.getInt("periodType");
        String treeId = params.getString("treeId");
        String orgUnitId = params.getString("orgUnitId");
        String dataCollectNumber = params.getString("dataCollectNumber");
        String fromCurrency = params.getString("fromCurrency");
        String c1 = (String)params.getObject("company");
        String c2 = (String)params.getObject("targetCompany");
        boolean isQueryHisBudget = params.getBoolean("isQueryHisBudget");
        String exchCheckageTabName = QueryHisBudgetUtils.getExchCheckageTabName(isQueryHisBudget);
        String exchCheckageEntryTabName = QueryHisBudgetUtils.getExchCheckageEntryTabName(isQueryHisBudget);
        String itemdataTableName = isQueryHisBudget ? "T_CSL_HisExchItemdata" : "T_CSL_ExchItemdata";
        SqlParams sp = new SqlParams();
        String longNumber = null;
        IRowSet rsTemp = DbUtil.executeQuery((Context)ctx, (String)" select FLongNumber,FLevel From t_org_structure where ftreeid = ? and funitid = ?", (Object[])new Object[]{treeId, orgUnitId});
        try {
            while (rsTemp.next()) {
                longNumber = rsTemp.getString("FLongNumber");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" select * from ( \n");
        sqlBuffer.append(" SELECT                                              \r\n");
        sqlBuffer.append(" exchcheckage.FID as fid,                             \r\n");
        sqlBuffer.append(" exchcheckage.Forgunitid as FCheckUnit, \r\n");
        sqlBuffer.append(" exchcheckage.FNumber as fNumber,                          \r\n");
        sqlBuffer.append(" TEMPLET.FName as fElimTemplet,                                     \r\n");
        sqlBuffer.append(" CURRENCY.FName_" + ctx.getLocale() + " as fCurrency,          \r\n");
        sqlBuffer.append(" MergeUnit.FName_" + ctx.getLocale() + " as FMergeUnitName, \r\n");
        sqlBuffer.append(" COMPANY1.FID as fCOMPANY1ID,  \t\t\t\t  \r\n");
        sqlBuffer.append(" COMPANY1.FName_" + ctx.getLocale() + " as fCompany,           \r\n");
        sqlBuffer.append(" TARGETCOMPANY.FID as fTargetCompanyID,  \t\t\t\t  \r\n");
        sqlBuffer.append(" TARGETCOMPANY.FName_" + ctx.getLocale() + " as fTargetCompany,   \r\n");
        sqlBuffer.append(" ITEM.FNumber as fItemNumber,                                      \r\n");
        sqlBuffer.append(" ITEM.FName_" + ctx.getLocale() + " as fItemName,               \r\n");
        sqlBuffer.append(" ENTRIES.FDataElement as fDataElement,                           \r\n");
        sqlBuffer.append(" ENTRIES.FDebit as fDebit,                                    \r\n");
        sqlBuffer.append(" ENTRIES.FCredit as fCredit ,                                   \r\n");
        sqlBuffer.append(" ENTRIES.FValiDebit as fValiDebit,                                \r\n");
        sqlBuffer.append(" ENTRIES.FValiCredit as fValiCredit,                               \r\n");
        sqlBuffer.append(" exchcheckage.FDiffValue as fDiff,                      \r\n");
        sqlBuffer.append(" CURRENCY.FPrecision as fCurrencyPrecision                       \r\n");
        sqlBuffer.append(" FROM ").append(exchCheckageTabName).append(" AS exchcheckage   \r\n");
        sqlBuffer.append(" INNER JOIN T_ORG_Tree AS ORGBOUND                   \r\n");
        sqlBuffer.append(" ON exchcheckage.FOrgBoundID = ORGBOUND.FID     \r\n");
        sqlBuffer.append(" INNER JOIN ").append(exchCheckageEntryTabName).append(" AS ENTRIES       \r\n");
        sqlBuffer.append(" ON exchcheckage.FID = ENTRIES.FCheckageID      \r\n");
        sqlBuffer.append(" INNER JOIN T_BD_Currency AS CURRENCY                \r\n");
        sqlBuffer.append(" ON exchcheckage.FCurrencyID = CURRENCY.FID     \r\n");
        sqlBuffer.append(" LEFT OUTER JOIN T_CSL_ElimTemplet AS TEMPLET        \r\n");
        sqlBuffer.append(" ON exchcheckage.FTempletID = TEMPLET.FID       \r\n");
        sqlBuffer.append(" LEFT OUTER JOIN T_CSL_ElimTempletENTRY AS TEMPLETENTRY        \r\n");
        sqlBuffer.append(" ON TEMPLETENTRY.FTempletID = TEMPLET.FID And TEMPLETENTRY.FItemID = ENTRIES.FItemID  \r\n");
        sqlBuffer.append(" And TEMPLETENTRY.FDataElement = ENTRIES.FDataElement");
        sqlBuffer.append(" INNER JOIN T_CSL_RptItem AS ITEM                    \r\n");
        sqlBuffer.append(" ON ENTRIES.FItemID = ITEM.FID                       \r\n");
        sqlBuffer.append(" INNER JOIN T_ORG_BaseUnit AS COMPANY1               \r\n");
        sqlBuffer.append(" ON ENTRIES.FCompanyID = COMPANY1.FID                \r\n");
        sqlBuffer.append(" INNER JOIN t_org_structure t1                        \r\n");
        sqlBuffer.append(" ON t1.funitid = COMPANY1.fid AND t1.fisleaf = 1      \r\n");
        sqlBuffer.append(" AND t1.ftreeid = '").append(treeId).append("'        \r\n");
        sqlBuffer.append(" AND t1.flongnumber LIKE '").append(longNumber).append("%'\r\n");
        sqlBuffer.append(" INNER JOIN T_ORG_Structure pStructure\t\t\r\n");
        sqlBuffer.append(" ON pStructure.FID = t1.Fparentid         \t\r\n");
        sqlBuffer.append(" INNER JOIN T_ORG_BaseUnit AS MergeUnit       \r\n");
        sqlBuffer.append(" ON MergeUnit.FID = pStructure.FUnitID        \r\n");
        sqlBuffer.append(" INNER JOIN T_ORG_BaseUnit AS TARGETCOMPANY          \r\n");
        sqlBuffer.append(" ON ENTRIES.FTargetCompanyID = TARGETCOMPANY.FID     \r\n");
        sqlBuffer.append(" INNER JOIN t_org_structure t2                        \r\n");
        sqlBuffer.append(" ON t2.funitid = TARGETCOMPANY.fid AND t2.fisleaf = 1      \r\n");
        sqlBuffer.append(" AND t2.ftreeid = '").append(treeId).append("'        \r\n");
        sqlBuffer.append(" AND t2.flongnumber LIKE '").append(longNumber).append("%'\r\n");
        sqlBuffer.append(" WHERE exchcheckage.FYear = ?   \r\n");
        sqlBuffer.append(" and exchcheckage.FPeriod = ?   \r\n");
        sqlBuffer.append(" and exchcheckage.FPeriodType = ?   \r\n");
        sqlBuffer.append(" and exchcheckage.FOrgBoundId = '").append(treeId).append("'");
        sqlBuffer.append(" and ((ENTRIES.FDebit <> 0) OR (ENTRIES.FCredit <> 0)         \r\n");
        sqlBuffer.append(" OR (ENTRIES.FValiDebit <> 0) OR (ENTRIES.FValiCredit <> 0))  \r\n");
        sp.addInt(year).addInt(period).addInt(periodType);
        if (fromCurrency != null && !fromCurrency.trim().equals("")) {
            sqlBuffer.append(" and exchcheckage.FCurrencyID = ?   \r\n");
            sp.addString(fromCurrency);
        }
        if (c1 != null) {
            sqlBuffer.append(" and COMPANY1.FID = ? ");
            sp.addString(c1);
        }
        if (c2 != null) {
            sqlBuffer.append(" and TARGETCOMPANY.FID = ? ");
            sp.addString(c2);
        }
        if ((dataElement = params.getInt("dataElement")) > 0) {
            sqlBuffer.append(" and ENTRIES.FDataElement = ? \r\n");
            sp.addInt(dataElement);
        }
        if (dataCollectNumber != null && dataCollectNumber.length() != 0) {
            sqlBuffer.append(" and exchcheckage.fdatacollectnumber=? \r\n");
            sp.addString(dataCollectNumber);
        }
        sqlBuffer.append(" UNION  \r\n");
        sqlBuffer.append(" select  distinct \r\n");
        sqlBuffer.append(" Interitemdata.FID as Fid,  \r\n");
        sqlBuffer.append(" '' as FCheckUnit,  \r\n");
        sqlBuffer.append(" N'' as FNumber,  \r\n");
        sqlBuffer.append(" N'' as fElimTemplet,  \r\n");
        sqlBuffer.append(" CURRENCY.FName_" + ctx.getLocale() + " as fCurrency,  \r\n");
        sqlBuffer.append(" MergeUnit.FName_" + ctx.getLocale() + " as FMergeUnitName,  \r\n");
        sqlBuffer.append(" COMPANY1.FID as  fCompanyID, \t\t\t\t\t\t\t  \r\n");
        sqlBuffer.append(" COMPANY1.FName_" + ctx.getLocale() + " as fCompany,  \r\n");
        sqlBuffer.append(" TARGETCOMPANY.FID as fTargetCompanyID,  \t\t\t\t  \r\n");
        sqlBuffer.append(" TARGETCOMPANY.FName_" + ctx.getLocale() + " as fTargetCompany,  \r\n");
        sqlBuffer.append(" ITEM.FNumber as fItemNumber,  \r\n");
        sqlBuffer.append(" ITEM.FName_" + ctx.getLocale() + " as fItemName,  \r\n");
        sqlBuffer.append(" Interitemdata.FDataElement as fDataElement,  \r\n");
        sqlBuffer.append(" case when ITEM.Fdc=0 then Interitemdata.Fmoney else 0 end as FDebit,  \r\n");
        sqlBuffer.append(" case when ITEM.Fdc=1 then Interitemdata.Fmoney else 0 end as fCredit,  \r\n");
        sqlBuffer.append(" 0 as fValiDebit,  \r\n");
        sqlBuffer.append(" 0 as fValiCredit,  \r\n");
        sqlBuffer.append(" 0 as fDiff,  \r\n");
        sqlBuffer.append(" CURRENCY.FPrecision as fCurrencyPrecision  \r\n");
        sqlBuffer.append(" FROM ").append(itemdataTableName).append(" Interitemdata  \r\n");
        sqlBuffer.append(" INNER JOIN T_BD_Currency CURRENCY ON Interitemdata.FCurrencyID = CURRENCY.FID  \r\n");
        sqlBuffer.append(" INNER JOIN T_ORG_BaseUnit COMPANY1 ON Interitemdata.FCompanyID = COMPANY1.FID  \r\n");
        sqlBuffer.append(" INNER JOIN t_org_structure t1 ON t1.funitid = COMPANY1.fid AND t1.fisleaf = 1  \r\n");
        sqlBuffer.append(" AND t1.ftreeid = '").append(treeId).append("'        \r\n");
        sqlBuffer.append(" AND t1.flongnumber LIKE '").append(longNumber).append("%'\r\n");
        sqlBuffer.append(" INNER JOIN T_ORG_Structure pStructure ON pStructure.FID = t1.Fparentid   \r\n");
        sqlBuffer.append(" INNER JOIN T_ORG_BaseUnit MergeUnit ON MergeUnit.FID = pStructure.FUnitID  \r\n");
        sqlBuffer.append(" INNER JOIN T_ORG_BaseUnit TARGETCOMPANY ON Interitemdata.FTargetCompanyID = TARGETCOMPANY.FID  \r\n");
        sqlBuffer.append(" INNER JOIN t_org_structure t2 ON t2.funitid = TARGETCOMPANY.fid AND t2.fisleaf = 1  AND t2.ftreeid = '").append(treeId).append("'        \r\n");
        sqlBuffer.append(" INNER JOIN T_CSL_RptItem ITEM ON Interitemdata.Fitemnumber = ITEM.Fnumber  \r\n");
        sqlBuffer.append(" INNER JOIN t_csl_rptreceived rec ON rec.freportid = Interitemdata.freport  \r\n");
        sqlBuffer.append(" WHERE Interitemdata.FYear = ?  \r\n");
        sqlBuffer.append(" and Interitemdata.FPeriod = ?    \r\n");
        sqlBuffer.append(" and Interitemdata.FPeriodType = ?  \r\n");
        sqlBuffer.append(" and (Interitemdata.forgboundid is null and  rec.forgtreeid = ?  or Interitemdata.forgboundid=?) \r\n");
        sqlBuffer.append(" and Interitemdata.Fmoney <> 0  \r\n");
        sqlBuffer.append(" and Interitemdata.FdataCollectNumber = ?  \r\n");
        sqlBuffer.append(" and Interitemdata.Fcommitstatus =3  \r\n");
        sp.addInt(year).addInt(period).addInt(periodType);
        sp.addString(treeId).addString(treeId);
        sp.addString(dataCollectNumber);
        sqlBuffer.append(" AND Interitemdata.FTargetCompanyID not in ( \r\n");
        sqlBuffer.append("  select distinct t3.funitid from t_org_structure t3  where t3.fisleaf = 1 \r\n");
        sqlBuffer.append("  AND t3.ftreeid = ? AND t3.flongnumber LIKE ? )  \r\n");
        sp.addString(treeId).addString(longNumber + "%");
        if (fromCurrency != null && !fromCurrency.trim().equals("")) {
            sqlBuffer.append(" and Interitemdata.FCurrencyID = ?   \r\n");
            sp.addString(fromCurrency);
        }
        if (c1 != null) {
            sqlBuffer.append(" and Interitemdata.FCompanyID = ? ");
            sp.addString(c1);
        }
        if (c2 != null) {
            sqlBuffer.append(" and Interitemdata.FTargetCompanyID = ? ");
            sp.addString(c2);
        }
        if (dataElement > 0) {
            sqlBuffer.append(" and Interitemdata.FDataElement = ? \r\n");
            sp.addInt(dataElement);
        }
        sqlBuffer.append(" ) tt \n");
        sqlBuffer.append(" ORDER BY FCheckUnit ASC, FNumber ASC,  FCurrency ASC, fElimTemplet ASC, fCompany Asc, fTargetCompany ASC, fItemNumber, fDataElement  \r\n");
        RptRowSet rst = null;
        Connection con = null;
        try {
            con = this.getConnection(ctx);
            rst = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString(), (SqlParams)sp, (int)from, (int)length, (Connection)con);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
        return rst;
    }

    @Override
    protected RptRowSet _getAfterElimRptData4Inter(Context ctx, RptProperties params) throws BOSException, EASBizException {
        int dataElement;
        int from = params.getInt("from");
        int length = params.getInt("length");
        int year = params.getInt("year");
        int period = params.getInt("period");
        int periodType = params.getInt("periodType");
        String treeId = params.getString("treeId");
        String orgUnitId = params.getString("orgUnitId");
        String dataCollectNumber = params.getString("dataCollectNumber");
        String fromCurrency = params.getString("fromCurrency");
        String c1 = (String)params.getObject("company");
        String c2 = (String)params.getObject("targetCompany");
        boolean isQueryHisBudget = params.getBoolean("isQueryHisBudget");
        String interCheckageTabName = QueryHisBudgetUtils.getInterCheckageTabName(isQueryHisBudget);
        String interCheckageEntryTabName = QueryHisBudgetUtils.getInterCheckageEntryTabName(isQueryHisBudget);
        SqlParams sp = new SqlParams();
        String longNumber = null;
        IRowSet rsTemp = DbUtil.executeQuery((Context)ctx, (String)" select FLongNumber,FLevel From t_org_structure where ftreeid = ? and funitid = ?", (Object[])new Object[]{treeId, orgUnitId});
        try {
            while (rsTemp.next()) {
                longNumber = rsTemp.getString("FLongNumber");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        String lang = ctx.getLocale().toString();
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("select * from ( \n");
        sqlBuffer.append(" SELECT                                              \r\n");
        sqlBuffer.append(" INTERDATACHECKAGE.FID as fid,                     \r\n");
        sqlBuffer.append(" INTERDATACHECKAGE.Forgunitid as FCheckUnit, \r\n");
        sqlBuffer.append(" INTERDATACHECKAGE.FNumber as fNumber,               \r\n");
        sqlBuffer.append(" TEMPLET.FName as fElimTemplet,            \r\n");
        sqlBuffer.append(" CURRENCY.FName_" + lang + " as fCurrency,            \r\n");
        sqlBuffer.append(" MergeUnit.FName_" + lang + " as FMergeUnitName,            \r\n");
        sqlBuffer.append(" COMPANY1.FID as  fCompanyID, \t\t\t\t\t\t\t  \r\n");
        sqlBuffer.append(" COMPANY1.FName_" + lang + " as fCompany,             \r\n");
        sqlBuffer.append(" TARGETCOMPANY.FID as fTargetCompanyID,  \t\t\t\t  \r\n");
        sqlBuffer.append(" TARGETCOMPANY.FName_" + lang + " as fTargetCompany,   \r\n");
        sqlBuffer.append(" ITEM.FNumber as fItemNumber,                         \r\n");
        sqlBuffer.append(" ITEM.FName_" + lang + " as fItemName,                \r\n");
        sqlBuffer.append(" ENTRIES.FDataElement as fDataElement,                 \r\n");
        sqlBuffer.append(" ENTRIES.FDebit as fDebit,                             \r\n");
        sqlBuffer.append(" ENTRIES.FCredit as fCredit ,                          \r\n");
        sqlBuffer.append(" ENTRIES.FValiDebit as fValiDebit,                     \r\n");
        sqlBuffer.append(" ENTRIES.FValiCredit as fValiCredit,                   \r\n");
        sqlBuffer.append(" INTERDATACHECKAGE.FDiffValue as fDiff,                      \r\n");
        sqlBuffer.append(" CURRENCY.FPrecision as fCurrencyPrecision                        \r\n");
        sqlBuffer.append(" FROM ").append(interCheckageTabName).append(" INTERDATACHECKAGE   \r\n");
        sqlBuffer.append(" INNER JOIN T_ORG_Tree ORGBOUND                   \r\n");
        sqlBuffer.append(" ON INTERDATACHECKAGE.FOrgBoundID = ORGBOUND.FID     \r\n");
        sqlBuffer.append(" INNER JOIN ").append(interCheckageEntryTabName).append(" ENTRIES       \r\n");
        sqlBuffer.append(" ON INTERDATACHECKAGE.FID = ENTRIES.FCheckageID      \r\n");
        sqlBuffer.append(" INNER JOIN T_BD_Currency CURRENCY                \r\n");
        sqlBuffer.append(" ON INTERDATACHECKAGE.FCurrencyID = CURRENCY.FID     \r\n");
        sqlBuffer.append(" LEFT OUTER JOIN T_CSL_ElimTemplet TEMPLET        \r\n");
        sqlBuffer.append(" ON INTERDATACHECKAGE.FTempletID = TEMPLET.FID       \r\n");
        sqlBuffer.append(" LEFT OUTER JOIN T_CSL_ElimTempletENTRY TEMPLETENTRY        \r\n");
        sqlBuffer.append(" ON TEMPLETENTRY.FTempletID = TEMPLET.FID And TEMPLETENTRY.FItemID = ENTRIES.FItemID  \r\n");
        sqlBuffer.append(" And TEMPLETENTRY.FDataElement = ENTRIES.FDataElement \r\n");
        sqlBuffer.append(" INNER JOIN T_CSL_RptItem ITEM                    \r\n");
        sqlBuffer.append(" ON ENTRIES.FItemID = ITEM.FID                       \r\n");
        sqlBuffer.append(" INNER JOIN T_ORG_BaseUnit COMPANY1               \r\n");
        sqlBuffer.append(" ON ENTRIES.FCompanyID = COMPANY1.FID                \r\n");
        sqlBuffer.append(" INNER JOIN t_org_structure t1                        \r\n");
        sqlBuffer.append(" ON t1.funitid = COMPANY1.fid AND t1.fisleaf = 1      \r\n");
        sqlBuffer.append(" AND t1.ftreeid = '").append(treeId).append("'        \r\n");
        sqlBuffer.append(" AND t1.flongnumber LIKE '").append(longNumber).append("%'\r\n");
        sqlBuffer.append(" INNER JOIN T_ORG_Structure pStructure\t\t\r\n");
        sqlBuffer.append(" ON pStructure.FID = t1.Fparentid         \t\r\n");
        sqlBuffer.append(" INNER JOIN T_ORG_BaseUnit MergeUnit       \r\n");
        sqlBuffer.append(" ON MergeUnit.FID = pStructure.FUnitID        \r\n");
        sqlBuffer.append(" INNER JOIN T_ORG_BaseUnit TARGETCOMPANY          \r\n");
        sqlBuffer.append(" ON ENTRIES.FTargetCompanyID = TARGETCOMPANY.FID     \r\n");
        sqlBuffer.append(" INNER JOIN t_org_structure t2                        \r\n");
        sqlBuffer.append(" ON t2.funitid = TARGETCOMPANY.fid AND t2.fisleaf = 1      \r\n");
        sqlBuffer.append(" AND t2.ftreeid = '").append(treeId).append("'        \r\n");
        sqlBuffer.append(" AND t2.flongnumber LIKE '").append(longNumber).append("%'\r\n");
        sqlBuffer.append(" WHERE INTERDATACHECKAGE.FYear = ?   \r\n");
        sqlBuffer.append(" and INTERDATACHECKAGE.FPeriod = ?   \r\n");
        sqlBuffer.append(" and INTERDATACHECKAGE.FPeriodType = ?   \r\n");
        sqlBuffer.append(" and INTERDATACHECKAGE.FOrgBoundId = '").append(treeId).append("'");
        sqlBuffer.append(" and ((ENTRIES.FDebit <> 0) OR (ENTRIES.FCredit <> 0)         \r\n");
        sqlBuffer.append(" OR (ENTRIES.FValiDebit <> 0) OR (ENTRIES.FValiCredit <> 0))  \r\n");
        sp.addInt(year).addInt(period).addInt(periodType);
        if (fromCurrency != null && !fromCurrency.trim().equals("")) {
            sqlBuffer.append("    and INTERDATACHECKAGE.FCurrencyID = ?   \r\n");
            sp.addString(fromCurrency);
        }
        if (c1 != null) {
            sqlBuffer.append(" and COMPANY1.FID = ? ");
            sp.addString(c1);
        }
        if (c2 != null) {
            sqlBuffer.append(" and TARGETCOMPANY.FID = ? ");
            sp.addString(c2);
        }
        if ((dataElement = params.getInt("dataElement")) > 0) {
            sqlBuffer.append(" and ENTRIES.FDataElement = ? \r\n");
            sp.addInt(dataElement);
        }
        if (dataCollectNumber != null && dataCollectNumber.length() != 0) {
            sqlBuffer.append(" and INTERDATACHECKAGE.FdataCollectNumber = ? \r\n");
            sp.addString(dataCollectNumber);
        }
        sqlBuffer.append(" UNION \r\n");
        sqlBuffer.append(" select   \r\n");
        sqlBuffer.append(" Interitemdata.FID as Fid,  \r\n");
        sqlBuffer.append(" '' as FCheckUnit,  \r\n");
        sqlBuffer.append(" N'' as FNumber,  \r\n");
        sqlBuffer.append(" N'' as fElimTemplet,  \r\n");
        sqlBuffer.append(" CURRENCY.FName_" + lang + " as fCurrency,  \r\n");
        sqlBuffer.append(" MergeUnit.FName_" + lang + " as FMergeUnitName,  \r\n");
        sqlBuffer.append(" COMPANY1.FID as  fCompanyID, \t\t\t\t\t\t\t  \r\n");
        sqlBuffer.append(" COMPANY1.FName_" + lang + " as fCompany,  \r\n");
        sqlBuffer.append(" TARGETCOMPANY.FID as fTargetCompanyID,  \t\t\t\t  \r\n");
        sqlBuffer.append(" TARGETCOMPANY.FName_" + lang + " as fTargetCompany,  \r\n");
        sqlBuffer.append(" ITEM.FNumber as fItemNumber,  \r\n");
        sqlBuffer.append(" ITEM.FName_" + lang + " as fItemName,  \r\n");
        sqlBuffer.append(" Interitemdata.FDataElement as fDataElement,  \r\n");
        sqlBuffer.append(" case when ITEM.Fdc=0 then Interitemdata.Fmoney else 0 end as FDebit,  \r\n");
        sqlBuffer.append(" case when ITEM.Fdc=1 then Interitemdata.Fmoney else 0 end as fCredit,  \r\n");
        sqlBuffer.append(" 0 as fValiDebit,  \r\n");
        sqlBuffer.append(" 0 as fValiCredit,  \r\n");
        sqlBuffer.append(" 0 as fDiff,  \r\n");
        sqlBuffer.append(" CURRENCY.FPrecision as fCurrencyPrecision  \r\n");
        sqlBuffer.append(" FROM t_Csl_Interitemdata Interitemdata  \r\n");
        sqlBuffer.append(" INNER JOIN T_BD_Currency CURRENCY ON Interitemdata.FCurrencyID = CURRENCY.FID  \r\n");
        sqlBuffer.append(" INNER JOIN T_ORG_BaseUnit COMPANY1 ON Interitemdata.FCompanyID = COMPANY1.FID  \r\n");
        sqlBuffer.append(" INNER JOIN t_org_structure t1 ON t1.funitid = COMPANY1.fid AND t1.fisleaf = 1  \r\n");
        sqlBuffer.append(" AND t1.ftreeid = '").append(treeId).append("'        \r\n");
        sqlBuffer.append(" AND t1.flongnumber LIKE '").append(longNumber).append("%'\r\n");
        sqlBuffer.append(" INNER JOIN T_ORG_Structure pStructure ON pStructure.FID = t1.Fparentid   \r\n");
        sqlBuffer.append(" INNER JOIN T_ORG_BaseUnit MergeUnit ON MergeUnit.FID = pStructure.FUnitID  \r\n");
        sqlBuffer.append(" INNER JOIN T_ORG_BaseUnit TARGETCOMPANY ON Interitemdata.FTargetCompanyID = TARGETCOMPANY.FID  \r\n");
        sqlBuffer.append(" INNER JOIN t_org_structure t2 ON t2.funitid = TARGETCOMPANY.fid AND t2.fisleaf = 1  AND t2.ftreeid = '").append(treeId).append("'        \r\n");
        sqlBuffer.append(" INNER JOIN T_CSL_RptItem ITEM ON Interitemdata.Fitemnumber = ITEM.Fnumber  \r\n");
        sqlBuffer.append(" WHERE Interitemdata.FYear = ?  \r\n");
        sqlBuffer.append(" and Interitemdata.FPeriod = ?    \r\n");
        sqlBuffer.append(" and Interitemdata.FPeriodType = ?  \r\n");
        sqlBuffer.append(" and Interitemdata.Fmoney <> 0  \r\n");
        sqlBuffer.append(" and Interitemdata.FdataCollectNumber = ?  \r\n");
        sqlBuffer.append(" and Interitemdata.Fcommitstatus =3  \r\n");
        sp.addInt(year).addInt(period).addInt(periodType);
        sp.addString(dataCollectNumber);
        sqlBuffer.append(" AND Interitemdata.FTargetCompanyID not in ( \r\n");
        sqlBuffer.append("  select distinct t3.funitid from t_org_structure t3  where t3.fisleaf = 1 \r\n");
        sqlBuffer.append("  AND t3.ftreeid = ? AND t3.flongnumber LIKE ? )  \r\n");
        sp.addString(treeId).addString(longNumber + "%");
        if (fromCurrency != null && !fromCurrency.trim().equals("")) {
            sqlBuffer.append(" and Interitemdata.FCurrencyID = ?   \r\n");
            sp.addString(fromCurrency);
        }
        if (c1 != null) {
            sqlBuffer.append(" and Interitemdata.FCompanyID = ? ");
            sp.addString(c1);
        }
        if (c2 != null) {
            sqlBuffer.append(" and Interitemdata.FTargetCompanyID = ? ");
            sp.addString(c2);
        }
        if (dataElement > 0) {
            sqlBuffer.append(" and Interitemdata.FDataElement = ? \r\n");
            sp.addInt(dataElement);
        }
        sqlBuffer.append(" ) tt \n");
        sqlBuffer.append(" ORDER BY FCheckUnit ASC, FNumber ASC,  FCurrency ASC, fElimTemplet ASC, fCompany Asc, fTargetCompany ASC, fItemNumber, fDataElement  \r\n");
        RptRowSet rst = null;
        Connection con = null;
        try {
            con = this.getConnection(ctx);
            rst = DBUtil.executeQuery((String)sqlBuffer.toString(), (SqlParams)sp, (int)from, (int)length, (Connection)con);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
        return rst;
    }

    @Override
    protected List _getAfterElimRptItems(Context ctx, RptProperties params, int elimType) throws BOSException, EASBizException {
        String year = params.getObject("year") instanceof String ? params.getString("year") : String.valueOf(params.getInt("year"));
        String period = params.getObject("period") instanceof String ? params.getString("period") : String.valueOf(params.getInt("period"));
        String periodType = params.getObject("periodType") instanceof String ? params.getString("periodType") : String.valueOf(params.getInt("periodType"));
        String dataElement = params.getObject("dataElement") instanceof String ? params.getString("dataElement") : String.valueOf(params.getInt("dataElement"));
        String treeId = params.getString("treeId");
        String orgUnitLongNumber = params.getString("orgUnitLongNumber");
        String currencyId = params.getString("currencyId");
        String dataCollect = params.getString("dataCollection");
        boolean isQueryHisBudget = params.getBoolean("isQueryHisBudget");
        String rptReceiveTabName = QueryHisBudgetUtils.getRptReceiveTabName(isQueryHisBudget);
        String itemDataTableName = null;
        itemDataTableName = isQueryHisBudget ? (elimType == 3 ? "T_CSL_HisExchItemData" : "T_CSL_HisInterItemData") : (elimType == 3 ? "T_CSL_ExchItemData" : "T_CSL_InterItemData");
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT distinct ");
        sql.append(" rptitem.Fid as ItemId, ");
        sql.append(" rptitem.FName_" + ctx.getLocale() + " as ItemName,rptitem.FNumber ");
        sql.append(" FROM " + itemDataTableName + " itemdata ");
        sql.append(" INNER JOIN T_BD_Currency  fromcurrency  ON itemdata.FCurrencyID = fromcurrency.FID ");
        sql.append(" INNER JOIN T_BD_Currency  targetcurrency  ON itemdata.FTargetCurrencyID = targetcurrency.FID ");
        sql.append(" INNER JOIN T_CSL_DATACOLLECT  datacollect ON itemdata.FDataCollectNumber = datacollect.FNumber ");
        sql.append(" INNER JOIN ").append(rptReceiveTabName).append("  rptreceived ON itemdata.FReport = rptreceived.FReportID ");
        sql.append(" INNER JOIN T_CSL_RptItem  rptitem ON itemdata.FItemNumber = rptitem.FNumber ");
        sql.append(" INNER JOIN T_ORG_BaseUnit  fromcompany ON itemdata.FCompanyID = fromcompany.FID ");
        sql.append(" INNER JOIN T_ORG_BaseUnit  targetcompany ON itemdata.FTargetCompanyID = targetcompany.FID ");
        sql.append(" INNER Join ( ");
        sql.append(" \tSelect f1.FCompanyId,f1.FLongNumber as FLongNumber From ");
        sql.append(" \t(Select t1.FUnitId As FCompanyId,t1.FLongNumber ");
        sql.append(" \tFrom t_org_structure t1  ");
        sql.append(" \tjoin t_org_baseunit t2 on t1.funitid=t2.fid ");
        sql.append(" \twhere (t1.flongnumber = '" + orgUnitLongNumber + "' or t1.flongnumber like '" + orgUnitLongNumber + "!%') and t1.ftreeid='" + treeId + "') f1 ");
        sql.append(" ) fromRange on itemdata.fcompanyid = fromRange.fcompanyid ");
        sql.append(" WHERE fromcompany.FID!=targetcompany.FID and (itemdata.FMoney <> 0) ");
        sql.append(" and itemdata.FCommitStatus = 3");
        sql.append(" and rptreceived.FOrgTreeID = '" + treeId + "' ");
        sql.append(" and itemdata.FYear = " + year);
        sql.append(" and itemdata.FPeriod = " + period);
        sql.append(" and itemdata.FPeriodType = " + periodType);
        sql.append(" and itemdata.fdataelement = " + dataElement);
        sql.append(" and itemdata.fdatacollectnumber = '" + dataCollect + "' ");
        sql.append(" and itemdata.FCurrencyID = '" + currencyId + "' ");
        sql.append(" and not exists (");
        sql.append(" \tSelect t1.FUnitId ");
        sql.append(" \tFrom t_org_structure t1  ");
        sql.append(" \tjoin t_org_baseunit t2 on t1.funitid=t2.fid ");
        sql.append(" \twhere (t1.flongnumber = '" + orgUnitLongNumber + "' or t1.flongnumber like '" + orgUnitLongNumber + "!%') and t1.ftreeid='" + treeId + "' ");
        sql.append(" \tand itemdata.ftargetcompanyid = t1.FUnitId ");
        sql.append(" ) ");
        sql.append(" order by rptitem.FNumber ");
        IRowSet rst = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ArrayList<String[]> lstRtn = new ArrayList<String[]>();
        String[] strTemp = null;
        try {
            while (rst.next()) {
                strTemp = new String[]{rst.getString("ItemId"), rst.getString("ItemName")};
                lstRtn.add(strTemp);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rst);
        }
        return lstRtn;
    }

    @Override
    protected Map _getItemDataFilterInfo(Context ctx, Map paramMap) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        CurrencyCollection currencyCollection = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection(viewInfo, true);
        Date rptDate = (Date)paramMap.get("rptDate");
        String userId = (String)paramMap.get("userId");
        OrgTreeCollection collection = CslRptUtil.getAllUnionTreesOrderByNumber(ctx, userId, rptDate);
        OrgTreeInfo info = null;
        for (int i = collection.size() - 1; i >= 0; --i) {
            info = collection.get(i);
            if (!info.isIsHide()) continue;
            collection.remove(info);
        }
        if (paramMap.containsKey("orgViewType") && paramMap.get("orgViewType") != null) {
            OrgViewType viewType = (OrgViewType)paramMap.get("orgViewType");
            for (int i = collection.size() - 1; i >= 0; --i) {
                info = collection.get(i);
                if (viewType == null || viewType.equals((Object)info.getLayerType())) continue;
                collection.remove(info);
            }
        }
        HashMap<String, Object> returnMap = new HashMap<String, Object>(4);
        returnMap.put("currencyCollection", currencyCollection);
        returnMap.put("orgTreeCollection", collection);
        return returnMap;
    }

    @Override
    protected Map _getRPTInterItemDataListInfo(Context ctx, Map paramMap) throws BOSException, EASBizException {
        FullOrgUnitInfo companyInfo = null;
        FullOrgUnitInfo targetCompanyInfo = null;
        ArrayList<String> companyList = new ArrayList<String>();
        if (paramMap.containsKey("company") && paramMap.get("company") != null) {
            String companyId = (String)paramMap.get("company");
            companyInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        }
        boolean isByCompany = false;
        if (paramMap.containsKey("isByCompany") && paramMap.get("isByCompany") != null) {
            isByCompany = Boolean.valueOf(paramMap.get("isByCompany").toString());
        }
        if (isByCompany && paramMap.containsKey("targetCompany") && paramMap.get("targetCompany") != null) {
            String targetCompanyId = (String)paramMap.get("targetCompany");
            targetCompanyInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(targetCompanyId));
        } else if (isByCompany && paramMap.containsKey("targetCompany") && paramMap.get("targetCompany") == null) {
            String treeId = (String)paramMap.get("treeId");
            String sql = " select FUnitId from t_org_Structure s inner join  t_org_tree t  on  s.ftreeid=t.fid where t.fid= ? ";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{treeId});
            try {
                while (rs.next()) {
                    companyList.add(rs.getString("FUnitId"));
                }
            }
            catch (SQLException ex) {
                throw new SQLDataException(ex);
            }
        }
        HashMap<String, Object> returnMap = new HashMap<String, Object>(4);
        returnMap.put("companyInfo", companyInfo);
        returnMap.put("targetCompanyInfo", targetCompanyInfo);
        returnMap.put("companyList", companyList);
        return returnMap;
    }

    @Override
    protected Map _getCheckProfileData(Context ctx, Map param) throws BOSException, EASBizException {
        if (param == null) {
            return null;
        }
        List idList = (List)param.get("idList");
        if (idList == null || idList.size() == 0) {
            return null;
        }
        int size = idList.size();
        StringBuffer idListStr = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            idListStr.append("'" + idList.get(i) + "'");
            if (i == size - 1) continue;
            idListStr.append(", ");
        }
        String inSql = idListStr.toString();
        String tempTable = null;
        if (size >= 1000) {
            tempTable = this.loadIds2TempTable(ctx, idList);
            inSql = "SELECT FID FROM " + tempTable;
        }
        boolean isQueryHisBudget = (Boolean)param.get("isQueryHisBudget");
        String interCheckage = QueryHisBudgetUtils.getInterCheckageTabName(isQueryHisBudget);
        String dataCheckEntr = isQueryHisBudget ? "T_CSL_HisDataCheckageEntry" : "T_CSL_DataCheckageEntry";
        String lang = ctx.getLocale().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT DISTINCT * FROM (( \n");
        sql.append("SELECT INTERDATACHECKAGE.fid as fid, \n").append(" 'WL-'||INTERDATACHECKAGE.FNumber as number, \n").append(" TEMPLET.FName as elimTemplet, \n").append(" COMPANY1.FName_").append(lang).append(" as company, \n").append(" TARGETCOMPANY.FName_").append(lang).append(" as targetCompany, \n").append(" COMPANY1.Fid as companyId, \n").append(" TARGETCOMPANY.FId as targetCompanyId, TEMPLET.FElimType as elimType, TEMPLET.FId as elimTempletId, \n").append(" INTERDATACHECKAGE.FDiffMode as diffMode \n").append("FROM ").append(interCheckage).append(" INTERDATACHECKAGE \n").append(" LEFT OUTER JOIN T_CSL_ElimTemplet TEMPLET \n").append(" ON INTERDATACHECKAGE.FTempletID = TEMPLET.FID \n").append(" INNER JOIN ").append(dataCheckEntr).append(" AS ENTRIES \n").append(" ON INTERDATACHECKAGE.FID = ENTRIES.FCheckageID \n").append(" INNER JOIN T_ORG_BaseUnit AS COMPANY1 \n").append(" ON ENTRIES.FCompanyID = COMPANY1.FID \n").append(" INNER JOIN T_ORG_BaseUnit AS TARGETCOMPANY \n").append(" ON ENTRIES.FTargetCompanyID = TARGETCOMPANY.FID \n").append("WHERE INTERDATACHECKAGE.FId IN (").append(inSql).append(") \n");
        String exchcheckage = isQueryHisBudget ? "T_CSL_Hisexchcheckage" : "T_CSL_exchcheckage";
        String exchCheckageEntry = isQueryHisBudget ? "T_CSL_HisExchCheckageEntry" : "T_CSL_ExchCheckageEntry";
        sql.append(" ) UNION ALL ( \n");
        sql.append("SELECT exchcheckage.FID as fid,\n").append(" 'JY-'||exchcheckage.FNumber as number, \n").append(" TEMPLET.FName as elimTemplet, \n").append(" COMPANY1.FName_").append(lang).append(" AS company, \n").append(" TARGETCOMPANY.FName_").append(lang).append(" AS targetCompany, \n").append(" COMPANY1.Fid as companyId, \n").append(" TARGETCOMPANY.FId as targetCompanyId, TEMPLET.FElimType as elimType, TEMPLET.FId as elimTempletId, \n").append(" exchcheckage.FDiffMode as diffMode \n").append("FROM ").append(exchcheckage).append(" exchcheckage \n").append(" LEFT OUTER JOIN T_CSL_ElimTemplet TEMPLET \n").append(" ON exchcheckage.FTempletID = TEMPLET.FID \n").append(" INNER JOIN ").append(exchCheckageEntry).append(" AS ENTRIES \n").append(" ON exchcheckage.FID = ENTRIES.FCheckageID \n").append(" INNER JOIN T_ORG_BaseUnit AS COMPANY1 \n").append(" ON ENTRIES.FCompanyID = COMPANY1.FID \n").append(" INNER JOIN T_ORG_BaseUnit AS TARGETCOMPANY \n").append(" ON ENTRIES.FTargetCompanyID = TARGETCOMPANY.FID \n").append("WHERE exchcheckage.FId IN (").append(inSql).append(") \n");
        sql.append(" )) t1 ORDER BY number, FId \n");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        param.put("result", rowSet);
        if (tempTable != null) {
            TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
        }
        return param;
    }

    private String loadIds2TempTable(Context ctx, List idList) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE T_CSL_IDS (FID VARCHAR(40))");
        String tempTable = this.getTemplateTable(ctx, sql.toString());
        sql = new StringBuffer();
        sql.append(" INSERT INTO ").append(tempTable);
        sql.append(" (FID) VALUES (?);\n");
        Connection cn = null;
        PreparedStatement ps = null;
        try {
            cn = super.getConnection(ctx);
            ps = cn.prepareStatement(sql.toString());
            for (int i = 0; i < idList.size(); ++i) {
                ps.setObject(1, idList.get(i));
                ps.addBatch();
            }
            if (idList != null && idList.size() > 0) {
                ps.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)cn);
        return tempTable;
    }

    private void addAdjustNoReportDataSql(StringBuffer buffer, SqlParams sp, RptProperties rptProp, String longNumber, int level, int type) {
        boolean isByCompany = rptProp.getBoolean("isByCompany");
        String itemDataTN = "";
        int itemGroup = 0;
        if (type == 3) {
            itemDataTN = "T_CSL_ExchItemData";
            itemGroup = 3;
        } else if (type == 1) {
            itemDataTN = "T_CSL_InterItemData";
            itemGroup = 1;
        }
        int mergeType = rptProp.getInt("MERGETYPE");
        int year = rptProp.getInt("year");
        int period = rptProp.getInt("period");
        int periodType = rptProp.getInt("periodType");
        String dataCollectNumber = rptProp.getString("dataCollectNumber");
        String treeId = rptProp.getString("treeId");
        String company = (String)rptProp.getObject("company");
        String targetCompany = (String)rptProp.getObject("targetCompany");
        String fromCurrency = rptProp.getString("fromCurrency");
        String toCurrency = rptProp.getString("toCurrency");
        buffer.append(" ) \r\n UNION ALL  \r\n");
        buffer.append("(SELECT fromcompany.FName_l2 COMPANY, \r\n");
        buffer.append("       targetcompany.FName_l2 TARGETCOMPANY, \r\n");
        buffer.append("       ITEM.FNumber ITEMNUMBER, \r\n");
        buffer.append("       ITEM.FName_l2 ITEMNAME, \r\n");
        buffer.append("       adjustDetails.Fdataelement DATAELEMENT, \r\n");
        buffer.append("       fromcurrency.FName_l2 FROMCURRENCY, \r\n");
        buffer.append("       targetcurrency.FName_l2 TARGETCURRENCY, \r\n");
        buffer.append("       0 BEFOREADJUSTDATA, \r\n");
        buffer.append("       ISNULL(ADJUSTDETAILS.FITEMDCVALUE, 0) ADJUSTDATA, \r\n");
        buffer.append("       ISNULL(ADJUSTDETAILS.FITEMDCVALUE, 0) AFTERADJUSTDATA, \r\n");
        buffer.append("       null fid, \r\n");
        buffer.append("       targetcurrency.FPrecision, \r\n");
        buffer.append("       datacollect.FName_l2 DATACOLLECTNAME, \r\n");
        buffer.append("       null fname_l2 \r\n");
        buffer.append("  from T_CSL_AdjustEntryDetails ADJUSTDETAILS \r\n");
        buffer.append(" INNER JOIN T_CSL_Adjustentry ADJUSTENTRY ON adjustDetails.FAdjustEntryID = \r\n");
        buffer.append("                                             adjustEntry.fid \r\n");
        buffer.append(" INNER JOIN T_CSL_Adjust ADJUST ON adjustentry.fadjustid = adjust.fid \r\n");
        buffer.append(" INNER JOIN T_CSL_RptItem ITEM ON item.fid = adjustentry.fitemid \r\n");
        buffer.append(" INNER JOIN T_ORG_BaseUnit fromcompany ON adjust.forgunit = fromcompany.fid \r\n");
        buffer.append(" INNER JOIN T_ORG_BaseUnit targetcompany ON adjustdetails.fcompanyid = \r\n");
        buffer.append("                                            targetcompany.fid \r\n");
        buffer.append(" INNER JOIN T_BD_Currency fromcurrency ON fromcurrency.fid = \r\n");
        buffer.append("                                          adjust.fsourcecurrencyid \r\n");
        buffer.append(" INNER JOIN T_BD_Currency targetcurrency ON targetcurrency.fid = \r\n");
        buffer.append("                                            adjust.fcurrencyid \r\n");
        buffer.append(" INNER JOIN T_CSL_DATACOLLECT DATACOLLECT ON adjust.FDataCollectNumber = \r\n");
        buffer.append("                                             datacollect.FNumber \r\n");
        if (!isByCompany && mergeType == 1) {
            buffer.append(" INNER JOIN (SELECT x1.FCompanyId, \r\n");
            buffer.append("                    x1.FLevel, \r\n");
            buffer.append("                    x2.FTargetCompanyId, \r\n");
            buffer.append("                    x2.FLevel FTARGETLEVEL \r\n");
            buffer.append("               FROM (SELECT t1.FUnitId FCOMPANYID, t1.FLevel \r\n");
            buffer.append("                       FROM T_ORG_Structure T1 \r\n");
            buffer.append("                      INNER JOIN T_ORG_BaseUnit T2 ON t1.funitid = t2.fid \r\n");
            buffer.append("                      WHERE (((t2.fisgrouping = 0 AND t1.fisleaf = 1) AND \r\n");
            buffer.append("                            (t1.flongnumber LIKE ?)) AND \r\n");
            sp.addString(longNumber + "!%");
            buffer.append("                            t1.ftreeid = ?)) X1, \r\n");
            sp.addString(treeId);
            buffer.append("                    (SELECT t1.FUnitId FTARGETCOMPANYID, t1.FLevel \r\n");
            buffer.append("                       FROM t_org_structure T1 \r\n");
            buffer.append("                      INNER JOIN t_org_baseunit T2 ON t1.funitid = t2.fid \r\n");
            buffer.append("                      WHERE (((t2.fisgrouping = 0 AND t1.fisleaf = 1) AND \r\n");
            buffer.append("                            (t1.flongnumber LIKE ?)) AND \r\n");
            sp.addString(longNumber + "!%");
            buffer.append("                            t1.ftreeid = ?)) X2) X ON (adjust.forgunit = \r\n");
            sp.addString(treeId);
            buffer.append("                                                                                   x.fcompanyid AND \r\n");
            buffer.append("                                                                                   adjustDetails.Fcompanyid = \r\n");
            buffer.append("                                                                                   x.ftargetcompanyid) \r\n");
        }
        buffer.append(" WHERE adjust.FCheckedStatus = 2 \r\n");
        buffer.append("   AND item.fitemgroup = ? \r\n");
        sp.addInt(itemGroup);
        buffer.append("   AND adjust.FOrgBoundId = ? \r\n");
        sp.addString(treeId);
        buffer.append("   AND adjust.FYear = ? \r\n");
        sp.addInt(year);
        buffer.append("   AND adjust.FPeriod = ? \r\n");
        sp.addInt(period);
        buffer.append("   AND adjust.FPeriodType = ? \r\n");
        sp.addInt(periodType);
        buffer.append("   AND adjust.FOrgUnit IN (SELECT FUnitId FROM T_ORG_Structure WHERE FTreeId = ?) \r\n");
        sp.addString(treeId);
        buffer.append("   AND adjustDetails.FCompanyID IN (SELECT FUnitId FROM T_ORG_Structure WHERE FTreeId = ?) \r\n");
        sp.addString(treeId);
        if (!StringUtils.isEmpty((String)dataCollectNumber)) {
            buffer.append(" AND adjust.FDataCollectNumber = ? ");
            sp.addString(dataCollectNumber);
        }
        if (!isByCompany && mergeType == 1) {
            buffer.append("   AND (x.FLevel = ? OR x.FTargetLevel = ?) \r\n");
            sp.addInt(level + 1).addInt(level + 1);
        }
        if (!StringUtils.isEmpty((String)fromCurrency)) {
            buffer.append("    AND adjust.FSourceCurrencyId = ?   \r\n");
            sp.addString(fromCurrency);
        }
        if (!StringUtils.isEmpty((String)toCurrency)) {
            buffer.append("    AND adjust.FCurrencyId = ?   \r\n");
            sp.addString(toCurrency);
        }
        if (isByCompany) {
            if (targetCompany == null) {
                buffer.append(" AND (adjust.FOrgUnit = ? OR adjustDetails.FCompanyID = ?) \r\n");
                sp.addString(company).addString(company);
            } else {
                buffer.append(" AND ((adjust.FOrgUnit = ? AND adjustDetails.FCompanyID = ?)");
                buffer.append(" OR (adjust.FOrgUnit = ? AND adjustDetails.FCompanyID = ? )) \r\n");
                sp.addString(company).addString(targetCompany).addString(targetCompany).addString(company);
            }
        } else if (!StringUtils.isEmpty((String)company)) {
            buffer.append(" AND (adjust.FOrgUnit = ? OR adjustDetails.FCompanyID = ?) \r\n");
            sp.addString(company).addString(company);
        }
        buffer.append("   AND NOT EXISTS \r\n");
        buffer.append(" (SELECT 1 \r\n");
        buffer.append("          FROM T_CSL_CslReport rpt \r\n");
        buffer.append("          join T_CSL_RptReceived rec ON rpt.FId = rec.FReportId \r\n");
        buffer.append("                                    AND rec.FOrgTreeid = ?\r\n");
        sp.addString(treeId);
        buffer.append("         WHERE 1=1 \r\n");
        if (isByCompany) {
            buffer.append(" AND (rpt.FAuditedStatus = 2 OR rpt.fAdjustStatus = 1)  \r\n");
        } else {
            buffer.append(" AND (rpt.FCommittedStatus=3 OR EXISTS (SELECT 1 FROM T_CSL_CslReport AS CslReport1 WHERE rpt.FSourceRptId=CslReport1.FId AND CslReport1.FCommittedStatus = 3))  \r\n");
        }
        buffer.append("           AND rpt.FId IN \r\n");
        buffer.append("               (SELECT itemdata.FReport \r\n");
        buffer.append("                  FROM " + itemDataTN + " ITEMDATA \r\n");
        buffer.append("                 WHERE itemData.FCompanyID = adjust.FOrgUnit  \r\n");
        buffer.append("                       AND itemData.FYear = adjust.FYear  \r\n");
        buffer.append("                       AND itemData.FPeriod = adjust.FPeriod  \r\n");
        buffer.append("                       AND itemData.FPeriodType = adjust.FPeriodType  \r\n");
        buffer.append("                       AND itemData.FDataCollectNumber = adjust.FDataCollectNumber  \r\n");
        buffer.append("                       AND itemData.FTargetCompanyID = adjustDetails.FCompanyID  \r\n");
        buffer.append("                       AND itemData.FDataElement = adjustDetails.FDataElement  \r\n");
        buffer.append("                       AND ITEMDATA.fcurrencyid=adjust.fcurrencyid  \r\n");
        buffer.append("                       AND itemData.FItemnumber = item.FNumber))  \r\n");
        buffer.append(")");
    }

    private void filterCompany(StringBuffer sqlBuffer, String companyTable, String orgTreeId, String longNumber, List[] disposeCompanys, boolean isByCompany, String structTable) {
        sqlBuffer.append(" INNER JOIN t_org_structure ").append(structTable).append("\t\t   \t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sqlBuffer.append(" ON ").append(structTable).append(".funitid = ").append(companyTable).append(".fid AND ").append(structTable).append(".fisleaf = 1\t\t\r\n");
        sqlBuffer.append(" AND ").append(structTable).append(".ftreeid = '").append(orgTreeId).append("'\t\t\t\t\r\n");
        if (!isByCompany) {
            boolean isHaveDisposeCompany = !disposeCompanys[0].isEmpty();
            sqlBuffer.append(" and ");
            if (isHaveDisposeCompany) {
                sqlBuffer.append("( ");
            }
            sqlBuffer.append(structTable).append(".flongnumber LIKE '").append(longNumber).append("!%' ");
            if (isHaveDisposeCompany) {
                sqlBuffer.append("  or ").append(structTable).append(".funitid in(").append(CslRptUtil.list2String(disposeCompanys[0], ",", true)).append(")) ");
            }
        }
    }
}

