/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.IInvestDayInvestOwnerEntry;
import com.kingdee.eas.fi.gr.cslrpt.IRPTItem;
import com.kingdee.eas.fi.gr.cslrpt.InvestDayCollection;
import com.kingdee.eas.fi.gr.cslrpt.InvestDayEntryCollection;
import com.kingdee.eas.fi.gr.cslrpt.InvestDayEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.InvestDayFactory;
import com.kingdee.eas.fi.gr.cslrpt.InvestDayInfo;
import com.kingdee.eas.fi.gr.cslrpt.InvestDayInvestOwnerEntryCollection;
import com.kingdee.eas.fi.gr.cslrpt.InvestDayInvestOwnerEntryFactory;
import com.kingdee.eas.fi.gr.cslrpt.InvestDayInvestOwnerEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.AbstractInvestDayInvestOwnerEntryControllerBean;
import com.kingdee.eas.fi.gr.cslrpt.util.SaveTableColumn;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class InvestDayInvestOwnerEntryControllerBean
extends AbstractInvestDayInvestOwnerEntryControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.cslrpt.app.InvestDayInvestOwnerEntryControllerBean");

    @Override
    protected Map _initData(Context ctx, Map map) throws BOSException, EASBizException {
        Object investDayId = map.get("investDayId");
        Boolean isChangeBefore = (Boolean)map.get("isChangeBefore");
        String currencyId = (String)map.get("currencyId");
        HashMap<String, Serializable> resultMap = new HashMap<String, Serializable>();
        if (investDayId != null) {
            this.getSumItems(ctx, resultMap, investDayId.toString(), isChangeBefore);
        }
        InvestDayInfo investDayBefore = this.getLastInvestDayInfo(ctx, map);
        resultMap.put("investDayBefore", investDayBefore);
        if (currencyId != null) {
            CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
            int precision = currency.getPrecision();
            resultMap.put("precision", new Integer(precision));
        }
        return resultMap;
    }

    private void getSumItems(Context ctx, HashMap resultMap, String investDayId, Boolean isChangeBefore) throws BOSException, EASBizException {
        IInvestDayInvestOwnerEntry iInvestOwner = InvestDayInvestOwnerEntryFactory.getLocalInstance(ctx);
        InvestDayInvestOwnerEntryCollection subItems = null;
        String oql = "select * where investDay.id = '" + investDayId;
        if (isChangeBefore != null) {
            oql = oql + "' and isBeforeInvest = ";
            oql = oql + (isChangeBefore != false ? "1" : "0");
        }
        if (iInvestOwner.exists(oql)) {
            subItems = iInvestOwner.getInvestDayInvestOwnerEntryCollection(oql);
        }
        resultMap.put("subItems", subItems);
    }

    private InvestDayInfo getLastInvestDayInfo(Context ctx, Map map) throws EASBizException, BOSException {
        String targetCompanyId = (String)map.get("targetCompanyId");
        String companyId = (String)map.get("companyId");
        Date date = (Date)map.get("date");
        String currencyId = (String)map.get("currencyId");
        if (targetCompanyId == null) {
            return null;
        }
        if (companyId == null) {
            return null;
        }
        if (date == null) {
            return null;
        }
        if (currencyId == null) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select ").append("sumInvestRate,ownerSumOld");
        sql.append(" where company.id = ").append("'").append(companyId).append("'");
        sql.append(" and targetCompany.id = '").append(targetCompanyId).append("'");
        sql.append(" and changeDate < ").append("'").append(date).append("'");
        sql.append(" and currency.id ='").append(currencyId).append("'");
        sql.append(" order by changeDate desc");
        InvestDayCollection col = InvestDayFactory.getLocalInstance(ctx).getInvestDayCollection(sql.toString());
        InvestDayInfo investDayBefore = null;
        if (col != null && col.size() > 0) {
            investDayBefore = col.get(0);
        }
        return investDayBefore;
    }

    @Override
    protected List _initFormulaData(Context ctx, Map uiCtx) throws EASBizException, BOSException {
        Pattern pt = (Pattern)uiCtx.get("pt");
        RPTItemInfo sumitem = (RPTItemInfo)uiCtx.get("sumitem");
        BigDecimal sumValue = (BigDecimal)uiCtx.get("sumValue");
        InvestDayInvestOwnerEntryCollection subItems = (InvestDayInvestOwnerEntryCollection)((Object)uiCtx.get("subItems"));
        Boolean isChangeBefore = (Boolean)uiCtx.get("isChangeBefore");
        BigDecimal sumInvestRateBefore = (BigDecimal)uiCtx.get("sumInvestRateBefore");
        BigDecimal sumInvestRate = (BigDecimal)uiCtx.get("sumInvestRate");
        InvestDayEntryCollection changeMoneyCollection = (InvestDayEntryCollection)((Object)uiCtx.get("changeMoneyCollection"));
        Boolean isRateOrOwnerSumNewChange = (Boolean)uiCtx.get("isRateOrOwnerSumNewChange");
        HashMap allItemList = (HashMap)uiCtx.get("allItemList");
        if (!allItemList.containsKey(sumitem.getNumber())) {
            allItemList.put(sumitem.getNumber(), sumitem);
        }
        ArrayList<HashMap> list = new ArrayList<HashMap>();
        this.displayFormula(ctx, list, sumValue, subItems, sumitem, 0, pt, "=", isChangeBefore, sumInvestRateBefore, sumInvestRate, changeMoneyCollection, isRateOrOwnerSumNewChange, allItemList);
        list.add(allItemList);
        return list;
    }

    private void displayFormula(Context ctx, ArrayList list, BigDecimal sumValue, InvestDayInvestOwnerEntryCollection subItems, RPTItemInfo item, int level, Pattern pt, String op, boolean isChangeBefore, BigDecimal sumInvestRateBefore, BigDecimal sumInvestRate, InvestDayEntryCollection changeMoneyCollection, boolean isRateOrOwnerSumNewChange, HashMap allItemList) throws BOSException, EASBizException {
        InvestDayEntryInfo info;
        int k;
        SaveTableColumn sv = new SaveTableColumn();
        StringBuffer space = new StringBuffer("");
        for (int i = 0; i < level; ++i) {
            space.append("  ");
        }
        if (level != 0) {
            sv.setItemId(item.getId().toString());
            sv.setItemNumber(item.getNumber());
        }
        sv.setItemName(space.toString() + item.getName());
        sv.setMoneyUIlevel(new Integer(level));
        sv.setOperation(op);
        if (isChangeBefore) {
            sv.setRate(sumInvestRateBefore);
        } else {
            sv.setRate(sumInvestRate);
        }
        if (isChangeBefore) {
            if (sumInvestRateBefore == null) {
                sv.setPlanMoney(null);
            } else {
                k = changeMoneyCollection != null && changeMoneyCollection.size() > 0 ? this.getEntryByItemNumber(changeMoneyCollection, item.getId().toString()) : -1;
                if (k == -1) {
                    if (item.isIsSumItem() || level == 0) {
                        sv.setPlanMoney(sumValue.multiply(sumInvestRateBefore));
                    } else {
                        sv.setPlanMoney(new BigDecimal(0.0));
                    }
                } else {
                    info = changeMoneyCollection.get(k);
                    if (info.getAmount() != null) {
                        sv.setPlanMoney(sumValue.multiply(sumInvestRateBefore));
                    }
                }
            }
        } else if (sumInvestRate == null) {
            sv.setPlanMoney(null);
        } else {
            k = changeMoneyCollection != null && changeMoneyCollection.size() > 0 ? this.getEntryByItemNumber(changeMoneyCollection, item.getId().toString()) : -1;
            if (k == -1) {
                if (item.isIsSumItem() || level == 0) {
                    sv.setPlanMoney(sumValue.multiply(sumInvestRate));
                } else {
                    sv.setPlanMoney(new BigDecimal(0.0));
                }
            } else {
                info = changeMoneyCollection.get(k);
                if (info.getAmount() != null) {
                    sv.setPlanMoney(info.getAmount().multiply(sumInvestRate));
                }
            }
        }
        InvestDayInvestOwnerEntryInfo entry = this.getEntry(subItems, item);
        if (entry != null && !isRateOrOwnerSumNewChange) {
            sv.setActualMoney(entry.getAmount());
        } else if (entry != null && isRateOrOwnerSumNewChange) {
            sv.setActualMoney(sv.getPlanMoney());
        } else if (item.isIsSumItem()) {
            sv.setActualMoney(null);
        } else {
            sv.setActualMoney(sv.getPlanMoney());
        }
        entry = this.getEntry(subItems, item);
        if (entry != null) {
            sv.setRemark(entry.getRemark());
        } else {
            sv.setRemark(null);
        }
        entry = this.getEntry(subItems, item);
        if (entry != null) {
            sv.setDiff(entry.getDiff());
        } else {
            sv.setDiff(null);
        }
        sv.setIsLock(new Integer(1));
        String formula = item.getSumItemFormula();
        if (StringUtils.isEmpty((String)formula)) {
            if (level == 0) {
                list.add(sv);
            }
            return;
        }
        list.add(sv);
        space.append("  ");
        Matcher matcher = pt.matcher(formula);
        matcher = pt.matcher(formula);
        while (matcher.find()) {
            String oql;
            IRPTItem irptItem = RPTItemFactory.getLocalInstance(ctx);
            item = irptItem.getRPTItemInfo(oql = " where number = '" + matcher.group(2) + "'");
            if (!allItemList.containsKey(item.getNumber())) {
                allItemList.put(item.getNumber(), item);
            }
            if (StringUtils.isEmpty((String)item.getSumItemFormula())) {
                InvestDayEntryInfo info2;
                int k2;
                sv = new SaveTableColumn();
                sv.setItemId(item.getId().toString());
                sv.setItemNumber(item.getNumber());
                sv.setItemName(space.toString() + item.getName());
                if (isChangeBefore) {
                    sv.setRate(sumInvestRateBefore);
                } else {
                    sv.setRate(sumInvestRate);
                }
                if (isChangeBefore) {
                    if (sumInvestRateBefore == null) {
                        sv.setPlanMoney(null);
                    } else {
                        k2 = changeMoneyCollection != null && changeMoneyCollection.size() > 0 ? this.getEntryByItemNumber(changeMoneyCollection, item.getId().toString()) : -1;
                        if (k2 == -1) {
                            if (item.isIsSumItem()) {
                                sv.setPlanMoney(sumValue.multiply(sumInvestRateBefore));
                            } else {
                                sv.setPlanMoney(new BigDecimal(0.0));
                            }
                        } else {
                            info2 = changeMoneyCollection.get(k2);
                            if (info2.getAmount() != null) {
                                sv.setPlanMoney(info2.getAmount().multiply(sumInvestRateBefore));
                            }
                        }
                    }
                } else if (sumInvestRate == null) {
                    sv.setPlanMoney(null);
                } else {
                    k2 = changeMoneyCollection != null && changeMoneyCollection.size() > 0 ? this.getEntryByItemNumber(changeMoneyCollection, item.getId().toString()) : -1;
                    if (k2 == -1) {
                        if (item.isIsSumItem()) {
                            sv.setPlanMoney(sumValue.multiply(sumInvestRate));
                        } else {
                            sv.setPlanMoney(new BigDecimal(0.0));
                        }
                    } else {
                        info2 = changeMoneyCollection.get(k2);
                        if (info2.getAmount() != null) {
                            sv.setPlanMoney(info2.getAmount().multiply(sumInvestRate));
                        }
                    }
                }
                entry = this.getEntry(subItems, item);
                if (entry != null && !isRateOrOwnerSumNewChange) {
                    sv.setActualMoney(entry.getAmount());
                } else if (entry != null && isRateOrOwnerSumNewChange) {
                    sv.setActualMoney(sv.getPlanMoney());
                } else if (item.isIsSumItem()) {
                    sv.setActualMoney(null);
                } else {
                    sv.setActualMoney(sv.getPlanMoney());
                }
                if (entry != null) {
                    sv.setRemark(entry.getRemark());
                }
                if ((entry = this.getEntry(subItems, item)) != null) {
                    sv.setDiff(entry.getDiff());
                } else {
                    sv.setDiff(null);
                }
                sv.setOperation(matcher.group(3));
                sv.setMoneyUIlevel(new Integer(level + 1));
                list.add(sv);
                continue;
            }
            this.displayFormula(ctx, list, sumValue, subItems, item, level + 1, pt, matcher.group(3), isChangeBefore, sumInvestRateBefore, sumInvestRate, changeMoneyCollection, isRateOrOwnerSumNewChange, allItemList);
        }
    }

    private int getEntryByItemNumber(InvestDayEntryCollection col, String id) {
        for (int i = 0; i < col.size(); ++i) {
            if (col.get(i).getItem().getId() == null || !col.get(i).getItem().getId().toString().equals(id)) continue;
            return i;
        }
        return -1;
    }

    private InvestDayInvestOwnerEntryInfo getEntry(InvestDayInvestOwnerEntryCollection subItems, RPTItemInfo info) {
        if (subItems == null) {
            return null;
        }
        Iterator iter = subItems.iterator();
        while (iter.hasNext()) {
            InvestDayInvestOwnerEntryInfo entry = (InvestDayInvestOwnerEntryInfo)iter.next();
            if (!entry.getItem().getId().equals((Object)info.getId())) continue;
            return entry;
        }
        return null;
    }
}

