/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.IInvestDay;
import com.kingdee.eas.fi.gr.cslrpt.IRPTItem;
import com.kingdee.eas.fi.gr.cslrpt.InvestDayFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.util.CslConstant;
import com.kingdee.eas.fi.gr.cslrpt.util.CslInvestUtil;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InvestDayUtilForMainCost {
    private static final BigDecimal ZERO = new BigDecimal("0");
    public static final String COMPANYID = "companyId";
    public static final String TARGET_COMPANYID = "targetCompanyId";
    public static final String COMPANY_NUMBER = "companyNumber";
    public static final String TARGET_COMPANY_NUMBER = "targetCompanyNumber";
    public static final String RATE = "rate";
    public static final String COMBINE_TYPE = "combineType";
    public static final String IDENTITY_DIRECT = "identityDirect";
    public static final String IDENTITY_UNDIRECT = "identityUnDirect";
    public static final String UNIDENTITY_DIRECT = "unidentityDirect";
    public static final String UNIDENTITY_UNDIRECT = "unidentityUnDirect";
    public static final String EQUIVALENT_RATE = "equivalentRate";

    private static IRowSet getEndOfYearInvest(Context ctx, String companyId, String targetCompanyId, String currencyId, java.util.Date elimDate) throws BOSException {
        String endOfYear = CslRptUtil.formatDateForSql(elimDate);
        StringBuffer sql = new StringBuffer();
        sql.append("select top 1 FID, FChangeDate, FInvestRate, FSumInvestRate, ");
        sql.append("FInvestAmount, FSumInvestAmout, FOwnerSumNew, FOwnerSumOld, FProfit, ");
        sql.append("FHonor, FHonorSum, FMinorityChange, FDiffValue from t_csl_investDay");
        sql.append(" where FCurrencyId = ?");
        sql.append(" and FCompanyId = ?");
        sql.append(" and FTargetCompanyId = ?");
        sql.append(" and FChangeDate <= ");
        sql.append(endOfYear);
        sql.append(" order by FChangeDate desc");
        Object[] param = new Object[]{currencyId, companyId, targetCompanyId};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
        return rowSet;
    }

    private static IRowSet getFirstInvest(Context ctx, String companyId, String targetCompanyId, String currencyId, int year) throws BOSException {
        Date date;
        IRowSet rowSet;
        Object[] param;
        StringBuffer sql;
        block7: {
            sql = new StringBuffer();
            sql.append("select top 1 FID, FCompanyId, FChangeDate from t_csl_investDay");
            sql.append(" where FCurrencyId = ?");
            sql.append(" and FTargetCompanyId = ?");
            sql.append(" order by FChangeDate asc");
            param = new Object[]{currencyId, targetCompanyId};
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
            try {
                if (rowSet.next()) {
                    date = rowSet.getDate("FChangeDate");
                    if (DateTimeUtils.getYear((java.util.Date)date) != year) {
                        return null;
                    }
                    break block7;
                }
                return null;
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        sql = new StringBuffer();
        sql.append("select FID, FCompanyId, FChangeDate, FInvestRate, FSumInvestRate, ");
        sql.append("FInvestAmount, FSumInvestAmout, FOwnerSumNew, FOwnerSumOld, FProfit, ");
        sql.append("FHonor, FHonorSum, FMinorityChange from t_csl_investDay");
        sql.append(" where FCurrencyId = ?");
        sql.append(" and FTargetCompanyId = ?");
        sql.append(" and FChangeDate = ").append(CslRptUtil.formatDateForSql(date));
        sql.append(" order by FChangeDate asc");
        param = new Object[]{currencyId, targetCompanyId};
        rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
        try {
            while (rowSet.next()) {
                String cid = rowSet.getString("FCompanyId");
                if (companyId != null && !StringUtils.equals((String)cid, (String)companyId)) continue;
                rowSet.beforeFirst();
                return rowSet;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return null;
    }

    private static IRowSet getThisYearInvests(Context ctx, String companyId, String targetCompanyId, String currencyId, int year, java.util.Date elimDate, boolean isIncludeFirst) throws BOSException {
        String beginOfYear = CslRptUtil.formatDateForSql(RPTDateUtil.getBeginOfYear(year));
        String endOfYear = CslRptUtil.formatDateForSql(elimDate);
        if (!isIncludeFirst) {
            IRowSet firstInvest = InvestDayUtilForMainCost.getFirstInvest(ctx, companyId, targetCompanyId, currencyId, year);
            try {
                if (firstInvest != null && firstInvest.next()) {
                    Date first = firstInvest.getDate("FChangeDate");
                    beginOfYear = CslRptUtil.formatDateForSql(RPTDateUtil.getEndOfDay(first));
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select FID, FChangeDate, FInvestRate, FSumInvestRate, ");
        sql.append("FInvestAmount, FSumInvestAmout, FOwnerSumNew, FOwnerSumOld, FProfit, ");
        sql.append("FHonor, FHonorSum, FMinorityChange from t_csl_investDay");
        sql.append(" where FCurrencyId = ?");
        if (!StringUtils.isEmpty((String)companyId)) {
            sql.append(" and FCompanyId = '").append(companyId).append("'");
        }
        sql.append(" and FTargetCompanyId = ?");
        if (isIncludeFirst) {
            sql.append(" and FChangeDate >= " + beginOfYear);
        } else {
            sql.append(" and FChangeDate > " + beginOfYear);
        }
        sql.append(" and FChangeDate <= " + endOfYear);
        sql.append(" order by FChangeDate asc");
        Object[] param = new Object[]{currencyId, targetCompanyId};
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
    }

    public static List getEndOfThisYearOwnerSum(Context ctx, String companyID, String targetCompanyID, String currencyId, boolean expanded, boolean isChanged, java.util.Date elimDate) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        IRowSet info = InvestDayUtilForMainCost.getEndOfYearInvest(ctx, companyID, targetCompanyID, currencyId, elimDate);
        if (expanded && !InvestDayUtilForMainCost.isSumItem(ctx, 20)) {
            expanded = false;
        }
        try {
            if (!info.next()) {
                return result;
            }
            if (expanded) {
                int flag = isChanged ? 1 : 0;
                StringBuffer sql = new StringBuffer();
                sql.append("select t1.fitemid, t1.famount");
                sql.append(" from t_csl_investDayEntry t1");
                sql.append(" join t_csl_rptItem t2 on t1.fitemId = t2.fid");
                sql.append(" where t1.finvestDayId = ?");
                sql.append(" and t1.fcontrolAttr = ");
                sql.append(20);
                sql.append(" and t1.famount <> 0 and t2.fisSumItem = 0");
                sql.append(" and FAssistantFlag = ?");
                Object[] param = new Object[]{info.getString("FID"), new Integer(flag)};
                IRowSet entry = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
                while (entry.next()) {
                    HashMap<String, Object> data = new HashMap<String, Object>(4);
                    data.put("RPTITEM_ID", entry.getString("fitemid"));
                    data.put("KEY_CURRENCY_ID", currencyId);
                    data.put("Value", entry.getBigDecimal("famount"));
                    result.add(data);
                }
            } else {
                HashMap<String, Object> data = new HashMap<String, Object>(4);
                data.put("KEY_CURRENCY_ID", currencyId);
                if (isChanged) {
                    data.put("Value", info.getBigDecimal("FOwnerSumNew"));
                } else {
                    data.put("Value", info.getBigDecimal("FOwnerSumOld"));
                }
                result.add(data);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return result;
    }

    public static List getEndOfLastYearHonorSum(Context ctx, String companyID, String targetCompanyID, String currencyId, int year) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        IRowSet info = InvestDayUtilForMainCost.getEndOfYearInvest(ctx, companyID, targetCompanyID, currencyId, RPTDateUtil.getEndOfYear(year - 1));
        try {
            if (info.next()) {
                HashMap<String, Object> data = new HashMap<String, Object>(4);
                data.put("KEY_CURRENCY_ID", currencyId);
                data.put("Value", info.getBigDecimal("FHonorSum"));
                result.add(data);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return result;
    }

    public static List getEndOfLastYearSumInvestAmount(Context ctx, String companyID, String targetCompanyID, String currencyId, int year) throws EASBizException, BOSException {
        ArrayList result = new ArrayList();
        IRowSet info = InvestDayUtilForMainCost.getEndOfYearInvest(ctx, companyID, targetCompanyID, currencyId, RPTDateUtil.getEndOfYear(year - 1));
        try {
            if (info.next()) {
                HashMap<String, Object> data = new HashMap<String, Object>(4);
                data.put("KEY_CURRENCY_ID", currencyId);
                data.put("Value", info.getBigDecimal("FSumInvestAmout"));
                result.add(data);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return result;
    }

    public static BigDecimal getEndOfThisYearDiffValue(Context ctx, String companyID, String targetCompanyID, String currencyId, java.util.Date elimDate) throws EASBizException, BOSException {
        IRowSet info = InvestDayUtilForMainCost.getEndOfYearInvest(ctx, companyID, targetCompanyID, currencyId, elimDate);
        BigDecimal result = ZERO;
        try {
            if (info.next() && (result = info.getBigDecimal("FDiffValue")) == null) {
                result = ZERO;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return result;
    }

    public static List getThisYearMinoritySum(Context ctx, String companyID, String targetCompanyID, String currencyId, java.util.Date elimDate) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        int year = DateTimeUtils.getYear((java.util.Date)elimDate);
        IRowSet invests = InvestDayUtilForMainCost.getThisYearInvests(ctx, companyID, targetCompanyID, currencyId, year, elimDate, true);
        BigDecimal sumMinority = ZERO;
        try {
            while (invests.next()) {
                BigDecimal minority = invests.getBigDecimal("FMinorityChange");
                if (minority == null) {
                    minority = ZERO;
                }
                sumMinority = sumMinority.add(minority);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (sumMinority.compareTo(ZERO) != 0) {
            HashMap<String, Object> data = new HashMap<String, Object>(4);
            data.put("KEY_CURRENCY_ID", currencyId);
            data.put("Value", sumMinority);
            result.add(data);
        }
        return result;
    }

    public static List getThisYearHonorSum(Context ctx, String companyID, String targetCompanyID, String currencyId, java.util.Date elimDate) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        int year = DateTimeUtils.getYear((java.util.Date)elimDate);
        IRowSet invests = InvestDayUtilForMainCost.getThisYearInvests(ctx, companyID, targetCompanyID, currencyId, year, elimDate, true);
        BigDecimal sumHonor = ZERO;
        try {
            while (invests.next()) {
                BigDecimal honor = invests.getBigDecimal("FHonor");
                if (honor == null) {
                    honor = ZERO;
                }
                sumHonor = sumHonor.add(honor);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (sumHonor.compareTo(ZERO) != 0) {
            HashMap<String, Object> data = new HashMap<String, Object>(4);
            data.put("KEY_CURRENCY_ID", currencyId);
            data.put("Value", sumHonor);
            result.add(data);
        }
        return result;
    }

    public static BigDecimal getBeforeInvestProfit(Context ctx, String targetCompanyId, String currencyId, int year) throws BOSException {
        IRowSet firstInvest = InvestDayUtilForMainCost.getFirstInvest(ctx, null, targetCompanyId, currencyId, year);
        try {
            if (firstInvest != null && firstInvest.next()) {
                return firstInvest.getBigDecimal("FProfit");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return ZERO;
    }

    private static boolean isSumItem(Context ctx, int control) throws BOSException, EASBizException {
        String strOql = "select id, isSumItem where isFreezed = 0 and control = " + control;
        IRPTItem iitem = RPTItemFactory.getLocalInstance(ctx);
        if (iitem.exists(strOql)) {
            try {
                RPTItemInfo item = iitem.getRPTItemInfo(strOql);
                if (item.isIsSumItem()) {
                    return true;
                }
            }
            catch (BOSException bOSException) {
                // empty catch block
            }
        }
        return false;
    }

    public static List getThisYearOwnerSum(Context ctx, String targetCompanyID, String currencyId, boolean expanded, java.util.Date elimDate) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        if (expanded && !InvestDayUtilForMainCost.isSumItem(ctx, 20)) {
            expanded = false;
        }
        int year = DateTimeUtils.getYear((java.util.Date)elimDate);
        java.util.Date date = RPTDateUtil.getBeginOfYear(year);
        IRowSet firstInvest = InvestDayUtilForMainCost.getFirstInvest(ctx, null, targetCompanyID, currencyId, year);
        boolean isFirst = firstInvest != null;
        IRowSet invests = InvestDayUtilForMainCost.getThisYearInvests(ctx, null, targetCompanyID, currencyId, year, elimDate, !isFirst);
        if (expanded) {
            HashMap<String, BigDecimal> sumItem = new HashMap<String, BigDecimal>();
            try {
                if (isFirst && firstInvest.next()) {
                    date = firstInvest.getDate("FChangeDate");
                    StringBuffer sql = new StringBuffer();
                    sql.append("select t1.fitemid, t1.famount");
                    sql.append(" from t_csl_investDayEntry t1");
                    sql.append(" join t_csl_rptItem t2 on t1.fitemId = t2.fid");
                    sql.append(" where t1.finvestDayId = ?");
                    sql.append(" and t1.fcontrolAttr = ");
                    sql.append(20);
                    sql.append(" and t1.famount <> 0 and t2.fisSumItem = 0");
                    sql.append(" and FAssistantFlag = ?");
                    Object[] param = new Object[]{firstInvest.getString("FID"), new Integer(1)};
                    IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
                    while (rowSet.next()) {
                        String itemid = rowSet.getString("fitemid");
                        BigDecimal amount = rowSet.getBigDecimal("FAmount");
                        if (amount == null) continue;
                        BigDecimal sum = (BigDecimal)sumItem.get(itemid);
                        if (sum == null) {
                            sum = ZERO;
                        }
                        sumItem.put(itemid, sum.add(amount));
                    }
                }
                while (invests.next()) {
                    BigDecimal sum;
                    BigDecimal amount;
                    String itemid;
                    Date changeDate = invests.getDate("FChangeDate");
                    if (!changeDate.after(date)) continue;
                    StringBuffer sql = new StringBuffer();
                    sql.append("select t1.fitemid, t1.famount");
                    sql.append(" from t_csl_investDayEntry t1");
                    sql.append(" join t_csl_rptItem t2 on t1.fitemId = t2.fid");
                    sql.append(" where t1.finvestDayId = ?");
                    sql.append(" and t1.fcontrolAttr = ");
                    sql.append(20);
                    sql.append(" and t1.famount <> 0 and t2.fisSumItem = 0");
                    sql.append(" and FAssistantFlag = ?");
                    Object[] param = new Object[]{invests.getString("FID"), new Integer(1)};
                    IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
                    while (rowSet.next()) {
                        itemid = rowSet.getString("fitemid");
                        amount = rowSet.getBigDecimal("FAmount");
                        if (amount == null) continue;
                        sum = (BigDecimal)sumItem.get(itemid);
                        if (sum == null) {
                            sum = ZERO;
                        }
                        sumItem.put(itemid, sum.add(amount));
                    }
                    param[1] = new Integer(0);
                    rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
                    while (rowSet.next()) {
                        itemid = rowSet.getString("fitemid");
                        amount = rowSet.getBigDecimal("FAmount");
                        if (amount == null) continue;
                        sum = (BigDecimal)sumItem.get(itemid);
                        if (sum == null) {
                            sum = ZERO;
                        }
                        sumItem.put(itemid, sum.subtract(amount));
                    }
                    date = changeDate;
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            for (String itemid : sumItem.keySet()) {
                HashMap<String, String> data = new HashMap<String, String>(4);
                data.put("RPTITEM_ID", itemid);
                data.put("KEY_CURRENCY_ID", currencyId);
                data.put("Value", (String)sumItem.get(itemid));
                result.add(data);
            }
        } else {
            BigDecimal sumOwner = ZERO;
            try {
                if (isFirst && firstInvest.next()) {
                    date = firstInvest.getDate("FChangeDate");
                    sumOwner = firstInvest.getBigDecimal("FOwnerSumNew");
                }
                while (invests.next()) {
                    Date changeDate = invests.getDate("FChangeDate");
                    if (!changeDate.after(date)) continue;
                    BigDecimal ownernew = invests.getBigDecimal("FOwnerSumNew");
                    BigDecimal ownerold = invests.getBigDecimal("FOwnerSumOld");
                    sumOwner = sumOwner.add(ownernew.subtract(ownerold));
                    date = changeDate;
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            if (sumOwner.compareTo(ZERO) != 0) {
                HashMap<String, Object> data = new HashMap<String, Object>(4);
                data.put("KEY_CURRENCY_ID", currencyId);
                data.put("Value", sumOwner);
                result.add(data);
            }
        }
        return result;
    }

    public static List getThisYearSumInvestAmount(Context ctx, String companyID, String targetCompanyID, String currencyId, java.util.Date elimDate) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        int year = DateTimeUtils.getYear((java.util.Date)elimDate);
        IRowSet invests = InvestDayUtilForMainCost.getThisYearInvests(ctx, companyID, targetCompanyID, currencyId, year, elimDate, true);
        BigDecimal sumInvestAmount = ZERO;
        try {
            while (invests.next()) {
                BigDecimal investAmount = invests.getBigDecimal("FInvestAmount");
                sumInvestAmount = sumInvestAmount.add(investAmount);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (sumInvestAmount.compareTo(ZERO) != 0) {
            HashMap<String, Object> data = new HashMap<String, Object>(4);
            data.put("KEY_CURRENCY_ID", currencyId);
            data.put("Value", sumInvestAmount);
            result.add(data);
        }
        return result;
    }

    public static List getThisYearProfit(Context ctx, List companyIDs, String targetCompanyID, String currencyId, int year, boolean expanded) throws BOSException, EASBizException {
        String companyID;
        ArrayList result = new ArrayList();
        IRowSet info = null;
        for (int i = 0; i < companyIDs.size() && (info = InvestDayUtilForMainCost.getFirstInvest(ctx, companyID = (String)companyIDs.get(i), targetCompanyID, currencyId, year)) == null; ++i) {
        }
        if (info == null) {
            return result;
        }
        if (expanded && !InvestDayUtilForMainCost.isSumItem(ctx, 21)) {
            expanded = false;
        }
        try {
            if (info.next()) {
                if (expanded) {
                    StringBuffer sql = new StringBuffer();
                    sql.append("select t1.fitemid, t1.famount");
                    sql.append(" from t_csl_investDayEntry t1");
                    sql.append(" join t_csl_rptItem t2 on t1.fitemId = t2.fid");
                    sql.append(" where t1.finvestDayId = '");
                    sql.append(info.getString("FID"));
                    sql.append("' and t1.fcontrolAttr = ");
                    sql.append(21);
                    sql.append(" and t1.famount <> 0 and t2.fisSumItem = 0");
                    IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                    while (rowSet.next()) {
                        HashMap<String, Object> data = new HashMap<String, Object>(4);
                        data.put("RPTITEM_ID", rowSet.getString("fitemid"));
                        data.put("KEY_CURRENCY_ID", currencyId);
                        data.put("Value", rowSet.getBigDecimal("famount"));
                        result.add(data);
                    }
                } else {
                    HashMap<String, Object> data = new HashMap<String, Object>(4);
                    data.put("KEY_CURRENCY_ID", currencyId);
                    data.put("Value", info.getBigDecimal("FProfit"));
                    result.add(data);
                }
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return result;
    }

    public static java.util.Date getThisYearLastInvestDate(Context ctx, String companyId, String targetCompanyId, String currencyId, int year, java.util.Date elimDate) throws BOSException {
        java.util.Date begin = RPTDateUtil.getBeginOfYear(year);
        String endOfYear = CslRptUtil.formatDateForSql(elimDate);
        StringBuffer sql = new StringBuffer();
        sql.append("select top 1 FID, FChangeDate ");
        sql.append(" from t_csl_investDay");
        sql.append(" where FCurrencyId = '").append(currencyId).append("'");
        if (!StringUtils.isEmpty((String)companyId)) {
            sql.append(" and FCompanyId = '").append(companyId).append("'");
        }
        sql.append(" and FTargetCompanyId = '").append(targetCompanyId).append("'");
        sql.append(" and FChangeDate <= ").append(endOfYear);
        sql.append(" order by FChangeDate desc");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rowSet.next()) {
                java.util.Date date = rowSet.getDate("FChangeDate");
                if (date.before(begin)) {
                    date = begin;
                }
                return date;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return begin;
    }

    public static BigDecimal getEndOfThisYearProfit(Context ctx, String companyId, String targetCompanyId, String currencyId, java.util.Date elimDate) throws EASBizException, BOSException {
        IRowSet info = InvestDayUtilForMainCost.getEndOfYearInvest(ctx, companyId, targetCompanyId, currencyId, elimDate);
        try {
            if (info.next()) {
                return info.getBigDecimal("FProfit");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return ZERO;
    }

    public static BigDecimal getEndOfThisYearSumInvestRate(Context ctx, String companyId, String targetCompanyId, java.util.Date elimDate, String currencyId) throws EASBizException, BOSException {
        IRowSet info = InvestDayUtilForMainCost.getEndOfYearInvest(ctx, companyId, targetCompanyId, currencyId, elimDate);
        try {
            if (info.next()) {
                return info.getBigDecimal("FSumInvestRate");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return ZERO;
    }

    public static BigDecimal getBeginOfThisYearSumInvestRate(Context ctx, String companyId, String targetCompanyId, String currencyId, int year) throws EASBizException, BOSException {
        return InvestDayUtilForMainCost.getEndOfThisYearSumInvestRate(ctx, companyId, targetCompanyId, RPTDateUtil.getEndOfYear(year - 1), currencyId);
    }

    public static List getThisYearAllProfit(Context ctx, String companyId, String targetCompanyId, String currencyId, java.util.Date elimDate) throws EASBizException, BOSException {
        ArrayList result = new ArrayList();
        int year = DateTimeUtils.getYear((java.util.Date)elimDate);
        IRowSet invests = InvestDayUtilForMainCost.getThisYearInvests(ctx, companyId, targetCompanyId, currencyId, year, elimDate, true);
        try {
            while (invests.next()) {
                BigDecimal profit = invests.getBigDecimal("FProfit");
                if (profit == null) {
                    profit = ZERO;
                }
                HashMap<String, Comparable<BigDecimal>> data = new HashMap<String, Comparable<BigDecimal>>();
                data.put("Value", profit);
                data.put("ChangeDate", invests.getDate("FChangeDate"));
                data.put("SumInvestRate", invests.getBigDecimal("FSumInvestRate"));
                result.add(data);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return result;
    }

    public static BigDecimal getThisDaySumInvestRate(Context ctx, String companyId, String targetCompanyId, String currencyId, java.util.Date day) throws EASBizException, BOSException {
        IRowSet info = InvestDayUtilForMainCost.getThisDayInvest(ctx, companyId, targetCompanyId, currencyId, day);
        try {
            if (info.next()) {
                return info.getBigDecimal("FSumInvestRate");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return ZERO;
    }

    private static IRowSet getThisDayInvest(Context ctx, String companyId, String targetCompanyId, String currencyId, java.util.Date day) throws BOSException {
        String endOfDate = CslRptUtil.formatDateForSql(RPTDateUtil.getEndOfDay(day));
        StringBuffer sql = new StringBuffer();
        sql.append("select top 1 FID, FChangeDate, FInvestRate, FSumInvestRate, ");
        sql.append("FInvestAmount, FSumInvestAmout, FOwnerSumNew, FOwnerSumOld, FProfit, ");
        sql.append("FHonor, FHonorSum, FMinorityChange from t_csl_investDay");
        sql.append(" where FCurrencyId = ?");
        sql.append(" and FCompanyId = ?");
        sql.append(" and FTargetCompanyId = ?");
        sql.append(" and FChangeDate <= ");
        sql.append(endOfDate);
        sql.append(" order by FChangeDate desc");
        Object[] param = new Object[]{currencyId, companyId, targetCompanyId};
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
    }

    public static boolean existsInvest(Context ctx, String companyId, String targetCompanyId, String currencyId, int year, java.util.Date elimDate) throws BOSException, EASBizException {
        String beginOfYear = CslRptUtil.formatDateForSql(RPTDateUtil.getBeginOfYear(year));
        String endOfYear = CslRptUtil.formatDateForSql(elimDate);
        IInvestDay iinvestDay = InvestDayFactory.getLocalInstance(ctx);
        StringBuffer oql = new StringBuffer();
        oql.append(" where targetCompany.id = '" + targetCompanyId);
        oql.append("' and currency.id = '" + currencyId);
        if (!StringUtils.isEmpty((String)companyId)) {
            oql.append("' and company.id = '" + companyId);
        }
        oql.append("' and changeDate >= " + beginOfYear);
        oql.append(" and changeDate <= " + endOfYear);
        return iinvestDay.exists(oql.toString());
    }

    public static boolean isThisYearByFirstInvest(Context ctx, String companyId, String targetCompanyId, String currencyId, int year) throws BOSException, EASBizException {
        int firstYear = InvestDayUtilForMainCost.getFirstInvestYear(ctx, companyId, targetCompanyId, currencyId);
        return firstYear == year;
    }

    public static int getFirstInvestYear(Context ctx, String companyId, String targetCompanyId, String currencyId) throws BOSException, EASBizException {
        StringBuffer oql = new StringBuffer();
        oql.append("select min(FChangeDate) as firstDate from t_csl_investDay ");
        oql.append("where FTargetCompanyId = '");
        oql.append(targetCompanyId);
        if (!StringUtils.isEmpty((String)companyId)) {
            oql.append("' and FCompanyId = '");
            oql.append(companyId);
        }
        if (!StringUtils.isEmpty((String)currencyId)) {
            oql.append("' and FCurrencyId = '");
            oql.append(currencyId);
        }
        oql.append("'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)oql.toString());
        try {
            if (rowSet.next()) {
                Date changeDate = rowSet.getDate("firstDate");
                if (changeDate == null) {
                    return -1;
                }
                return DateTimeUtils.getYear((java.util.Date)changeDate);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return -1;
    }

    public static boolean isThisYearByLastInvest(Context ctx, String companyId, String targetCompanyId, String currencyId, java.util.Date elimDate) throws BOSException, EASBizException {
        int year;
        int firstYear = InvestDayUtilForMainCost.getLastInvestYear(ctx, companyId, targetCompanyId, currencyId, elimDate);
        return firstYear == (year = DateTimeUtils.getYear((java.util.Date)elimDate));
    }

    public static int getLastInvestYear(Context ctx, String companyId, String targetCompanyId, String currencyId, java.util.Date elimDate) throws BOSException, EASBizException {
        IRowSet rowSet = InvestDayUtilForMainCost.getLastInvest(ctx, companyId, targetCompanyId, currencyId, elimDate);
        if (rowSet != null) {
            try {
                if (rowSet.next()) {
                    Date changeDate = rowSet.getDate("FChangeDate");
                    if (changeDate == null) {
                        return -1;
                    }
                    return DateTimeUtils.getYear((java.util.Date)changeDate);
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return -1;
    }

    public static String getLastInvestCompany(Context ctx, String targetCompanyId, String currencyId, java.util.Date elimDate) throws BOSException {
        IRowSet rowSet = InvestDayUtilForMainCost.getLastInvest(ctx, null, targetCompanyId, currencyId, elimDate);
        if (rowSet != null) {
            try {
                if (rowSet.next()) {
                    return rowSet.getString("FCompanyId");
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return null;
    }

    private static IRowSet getLastInvest(Context ctx, String companyId, String targetCompanyId, String currencyId, java.util.Date elimDate) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select top 1 FID, FCompanyId, FChangeDate, FInvestRate, FSumInvestRate, ");
        sql.append("FInvestAmount, FSumInvestAmout, FOwnerSumNew, FOwnerSumOld, FProfit, ");
        sql.append("FHonor, FHonorSum, FMinorityChange, FDiffValue from t_csl_investDay");
        sql.append(" where FTargetCompanyId = '");
        sql.append(targetCompanyId);
        if (!StringUtils.isEmpty((String)companyId)) {
            sql.append("' and FCompanyId = '");
            sql.append(companyId);
        }
        if (!StringUtils.isEmpty((String)currencyId)) {
            sql.append("' and FCurrencyId = '");
            sql.append(currencyId);
        }
        sql.append("' and FChangeDate <= ").append(CslRptUtil.formatDateForSql(elimDate));
        sql.append(" order by FChangeDate desc");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return rowSet;
    }

    public static Map getCompanysOfMainCost(Context ctx, String orgTreeId, String orgUnitId, String currencyId, java.util.Date day, boolean returnElimType, String longnumber) throws BOSException {
        String strDay = CslRptUtil.formatDateForSql(day);
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct t1.fcompanyid, t1.ftargetCompanyid, t1.FSumInvestRate,");
        sql.append(" t1.FCombineType, t2.flongnumber, t3.flongnumber ");
        sql.append(" from t_csl_investDay t1 inner join");
        sql.append(" (select FUnitId, FLongNumber from t_org_structure");
        sql.append(" where FTreeId = '" + orgTreeId + "') t2");
        sql.append(" on t1.fcompanyid = t2.funitid");
        sql.append(" inner join ");
        sql.append(" (select FUnitId, FLongNumber from t_org_structure");
        sql.append(" where FTreeId = '" + orgTreeId + "') t3");
        sql.append(" on t1.ftargetCompanyid = t3.funitid");
        sql.append(" inner join ");
        sql.append(" (select FCompanyId, FTargetCompanyId, max(FChangeDate) FChangeDate");
        sql.append(" from t_csl_investDay ");
        sql.append(" where FChangeDate <= ").append(strDay);
        sql.append(" and FCurrencyId = '").append(currencyId).append("'");
        sql.append(" group by FCompanyId, FTargetCompanyId) t4");
        sql.append(" on t1.FCompanyId = t4.FCompanyId ");
        sql.append(" and t1.FTargetCompanyId = t4.FTargetCompanyId");
        sql.append(" and t1.FChangeDate = t4.FChangeDate");
        sql.append(" where t1.FCurrencyId = '").append(currencyId).append("'");
        HashMap toCompanys = new HashMap();
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            String[] numbers = StringUtils.split((String)longnumber, (String)"!");
            int size = numbers.length;
            BigDecimal ZERO = CslConstant.BGZERO;
            while (rowSet.next()) {
                String companyId = rowSet.getString(1);
                String targetCompanyId = rowSet.getString(2);
                BigDecimal rate = rowSet.getBigDecimal(3);
                if (ZERO.compareTo(rate) == 0) continue;
                int combineType = rowSet.getInt(4);
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put(COMPANYID, companyId);
                data.put(TARGET_COMPANYID, targetCompanyId);
                data.put(RATE, rate);
                data.put(COMBINE_TYPE, new Integer(combineType));
                String companyNumber = rowSet.getString(5);
                data.put(COMPANY_NUMBER, companyNumber);
                String[] num1 = StringUtils.split((String)companyNumber, (String)"!");
                String targetCompanyNumber = rowSet.getString(6);
                data.put(TARGET_COMPANY_NUMBER, targetCompanyNumber);
                String[] num2 = StringUtils.split((String)targetCompanyNumber, (String)"!");
                if (!(companyNumber.equals(longnumber) && targetCompanyNumber.equals(longnumber) || companyNumber.indexOf(longnumber + "!") == 0 && targetCompanyNumber.indexOf(longnumber + "!") == 0)) {
                    data.put("NotElim", Boolean.TRUE);
                } else if (num1.length > size + 1 && num2.length > size + 1 && StringUtils.equals((String)num1[size], (String)num2[size])) {
                    data.put("NotElim", Boolean.TRUE);
                }
                if (num1.length == 2) {
                    data.put("InTopGroup", Boolean.TRUE);
                }
                Map fromCompanys = new HashMap();
                if (toCompanys.containsKey(targetCompanyId)) {
                    fromCompanys = (Map)toCompanys.get(targetCompanyId);
                } else {
                    toCompanys.put(targetCompanyId, fromCompanys);
                }
                if (fromCompanys.containsKey(companyId)) continue;
                fromCompanys.put(companyId, data);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        InvestDayUtilForMainCost.takeUndirectCompany(toCompanys, longnumber);
        InvestDayUtilForMainCost.computeEquivalentRate(toCompanys);
        HashMap<String, Map> result = new HashMap<String, Map>();
        result.put("EquivalentRate", InvestDayUtilForMainCost.getEquivalentRateResultMap(toCompanys));
        if (returnElimType) {
            result.put("ElimType", InvestDayUtilForMainCost.getElimTypeAndResultMap(toCompanys));
        }
        return result;
    }

    private static void takeUndirectCompany(Map toCompanys, String longnumber) {
        for (String targetCompanyId : toCompanys.keySet()) {
            if (InvestDayUtilForMainCost.isInvestCompany(toCompanys, targetCompanyId)) continue;
            Map fromCompanys = (Map)toCompanys.get(targetCompanyId);
            Object[] arr = fromCompanys.keySet().toArray();
            for (int i = 0; i < arr.length; ++i) {
                String companyId = (String)arr[i];
                if (!toCompanys.containsKey(companyId)) continue;
                Map data = (Map)fromCompanys.get(companyId);
                int combineType = (Integer)data.get(COMBINE_TYPE);
                String targetCompanyNumber = (String)data.get(TARGET_COMPANY_NUMBER);
                InvestDayUtilForMainCost.takeUndirectCompany(toCompanys, targetCompanyId, targetCompanyNumber, companyId, combineType, longnumber);
            }
        }
    }

    private static boolean isInvestCompany(Map toCompanys, String investCompanyId) {
        for (String targetCompanyId : toCompanys.keySet()) {
            Map fromCompanys = (Map)toCompanys.get(targetCompanyId);
            if (!fromCompanys.containsKey(investCompanyId)) continue;
            return true;
        }
        return false;
    }

    private static void takeUndirectCompany(Map toCompanys, String targetCompanyId, String targetCompanyNumber, String middleCompanyId, int combineType, String longnumber) {
        if (!toCompanys.containsKey(middleCompanyId)) {
            return;
        }
        Map fromCompanys = (Map)toCompanys.get(middleCompanyId);
        for (String companyId : fromCompanys.keySet()) {
            int i2;
            String s2;
            int i1;
            Map tmpData;
            String companyNumber;
            String s1;
            if (toCompanys.containsKey(companyId)) {
                InvestDayUtilForMainCost.takeUndirectCompany(toCompanys, targetCompanyId, targetCompanyNumber, companyId, combineType, longnumber);
                continue;
            }
            Map tmpMap = (Map)toCompanys.get(targetCompanyId);
            if (tmpMap.containsKey(companyId) || !(s1 = (companyNumber = (String)(tmpData = (Map)fromCompanys.get(companyId)).get(COMPANY_NUMBER)).substring(0, i1 = companyNumber.lastIndexOf("!"))).equals(s2 = targetCompanyNumber.substring(0, i2 = targetCompanyNumber.lastIndexOf("!"))) && s2.startsWith(s1)) continue;
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put(COMPANYID, companyId);
            data.put(TARGET_COMPANYID, targetCompanyId);
            data.put(RATE, ZERO);
            data.put(COMBINE_TYPE, new Integer(combineType));
            data.put(COMPANY_NUMBER, companyNumber);
            String[] num1 = StringUtils.split((String)companyNumber, (String)"!");
            data.put(TARGET_COMPANY_NUMBER, targetCompanyNumber);
            String[] num2 = StringUtils.split((String)targetCompanyNumber, (String)"!");
            String[] numbers = StringUtils.split((String)longnumber, (String)"!");
            int size = numbers.length;
            if (companyNumber.indexOf(longnumber) != 0 || targetCompanyNumber.indexOf(longnumber) != 0) {
                data.put("NotElim", Boolean.TRUE);
            } else if (num1.length > size + 1 && num2.length > size + 1 && StringUtils.equals((String)num1[size], (String)num2[size])) {
                data.put("NotElim", Boolean.TRUE);
            }
            if (num1.length == 2) {
                data.put("InTopGroup", Boolean.TRUE);
            }
            tmpMap.put(companyId, data);
        }
    }

    private static Map getEquivalentRateResultMap(Map toCompanys) {
        HashMap result = new HashMap();
        for (String targetCompanyId : toCompanys.keySet()) {
            Map fromCompanys = (Map)toCompanys.get(targetCompanyId);
            BigDecimal rate = ZERO;
            for (String companyId : fromCompanys.keySet()) {
                Map data = (Map)fromCompanys.get(companyId);
                if (data.containsKey("NotElim") || data.containsKey("middlePoint")) continue;
                rate = rate.add((BigDecimal)data.get(EQUIVALENT_RATE));
                result.put(targetCompanyId + companyId, data.get(EQUIVALENT_RATE));
            }
            if (rate.compareTo(ZERO) <= 0) continue;
            result.put(targetCompanyId, rate);
        }
        return result;
    }

    private static Map getElimTypeAndResultMap(Map toCompanys) {
        HashMap unidentityUnDirect = new HashMap();
        HashMap identityUnDirect = new HashMap();
        HashMap unidentityDirect = new HashMap();
        HashMap identityDirect = new HashMap();
        for (String targetCompanyId : toCompanys.keySet()) {
            int combineType;
            String companyId;
            Map mapdata;
            Map fromCompanys = (Map)toCompanys.get(targetCompanyId);
            BigDecimal maxRate = ZERO;
            ArrayList<String> ids = new ArrayList<String>();
            for (String companyId2 : fromCompanys.keySet()) {
                Map data = (Map)fromCompanys.get(companyId2);
                BigDecimal rate = (BigDecimal)data.get(EQUIVALENT_RATE);
                if (maxRate.compareTo(rate) < 0) {
                    maxRate = rate;
                    ids.clear();
                    ids.add(companyId2);
                    continue;
                }
                if (maxRate.compareTo(rate) != 0) continue;
                ids.add(companyId2);
            }
            if (ids.size() > 1) {
                InvestDayUtilForMainCost.getDirectCompanyIds(ids, fromCompanys);
            }
            if (!(mapdata = (Map)fromCompanys.get(companyId = (String)ids.get(0))).containsKey("NotElim")) {
                ArrayList idList = new ArrayList();
                ArrayList uidList = new ArrayList();
                for (Map data : fromCompanys.values()) {
                    if (data.containsKey("NotElim")) continue;
                    combineType = (Integer)data.get(COMBINE_TYPE);
                    if (combineType == 0) {
                        idList.add(data.get(COMPANYID));
                        continue;
                    }
                    uidList.add(data.get(COMPANYID));
                }
                if (!idList.isEmpty()) {
                    identityDirect.put(targetCompanyId, idList);
                }
                if (uidList.isEmpty()) continue;
                unidentityDirect.put(targetCompanyId, uidList);
                continue;
            }
            ArrayList iudList = new ArrayList();
            ArrayList uiudList = new ArrayList();
            for (Map data : fromCompanys.values()) {
                if (data.containsKey("NotElim")) continue;
                combineType = (Integer)data.get(COMBINE_TYPE);
                if (combineType == 0) {
                    iudList.add(data.get(COMPANYID));
                    continue;
                }
                uiudList.add(data.get(COMPANYID));
            }
            if (!iudList.isEmpty()) {
                identityUnDirect.put(targetCompanyId, iudList);
            }
            if (uiudList.isEmpty()) continue;
            unidentityUnDirect.put(targetCompanyId, uiudList);
        }
        HashMap result = new HashMap();
        result.put(IDENTITY_DIRECT, identityDirect);
        result.put(IDENTITY_UNDIRECT, identityUnDirect);
        result.put(UNIDENTITY_DIRECT, unidentityDirect);
        result.put(UNIDENTITY_UNDIRECT, unidentityUnDirect);
        return result;
    }

    private static void getDirectCompanyIds(List ids, Map fromCompanys) {
        ArrayList<String> result = new ArrayList<String>();
        int size = 0;
        for (int i = 0; i < ids.size(); ++i) {
            String companyId = (String)ids.get(i);
            Map data = (Map)fromCompanys.get(companyId);
            String companyNumber = (String)data.get(COMPANY_NUMBER);
            String targetCompanyNumber = (String)data.get(TARGET_COMPANY_NUMBER);
            String[] num1 = companyNumber.split("!");
            String[] num2 = targetCompanyNumber.split("!");
            boolean next = false;
            for (int j = 0; j < num1.length && j < num2.length && !next; ++j) {
                if (StringUtils.equals((String)num1[j], (String)num2[j])) continue;
                if (size < j) {
                    result.clear();
                    result.add(companyId);
                    size = j;
                } else if (size == j) {
                    result.add(companyId);
                    size = j;
                }
                next = true;
            }
        }
        ids.clear();
        ids.addAll(result);
    }

    private static void computeEquivalentRate(Map toCompanys) {
        for (String targetCompany : toCompanys.keySet()) {
            Map fromCompanys = (Map)toCompanys.get(targetCompany);
            for (String company : fromCompanys.keySet()) {
                Map data = (Map)fromCompanys.get(company);
                if (data.containsKey(EQUIVALENT_RATE)) continue;
                String companyNumber = (String)data.get(COMPANY_NUMBER);
                String targetCompanyNumber = (String)data.get(TARGET_COMPANY_NUMBER);
                String longnumber = InvestDayUtilForMainCost.getParentNumber(companyNumber, targetCompanyNumber);
                InvestDayUtilForMainCost.computeEquivalentRate(company, targetCompany, longnumber, toCompanys);
            }
        }
    }

    private static String getParentNumber(String number1, String number2) {
        String[] str1 = number1.split("!");
        String[] str2 = number2.split("!");
        int k = Math.min(str1.length, str2.length);
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < k && str1[i].equals(str2[i]); ++i) {
            buf.append(str1[i]).append("!");
        }
        if (buf.length() > 0) {
            buf.deleteCharAt(buf.length() - 1);
        }
        return buf.toString();
    }

    private static BigDecimal computeEquivalentRate(String company, String targetCompany, String clongnumber, Map toCompanys) {
        Map data;
        if (!toCompanys.containsKey(targetCompany)) {
            return ZERO;
        }
        Map fromCompanys = (Map)toCompanys.get(targetCompany);
        if (fromCompanys.isEmpty()) {
            return ZERO;
        }
        if (fromCompanys.size() == 1) {
            Map tmpData = (Map)fromCompanys.values().iterator().next();
            tmpData.put(EQUIVALENT_RATE, tmpData.get(RATE));
        }
        if ((data = (Map)fromCompanys.get(company)) != null && data.containsKey(EQUIVALENT_RATE)) {
            return (BigDecimal)data.get(EQUIVALENT_RATE);
        }
        BigDecimal rate = data != null ? (BigDecimal)data.get(RATE) : ZERO;
        for (String id : fromCompanys.keySet()) {
            if (id.equals(company)) continue;
            Map tmpData = (Map)fromCompanys.get(id);
            String companyNumber = (String)tmpData.get(COMPANY_NUMBER);
            String targetCompanyNumber = (String)tmpData.get(TARGET_COMPANY_NUMBER);
            if (companyNumber.indexOf(clongnumber) != 0) continue;
            int size = clongnumber.split("!").length;
            if (StringUtils.equals((String)companyNumber.split("!")[size], (String)targetCompanyNumber.split("!")[size])) continue;
            BigDecimal value = (BigDecimal)tmpData.get(RATE);
            BigDecimal rate1 = InvestDayUtilForMainCost.computeEquivalentRate(company, id, clongnumber, toCompanys);
            if (rate1.compareTo(ZERO) <= 0) continue;
            rate = rate.add(value.multiply(rate1));
            Map tmpFromCmp = (Map)toCompanys.get(targetCompany);
            tmpData.put("middlePoint", Boolean.TRUE);
        }
        if (data != null) {
            data.put(EQUIVALENT_RATE, rate);
        }
        return rate;
    }

    public static Map getCompanysOfMainCostRate(Context ctx, String orgTreeId, String orgUnitId, String currencyId, java.util.Date day, boolean returnElimType) throws BOSException {
        String longnumber;
        String numberSql = "select flongnumber from t_org_structure t where ftreeId = ? and funitId = ?";
        Object[] params = new Object[]{orgTreeId, orgUnitId};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)numberSql, (Object[])params);
        try {
            rowSet.next();
            longnumber = rowSet.getString(1);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        Date sqlDate = new Date(day.getTime());
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct t1.fcompanyid as fcompanyid, t1.ftargetCompanyid as ftargetCompanyid, t1.FSumInvestRate as FSumInvestRate,");
        sql.append(" t1.FCombineType as FCombineType, t2.flongnumber fromlongnumber, t3.flongnumber as tolongnumber");
        sql.append(" from t_csl_investDay t1 inner join");
        sql.append(" (select FUnitId, FLongNumber from t_org_structure");
        sql.append(" where FTreeId = ?) t2");
        sql.append(" on t1.fcompanyid = t2.funitid");
        sql.append(" inner join ");
        sql.append(" (select FUnitId, FLongNumber from t_org_structure");
        sql.append(" where FTreeId = ?) t3");
        sql.append(" on t1.ftargetCompanyid = t3.funitid");
        sql.append(" inner join ");
        sql.append(" (select FCompanyId, FTargetCompanyId, max(FChangeDate) FChangeDate");
        sql.append(" from t_csl_investDay ");
        sql.append(" where FChangeDate <= ?");
        sql.append(" and FCurrencyId = ?");
        sql.append(" group by FCompanyId, FTargetCompanyId) t4");
        sql.append(" on t1.FCompanyId = t4.FCompanyId ");
        sql.append(" and t1.FTargetCompanyId = t4.FTargetCompanyId");
        sql.append(" and t1.FChangeDate = t4.FChangeDate");
        sql.append(" where t1.FCurrencyId = ?");
        HashMap CompanysAndRate = new HashMap();
        params = new Object[]{orgTreeId, orgTreeId, sqlDate, currencyId, currencyId};
        rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        try {
            while (rowSet.next()) {
                String companyId = rowSet.getString("fcompanyid");
                String targetCompanyId = rowSet.getString("ftargetCompanyid");
                BigDecimal rate = rowSet.getBigDecimal("FSumInvestRate");
                int combineType = rowSet.getInt("FCombineType");
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put(COMPANYID, companyId);
                data.put(TARGET_COMPANYID, targetCompanyId);
                data.put(RATE, rate);
                data.put(COMBINE_TYPE, new Integer(combineType));
                String companyNumber = rowSet.getString("fromlongnumber");
                data.put(COMPANY_NUMBER, companyNumber);
                String targetCompanyNumber = rowSet.getString("tolongnumber");
                data.put(TARGET_COMPANY_NUMBER, targetCompanyNumber);
                String parentNumber = CslInvestUtil.getCommonParent(companyNumber, targetCompanyNumber);
                if (companyNumber.indexOf(longnumber) != 0 || targetCompanyNumber.indexOf(longnumber) != 0 || !parentNumber.equals(longnumber)) continue;
                CompanysAndRate.put(companyId + targetCompanyId, data);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return CompanysAndRate;
    }
}

