/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.variant.Util;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.gr.cslrpt.AdjustException;
import com.kingdee.eas.fi.gr.cslrpt.CSLReportGroupEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DebitOrCreditEnum;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.IItemFieldMapped;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataCondition;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataProviderException;
import com.kingdee.eas.fi.gr.cslrpt.ItemFieldMappedFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.app.AbstractItemDataProviderControllerBean;
import com.kingdee.eas.fi.gr.cslrpt.app.CSLServerHelper;
import com.kingdee.eas.fi.gr.cslrpt.app.CollectItemDefine;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ParamTempTblService;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.IItemQueryUnit;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.KeepSingleItemData;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CslConstant;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.gr.dynamic.CslRptAssistantHGFactory;
import com.kingdee.eas.fi.gr.dynamic.DynaItemDataEntryInfo;
import com.kingdee.eas.fi.gr.dynamic.DynaItemDataInfo;
import com.kingdee.eas.fi.gr.dynamic.MultiDynaItemDataEntryInfo;
import com.kingdee.eas.fi.gr.dynamic.MultiDynaItemDataInfo;
import com.kingdee.eas.fi.gr.dynamic.util.MultiDynaItem;
import com.kingdee.eas.fi.gr.fast.util.FastMergeUtil;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.util.RptItemDataSyn;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.jdbc.statement.CslPreparedStatement;
import com.kingdee.eas.fi.rpt.jdbc.statement.CslStatement;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class ItemDataProviderControllerBean
extends AbstractItemDataProviderControllerBean {
    private static final long serialVersionUID = 3997574876659094779L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.cslrpt.app.ItemDataProviderControllerBean");
    private static final int DynaValue = 0;
    private static final int DynaName = 1;
    private static final int DynaType = 2;
    private static final int DynaRow = 3;
    private static final int DynaCol = 4;
    private static final int DynaSheetId = 5;
    private static final int Grade = 6;

    @Override
    protected BigDecimal _getAcctItem(Context ctx, ItemDataCondition condition, boolean isQueryBudget) throws BOSException, EASBizException {
        String orgTreeNumber = condition.getOrgTreeNumber();
        BigDecimal bgResult = SysConstant.BIGZERO;
        boolean isFromCurrentTree = this.isGetFromCurrentTree(condition);
        if (isFromCurrentTree) {
            condition.setOrgTreeNumber(condition.getOrgTreeId());
            condition.setRptYearStart(condition.getRptYearStart());
            condition.setRptYearEnd(condition.getRptYearEnd());
            condition.setRptPeriodStart(condition.getRptPeriodStart());
            condition.setRptPeriodEnd(condition.getRptPeriodEnd());
            bgResult = this.get_AcctItemByNumber(ctx, condition, isQueryBudget);
            condition.setOrgTreeNumber(orgTreeNumber);
            return bgResult;
        }
        Map mapOrgTree = null;
        Set set = null;
        if (isQueryBudget) {
            mapOrgTree = new HashMap(1);
            HashMap<String, Integer> mapPeriod = new HashMap<String, Integer>(4);
            mapPeriod.put("KEY_STARTYEAR", new Integer(condition.getRptYearStart()));
            mapPeriod.put("KEY_ENDYEAR", new Integer(condition.getRptYearEnd()));
            mapPeriod.put("KEY_STARTPERIOD", new Integer(condition.getRptPeriodStart()));
            mapPeriod.put("KEY_ENDPERIOD", new Integer(condition.getRptPeriodEnd()));
            mapOrgTree.put(condition.getOrgBoundID(), mapPeriod);
        } else {
            PeriodCollection periods = null;
            condition = CSLParamUtil.getSysParams(ctx, condition);
            boolean isMergeByFiscalPeriod = condition.isMergeByFiscalPeriod();
            boolean isSupport13Period = condition.isSupport13Period();
            if (isMergeByFiscalPeriod && orgTreeNumber != null) {
                OrgTreeInfo tree = new OrgTreeInfo();
                tree.setNumber(orgTreeNumber);
                periods = FiscalPeriodHelper.getPeriodCollection(ctx, tree);
            }
            mapOrgTree = FiscalPeriodHelper.getOrgTreeByPeriods(ctx, periods, orgTreeNumber, condition.getRptYearStart(), condition.getRptYearEnd(), condition.getRptPeriodStart(), condition.getRptPeriodEnd(), condition.getRptPeriodType(), isMergeByFiscalPeriod, isSupport13Period);
        }
        set = mapOrgTree.keySet();
        Iterator ite = set.iterator();
        while (ite.hasNext()) {
            String strOrgTreeID = ite.next().toString();
            Map mapPeriod = (Map)mapOrgTree.get(strOrgTreeID);
            condition.setOrgTreeNumber(strOrgTreeID);
            condition.setRptYearStart((Integer)mapPeriod.get("KEY_STARTYEAR"));
            condition.setRptYearEnd((Integer)mapPeriod.get("KEY_ENDYEAR"));
            condition.setRptPeriodStart((Integer)mapPeriod.get("KEY_STARTPERIOD"));
            condition.setRptPeriodEnd((Integer)mapPeriod.get("KEY_ENDPERIOD"));
            BigDecimal bg = this.get_AcctItemByNumber(ctx, condition, isQueryBudget);
            if (bg == null) continue;
            bgResult = bgResult.add(bg);
        }
        condition.setOrgTreeNumber(orgTreeNumber);
        return bgResult;
    }

    private boolean isGetFromCurrentTree(ItemDataCondition condition) {
        return condition.getOrgTreeId() != null && condition.getDataSourceString().trim().equals("(ItemDataBd.FDataSource=1 OR ItemDataBd.FDataSource=2)");
    }

    @Override
    protected Map _getAcctItems(Context ctx, ItemDataCondition condition) throws BOSException, EASBizException {
        return this.get_AcctItems(ctx, condition);
    }

    @Override
    protected void _saveItemData(Context ctx, String rptId, Map data, Map caData, Map exchData, Map investData, boolean isAdjust) throws EASBizException, BOSException {
        int valueType = isAdjust ? 1 : 0;
        this.save_ItemData(ctx, rptId, data, caData, exchData, investData, valueType);
    }

    @Override
    protected void _saveItemData(Context ctx, String reportId, Map itemData, Map caData, Map exchData, Map investData, int valueType) throws BOSException, EASBizException {
        this.save_ItemData(ctx, reportId, itemData, caData, exchData, investData, valueType);
    }

    @Override
    protected void _clearItemData(Context ctx, String reportId) throws BOSException, EASBizException {
        this.clear_ItemData(ctx, reportId);
        RptItemDataSyn.getInstance().sysSingleRptItemData(ctx, reportId, true, true);
    }

    @Override
    protected void _reSetItemDataByNull(Context ctx, String reportId) throws BOSException, EASBizException {
        this.reSet_ItemDataByNull(ctx, reportId);
    }

    @Override
    protected void _reSetItemDataByReport(Context ctx, String reportId) throws BOSException, EASBizException {
        this.reSet_ItemDataByReport(ctx, reportId);
    }

    private BigDecimal get_AcctItemByNumber(Context ctx, ItemDataCondition condition, boolean isQueryBudget) throws BOSException, EASBizException {
        IItemFieldMapped itemMap = ItemFieldMappedFactory.getLocalInstance(ctx);
        Map items = itemMap.getHiberMapInfoByCondition(condition);
        if (items == null || items.size() == 0) {
            return null;
        }
        StringBuffer szBuf = new StringBuffer();
        BigDecimal sum = null;
        szBuf.delete(0, szBuf.length());
        szBuf.append(this.getSelectClause(items, condition)).append(this.getFromClauseByNumber(items, condition, isQueryBudget)).append(this.getWhereClauseByNumber(condition, ctx));
        if (condition.getIsAdjusted()) {
            szBuf.append(" GROUP BY company.fnumber, ItemDataBd.fisadjusted ").append(" ORDER BY company.fnumber, ItemDataBd.fisadjusted DESC");
        }
        sum = this.storeItemDataToMap(ctx, items, condition, szBuf);
        return sum;
    }

    private BigDecimal storeItemDataToMap(Context ctx, Map items, ItemDataCondition condition, StringBuffer szBuf) throws BOSException, SQLDataException {
        BigDecimal sum = CslConstant.BGZERO;
        try {
            TreeMap item;
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)szBuf.toString());
            Iterator iter = null;
            BigDecimal v = null;
            HashMap<String, BigDecimal[]> companySum = new HashMap<String, BigDecimal[]>();
            String company = null;
            while (rs.next()) {
                for (String tabName : items.keySet()) {
                    item = (TreeMap)items.get(tabName);
                    for (String itemNo : item.keySet()) {
                        v = rs.getBigDecimal(itemNo);
                        if (!condition.getIsAdjusted()) {
                            if (v == null) continue;
                            if (sum == null) {
                                sum = SysConstant.BIGZERO;
                            }
                            sum = sum.add(v);
                            continue;
                        }
                        String tcompany = rs.getString("CompanyNumber");
                        BigDecimal[] values = (BigDecimal[])companySum.get(tabName + itemNo);
                        if (!tcompany.equals(company)) {
                            sum = sum.add(this.sumAdjusted(values));
                            company = tcompany;
                        }
                        if (values == null) {
                            values = new BigDecimal[13];
                            companySum.put(tabName + itemNo, values);
                        }
                        int adjust = rs.getInt("IsAdjusted");
                        values[adjust] = v;
                    }
                }
            }
            for (String tabName : items.keySet()) {
                item = (TreeMap)items.get(tabName);
                for (String itemNo : item.keySet()) {
                    sum = sum.add(this.sumAdjusted((BigDecimal[])companySum.get(tabName + itemNo)));
                }
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return sum;
    }

    private BigDecimal sumAdjusted(BigDecimal[] values) {
        BigDecimal result = CslConstant.BGZERO;
        if (values == null) {
            return result;
        }
        if (values[2] != null) {
            result = values[2];
        } else {
            if (values[0] != null) {
                result = result.add(values[0]);
            }
            if (values[1] != null) {
                result = result.add(values[1]);
            }
        }
        values[0] = null;
        values[1] = null;
        values[2] = null;
        return result;
    }

    private String getFromClauseByNumber(Map items, ItemDataCondition condition, boolean isQueryBudget) {
        StringBuffer sbFrom = new StringBuffer();
        sbFrom.append("\r\n from  ").append("T_CSL_ItemDataEntry").append(" ").append("ItemDataBd");
        if (isQueryBudget) {
            sbFrom.append("\n Inner join T_Csl_HisRptReceived Received on Received.FReportID = ");
        } else {
            sbFrom.append("\n Inner join T_Csl_RptReceived Received on Received.FReportID = ");
        }
        sbFrom.append("ItemDataBd").append(".FReportID ");
        for (String tabName : items.keySet()) {
            sbFrom.append(" left outer join ").append(tabName).append(" on ").append("ItemDataBd").append(".FID = ").append(tabName).append(".FID  \r\n\t\t");
        }
        sbFrom.append("  inner join t_org_structure stru on stru.funitid=ItemDataBd.Fcompanyid ");
        sbFrom.append(" left outer join T_ORG_BaseUnit  company on ").append("ItemDataBd.").append("FCompanyID").append("=\tcompany.FID\t\r\n\t\t").append(" left outer join T_BD_Currency  cur on ").append("ItemDataBd.").append("FCurrencyID").append("=\tcur.FID\t\r\n\t\t").append(" left outer join T_BD_Currency  tgtcur on ").append("ItemDataBd.").append("FTargetCurrencyID").append("=\ttgtcur.FID\t\r\n\t\t");
        sbFrom.append(CslRptUtil.getRptAddPerportySql(condition.getRptVersionNumber(), null, true));
        return sbFrom.toString();
    }

    private String getWhereClauseByNumber(ItemDataCondition condition, Context ctx) throws BOSException {
        StringBuffer sbWhere = new StringBuffer();
        sbWhere.append("\r\n where ");
        if (StringUtils.isEmpty((String)condition.getOrgTreeNumber())) {
            throw new BOSException("orgTree is null!");
        }
        if (condition.getBaseOrgTreeId() != null) {
            sbWhere.append(" (");
        }
        sbWhere.append(" Received.FOrgTreeID = '").append(condition.getOrgTreeNumber().trim()).append("'");
        if (condition.getBaseOrgTreeId() != null) {
            sbWhere.append(" or Received.FOrgTreeID = '").append(condition.getBaseOrgTreeId()).append("' and fisadjusted=1 )");
        }
        sbWhere.append(" and stru.ftreeid = '").append(condition.getOrgTreeNumber().trim()).append("'");
        String orgUnitString = condition.getOrgUnitId() != null ? CSLServerHelper.getOrStringByList(condition.getOrgUnitId(), "ItemDataBd", "fcompanyid") : CSLServerHelper.getOrStringByList(condition.getOrgUnit(), "company", "FNumber");
        if (orgUnitString != null) {
            sbWhere.append("\n\t\t and ").append(orgUnitString).append("\n\t\t");
        }
        if (condition.getCurrency() != null) {
            sbWhere.append("\n\t\t and cur.FNumber").append(" = '").append(condition.getCurrency().trim()).append("'");
        }
        if (condition.getTargetCurrency() != null) {
            sbWhere.append("\n\t\t and tgtcur.FNumber").append(" = '").append(condition.getTargetCurrency().trim()).append("'");
        }
        if (condition.getRptPeriodType() != -1) {
            sbWhere.append("\n\t\t and ").append("ItemDataBd").append(".").append("FPeriodType").append(" = ").append(condition.getRptPeriodType());
        }
        if (condition.getRptYearStart() == condition.getRptYearEnd()) {
            sbWhere.append("\n\t\t and ").append("ItemDataBd").append(".").append("FYear").append(" = ").append(condition.getRptYearStart());
        } else {
            sbWhere.append("\n\t\t and ").append("ItemDataBd").append(".").append("FYear").append(" >= ").append(condition.getRptYearStart()).append("\n\t\t and ").append("ItemDataBd").append(".").append("FYear").append(" <= ").append(condition.getRptYearEnd());
        }
        if (condition.getRptPeriodStart() == condition.getRptPeriodEnd()) {
            sbWhere.append("\n\t\t and ").append("ItemDataBd").append(".").append("FPeriod").append(" = ").append(condition.getRptPeriodStart());
        } else {
            sbWhere.append("\n\t\t and ").append("ItemDataBd").append(".").append("FPeriod").append(" >= ").append(condition.getRptPeriodStart()).append("\n\t\t and ").append("ItemDataBd").append(".").append("FPeriod").append(" <= ").append(condition.getRptPeriodEnd());
        }
        if (condition.getDataSource() != -1) {
            if (condition.getDataSource() == 1 || condition.getDataSource() == 7) {
                sbWhere.append("\n\t\t and ").append("ItemDataBd").append(".").append("FDataSource").append(" IN (").append(1).append(",").append(7).append(") ");
            } else {
                sbWhere.append("\n\t\t and ").append("ItemDataBd").append(".").append("FDataSource").append(" = ").append(condition.getDataSource());
            }
        } else if (condition.getDataSourceString() != null) {
            sbWhere.append("\n\t\t AND ").append(condition.getDataSourceString()).append(" \r\n");
        }
        if (condition.getDataElement() != -1) {
            sbWhere.append("\n\t\t and ").append("ItemDataBd").append(".").append("FDataElement").append(" = ").append(condition.getDataElement());
        }
        sbWhere.append("\n\t\t and ").append("ItemDataBd").append(".").append("FValueType").append(" = ").append(condition.getValueType());
        if (!condition.getIsAdjusted()) {
            sbWhere.append("\n\t\t and ").append("ItemDataBd").append(".").append("FIsAdjusted").append(" = ").append(0);
        }
        if (condition.getDataSource() != 4 && condition.getCommitStatus() != -1) {
            sbWhere.append("\n\t\t and ").append("ItemDataBd").append(".").append("FCommitStatus").append(" = ").append(condition.getCommitStatus()).append(" \r\n");
        }
        if (condition.getRptVersionNumber() <= 0 && condition.getDataCollectNumber() != null && condition.getDataCollectNumber().length() != 0) {
            sbWhere.append("\n\t\t and ").append("ItemDataBd").append(".").append("FdataCollectNumber").append(" = '").append(condition.getDataCollectNumber()).append("' ");
        }
        sbWhere.append(CslRptUtil.getRptAddPerportySql(condition.getRptVersionNumber(), null, false));
        return sbWhere.toString();
    }

    private Map get_AcctItems(Context ctx, ItemDataCondition condition) throws BOSException, EASBizException {
        Map items = condition.getItemList();
        boolean isGroupByCompany = condition.isGroupByCompany();
        StringBuffer sql = new StringBuffer();
        condition = CSLParamUtil.getSysParams(ctx, condition);
        Object baseOrgTreeNumber = null;
        FastMergeUtil.initConditionByFastMergeSolu(ctx, condition, null);
        StringBuffer szBuf = new StringBuffer();
        StringBuffer szAdjustedBuf = new StringBuffer();
        HashMap map = new HashMap();
        Iterator iter = items.keySet().iterator();
        String autoItemSql = null;
        ParamTempTblService paramTblService = null;
        if (condition.getOrgUnit() != null && condition.getOrgUnit().size() > 0) {
            paramTblService = ParamTempTblService.getDefaultInstance(ctx, condition.getOrgUnit(), null);
            condition.setOrgIdTmpTblSQL(paramTblService.getParamsSql());
        }
        while (iter.hasNext()) {
            String tabName = (String)iter.next();
            TreeMap item = (TreeMap)items.get(tabName);
            szBuf.delete(0, szBuf.length());
            szAdjustedBuf.delete(0, szAdjustedBuf.length());
            if (condition.getIsAdjusted()) {
                szBuf.append(this.getSelectClause4Items(tabName, item)).append(", ItemDataBd.FCompanyID as Company").append(this.getFromClause4Items(tabName, condition, false)).append(this.getWhereClause4Items(condition));
                szAdjustedBuf.append(this.getSelectClause4Items(tabName, item)).append(", ItemDataBd.FCompanyID as Company").append(this.getFromClause4Items(tabName, condition, true)).append(this.getWhereClause4Items(condition));
                StringBuffer sbSelect = new StringBuffer();
                sbSelect.append("Select ");
                sbSelect.append(this.getSelectSumPartStr(item, condition, CslRptUtil.isListEmpty(condition.getAdjustTypeFilter()), null, "t1", "t2"));
                if (isGroupByCompany) {
                    sbSelect.append(",t1.Company as company ");
                }
                sbSelect.append(" FROM ( ");
                if (condition.isContainUnRecive() && !StringUtils.isEmpty((String)condition.getAutoItemFormualId())) {
                    autoItemSql = this.getAutoItemSql(item, tabName, condition);
                }
                if (!StringUtils.isEmpty(autoItemSql)) {
                    sbSelect.append(" select ");
                    sbSelect.append(this.getSelectSumPartStr(item, condition, true, "tmpgroup", "t3", "t4"));
                    sbSelect.append(",t3.Company as company ");
                    sbSelect.append(" from (");
                }
                sbSelect.append(this.getRptAndAdjustStr(tabName, item, condition, !StringUtils.isEmpty((String)autoItemSql)));
                if (!StringUtils.isEmpty((String)autoItemSql)) {
                    sbSelect.append(") t3");
                    sbSelect.append(" full join (").append(autoItemSql);
                    sbSelect.append(") t4 on t3.company=t4.company and t3.tmpgroup=t4.tmpgroup ");
                    sbSelect.append(" group by t3.company");
                }
                sbSelect.append(") t1");
                if (CslRptUtil.isListEmpty(condition.getAdjustTypeFilter())) {
                    sbSelect.append(" left join ").append("( ").append(this.getAdjustRptStr(tabName, item, condition)).append(" ) t2 on t1.Company=t2.Company");
                }
                if (isGroupByCompany) {
                    sbSelect.append(" group by t1.Company ");
                }
                szBuf = sbSelect;
            } else {
                szBuf.append(this.getSelectClause4Items(tabName, item));
                if (isGroupByCompany) {
                    szBuf.append(",ItemDataBd.fcompanyid as company ");
                }
                szBuf.append(this.getFromClause4Items(tabName, condition, false)).append(this.getWhereClause4Items(condition)).append(" AND ItemDataBd.FIsAdjusted != 2 ");
                if (isGroupByCompany) {
                    szBuf.append(" group by ItemDataBd.fcompanyid ");
                }
            }
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)szBuf.toString());
            this.storeRowSetToMap(rs, map, item, isGroupByCompany);
            szBuf.delete(0, szBuf.length());
        }
        if (paramTblService != null) {
            paramTblService.release();
        }
        return map;
    }

    private String getAdjustRptStr(String tabName, TreeMap item, ItemDataCondition condition) throws BOSException, EASBizException {
        StringBuffer adjustRptSql = new StringBuffer();
        adjustRptSql.append(this.getSelectClause4Items(tabName, item)).append(", ItemDataBd.FCompanyID as Company").append(this.getFromClause4Items(tabName, condition, true)).append(this.getWhereClause4Items(condition)).append(" AND ItemDataBd.FIsAdjusted = 2  GROUP BY ItemDataBd.FCompanyID");
        return adjustRptSql.toString();
    }

    private String getRptAndAdjustStr(String tabName, TreeMap item, ItemDataCondition condition, boolean isAutoItem) throws BOSException, EASBizException {
        StringBuffer adjustRptSql = new StringBuffer();
        adjustRptSql.append(this.getSelectClause4Items(tabName, item)).append(", ItemDataBd.FCompanyID as Company");
        if (isAutoItem) {
            adjustRptSql.append(",tmp.fgroup as tmpgroup ");
        }
        adjustRptSql.append(this.getFromClause4Items(tabName, condition, true));
        if (isAutoItem) {
            adjustRptSql.append(" left outer join t_csl_cslreport cslrpt on cslrpt.fid=ItemDataBd.Freportid ");
            adjustRptSql.append(" left outer join t_rpt_template tmp on tmp.fid=cslrpt.ftemplateid ");
        }
        adjustRptSql.append(this.getWhereClause4Items(condition)).append(" AND ItemDataBd.FIsAdjusted != 2 AND ItemDataBd.FIsAdjusted != 11  ");
        if (!CslRptUtil.isListEmpty(condition.getAdjustTypeFilter())) {
            adjustRptSql.append(" and ((ItemDataBd.FIsAdjusted = 1 and ");
            adjustRptSql.append("exists(select 1 from t_csl_adjust where fid=ItemDataBd.freportid and ");
            adjustRptSql.append(CSLServerHelper.getOrStringByList(condition.getAdjustTypeFilter(), null, "fadjustmode"));
            adjustRptSql.append(")) or ItemDataBd.FIsAdjusted != 1)");
        }
        adjustRptSql.append(" GROUP BY ItemDataBd.FCompanyID ");
        if (isAutoItem) {
            adjustRptSql.append(" ,tmp.fgroup ");
        }
        return adjustRptSql.toString();
    }

    private String getSelectSumPartStr(TreeMap item, ItemDataCondition condition, boolean isUseCaseWhen, String caseFiled, String table1, String table2) throws BOSException, EASBizException {
        boolean isCaseFiledNull;
        Iterator ii = item.keySet().iterator();
        StringBuffer sumPartStr = new StringBuffer();
        boolean bl = isCaseFiledNull = caseFiled == null;
        while (ii.hasNext()) {
            String itemNo = ((String)ii.next()).trim();
            if (!isUseCaseWhen) {
                sumPartStr.append(" SUM(").append(table1).append(".\"").append(itemNo).append("\") AS \"").append(itemNo).append("\",\n");
                continue;
            }
            sumPartStr.append(" SUM(CASE WHEN ").append(table2).append(".").append(isCaseFiledNull ? "\"" + itemNo + "\"" : caseFiled).append(" IS NULL THEN ").append(table1).append(".\"").append(itemNo).append("\" ELSE ").append(table2).append(".\"").append(itemNo).append("\" END) AS \"").append(itemNo).append("\",\n");
        }
        if (sumPartStr.lastIndexOf(",") != -1) {
            sumPartStr.deleteCharAt(sumPartStr.lastIndexOf(","));
        }
        return sumPartStr.toString();
    }

    private void storeRowSetToMap(IRowSet rs, HashMap map, TreeMap items, boolean isGroupByCompany) throws SQLDataException {
        String itemNo = null;
        String companyId = null;
        String key = null;
        Iterator iter = items.keySet().iterator();
        Object[] itemsArray = items.keySet().toArray();
        try {
            if (isGroupByCompany) {
                while (rs.next()) {
                    companyId = rs.getString("company");
                    for (int i = 0; i < itemsArray.length; ++i) {
                        itemNo = (String)itemsArray[i];
                        BigDecimal value = rs.getBigDecimal(itemNo);
                        key = itemNo + "!" + companyId;
                        if (!map.containsKey(key)) {
                            map.put(key, value);
                            continue;
                        }
                        BigDecimal bdValue = (BigDecimal)map.get(key);
                        if (bdValue != null) {
                            if (value != null) {
                                map.put(key, bdValue.add(value));
                                continue;
                            }
                            map.put(key, bdValue);
                            continue;
                        }
                        map.put(key, value);
                    }
                }
            } else {
                while (rs.next()) {
                    while (iter.hasNext()) {
                        itemNo = (String)iter.next();
                        BigDecimal value = rs.getBigDecimal(itemNo);
                        if (!map.containsKey(itemNo)) {
                            map.put(itemNo, value);
                            continue;
                        }
                        BigDecimal bdValue = (BigDecimal)map.get(itemNo);
                        if (bdValue != null) {
                            if (value != null) {
                                map.put(itemNo, bdValue.add(value));
                                continue;
                            }
                            map.put(itemNo, bdValue);
                            continue;
                        }
                        map.put(itemNo, value);
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private Map<String, Object> getItemDataHdInfoMap(Context ctx, String rptId, int valueType) throws BOSException, EASBizException {
        HashMap<String, Object> itemDataMap = new HashMap<String, Object>();
        StringBuffer sqlBuffer = new StringBuffer();
        if (valueType == 1) {
            sqlBuffer.append(" select forgunit companyid,fsourcecurrencyid currencyid ,fcurrencyid targetcurrencyid ,");
            sqlBuffer.append("fperiodtype periodtype,fdatasource datasource,3 commitstatus,fid reportid,").append(valueType).append(" isAdjusted,fdataCollectNumber dataCollectNumber,'' fastMergeSoluId,1 FIsSupportGroup").append(" from t_csl_adjust where fid = ? ");
        } else if (valueType == 11) {
            sqlBuffer.append(" select forgunitid companyid,fsourcecurrencyid currencyid,fcurrencyid targetcurrencyid,fperiodtype periodtype,fdatasource datasource,3 commitstatus ,fid reportid,").append(valueType).append(" isAdjusted,fdataCollectNumber dataCollectNumber,'' fastMergeSoluId,1 FIsSupportGroup").append(" from t_csl_caliadjust where fid = ? ");
        } else {
            int commiteStatus = 1;
            if (valueType == 2) {
                commiteStatus = 3;
            }
            sqlBuffer.append(" select forgunitid companyid,Fsourcecurrencyid currencyid,fcurrencyid targetcurrencyid,fperiodtype periodtype,fsourcetype datasource,").append(commiteStatus).append(" commitstatus ,r.fid reportid,").append(valueType).append(" isAdjusted ,fdataCollectNumber dataCollectNumber").append(" ,ffastMergeSoluId fastMergeSoluId,isnull(a.FIsSupportGroup,1) fisSupportGroup from t_csl_cslreport r left join t_csl_sumrptaddedperporty a on a.freport=r.fid where r.fid = ?");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString(), (Object[])new Object[]{rptId});
        try {
            if (rs.next()) {
                itemDataMap.put("KEY_COMPANY_ID", rs.getString("companyid"));
                itemDataMap.put("KEY_SOURCECURRENCY_ID", rs.getString("currencyid"));
                itemDataMap.put("KEY_CURRENCY_ID", rs.getString("targetcurrencyid"));
                itemDataMap.put("PeriodType", rs.getInt("periodtype"));
                itemDataMap.put("KEY_SOURCETYPE", rs.getInt("datasource"));
                itemDataMap.put("committedStatus", rs.getInt("commitstatus"));
                itemDataMap.put("KEY_REPORT_ID", rs.getString("reportid"));
                itemDataMap.put("KEY_ADJUSTSTATUS", rs.getString("isAdjusted"));
                itemDataMap.put("KEY_DATACOLLECT_NUMBER", rs.getString("dataCollectNumber"));
                itemDataMap.put("KEY_FASTMERGEID", rs.getString("fastMergeSoluId"));
                itemDataMap.put("KEY_ISSUPPORTGROUP", rs.getInt("fisSupportGroup") < 1 ? 1 : rs.getInt("fisSupportGroup"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return itemDataMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save_ItemData(Context ctx, String rptId, Map data, Map caData, Map exchData, Map investData, int valueType) throws BOSException, EASBizException {
        block27: {
            this.delete_ItemDataByReportID(ctx, rptId);
            Object[] params = new Object[]{rptId};
            String ItemDataId = Uuid.create().toString();
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append("insert into t_csl_ItemData(");
            sqlBuffer.append("fid,fcompanyid,fcurrencyid,ftargetcurrencyid,fperiodtype,fdatasource,fcommitstatus,freportid,fcommitDate,fisAdjusted,fdataCollectNumber,ffastMergeSoluId,forgType)");
            sqlBuffer.append(" select '");
            sqlBuffer.append(ItemDataId);
            if (valueType == 1) {
                sqlBuffer.append("' as fid,forgunit,fsourcecurrencyid,fcurrencyid,fperiodtype,fdatasource,3,fid,flastupdatetime,").append(valueType).append(",fdataCollectNumber,'',1");
                sqlBuffer.append(" from t_csl_adjust where fid = ?");
            } else if (valueType == 11) {
                sqlBuffer.append("' as fid,forgunitid,fsourcecurrencyid,fcurrencyid,fperiodtype,fdatasource,3,fid,flastupdatetime,").append(valueType).append(",fdataCollectNumber,'',1");
                sqlBuffer.append(" from t_csl_caliadjust where fid = ?");
            } else {
                int commiteStatus = 1;
                if (valueType == 2) {
                    commiteStatus = 3;
                }
                sqlBuffer.append("' as fid,forgunitid,Fsourcecurrencyid,fcurrencyid,fperiodtype,fsourcetype,").append(commiteStatus).append(",fid,flastupdatetime,").append(valueType).append(",fdataCollectNumber");
                sqlBuffer.append(" ,ffastMergeSoluId,forgType from t_csl_cslreport where fid = ?");
            }
            DbUtil.execute((Context)ctx, (String)sqlBuffer.toString(), (Object[])params);
            sqlBuffer.setLength(0);
            sqlBuffer.append("select isnull(FIsSupportGroup,1) fisSupportGroup from t_csl_cslreport rpt left join t_csl_sumrptaddedperporty rptAdd on rpt.fid=rptAdd.Freport where rpt.fid=? ");
            Integer isSupportGoup = 1;
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString(), (Object[])params);
                if (rowSet != null && rowSet.next()) {
                    isSupportGoup = rowSet.getInt("fisSupportGroup") < 1 ? 1 : rowSet.getInt("fisSupportGroup");
                }
            }
            catch (SQLException e1) {
                throw new SQLDataException(e1);
            }
            if (data != null && data.size() != 0) {
                Connection cn = this.getConnection(ctx);
                Statement st = null;
                try {
                    Set keySet = data.keySet();
                    Iterator iter = keySet.iterator();
                    sqlBuffer.delete(0, sqlBuffer.length());
                    sqlBuffer.append("insert into t_csl_ItemDataEntry(   \r\n");
                    sqlBuffer.append("FID,FItemDataID,FDataElement,FValueType,Fyear,FPeriod,FDay,").append("fcompanyid,fcurrencyid,ftargetcurrencyid,fperiodtype,fdatasource,freportid,fcommitstatus,fisadjusted,FDataCollectNumber,FFastMergeSoluID,FIsSupportGroup)  \r\n").append("values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) \r\n");
                    st = cn.createStatement();
                    Object[][] allParams = new Object[keySet.size()][];
                    int index = 0;
                    Map<String, Object> itemDataMap = this.getItemDataHdInfoMap(ctx, rptId, valueType);
                    while (iter.hasNext()) {
                        String key = iter.next().toString();
                        HashMap keyMap = CslRptUtil.getKeyMap(key);
                        String ItemDataEntryId = Uuid.create().toString();
                        params = new Object[]{ItemDataEntryId, ItemDataId, new Integer(keyMap.get("DataElement").toString()), new Integer(keyMap.get("ValueType").toString()), new Integer(keyMap.get("Year").toString()), new Integer(keyMap.get("Period").toString()), Date.valueOf(keyMap.get("Day").toString()), itemDataMap.get("KEY_COMPANY_ID"), itemDataMap.get("KEY_SOURCECURRENCY_ID"), itemDataMap.get("KEY_CURRENCY_ID"), itemDataMap.get("PeriodType"), itemDataMap.get("KEY_SOURCETYPE"), itemDataMap.get("KEY_REPORT_ID"), itemDataMap.get("committedStatus"), itemDataMap.get("KEY_ADJUSTSTATUS"), itemDataMap.get("KEY_DATACOLLECT_NUMBER"), itemDataMap.get("KEY_FASTMERGEID"), itemDataMap.get("KEY_ISSUPPORTGROUP")};
                        allParams[index++] = params;
                        this.updateItemData(ctx, ItemDataEntryId, (HashMap)data.get(key), true, st);
                    }
                    CslRptUtil.batchExecute(ctx, sqlBuffer.toString(), allParams);
                    st.executeBatch();
                    st.clearBatch();
                }
                catch (SQLException e) {
                    try {
                        throw new SQLDataException(e);
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(null, st, (Connection)cn);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup(null, (Statement)st, (Connection)cn);
            }
            if (valueType == 0) break block27;
            RptItemDataSyn.getInstance().sysSingleRptItemData(ctx, rptId, valueType != 1, false);
            return;
        }
        try {
            Iterator iter;
            Set keySet;
            try {
                DBHandler dao = new DBHandler(ctx);
                CollectItemDefine collect = new CollectItemDefine(dao);
                boolean isHasExtrItem = collect.init(rptId);
                if (isHasExtrItem) {
                    collect.addItem(data, "ITEM");
                    collect.addEItem(caData, "LEITEM");
                    collect.addEItem(exchData, "CEITEM");
                    collect.addEItem(investData, "REITEM");
                    Collection<IItemQueryUnit> queryUnits = collect.getQueryUnits();
                    new KeepSingleItemData(dao).exec(queryUnits, collect.getOrgType());
                    collect.clear();
                }
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
            this.delete_InterItemData(ctx, rptId, CSLReportGroupEnum.ELIMINATION);
            this.delete_InterItemData(ctx, rptId, CSLReportGroupEnum.INTERIOR_EXCHANGE);
            this.delete_InvestItemdata(ctx, rptId);
            if (caData != null && caData.size() != 0) {
                keySet = caData.keySet();
                iter = keySet.iterator();
                while (iter.hasNext()) {
                    String key = iter.next().toString();
                    this.insertInterData(ctx, rptId, key, caData.get(key).toString(), CSLReportGroupEnum.ELIMINATION);
                }
            }
            if (exchData != null && exchData.size() != 0) {
                keySet = exchData.keySet();
                iter = keySet.iterator();
                while (iter.hasNext()) {
                    String key = iter.next().toString();
                    this.insertInterData(ctx, rptId, key, exchData.get(key).toString(), CSLReportGroupEnum.INTERIOR_EXCHANGE);
                }
            }
            if (investData != null && investData.size() != 0) {
                keySet = investData.keySet();
                iter = keySet.iterator();
                while (iter.hasNext()) {
                    String key = iter.next().toString();
                    this.insertInvestData(ctx, rptId, key, investData.get(key).toString());
                }
            }
        }
        catch (Throwable throwable) {
            RptItemDataSyn.getInstance().sysSingleRptItemData(ctx, rptId, valueType != 1, false);
            throw throwable;
        }
        RptItemDataSyn.getInstance().sysSingleRptItemData(ctx, rptId, valueType != 1, false);
    }

    private void insertInvestData(Context ctx, String rptId, String key, String value) throws BOSException, EASBizException {
        String[] strarr = key.split(",");
        if (strarr.length < 9) {
            throw new BOSException("parameter error: key values' length < 9 !");
        }
        String strid = Uuid.create().toString();
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("insert into T_CSL_InvestItemData (");
        sqlBuffer.append("FId,");
        sqlBuffer.append("FItemNumber,");
        if (!StringUtils.isEmpty((String)strarr[1])) {
            sqlBuffer.append("FOrgBoundId,");
        }
        sqlBuffer.append("FTargetCompanyId,");
        sqlBuffer.append("FCompanyId,");
        sqlBuffer.append("FCurrencyId,");
        sqlBuffer.append("FTargetCurrencyId,");
        sqlBuffer.append("FYear,");
        sqlBuffer.append("FPeriod,");
        sqlBuffer.append("FPeriodType,");
        sqlBuffer.append("FDay, ");
        sqlBuffer.append("FReportID, ");
        sqlBuffer.append("FDataElement, ");
        sqlBuffer.append("FMoney, ");
        if (value != null && !value.split(",")[1].equals("null")) {
            sqlBuffer.append("FItemPostil, ");
        }
        sqlBuffer.append("FCreatorID, ");
        sqlBuffer.append("FCreateTime) ");
        sqlBuffer.append(" values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,? ");
        if (!StringUtils.isEmpty((String)strarr[1])) {
            sqlBuffer.append(",?");
        }
        if (value != null && !value.split(",")[1].equals("null")) {
            sqlBuffer.append(",?");
        }
        sqlBuffer.append(")");
        ArrayList<Object> listParams = new ArrayList<Object>();
        listParams.add(strid);
        listParams.add(strarr[0]);
        if (!StringUtils.isEmpty((String)strarr[1])) {
            listParams.add(strarr[1]);
        }
        listParams.add(strarr[2]);
        listParams.add(strarr[3]);
        listParams.add(strarr[4]);
        listParams.add(strarr[5]);
        listParams.add(new Integer(strarr[6]));
        listParams.add(new Integer(strarr[7]));
        listParams.add(new Integer(strarr[8]));
        Timestamp timeStamp = new Timestamp(new Long(strarr[9]));
        listParams.add(timeStamp);
        listParams.add(rptId);
        listParams.add(new Integer(DataElementProvider.getDataElementInnerValue(ctx, strarr[10])));
        try {
            BigDecimal money = new BigDecimal(value.split(",")[0]).setScale(6, 4);
            CslRptUtil.checkBigDecimalLength(money);
            listParams.add(money.toString());
        }
        catch (RuntimeException e) {
            listParams.add(value == null || value.split(",")[0].equals("null") ? "0" : value.split(",")[0]);
        }
        if (value != null && !value.split(",")[1].equals("null")) {
            listParams.add(value.split(",")[1]);
        }
        listParams.add(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
        Timestamp createTime = new Timestamp(System.currentTimeMillis());
        listParams.add(createTime);
        DbUtil.execute((Context)ctx, (String)sqlBuffer.toString(), (Object[])listParams.toArray());
    }

    private void delete_InvestItemdata(Context ctx, String rptId) throws BOSException {
        ArrayList<String> deleteParas = new ArrayList<String>();
        deleteParas.add(rptId);
        StringBuffer sql_del = new StringBuffer();
        sql_del.append("delete from T_CSL_InvestItemData where ");
        sql_del.append(" FReportID = ? ");
        DbUtil.execute((Context)ctx, (String)sql_del.toString(), (Object[])deleteParas.toArray());
    }

    private void clear_ItemData(Context ctx, String reportId) throws BOSException, EASBizException {
        StringBuffer strSQL = new StringBuffer();
        Object[] params = new Object[]{reportId};
        this.delete_ItemDataByReportID(ctx, reportId);
        strSQL.append("Delete From T_CSL_ItemDataAssistant Where T_CSL_ItemDataAssistant.FReport = ? and Exists( \r\n");
        strSQL.append("Select b.FID From T_CSL_CslReport b \r\n");
        strSQL.append("Where T_CSL_ItemDataAssistant.FReport = b.FID )");
        DbUtil.execute((Context)ctx, (String)strSQL.toString(), (Object[])params);
        strSQL.delete(0, strSQL.length());
        strSQL.append("Delete From T_CSL_InterItemdata Where FReport = ? ");
        DbUtil.execute((Context)ctx, (String)strSQL.toString(), (Object[])params);
        strSQL.delete(0, strSQL.length());
        strSQL.append("Delete From t_csl_exchitemdata Where FReport = ? ");
        DbUtil.execute((Context)ctx, (String)strSQL.toString(), (Object[])params);
        strSQL.delete(0, strSQL.length());
        strSQL.append("Delete From t_csl_investitemdata Where FReportid = ? ");
        DbUtil.execute((Context)ctx, (String)strSQL.toString(), (Object[])params);
    }

    private void delete_ItemDataByReportID(Context ctx, String reportID) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)reportID)) {
            throw new ItemDataProviderException(ItemDataProviderException.REPORTIDEMPTY);
        }
        Connection cn = null;
        Statement st = null;
        List listTableName = null;
        StringBuffer strSql = new StringBuffer();
        IItemFieldMapped itemDataMapped = ItemFieldMappedFactory.getLocalInstance(ctx);
        listTableName = itemDataMapped.getTableNameByReportId(reportID);
        boolean isHavingSubTable = listTableName != null && listTableName.size() > 0;
        try {
            cn = super.getConnection(ctx);
            st = cn.createStatement();
            if (isHavingSubTable) {
                for (int i = 0; i < listTableName.size(); ++i) {
                    strSql.delete(0, strSql.length());
                    strSql = strSql.append("Delete From " + listTableName.get(i));
                    strSql = strSql.append(" c where c.FID in (Select b.FID From ").append("T_CSL_ItemData").append(" AS a,").append("T_CSL_ItemDataEntry").append(" AS b where a.FID = b.FItemDataID and a.FreportID ='" + reportID + "')");
                    st.addBatch(strSql.toString());
                }
            }
            strSql.delete(0, strSql.length());
            strSql = strSql.append("Delete From ").append("T_CSL_ItemDataEntry");
            strSql = strSql.append(" b where b.FItemDataID in (Select a.FID as FID From ").append("T_CSL_ItemData").append(" a where a.FreportID ='" + reportID + "')");
            st.addBatch(strSql.toString());
            strSql.delete(0, strSql.length());
            strSql = strSql.append("Delete From ").append("T_CSL_ItemData");
            strSql = strSql.append(" where FReportID ='" + reportID + "'");
            st.addBatch(strSql.toString());
            strSql.delete(0, strSql.length());
            strSql = strSql.append(" DELETE FROM T_CSL_DynaItemDataEntry b").append(" WHERE b.FItemDataID IN (").append("SELECT a.FID as FID FROM T_CSL_DynaItemData a WHERE a.FreportID = '" + reportID + "') ");
            st.addBatch(strSql.toString());
            strSql.delete(0, strSql.length());
            strSql = strSql.append(" DELETE FROM T_CSL_DynaItemData ");
            strSql = strSql.append(" WHERE FreportID = '" + reportID + "' ");
            st.addBatch(strSql.toString());
            strSql.delete(0, strSql.length());
            strSql = strSql.append(" DELETE FROM T_CSL_MultiDynaItemDataEntry b").append(" WHERE b.FItemDataID IN (").append("SELECT a.FID as FID FROM T_CSL_MultiDynaItemData a WHERE a.FreportID = '" + reportID + "') ");
            st.addBatch(strSql.toString());
            strSql.delete(0, strSql.length());
            strSql = strSql.append(" DELETE FROM T_CSL_MultiDynaItemData ");
            strSql = strSql.append(" WHERE FreportID = '" + reportID + "' ");
            st.addBatch(strSql.toString());
            st.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)cn);
    }

    private void updateItemData(Context ctx, String entryID, Map itemData, boolean isInsert, Statement st) throws BOSException, EASBizException {
        block21: {
            IItemFieldMapped itemFieldMapped = ItemFieldMappedFactory.getLocalInstance(ctx);
            if (StringUtils.isEmpty((String)entryID)) {
                throw new BOSException("Code error: entryID is empty!");
            }
            if (itemData == null || itemData.isEmpty()) {
                throw new BOSException("Code error: itemData is empty!");
            }
            Map hmMappingData = itemFieldMapped.getHiberMapInfoByItemNumbers(new ArrayList(itemData.keySet()));
            try {
                if (hmMappingData != null) {
                    Set setTableName = hmMappingData.keySet();
                    ArrayList<AdjustException> exList = new ArrayList<AdjustException>();
                    boolean hasExs = false;
                    StringBuffer strInsertSql = null;
                    StringBuffer strValuesSql = null;
                    Iterator iterTableName = setTableName.iterator();
                    while (iterTableName.hasNext()) {
                        hasExs = false;
                        strInsertSql = new StringBuffer();
                        strValuesSql = new StringBuffer();
                        String strTableName = iterTableName.next().toString();
                        if (isInsert) {
                            strInsertSql.append("Insert into ").append(strTableName).append("(FID");
                        } else {
                            strInsertSql.append("Update ").append(strTableName).append("set(");
                        }
                        TreeMap hmTemp = (TreeMap)hmMappingData.get(strTableName);
                        Set setFieldName = hmTemp.keySet();
                        for (String strItemNumber : setFieldName) {
                            if (strItemNumber != null) {
                                strItemNumber = strItemNumber.trim();
                            }
                            if (strInsertSql.length() > 0) {
                                strInsertSql = strInsertSql.append(",");
                                strValuesSql = strValuesSql.append(",");
                            }
                            Object value = itemData.get(strItemNumber);
                            strInsertSql = strInsertSql.append(hmTemp.get(strItemNumber).toString());
                            if (value == null) {
                                strValuesSql = strValuesSql.append("null");
                                continue;
                            }
                            if (value instanceof BigDecimal) {
                                String v = Util.bigDecimalToPlainString((BigDecimal)((BigDecimal)value).setScale(6, 4));
                                CslRptUtil.checkBigDecimalLength(new BigDecimal(v));
                                strValuesSql = strValuesSql.append(v);
                                continue;
                            }
                            if (value instanceof Number) {
                                strValuesSql = strValuesSql.append(((Number)value).toString());
                                continue;
                            }
                            if (value instanceof String) {
                                try {
                                    strValuesSql = strValuesSql.append(new BigDecimal((String)value).setScale(6, 4).toString());
                                }
                                catch (NumberFormatException e) {
                                    hasExs = true;
                                    exList.add(new AdjustException(AdjustException.CELLVALUETYPEINVALID, new Object[]{strItemNumber, value}));
                                }
                                continue;
                            }
                            hasExs = true;
                            exList.add(new AdjustException(AdjustException.CELLVALUETYPEINVALID, new Object[]{strItemNumber, value}));
                        }
                        if (isInsert) {
                            strInsertSql.append(") Values('").append(entryID).append("'").append(strValuesSql).append(")");
                        } else {
                            strInsertSql.append(")=(").append(strValuesSql).append(") where FID = ").append(entryID);
                        }
                        if (hasExs) continue;
                        st.addBatch(strInsertSql.toString());
                    }
                    if (exList.size() > 0) {
                        StringBuffer exBuffer = new StringBuffer();
                        for (int i = 0; i < exList.size(); ++i) {
                            EASBizException numEx = (EASBizException)((Object)exList.get(i));
                            exBuffer.append(numEx.getMessage());
                            exBuffer.append("\r\n");
                        }
                        throw new AdjustException(AdjustException.CELLVALUETYPEINVALIDALL, new Object[]{exBuffer.toString()});
                    }
                    break block21;
                }
                throw new BOSException("Code error: not found item and field mapping!");
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
    }

    private String getInterTableName(CSLReportGroupEnum rptGroupEnum) {
        return rptGroupEnum == CSLReportGroupEnum.ELIMINATION ? "T_CSL_InterItemData" : "T_CSL_ExchItemData";
    }

    private void delete_InterItemData(Context ctx, String rptId, CSLReportGroupEnum rptGroupEnum) throws BOSException {
        ArrayList<String> deleteParas = new ArrayList<String>();
        deleteParas.add(rptId);
        StringBuffer sql_del = new StringBuffer();
        sql_del.append("delete from ").append(this.getInterTableName(rptGroupEnum)).append(" where ");
        sql_del.append(" FReport = ? ");
        DbUtil.execute((Context)ctx, (String)sql_del.toString(), (Object[])deleteParas.toArray());
    }

    private void insertInterData(Context ctx, String rptId, String key, String value, CSLReportGroupEnum rptGroupEnum) throws BOSException, EASBizException {
        String[] strarr = key.split(",");
        if (strarr.length < 9) {
            throw new BOSException("parameter error: key values' length < 9 !");
        }
        String strid = Uuid.create().toString();
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("insert into ").append(this.getInterTableName(rptGroupEnum)).append(" (");
        sqlBuffer.append("FId,");
        sqlBuffer.append("FItemNumber,");
        if (!StringUtils.isEmpty((String)strarr[1])) {
            sqlBuffer.append("FOrgBoundId,");
        }
        sqlBuffer.append("FTargetCompanyId,");
        sqlBuffer.append("FCompanyId,");
        sqlBuffer.append("FCurrencyId,");
        sqlBuffer.append("FTargetCurrencyId,");
        sqlBuffer.append("FYear,");
        sqlBuffer.append("FPeriod,");
        sqlBuffer.append("FPeriodType,");
        sqlBuffer.append("FDay, ");
        sqlBuffer.append(" FDataElement, ");
        sqlBuffer.append("FReport, ");
        sqlBuffer.append("FMoney");
        if (value != null && !value.split(",")[1].equals("null")) {
            sqlBuffer.append(",FItemPostil");
        }
        sqlBuffer.append(",FDataCollectNumber");
        sqlBuffer.append(")");
        sqlBuffer.append(" values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?");
        if (!StringUtils.isEmpty((String)strarr[1])) {
            sqlBuffer.append(",?");
        }
        sqlBuffer.append(",?");
        if (value != null && !value.split(",")[1].equals("null")) {
            sqlBuffer.append(",?");
        }
        sqlBuffer.append(",?");
        sqlBuffer.append(")");
        ArrayList<Object> listParams = new ArrayList<Object>();
        listParams.add(strid);
        listParams.add(strarr[0]);
        if (!StringUtils.isEmpty((String)strarr[1])) {
            listParams.add(strarr[1]);
        }
        listParams.add(strarr[2]);
        listParams.add(strarr[3]);
        listParams.add(strarr[4]);
        listParams.add(strarr[5]);
        listParams.add(new Integer(strarr[6]));
        listParams.add(new Integer(strarr[7]));
        listParams.add(new Integer(strarr[8]));
        Timestamp timeStamp = new Timestamp(new Long(strarr[9]));
        listParams.add(timeStamp);
        listParams.add(new Integer(DataElementProvider.getDataElementInnerValue(ctx, strarr[10])));
        listParams.add(rptId);
        try {
            BigDecimal money = new BigDecimal(value.split(",")[0]).setScale(6, 4);
            CslRptUtil.checkBigDecimalLength(money);
            listParams.add(money.toString());
        }
        catch (RuntimeException e) {
            listParams.add(value == null || value.split(",")[0].equals("null") ? "0" : value.split(",")[0]);
        }
        if (value != null && !value.split(",")[1].equals("null")) {
            listParams.add(value.split(",")[1]);
        }
        listParams.add(strarr[11]);
        DbUtil.execute((Context)ctx, (String)sqlBuffer.toString(), (Object[])listParams.toArray());
    }

    private void reSet_ItemDataByNull(Context ctx, String reportId) throws BOSException, EASBizException {
    }

    private void reSet_ItemDataByReport(Context ctx, String reportId) throws BOSException, EASBizException {
    }

    private String getSelectClause(Map items, ItemDataCondition condition) {
        StringBuffer sbSelect = new StringBuffer();
        sbSelect.append("Select ");
        for (String tabName : items.keySet()) {
            TreeMap item = (TreeMap)items.get(tabName);
            for (String itemNo : item.keySet()) {
                String field = (String)item.get(itemNo);
                sbSelect.append(" sum(").append(tabName).append('.').append(field).append(") as \"").append(itemNo).append("\",\n ");
            }
        }
        if (!condition.getIsAdjusted()) {
            if (sbSelect.lastIndexOf(",") != -1) {
                sbSelect.deleteCharAt(sbSelect.lastIndexOf(","));
            }
        } else {
            sbSelect.append(" company.fnumber AS CompanyNumber, ItemDataBd.fisadjusted AS IsAdjusted ");
        }
        return sbSelect.toString();
    }

    private String getSelectClause4Items(String tabName, TreeMap items) {
        StringBuffer sbSelect = new StringBuffer();
        sbSelect.append("Select ");
        for (String itemNo : items.keySet()) {
            String field = (String)items.get(itemNo);
            sbSelect.append(" sum(").append(tabName.trim()).append('.').append(field.trim()).append(") as \"").append(itemNo.trim()).append("\",\r\n\t\t\t ");
        }
        if (sbSelect.lastIndexOf(",") != -1) {
            sbSelect.deleteCharAt(sbSelect.lastIndexOf(","));
        }
        return sbSelect.toString();
    }

    private String getFromClause4Items(String tabName, ItemDataCondition condition, boolean isadjusted) {
        boolean isIncludeOrgTree;
        StringBuffer sbFrom = new StringBuffer();
        sbFrom.append("\r\n\n from  ").append("T_CSL_ItemDataEntry").append(" ").append("ItemDataBd");
        sbFrom.append("\n Inner join T_Org_BaseUnit orgUnit on orgUnit.FID = ").append("ItemDataBd").append(".FCompanyID ");
        boolean bl = isIncludeOrgTree = !StringUtils.isEmpty((String)condition.getOrgTreeId()) || !StringUtils.isEmpty((String)condition.getOrgTreeId2()) || !StringUtils.isEmpty((String)condition.getOrgTreeNumber());
        if (isIncludeOrgTree) {
            sbFrom.append("\n Inner join T_Csl_RptReceived Received on Received.FReportID = ItemDataBd.FReportID");
            sbFrom.append("\n inner join t_org_tree tree on received.FOrgTreeId = tree.FId");
        }
        if (condition.getIsAdjusted() && condition.isAdjustSeparate() && isadjusted) {
            sbFrom.append("\n inner join T_Csl_CSLREPORT report on ");
            if (isIncludeOrgTree) {
                sbFrom.append(" Received.FReportID = report.FID and Received.FORGTREEID = report.FORGTREEID ");
            } else {
                sbFrom.append(" ItemDataBd.FReportID = report.FID ");
            }
        } else if (condition.isIncludeSendBackedReport()) {
            sbFrom.append("\n left join T_Csl_CSLREPORT report on ItemDataBd.FReportID = report.FID ");
        }
        sbFrom.append(" left outer join ").append(tabName).append(" on ").append("ItemDataBd").append(".fid = ").append(tabName).append(".fid  \r\n\t\t");
        sbFrom.append(CslRptUtil.getRptAddPerportySql(condition.getRptVersionNumber(), null, true));
        return sbFrom.toString();
    }

    private String getWhereClause4Items(ItemDataCondition condition) {
        StringBuffer sbWhere = new StringBuffer();
        sbWhere.append("\r\n where 1=1 ");
        if (!StringUtils.isEmpty((String)condition.getOrgTreeId()) || !StringUtils.isEmpty((String)condition.getOrgTreeId2())) {
            String orgTreeId = !StringUtils.isEmpty((String)condition.getOrgTreeId()) ? condition.getOrgTreeId().trim() : condition.getOrgTreeId2().trim();
            sbWhere.append("And Received.FOrgTreeID");
            sbWhere.append(" = '").append(orgTreeId).append("'");
        } else if (!StringUtils.isEmpty((String)condition.getOrgTreeNumber())) {
            sbWhere.append(" and ");
            if (condition.getBaseOrgTreeId() != null) {
                sbWhere.append(" (");
            }
            sbWhere.append(" tree.FNumber = '").append(condition.getOrgTreeNumber()).append("'");
            if (condition.getBaseOrgTreeId() != null) {
                sbWhere.append(" or tree.FNumber = '").append(condition.getBaseOrgTreeId()).append("' and fisadjusted=1 )");
            }
        }
        String orgUnitString = CSLServerHelper.getOrStringByList(condition.getOrgUnitNumber(), "orgUnit", "FNumber");
        if (orgUnitString != null) {
            sbWhere.append("\n\t\t and ").append(orgUnitString).append("\t\n\t\t");
        } else if (condition.getOrgUnit() != null && condition.getOrgUnit().size() > 0) {
            sbWhere.append("\n\t\t and orgUnit.FID IN(").append(condition.getOrgIdTmpTblSQL()).append(")");
        }
        if (condition.getCurrency() != null) {
            sbWhere.append("\n\t\t and ").append("ItemDataBd").append(".").append("FCurrencyID").append(" = '").append(condition.getCurrency().trim()).append("'");
        }
        if (condition.getTargetCurrency() != null) {
            sbWhere.append("\n\t\t and ").append("ItemDataBd").append(".").append("FTargetCurrencyID").append(" = '").append(condition.getTargetCurrency().trim()).append("'");
        }
        if (condition.getRptPeriodType() != -1) {
            sbWhere.append("\n\t\t and ").append("ItemDataBd").append(".").append("FPeriodType").append(" = ").append(condition.getRptPeriodType());
        }
        sbWhere.append("\n\t\t and ").append("ItemDataBd").append(".").append("FYear").append(" = ").append(condition.getRptYearStart()).append("\n\t\t and ").append("ItemDataBd").append(".").append("FPeriod").append(" = ").append(condition.getRptPeriodStart());
        if (condition.getDataElement() != -1) {
            sbWhere.append("\n\t\t and ").append("ItemDataBd").append(".").append("FDataElement").append(" = ").append(condition.getDataElement());
        }
        if (condition.getValueType() != -1) {
            sbWhere.append("\n\t\t and ").append("ItemDataBd").append(".").append("FValueType").append(" = ").append(condition.getValueType());
        }
        if (!condition.isSupportGroupReport() && condition.getDataSource() == -1 && condition.getSources() != null) {
            int[] datasource = condition.getSources();
            StringBuffer source_fastmerge = new StringBuffer();
            StringBuffer source_adjust = new StringBuffer();
            boolean exist_fastmerge = false;
            boolean exist_adjust = false;
            boolean exist_other = false;
            source_fastmerge.append("ItemDataBd").append(".").append("FDataSource").append(" in (");
            source_adjust.append("ItemDataBd").append(".").append("FDataSource").append(" in (");
            StringBuffer source_other = new StringBuffer();
            source_other.append("(").append("ItemDataBd").append(".").append("FDataSource").append(" in (");
            for (int i = 0; i < condition.getSources().length; ++i) {
                if (datasource[i] == 31 || datasource[i] == 32 || datasource[i] == 33 || datasource[i] == 34 || datasource[i] == 35) {
                    exist_fastmerge = true;
                    source_fastmerge.append(datasource[i]).append(",");
                    if (datasource[i] == 31) {
                        exist_adjust = true;
                        source_adjust.append(2).append(",");
                        continue;
                    }
                    if (datasource[i] != 34) continue;
                    exist_adjust = true;
                    source_adjust.append(3).append(",");
                    continue;
                }
                exist_other = true;
                source_other.append(datasource[i]).append(",");
            }
            if (exist_fastmerge) {
                source_fastmerge.deleteCharAt(source_fastmerge.lastIndexOf(","));
                source_fastmerge.append(") and ").append("ItemDataBd").append(".FfastMergeSoluid").append(" = '").append(condition.getFastMergeSoluId()).append("'");
                sbWhere.append("\n\t\t and ((").append(source_fastmerge).append(")");
                if (exist_other) {
                    source_other.deleteCharAt(source_other.lastIndexOf(","));
                    source_other.append(")");
                    if (exist_adjust) {
                        source_adjust.deleteCharAt(source_adjust.lastIndexOf(","));
                        source_adjust.append(")");
                        source_other.append(" or (");
                        source_other.append(source_adjust);
                        source_other.append(" and ItemDataBd.Fisadjusted = 1");
                        source_other.append(")");
                    }
                    source_other.append(")");
                    if (condition.getCommitStatus() != -1) {
                        source_other.append(" and ").append("ItemDataBd").append(".").append("FCommitStatus").append(" = ").append(condition.getCommitStatus()).append(" \r\n");
                    }
                    sbWhere.append("\n\t\t or (").append(source_other).append(")");
                }
                sbWhere.append(")");
            } else {
                if (condition.getDataSourceString() != null) {
                    sbWhere.append("\n\t\t AND ").append(condition.getDataSourceString()).append(" \r\n");
                }
                if (condition.getCommitStatus() != -1) {
                    if (condition.isIncludeSendBackedReport()) {
                        sbWhere.append("\n\t\t and (").append("ItemDataBd").append(".").append("FCommitStatus").append(" = ").append(condition.getCommitStatus()).append(" or report.FReceiveStatus = ").append(1).append(") \r\n");
                    } else if (condition.getDataSource() != 4) {
                        sbWhere.append("\n\t\t and ").append("ItemDataBd").append(".").append("FCommitStatus").append(" = ").append(condition.getCommitStatus()).append(" \r\n");
                    }
                }
            }
        } else {
            if (condition.getDataSource() != -1) {
                if (condition.getDataSource() == 1 || condition.getDataSource() == 7) {
                    sbWhere.append("\n\t\t and ").append("ItemDataBd").append(".").append("FDataSource").append(" IN (").append(1).append(",").append(7).append(") ");
                } else {
                    sbWhere.append("\n\t\t and ").append("ItemDataBd").append(".").append("FDataSource").append(" = ").append(condition.getDataSource());
                }
            } else if (condition.getDataSourceString() != null) {
                sbWhere.append("\n\t\t AND ").append(condition.getDataSourceString()).append(" \r\n");
            }
            if (condition.getCommitStatus() != -1) {
                if (condition.isIncludeSendBackedReport()) {
                    sbWhere.append("\n\t\t and (").append("ItemDataBd").append(".").append("FCommitStatus").append(" = ").append(condition.getCommitStatus()).append(" or report.FReceiveStatus = ").append(1).append(") \r\n");
                } else if (condition.getDataSource() != 4) {
                    sbWhere.append("\n\t\t and ").append("ItemDataBd").append(".").append("FCommitStatus").append(" = ").append(condition.getCommitStatus()).append(" \r\n");
                }
            }
            if (!StringUtils.isEmpty((String)condition.getFastMergeSoluId()) && condition.getDataSource() == 34 && !condition.isSupportGroupReport()) {
                sbWhere.append(" and ").append("ItemDataBd");
                sbWhere.append(".FfastMergeSoluid='").append(condition.getFastMergeSoluId()).append("'\r\n");
            }
        }
        if (condition.isAdjustData()) {
            sbWhere.append(" and ItemDataBd.Fisadjusted = 1 ");
        } else if (!condition.getIsAdjusted()) {
            sbWhere.append(" and ItemDataBd.Fisadjusted = 0 ");
        }
        String dataCollectNumber = condition.getDataCollectNumber();
        if (dataCollectNumber != null && dataCollectNumber.length() != 0) {
            sbWhere.append(" and ItemDataBd.FdataCollectNumber = '").append(dataCollectNumber).append("' ");
        }
        sbWhere.append(CslRptUtil.getRptAddPerportySql(condition.getRptVersionNumber(), null, false));
        return sbWhere.toString();
    }

    @Override
    public Map _getItemDataFromAdjust(Context ctx, String orgTree, String orgUnit, String currency, int sourceType, IObjectValue model, String dataCollectNumber) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        ArrayList<Object> params = new ArrayList<Object>();
        sql.append(" select c.fnumber,b.fdataelement,a.fvaluetype,a.fyear,a.fperiod,b.fdebit,b.fcredit");
        sql.append(" from t_csl_adjust a inner join t_csl_adjustentry b ");
        sql.append(" on a.fid = b.fadjustid inner join t_csl_rptitem c on b.fitemid = c.fid where a.FCheckedStatus = ");
        sql.append(2);
        sql.append(" and fOrgBoundID = ? ");
        params.add(orgTree);
        sql.append(" and a.FOrgUnit = ? ");
        params.add(orgUnit);
        sql.append(" and a.FCurrencyId = ? ");
        params.add(currency);
        sql.append(" and a.FDataCollectNumber = ? ");
        params.add(dataCollectNumber);
        sql.append(" and a.FDataSource = ? ");
        params.add(new Integer(sourceType));
        sql.append(" and a.FSourceCurrencyId = a.FCurrencyId");
        HashMap<String, BigDecimal> midMap = new HashMap<String, BigDecimal>();
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        try {
            while (rowSet.next()) {
                BigDecimal newData;
                Object valueOld;
                String itemNumber = rowSet.getString("fnumber");
                int year = rowSet.getInt("fyear");
                int period = rowSet.getInt("fperiod");
                int dataElement = rowSet.getInt("fdataElement");
                int valueType = rowSet.getInt("fvalueType");
                BigDecimal debit = rowSet.getBigDecimal("fdebit");
                BigDecimal credit = rowSet.getBigDecimal("fcredit");
                StringBuffer oql = new StringBuffer();
                oql.append(" select dc where number = '");
                oql.append(itemNumber);
                oql.append("'");
                RPTItemInfo info = RPTItemFactory.getLocalInstance(ctx).getRPTItemInfo(oql.toString());
                DebitOrCreditEnum dc = info.getDc();
                itemNumber = itemNumber.toUpperCase();
                if (dc.getValue() == 1) {
                    valueOld = midMap.get(itemNumber + "-" + year + "-" + period + "-" + dataElement + "-" + valueType);
                    if (debit != null) {
                        if (valueOld != null) {
                            newData = ((BigDecimal)valueOld).add(debit);
                            midMap.put(itemNumber + "-" + year + "-" + period + "-" + dataElement + "-" + valueType, newData);
                            continue;
                        }
                        midMap.put(itemNumber + "-" + year + "-" + period + "-" + dataElement + "-" + valueType, debit);
                        continue;
                    }
                    if (credit == null) continue;
                    credit = credit.negate();
                    if (valueOld != null) {
                        newData = ((BigDecimal)valueOld).add(credit);
                        midMap.put(itemNumber + "-" + year + "-" + period + "-" + dataElement + "-" + valueType, newData);
                        continue;
                    }
                    midMap.put(itemNumber + "-" + year + "-" + period + "-" + dataElement + "-" + valueType, credit);
                    continue;
                }
                if (dc.getValue() != 0) continue;
                valueOld = midMap.get(itemNumber + "-" + year + "-" + period + "-" + dataElement + "-" + valueType);
                if (debit != null) {
                    debit = debit.negate();
                    if (valueOld != null) {
                        newData = ((BigDecimal)valueOld).add(debit);
                        midMap.put(itemNumber + "-" + year + "-" + period + "-" + dataElement + "-" + valueType, newData);
                        continue;
                    }
                    midMap.put(itemNumber + "-" + year + "-" + period + "-" + dataElement + "-" + valueType, debit);
                    continue;
                }
                if (credit == null) continue;
                if (valueOld != null) {
                    newData = ((BigDecimal)valueOld).add(credit);
                    midMap.put(itemNumber + "-" + year + "-" + period + "-" + dataElement + "-" + valueType, newData);
                    continue;
                }
                midMap.put(itemNumber + "-" + year + "-" + period + "-" + dataElement + "-" + valueType, credit);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return midMap;
    }

    @Override
    public Map _getItemDataByReportID(Context ctx, String reportID) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> mapResult = null;
        IItemFieldMapped itemFieldMapped = ItemFieldMappedFactory.getLocalInstance(ctx);
        Map hmMappingData = itemFieldMapped.getHiberMapInfoByReportID(reportID);
        if (hmMappingData != null && hmMappingData.size() > 0) {
            Set setTableName = hmMappingData.keySet();
            StringBuffer strSql = null;
            ArrayList<String> lstParams = null;
            IRowSet rowSet = null;
            Iterator iterTableName = setTableName.iterator();
            while (iterTableName.hasNext()) {
                lstParams = new ArrayList<String>();
                strSql = new StringBuffer();
                strSql.append("Select ").append("T_CSL_ItemDataEntry").append(".FYear,").append("T_CSL_ItemDataEntry").append(".FPeriod,");
                strSql.append("T_CSL_ItemDataEntry").append(".FDataElement DataElement,");
                strSql.append("T_CSL_ItemDataEntry").append(".FValueType ValueType, ");
                strSql.append(CslRptUtil.getItemDataSqlForSelect(hmMappingData, iterTableName.next().toString()));
                strSql.append(" Inner Join ");
                strSql.append("T_CSL_ItemData");
                strSql.append(" on ");
                strSql.append("T_CSL_ItemData.FID = T_CSL_ItemDataEntry.FItemDataID ");
                strSql.append("and T_CSL_ItemData.FReportID = ?");
                lstParams.add(reportID);
                rowSet = DbUtil.executeQuery((Context)ctx, (String)strSql.toString(), (Object[])lstParams.toArray());
                try {
                    while (rowSet.next()) {
                        if (mapResult == null) {
                            mapResult = new HashMap<String, BigDecimal>();
                        }
                        int iDataElement = rowSet.getInt("DataElement");
                        int iValueType = rowSet.getInt("ValueType");
                        int iYear = rowSet.getInt("FYear");
                        int iPeriod = rowSet.getInt("FPeriod");
                        ResultSetMetaData metaData = rowSet.getMetaData();
                        for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                            String strColName = metaData.getColumnName(i);
                            BigDecimal bdData = rowSet.getBigDecimal(strColName);
                            mapResult.put(strColName.toUpperCase() + "-" + iYear + "-" + iPeriod + "-" + iDataElement + "-" + iValueType, bdData);
                        }
                    }
                }
                catch (SQLException e) {
                    throw new SQLDataException(e);
                }
            }
        }
        return mapResult;
    }

    @Override
    protected Map _getDynaItemDataByReportID(Context ctx, String reportId) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> mapResult = new HashMap<String, BigDecimal>();
        StringBuffer strSql = null;
        strSql = new StringBuffer();
        CslReportInfo reportInfo = CslReportFactory.getLocalInstance(ctx).getCslReportInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)reportId)));
        if (reportInfo != null) {
            RptSrcTypeEnum sorceType = reportInfo.getSourceType();
            if (sorceType == RptSrcTypeEnum.MULTIDYNAMICNORMALREPORT || sorceType == RptSrcTypeEnum.MULTIDYNAMICSUMREPORT) {
                strSql.append("Select e.FItemID, e.FKeyNumber, d.FYear, d.FPeriod,");
                strSql.append(" e.FDataElement, e.FValueType, e.FValue ");
                strSql.append(" from T_Csl_MultiDynaItemData d join T_Csl_MultiDynaItemDataEntry e");
                strSql.append(" on d.FId = e.FItemDataId");
                strSql.append(" where d.FReportID = ?");
            } else {
                strSql.append("Select e.FItemID, e.FKeyNumber, e.FYear, e.FPeriod,");
                strSql.append(" e.FDataElement, e.FValueType, e.FValue ");
                strSql.append(" from T_Csl_DynaItemData d join T_Csl_DynaItemDataEntry e");
                strSql.append(" on d.FId = e.FItemDataId");
                strSql.append(" where d.FReportID = ?");
            }
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)strSql.toString(), (Object[])new Object[]{reportId});
        try {
            while (rowSet.next()) {
                String itemNumber = rowSet.getString("FItemId");
                String keyNumber = rowSet.getString("FKeyNumber");
                int iDataElement = rowSet.getInt("FDataElement");
                int iValueType = rowSet.getInt("FValueType");
                int iYear = rowSet.getInt("FYear");
                int iPeriod = rowSet.getInt("FPeriod");
                BigDecimal bdData = rowSet.getBigDecimal("FValue");
                mapResult.put(itemNumber.toUpperCase() + "-" + keyNumber + "-" + iYear + "-" + iPeriod + "-" + iDataElement + "-" + iValueType, bdData);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return mapResult;
    }

    @Override
    protected void _saveDynaItemData(Context ctx, String reportId, Map map) throws BOSException, EASBizException {
        Map itemData = (Map)map.get("itemData");
        int valueType = (Integer)map.get("valueType");
        int dynaType = (Integer)map.get("dynaType");
        ArrayList sheetIds = null;
        if (map.containsKey("sheetIds")) {
            sheetIds = (ArrayList)map.get("sheetIds");
        }
        this.saveData(ctx, reportId, itemData, valueType, dynaType, sheetIds);
    }

    @Override
    protected void _saveDynaItemData(Context ctx, String reportId, Map itemData, int valueType) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)reportId));
        if (CslReportFactory.getLocalInstance(ctx).exists((IObjectPK)pk)) {
            CslReportInfo reportInfo = CslReportFactory.getLocalInstance(ctx).getCslReportInfo((IObjectPK)pk);
            if (reportInfo != null) {
                RptSrcTypeEnum sorceType = reportInfo.getSourceType();
                if (sorceType == RptSrcTypeEnum.MULTIDYNAMICNORMALREPORT || sorceType == RptSrcTypeEnum.MULTIDYNAMICSUMREPORT || sorceType == RptSrcTypeEnum.MULTIDYNAMICCSLREPORT || sorceType == RptSrcTypeEnum.MULTIDYNAMICCSLELIMREPORT) {
                    this.saveMultiDynaData(ctx, reportId, itemData, valueType, reportInfo.getDynaRptType().getValue(), sorceType);
                } else if (!itemData.isEmpty()) {
                    this.saveData(ctx, reportId, itemData, valueType, 1, null);
                }
            }
        } else if (!itemData.isEmpty()) {
            this.saveData(ctx, reportId, itemData, valueType, 1, null);
        }
    }

    protected void saveData(Context ctx, String reportId, Map itemData, int valueType, int dynaType, ArrayList sheetIds) throws BOSException, EASBizException {
        Statement statement;
        if (StringUtils.isEmpty((String)reportId)) {
            throw new ItemDataProviderException(ItemDataProviderException.REPORTIDEMPTY);
        }
        boolean isSingeSheetCal = false;
        StringBuffer ids = new StringBuffer();
        if (sheetIds != null && sheetIds.size() > 0) {
            isSingeSheetCal = true;
            for (int i = 0; i < sheetIds.size(); ++i) {
                if (i != 0) {
                    ids.append(",");
                }
                ids.append("'").append(sheetIds.get(i)).append("'");
            }
        }
        CslStatement st = null;
        CslPreparedStatement ps = null;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer();
        Connection cn = super.getConnection(ctx);
        try {
            st = CslStatement.createStatement((Connection)cn);
            sql.delete(0, sql.length());
            sql = sql.append(" DELETE FROM T_CSL_DynaItemDataEntry ").append(" WHERE FItemDataID IN (").append("SELECT FID FROM T_CSL_DynaItemData WHERE FreportID = '" + reportId + "' and FdynaType=" + dynaType + ")");
            if (isSingeSheetCal && ids.length() > 0) {
                sql.append(" and fsheetid in(").append(ids).append(")");
            }
            st.addBatch(sql.toString());
            if (!isSingeSheetCal) {
                sql.delete(0, sql.length());
                sql = sql.append(" DELETE FROM T_CSL_DynaItemData ");
                sql = sql.append(" WHERE FreportID = '" + reportId + "' and FdynaType=" + dynaType);
                st.addBatch(sql.toString());
            }
            st.executeBatch();
            BOSObjectType bosTypeMain = new DynaItemDataInfo().getBOSType();
            BOSObjectType bosTypeEntry = new DynaItemDataEntryInfo().getBOSType();
            String itemDataID = BOSUuid.create((BOSObjectType)bosTypeMain).toString();
            boolean isExistsDynaitemdata = true;
            if (isSingeSheetCal) {
                ResultSet resultSet = st.executeQuery("select fid from T_CSL_DynaItemData where freportid='" + reportId + "' and FdynaType=" + dynaType);
                if (resultSet != null && resultSet.next()) {
                    itemDataID = resultSet.getString("fid");
                } else {
                    isExistsDynaitemdata = false;
                }
            }
            sql.delete(0, sql.length());
            if (!isExistsDynaitemdata || !isSingeSheetCal) {
                sql.append(" INSERT INTO T_CSL_DynaItemData(FID, FOrgUnitID, FCurrencyID, FSourceCurrencyID,    \n");
                sql.append("     FPeriodType, FDataSource, FReportID, FCommitStatus, FControlUnitID, FDataType ,FdynaType, FdataCollectNumber, FFastMergeSoluId,FOrgType \n");
                sql.append(" )   \n");
                if (valueType == 1) {
                    sql.append(" select '").append(itemDataID).append("' AS itemdataId,forgunit,fcurrencyid,fsourcecurrencyid,");
                    sql.append("fperiodtype,fdatasource+9,fid,3,FControlUnitID,").append(valueType).append(",").append(dynaType).append(",FdataCollectNumber").append("\n");
                    sql.append(" ,'',1 from t_csl_adjust where fid = '").append(reportId).append("'");
                } else {
                    sql.append(" SELECT '").append(itemDataID).append("' AS itemdataId, FOrgUnitID, FCurrencyID, FSourceCurrencyID, ");
                    sql.append(" FPeriodType, FSourceType, FID").append("\r\n");
                    if (valueType == 2) {
                        sql.append(",").append(3);
                    } else {
                        sql.append(",FCommittedStatus");
                    }
                    sql.append(", FControlUnitID,").append(valueType).append(",").append(dynaType).append(",FdataCollectNumber").append("\n");
                    sql.append(" ,FFastMergeSoluId,FOrgType FROM T_CSL_CslReport                                                       \n");
                    sql.append(" WHERE FID =  '").append(reportId).append("' ");
                }
                ps = CslPreparedStatement.prepareStatement((Connection)cn, (String)sql.toString());
                ps.execute();
            }
            sql.delete(0, sql.length());
            sql.append(" INSERT INTO T_CSL_DynaItemDataEntry (                              \n");
            sql.append("    FID, FItemDataID, FItemID, FKeyNumber, FKeyName, FDataElement,  \n");
            sql.append("    FValueType, FYear, FPeriod, FValue, FTextValue, FDynaItemType, FRow,FCol,FSheetId,FGradeNumber, FGradeIsleaf \n");
            sql.append("    ,FIsSupportInnerExch) VALUES (                                                         \n");
            sql.append("    ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? ,? ,?,?,?,?,?                \n");
            sql.append(" )                                                                  \n");
            ps = CslPreparedStatement.prepareStatement((Connection)cn, (String)sql.toString());
            int sourceType = -1;
            boolean isDyRptSaveUpdateItem4CM = CSLParamUtil.isDyRptSaveUpdateItem4CM(ctx);
            Set keySet = itemData.keySet();
            for (String key : keySet) {
                HashMap keyMap = CslRptUtil.getKeyMap(key);
                Map mapI = (Map)itemData.get(key);
                Set keySetI = mapI.keySet();
                for (String itemNumber : keySetI) {
                    Map mapD = (Map)mapI.get(itemNumber);
                    Set keySetD = mapD.keySet();
                    for (String dNumber : keySetD) {
                        String grade;
                        if (dNumber == null) continue;
                        ps.setString(1, BOSUuid.create((BOSObjectType)bosTypeEntry).toString());
                        ps.setString(2, itemDataID);
                        ArrayList itemValue = (ArrayList)mapD.get(dNumber);
                        if (isDyRptSaveUpdateItem4CM && itemValue.size() > 6 && !StringUtils.isEmpty((String)(grade = (String)itemValue.get(6)))) {
                            dNumber = dNumber.replaceFirst(grade + "@@", "");
                        }
                        ps.setString(3, itemNumber);
                        ps.setString(4, dNumber);
                        ps.setString(5, (String)itemValue.get(1));
                        ps.setInt(6, Integer.parseInt((String)keyMap.get("DataElement")));
                        ps.setInt(7, Integer.parseInt((String)keyMap.get("ValueType")));
                        ps.setInt(8, Integer.parseInt((String)keyMap.get("Year")));
                        ps.setInt(9, Integer.parseInt((String)keyMap.get("Period")));
                        if (((String)keyMap.get("ValueType")).equals("3")) {
                            if (itemValue.get(0) != null && itemValue.get(0).toString().length() >= 1000) {
                                boolean isException = true;
                                if (dynaType == 1) {
                                    String curSql;
                                    IRowSet rowSet;
                                    if (sourceType == -1 && (rowSet = DbUtil.executeQuery((Context)ctx, (String)(curSql = "select FSourceType from T_CSL_CslReport where fid='" + reportId + "'"))) != null && rowSet.next()) {
                                        sourceType = rowSet.getInt("FSourceType");
                                    }
                                    if (sourceType == 11 || sourceType == 12 || sourceType == 32 || sourceType == 35 || sourceType == 42 || sourceType == 43) {
                                        isException = false;
                                        itemValue.set(0, itemValue.get(0).toString().substring(0, 999));
                                    }
                                }
                                if (isException) {
                                    throw new ReportException(ReportException.DATATOOLONG, new Object[]{(String)itemValue.get(1), DataElementProvider.getDataElementName(ctx, Integer.parseInt((String)keyMap.get("DataElement"))), (String)keyMap.get("Year"), (String)keyMap.get("Period"), "1000"});
                                }
                            }
                            ps.setObject(10, null);
                            ps.setString(11, itemValue.get(0) == null ? null : itemValue.get(0).toString());
                        } else {
                            Number value;
                            if (itemValue.get(0) == null) continue;
                            if (itemValue.get(0) instanceof BigDecimal) {
                                value = ((BigDecimal)itemValue.get(0)).setScale(6, 4);
                                CslRptUtil.checkBigDecimalLength((BigDecimal)value);
                                ps.setObject(10, (Object)Util.bigDecimalToPlainString((BigDecimal)value));
                                ps.setString(11, "");
                            } else if (itemValue.get(0) instanceof Integer) {
                                value = (Integer)itemValue.get(0);
                                ps.setObject(10, (Object)new BigDecimal(((Integer)value).toString()));
                                ps.setString(11, "");
                            } else {
                                sql.delete(0, sql.length());
                                sql.append("select  cr.fname, cm.fnumber,cm.fname_").append(ctx.getLocale().getLanguage()).append(" fcomName FROM T_CSL_CslReport cr join T_ORG_BASEUNIT cm on cr.forgunitid=cm.fid\n");
                                sql.append(" WHERE cr.FID =  '").append(reportId).append("' ");
                                ps = CslPreparedStatement.prepareStatement((Connection)cn, (String)sql.toString());
                                rs = ps.executeQuery();
                                String reportName = "";
                                String comNumber = "";
                                String comName = "";
                                if (rs.next()) {
                                    reportName = rs.getString("fname");
                                    comNumber = rs.getString("fnumber");
                                    comName = rs.getString("fcomName");
                                }
                                throw new AdjustException(AdjustException.FILLVALUE_ERROR, new Object[]{(String)itemValue.get(1), ValueTypeEnum.getEnum(Integer.parseInt((String)keyMap.get("ValueType"))).getAlias(), DataElementProvider.getDataElementName(ctx, Integer.parseInt((String)keyMap.get("DataElement"))), (String)keyMap.get("Year"), (String)keyMap.get("Period"), itemValue.get(0).toString(), comNumber + "-" + comName, reportName, "\n"});
                            }
                        }
                        ps.setInt(12, ((Integer)itemValue.get(2)).intValue());
                        if (valueType != 1 && valueType != 2) {
                            ps.setInt(13, ((Integer)itemValue.get(3)).intValue());
                            ps.setInt(14, ((Integer)itemValue.get(4)).intValue());
                            ps.setString(15, (String)itemValue.get(5));
                        } else {
                            ps.setInt(13, 0);
                            ps.setInt(14, 0);
                            ps.setString(15, null);
                        }
                        if (itemValue.size() > 6) {
                            grade = (String)itemValue.get(6);
                            ps.setString(16, grade);
                        } else {
                            ps.setString(16, null);
                        }
                        if (itemValue.size() > 7) {
                            Boolean isLeaf = (Boolean)itemValue.get(7);
                            if (isLeaf != null) {
                                ps.setInt(17, isLeaf != false ? 1 : 0);
                            } else {
                                ps.setInt(17, 1);
                            }
                        } else {
                            ps.setInt(17, 1);
                        }
                        ps.setInt(18, itemValue.size() > 8 ? (((Boolean)itemValue.get(8)).booleanValue() ? 1 : 0) : 0);
                        ps.addBatch();
                    }
                }
            }
            ps.executeBatch();
            statement = st != null ? st.getStatement() : null;
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup((Statement)(st != null ? st.getStatement() : null));
                SQLUtils.cleanup(rs, (Statement)(ps != null ? ps.getStatement() : null), (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement);
        SQLUtils.cleanup(rs, (Statement)(ps != null ? ps.getStatement() : null), (Connection)cn);
        try {
            DBHandler dao = new DBHandler(ctx);
            CollectItemDefine collect = new CollectItemDefine(dao);
            boolean isHasExtrItem = collect.init(reportId);
            if (isHasExtrItem) {
                collect.addDItem(itemData, "DITEM");
                Collection<IItemQueryUnit> queryUnits = collect.getQueryUnits();
                new KeepSingleItemData(dao).exec(queryUnits, collect.getOrgType());
                collect.clear();
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    @Override
    protected Map _getInterItemDataByReportID(Context ctx, String reportID) throws BOSException, EASBizException {
        String sql = "select FItemNumber, FDATAELEMENT, FTargetCompanyID, FYear, FPeriod, FMoney from t_csl_interItemData where FReport = ?";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{reportID});
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
        try {
            while (rowSet.next()) {
                StringBuffer key = new StringBuffer();
                key.append(rowSet.getString("FItemNumber")).append("-");
                key.append(rowSet.getString("FTargetCompanyID")).append("-");
                key.append(rowSet.getInt("FYear")).append("-");
                key.append(rowSet.getInt("FPeriod")).append("-");
                key.append(rowSet.getString("FDATAELEMENT"));
                BigDecimal value = rowSet.getBigDecimal("FMoney");
                result.put(key.toString(), value);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return result;
    }

    @Override
    protected Map _getExchItemDataByReportID(Context ctx, String reportID) throws BOSException, EASBizException {
        String sql = "select FItemNumber, FTargetCompanyID, FYear, FPeriod, FDataElement, FMoney from t_csl_exchItemData where FReport = ?";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{reportID});
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
        try {
            while (rowSet.next()) {
                StringBuffer key = new StringBuffer();
                key.append(rowSet.getString("FItemNumber")).append("-");
                key.append(rowSet.getString("FTargetCompanyID")).append("-");
                key.append(rowSet.getInt("FYear")).append("-");
                key.append(rowSet.getInt("FPeriod")).append("-");
                key.append(rowSet.getInt("FDataElement"));
                BigDecimal value = rowSet.getBigDecimal("FMoney");
                result.put(key.toString(), value);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return result;
    }

    @Override
    protected Map _getInvestItemDataByReportID(Context ctx, String reportID) throws BOSException, EASBizException {
        String sql = "select FItemNumber, FTargetCompanyID, FYear, FPeriod, FDataElement, FMoney from t_csl_investItemData where FReportId = ?";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{reportID});
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
        try {
            while (rowSet.next()) {
                StringBuffer key = new StringBuffer();
                key.append(rowSet.getString("FItemNumber")).append("-");
                key.append(rowSet.getString("FTargetCompanyID")).append("-");
                key.append(rowSet.getInt("FYear")).append("-");
                key.append(rowSet.getInt("FPeriod")).append("-");
                key.append(rowSet.getInt("FDataElement"));
                BigDecimal value = rowSet.getBigDecimal("FMoney");
                result.put(key.toString(), value);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return result;
    }

    @Override
    protected void _updateAuditedItemData(Context ctx, String adjustId, boolean isCaliAdjust) throws BOSException, EASBizException {
        ArrayList<Object> params = new ArrayList<Object>();
        ArrayList<String> itemNumbers = new ArrayList<String>();
        ArrayList<String> itemDataEntryIds = new ArrayList<String>();
        StringBuffer querySql = new StringBuffer();
        if (isCaliAdjust) {
            querySql.append("select distinct t1.forgunitid,t3.FNumber").append("\r\n");
        } else {
            querySql.append("select distinct t1.forgunit,t3.FNumber").append("\r\n");
        }
        querySql.append(",t1.FSourceCurrencyId,t1.fcurrencyid").append("\r\n");
        querySql.append(",t1.FYear,t1.FPeriod,t1.FPeriodType,t1.FDATACOLLECTNUMBER").append("\r\n");
        querySql.append(",t1.FDataSource,t1.FValueType,t2.FDataElement").append("\r\n");
        if (isCaliAdjust) {
            querySql.append("from t_csl_caliadjust t1").append("\r\n");
            querySql.append("inner join t_csl_caliadjustEntry t2").append("\r\n");
        } else {
            querySql.append("from t_csl_adjust t1").append("\r\n");
            querySql.append("inner join t_csl_adjustEntry t2").append("\r\n");
        }
        querySql.append("on t2.FAdjustID = t1.FID").append("\r\n");
        querySql.append("inner join t_csl_RPTItem t3").append("\r\n");
        querySql.append("on t3.FID = t2.fitemid").append("\r\n");
        querySql.append("where t1.FID = ?").append("\r\n");
        params.add(adjustId);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySql.toString(), (Object[])params.toArray());
        params.clear();
        try {
            while (rs.next()) {
                ArrayList<String> subParams = new ArrayList<String>();
                subParams.add(rs.getString(1));
                if (!itemNumbers.contains(rs.getString(2))) {
                    itemNumbers.add(rs.getString(2));
                }
                subParams.add(rs.getString(4));
                subParams.add(rs.getString(5));
                subParams.add(rs.getString(6));
                subParams.add(rs.getString(7));
                subParams.add(rs.getString(8));
                subParams.add(rs.getString(9));
                subParams.add(rs.getString(10));
                subParams.add(rs.getString(11));
                params.add(subParams);
            }
            querySql.setLength(0);
            querySql.append("select distinct t2.FID as ItemDataEntryID").append("\r\n");
            querySql.append("from t_Csl_Itemdata t1").append("\r\n");
            querySql.append("inner join t_Csl_ItemdataEntry t2").append("\r\n");
            querySql.append("on t2.Fitemdataid=t1.fid").append("\r\n");
            querySql.append("where t1.fcompanyid = ?").append("\r\n");
            querySql.append("and t1.ftargetcurrencyid = ?").append("\r\n");
            querySql.append("and t2.fyear = ?").append("\r\n");
            querySql.append("and t2.fperiod = ?").append("\r\n");
            querySql.append("and t1.fperiodtype = ?").append("\r\n");
            querySql.append("and t1.FDATACOLLECTNUMBER = ?").append("\r\n");
            querySql.append("and t1.fdatasource = ?").append("\r\n");
            querySql.append("and t2.fvaluetype = ?").append("\r\n");
            querySql.append("and t2.fdataelement = ?").append("\r\n");
            if (isCaliAdjust) {
                querySql.append("and t1.fisadjusted = 12 ").append("\r\n");
            } else {
                querySql.append("and t1.fisadjusted in(2,12)").append("\r\n");
            }
            for (List list : params) {
                rs = DbUtil.executeQuery((Context)ctx, (String)querySql.toString(), (Object[])list.toArray());
                while (rs.next()) {
                    if (itemDataEntryIds.contains(rs.getString(1))) continue;
                    itemDataEntryIds.add(rs.getString(1));
                }
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        if (!params.isEmpty() && !itemDataEntryIds.isEmpty()) {
            StringBuffer updateSql = new StringBuffer();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("'").append(itemDataEntryIds.get(0)).append("'");
            for (int i = 1; i < itemDataEntryIds.size(); ++i) {
                stringBuffer.append(",'").append(itemDataEntryIds.get(i)).append("'");
            }
            IItemFieldMapped itemFieldMapped = ItemFieldMappedFactory.getLocalInstance(ctx);
            Map itemFieldMap = itemFieldMapped.getHiberMapInfoByItemNumbers(itemNumbers);
            Connection conn = this.getConnection(ctx);
            Statement stmt = null;
            try {
                stmt = conn.createStatement();
                Set setTableName = itemFieldMap.keySet();
                Iterator iterTableName = setTableName.iterator();
                while (iterTableName.hasNext()) {
                    updateSql.setLength(0);
                    String tableName = iterTableName.next().toString();
                    updateSql.append("update ").append(tableName).append(" set").append("\r\n");
                    Map fieldMap = (Map)itemFieldMap.get(tableName);
                    Set setFieldName = fieldMap.keySet();
                    Iterator iterFieldName = setFieldName.iterator();
                    while (iterFieldName.hasNext()) {
                        updateSql.append(fieldMap.get(iterFieldName.next())).append(" = null,");
                    }
                    updateSql.setLength(updateSql.length() - 1);
                    updateSql.append("\r\n");
                    updateSql.append("where FID in(").append(stringBuffer.toString()).append(")").append("\r\n");
                    stmt.addBatch(updateSql.toString());
                }
                stmt.executeBatch();
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            finally {
                SQLUtils.cleanup((Statement)stmt, (Connection)conn);
            }
        }
        querySql.setLength(0);
        params.clear();
        querySql.append("select distinct t5.FID").append("\r\n");
        if (isCaliAdjust) {
            querySql.append("from t_csl_caliadjust t1").append("\r\n");
            querySql.append("inner join t_csl_caliadjustEntry t2").append("\r\n");
        } else {
            querySql.append("from t_csl_adjust t1").append("\r\n");
            querySql.append("inner join t_csl_adjustEntry t2").append("\r\n");
        }
        querySql.append("on t2.FAdjustID = t1.FID").append("\r\n");
        querySql.append("inner join t_Csl_AdjustDynamicItem t3").append("\r\n");
        querySql.append("on t2.fid = t3.fadjustentryid").append("\r\n");
        querySql.append("inner join T_CSL_RptItem item").append("\r\n");
        querySql.append("on item.fid = t3.FRptItemID").append("\r\n");
        querySql.append("inner join T_CSL_DynaItemData t4").append("\r\n");
        if (isCaliAdjust) {
            querySql.append("on t4.FOrgUnitID = t1.FOrgUnitID").append("\r\n");
        } else {
            querySql.append("on t4.FOrgUnitID = t1.FOrgUnit").append("\r\n");
        }
        querySql.append("and t4.FCurrencyID = t1.FCurrencyID").append("\r\n");
        querySql.append("and t4.FSourceCurrencyId = t1.FSourceCurrencyID").append("\r\n");
        querySql.append("and t4.FPeriodType = t1.FPeriodType").append("\r\n");
        querySql.append("and t4.FDataSource = t1.FDataSource+9").append("\r\n");
        querySql.append("and t4.FDataType = ").append(2).append("\r\n");
        querySql.append("inner join T_CSL_DynaItemDataEntry t5").append("\r\n");
        querySql.append("on t5.FItemDataID = t4.FID").append("\r\n");
        querySql.append("and t5.FYear = t1.FYear").append("\r\n");
        querySql.append("and t5.FPeriod = t1.FPeriod").append("\r\n");
        querySql.append("and t5.FValueType = t1.FValueType").append("\r\n");
        querySql.append("and t5.FDataElement = t2.FDataElement").append("\r\n");
        querySql.append("and t5.FItemID = item.FNumber").append("\r\n");
        querySql.append("and t5.FKeyNumber = t3.FKeyLongNumber").append("\r\n");
        querySql.append(" join t_csl_rptreceived t6 on t1.FOrgBoundID=t6.forgtreeid ").append("\r\n");
        querySql.append(" join t_csl_rptreceived t8 on t8.freportid=t4.freportid").append("\r\n");
        querySql.append(" and t6.forgtreeid=t8.forgtreeid").append("\r\n");
        querySql.append("where t1.FID = ?").append("\r\n");
        params.add(adjustId);
        rs = DbUtil.executeQuery((Context)ctx, (String)querySql.toString(), (Object[])params.toArray());
        StringBuffer ids = new StringBuffer();
        try {
            while (rs.next()) {
                if (ids.length() > 0) {
                    ids.append(",");
                }
                ids.append("'").append(rs.getString(1)).append("'");
            }
            if (ids.length() > 0) {
                String string2 = "delete from T_CSL_DynaItemDataEntry";
                string2 = string2 + " where FID in(" + ids.toString() + ")";
                DbUtil.execute((Context)ctx, (String)string2);
            }
        }
        catch (SQLException sQLException) {
            throw new SQLDataException(sQLException);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
    }

    @Override
    protected BigDecimal _getAdjustingValue(Context ctx, ItemDataCondition condition, boolean isQueryBudget) throws BOSException {
        BigDecimal value = null;
        StringBuffer querySql = new StringBuffer();
        querySql.append("select (isnull(sum(t2.fdebit),0)-isnull(sum(t2.fcredit),0))*(rptItem.fdc*2-1)").append("\r\n");
        if (isQueryBudget) {
            querySql.append(" From T_CSL_HisAdjust t1").append("\r\n");
            querySql.append(" inner join T_CSL_HisAdjustEntry t2").append("\r\n");
        } else {
            querySql.append(" From T_CSL_Adjust t1").append("\r\n");
            querySql.append(" inner join T_CSL_AdjustEntry t2").append("\r\n");
        }
        querySql.append("on t1.FID = t2.fadjustid").append("\r\n");
        querySql.append("inner join T_CSL_RptItem rptItem").append("\r\n");
        querySql.append("on t2.FItemID = rptItem.FID").append("\r\n");
        querySql.append("inner join t_org_tree orgTree ").append("\r\n");
        querySql.append("on orgTree.fid = t1.FOrgBoundID ").append("\r\n");
        querySql.append("inner join t_org_baseunit baseunit ").append("\r\n");
        querySql.append("on baseunit.fid = t1.FOrgUnit ").append("\r\n");
        querySql.append("where t1.FCheckedStatus = ?").append("\r\n");
        querySql.append("and orgTree.fnumber = ?").append("\r\n");
        querySql.append("and baseunit.fnumber = ?").append("\r\n");
        querySql.append("and t1.FSourceCurrencyID = ?").append("\r\n");
        querySql.append("and t1.FCurrencyID = ?").append("\r\n");
        if (condition.getDataSource() != -1) {
            querySql.append("and t1.FDataSource = ?").append("\r\n");
        } else {
            int[] ds = condition.getDataSourceArrary();
            if (ds.length > 0) {
                StringBuffer buf = new StringBuffer();
                boolean isFirst = true;
                for (int i = 0; i < ds.length; ++i) {
                    if (!isFirst) {
                        buf.append(",");
                    }
                    buf.append(ds[i]);
                    isFirst = false;
                }
                querySql.append("and t1.FDataSource in (").append(buf.toString()).append(")\r\n");
            }
        }
        querySql.append("and t1.FValueType = ?").append("\r\n");
        querySql.append("and rptItem.FNumber = ?").append("\r\n");
        querySql.append("and t2.FDataElement = ?").append("\r\n");
        querySql.append(" and t1.FYear >= ? and t1.FYear <= ?\r\n");
        querySql.append(" and t1.FPeriod >= ? and t1.FPeriod <= ?\r\n");
        querySql.append(" and t1.FPeriodType = ?\r\n");
        querySql.append(" and t1.FDataCollectNumber = ?").append("\r\n");
        querySql.append("group by rptItem.fdc").append("\r\n");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(new Integer(2));
        params.add(condition.getOrgTreeNumber());
        params.add(condition.getOrgUnit().get(0));
        params.add(condition.getCurrency());
        params.add(condition.getTargetCurrency());
        if (condition.getDataSource() != -1) {
            params.add(new Integer(condition.getDataSource()));
        }
        params.add(new Integer(condition.getValueType()));
        params.add(condition.getItemNumberStart());
        params.add(new Integer(condition.getDataElement()));
        params.add(new Integer(condition.getRptYearStart()));
        params.add(new Integer(condition.getRptYearEnd()));
        params.add(new Integer(condition.getRptPeriodStart()));
        params.add(new Integer(condition.getRptPeriodEnd()));
        params.add(new Integer(condition.getRptPeriodType()));
        params.add(condition.getDataCollectNumber());
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySql.toString(), (Object[])params.toArray());
        try {
            if (rs.next()) {
                value = rs.getBigDecimal(1);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        if (value == null) {
            value = new BigDecimal(0.0);
        }
        return value;
    }

    @Override
    protected Map _getDynaItemDataFromAdjust(Context ctx, String orgTree, String orgUnit, String currencyId, int sourceType, IObjectValue model, String dataCollectNumber) throws BOSException, EASBizException {
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer sql = new StringBuffer();
        sql.append(" select c.fnumber,ad.FKeyLongNumber,b.fdataelement,a.fvaluetype,a.fyear,a.fperiod,ad.FValue ");
        sql.append(" from t_csl_adjust a inner join t_csl_adjustentry b on a.fid = b.fadjustid");
        sql.append(" inner join t_csl_adjustDynamicItem ad on b.FId = ad.FAdjustEntryID");
        sql.append(" inner join t_csl_rptitem c on ad.frptitemid = c.fid where a.FCheckedStatus = ");
        sql.append(2);
        sql.append(" and fOrgBoundID = ?");
        params.add(orgTree);
        sql.append(" and a.FOrgUnit = ? ");
        params.add(orgUnit);
        sql.append(" and a.FCurrencyId = ? ");
        params.add(currencyId);
        sql.append(" and a.FDataSource = ? ");
        params.add(new Integer(sourceType - 9));
        sql.append(" and a.FSourceCurrencyId = a.FCurrencyId");
        HashMap<String, BigDecimal> midMap = new HashMap<String, BigDecimal>();
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        try {
            while (rowSet.next()) {
                String itemNumber = rowSet.getString("fnumber").toUpperCase();
                String dnumber = rowSet.getString("FKeyLongNumber");
                int year = rowSet.getInt("fyear");
                int period = rowSet.getInt("fperiod");
                int dataElement = rowSet.getInt("fdataElement");
                int valueType = rowSet.getInt("fvalueType");
                BigDecimal value = rowSet.getBigDecimal("FValue");
                Object valueOld = midMap.get(itemNumber + "-" + dnumber + "-" + year + "-" + period + "-" + dataElement + "-" + valueType);
                if (value == null) continue;
                if (valueOld != null) {
                    BigDecimal newData = ((BigDecimal)valueOld).add(value);
                    midMap.put(itemNumber + "-" + dnumber + "-" + year + "-" + period + "-" + dataElement + "-" + valueType, newData);
                    continue;
                }
                midMap.put(itemNumber + "-" + dnumber + "-" + year + "-" + period + "-" + dataElement + "-" + valueType, value);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return midMap;
    }

    @Override
    protected List _getAllLowLevelCompany(Context ctx, Map param) throws BOSException, EASBizException {
        OrgUnitInfo unit = (OrgUnitInfo)param.get("company");
        StringBuffer sql = new StringBuffer();
        sql.append("select flongnumber from T_ORG_Baseunit where fid ='").append(unit.getId().toString()).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String longNumber = null;
        if (rs != null) {
            try {
                if (rs.next()) {
                    longNumber = rs.getString("flongnumber");
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        sql = new StringBuffer();
        sql.append("select fid from T_ORG_Baseunit where flongnumber like ").append("'").append(longNumber).append("%'");
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ArrayList<String> list = new ArrayList<String>();
        if (rs != null) {
            try {
                while (rs.next()) {
                    list.add(rs.getString("fid"));
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return list;
    }

    protected void saveMultiDynaData(Context ctx, String reportId, Map itemData, int valueType, int dynaType, RptSrcTypeEnum srcType) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)reportId)) {
            throw new ItemDataProviderException(ItemDataProviderException.REPORTIDEMPTY);
        }
        Statement st = null;
        PreparedStatement ps = null;
        IRowSet rs = null;
        StringBuffer sql = new StringBuffer();
        Connection cn = super.getConnection(ctx);
        try {
            st = cn.createStatement();
            sql.delete(0, sql.length());
            sql = sql.append(" DELETE FROM T_CSL_MultiDynaItemDataEntry ").append(" WHERE FItemDataID IN (").append("SELECT FID FROM T_CSL_MultiDynaItemData WHERE FreportID = '" + reportId + "' and FdynaType=" + dynaType + ")");
            st.addBatch(sql.toString());
            sql.delete(0, sql.length());
            sql = sql.append(" DELETE FROM T_CSL_MultiDynaItemData ");
            sql = sql.append(" WHERE FreportID = '" + reportId + "' and FdynaType=" + dynaType);
            st.addBatch(sql.toString());
            st.executeBatch();
            if (itemData == null || itemData.size() == 0) {
                return;
            }
            BOSObjectType bosTypeMain = new MultiDynaItemDataInfo().getBOSType();
            BOSObjectType bosTypeEntry = new MultiDynaItemDataEntryInfo().getBOSType();
            String itemDataID = BOSUuid.create((BOSObjectType)bosTypeMain).toString();
            sql.delete(0, sql.length());
            sql.append(" INSERT INTO T_CSL_MultiDynaItemData  \n");
            sql.append("(FID, FOrgUnitID, FCurrencyID, FSourceCurrencyID,FPeriodType, FDataSource, \n");
            sql.append(" FReportID, FCommitStatus, FControlUnitID, FDataType ,FdynaType,FYear,FPeriod )   \n");
            sql.append(" SELECT '").append(itemDataID).append("'AS itemdataId, FOrgUnitID, FCurrencyID, FSourceCurrencyID,FPeriodType, FSourceType, ");
            sql.append(" FID,FCommittedStatus, FControlUnitID,").append("\r\n");
            sql.append(valueType).append(",").append(dynaType).append("\r\n");
            sql.append(",FYear,FPeriod ").append("\n");
            sql.append(" FROM T_CSL_CslReport \n");
            sql.append(" WHERE FID =  '").append(reportId).append("' ");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            MultiDynaItem multiDynaItem = MultiDynaItem.getInstance();
            Set keySet = itemData.keySet();
            Iterator iter = keySet.iterator();
            ArrayList<String[]> tempList = new ArrayList<String[]>();
            ArrayList<String> DItemNumbers = new ArrayList<String>();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                HashMap keyMap = CslRptUtil.getKeyMap(key);
                Map map = (Map)itemData.get(key);
                Set keySetI = map.keySet();
                for (String itemNumber : keySetI) {
                    Map mapD = (Map)map.get(itemNumber);
                    Set keySetD = mapD.keySet();
                    Iterator iterD = keySetD.iterator();
                    while (iterD.hasNext()) {
                        String[] tempData = new String[14];
                        String dNumber = (String)iterD.next();
                        tempData[0] = BOSUuid.create((BOSObjectType)bosTypeEntry).toString();
                        tempData[1] = itemDataID;
                        tempData[2] = itemNumber;
                        tempData[3] = multiDynaItem.reverseDItemNumber(multiDynaItem.parseDItemNumber(dNumber));
                        ArrayList itemValue = (ArrayList)mapD.get(dNumber);
                        tempData[4] = (String)itemValue.get(1);
                        tempData[5] = (String)keyMap.get("DataElement");
                        tempData[6] = (String)keyMap.get("ValueType");
                        if (((String)keyMap.get("ValueType")).equals("3")) {
                            if (itemValue.get(0) != null && itemValue.get(0).toString().length() > 2000) {
                                itemValue.set(0, itemValue.get(0).toString().substring(0, 2000));
                            }
                            tempData[7] = null;
                            tempData[8] = itemValue.get(0) == null ? null : itemValue.get(0).toString();
                        } else {
                            if (itemValue.get(0) == null) continue;
                            if (itemValue.get(0) instanceof BigDecimal) {
                                BigDecimal value = ((BigDecimal)itemValue.get(0)).setScale(6, 4);
                                CslRptUtil.checkBigDecimalLength(value);
                                tempData[7] = Util.bigDecimalToPlainString((BigDecimal)value);
                                tempData[8] = "";
                            } else {
                                sql.delete(0, sql.length());
                                sql.append("select  cr.fname, cm.fnumber,cm.fname_").append(ctx.getLocale().getLanguage()).append(" fcomName FROM T_CSL_CslReport cr join t_org_company cm on cr.forgunitid=cm.fid\n");
                                sql.append(" WHERE cr.FID =  '").append(reportId).append("' ");
                                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                                String reportName = "";
                                String comNumber = "";
                                String comName = "";
                                if (rs.next()) {
                                    reportName = rs.getString("fname");
                                    comNumber = rs.getString("fnumber");
                                    comName = rs.getString("fcomName");
                                }
                                throw new AdjustException(AdjustException.FILLVALUE_ERROR, new Object[]{(String)itemValue.get(1), ValueTypeEnum.getEnum(Integer.parseInt((String)keyMap.get("ValueType"))).getAlias(), DataElementProvider.getDataElementName(ctx, Integer.parseInt((String)keyMap.get("DataElement"))), (String)keyMap.get("Year"), (String)keyMap.get("Period"), itemValue.get(0).toString(), comNumber + "-" + comName, reportName, "\n"});
                            }
                        }
                        tempData[9] = itemValue.get(2).toString();
                        DItemNumbers.add(tempData[3]);
                        tempData[10] = String.valueOf(itemValue.get(3));
                        tempData[11] = String.valueOf(itemValue.get(4));
                        tempData[12] = (String)itemValue.get(5);
                        if (itemValue.size() > 6) {
                            tempData[13] = (String)itemValue.get(6);
                        }
                        tempList.add(tempData);
                    }
                }
            }
            HashMap dItemNumberMap = new HashMap();
            for (Object e : DItemNumbers) {
                dItemNumberMap.put(e, null);
            }
            Map assistanHGIDs = CslRptAssistantHGFactory.getLocalInstance((Context)ctx).getAssistantHGBatch(new ArrayList(dItemNumberMap.keySet()), srcType);
            dItemNumberMap.clear();
            sql.delete(0, sql.length());
            String string = " INSERT INTO T_CSL_MultiDynaItemDataEntry   \n(FID, FItemDataID, FItemID, FKeyNumber, FKeyName, FDataElement,  \nFValueType, FValue, FTextValue, FDynaItemType, FCslRptAssistantHGId,FRow,FCol,FSheetID,FDetailCompanyId )  \nVALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ? ,?, ?, ?, ?,?) \n";
            ps = cn.prepareStatement(string);
            for (int i = 0; i < tempList.size(); ++i) {
                String[] data = (String[])tempList.get(i);
                ps.setString(1, data[0]);
                ps.setString(2, data[1]);
                ps.setString(3, data[2]);
                ps.setString(4, data[3]);
                ps.setString(5, data[4]);
                ps.setInt(6, Integer.valueOf(data[5]));
                ps.setInt(7, Integer.valueOf(data[6]));
                ps.setBigDecimal(8, data[7] != null ? new BigDecimal(data[7]) : null);
                ps.setString(9, data[8]);
                ps.setInt(10, Integer.valueOf(data[9]));
                ps.setString(11, (String)assistanHGIDs.get(data[3]));
                ps.setInt(12, Integer.valueOf(data[10]));
                ps.setInt(13, Integer.valueOf(data[11]));
                ps.setString(14, data[12]);
                ps.setString(15, data[13]);
                ps.addBatch();
            }
            ps.executeBatch();
            SQLUtils.cleanup((Statement)st);
        }
        catch (SQLException e) {
            logger.error((Object)"saveMultiDynaData_SQLException", (Throwable)e);
            throw new SQLDataException(e.getNextException());
        }
        finally {
            SQLUtils.cleanup((Statement)st);
            SQLUtils.cleanup(null, ps, (Connection)cn);
        }
        SQLUtils.cleanup(null, (Statement)ps, (Connection)cn);
    }

    @Override
    protected BigDecimal _getCaliAdjustingValue(Context ctx, ItemDataCondition condition, boolean isQueryBudget) throws BOSException {
        BigDecimal value = null;
        StringBuffer querySql = new StringBuffer();
        querySql.append(" select (isnull(sum(t2.fdebit),0)-isnull(sum(t2.fcredit),0))*(rptItem.fdc*2-1)").append("\r\n");
        if (isQueryBudget) {
            querySql.append(" From T_CSL_HisCaliAdjust t1").append("\r\n");
            querySql.append(" inner join T_CSL_HisCaliAdjustEntry t2").append("\r\n");
        } else {
            querySql.append(" From T_CSL_CaliAdjust t1").append("\r\n");
            querySql.append(" inner join T_CSL_CaliAdjustEntry t2").append("\r\n");
        }
        querySql.append(" on t1.FID = t2.fadjustid").append("\r\n");
        querySql.append(" inner join T_CSL_RptItem rptItem").append("\r\n");
        querySql.append(" on t2.FItemID = rptItem.FID").append("\r\n");
        querySql.append(" where t1.FCheckedStatus = ?").append("\r\n");
        querySql.append(" and t1.FOrgBoundID = ?").append("\r\n");
        querySql.append(" and t1.FOrgUnitID = ?").append("\r\n");
        querySql.append(" and t1.FSourceCurrencyID = ?").append("\r\n");
        querySql.append(" and t1.FCurrencyID = ?").append("\r\n");
        querySql.append(" and t1.FDataSource = ?").append("\r\n");
        querySql.append(" and t1.FValueType = ?").append("\r\n");
        querySql.append(" and rptItem.FNumber = ?").append("\r\n");
        querySql.append(" and t2.FDataElement = ?").append("\r\n");
        querySql.append(" and t1.FYear >= ? and t1.FYear <= ?\r\n");
        querySql.append(" and t1.FPeriod >= ? and t1.FPeriod <= ?\r\n");
        querySql.append(" and t1.FPeriodType = ?\r\n");
        querySql.append(" and t1.FDataCollectNumber = ?").append("\r\n");
        querySql.append("group by rptItem.fdc").append("\r\n");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(new Integer(2));
        params.add(condition.getOrgBoundID());
        params.add(condition.getOrgUnit().get(0));
        params.add(condition.getCurrency());
        params.add(condition.getTargetCurrency());
        params.add(new Integer(condition.getDataSource()));
        params.add(new Integer(condition.getValueType()));
        params.add(condition.getItemNumberStart());
        params.add(new Integer(condition.getDataElement()));
        params.add(new Integer(condition.getRptYearStart()));
        params.add(new Integer(condition.getRptYearEnd()));
        params.add(new Integer(condition.getRptPeriodStart()));
        params.add(new Integer(condition.getRptPeriodEnd()));
        params.add(new Integer(condition.getRptPeriodType()));
        params.add(condition.getDataCollectNumber());
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySql.toString(), (Object[])params.toArray());
        try {
            if (rs.next()) {
                value = rs.getBigDecimal(1);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        if (value == null) {
            value = new BigDecimal(0);
        }
        return value;
    }

    private String getAutoItemSql(TreeMap itemMap, String tabName, ItemDataCondition condition) {
        boolean buildSql;
        StringBuffer sql;
        block3: {
            block4: {
                sql = new StringBuffer();
                buildSql = false;
                if (condition.isSupportGroupReport()) break block3;
                if (condition.getDataSource() == -1) break block4;
                if (condition.getDataSource() != 1 && condition.getDataSource() != 7) break block3;
                buildSql = true;
                break block3;
            }
            if (condition.getSources() != null) {
                int[] datasource = condition.getSources();
                for (int i = 0; i < datasource.length; ++i) {
                    if (datasource[i] != 1 && datasource[i] != 7) continue;
                    buildSql = true;
                    break;
                }
            }
        }
        if (buildSql) {
            sql.append(this.getSelectClause4Items(tabName, itemMap));
            sql.append(",ItemDataBd.FCompanyID as company ");
            sql.append(",tmp.fgroup as tmpgroup ");
            sql.append("\r\n\n from  ").append("T_CSL_ItemDataEntry").append(" ").append("ItemDataBd").append(" left outer join ").append(tabName).append(" on ").append("ItemDataBd").append(".fid = ").append(tabName).append(".fid  \r\n\t\t").append(CslRptUtil.getRptAddPerportySql(condition.getRptVersionNumber(), null, true)).append(" left outer join t_csl_cslreport cslrpt on cslrpt.fid=ItemDataBd.Freportid ").append(" left outer join t_rpt_template tmp on tmp.fid=cslrpt.ftemplateid ");
            sql.append("\r\n\n where  1=1 ").append(this.getAutoItemWhere(condition));
            sql.append(" GROUP BY ItemDataBd.FCompanyID,tmp.fgroup ");
        }
        return sql.toString();
    }

    private String getAutoItemWhere(ItemDataCondition condition) {
        String dataCollectNumber;
        StringBuffer sql = new StringBuffer();
        String compaingsString = CSLServerHelper.getOrStringByList(condition.getOrgUnit(), "ItemDataBd", "FCompanyID");
        if (compaingsString != null) {
            sql.append("\n\t\t and ").append(compaingsString).append("\t\n\t\t");
        }
        if (condition.getRptPeriodType() != -1) {
            sql.append("\n\t\t and ").append("ItemDataBd").append(".").append("FPeriodType").append(" = ").append(condition.getRptPeriodType());
        }
        sql.append("\n\t\t and ").append("ItemDataBd").append(".").append("FYear").append(" = ").append(condition.getRptYearStart()).append("\n\t\t and ").append("ItemDataBd").append(".").append("FPeriod").append(" = ").append(condition.getRptPeriodStart());
        if (condition.getCurrency() != null) {
            sql.append("\n\t\t and ").append("ItemDataBd").append(".").append("FCurrencyID").append(" = '").append(condition.getCurrency().trim()).append("'");
        }
        if (condition.getTargetCurrency() != null) {
            sql.append("\n\t\t and ").append("ItemDataBd").append(".").append("FTargetCurrencyID").append(" = '").append(condition.getTargetCurrency().trim()).append("'");
        }
        if (condition.getDataElement() != -1) {
            sql.append("\n\t\t and ").append("ItemDataBd").append(".").append("FDataElement").append(" = ").append(condition.getDataElement());
        }
        if (condition.getValueType() != -1) {
            sql.append("\n\t\t and ").append("ItemDataBd").append(".").append("FValueType").append(" = ").append(condition.getValueType());
        }
        if ((dataCollectNumber = condition.getDataCollectNumber()) != null && dataCollectNumber.length() != 0) {
            sql.append(" and ItemDataBd.FdataCollectNumber = '").append(dataCollectNumber).append("' ");
        }
        sql.append(CslRptUtil.getRptAddPerportySql(condition.getRptVersionNumber(), null, false));
        sql.append(" and ItemDataBd.FDataSource=100 ");
        if (!StringUtils.isEmpty((String)condition.getAutoItemFormualId())) {
            sql.append(" and ItemDataBd.FFastMergeSoluId='").append(condition.getAutoItemFormualId()).append("'");
        }
        return sql.toString();
    }
}

