/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.app.service.OrgPermissionService;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.ConvertStatusEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectConstant;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectFactory;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectInfo;
import com.kingdee.eas.fi.gr.cslrpt.DebitOrCreditEnum;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.IItemDataYearInit;
import com.kingdee.eas.fi.gr.cslrpt.IRPTItem;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataYearInitCollection;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataYearInitFactory;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataYearInitInfo;
import com.kingdee.eas.fi.gr.cslrpt.MaintainYearInitDataFacadeFactory;
import com.kingdee.eas.fi.gr.cslrpt.MergeTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.app.AbstractItemDataYearInitControllerBean;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ColumnInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ParamTempTblService;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.TableInfo;
import com.kingdee.eas.fi.newrpt.RptNewUIHandleFacadeFactory;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.Result;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class ItemDataYearInitControllerBean
extends AbstractItemDataYearInitControllerBean {
    protected int STATUS_ADDNEW = 1;
    protected int STATUS_DELETE = 2;
    protected int STATUS_UPDATE = 3;
    private int EXCEL_ITEM = 0;
    private int EXCEL_CURRENCY = 2;
    private int EXCEL_SOURCE_CURRENCY = 4;
    private int EXCEL_DEBIT = 6;
    private int EXCEL_CREDIT = 7;
    private int EXCEL_VALUE_TYPE = 8;
    private int EXCEL_COVERT_STATUES = 9;
    private String excelOrgTreeId = null;
    private String excelUnitNum = null;
    private String excelUnitId = null;
    private String excelUnitName = null;
    private int excelYear = 0;
    DataCollectInfo dataCollectInfo = null;
    private int EXCEL_BASIC_LINE = 4;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.cslrpt.app.AbstractItemDataYearInitControllerBean");

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        ItemDataYearInitInfo info = this.getItemDataYearInitInfo(ctx, pk, this.getSelectorItemCollection());
        return info.getLogInfo();
    }

    private SelectorItemCollection getSelectorItemCollection() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("item.id"));
        sic.add(new SelectorItemInfo("item.number"));
        sic.add(new SelectorItemInfo("item.name"));
        sic.add(new SelectorItemInfo("Item.reportClass.id"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("sourceCurrency.id"));
        sic.add(new SelectorItemInfo("sourceCurrency.number"));
        sic.add(new SelectorItemInfo("sourceCurrency.name"));
        sic.add(new SelectorItemInfo("year"));
        sic.add(new SelectorItemInfo("debit"));
        sic.add(new SelectorItemInfo("credit"));
        sic.add(new SelectorItemInfo("valueType"));
        sic.add(new SelectorItemInfo("convertStatus"));
        sic.add(new SelectorItemInfo("dataElement"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("dataCollect.*"));
        return sic;
    }

    @Override
    protected BigDecimal _getYearInitValue(Context ctx, Map mapParams) throws BOSException {
        Integer mergeType;
        BigDecimal result = null;
        if (mapParams == null) {
            return result;
        }
        StringBuffer strSql = new StringBuffer();
        ArrayList<Object> lstParams = new ArrayList<Object>();
        strSql.append("Select (IsNull(FDebit,0)-IsNull(FCredit,0))*(FDC+FDC-1) as FValue").append("\r\n");
        strSql.append(" From T_Csl_ItemDataYearInit t1,T_Csl_RptItem t2").append("\r\n");
        strSql.append(" Where t1.FItemID = t2.FID ");
        if (mapParams.containsKey("OrgTreeID")) {
            strSql.append(" and FOrgTreeNumber in(select fnumber from t_org_tree where fid=?) ");
            lstParams.add(mapParams.get("OrgTreeID"));
            strSql.append(" and FOrgUnitNumber in(select fnumber from t_org_baseunit where fid=?) ");
            lstParams.add(mapParams.get("OrgUnitID"));
        } else {
            strSql.append(" and FOrgUnitid = ? ");
            lstParams.add(mapParams.get("OrgUnitID"));
        }
        strSql.append(" and FCurrencyid = ? ").append(" and FSourceCurrencyid = ? ").append(" and FYear = ? ").append(" and FDataElement = ? ").append(" and FValueType = ? ").append(" and t2.FNumber = ? ").append(" and FConvertStatus = ? ");
        lstParams.add(mapParams.get("KEY_CURRENCY_ID"));
        lstParams.add(mapParams.get("KEY_SOURCECURRENCY_ID"));
        lstParams.add(mapParams.get("Year"));
        lstParams.add(mapParams.get("DataElement"));
        lstParams.add(mapParams.get("ValueType"));
        lstParams.add(mapParams.get("KEY_ITEM_NUMBER"));
        lstParams.add(mapParams.get("KEY_CONVERTSTATUS"));
        if (mapParams.get("Period") != null) {
            strSql.append(" and t1.fperiod= ? ");
            lstParams.add(mapParams.get("Period"));
        }
        if ((mergeType = (Integer)mapParams.get("MERGETYPE")) == null) {
            mergeType = 0;
        }
        strSql.append(" and t1.fmergeType= ? ");
        lstParams.add(mergeType);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)strSql.toString(), (Object[])lstParams.toArray());
        try {
            while (rowSet.next()) {
                result = rowSet.getBigDecimal(1);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return result;
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkDoubleData(ctx, model);
        super._addnew(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkDoubleData(ctx, model);
        return super._addnew(ctx, model);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkDoubleData(ctx, model);
        super._update(ctx, pk, model);
    }

    private void checkDoubleData(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ItemDataYearInitInfo info = (ItemDataYearInitInfo)model;
        FilterInfo filter = new FilterInfo();
        if (info.getOrgTree() != null) {
            String orgTreeNumber = info.getOrgTree().getNumber();
            String orgUnitNumber = info.getOrgUnit().getNumber();
            if (StringUtils.isEmpty((String)orgTreeNumber) && !StringUtils.isEmpty((String)info.getOrgTreeNumber())) {
                orgTreeNumber = info.getOrgTreeNumber();
            }
            if (StringUtils.isEmpty((String)orgUnitNumber) && !StringUtils.isEmpty((String)info.getOrgUnitNumber())) {
                orgUnitNumber = info.getOrgUnitNumber();
            }
            filter.getFilterItems().add(new FilterItemInfo("orgTreeNumber", (Object)orgTreeNumber));
            filter.getFilterItems().add(new FilterItemInfo("orgUnitNumber", (Object)orgUnitNumber));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)info.getOrgUnit().getId().toString()));
        }
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)info.getCurrency().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("sourceCurrency.id", (Object)info.getSourceCurrency().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("item.id", (Object)info.getItem().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("year", (Object)new Integer(info.getYear())));
        filter.getFilterItems().add(new FilterItemInfo("dataElement", (Object)new Integer(info.getDataElement())));
        filter.getFilterItems().add(new FilterItemInfo("valueType", (Object)info.getValueType()));
        filter.getFilterItems().add(new FilterItemInfo("convertStatus", (Object)info.getConvertStatus()));
        filter.getFilterItems().add(new FilterItemInfo("dataCollectNumber", (Object)info.getDataCollectNumber()));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("mergeType", (Object)info.getMergeType().getValue(), CompareType.EQUALS));
        String maskString = "#0 and #1 and #2 and #3 and #4 and #5 and #6 and #7 and #8 and #9 and #10";
        if (info.getOrgTree() != null) {
            maskString = maskString + " and #11";
        }
        filter.setMaskString(maskString);
        if (info.getDataElement() == 3) {
            filter.getFilterItems().add(new FilterItemInfo("period", (Object)new Integer(info.getPeriod())));
            filter.setMaskString(filter.getMaskString() + " and #" + (filter.getFilterItems().size() - 1));
        }
        if (this.exists(ctx, filter)) {
            String tips = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource.920_itemIsExist", (Locale)ctx.getOriginLocale());
            tips = MessageFormat.format(tips, info.getItem().getName());
            throw new EASBizException(new NumericExceptionSubItem("001", tips));
        }
    }

    @Override
    protected int _geneRateNextYearInitData(Context ctx, String orgTreeId, String orgUnitID, List lstParams) throws BOSException, EASBizException {
        if (lstParams != null && lstParams.size() > 0) {
            boolean isMergeByFiscalPeriod = false;
            boolean treeIdIsNull = StringUtils.isEmpty((String)orgTreeId);
            PeriodCollection periods = null;
            if (!treeIdIsNull && (isMergeByFiscalPeriod = FiscalPeriodHelper.isMergeByFiscalPeriod(ctx))) {
                OrgTreeInfo orgTree = new OrgTreeInfo();
                orgTree.setId(BOSUuid.read((String)orgTreeId));
                periods = FiscalPeriodHelper.getPeriodCollection(ctx, orgTree);
            }
            Map mapRowData = null;
            HashMap mapTrees = new HashMap();
            for (int i = 0; i < lstParams.size(); ++i) {
                mapRowData = (Map)lstParams.get(i);
                if (!treeIdIsNull) {
                    int year = (Integer)mapRowData.get("Year");
                    Map thisTrees = this.getNextYearTreeAndUnit(ctx, orgTreeId, orgUnitID, year, mapTrees, periods);
                    if (thisTrees == null) continue;
                    for (String treeNumber : thisTrees.keySet()) {
                        String unitNumber = (String)thisTrees.get(treeNumber);
                        this.insertOrUpdateInitData(ctx, orgTreeId, orgUnitID, mapRowData, isMergeByFiscalPeriod, treeNumber, unitNumber);
                    }
                    continue;
                }
                this.insertOrUpdateInitData(ctx, null, orgUnitID, mapRowData, isMergeByFiscalPeriod, null, null);
            }
        }
        return 0;
    }

    private Map getNextYearTreeAndUnit(Context ctx, String orgTreeId, String orgUnitId, int year, Map mapTrees, PeriodCollection periods) throws BOSException {
        Integer y = new Integer(year);
        if (mapTrees.containsKey(y)) {
            return (Map)mapTrees.get(y);
        }
        String day = CslRptUtil.formatDateForSql(FiscalPeriodHelper.getEndOfYear(periods, year));
        if (day == null) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        mapTrees.put(y, result);
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct t.fnumber as FTreeNumber, b.fnumber as FUnitNumber ");
        sql.append("from t_org_structure s join t_org_tree t on s.ftreeid = t.fid ");
        sql.append("join t_org_baseunit b on s.funitid = b.fid ");
        sql.append("where t.fstatus > 0 and (t.fenddate > " + day + " or t.fenddate is null) ");
        sql.append("and t.fnumber in (select fnumber from t_org_tree where fid = ?) ");
        sql.append("and b.fnumber in (select fnumber from t_org_baseunit where fid = ?)");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{orgTreeId, orgUnitId});
        try {
            while (rowSet.next()) {
                String treeNumber = rowSet.getString("FTreeNumber");
                String unitNumber = rowSet.getString("FUnitNumber");
                result.put(treeNumber, unitNumber);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return result;
    }

    private void insertOrUpdateInitData(Context ctx, String orgTreeId, String orgUnitID, Map mapRowData, boolean isMergeByFiscalPeriod, String orgTreeNumber, String orgUnitNumber) throws BOSException, EASBizException {
        boolean orgTreeIDIsNull = StringUtils.isEmpty((String)orgTreeNumber);
        DataCollectInfo dcInfo_ACTUALDATA = DataCollectConstant.getActualDC();
        DataCollectInfo dcInfo_BUDGETDATA = DataCollectConstant.getBudgetDC();
        String strItemNumber = (String)mapRowData.get("ItemNumber");
        String strItemID = this.getItemIDByNumber(ctx, strItemNumber);
        String strCurrencyNumber = (String)mapRowData.get("CurrencyNumber");
        String strCurrencyID = this.getCurrencyIDByNumber(ctx, strCurrencyNumber);
        String strSrcCurrencyNumber = (String)mapRowData.get("SourceCurrencyNumber");
        String strSrcCurrencyID = null;
        strSrcCurrencyID = strCurrencyNumber.equals(strSrcCurrencyNumber) ? strCurrencyID : this.getCurrencyIDByNumber(ctx, strSrcCurrencyNumber);
        int iYear = (Integer)mapRowData.get("Year");
        int iDataElement = (Integer)mapRowData.get("DataElement");
        int iValueType = (Integer)mapRowData.get("ValueType");
        BigDecimal bgDebit = (BigDecimal)mapRowData.get("Debit");
        BigDecimal bgCredit = (BigDecimal)mapRowData.get("Credit");
        int iPeriod = (Integer)mapRowData.get("Period");
        Integer mergeType = (Integer)mapRowData.get("MERGETYPE");
        if (mergeType == null) {
            mergeType = 0;
        }
        StringBuffer oSql = new StringBuffer();
        oSql.append("where ");
        if (!orgTreeIDIsNull) {
            oSql.append("orgTreeNumber = '").append(orgTreeNumber).append("' and ");
            oSql.append("orgUnitNumber = '").append(orgUnitNumber).append("' and ");
        } else {
            oSql.append(" orgUnit.id = '").append(orgUnitID).append("' and ");
        }
        oSql.append(" item.id = '").append(strItemID).append("'");
        oSql.append(" and currency.id = '").append(strCurrencyID).append("'");
        oSql.append(" and sourceCurrency.id = '").append(strSrcCurrencyID).append("'");
        oSql.append(" and year = ").append(iYear + 1);
        oSql.append(" and dataElement = ").append(iDataElement);
        oSql.append(" and valueType = ").append(iValueType);
        oSql.append(" and dataCollectNumber = '").append("ACTUALDATA").append("'");
        oSql.append(" and mergetype=").append(mergeType);
        int iConvertStatus = strCurrencyNumber.equals(strSrcCurrencyNumber) ? 0 : 1;
        oSql.append(" and convertStatus = ").append(iConvertStatus);
        IItemDataYearInit itemDataYearInit = ItemDataYearInitFactory.getLocalInstance(ctx);
        ItemDataYearInitInfo itemDataYearInitInfo_ACTUALDATA = null;
        Object itemDataYearInitInfo_BUDGETDATA = null;
        if (itemDataYearInit.exists(oSql.toString())) {
            itemDataYearInitInfo_ACTUALDATA = (ItemDataYearInitInfo)itemDataYearInit.getValue(oSql.toString());
            if (itemDataYearInitInfo_ACTUALDATA != null && itemDataYearInitInfo_ACTUALDATA.size() > 0) {
                if (bgDebit != null) {
                    itemDataYearInitInfo_ACTUALDATA.setDebit(bgDebit);
                    itemDataYearInitInfo_ACTUALDATA.setCredit(null);
                }
                if (bgCredit != null) {
                    itemDataYearInitInfo_ACTUALDATA.setCredit(bgCredit);
                    itemDataYearInitInfo_ACTUALDATA.setDebit(null);
                }
                itemDataYearInitInfo_ACTUALDATA.setPeriod(iPeriod);
                itemDataYearInitInfo_ACTUALDATA.setDataCollect(dcInfo_ACTUALDATA);
                itemDataYearInitInfo_ACTUALDATA.setDataCollectNumber(dcInfo_ACTUALDATA.getNumber());
                itemDataYearInit.update((IObjectPK)new ObjectStringPK(itemDataYearInitInfo_ACTUALDATA.getId().toString()), (CoreBaseInfo)itemDataYearInitInfo_ACTUALDATA);
            }
        } else {
            FullOrgUnitInfo unitInfo = new FullOrgUnitInfo();
            unitInfo.setId(BOSUuid.read((String)orgUnitID));
            itemDataYearInitInfo_ACTUALDATA = new ItemDataYearInitInfo();
            if (!orgTreeIDIsNull) {
                OrgTreeInfo info = new OrgTreeInfo();
                info.setId(BOSUuid.read((String)orgTreeId));
                info.setNumber(orgTreeNumber);
                itemDataYearInitInfo_ACTUALDATA.setOrgTree(info);
                itemDataYearInitInfo_ACTUALDATA.setOrgUnitNumber(orgUnitNumber);
                itemDataYearInitInfo_ACTUALDATA.setOrgTreeNumber(orgTreeNumber);
                unitInfo.setNumber(orgUnitNumber);
            }
            itemDataYearInitInfo_ACTUALDATA.setOrgUnit(unitInfo);
            itemDataYearInitInfo_ACTUALDATA.setItem(RPTItemFactory.getLocalInstance(ctx).getRPTItemInfo((IObjectPK)new ObjectStringPK(strItemID)));
            itemDataYearInitInfo_ACTUALDATA.setCurrency(CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectStringPK(strCurrencyID)));
            itemDataYearInitInfo_ACTUALDATA.setSourceCurrency(CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectStringPK(strSrcCurrencyID)));
            itemDataYearInitInfo_ACTUALDATA.setYear(iYear + 1);
            itemDataYearInitInfo_ACTUALDATA.setDataElement(iDataElement);
            itemDataYearInitInfo_ACTUALDATA.setValueType(ValueTypeEnum.getEnum(iValueType));
            itemDataYearInitInfo_ACTUALDATA.setConvertStatus(ConvertStatusEnum.getEnum(iConvertStatus));
            if (bgDebit != null) {
                itemDataYearInitInfo_ACTUALDATA.setDebit(bgDebit);
            }
            if (bgCredit != null) {
                itemDataYearInitInfo_ACTUALDATA.setCredit(bgCredit);
            }
            itemDataYearInitInfo_ACTUALDATA.setPeriod(iPeriod);
            itemDataYearInitInfo_ACTUALDATA.setDataCollect(dcInfo_ACTUALDATA);
            itemDataYearInitInfo_ACTUALDATA.setDataCollectNumber(dcInfo_ACTUALDATA.getNumber());
            itemDataYearInitInfo_ACTUALDATA.setMergeType(MergeTypeEnum.getEnum(mergeType));
            itemDataYearInit.addnew((CoreBaseInfo)itemDataYearInitInfo_ACTUALDATA);
        }
    }

    private String getItemIDByNumber(Context ctx, String strNumber) throws BOSException, EASBizException {
        IRPTItem rptItem = RPTItemFactory.getLocalInstance(ctx);
        RPTItemInfo rptItemInfo = (RPTItemInfo)rptItem.getValue("Select id where number = '" + strNumber + "'");
        if (rptItemInfo == null || rptItemInfo.size() <= 0) {
            throw new BOSException("Data Error: invalid Report Item Number '" + strNumber + "'");
        }
        return rptItemInfo.getId().toString();
    }

    private String getCurrencyIDByNumber(Context ctx, String strNumber) throws BOSException, EASBizException {
        ICurrency currency = CurrencyFactory.getLocalInstance((Context)ctx);
        CurrencyInfo currencyInfo = (CurrencyInfo)currency.getValue("Select id where number = '" + strNumber + "'");
        if (currencyInfo == null || currencyInfo.size() <= 0) {
            throw new BOSException("Data Error: invalid Report Item Number '" + strNumber + "'");
        }
        return currencyInfo.getId().toString();
    }

    @Override
    protected void _saveYearInitDataList(Context ctx, List lstOldID, List lstNewObjects) throws BOSException, EASBizException {
        int i;
        int j;
        if (lstOldID != null && lstOldID.size() > 0) {
            StringBuffer strIDs = new StringBuffer("Delete From T_Csl_ItemDataYearInit Where FID in (");
            j = lstOldID.size();
            for (i = 0; i < j; ++i) {
                if (strIDs.length() > 0) {
                    strIDs.append(",");
                }
                strIDs.append("'").append(lstOldID.get(i).toString()).append("'");
            }
            strIDs.append(")");
            DbUtil.execute((Context)ctx, (String)strIDs.toString());
        }
        if (lstNewObjects != null && lstNewObjects.size() > 0) {
            IItemDataYearInit itemDataYearInit = ItemDataYearInitFactory.getLocalInstance(ctx);
            j = lstNewObjects.size();
            for (i = 0; i < j; ++i) {
                ItemDataYearInitInfo info = (ItemDataYearInitInfo)lstNewObjects.get(i);
                if (StringUtils.isEmpty((String)info.getOrgTreeNumber()) && info.getOrgTree() != null && !StringUtils.isEmpty((String)info.getOrgTree().getNumber())) {
                    info.setOrgTreeNumber(info.getOrgTree().getNumber());
                }
                if (StringUtils.isEmpty((String)info.getOrgUnitNumber()) && info.getOrgUnit() != null && !StringUtils.isEmpty((String)info.getOrgUnit().getNumber())) {
                    info.setOrgUnitNumber(info.getOrgUnit().getNumber());
                }
                itemDataYearInit.submit((CoreBaseInfo)info);
            }
        }
    }

    @Override
    protected Map _batchGetYearInitValue(Context ctx, List mapItemNumber, Map mapParams) throws BOSException {
        Integer mergeType;
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
        if (mapParams == null || mapItemNumber == null) {
            return result;
        }
        StringBuffer items = new StringBuffer();
        boolean isFirst = true;
        for (String number : mapItemNumber) {
            if (!isFirst) {
                items.append(",");
            }
            items.append("'").append(number).append("'");
            isFirst = false;
        }
        StringBuffer strSql = new StringBuffer();
        ArrayList<Object> lstParams = new ArrayList<Object>();
        strSql.append("Select (IsNull(FDebit,0)-IsNull(FCredit,0))*(FDC+FDC-1) as FValue, t2.FNumber");
        strSql.append(" From T_Csl_ItemDataYearInit t1,T_Csl_RptItem t2").append("\r\n");
        strSql.append(" Where t1.FItemID = t2.FID ");
        if (mapParams.containsKey("OrgTreeID")) {
            strSql.append(" and FOrgTreeNumber in(select fnumber from t_org_tree where fid=?) ");
            lstParams.add(mapParams.get("OrgTreeID"));
            strSql.append(" and FOrgUnitNumber in(select fnumber from t_org_baseunit where fid=?) ");
            lstParams.add(mapParams.get("OrgUnitID"));
        } else {
            strSql.append(" and FOrgUnitid = ? ");
            lstParams.add(mapParams.get("OrgUnitID"));
        }
        strSql.append(" and FCurrencyid = ? ").append(" and FSourceCurrencyid = ? ").append(" and FYear = ? ").append(" and FDataElement = ? ").append(" and FValueType = ? ").append(" and t2.FNumber in (").append(items.toString()).append(") and FConvertStatus = ? ").append(" and FDataCollectNumber = ?");
        lstParams.add(mapParams.get("KEY_CURRENCY_ID"));
        lstParams.add(mapParams.get("KEY_SOURCECURRENCY_ID"));
        lstParams.add(mapParams.get("Year"));
        lstParams.add(mapParams.get("DataElement"));
        lstParams.add(mapParams.get("ValueType"));
        lstParams.add(mapParams.get("KEY_CONVERTSTATUS"));
        lstParams.add(mapParams.get("KEY_DATACOLLECT_NUMBER"));
        if (mapParams.get("Period") != null) {
            strSql.append(" and t1.fperiod= ? ");
            lstParams.add(mapParams.get("Period"));
        }
        if ((mergeType = (Integer)mapParams.get("MERGETYPE")) == null) {
            mergeType = 0;
        }
        strSql.append(" and t1.fmergeType= ? ");
        lstParams.add(mergeType);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)strSql.toString(), (Object[])lstParams.toArray());
        try {
            while (rowSet.next()) {
                String number = rowSet.getString("FNumber");
                BigDecimal value = rowSet.getBigDecimal("FValue");
                result.put(number, value);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return result;
    }

    @Override
    protected void _saveData(Context ctx, Map changedInfosMap) throws BOSException, EASBizException {
        ArrayList<ItemDataYearInitInfo> updateEle = new ArrayList<ItemDataYearInitInfo>();
        ArrayList<ItemDataYearInitInfo> addnewEle = new ArrayList<ItemDataYearInitInfo>();
        for (ItemDataYearInitInfo element : changedInfosMap.keySet()) {
            Integer status = (Integer)changedInfosMap.get(element);
            if (status == this.STATUS_ADDNEW) {
                addnewEle.add(element);
                continue;
            }
            if (status == this.STATUS_UPDATE) {
                updateEle.add(element);
                continue;
            }
            if (status != this.STATUS_DELETE) continue;
            this.delete(ctx, (IObjectPK)new ObjectUuidPK(element.getId()));
        }
        for (ItemDataYearInitInfo element : updateEle) {
            this.update(ctx, (IObjectPK)new ObjectUuidPK(element.getId()), (CoreBaseInfo)element);
        }
        for (ItemDataYearInitInfo element : addnewEle) {
            this.addnew(ctx, (CoreBaseInfo)element);
        }
    }

    @Override
    protected String _checkCslReportExists(Context ctx, Map param) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        String treeid = (String)param.get("orgtreeid");
        String unitid = (String)param.get("orgunitid");
        RptPeriodTypeEnum periodtype = (RptPeriodTypeEnum)param.get("periodtype");
        int year = (Integer)param.get("year");
        sb.append(" select distinct t3.fname_" + ctx.getLocale() + " as ftreename,t3.fstartdate,t3.fenddate,t5.fname_" + ctx.getLocale() + " as funitname,t1.fname as frptname,t1.fyear,fperiod,fperiodtype \n");
        sb.append(" from t_csl_cslreport t1 join t_csl_rptreceived t2 on t1.fid=t2.freportid \n");
        sb.append(" join t_org_tree t3 on t2.forgtreeid=t3.fid \n");
        sb.append(" join t_org_structure t4 on t3.fid=t4.ftreeid \n");
        sb.append(" join t_org_baseunit t5 on t5.fid=t4.funitid and t1.forgunitid=t5.fid \n");
        sb.append(" where t3.fnumber in \n");
        sb.append(" (select fnumber from t_org_tree where fid=?) \n");
        sb.append(" and t4.flongnumber in \n");
        sb.append(" ( \n");
        sb.append(" select flongnumber from t_org_structure \n");
        sb.append(" where fid in (select fparentid from t_org_structure where funitid=?) \n");
        sb.append(" ) \n");
        sb.append(" and t1.fperiodtype= ? \n");
        sb.append(" and t1.fyear=? \n");
        sb.append(" and t1.fsourcetype=3 \n");
        sb.append(" order by fperiodtype, fyear, fperiod \n");
        ArrayList<Object> objs = new ArrayList<Object>();
        objs.add(treeid);
        objs.add(unitid);
        objs.add(new Integer(periodtype.getValue()));
        objs.add(new Integer(year + 1));
        StringBuffer sbHint = new StringBuffer();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])objs.toArray());
            while (rs.next()) {
                if (sbHint.length() < 1) {
                    sbHint.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"230_ItemDataYearInitControllerBean", (Locale)ctx.getOriginLocale())).append("\n");
                    sbHint.append("\n");
                    sbHint.append("\n");
                }
                sbHint.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"160_CslReportControllerBean", (Locale)ctx.getOriginLocale())).append(rs.getString("ftreename"));
                sbHint.append("(").append(rs.getDate("fstartdate")).append("-").append(rs.getDate("fenddate") == null ? "" : rs.getDate("fenddate").toString()).append(")").append(" \n");
                sbHint.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"231_ItemDataYearInitControllerBean", (Locale)ctx.getOriginLocale())).append(rs.getString("funitname")).append(" \n");
                sbHint.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"232_ItemDataYearInitControllerBean", (Locale)ctx.getOriginLocale())).append(periodtype).append(" \n");
                sbHint.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"233_ItemDataYearInitControllerBean", (Locale)ctx.getOriginLocale())).append(rs.getInt("fyear")).append(" \n");
                sbHint.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"234_ItemDataYearInitControllerBean", (Locale)ctx.getOriginLocale())).append(rs.getInt("fperiod")).append(" \n");
                sbHint.append("\n");
            }
        }
        catch (SQLException exc) {
            throw new SQLDataException(exc);
        }
        return sbHint.toString();
    }

    @Override
    protected boolean _checkCurrYearInitExists(Context ctx, String orgTreeId, String orgUnitId, int year, String dataCollectNumber) throws BOSException, EASBizException {
        ArrayList<Object> param = new ArrayList<Object>();
        StringBuffer sql = new StringBuffer("select top 1 fyear from t_csl_ItemDataYearInit yearInit ");
        sql.append(" inner join t_org_tree tree on yearInit.FOrgTreeNumber=tree.fnumber ");
        sql.append(" inner join t_org_baseunit unit on yearInit.FOrgUnitNumber=unit.fnumber ");
        sql.append(" where tree.fid = ? ");
        sql.append(" and unit.fid = ? ");
        sql.append(" and fyear = ? ");
        sql.append(" and fdataelement = ").append(5);
        sql.append(" and FDataCollectNumber = ? ");
        sql.append(" and fmergeType = 0 ");
        param.add(orgTreeId);
        param.add(orgUnitId);
        param.add(new Integer(year));
        param.add(dataCollectNumber);
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param.toArray());
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException exc) {
            throw new SQLDataException(exc);
        }
        return false;
    }

    @Override
    protected List _copyCurrYearInitData(Context ctx, Map params) throws BOSException, EASBizException {
        String orgTree = (String)params.get("orgTree");
        String orgUnit = (String)params.get("orgUnit");
        int year = (Integer)params.get("Year");
        String dataCollectNumber = "ACTUALDATA";
        if (params.containsKey("dataCollectNumber")) {
            dataCollectNumber = (String)params.get("dataCollectNumber");
        }
        boolean isExistsRecord = (Boolean)params.get("isExistsRecords");
        PeriodCollection periods = null;
        if (FiscalPeriodHelper.isMergeByFiscalPeriod(ctx)) {
            OrgTreeInfo tree = new OrgTreeInfo();
            tree.setId(BOSUuid.read((String)orgTree));
            periods = FiscalPeriodHelper.getPeriodCollection(null, tree);
        }
        List TreeAndUnitMap = this.getHisVersionTreeAndUnit(ctx, orgTree, orgUnit, year, periods);
        ArrayList result = new ArrayList();
        if (TreeAndUnitMap == null || TreeAndUnitMap.isEmpty()) {
            return result;
        }
        Iterator it = TreeAndUnitMap.iterator();
        String oldTree = null;
        String oldUnit = null;
        Map item = null;
        while (it.hasNext()) {
            item = (Map)it.next();
            oldTree = (String)item.keySet().iterator().next();
            if (!this.checkCurrYearInitExists(ctx, oldTree, oldUnit = (String)item.get(oldTree), year, dataCollectNumber)) continue;
            if (isExistsRecord) {
                this.deleteCurrRecords(ctx, orgTree, orgUnit, year, dataCollectNumber, 0);
            }
            this.insertHisItemDataYearInit(ctx, oldTree, oldUnit, orgTree, orgUnit, year, dataCollectNumber, 0);
            break;
        }
        return result;
    }

    private List getHisVersionTreeAndUnit(Context ctx, String orgTreeId, String orgUnitId, int year, PeriodCollection periods) throws BOSException, EASBizException {
        Date date = FiscalPeriodHelper.getBeginOfYear(periods, year);
        if (date == null) {
            return null;
        }
        java.sql.Date day = new java.sql.Date(date.getTime());
        HashMap<String, String> item = null;
        ArrayList result = new ArrayList();
        OrgTreeInfo orgTree = OrgTreeFactory.getLocalInstance((Context)ctx).getOrgTreeInfo((IObjectPK)new ObjectUuidPK(orgTreeId));
        ArrayList<Object> param = new ArrayList<Object>();
        StringBuffer sql = new StringBuffer();
        sql.append("select t.fid as FTreeId, b.fid as FUnitId ");
        sql.append("from t_org_structure s join t_org_tree t on s.ftreeid = t.fid ");
        sql.append("join t_org_baseunit b on s.funitid = b.fid ");
        sql.append("where t.fstatus = 2 and t.fenddate >= ?");
        param.add(day);
        if (orgTree.getStatus().getValue() == 2) {
            sql.append(" and t.fenddate < ? ");
            java.sql.Date endDate = new java.sql.Date(orgTree.getEndDate().getTime());
            param.add(endDate);
        }
        sql.append("and t.fnumber in (select fnumber from t_org_tree where fid = ?) ");
        param.add(orgTreeId);
        sql.append("and b.fnumber in (select fnumber from t_org_baseunit where fid = ?) order by t.fenddate desc");
        param.add(orgUnitId);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param.toArray());
        try {
            while (rowSet.next()) {
                item = new HashMap<String, String>(2);
                String treeId = rowSet.getString("FTreeId");
                String unitId = rowSet.getString("FUnitId");
                item.put(treeId, unitId);
                result.add(item);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return result;
    }

    private void deleteCurrRecords(Context ctx, String orgTreeId, String orgUnitId, int year, String dataCollectNumber, Integer mergeType) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("delete  t_csl_ItemDataYearInit ");
        sql.append(" where FOrgTreeNumber in (select fnumber from t_org_tree where fid =? ) ");
        sql.append(" and FOrgUnitNumber in (select fnumber from t_org_baseunit where fid =? ) ");
        sql.append(" and fyear = ?");
        sql.append(" and fdataelement = ").append(5);
        sql.append(" and FDataCollectNumber = ? ");
        sql.append(" and FmergeType = ?");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{orgTreeId, orgUnitId, new Integer(year), dataCollectNumber, mergeType});
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void insertHisItemDataYearInit(Context ctx, String oldTree, String oldUnit, String newTree, String newUnit, int year, String dataCollectNumber, Integer mergeType) throws BOSException, EASBizException {
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        BOSObjectType bosType = new ItemDataYearInitInfo().getBOSType();
        Connection cn = null;
        ItemDataYearInitCollection coll = ItemDataYearInitFactory.getLocalInstance(ctx).getItemDataYearInitCollection("where orgTree.id='" + oldTree + "' and orgUnit.id='" + oldUnit + "' and year=" + year + " and dataelement = 5 and dataCollect.number='" + dataCollectNumber + "' and mergetype= " + mergeType);
        DataCollectInfo dataCollect = DataCollectFactory.getLocalInstance(ctx).getDataCollectInfo(" where Number='" + dataCollectNumber + "'");
        if (coll == null) return;
        if (coll.size() == 0) {
            return;
        }
        Iterator it = coll.iterator();
        ItemDataYearInitInfo info = null;
        Date currDate = new Date();
        Timestamp time = new Timestamp(currDate.getTime());
        try {
            OrgTreeInfo orgTree = OrgTreeFactory.getLocalInstance((Context)ctx).getOrgTreeInfo((IObjectPK)new ObjectUuidPK(newTree));
            FullOrgUnitInfo orgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(newUnit));
            cn = EJBFactory.getConnection((Context)ctx);
            IORMappingDAO iOrMapping = ORMappingDAO.getInstance((BOSObjectType)bosType, (Context)ctx, (Connection)cn);
            while (it.hasNext()) {
                info = (ItemDataYearInitInfo)it.next();
                info.setId(BOSUuid.create((BOSObjectType)bosType));
                info.setOrgTree(orgTree);
                info.setOrgUnit(orgUnit);
                info.setYear(year);
                info.setCreator(user);
                info.setLastUpdateUser(user);
                info.setLastUpdateTime(time);
                info.setCreateTime(time);
                info.setDataCollectNumber(dataCollectNumber);
                info.setDataCollect(dataCollect);
                info.setMergeType(MergeTypeEnum.getEnum(mergeType));
                iOrMapping.addNewBatch((IObjectValue)info);
            }
            iOrMapping.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
                catch (EASBizException ee) {
                    throw new BOSException((Throwable)ee);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)cn);
    }

    @Override
    public List _getYearInitItemByTemplates(Context ctx, Map param) throws BOSException, EASBizException {
        if (param == null) {
            return null;
        }
        List templateIds = (List)param.get("templateIds");
        int dataElement = Integer.valueOf(param.get("dataElement").toString());
        int valueType = param.get("valueType") != null ? Integer.valueOf(param.get("valueType").toString()) : -1;
        HashSet<String> tempidSet = new HashSet<String>();
        SQLBuilder build = new SQLBuilder();
        build.append(" SELECT fid as tempid, FGROUPTEMPLATEID as grouptempid  FROM T_RPT_Template ");
        build.append(" WHERE fid IN ", (Collection)templateIds);
        build.append(" or FGROUPTEMPLATEID IN ", (Collection)templateIds);
        IRowSet rsct = DbUtil.executeQuery((Context)ctx, (String)build.getSQL(), (Object[])build.getParams());
        try {
            while (rsct.next()) {
                if (rsct.getString("grouptempid") != null) {
                    tempidSet.add(rsct.getString("grouptempid"));
                    continue;
                }
                tempidSet.add(rsct.getString("tempid"));
            }
        }
        catch (SQLException e1) {
            throw new SQLDataException(e1);
        }
        SQLBuilder builder = new SQLBuilder();
        builder.append("SELECT item.FId, item.FName_" + ctx.getLocale() + " FName, item.FNumber, item.FDc, itemlist.FValueType        ");
        builder.append("  FROM T_CSL_TempletItemList itemlist                            ");
        builder.append("  JOIN T_CSL_RptItem item on item.FNumber = itemlist.FItemNumber ");
        builder.append(" WHERE itemlist.FTemplateId IN ", tempidSet);
        builder.append("   AND itemlist.FDataElement = ?", (Object)dataElement);
        if (valueType > 0) {
            builder.append("   AND itemlist.FValueType = ?", (Object)valueType);
        } else {
            builder.append("   AND itemlist.FValueType in(1,2) ");
        }
        builder.append(" ORDER BY item.FNumber");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)builder.getSQL(), (Object[])builder.getParams());
        ArrayList reportIds = new ArrayList();
        ArrayList<RPTItemInfo> result = new ArrayList<RPTItemInfo>();
        try {
            while (rs.next()) {
                RPTItemInfo itemInfo = new RPTItemInfo();
                itemInfo.setId(BOSUuid.read((String)rs.getString("FId")));
                itemInfo.setNumber(rs.getString("FNumber"));
                itemInfo.setName(rs.getString("FName"), ctx.getLocale());
                itemInfo.setDc(DebitOrCreditEnum.getEnum(rs.getInt("FDc")));
                itemInfo.put("ValueType", (Object)ValueTypeEnum.getEnum(rs.getInt("FValueType")));
                result.add(itemInfo);
            }
        }
        catch (SQLException e1) {
            throw new SQLDataException(e1);
        }
        return result;
    }

    private String getItemDataSqlForSelect(Map hmMappingData, String tableName, String tableAlias) {
        StringBuffer buffer = new StringBuffer();
        TreeMap hmTemp = (TreeMap)hmMappingData.get(tableName);
        for (String number : hmTemp.keySet()) {
            if (buffer.length() > 0) {
                buffer.append(",");
            }
            buffer.append(tableAlias + "." + hmTemp.get(number) + " AS \"" + number + "\"");
        }
        buffer.append(" FROM T_CSL_ItemDataEntry");
        buffer.append(" LEFT OUTER JOIN " + tableName + " " + tableAlias);
        buffer.append("   ON T_CSL_ItemDataEntry.FID = " + tableAlias + ".FID ");
        return buffer.toString();
    }

    @Override
    protected List _getItemDataByCompany(Context ctx, Map param) throws BOSException, EASBizException {
        if (param == null) {
            return null;
        }
        String companyId = param.get("companyId").toString();
        int year = Integer.valueOf(param.get("year").toString());
        int period = Integer.valueOf(param.get("period").toString());
        String currencyId = param.get("currencyId").toString();
        String sourceCurrencyId = param.get("sourceCurrencyId").toString();
        String dataCollectNumber = param.get("dataCollectNumber").toString();
        int dataElement = Integer.valueOf(param.get("dataElement").toString());
        SQLBuilder builder = new SQLBuilder();
        builder.append("SELECT DISTINCT report.FId");
        builder.append("  FROM T_CSL_CslReport report");
        builder.append("  JOIN T_RPT_Template template ON report.FTemplateId = template.FId");
        builder.append("  JOIN T_CSL_TempletItemlist_new itemdatalist ON (itemdatalist.FTemplateId = template.FId  or itemdatalist.FTemplateId=template.fgrouptemplateid) ");
        builder.append(" WHERE report.FSourceType=?", (Object)1);
        builder.append("   AND report.FOrgunitId=?", (Object)companyId);
        builder.append("   AND report.FCurrencyId=?", (Object)currencyId);
        builder.append("   AND report.FSourceCurrencyId=?", (Object)sourceCurrencyId);
        builder.append("   AND report.FDataCollectNumber=?", (Object)dataCollectNumber);
        if (!((Boolean)param.get("isGroupRptListUI")).booleanValue()) {
            builder.append("   AND report.FIsCommitReport=?", (Object)1);
        }
        builder.append("   AND report.FYear=?", (Object)year);
        builder.append("   AND report.FPeriod=?", (Object)period);
        builder.append("   AND itemdatalist.FDataElement=?", (Object)dataElement);
        builder.append("   AND itemdatalist.FValueType=?", (Object)1);
        builder.append("   AND itemdatalist.FItemFormula LIKE ?", (Object)"=Item(%");
        builder.append("   AND report.FCommittedStatus =?", (Object)3);
        builder.append(" union ");
        builder.append("SELECT DISTINCT report.FId");
        builder.append("  FROM T_CSL_CslReport report");
        builder.append("  JOIN T_RPT_Template template ON report.FTemplateId = template.FId");
        builder.append("  JOIN T_CSL_TempletItemlist_his itemdatalist ON (itemdatalist.FTemplateId = template.FId  or itemdatalist.FTemplateId=template.fgrouptemplateid) ");
        builder.append(" WHERE report.FSourceType=?", (Object)1);
        builder.append("   AND report.FOrgunitId=?", (Object)companyId);
        builder.append("   AND report.FCurrencyId=?", (Object)currencyId);
        builder.append("   AND report.FSourceCurrencyId=?", (Object)sourceCurrencyId);
        builder.append("   AND report.FDataCollectNumber=?", (Object)dataCollectNumber);
        if (!((Boolean)param.get("isGroupRptListUI")).booleanValue()) {
            builder.append("   AND report.FIsCommitReport=?", (Object)1);
        }
        builder.append("   AND report.FYear=?", (Object)year);
        builder.append("   AND report.FPeriod=?", (Object)period);
        builder.append("   AND itemdatalist.FDataElement=?", (Object)dataElement);
        builder.append("   AND itemdatalist.FValueType=?", (Object)1);
        builder.append("   AND itemdatalist.FItemFormula LIKE ?", (Object)"=Item(%");
        builder.append("   AND report.FCommittedStatus =?", (Object)3);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)builder.getSQL(), (Object[])builder.getParams());
        ArrayList<String> reportIds = new ArrayList<String>();
        try {
            while (rs.next()) {
                reportIds.add(rs.getString("FId"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (reportIds.size() == 0) {
            return null;
        }
        return MaintainYearInitDataFacadeFactory.getLocalInstance(ctx).getRptItemInfoByReportIDList(reportIds, 4);
    }

    @Override
    protected List _getTemplateByQuery(Context ctx, Map param) throws BOSException, EASBizException {
        if (param == null) {
            return null;
        }
        ArrayList<TemplateInfo> templateList = new ArrayList<TemplateInfo>();
        String orgBoundId = (String)param.get("orgBoundId");
        String companyId = (String)param.get("companyId");
        String queryText = (String)param.get("queryText");
        if (orgBoundId == null || companyId == null) {
            return null;
        }
        SQLBuilder sb = new SQLBuilder();
        sb.append(" SELECT Fid,FNumber,Fname,FPeriodtype,FversionNumber,ForgType \n");
        sb.append("   FROM T_RPT_Template AS t\n");
        sb.append("  WHERE t.FTemplateType = 5\n");
        sb.append("    AND t.FIsFreezed = 0 \n");
        sb.append("    AND t.FVersionStatus = 1 \n");
        sb.append("    AND t.FPeriodType = 3 \n");
        sb.append("    AND t.FID IN\n");
        sb.append(" (SELECT DISTINCT FDispenseSrcId \n");
        sb.append("   FROM T_CSL_TempletDispense \n");
        sb.append("  WHERE FOrgBoundId = ? \n", (Object)orgBoundId);
        sb.append(" AND FCompanyId= ? ) \n", (Object)companyId);
        sb.append(" AND (FName LIKE '%" + queryText + "%' OR FNumber LIKE '%" + queryText + "%') \n");
        sb.append(" ORDER BY \n");
        sb.append(" FPeriodType ASC,\n");
        sb.append(" FNumber ASC,\n");
        sb.append(" FVersionNumber ASC\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.getSQL(), (Object[])sb.getParams());
        try {
            while (rs.next()) {
                TemplateInfo tmp = new TemplateInfo();
                tmp.setId(BOSUuid.read((String)rs.getString("FId")));
                tmp.setNumber(rs.getString("FNumber"));
                tmp.setName(rs.getString("FName"));
                tmp.setPeriodType(RptPeriodTypeEnum.getEnum((int)rs.getInt("FPeriodtype")));
                tmp.setVersionNumber(rs.getString("FversionNumber"));
                tmp.setOrgType(OrgType.Company);
                templateList.add(tmp);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (templateList.size() == 0) {
            return null;
        }
        return templateList;
    }

    @Override
    protected Map _saveYearInitDataForExcel(Context ctx, Map params) throws BOSException {
        boolean hasErrorData = false;
        StringBuffer msgStr = new StringBuffer();
        HashMap<String, CharSequence> result = new HashMap<String, CharSequence>();
        msgStr.append(this.checkMapDataNull(ctx, params));
        if (this.excelUnitName != null) {
            result.put("excelUnitName", this.excelUnitName);
        }
        if (msgStr != null && msgStr.length() > 0) {
            result.put("excelErrorMsg", msgStr);
            return result;
        }
        msgStr.append(this.insertData(ctx, params));
        if (msgStr != null && msgStr.length() > 0) {
            result.put("excelErrorMsg", msgStr);
            return result;
        }
        return result;
    }

    private String checkMapDataNull(Context ctx, Map params) {
        StringBuffer msgSb = new StringBuffer();
        this.dataCollectInfo = (DataCollectInfo)params.get("excelDataCollectInfo");
        msgSb.append(this.checkExcelCompany(ctx, params));
        msgSb.append(this.checkExcelYear(ctx, params));
        Object[][] bookData = (Object[][])params.get("excelYearInit");
        msgSb.append(this.checkData(ctx, bookData, this.EXCEL_ITEM));
        msgSb.append(this.checkData(ctx, bookData, this.EXCEL_CURRENCY));
        msgSb.append(this.checkData(ctx, bookData, this.EXCEL_SOURCE_CURRENCY));
        msgSb.append(this.checkSumNumber(ctx, bookData));
        if (msgSb.length() == 0) {
            msgSb.append(this.checkDataRepeat(ctx, bookData));
        }
        return msgSb.toString();
    }

    private Object checkDataRepeat(Context ctx, Object[][] bookData) {
        StringBuffer sb = new StringBuffer();
        StringBuffer tmpSb = new StringBuffer();
        for (int i = 0; i < bookData[1].length; ++i) {
            if (bookData[0][i] == null) continue;
            String itemNumber = bookData[1][i].toString();
            String currencyNum = bookData[2][i].toString();
            String sourceCurrencyNum = bookData[3][i].toString();
            String valueType = bookData[6][i].toString();
            for (int j = i + 1; j < bookData[1].length; ++j) {
                if (!itemNumber.equals(bookData[1][j].toString()) || !currencyNum.equals(bookData[2][j].toString()) || !sourceCurrencyNum.equals(bookData[3][j].toString()) || !valueType.equals(bookData[6][j].toString())) continue;
                tmpSb.append(bookData[0][j]).append(",");
                bookData[0][j] = null;
            }
            if (tmpSb.length() <= 0) continue;
            sb.append(this.getErrorMsgString(ctx, "excelDatRepeat"));
            this.removeLastChar(tmpSb);
            sb.append("[").append(bookData[0][i].toString()).append(",").append(tmpSb).append("]\n");
            tmpSb = new StringBuffer();
        }
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String insertData(Context ctx, Map params) throws BOSException {
        Object yearInitInfo = null;
        StringBuffer result = new StringBuffer();
        Object[][] bookData = (Object[][])params.get("excelYearInit");
        String tableName = null;
        try {
            tableName = this.createInfoTempTbl(ctx);
            this.insertDataToTempTable(ctx, tableName, bookData);
            result.append(this.insertList(ctx, bookData, tableName));
        }
        catch (Exception e) {
            logger.error((Object)"insertData error.", (Throwable)e);
            result.append(this.getErrorMsgString(ctx, "excelInsertDataError")).append(e.toString());
        }
        finally {
            if (tableName != null) {
                TempTablePool.getInstance((Context)ctx).releaseTable(tableName);
            }
        }
        return result.toString();
    }

    private String checkExcelYear(Context ctx, Map params) {
        StringBuffer msgSb = new StringBuffer();
        if (params.get("excelYear") == null) {
            msgSb.append(this.getErrorMsgString(ctx, "excelYearNull"));
        } else {
            BigDecimal year = null;
            try {
                year = (BigDecimal)params.get("excelYear");
                if (year.intValue() < 1900 || year.intValue() > 2200) {
                    throw new RuntimeException();
                }
                this.excelYear = year.intValue();
            }
            catch (RuntimeException e) {
                msgSb.append(this.getErrorMsgString(ctx, "excelYearError"));
            }
        }
        return msgSb.toString();
    }

    private String checkExcelCompany(Context ctx, Map params) {
        StringBuffer msgSb = new StringBuffer();
        StringBuffer sqlSb = new StringBuffer();
        ArrayList paramList = new ArrayList();
        this.excelUnitNum = this.isNull(params.get("excelCompanyNum")) ? null : params.get("excelCompanyNum").toString().trim();
        String string = this.excelOrgTreeId = this.isNull(params.get("excelOrgTreeId")) ? null : params.get("excelOrgTreeId").toString().trim();
        if (this.excelUnitNum == null) {
            msgSb.append(this.getErrorMsgString(ctx, "excelCompayNull"));
            return msgSb.toString();
        }
        if (params.get("orgParams") != null) {
            if (!this.hasUnitPermission(ctx, params.get("orgParams"), this.excelUnitNum)) {
                msgSb.append(this.getErrorMsgString(ctx, "excelNotPermission"));
            }
        } else {
            msgSb.append(this.getErrorMsgString(ctx, "excelNotPermission"));
        }
        return msgSb.toString();
    }

    private String checkData(Context ctx, Object[][] object, int excelIndex) {
        String errorHead;
        String errorMsg = "";
        ArrayList notNullList = new ArrayList();
        StringBuffer nullMsg = new StringBuffer();
        StringBuffer resulMsg = new StringBuffer();
        this.getNullMsg(object, nullMsg, notNullList, excelIndex);
        errorMsg = this.excuteCheck(ctx, notNullList, this.getExcelDataTable(excelIndex), excelIndex, object);
        if (nullMsg.length() != 0) {
            errorHead = this.getStringByIndex(ctx, excelIndex, "Null");
            resulMsg.append(errorHead).append("[").append(nullMsg.toString()).append("]").append("\n");
        }
        if (errorMsg != null && errorMsg.length() > 0) {
            errorHead = this.getStringByIndex(ctx, excelIndex, "Error");
            resulMsg.append(errorHead).append("[").append(errorMsg.toString()).append("]").append("\n");
        }
        return resulMsg.toString();
    }

    private String insertList(Context ctx, Object[][] bookData, String tableName) throws Exception {
        String userId = this.getUserId(ctx);
        ItemDataYearInitCollection newCol = new ItemDataYearInitCollection();
        ItemDataYearInitCollection existCol = new ItemDataYearInitCollection();
        StringBuffer sql = new StringBuffer();
        StringBuffer updateSql = new StringBuffer();
        StringBuffer insertSql = new StringBuffer();
        StringBuffer result = new StringBuffer();
        boolean isCslRpt = false;
        if (this.excelOrgTreeId != null && this.excelOrgTreeId.length() > 0) {
            isCslRpt = true;
        }
        IItemDataYearInit itemDataYearInit = ItemDataYearInitFactory.getLocalInstance(ctx);
        sql.append(" select yearInit.FId FId, tempTbl.Fline line \n").append(" from  ").append(tableName).append(" tempTbl  \n");
        if (isCslRpt) {
            sql.append(" inner join t_org_tree tree on tree.fid=tempTbl.FtreeId ");
            sql.append(" inner join t_org_baseunit unit on unit.fid=tempTbl.ForgUnitId ");
        }
        sql.append(" inner join  T_CSL_ItemDataYearInit yearInit on  \n").append(" (tempTbl.FItemId = yearInit.FItemId \n").append(" and tempTbl.FCurrencyID = yearInit.FCurrencyID \n").append(" and tempTbl.FSourceCurrencyID = yearInit.FSourceCurrencyID \n").append(" and tempTbl.FYear = yearInit.FYear \n").append(" and tempTbl.FValueType = yearInit.FValueType \n");
        if (isCslRpt) {
            sql.append(" and unit.fnumber = yearInit.forgunitNumber \n");
            sql.append(" and tree.fnumber = yearInit.forgTreeNumber ) \n");
        } else {
            sql.append(" and tempTbl.ForgUnitId = yearInit.FOrgUnitID \n");
            sql.append(" and yearInit.ForgTreeId is null) \n");
        }
        sql.append(" order by line asc \n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        updateSql.append(" update T_CSL_ItemDataYearInit set  ").append(" FDebit = ?, FCredit = ?, FvalueType = ?, FconvertStatus = ?, \n").append(" FLastUpdateUserId = ?, FLastUpdateTime = ? \n").append(" where fId = ? \n");
        PreparedStatement updateSt = null;
        Connection cn = null;
        try {
            Result resulte;
            cn = EJBFactory.getConnection((Context)ctx);
            updateSt = cn.prepareStatement(updateSql.toString());
            int index = -1;
            String id = "";
            if (rs.size() > 0 && rs.next()) {
                index = rs.getInt("line");
                id = rs.getString("Fid");
            }
            CoreBaseCollection yearInitCol = new CoreBaseCollection();
            HashMap<String, OrgTreeInfo> orgTrees = new HashMap<String, OrgTreeInfo>();
            HashMap<String, FullOrgUnitInfo> orgUnits = new HashMap<String, FullOrgUnitInfo>();
            for (int i = 0; i < bookData[0].length; ++i) {
                FullOrgUnitInfo orgUnit;
                BigDecimal tempCredit;
                BigDecimal tempDebit = bookData[4][i] == null ? null : new BigDecimal(bookData[4][i].toString());
                BigDecimal bigDecimal = tempCredit = bookData[5][i] == null ? null : new BigDecimal(bookData[5][i].toString());
                if (index == (Integer)bookData[0][i]) {
                    updateSt.setBigDecimal(1, tempDebit);
                    updateSt.setBigDecimal(2, tempCredit);
                    updateSt.setInt(3, this.getExcelValueType(bookData, i).getValue());
                    updateSt.setInt(4, this.getExcelCovertStatus(bookData, i).getValue());
                    updateSt.setString(5, userId);
                    updateSt.setDate(6, new java.sql.Date(Calendar.getInstance().getTimeInMillis()));
                    updateSt.setString(7, id);
                    updateSt.addBatch();
                    if (!rs.next()) continue;
                    index = rs.getInt("line");
                    id = rs.getString("Fid");
                    continue;
                }
                ItemDataYearInitInfo itemDataYearInitInfo = new ItemDataYearInitInfo();
                if (this.excelOrgTreeId != null) {
                    OrgTreeInfo orgTree = (OrgTreeInfo)orgTrees.get(this.excelOrgTreeId);
                    if (orgTree == null) {
                        orgTree = OrgTreeFactory.getLocalInstance((Context)ctx).getOrgTreeInfo((IObjectPK)new ObjectStringPK(this.excelOrgTreeId));
                        orgTrees.put(this.excelOrgTreeId, orgTree);
                    }
                    itemDataYearInitInfo.setOrgTree(orgTree);
                    itemDataYearInitInfo.setOrgTreeNumber(orgTree.getNumber());
                }
                if ((orgUnit = (FullOrgUnitInfo)orgUnits.get(this.excelUnitId)) == null) {
                    orgUnit = (FullOrgUnitInfo)FullOrgUnitFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectStringPK(this.excelUnitId));
                    orgUnits.put(this.excelUnitId, orgUnit);
                }
                itemDataYearInitInfo.setOrgUnit(orgUnit);
                itemDataYearInitInfo.setOrgUnitNumber(orgUnit.getNumber());
                itemDataYearInitInfo.setItem(RPTItemFactory.getLocalInstance(ctx).getRPTItemInfo((IObjectPK)new ObjectStringPK(bookData[1][i].toString())));
                itemDataYearInitInfo.setCurrency(CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectStringPK(bookData[2][i].toString())));
                itemDataYearInitInfo.setSourceCurrency(CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectStringPK(bookData[3][i].toString())));
                itemDataYearInitInfo.setYear(this.excelYear);
                itemDataYearInitInfo.setDataElement(5);
                itemDataYearInitInfo.setValueType(this.getExcelValueType(bookData, i));
                itemDataYearInitInfo.setConvertStatus(this.getExcelCovertStatus(bookData, i));
                if (tempCredit != null) {
                    itemDataYearInitInfo.setCredit(tempCredit);
                }
                if (tempDebit != null) {
                    itemDataYearInitInfo.setDebit(tempDebit);
                }
                itemDataYearInitInfo.setPeriod(1);
                itemDataYearInitInfo.setDataCollect(this.dataCollectInfo);
                itemDataYearInitInfo.setDataCollectNumber(this.dataCollectInfo.getNumber());
                yearInitCol.add((CoreBaseInfo)itemDataYearInitInfo);
            }
            updateSt.executeBatch();
            if (yearInitCol.size() > 0 && (resulte = itemDataYearInit.addnew(yearInitCol)) != null && resulte.getResult() == 0) {
                result.append(this.getErrorMsgString(ctx, "excelInsertDataError"));
                for (int i = 0; i < resulte.size(); ++i) {
                    if (resulte.getLineResult(i).getException() == null) continue;
                    result.append(resulte.getLineResult(i).getException().getMessage()).append("\n");
                }
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)" check excel data error ");
                throw new Exception(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(updateSt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)updateSt, (Connection)cn);
        return result.toString();
    }

    private ConvertStatusEnum getExcelCovertStatus(Object[][] bookData, int arrayIndex) {
        try {
            if (bookData[2][arrayIndex].toString().equals(bookData[3][arrayIndex].toString())) {
                return ConvertStatusEnum.BeforeConvert;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ConvertStatusEnum.Converted;
    }

    private ValueTypeEnum getExcelValueType(Object[][] bookData, int arrayIndex) {
        try {
            if (ValueTypeEnum.QUANTITY.getAlias().equals(bookData[6][arrayIndex].toString())) {
                return ValueTypeEnum.QUANTITY;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ValueTypeEnum.MONEY;
    }

    private String getUserId(Context ctx) {
        if (ContextUtil.getCurrentUserInfo((Context)ctx) != null && ContextUtil.getCurrentUserInfo((Context)ctx).getId() != null) {
            return ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        }
        return null;
    }

    private String createInfoTempTbl(Context ctx) throws BOSException {
        String tableName;
        StringBuffer createSql = new StringBuffer();
        createSql.append(" Create Table  T_YearInit_tempTbl ").append(" (Fline int, FItemId varchar(80), ").append(" FCurrencyId varchar(80), FSourceCurrencyId varchar(80),").append(" FtreeId varchar(44), ForgUnitId varchar(80), Fyear int,fvalueType int) ");
        try {
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            tableName = pool.createTempTable(createSql.toString());
        }
        catch (Exception e) {
            logger.error((Object)"create tempTbale fail");
            throw new BOSException((Throwable)e);
        }
        return tableName;
    }

    private String insertDataToTempTable(Context ctx, String tableName, Object[][] bookData) throws Exception {
        StringBuffer sql = new StringBuffer();
        StringBuffer result = new StringBuffer();
        sql.append("INSERT INTO ").append(tableName).append(" (Fline, FItemId,FCurrencyId, FSourceCurrencyId, ").append(" FtreeId, ForgUnitId, Fyear,fvalueType  ");
        sql.append(") values (?,?,?,?,?,?,?,?)");
        Connection con = null;
        PreparedStatement pStmt = null;
        con = EJBFactory.getConnection((Context)ctx);
        pStmt = con.prepareStatement(sql.toString());
        for (int k = 0; k < bookData[this.EXCEL_ITEM].length; ++k) {
            pStmt.setInt(1, (Integer)bookData[0][k]);
            pStmt.setString(2, bookData[1][k].toString());
            pStmt.setString(3, bookData[2][k].toString());
            pStmt.setString(4, bookData[3][k].toString());
            pStmt.setString(5, this.excelOrgTreeId);
            pStmt.setString(6, this.excelUnitId);
            pStmt.setInt(7, this.excelYear);
            ValueTypeEnum valueTypeEnum = this.getExcelValueType(bookData, k);
            pStmt.setInt(8, valueTypeEnum == null ? 1 : valueTypeEnum.getValue());
            pStmt.addBatch();
        }
        pStmt.executeBatch();
        return result.toString();
    }

    private boolean hasUnitPermission(Context ctx, Object object, String unitNumber) {
        ItemDataYearInitInfo info = new ItemDataYearInitInfo();
        Map orgParmas = (Map)object;
        boolean hasPermission = false;
        FullOrgUnitCollection array = (FullOrgUnitCollection)orgParmas.get("userOrgList");
        if (array == null) {
            return hasPermission;
        }
        for (int i = 0; i < array.size(); ++i) {
            FullOrgUnitInfo orgUnit = array.get(i);
            if (!unitNumber.equals(orgUnit.getNumber())) continue;
            hasPermission = true;
            this.excelUnitId = orgUnit.getId() == null ? null : orgUnit.getId().toString();
            this.excelUnitName = orgUnit.getName() == null ? null : orgUnit.getName().toString();
            break;
        }
        return hasPermission;
    }

    private String checkSumNumber(Context ctx, Object[][] object) {
        StringBuffer nullMsg = new StringBuffer();
        StringBuffer errorMsg = new StringBuffer();
        StringBuffer resultMsg = new StringBuffer();
        int debitIndex = this.getArrayIndex(this.EXCEL_DEBIT);
        int creditIndex = this.getArrayIndex(this.EXCEL_CREDIT);
        for (int i = 0; i < object[debitIndex].length; ++i) {
            if (!this.isNull(object[debitIndex][i]) && !this.isNull(object[creditIndex][i])) {
                int index = new BigDecimal(object[0][i].toString()).intValue();
                nullMsg.append("(").append(this.getNullCellSite(this.EXCEL_DEBIT, index)).append(",").append(this.getNullCellSite(this.EXCEL_CREDIT, index)).append(")").append(",");
                continue;
            }
            if (!this.isNull(object[4][i])) {
                try {
                    String debitStr = object[4][i].toString();
                    new BigDecimal(debitStr);
                    String[] splitDebit = debitStr.split("\\.");
                    if (splitDebit[0].length() > 14 || splitDebit.length > 1 && splitDebit[1].length() > 16) {
                        errorMsg.append("G").append(object[0][i]).append(",");
                    }
                }
                catch (Exception e) {
                    errorMsg.append("G").append(object[0][i]).append(",");
                }
            }
            if (this.isNull(object[5][i])) continue;
            try {
                String creditStr = object[5][i].toString();
                new BigDecimal(creditStr);
                String[] splitCredit = creditStr.split("\\.");
                if (splitCredit[0].length() <= 14 && (splitCredit.length <= 1 || splitCredit[1].length() <= 16)) continue;
                errorMsg.append("H").append(object[0][i]).append(",");
                continue;
            }
            catch (Exception e) {
                errorMsg.append("H").append(object[0][i]).append(",");
            }
        }
        if (nullMsg.length() != 0) {
            String errorhead = this.getStringByIndex(ctx, this.EXCEL_DEBIT, "Null");
            this.removeLastChar(nullMsg);
            resultMsg.append(errorhead).append("[").append(nullMsg).append("]").append("\n");
        }
        if (errorMsg.length() != 0) {
            String errorhead = this.getStringByIndex(ctx, this.EXCEL_DEBIT, "Error");
            this.removeLastChar(errorMsg);
            resultMsg.append(errorhead).append("[").append(errorMsg).append("]").append("\n");
        }
        return resultMsg.toString();
    }

    private boolean isNull(Object object) {
        return object == null || object.toString().trim().length() == 0;
    }

    private String getStringByIndex(Context ctx, int excelIndex, String string) {
        StringBuffer sb = new StringBuffer();
        if (excelIndex == this.EXCEL_ITEM) {
            sb.append("excelItem").append(string);
        } else if (excelIndex == this.EXCEL_CURRENCY) {
            sb.append("excelCurrency").append(string);
        } else if (excelIndex == this.EXCEL_SOURCE_CURRENCY) {
            sb.append("excelSouceCurrency").append(string);
        } else if (excelIndex == this.EXCEL_DEBIT) {
            sb.append("excelDebit").append(string);
        }
        return this.getErrorMsgString(ctx, sb.toString());
    }

    private String getExcelDataTable(int excelColIndex) {
        if (excelColIndex == this.EXCEL_ITEM) {
            return "T_CSL_RptItem";
        }
        if (excelColIndex == this.EXCEL_CURRENCY) {
            return "T_BD_Currency";
        }
        if (excelColIndex == this.EXCEL_SOURCE_CURRENCY) {
            return "T_BD_Currency";
        }
        return "";
    }

    private int getArrayIndex(int excelColIndex) {
        if (excelColIndex == this.EXCEL_ITEM) {
            return 1;
        }
        if (excelColIndex == this.EXCEL_CURRENCY) {
            return 2;
        }
        if (excelColIndex == this.EXCEL_SOURCE_CURRENCY) {
            return 3;
        }
        if (excelColIndex == this.EXCEL_DEBIT) {
            return 4;
        }
        if (excelColIndex == this.EXCEL_CREDIT) {
            return 5;
        }
        if (excelColIndex == this.EXCEL_VALUE_TYPE) {
            return 6;
        }
        if (excelColIndex == this.EXCEL_COVERT_STATUES) {
            return 7;
        }
        return 0;
    }

    private void getNullMsg(Object[][] object, StringBuffer nullMsg, List notNullList, int excelIndex) {
        for (int i = 0; i < object[0].length; ++i) {
            int arrayIndex = this.getArrayIndex(excelIndex);
            Object value = object[arrayIndex][i];
            int index = new BigDecimal(object[0][i].toString()).intValue();
            if (value == null || object[arrayIndex][i].toString().trim().length() == 0) {
                nullMsg.append(this.getNullCellSite(excelIndex, index)).append(",");
                continue;
            }
            notNullList.add(new Object[]{value.toString().trim(), index});
        }
        this.removeLastChar(nullMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String excuteCheck(Context ctx, List checkList, String tableName, int colIndex, Object[][] params) {
        ParamTempTblService service = null;
        StringBuffer errorSb = new StringBuffer();
        try {
            ArrayList<Object[]> insertList = new ArrayList<Object[]>();
            for (int i = 0; i < checkList.size(); ++i) {
                Object[] obj = (Object[])checkList.get(i);
                String number = (String)obj[0];
                if (number.length() > 80 && (this.EXCEL_ITEM == colIndex || this.EXCEL_SOURCE_CURRENCY == colIndex || this.EXCEL_CURRENCY == colIndex)) {
                    char c = (char)(65 + colIndex);
                    if (this.EXCEL_CURRENCY == colIndex) {
                        c = (char)(67 + colIndex);
                    } else if (this.EXCEL_SOURCE_CURRENCY == colIndex) {
                        c = (char)(69 + colIndex);
                    }
                    errorSb.append(c).append(obj[1]).append(",");
                    continue;
                }
                insertList.add(obj);
            }
            if (insertList.size() > 0) {
                service = this.getTemplateUnitService(ctx, insertList);
                String tempName = service.getTmpTableName();
                StringBuffer sql = new StringBuffer();
                sql.append("select tempTbl.Findex Findex, rptItem.Fid Fid from ").append(tempName).append(" tempTbl left join ").append(tableName).append(" rptItem on tempTbl.fnumber=rptItem.Fnumber ").append(" order by  Findex asc");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                if (rs.size() > 0) {
                    while (rs.next()) {
                        int arrayIndex = rs.getInt("Findex") - this.EXCEL_BASIC_LINE - 1;
                        String id = rs.getString("Fid");
                        if (id != null && !id.equals("") && arrayIndex >= 0) {
                            params[this.getArrayIndex((int)colIndex)][arrayIndex] = rs.getString("Fid");
                            continue;
                        }
                        char c = (char)(65 + colIndex);
                        errorSb.append(c).append(rs.getString("Findex")).append(",");
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.toString());
        }
        finally {
            if (service != null) {
                service.release();
            }
        }
        this.removeLastChar(errorSb);
        return errorSb.toString();
    }

    private void removeLastChar(StringBuffer sb) {
        if (sb.length() == 0) {
            return;
        }
        sb.replace(sb.length() - 1, sb.length(), "");
    }

    private ParamTempTblService getTemplateUnitService(Context ctx, List companyList) throws BOSException {
        TableInfo table = new TableInfo("t_temp_data");
        table.addColumn(new ColumnInfo("Fnumber", "nvarchar(80)"));
        table.addColumn(new ColumnInfo("Findex", "int"));
        ParamTempTblService service = ParamTempTblService.getInstance(ctx, table, companyList, null);
        return service;
    }

    private String getNullCellSite(int colIndex, int rowIndex) {
        StringBuffer sb = new StringBuffer();
        char c = (char)(65 + colIndex);
        sb.append(c).append(rowIndex);
        return sb.toString();
    }

    private String getErrorMsgString(Context ctx, String string) {
        String str = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)string, (Locale)ctx.getOriginLocale());
        return str;
    }

    @Override
    protected IObjectCollection _getUnionUnitOfTree(Context ctx, String userId, String treeId) throws BOSException {
        OrgPermissionService service = new OrgPermissionService(ctx);
        FullOrgUnitCollection result = new FullOrgUnitCollection();
        try {
            result = service.getUnionUnitOfTree((IObjectPK)new ObjectUuidPK(userId), (IObjectPK)new ObjectUuidPK(treeId));
        }
        catch (EASBizException e) {
            logger.error((Object)e.toString());
            e.printStackTrace();
        }
        return result;
    }

    @Override
    protected IObjectCollection _getAuthorizedOrg(Context ctx, String userId, String[] permItems, OrgType orgType) throws BOSException {
        IRowSet rs = null;
        try {
            rs = RptNewUIHandleFacadeFactory.getLocalInstance((Context)ctx).getAuthorizedOrg((IObjectPK)new ObjectUuidPK(userId), permItems, orgType);
        }
        catch (EASBizException e) {
            logger.error((Object)e.toString());
            e.printStackTrace();
        }
        FullOrgUnitCollection result = this.initCollection(rs);
        return result;
    }

    private FullOrgUnitCollection initCollection(IRowSet rs) {
        if (rs == null) {
            return null;
        }
        FullOrgUnitCollection orgCollection = new FullOrgUnitCollection();
        try {
            while (rs.next()) {
                FullOrgUnitInfo orgInfo = new FullOrgUnitInfo();
                orgInfo.setId(BOSUuid.read((String)rs.getString("FID")));
                orgInfo.setNumber(rs.getString("FNumber"));
                orgInfo.setName(rs.getString("Fname"));
                orgCollection.add(orgInfo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.toString());
            e.printStackTrace();
        }
        return orgCollection;
    }
}

