/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.fi.gr.cslrpt.BoundTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectCollection;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectFactory;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectInfo;
import com.kingdee.eas.fi.gr.cslrpt.IItemHisExchgRate;
import com.kingdee.eas.fi.gr.cslrpt.ItemHisExchgPromRateCollection;
import com.kingdee.eas.fi.gr.cslrpt.ItemHisExchgPromRateInfo;
import com.kingdee.eas.fi.gr.cslrpt.ItemHisExchgRateFactory;
import com.kingdee.eas.fi.gr.cslrpt.ItemHisExchgRateInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemCollection;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ItemHisExchgRateImport
extends AbstractDataTransmission {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.cslrpt.app.ItemHisExchgRateImport");
    private static String resource = "com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource";
    private Map<String, RPTItemInfo> cacheRptItemMap = new HashMap<String, RPTItemInfo>();
    private Map<String, OrgTreeCollection> cacheHasPermissionOrgTreeMap = null;
    private Map<String, OrgTreeInfo> cacheOrgTreeMap = new HashMap<String, OrgTreeInfo>();
    private Map<String, FullOrgUnitInfo> cacheUnitMap = new HashMap<String, FullOrgUnitInfo>();
    private Map<String, CurrencyInfo> cacheCurrencyMap = new HashMap<String, CurrencyInfo>();
    private Map<String, CoreBaseInfo> cacheItemHisExchgRateInfoMap = new HashMap<String, CoreBaseInfo>();
    private DataCollectInfo dataCollectInfo = null;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return ItemHisExchgRateFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public IItemHisExchgRate getBizInterface(Context ctx) {
        IItemHisExchgRate iItemHisExchgRate = null;
        try {
            iItemHisExchgRate = ItemHisExchgRateFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            logger.error((Object)"ItemHisExchgRate_getBizInterface_BOSException", (Throwable)e);
        }
        return iItemHisExchgRate;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        boolean isOrgBound;
        ItemHisExchgRateInfo info = (ItemHisExchgRateInfo)coreBaseInfo;
        if (info == null) {
            return;
        }
        boolean isAddNewImport = !this.isSltImportUpdate();
        StringBuilder sameDataKey = new StringBuilder();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection filterItems = filterInfo.getFilterItems();
        StringBuffer param = new StringBuffer();
        String desc = null;
        RPTItemInfo rptItem = info.getItem();
        filterItems.add(new FilterItemInfo("item", (Object)rptItem.getId().toString()));
        sameDataKey.append(rptItem.getId().toString());
        param.append(rptItem.getName());
        boolean bl = isOrgBound = info.getBoundType().getValue() == 1;
        if (isOrgBound) {
            OrgTreeInfo orgBound = info.getOrgBound();
            filterItems.add(new FilterItemInfo("orgBound", (Object)orgBound.getId().toString()));
            sameDataKey.append(orgBound.getId().toString());
            FullOrgUnitInfo orgGroup = info.getOrgBoundGrp();
            filterItems.add(new FilterItemInfo("orgBoundGrp", (Object)orgGroup.getId().toString()));
            sameDataKey.append(orgGroup.getId().toString());
            param.append(",").append(orgBound.getName());
            param.append(",").append(orgGroup.getName());
            desc = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"ItemHisRateKey2", (Locale)ctx.getOriginLocale());
        } else {
            FullOrgUnitInfo company = info.getCompany();
            filterItems.add(new FilterItemInfo("company", (Object)company.getId().toString()));
            sameDataKey.append(company.getId().toString());
            param.append(",").append(company.getName());
            desc = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"ItemHisRateKey1", (Locale)ctx.getOriginLocale());
            FullOrgUnitInfo prmtTargetCompany = info.getPrmtTargetCompany();
            String prmtTargetCompanyId = null;
            if (prmtTargetCompany != null) {
                prmtTargetCompanyId = prmtTargetCompany.getId().toString();
                param.append(",").append(prmtTargetCompany.getName());
                desc = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"ItemHisRateKey3", (Locale)ctx.getOriginLocale());
            }
            filterItems.add(new FilterItemInfo("prmtTargetCompany", (Object)prmtTargetCompanyId));
            sameDataKey.append(prmtTargetCompanyId);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(info.getChangeDate());
        Calendar checkDate = Calendar.getInstance();
        checkDate.setTime(new Date(0L));
        checkDate.set(1, calendar.get(1));
        checkDate.set(2, calendar.get(2));
        checkDate.set(5, calendar.get(5));
        checkDate.set(11, 0);
        checkDate.set(14, 0);
        checkDate.set(13, 0);
        Calendar checkDate2 = Calendar.getInstance();
        checkDate2.setTime(new Date(0L));
        checkDate2.set(1, calendar.get(1));
        checkDate2.set(2, calendar.get(2));
        checkDate2.set(5, calendar.get(5));
        checkDate2.set(11, 0);
        checkDate2.set(14, 0);
        checkDate2.set(13, 1);
        filterItems.add(new FilterItemInfo("changeDate", (Object)checkDate.getTime(), CompareType.GREATER_EQUALS));
        filterItems.add(new FilterItemInfo("changeDate", (Object)checkDate2.getTime(), CompareType.LESS));
        sameDataKey.append(checkDate.getTime());
        param.append(",").append(info.getChangeDate());
        CurrencyInfo currency = info.getCurrency();
        filterItems.add(new FilterItemInfo("currency", (Object)currency.getId().toString()));
        sameDataKey.append(currency.getId().toString());
        param.append(",").append(currency.getName());
        boolean isNeedAddNew = true;
        try {
            CoreBaseInfo coBaseInfo = null;
            boolean isNeedDeleteOldData = false;
            if (this.cacheItemHisExchgRateInfoMap.containsKey(sameDataKey.toString())) {
                coBaseInfo = this.cacheItemHisExchgRateInfoMap.get(sameDataKey.toString());
            } else {
                EntityViewInfo view = new EntityViewInfo();
                view.setFilter(filterInfo);
                CoreBaseCollection collection = this.getController(ctx).getCollection(view);
                if (collection != null && !collection.isEmpty()) {
                    coBaseInfo = collection.get(0);
                }
            }
            if (coBaseInfo != null) {
                ItemHisExchgRateInfo itemHisExchgRateInfo = (ItemHisExchgRateInfo)coBaseInfo;
                CompanyOrgUnitInfo trackRecordCreator = itemHisExchgRateInfo.getTrackRecordCreator();
                if (!trackRecordCreator.getId().toString().equals(info.getTrackRecordCreator().getId().toString())) {
                    if (isAddNewImport) {
                        throw new TaskExternalException(MessageFormat.format(desc, param));
                    }
                    throw new TaskExternalException(ResourceBase.getString((String)resource, (String)"945_TrackRecordCreatorNotSame", (Locale)ctx.getOriginLocale()));
                }
                if (isAddNewImport) {
                    isNeedAddNew = false;
                    BigDecimal changeAmount = itemHisExchgRateInfo.getChangeAmount();
                    ItemHisExchgPromRateCollection promRate = itemHisExchgRateInfo.getPromRate();
                    ItemHisExchgPromRateInfo promRateInfo = null;
                    ItemHisExchgPromRateInfo itemHisExchgPromRateInfo = info.getPromRate().get(0);
                    CurrencyInfo targetCurrency = itemHisExchgPromRateInfo.getTargetCurrency();
                    for (int i = 0; i < promRate.size(); ++i) {
                        promRateInfo = promRate.get(i);
                        if (targetCurrency.getId().toString().equals(promRateInfo.getTargetCurrency().getId().toString())) {
                            throw new TaskExternalException(MessageFormat.format(desc, param));
                        }
                        itemHisExchgPromRateInfo.setAmount(changeAmount.multiply(itemHisExchgPromRateInfo.getDirectRate()).setScale(targetCurrency.getPrecision(), 4));
                    }
                    promRate.add(itemHisExchgPromRateInfo);
                } else if ("true".equals(coBaseInfo.get("isImportAdd"))) {
                    isNeedAddNew = false;
                    ItemHisExchgPromRateInfo itemHisExchgPromRateInfo = info.getPromRate().get(0);
                    CurrencyInfo targetCurrency = itemHisExchgPromRateInfo.getTargetCurrency();
                    BigDecimal changeAmount = itemHisExchgRateInfo.getChangeAmount();
                    ItemHisExchgPromRateCollection promRate = itemHisExchgRateInfo.getPromRate();
                    ItemHisExchgPromRateInfo promRateInfo = null;
                    boolean hasSameTarCurrencyData = false;
                    for (int i = 0; i < promRate.size(); ++i) {
                        promRateInfo = promRate.get(i);
                        if (targetCurrency.getId().toString().equals(promRateInfo.getTargetCurrency().getId().toString())) {
                            hasSameTarCurrencyData = true;
                            promRateInfo.setDirectRate(itemHisExchgPromRateInfo.getDirectRate());
                            promRateInfo.setAmount(itemHisExchgPromRateInfo.getAmount());
                            break;
                        }
                        itemHisExchgPromRateInfo.setAmount(changeAmount.multiply(itemHisExchgPromRateInfo.getDirectRate()).setScale(targetCurrency.getPrecision(), 4));
                    }
                    if (!hasSameTarCurrencyData) {
                        promRate.add(itemHisExchgPromRateInfo);
                    }
                } else {
                    isNeedAddNew = true;
                    isNeedDeleteOldData = true;
                }
            }
            if (isNeedAddNew) {
                coreBaseInfo.put("isImport", (Object)"true");
                if (isNeedDeleteOldData) {
                    this.getController(ctx).delete((IObjectPK)new ObjectUuidPK(coBaseInfo.getId()));
                }
                if (!isAddNewImport) {
                    coreBaseInfo.put("isImportAdd", (Object)"true");
                }
                this.getController(ctx).addnew(coreBaseInfo);
                this.cacheItemHisExchgRateInfoMap.put(sameDataKey.toString(), coreBaseInfo);
            } else {
                coBaseInfo.put("isImport", (Object)"true");
                this.getController(ctx).update((IObjectPK)new ObjectUuidPK(coBaseInfo.getId()), coBaseInfo);
                this.cacheItemHisExchgRateInfoMap.put(sameDataKey.toString(), coBaseInfo);
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
    }

    private String fecthData(Hashtable htData, String key) {
        DataToken dataToken = (DataToken)htData.get(key);
        if (dataToken != null) {
            return dataToken.toString();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        boolean isOrgBound;
        String boundTypeStr = this.fecthData(hsData, "FBoundType");
        List boundTypeList = BoundTypeEnum.getEnumList();
        BoundTypeEnum boundType = null;
        for (int i = 0; i < boundTypeList.size(); ++i) {
            if (!((BoundTypeEnum)((Object)boundTypeList.get(i))).getAlias().equals(boundTypeStr)) continue;
            boundType = (BoundTypeEnum)((Object)boundTypeList.get(i));
            break;
        }
        if (boundType == null) {
            throw new TaskExternalException(ResourceBase.getString((String)resource, (String)"929_BoundTypeNotExist", (Locale)ctx.getOriginLocale()));
        }
        ItemHisExchgRateInfo info = new ItemHisExchgRateInfo();
        info.setBoundType(boundType);
        CompanyOrgUnitInfo companyOrgUnitInfo = new CompanyOrgUnitInfo();
        companyOrgUnitInfo.setId(BOSUuid.read((String)ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString()));
        info.setTrackRecordCreator(companyOrgUnitInfo);
        String itemNumberStr = this.fecthData(hsData, "FItemNumber");
        RPTItemInfo rptItem = this.getRptItem(ctx, itemNumberStr);
        if (rptItem == null) {
            throw new TaskExternalException(ResourceBase.getString((String)resource, (String)"928_ItemNotExist", (Locale)ctx.getOriginLocale()));
        }
        info.setItem(rptItem);
        String changeDateStr = this.fecthData(hsData, "FChangeDate");
        if (StringUtils.isEmpty((String)changeDateStr) || !changeDateStr.matches("\\d{4}-\\d{2}-\\d{2}")) {
            throw new TaskExternalException(ResourceBase.getString((String)resource, (String)"930_ChangeDateError", (Locale)ctx.getOriginLocale()));
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date changeDate = null;
        try {
            changeDate = sdf.parse(changeDateStr);
        }
        catch (ParseException e) {
            throw new TaskExternalException(e.getMessage());
        }
        if (changeDate == null) {
            throw new TaskExternalException(ResourceBase.getString((String)resource, (String)"930_ChangeDateError", (Locale)ctx.getOriginLocale()));
        }
        info.setChangeDate(changeDate);
        boolean bl = isOrgBound = info.getBoundType().getValue() == 1;
        if (isOrgBound) {
            Date lastDate;
            String orgBoundNumberStr = this.fecthData(hsData, "FOrgBoundNumber");
            OrgTreeInfo orgTree = this.getOrgTree(ctx, orgBoundNumberStr, lastDate = RPTDateUtil.getLastDayByDate(new Date(changeDate.getTime())));
            if (orgTree == null) {
                throw new TaskExternalException(ResourceBase.getString((String)resource, (String)"931_OrgTreeNotExist", (Locale)ctx.getOriginLocale()));
            }
            String orgBoundGrpNumberStr = this.fecthData(hsData, "FOrgBoundGrpNumber");
            FullOrgUnitInfo orgBoundGrp = this.getOrgBoundGrp(ctx, orgTree, orgBoundGrpNumberStr);
            if (orgBoundGrp == null) {
                throw new TaskExternalException(ResourceBase.getString((String)resource, (String)"933_OrgUnitNotExist", (Locale)ctx.getOriginLocale()));
            }
            info.setOrgBound(orgTree);
            info.setOrgBoundGrp(orgBoundGrp);
        } else {
            String companyNumberStr = this.fecthData(hsData, "FCompanyNumber");
            FullOrgUnitInfo company = this.getFullOrgUnit(ctx, companyNumberStr);
            if (company == null) {
                throw new TaskExternalException(ResourceBase.getString((String)resource, (String)"934_CompanyNotExist", (Locale)ctx.getOriginLocale()));
            }
            info.setCompany(company);
            String prmtTargetCompanyNumberStr = this.fecthData(hsData, "FPrmtTargetCompanyNumber");
            if (!StringUtils.isEmpty((String)prmtTargetCompanyNumberStr)) {
                FullOrgUnitInfo prmtTargetCompany = this.getFullOrgUnit(ctx, prmtTargetCompanyNumberStr);
                if (prmtTargetCompany == null) {
                    throw new TaskExternalException(ResourceBase.getString((String)resource, (String)"940_TarCompanyNotExist", (Locale)ctx.getOriginLocale()));
                }
                info.setPrmtTargetCompany(prmtTargetCompany);
            }
        }
        String currencyNumberStr = this.fecthData(hsData, "FCurrencyNumber");
        CurrencyInfo currency = this.getCurrency(ctx, currencyNumberStr, true);
        if (currency == null) {
            throw new TaskExternalException(ResourceBase.getString((String)resource, (String)"935_CurrencyNotExist", (Locale)ctx.getOriginLocale()));
        }
        info.setCurrency(currency);
        String changeAmountStr = this.fecthData(hsData, "FChangeAmount");
        if (StringUtils.isEmpty((String)changeAmountStr)) {
            throw new TaskExternalException(ResourceBase.getString((String)resource, (String)"936_ChangeAmountError", (Locale)ctx.getOriginLocale()));
        }
        try {
            BigDecimal changeAmount = new BigDecimal(changeAmountStr);
            if (changeAmount.compareTo(new BigDecimal("9999999999999")) > 0 || changeAmount.compareTo(new BigDecimal("-9999999999999")) < 0) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"HisExchgValueOutOfRange", (Locale)ctx.getOriginLocale()));
            }
            info.setChangeAmount(changeAmount.setScale(4, 4));
        }
        catch (Exception e) {
            throw new TaskExternalException(ResourceBase.getString((String)resource, (String)"936_ChangeAmountError", (Locale)ctx.getOriginLocale()));
        }
        String summaryStr = this.fecthData(hsData, "FSummary");
        if (!StringUtils.isEmpty((String)summaryStr)) {
            info.setSummary(summaryStr);
        }
        ItemHisExchgPromRateInfo item = new ItemHisExchgPromRateInfo();
        String directRateStr = this.fecthData(hsData, "FDirectRate");
        if (StringUtils.isEmpty((String)directRateStr)) {
            throw new TaskExternalException(ResourceBase.getString((String)resource, (String)"938_DirectRateError", (Locale)ctx.getOriginLocale()));
        }
        try {
            item.setDirectRate(new BigDecimal(directRateStr).setScale(6, 4));
        }
        catch (Exception e) {
            throw new TaskExternalException(ResourceBase.getString((String)resource, (String)"938_DirectRateError", (Locale)ctx.getOriginLocale()));
        }
        String tarCurrencyNumberStr = this.fecthData(hsData, "FTarCurrencyNumber");
        CurrencyInfo tarCurrency = this.getCurrency(ctx, tarCurrencyNumberStr, false);
        if (tarCurrency == null) {
            throw new TaskExternalException(ResourceBase.getString((String)resource, (String)"937_TarCurrencyNotExist", (Locale)ctx.getOriginLocale()));
        }
        if (tarCurrency.getId().toString().equals(currency.getId().toString())) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"targetAndSourceCurrencyRepeat", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{tarCurrency.getName()}));
        }
        item.setTargetCurrency(tarCurrency);
        item.setAmount(info.getChangeAmount().multiply(item.getDirectRate()).setScale(tarCurrency.getPrecision(), 4));
        info.getPromRate().add(item);
        info.setIsSetPromRate(true);
        try {
            if (this.dataCollectInfo != null) return info;
            DataCollectCollection dataCollectCollection = DataCollectFactory.getLocalInstance(ctx).getDataCollectCollection("select * where number in ('ACTUALDATA')");
            if (dataCollectCollection != null && !dataCollectCollection.isEmpty()) {
                this.dataCollectInfo = dataCollectCollection.get(0);
            }
            if (this.dataCollectInfo == null) return info;
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage());
        }
        return info;
    }

    private CurrencyInfo getCurrency(Context ctx, String currencyNumberStr, boolean isCurrency) throws TaskExternalException {
        if (StringUtils.isEmpty((String)currencyNumberStr)) {
            return null;
        }
        if (this.cacheCurrencyMap.containsKey(currencyNumberStr)) {
            return this.cacheCurrencyMap.get(currencyNumberStr);
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("precision"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)currencyNumberStr));
        view.setFilter(filter);
        try {
            CurrencyCollection currencyCollection = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection(view);
            CurrencyInfo currencyInfo = null;
            if (currencyCollection != null && !currencyCollection.isEmpty()) {
                currencyInfo = currencyCollection.get(0);
            }
            this.cacheCurrencyMap.put(currencyNumberStr, currencyInfo);
            return currencyInfo;
        }
        catch (BOSException e) {
            throw new TaskExternalException(ResourceBase.getString((String)resource, (String)(isCurrency ? "935_CurrencyNotExist" : "937_TarCurrencyNotExist"), (Locale)ctx.getOriginLocale()));
        }
    }

    private FullOrgUnitInfo getFullOrgUnit(Context ctx, String companyNumberStr) throws TaskExternalException {
        if (StringUtils.isEmpty((String)companyNumberStr)) {
            return null;
        }
        if (this.cacheUnitMap.containsKey(companyNumberStr)) {
            return this.cacheUnitMap.get(companyNumberStr);
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        view.setSelector(sic);
        String userId = ctx.getCaller().toString();
        FilterInfo filter = new FilterInfo();
        int formulaIndex = 0;
        StringBuilder sbFormula = new StringBuilder();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)companyNumberStr));
        sbFormula.append("#" + formulaIndex++);
        sbFormula.append(" and ");
        filter.getFilterItems().add(new FilterItemInfo("partFI.isSealUp", (Object)0));
        sbFormula.append("(#" + formulaIndex++);
        sbFormula.append(" or ");
        filter.getFilterItems().add(new FilterItemInfo("partProfitCenter.isSealUp", (Object)0));
        sbFormula.append("#" + formulaIndex++ + ")");
        sbFormula.append(" and ");
        filter.getFilterItems().add(new FilterItemInfo("id in (SELECT forgid FROM t_pm_orgrange WHERE fuserid = '" + userId + "' AND ftype = 10)"));
        sbFormula.append("#" + formulaIndex++);
        if (sbFormula.length() > 0) {
            filter.setMaskString(sbFormula.toString());
        } else if (filter.containsKey("maskString")) {
            filter.remove("maskString");
        }
        view.setFilter(filter);
        try {
            FullOrgUnitCollection fullOrgUnitCollection = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitCollection(view);
            FullOrgUnitInfo fullOrgUnitInfo = null;
            if (fullOrgUnitCollection != null && !fullOrgUnitCollection.isEmpty()) {
                fullOrgUnitInfo = fullOrgUnitCollection.get(0);
            }
            this.cacheUnitMap.put(companyNumberStr, fullOrgUnitInfo);
            return fullOrgUnitInfo;
        }
        catch (BOSException e) {
            throw new TaskExternalException(ResourceBase.getString((String)resource, (String)"934_CompanyNotExist", (Locale)ctx.getOriginLocale()));
        }
    }

    private FullOrgUnitInfo getOrgBoundGrp(Context ctx, OrgTreeInfo orgTree, String orgBoundGrpNumberStr) throws TaskExternalException {
        if (StringUtils.isEmpty((String)orgBoundGrpNumberStr)) {
            return null;
        }
        String unitKey = orgTree.getNumber() + orgTree.getStartDate().getTime() + orgBoundGrpNumberStr;
        if (this.cacheUnitMap.containsKey(unitKey)) {
            return this.cacheUnitMap.get(unitKey);
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("unit.id"));
        sic.add(new SelectorItemInfo("unit.name"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("tree.id", (Object)orgTree.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("unit.number", (Object)orgBoundGrpNumberStr));
        filter.getFilterItems().add(new FilterItemInfo("unit.isunion", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("unit.id in (SELECT forgid FROM t_pm_orgrange WHERE fuserid = '" + ctx.getCaller().toString() + "' AND ftype = 10)"));
        view.setFilter(filter);
        try {
            OrgStructureCollection orgStructureCollection = OrgStructureFactory.getLocalInstance((Context)ctx).getOrgStructureCollection(view);
            FullOrgUnitInfo fullOrgUnitInfo = null;
            if (orgStructureCollection != null && !orgStructureCollection.isEmpty()) {
                fullOrgUnitInfo = orgStructureCollection.get(0).getUnit();
            }
            this.cacheUnitMap.put(unitKey, fullOrgUnitInfo);
            return fullOrgUnitInfo;
        }
        catch (BOSException e) {
            throw new TaskExternalException(ResourceBase.getString((String)resource, (String)"933_OrgUnitNotExist", (Locale)ctx.getOriginLocale()));
        }
    }

    private OrgTreeInfo getOrgTree(Context ctx, String orgBoundNumberStr, Date changeDate) throws TaskExternalException {
        OrgTreeInfo orgTreeInfo;
        OrgTreeInfo tree;
        if (StringUtils.isEmpty((String)orgBoundNumberStr)) {
            return null;
        }
        if (!this.cacheOrgTreeMap.containsKey(orgBoundNumberStr)) {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            view.setSelector(sic);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)orgBoundNumberStr));
            view.setFilter(filter);
            try {
                OrgTreeCollection orgTreeCollection = OrgTreeFactory.getLocalInstance((Context)ctx).getOrgTreeCollection(view);
                OrgTreeInfo orgTreeInfo2 = null;
                if (orgTreeCollection != null && !orgTreeCollection.isEmpty()) {
                    orgTreeInfo2 = orgTreeCollection.get(0);
                }
                this.cacheOrgTreeMap.put(orgBoundNumberStr, orgTreeInfo2);
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage());
            }
        }
        if ((tree = this.cacheOrgTreeMap.get(orgBoundNumberStr)) == null) {
            return null;
        }
        if (this.cacheHasPermissionOrgTreeMap == null) {
            this.cacheHasPermissionOrgTreeMap = new HashMap<String, OrgTreeCollection>();
            try {
                OrgTreeCollection hasPermissionOrgTreeCollection = CslRptUtil.getOrgTreeCollection(ctx, ctx.getCaller().toString(), null, true);
                if (hasPermissionOrgTreeCollection != null && !hasPermissionOrgTreeCollection.isEmpty()) {
                    for (int i = 0; i < hasPermissionOrgTreeCollection.size(); ++i) {
                        orgTreeInfo = hasPermissionOrgTreeCollection.get(i);
                        String orgTreeNumber = orgTreeInfo.getNumber();
                        OrgTreeCollection orgTreeCollection = this.cacheHasPermissionOrgTreeMap.get(orgTreeNumber);
                        if (orgTreeCollection == null) {
                            orgTreeCollection = new OrgTreeCollection();
                            this.cacheHasPermissionOrgTreeMap.put(orgTreeNumber, orgTreeCollection);
                        }
                        orgTreeCollection.add(orgTreeInfo);
                    }
                }
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage());
            }
        }
        if (this.cacheHasPermissionOrgTreeMap.isEmpty()) {
            throw new TaskExternalException(ResourceBase.getString((String)resource, (String)"939_OrgTreeHaveNoPermission", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{tree.getName()}));
        }
        OrgTreeCollection orgTreeCollection = this.cacheHasPermissionOrgTreeMap.get(orgBoundNumberStr);
        if (orgTreeCollection == null || orgTreeCollection.isEmpty()) {
            throw new TaskExternalException(ResourceBase.getString((String)resource, (String)"939_OrgTreeHaveNoPermission", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{tree.getName()}));
        }
        for (int i = 0; i < orgTreeCollection.size(); ++i) {
            orgTreeInfo = orgTreeCollection.get(i);
            Timestamp startDate = orgTreeInfo.getStartDate();
            Timestamp endDate = orgTreeInfo.getEndDate();
            if (changeDate.getTime() < startDate.getTime() || endDate != null && changeDate.getTime() > endDate.getTime()) continue;
            return orgTreeInfo;
        }
        throw new TaskExternalException(ResourceBase.getString((String)resource, (String)"932_OrgTreeNotFindByChangeDate", (Locale)ctx.getOriginLocale()));
    }

    private RPTItemInfo getRptItem(Context ctx, String itemNumberStr) throws TaskExternalException {
        if (StringUtils.isEmpty((String)itemNumberStr)) {
            return null;
        }
        if (this.cacheRptItemMap.containsKey(itemNumberStr)) {
            return this.cacheRptItemMap.get(itemNumberStr);
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)itemNumberStr));
        view.setFilter(filter);
        try {
            RPTItemCollection rptItemCollection = RPTItemFactory.getLocalInstance(ctx).getRPTItemCollection(view);
            RPTItemInfo rptItemInfo = null;
            if (rptItemCollection != null && !rptItemCollection.isEmpty()) {
                rptItemInfo = rptItemCollection.get(0);
            }
            this.cacheRptItemMap.put(itemNumberStr, rptItemInfo);
            return rptItemInfo;
        }
        catch (BOSException e) {
            throw new TaskExternalException(ResourceBase.getString((String)resource, (String)"928_ItemNotExist", (Locale)ctx.getOriginLocale()));
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            this.setData(result, "FItemNumber", rs.getObject("item.number"));
            this.setData(result, "FItemName", rs.getObject("item.name"));
            this.setData(result, "FBoundType", (Object)BoundTypeEnum.getEnum(rs.getInt("boundType")));
            this.setData(result, "FChangeDate", rs.getDate("changeDate"));
            this.setData(result, "FOrgBoundNumber", rs.getObject("orgBound.number"));
            this.setData(result, "FOrgBoundName", rs.getObject("orgBound.name"));
            this.setData(result, "FOrgBoundGrpNumber", rs.getObject("orgBoundGrp.number"));
            this.setData(result, "FOrgBoundGrpName", rs.getObject("orgBoundGrp.name"));
            this.setData(result, "FOrgTreeStartDate", rs.getDate("orgBound.startDate"));
            this.setData(result, "FCompanyNumber", rs.getObject("company.number"));
            this.setData(result, "FCompanyName", rs.getObject("company.name"));
            this.setData(result, "FCurrencyNumber", rs.getObject("currency.number"));
            this.setData(result, "FCurrencyName", rs.getObject("currency.name"));
            this.setData(result, "FChangeAmount", rs.getObject("changeAmount"));
            this.setData(result, "FTarCurrencyNumber", rs.getObject("targetCurrency.number"));
            this.setData(result, "FTarCurrencyName", rs.getObject("targetCurrency.name"));
            this.setData(result, "FDirectRate", rs.getObject("promRate.directRate"));
            this.setData(result, "FAmount", rs.getObject("promRate.amount"));
            this.setData(result, "FSummary", rs.getObject("summary"));
            this.setData(result, "FPrmtTargetCompanyNumber", rs.getObject("prmtTargetCompany.number"));
            this.setData(result, "FPrmtTargetCompanyName", rs.getObject("prmtTargetCompany.name"));
            this.setData(result, "FTrackRecordCreator", rs.getObject("trackRecordCreator.name"));
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private void setData(Hashtable result, String key, Object value) {
        if (value != null) {
            result.put(key, value.toString());
        }
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return null;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.fi.gr.cslrpt.ItemHisExchgRateQuery";
    }

    public void setContextParameter(Hashtable param) {
        super.setContextParameter((Map)param);
    }

    public int getSubmitType() {
        return super.getSubmitType();
    }

    public String getMainField() {
        return super.getMainField();
    }
}

