/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.IItemDataYearInit;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataYearInitFactory;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataYearInitInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.AbstractMaintainYearInitDataFacadeControllerBean;
import com.kingdee.eas.fi.gr.cslrpt.app.CSLServerHelper;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MaintainYearInitDataFacadeControllerBean
extends AbstractMaintainYearInitDataFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.cslrpt.app.MaintainYearInitDataFacadeControllerBean");
    private String lan;

    @Override
    protected List _getRptItemInfoByReportIDList(Context ctx, List reportIDList, int dataElement) throws BOSException {
        ArrayList<HashMap> returnList = null;
        if (reportIDList == null) {
            logger.debug((Object)"-----Error reportIDList is null-----");
            return null;
        }
        returnList = new ArrayList<HashMap>();
        Iterator reportIDIt = reportIDList.iterator();
        List currentRowList = null;
        Iterator currentRowIt = null;
        HashMap currentRowMap2 = null;
        while (reportIDIt.hasNext()) {
            currentRowList = this._getRptItemInfoByReportID(ctx, (String)reportIDIt.next(), dataElement);
            if (currentRowList != null) {
                for (HashMap currentRowMap2 : currentRowList) {
                    if (this.hasSuchObject(currentRowMap2, returnList)) continue;
                    returnList.add(currentRowMap2);
                }
            }
            currentRowList = null;
        }
        return returnList;
    }

    @Override
    protected List _getRptItemInfoByReportID(Context ctx, String reportID, int dataElement) throws BOSException {
        ArrayList returnList = null;
        this.lan = ctx.getLocale().toString();
        SQLBuilder builder = new SQLBuilder();
        builder.append("SELECT distinct rptItem.FNumber,rptItem.FName_").append(this.lan).append(",cslRpt.FYear,cslRpt.FPeriod,currency.FName_").append(this.lan).append(", ");
        builder.append(" itemDataYearInit.FDebit,itemDataYearInit.FCredit,itemList.FDataElement, itemList.FValueType, case when baseUnit.fisunion=1 then orgTree.FName_").append(this.lan);
        builder.append(" else null end orgTreeName,itemList.FSheetID,itemList.FPosX,itemList.FPosY,rptItem.FDC, ");
        builder.append(" case when baseUnit.fisunion=1 then orgTree.FId else null end orgTreeId, rptItem.FID,cslRpt.FOrgUnitID,baseUnit.FDisplayName_").append(this.lan).append(", ");
        builder.append(" cslRpt.FCurrencyID,cslRpt.FSourceType,srcCurrency.FId srcCurrencyId, srcCurrency.FName_").append(this.lan).append(" srcCurrencyName");
        builder.append(" ,case when baseUnit.fisunion=1 then orgTree.fnumber else null end OrgTreeNumber,baseUnit.fnumber OrgUnitNumber ");
        builder.append(" FROM T_CSL_CslReport cslRpt ");
        builder.append(" INNER JOIN T_RPT_Template template ON cslRpt.FTemplateID = template.FID ");
        builder.append(" INNER JOIN T_RPT_Template grpTpl ON (template.fid = grpTpl.Fid or template.fgrouptemplateid = grpTpl.fid) ");
        builder.append(" INNER JOIN T_CSL_TempletItemList itemList ON grpTpl.FID = itemList.FTemplateID ");
        builder.append(" INNER JOIN T_CSL_rptItem rptItem ON itemList.FItemNumber = RptItem.FNumber ");
        builder.append(" INNER JOIN T_BD_Currency currency ON cslRpt.FCurrencyID = currency.FID ");
        builder.append(" INNER JOIN T_BD_Currency srcCurrency ON cslRpt.FSourceCurrencyId = srcCurrency.FID ");
        builder.append(" INNER JOIN T_CSL_RptReceived received ON cslRpt.fid = received.FReportID ");
        builder.append(" INNER JOIN T_ORG_Tree orgTree ON received.FOrgTreeID  = orgTree.FID ");
        builder.append(" INNER JOIN T_ORG_BaseUnit baseUnit ON cslRpt.FOrgUnitID = baseUnit.FID ");
        builder.append("  LEFT JOIN T_CSL_ItemDataYearInit itemDataYearInit ON ");
        builder.append(" ((itemDataYearInit.FORGTREEID is not null and itemDataYearInit.FOrgUnitNumber=baseUnit.fnumber and itemDataYearInit.FOrgTreeNumber=orgTree.fnumber ");
        builder.append("   or itemDataYearInit.FORGTREEID is null and itemDataYearInit.FOrgUnitID=cslRpt.ForgUnitID) and ");
        builder.append(" itemDataYearInit.FYear = cslRpt.FYear and ");
        builder.append(" itemDataYearInit.FItemID=rptItem.FID AND itemDataYearInit.FCurrencyID=cslRpt.FCurrencyID AND ");
        builder.append(" itemDataYearInit.FDataElement=itemList.FDataElement and itemDataYearInit.FValueType=itemList.FValueType");
        builder.append(" AND itemDataYearInit.FMergeType=(CASE WHEN cslRpt.FSourceType=34 THEN 1 ELSE 0 END)) ");
        builder.append(" WHERE itemList.FItemFormula LIKE '=Item%' AND cslRpt.FId=?", (Object)reportID);
        builder.append("   AND itemList.FDataElement=? ", (Object)dataElement);
        builder.append("   AND itemList.FValueType <> 3");
        builder.append(" ORDER BY rptItem.FNumber");
        ArrayList<Object> alParams = new ArrayList<Object>();
        alParams.add(reportID);
        alParams.add(new Integer(dataElement));
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)builder.getSQL(), (Object[])builder.getParams());
        HashMap<String, Object> rowMap = null;
        returnList = new ArrayList();
        try {
            while (rowSet.next()) {
                int index = 0;
                rowMap = new HashMap<String, Object>(32);
                rowMap.put("RptItemNumber", rowSet.getString(++index));
                rowMap.put("RptItemName", rowSet.getString(++index));
                rowMap.put("Year", new Integer(rowSet.getInt(++index)));
                rowMap.put("Period", new Integer(rowSet.getInt(++index)));
                rowMap.put("CurrencyName", rowSet.getString(++index));
                rowMap.put("Debit", rowSet.getBigDecimal(++index));
                rowMap.put("Credit", rowSet.getBigDecimal(++index));
                rowMap.put("DataElement", new Integer(rowSet.getInt(++index)));
                rowMap.put("ValueType", new Integer(rowSet.getInt(++index)));
                rowMap.put("OrgTreeName", rowSet.getString(++index));
                rowMap.put("RptItemSheetID", rowSet.getString(++index));
                rowMap.put("RptItemPosX", new Integer(rowSet.getInt(++index)));
                rowMap.put("RptItemPosY", new Integer(rowSet.getInt(++index)));
                rowMap.put("RptItemDC", new Integer(rowSet.getInt(++index)));
                rowMap.put("OrgTreeID", rowSet.getString(++index));
                rowMap.put("RptItemID", rowSet.getString(++index));
                rowMap.put("OrgUnitID", rowSet.getString(++index));
                rowMap.put("OrgUnitDisplayName", rowSet.getString(++index));
                rowMap.put("CurrencyID", rowSet.getString(++index));
                rowMap.put("RptSourceType", new Integer(rowSet.getInt(++index)));
                rowMap.put("srcCurrencyId", rowSet.getString(++index));
                rowMap.put("srcCurrencyName", rowSet.getString(++index));
                rowMap.put("ReportID", reportID);
                rowMap.put("OrgTreeNumber", rowSet.getString(++index));
                rowMap.put("OrgUnitNumber", rowSet.getString(++index));
                returnList.add(rowMap);
            }
        }
        catch (SQLException ex) {
            rowSet = null;
            logger.error((Object)"getRptItemInfoByReportID_SQLException", (Throwable)ex);
            throw new BOSException("SQL EXECUTE ERROR IN MaintainYearInitDataFacadeControllerBean's _getRptItemInfoByReportID");
        }
        return returnList;
    }

    @Override
    protected boolean _updateItemDataYearInit(Context ctx, List valueList) throws BOSException {
        Map record;
        boolean isOk = false;
        if (valueList == null || valueList.size() == 0) {
            return false;
        }
        ArrayList insertObjectList = new ArrayList(valueList.size());
        ArrayList<Map> updateObjectList = new ArrayList<Map>(valueList.size());
        ArrayList<Map> newInsertList = new ArrayList<Map>(valueList.size());
        ArrayList param = new ArrayList();
        IItemDataYearInit yearInit = ItemDataYearInitFactory.getLocalInstance(ctx);
        StringBuilder builder = new StringBuilder();
        StringBuffer oql = new StringBuffer();
        String orgTreeNumber = null;
        String orgUnitNumber = null;
        for (int i = 0; i < valueList.size(); ++i) {
            record = (Map)valueList.get(i);
            FilterInfo filter = new FilterInfo();
            orgTreeNumber = (String)record.get("OrgTreeNumber");
            orgUnitNumber = (String)record.get("OrgUnitNumber");
            if (!StringUtils.isEmpty((String)orgTreeNumber)) {
                filter.getFilterItems().add(new FilterItemInfo("orgTreeNumber", (Object)orgTreeNumber));
                filter.getFilterItems().add(new FilterItemInfo("orgUnitNumber", (Object)orgUnitNumber));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", record.get("OrgUnitID")));
                if (i == 0) {
                    param.add(record.get("OrgUnitID"));
                }
            }
            filter.getFilterItems().add(new FilterItemInfo("year", record.get("Year")));
            if (i == 0) {
                param.add(record.get("Year"));
            }
            filter.getFilterItems().add(new FilterItemInfo("item.id", record.get("RptItemID")));
            filter.getFilterItems().add(new FilterItemInfo("currency.id", record.get("CurrencyID")));
            if (i == 0) {
                param.add(record.get("CurrencyID"));
            }
            filter.getFilterItems().add(new FilterItemInfo("sourceCurrency.Id", record.get("srcCurrencyId")));
            if (i == 0) {
                param.add(record.get("srcCurrencyId"));
            }
            filter.getFilterItems().add(new FilterItemInfo("valueType", record.get("ValueType")));
            if (record.get("MergeType") != null) {
                filter.getFilterItems().add(new FilterItemInfo("mergeType", record.get("MergeType")));
            }
            try {
                if (StringUtils.isEmpty((String)orgTreeNumber)) {
                    newInsertList.add(record);
                    continue;
                }
                if (yearInit.exists(filter)) {
                    updateObjectList.add(record);
                    continue;
                }
                if (this.hasSuchObject(record, insertObjectList)) continue;
                insertObjectList.add(record);
                continue;
            }
            catch (EASBizException e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (newInsertList.size() > 0) {
            builder = new StringBuilder();
            builder.append("Delete From T_CSL_ItemDataYearInit Where FOrgUnitID = ? And FYear = ? And FCurrencyID = ? And FSourceCurrencyID = ? \n");
            DbUtil.execute((Context)ctx, (String)builder.toString(), (Object[])param.toArray());
        }
        try {
            Timestamp tsNow = new Timestamp(System.currentTimeMillis());
            BOSObjectType bosType = new ItemDataYearInitInfo().getBOSType();
            Integer mergeType = 0;
            if (insertObjectList.size() > 0 || newInsertList.size() > 0) {
                if (newInsertList.size() > 0) {
                    insertObjectList.addAll(newInsertList);
                }
                builder.setLength(0);
                builder.append("INSERT INTO T_CSL_ItemDataYearInit(");
                builder.append("FID,");
                if (!StringUtils.isEmpty((String)orgTreeNumber)) {
                    builder.append("FOrgTreeID,forgTreeNumber,Forgunitnumber,");
                }
                builder.append("FOrgUnitID,FYear,FItemID,FCurrencyID,FSourceCurrencyID,FDataElement,FValueType,");
                builder.append("FDebit,FCredit,FConvertStatus,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,");
                builder.append("FControlUnitID,Fperiod,FMergeType)");
                builder.append(" VALUES(?,");
                if (!StringUtils.isEmpty((String)orgTreeNumber)) {
                    builder.append("?,?,?,");
                }
                builder.append("?,?,?,?,?,5,?,");
                builder.append("?,?,?,?,?,?,?,?,?,?)");
                ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
                for (int i = 0; i < insertObjectList.size(); ++i) {
                    record = (HashMap)insertObjectList.get(i);
                    ArrayList<Object> p = new ArrayList<Object>();
                    p.add(BOSUuid.create((String)bosType.toString()).toString());
                    if (!StringUtils.isEmpty((String)orgTreeNumber)) {
                        p.add(record.get("OrgTreeID"));
                        p.add(record.get("OrgTreeNumber"));
                        p.add(record.get("OrgUnitNumber"));
                    }
                    p.add(record.get("OrgUnitID"));
                    p.add(record.get("Year"));
                    p.add(record.get("RptItemID"));
                    p.add(record.get("CurrencyID"));
                    p.add(record.get("srcCurrencyId"));
                    p.add(record.get("ValueType"));
                    if (record.get("Debit") != null && record.get("Debit") instanceof BigDecimal) {
                        p.add(record.get("Debit"));
                    } else {
                        p.add(null);
                    }
                    if (record.get("Credit") != null && record.get("Credit") instanceof BigDecimal) {
                        p.add(record.get("Credit"));
                    } else {
                        p.add(null);
                    }
                    if (record.get("CurrencyID") != null && record.get("CurrencyID").equals(record.get("srcCurrencyId"))) {
                        p.add(0);
                    } else {
                        p.add(1);
                    }
                    p.add(record.get("CurrentUserID"));
                    p.add(tsNow);
                    p.add(record.get("CurrentUserID"));
                    p.add(tsNow);
                    p.add(record.get("ControlUnitID"));
                    p.add(record.get("Period"));
                    p.add(record.get("MergeType") != null ? (Integer)record.get("MergeType") : mergeType);
                    paramsList.add(p.toArray());
                }
                DbUtil.executeBatch((Context)ctx, (String)builder.toString(), paramsList);
            }
            if (updateObjectList.size() > 0) {
                StringBuffer sql = new StringBuffer();
                sql.append("UPDATE T_CSL_ItemDataYearInit SET FDebit=?,FCredit=?,FLastUpdateUserID=?,FLastUpdateTime=?, Fperiod = ? ");
                sql.append("WHERE FOrgTreeNumber =? and FOrgUnitNumber=? AND FYear=? AND FItemID=? AND FCurrencyID=? AND FSourceCurrencyID=?  AND FDataElement=5 ");
                sql.append(" AND FValueType=? AND fMergeType=?");
                StringBuffer sql2 = new StringBuffer();
                sql2.append("UPDATE T_CSL_ItemDataYearInit SET FDebit=?,FCredit=?,FLastUpdateUserID=?,FLastUpdateTime=?, Fperiod = ? ");
                sql2.append("WHERE  FOrgUnitID=? AND FYear=? AND FItemID=? AND FCurrencyID=? AND FSourceCurrencyID=?  AND FDataElement=5 ");
                sql2.append(" AND FValueType=? AND fMergeType=?");
                ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
                ArrayList<Object[]> paramsList2 = new ArrayList<Object[]>();
                for (int i = 0; i < updateObjectList.size(); ++i) {
                    ArrayList<Object> p = new ArrayList<Object>();
                    record = (HashMap)updateObjectList.get(i);
                    if (record.get("Debit") != null && record.get("Debit") instanceof BigDecimal) {
                        p.add(record.get("Debit"));
                    } else {
                        p.add(null);
                    }
                    if (record.get("Credit") != null && record.get("Credit") instanceof BigDecimal) {
                        p.add(record.get("Credit"));
                    } else {
                        p.add(null);
                    }
                    p.add(record.get("CurrentUserID"));
                    p.add(tsNow);
                    p.add(record.get("Period"));
                    if (record.get("OrgTreeID") != null) {
                        p.add(record.get("OrgTreeNumber"));
                        p.add(record.get("OrgUnitNumber"));
                    } else {
                        p.add(record.get("OrgUnitID"));
                    }
                    p.add(record.get("Year"));
                    p.add(record.get("RptItemID"));
                    p.add(record.get("CurrencyID"));
                    p.add(record.get("srcCurrencyId"));
                    p.add(record.get("ValueType"));
                    p.add(record.get("MergeType") != null ? (Integer)record.get("MergeType") : mergeType);
                    if (record.get("OrgTreeID") != null) {
                        paramsList.add(p.toArray());
                        continue;
                    }
                    paramsList2.add(p.toArray());
                }
                if (paramsList.size() > 0) {
                    DbUtil.executeBatch((Context)ctx, (String)sql.toString(), paramsList);
                }
                if (paramsList2.size() > 0) {
                    DbUtil.executeBatch((Context)ctx, (String)sql2.toString(), paramsList2);
                }
            }
            isOk = true;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return isOk;
    }

    @Override
    protected int _existYearInitData(Context ctx, List reportIDList, OrgTreeInfo orgTreeInfo) throws BOSException {
        int period = 0;
        if (reportIDList == null) {
            logger.debug((Object)"-----Error reportIDList is null-----");
            return 0;
        }
        Iterator reportIDIt = reportIDList.iterator();
        while (reportIDIt.hasNext() && (period = this._existYearInitData(ctx, (String)reportIDIt.next(), orgTreeInfo)) <= 0) {
        }
        return period;
    }

    @Override
    protected int _existYearInitData(Context ctx, String reportID, OrgTreeInfo orgTreeInfo) throws BOSException {
        int period = 0;
        if (reportID == null) {
            reportID = "";
            logger.debug((Object)"-----Error reportID is null-----");
            return 0;
        }
        ArrayList<Object> alParams = new ArrayList<Object>();
        StringBuffer sqlSB = new StringBuffer();
        sqlSB.append(" SELECT top 1 itemDataYearInit.fperiod FROM t_csl_cslreport cslRpt ");
        sqlSB.append(" INNER JOIN T_RPT_Template template ON cslRpt.FTemplateID=template.FID ");
        sqlSB.append(" INNER JOIN T_RPT_Template grpTpl ON (template.fid = grpTpl.Fid or template.fgrouptemplateid = grpTpl.fid) ");
        sqlSB.append(" INNER JOIN T_CSL_TempletItemList itemList ON grpTpl.FID=itemList.FTemplateID ");
        sqlSB.append(" INNER JOIN T_CSL_rptItem rptItem ON itemList.FItemNumber=RptItem.FNumber ");
        sqlSB.append(" INNER JOIN T_CSL_RptReceived rptReceived ON rptReceived.FReportID=cslRpt.FID  ");
        sqlSB.append(" INNER JOIN t_org_tree tree ON tree.fid=rptReceived.forgTreeId  ");
        sqlSB.append(" INNER JOIN T_BD_Currency currency ON cslRpt.FCurrencyID=currency.FID ");
        sqlSB.append(" INNER JOIN T_ORG_BaseUnit baseUnit ON cslRpt.FOrgUnitID=baseUnit.FID ");
        sqlSB.append(" INNER JOIN T_CSL_ItemDataYearInit itemDataYearInit ON ");
        sqlSB.append(" ((itemDataYearInit.FORGTREEID is null and itemDataYearInit.FOrgUnitID=cslRpt.ForgUnitID or  ");
        sqlSB.append(" itemDataYearInit.FORGTREEID is not null and itemDataYearInit.fOrgTreeNumber=tree.fnumber and itemDataYearInit.forgunitnumber=baseUnit.fnumber )  ");
        sqlSB.append(" and itemDataYearInit.FYear=cslRpt.FYear+1 and  ");
        sqlSB.append(" itemDataYearInit.FItemID=rptItem.FID and itemDataYearInit.FCurrencyID=cslRpt.FCurrencyID and ");
        sqlSB.append(" itemDataYearInit.FValueType=itemList.FValueType) ");
        sqlSB.append(" WHERE itemList.FItemFormula like '=Item%' and ");
        sqlSB.append(" cslRpt.FID=? and itemList.FDataElement=? and itemDataYearInit.FDataElement = ? ");
        alParams.add(reportID);
        alParams.add(new Integer(4));
        alParams.add(new Integer(5));
        if (orgTreeInfo != null) {
            sqlSB.append(" and itemDataYearInit.FOrgTreeID=?");
            alParams.add(orgTreeInfo.getId().toString());
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlSB.toString(), (Object[])alParams.toArray());
        try {
            if (rowSet.next()) {
                period = rowSet.getInt(1);
            }
        }
        catch (SQLException ex) {
            rowSet = null;
            throw new BOSException("SQL EXECUTE ERROR IN MaintainYearInitDataFacadeControllerBean's _updateItemDataYearInit");
        }
        return period;
    }

    @Override
    protected List _getCellValueFromYearInitDataByReportIDList(Context ctx, List reportIDList) throws BOSException {
        ArrayList returnList = null;
        if (reportIDList == null) {
            logger.debug((Object)"-----Error reportIDList is null-----");
            return null;
        }
        returnList = new ArrayList();
        Iterator reportIDIt = reportIDList.iterator();
        while (reportIDIt.hasNext()) {
            returnList.addAll(this._getCellValueFromYearInitDataByReportID(ctx, (String)reportIDIt.next()));
        }
        return returnList;
    }

    @Override
    protected List _getCellValueFromYearInitDataByReportID(Context ctx, String reportID) throws BOSException {
        ArrayList returnList = null;
        if (reportID == null) {
            reportID = "";
            logger.debug((Object)"-----Error reportID is null-----");
        }
        CSLServerHelper serverHelper = new CSLServerHelper(ctx);
        this.lan = serverHelper.getFieldNameExtend();
        StringBuffer sqlSB = new StringBuffer();
        sqlSB.append(" SELECT rptItem.FNumber,itemDataYearInit.FDebit,itemDataYearInit.FCredit,currency.FPrecision,itemList.FSheetID,itemList.FPosX,itemList.FPosY,rptItem.FDC,itemList.FItemFormula ");
        sqlSB.append(" FROM t_csl_cslreport cslRpt ");
        sqlSB.append(" INNER JOIN T_RPT_Template template ON cslRpt.FTemplateID=template.FID ");
        sqlSB.append(" INNER JOIN T_RPT_Template grpTpl ON (template.fid = grpTpl.Fid or template.fgrouptemplateid = grpTpl.fid) ");
        sqlSB.append(" INNER JOIN T_CSL_TempletItemList itemList ON grpTpl.FID=itemList.FTemplateID ");
        sqlSB.append(" INNER JOIN T_CSL_rptItem rptItem ON itemList.FItemNumber=RptItem.FNumber ");
        sqlSB.append(" INNER JOIN T_BD_Currency currency ON cslRpt.FCurrencyID=currency.FID ");
        sqlSB.append(" INNER JOIN T_CSL_RptReceived rptReceived ON rptReceived.FReportID=cslRpt.FID  ");
        sqlSB.append(" INNER JOIN t_org_tree tree ON tree.fid=rptReceived.forgTreeId  ");
        sqlSB.append(" INNER JOIN T_ORG_BaseUnit baseUnit ON cslRpt.FOrgUnitID=baseUnit.FID ");
        sqlSB.append(" INNER JOIN T_CSL_ItemDataYearInit itemDataYearInit ON ");
        sqlSB.append(" ((itemDataYearInit.FORGTREEID is null and itemDataYearInit.FOrgUnitID=cslRpt.ForgUnitID or  ");
        sqlSB.append(" itemDataYearInit.FORGTREEID is not null and itemDataYearInit.fOrgTreeNumber=tree.fnumber and itemDataYearInit.forgunitnumber=baseUnit.fnumber )  ");
        sqlSB.append("  and itemDataYearInit.FYear=cslRpt.FYear and ");
        sqlSB.append(" itemDataYearInit.FItemID=rptItem.FID and itemDataYearInit.FCurrencyID=cslRpt.FCurrencyID and ");
        sqlSB.append(" itemDataYearInit.FDataElement=itemList.FDataElement and itemDataYearInit.FValueType=itemList.FValueType and itemDataYearInit.fsourcecurrencyid=cslRpt.fsourcecurrencyid)");
        sqlSB.append(" WHERE itemList.FItemFormula like '=Item%' and ");
        sqlSB.append(" cslRpt.FID=? and itemList.FDataElement=5");
        sqlSB.append(" ORDER BY itemDataYearInit.FLASTUPDATETIME DESC");
        ArrayList<String> alParams = new ArrayList<String>();
        alParams.add(reportID);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlSB.toString(), (Object[])alParams.toArray());
        HashMap<String, Object> rowMap = null;
        returnList = new ArrayList();
        try {
            String itemNumber = null;
            String sheetID = null;
            String key = null;
            HashSet<String> set = new HashSet<String>(9);
            while (rowSet.next()) {
                itemNumber = rowSet.getString(1);
                sheetID = rowSet.getString(5);
                int posX = rowSet.getInt(6);
                int posY = rowSet.getInt(7);
                key = new StringBuffer(itemNumber).append(sheetID).append(posX).append(posY).toString();
                if (set.contains(key)) continue;
                set.add(key);
                rowMap = new HashMap<String, Object>(16);
                rowMap.put("RptItemNumber", itemNumber);
                rowMap.put("Debit", rowSet.getBigDecimal(2));
                rowMap.put("Credit", rowSet.getBigDecimal(3));
                rowMap.put("CurrencyPrecision", new Integer(rowSet.getInt(4)));
                rowMap.put("RptItemSheetID", sheetID);
                rowMap.put("RptItemPosX", new Integer(posX));
                rowMap.put("RptItemPosY", new Integer(posY));
                rowMap.put("RptItemDC", new Integer(rowSet.getInt(8)));
                rowMap.put("itemFormula", rowSet.getString(9));
                returnList.add(rowMap);
            }
            set.clear();
        }
        catch (SQLException ex) {
            rowSet = null;
            throw new BOSException("SQL EXECUTE ERROR IN MaintainYearInitDataFacadeControllerBean's _getCellValueFromYearInitData");
        }
        return returnList;
    }

    private boolean hasSuchObject(Map objectMap, List existedObjectList) {
        boolean hasSuchObject = false;
        Iterator existedObjectIt = existedObjectList.iterator();
        HashMap existedObjectMap = null;
        while (existedObjectIt.hasNext()) {
            existedObjectMap = (HashMap)existedObjectIt.next();
            if (objectMap.get("OrgTreeID") != null && !((String)objectMap.get("OrgTreeID")).equals((String)existedObjectMap.get("OrgTreeID")) || !((String)objectMap.get("OrgUnitID")).equals((String)existedObjectMap.get("OrgUnitID")) || !((String)objectMap.get("CurrencyID")).equals((String)existedObjectMap.get("CurrencyID")) || objectMap.get("RptItemSheetID") != null && !((String)objectMap.get("RptItemSheetID")).equals((String)existedObjectMap.get("RptItemSheetID")) || !((String)objectMap.get("RptItemID")).equals((String)existedObjectMap.get("RptItemID")) || ((Integer)objectMap.get("Year")).intValue() != ((Integer)existedObjectMap.get("Year")).intValue() || ((Integer)objectMap.get("ValueType")).intValue() != ((Integer)existedObjectMap.get("ValueType")).intValue()) continue;
            hasSuchObject = true;
        }
        return hasSuchObject;
    }

    @Override
    protected List _getCellValueFromYearInitDataByTemplateID(Context ctx, String templateID, String orgUnitID, String currencyID, int year) throws BOSException {
        ArrayList returnList = null;
        if (templateID == null) {
            templateID = "";
            logger.debug((Object)"-----Error reportID is null-----");
        }
        CSLServerHelper serverHelper = new CSLServerHelper(ctx);
        this.lan = serverHelper.getFieldNameExtend();
        StringBuffer sqlSB = new StringBuffer();
        sqlSB.append(" SELECT rptItem.FNumber,itemDataYearInit.FDebit,itemDataYearInit.FCredit,currency.FPrecision,itemList.FSheetID,itemList.FPosX,itemList.FPosY,rptItem.FDC,itemList.FItemFormula itemFormula ");
        sqlSB.append(" FROM T_RPT_Template template ");
        sqlSB.append(" INNER JOIN T_CSL_TempletItemList itemList ON (template.FID=itemList.FTemplateID  or  template.fgrouptemplateid=itemList.FTemplateID) ");
        sqlSB.append(" INNER JOIN T_CSL_rptItem rptItem ON itemList.FItemNumber=RptItem.FNumber ");
        sqlSB.append(" INNER JOIN T_CSL_ItemDataYearInit itemDataYearInit ON ");
        sqlSB.append(" (itemDataYearInit.FItemID=rptItem.FID and  itemDataYearInit.FDataElement=itemList.FDataElement and  ");
        sqlSB.append(" itemDataYearInit.FValueType=itemList.FValueType) ");
        sqlSB.append(" INNER JOIN T_BD_Currency currency ON itemDataYearInit.FCurrencyID=currency.FID ");
        sqlSB.append(" WHERE itemList.FItemFormula like '=Item%' and ");
        sqlSB.append(" template.FID=? and itemList.FDataElement=5 and ");
        sqlSB.append(" itemDataYearInit.FOrgUnitID=? and itemDataYearInit.FCurrencyID=? and ");
        sqlSB.append(" itemDataYearInit.FYear=? ");
        sqlSB.append(" ORDER BY itemDataYearInit.FLASTUPDATETIME DESC");
        ArrayList<Object> alParams = new ArrayList<Object>();
        alParams.add(templateID);
        alParams.add(orgUnitID);
        alParams.add(currencyID);
        alParams.add(year);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlSB.toString(), (Object[])alParams.toArray());
        HashMap<String, Object> rowMap = null;
        returnList = new ArrayList();
        try {
            String itemNumber = null;
            String sheetID = null;
            String key = null;
            HashSet<String> set = new HashSet<String>(8);
            while (rowSet.next()) {
                itemNumber = rowSet.getString(1);
                sheetID = rowSet.getString(5);
                int posX = rowSet.getInt(6);
                int posY = rowSet.getInt(7);
                key = new StringBuffer(itemNumber).append(sheetID).append(posX).append(posY).toString();
                if (set.contains(key)) continue;
                set.add(key);
                rowMap = new HashMap<String, Object>(16);
                rowMap.put("RptItemNumber", itemNumber);
                rowMap.put("Debit", rowSet.getBigDecimal(2));
                rowMap.put("Credit", rowSet.getBigDecimal(3));
                rowMap.put("CurrencyPrecision", new Integer(rowSet.getInt(4)));
                rowMap.put("RptItemSheetID", sheetID);
                rowMap.put("RptItemPosX", new Integer(posX));
                rowMap.put("RptItemPosY", new Integer(posY));
                rowMap.put("RptItemDC", new Integer(rowSet.getInt(8)));
                rowMap.put("itemFormula", rowSet.getString("itemFormula"));
                returnList.add(rowMap);
            }
            set.clear();
        }
        catch (SQLException ex) {
            rowSet = null;
            throw new BOSException("SQL EXECUTE ERROR IN MaintainYearInitDataFacadeControllerBean's _getCellValueFromYearInitData");
        }
        return returnList;
    }

    @Override
    protected List _getNextYearOrgUnit(Context ctx, String orgTreeID, String orgUnitID, int nextYear) throws BOSException {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, nextYear);
        Date startDate = calendar.getTime();
        String startDateSql = CslRptUtil.formatDateForSql(startDate);
        calendar.set(1, nextYear + 1);
        Date endDate = calendar.getTime();
        String endDateSql = CslRptUtil.formatDateForSql(endDate);
        String isunionSql = "select fid from t_org_baseunit where fid=? and FISUNION = 1";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)isunionSql, (Object[])new Object[]{orgUnitID});
        try {
            if (!rowSet.next()) {
                return null;
            }
        }
        catch (SQLException e) {
            rowSet = null;
            throw new BOSException("SQL EXECUTE ERROR IN MaintainYearInitDataFacadeControllerBean's _getNextYearOrgUnit");
        }
        StringBuilder sql = new StringBuilder();
        sql.append("select unit.fid unitid from t_org_structure str join t_org_tree tree on str.ftreeid=tree.fid \n");
        sql.append("join t_org_baseunit unit on str.funitid=unit.fid \n");
        sql.append("join t_org_tree oldTree on tree.fnumber=oldtree.fnumber \n");
        sql.append("join t_org_baseunit oldunit on oldunit.fnumber=unit.fnumber and oldunit.FISUNION=unit.FISUNION \n");
        sql.append("where oldtree.fid=? \n");
        sql.append("and oldunit.fid=? \n");
        sql.append("and tree.FSTARTDATE>=" + startDateSql + " and (tree.FENDDATE is null or tree.FENDDATE <" + endDateSql + ") \n");
        Object[] param = new Object[]{orgTreeID, orgUnitID};
        ArrayList<String> returnList = new ArrayList<String>();
        rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
        try {
            while (rowSet.next()) {
                returnList.add(rowSet.getString("unitid"));
            }
        }
        catch (SQLException e) {
            rowSet = null;
            throw new BOSException("SQL EXECUTE ERROR IN MaintainYearInitDataFacadeControllerBean's _getNextYearOrgUnit");
        }
        return returnList;
    }
}

