/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.variant.Util;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.AdjustStatusEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ElimTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.IRPTInterItemData;
import com.kingdee.eas.fi.gr.cslrpt.InterTradeServerUtils;
import com.kingdee.eas.fi.gr.cslrpt.RPTInterItemDataFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTInterItemDataInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.AbstractRPTExchItemDataControllerBean;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.dynamic.DynaItemTypeEnum;
import com.kingdee.eas.fi.gr.fast.FastMergeSoluInfo;
import com.kingdee.eas.fi.gr.fast.util.FastMergeUtil;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class RPTExchItemDataControllerBean
extends AbstractRPTExchItemDataControllerBean {
    private static final int HASCHECKED = 1;
    private static final int BASEDATA = 2;
    private static final int CANDELETE = 0;
    private static final int NOTCURGROUP = 3;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.cslrpt.app.RPTExchItemDataControllerBean");

    @Override
    protected Map _getImportData(Context ctx, Map params) throws BOSException, EASBizException {
        OrgTreeInfo orgTree = (OrgTreeInfo)params.get("KeyOrgTree");
        OrgUnitInfo orgUnit = (OrgUnitInfo)params.get("KeyOrgUnit");
        int year = (Integer)params.get("Year");
        int period = (Integer)params.get("Period");
        int periodType = (Integer)params.get("PeriodType");
        int mergeMode = (Integer)params.get("MERGETYPE");
        String currencyId = (String)params.get("KEY_CURRENCY_ID");
        String dataCollectNumber = (String)params.get("dataCollectNumber");
        String fastMergeSoluId = (String)params.get("fastMergeSoluId");
        boolean isUnReceive = false;
        if (params.get("isUnReceive") != null && params.get("isUnReceive") instanceof Boolean) {
            isUnReceive = (Boolean)params.get("isUnReceive");
        }
        boolean isGetReportIDs = params.get("ISGETREPORTIDS") == null ? false : (Boolean)params.get("ISGETREPORTIDS");
        String reportsStr = null;
        String tmplName = null;
        HashMap result = new HashMap();
        boolean[] booleans = CSLParamUtil.batchGetParam(ctx, new String[]{"GR_CSL_OnlyImportDynaDataOfCurrentUnit", "GR_CSL_MImportDyna"});
        boolean isOnlyImportDynaDataOfCurrentUnit = booleans[0];
        boolean isCrossImportDynaData = booleans[1];
        if (isGetReportIDs) {
            String[] str = CslRptUtil.getAllGroupNormalReportsUsedTmplTbl(ctx, orgTree, orgUnit, currencyId, mergeMode, year, period, periodType, fastMergeSoluId, isUnReceive);
            if (str == null) {
                return result;
            }
            tmplName = str[0];
            reportsStr = str[1];
        } else {
            Set idsSet = ((Map)params.get("ReportData")).keySet();
            ArrayList reportIds = new ArrayList(idsSet);
            StringBuffer tmp = new StringBuffer();
            for (int i = 0; i < reportIds.size(); ++i) {
                tmp.append("'").append(reportIds.get(i)).append("',");
            }
            if (tmp.length() > 0) {
                reportsStr = tmp.substring(0, tmp.length() - 1);
            } else {
                return result;
            }
        }
        StringBuffer sql = new StringBuffer();
        sql.append(this.getDynaNormalReportExchItemDataSql(params, isGetReportIDs, reportsStr));
        if (orgUnit.isIsGrouping() && isOnlyImportDynaDataOfCurrentUnit && !isCrossImportDynaData) {
            sql.append(" union \n");
            sql.append(this.getDynaCslReportExchItemDataSql(ctx, params, isGetReportIDs, reportsStr));
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rowSet.next()) {
                this.wrapperMapData(rowSet, result, isGetReportIDs);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            if (tmplName != null) {
                TempTablePool.getInstance((Context)ctx).releaseTable(tmplName);
            }
        }
        return result;
    }

    private String getDynaNormalReportExchItemDataSql(Map params, boolean isGetReportIDs, String reportsStr) {
        StringBuffer sql = new StringBuffer(1000);
        boolean isFilterTmpNumber = params.get("templateNumbers") != null;
        StringBuffer numbers = new StringBuffer();
        String nms = "";
        if (isFilterTmpNumber) {
            Set numberSet = (Set)params.get("templateNumbers");
            Iterator it = numberSet.iterator();
            while (it.hasNext()) {
                numbers.append("'" + it.next() + "',");
            }
        }
        if (numbers.length() > 0) {
            nms = numbers.substring(0, numbers.length() - 1);
        }
        String dataCollectNumber = (String)params.get("dataCollectNumber");
        OrgTreeInfo orgTree = (OrgTreeInfo)params.get("KeyOrgTree");
        sql.append(this.getSelectSql(isGetReportIDs, false));
        sql.append(" from t_csl_dynaItemData a");
        sql.append(" left join t_csl_cslreport report");
        sql.append(" on report.fid = a.FReportId");
        sql.append(" inner join t_csl_dynaItemDataEntry b");
        sql.append(" on a.FId = b.FItemDataId");
        sql.append(" inner join t_csl_rptItem i");
        sql.append(" on b.FItemId = i.FNumber");
        if (isFilterTmpNumber) {
            sql.append(" INNER JOIN T_CSL_CslReport cslrpt ON cslrpt.FId = a.FReportId");
            sql.append(" INNER JOIN T_RPT_Template tmp ON tmp.FId = cslrpt.FTemplateId");
        }
        sql.append(" inner join (");
        sql.append("select distinct entry.FItemId, entry.FDataElement from t_csl_elimTemplet e");
        sql.append(" inner join t_csl_elimTempletentry entry on e.FId = entry.FTempletId");
        sql.append(" where e.FElimType = ").append(this.getElimType().getValue());
        sql.append(") t on i.FId = t.FItemId and b.FDataElement = t.FDataElement");
        sql.append(" where a.FReportId in (").append(reportsStr).append(")");
        sql.append(" and a.FDataCollectNumber = '").append(dataCollectNumber).append("'");
        if (orgTree.getLayerType().equals((Object)OrgViewType.PROFITCENTER)) {
            sql.append(" and b.FDynaItemType in (1, 2, 3, 10)");
        } else {
            sql.append(" and b.FDynaItemType in (1, 2, 3)");
        }
        if (isFilterTmpNumber) {
            sql.append(" and tmp.FNumber IN (").append(nms).append(")");
        }
        sql.append(" and i.FId not in (select distinct FDynaItemId from t_csl_dynaItem2ElimItem)");
        sql.append(" and b.FValue !=0 and b.FValue is not null ");
        sql.append(" and a.FDynaType = 1 ");
        sql.append(" and a.FDataSource = 10");
        sql.append(" union \r\n");
        sql.append(this.getSelectSql(isGetReportIDs, true));
        sql.append(" from t_csl_dynaItemData a");
        sql.append(" inner join t_csl_dynaItemDataEntry b");
        sql.append(" on a.FId = b.FItemDataId");
        if (isFilterTmpNumber) {
            sql.append(" INNER JOIN T_CSL_CslReport cslrpt ON cslrpt.FId = a.FReportId");
            sql.append(" INNER JOIN T_RPT_Template tmp ON tmp.FId = cslrpt.FTemplateId");
        }
        sql.append(" inner join t_csl_rptItem i");
        sql.append(" on b.FItemId = i.FNumber");
        sql.append(" inner join t_csl_dynaItem2ElimItem d2e");
        sql.append(" on i.FId = d2e.FDynaItemId");
        sql.append(" inner join (");
        sql.append("select distinct entry.FItemId, entry.FDataElement from t_csl_elimTemplet e");
        sql.append(" inner join t_csl_elimTempletentry entry on e.FId = entry.FTempletId");
        sql.append(" where e.FElimType = ").append(this.getElimType().getValue());
        sql.append(") t on d2e.FElimItemId = t.FItemId and b.FDataElement = t.FDataElement");
        sql.append(" inner join t_csl_rptItem i2");
        sql.append(" on t.FItemId = i2.FId");
        sql.append(" where a.FReportId in (").append(reportsStr).append(")");
        sql.append(" and a.FDataCollectNumber = '").append(dataCollectNumber).append("'");
        if (orgTree.getLayerType().equals((Object)OrgViewType.PROFITCENTER)) {
            sql.append(" and b.FDynaItemType in (1, 2, 3, 10)");
        } else {
            sql.append(" and b.FDynaItemType in (1, 2, 3)");
        }
        if (isFilterTmpNumber) {
            sql.append(" and tmp.FNumber IN (").append(nms).append(")");
        }
        sql.append(" and b.FValue !=0 and b.FValue is not null ");
        sql.append(" and a.FDynaType = 1 ");
        sql.append(" and a.FDataSource = 10");
        sql.append(" group by a.FReportId, i2.FNumber, b.FKeyNumber, b.FKeyName, b.FDataElement, ");
        sql.append(" b.FValueType, b.FYear, b.FPeriod, b.FDynaItemType");
        return sql.toString();
    }

    private String getDynaCslReportExchItemDataSql(Context ctx, Map params, boolean isGetReportIDs, String reportsStr) throws EASBizException, BOSException {
        boolean isFilterTmpNumber = params.get("templateNumbers") != null;
        StringBuffer numbers = new StringBuffer();
        String nms = "";
        if (isFilterTmpNumber) {
            Set numberSet = (Set)params.get("templateNumbers");
            Iterator it = numberSet.iterator();
            while (it.hasNext()) {
                numbers.append("'" + it.next() + "',");
            }
        }
        if (numbers.length() > 0) {
            nms = numbers.substring(0, numbers.length() - 1);
        }
        boolean isFilterCommitState = true;
        int sourceType = 12;
        String fastMergeSoluId = (String)params.get("fastMergeSoluId");
        boolean isUnReceive = false;
        if (params.get("isUnReceive") != null && params.get("isUnReceive") instanceof Boolean) {
            isUnReceive = (Boolean)params.get("isUnReceive");
        }
        if (!StringUtils.isEmpty((String)fastMergeSoluId) && isUnReceive) {
            isFilterCommitState = false;
            sourceType = 35;
        } else {
            isFilterCommitState = true;
            sourceType = 12;
        }
        StringBuffer sql = new StringBuffer(1000);
        int year = (Integer)params.get("Year");
        int period = (Integer)params.get("Period");
        int periodType = (Integer)params.get("PeriodType");
        String currencyId = (String)params.get("KEY_CURRENCY_ID");
        int mergeMode = (Integer)params.get("MERGETYPE");
        OrgTreeInfo orgTree = (OrgTreeInfo)params.get("KeyOrgTree");
        OrgUnitInfo orgUnit = (OrgUnitInfo)params.get("KeyOrgUnit");
        String mimport = ParamManager.getParamValue((Context)ctx, null, (String)"GR_CSL_MImportDyna");
        IOrgStructure iStruc = OrgStructureFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("tree.id", (Object)orgTree.getId()));
        filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)orgUnit.getId()));
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("*"));
        OrgStructureCollection structInfos = iStruc.getOrgStructureCollection(view);
        if (structInfos.size() == 0) {
            return "";
        }
        String StruParentId = structInfos.get(0).getId().toString();
        String unitLongNum = structInfos.get(0).getLongNumber();
        sql.append(this.getSelectSql(isGetReportIDs, false));
        sql.append(" from t_csl_dynaItemData a \n");
        sql.append(" inner join t_csl_cslreport report");
        sql.append(" on report.fid = a.FReportId");
        sql.append(" inner join t_rpt_template tmpl");
        sql.append(" on tmpl.FId = report.ftemplateid ");
        sql.append(" inner join t_csl_dynaItemDataEntry b");
        sql.append(" on a.FId = b.FItemDataId");
        sql.append(" inner join t_csl_rptItem i");
        sql.append(" on b.FItemId = i.FNumber");
        sql.append(" inner join (");
        sql.append("select distinct entry.FItemId, entry.FDataElement from t_csl_elimTemplet e");
        sql.append(" inner join t_csl_elimTempletentry entry on e.FId = entry.FTempletId");
        sql.append(" where e.FElimType = ").append(this.getElimType().getValue());
        sql.append(") t on i.FId = t.FItemId and b.FDataElement = t.FDataElement");
        sql.append(" where b.FDynaItemType in (0, 1, 2, 3, 10)");
        sql.append(" and i.FId not in (select distinct FDynaItemId from t_csl_dynaItem2ElimItem)");
        sql.append(" and b.FValue !=0 and b.FValue is not null ");
        sql.append(" and tmpl.FIsSupportInnerExch = 1 \n");
        sql.append(" and a.FDataSource = " + sourceType);
        sql.append(" and a.FOrgUnitId in (");
        sql.append(" select unit.fid from t_org_Structure s            \n");
        sql.append(" join t_org_BaseUnit unit on s.funitid = unit.fid  \n ");
        sql.append(" where s.ftreeid ='").append(orgTree.getId().toString()).append("' and unit.FisGrouping = 1");
        if (mergeMode == 1) {
            if ("true".equalsIgnoreCase(mimport)) {
                sql.append(" and s.flongnumber like'" + unitLongNum + "!%') \n");
            } else {
                sql.append(" and s.fparentId ='").append(StruParentId).append("')");
            }
        } else {
            sql.append(" and s.flongnumber like'" + unitLongNum + "!%') \n");
        }
        if (isFilterTmpNumber) {
            sql.append(" and tmpl.FNumber IN (").append(nms).append(")");
        }
        sql.append(" and b.FYear = " + year);
        sql.append(" and b.FPeriod = " + period);
        sql.append(" and a.FPeriodType = " + periodType);
        sql.append(" and a.FDynaType = 6 ");
        if (isFilterCommitState) {
            sql.append(" and a.FCommitStatus = 3 ");
        } else {
            sql.append(" AND report.FFastMergeSoluId = '").append(fastMergeSoluId).append("' \n");
        }
        if (!StringUtils.isEmpty((String)currencyId)) {
            sql.append(" and a.FCurrencyID = '" + currencyId + "'");
        }
        if (!isGetReportIDs) {
            sql.append(" and a.freportid in(" + reportsStr + ")");
        }
        sql.append(" union \r\n");
        sql.append(this.getSelectSql(isGetReportIDs, true));
        sql.append(" from t_csl_dynaItemData a \n");
        sql.append(" inner join t_csl_cslreport report");
        sql.append(" on report.fid = a.FReportId");
        sql.append(" inner join t_rpt_template tmpl");
        sql.append(" on tmpl.FId = report.ftemplateid ");
        sql.append(" inner join t_csl_dynaItemDataEntry b");
        sql.append(" on a.FId = b.FItemDataId");
        sql.append(" inner join t_csl_rptItem i");
        sql.append(" on b.FItemId = i.FNumber");
        sql.append(" inner join t_csl_dynaItem2ElimItem de");
        sql.append(" on i.FId = de.FDynaItemId");
        sql.append(" inner join (");
        sql.append("select distinct entry.FItemId, entry.FDataElement from t_csl_elimTemplet e");
        sql.append(" inner join t_csl_elimTempletentry entry on e.FId = entry.FTempletId");
        sql.append(" where e.FElimType = ").append(this.getElimType().getValue());
        sql.append(") t on de.FElimItemId = t.FItemId and b.FDataElement = t.FDataElement");
        sql.append(" inner join t_csl_rptItem i2");
        sql.append(" on t.FItemId = i2.FId");
        sql.append(" where b.FDynaItemType in (0, 1, 2, 3, 10) \n");
        sql.append(" and b.FValue !=0 and b.FValue is not null \n");
        sql.append(" and tmpl.FIsSupportInnerExch = 1 \n");
        sql.append(" and a.FDataSource = " + sourceType);
        sql.append(" and a.FOrgUnitId in (");
        sql.append(" select unit.fid from t_org_Structure s            \n");
        sql.append(" join t_org_BaseUnit unit on s.funitid = unit.fid  \n ");
        sql.append(" where s.ftreeid ='").append(orgTree.getId().toString()).append("' and unit.FisGrouping = 1");
        if (mergeMode == 1) {
            if ("true".equalsIgnoreCase(mimport)) {
                sql.append(" and s.flongnumber like'" + unitLongNum + "!%') \n");
            } else {
                sql.append(" and s.fparentId ='").append(StruParentId).append("')");
            }
        } else {
            sql.append(" and s.flongnumber like'" + unitLongNum + "!%') \n");
        }
        if (isFilterTmpNumber) {
            sql.append(" and tmpl.FNumber IN (").append(nms).append(")");
        }
        sql.append(" and b.FYear = " + year);
        sql.append(" and b.FPeriod = " + period);
        sql.append(" and a.FPeriodType = " + periodType);
        sql.append(" and a.FDynaType = 6 ");
        if (isFilterCommitState) {
            sql.append(" and a.FCommitStatus = 3 ");
        } else {
            sql.append(" AND report.FFastMergeSoluId = '").append(fastMergeSoluId).append("' \n");
        }
        if (!StringUtils.isEmpty((String)currencyId)) {
            sql.append(" and a.FCurrencyID = '" + currencyId + "'");
        }
        if (!isGetReportIDs) {
            sql.append(" and a.freportid in(" + reportsStr + ")");
        }
        sql.append(this.getGroupBySql(isGetReportIDs));
        return sql.toString();
    }

    private void wrapperMapData(IRowSet rowSet, Map result, boolean isGetReportIDs) throws SQLException {
        List<HashMap<String, Object>> itemData = null;
        if (isGetReportIDs) {
            String reportId = rowSet.getString("reportId");
            result.put(reportId, null);
        } else {
            HashMap<String, Object> data = new HashMap<String, Object>();
            String reportId = rowSet.getString("reportId");
            String itemId = rowSet.getString("FItemId");
            data.put("itemNumber", itemId);
            String keyNumber = rowSet.getString("FkeyNumber");
            data.put("ditemNumber", keyNumber);
            String keyName = rowSet.getString("FKeyName");
            data.put("ditemName", keyName);
            int dataElement = rowSet.getInt("FDataElement");
            data.put("dataElement", new Integer(dataElement));
            int valueType = rowSet.getInt("FValueType");
            data.put("valueType", new Integer(valueType));
            int fyear = rowSet.getInt("Fyear");
            data.put("year", new Integer(fyear));
            int fperiod = rowSet.getInt("FPeriod");
            data.put("period", new Integer(fperiod));
            BigDecimal value = rowSet.getBigDecimal("FValue");
            data.put("value", value);
            int dynaItemType = rowSet.getInt("FDynaItemType");
            data.put("dynaItemType", DynaItemTypeEnum.getEnum((int)dynaItemType));
            if (result.containsKey(reportId)) {
                itemData = (List)result.get(reportId);
            } else {
                itemData = new ArrayList();
                result.put(reportId, itemData);
            }
            itemData.add(data);
        }
    }

    private String getGroupBySql(boolean isGetReportIDs) {
        if (isGetReportIDs) {
            return "";
        }
        return " group by a.FReportId, i2.FNumber, b.FKeyNumber, b.FKeyName, b.FDataElement,  b.FValueType, b.FYear, b.FPeriod, b.FDynaItemType";
    }

    private String getSelectSql(boolean isGetReportIDs, boolean isSumValPartSql) {
        if (isGetReportIDs) {
            if (!isSumValPartSql) {
                return "select distinct case when report.FId is not NULL then report.FId else a.FReportId end as reportId";
            }
            return "select distinct a.FReportId as reportId";
        }
        if (!isSumValPartSql) {
            return "select case when report.FId is not NULL then report.FId else a.FReportId end as reportId, to_char(b.FItemId) as FItemId, b.FKeyNumber, b.FKeyName, b.FDataElement,b.FValueType, b.FYear, b.FPeriod, b.FValue, b.FDynaItemType";
        }
        return "select a.FReportId as reportId, to_char(i2.FNumber) as FItemId, b.FKeyNumber, b.FKeyName, b.FDataElement, b.FValueType, b.FYear, b.FPeriod, sum(b.FValue) as FValue, b.FDynaItemType";
    }

    @Override
    @Deprecated
    protected void _delete(Context ctx, IObjectPK pk, OrgTreeInfo tree, OrgUnitInfo orgUnit) throws BOSException, EASBizException {
        HashMap result = new HashMap();
        int mergeType = CslRptUtil.getMergeMode(ctx, tree.getId().toString()).getValue();
        int b = InterTradeServerUtils.tryToDelete(ctx, pk, mergeType, tree, orgUnit, this.getElimType());
        if (b == 0) {
            super._delete(ctx, pk);
        } else {
            if (b == 2) {
                throw new EASBizException(new NumericExceptionSubItem("1", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"SelectedData_NotImported", (Locale)ctx.getOriginLocale())));
            }
            if (b == 1) {
                throw new EASBizException(new NumericExceptionSubItem("1", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"CheckedData_CantDelete", (Locale)ctx.getOriginLocale())));
            }
            if (b == 3) {
                throw new EASBizException(new NumericExceptionSubItem("1", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"221_InvestItemDataControllerBean", (Locale)ctx.getOriginLocale())));
            }
        }
    }

    @Override
    protected void _delete(Context ctx, String sql, String reportIds) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        sb.append("(SELECT itemdata.FId FId FROM T_CSL_ExchItemData itemdata WHERE itemdata.FReport IN (").append(reportIds).append("))");
        InterTradeServerUtils.checkDelete(ctx, sb.toString(), ElimTypeEnum.exchange);
        super.delete(ctx, sql);
    }

    @Override
    protected void _delete(Context ctx, String sql, String reportIds, boolean isComeAndExch) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        sb.append("(SELECT itemdata.FId FId FROM T_CSL_ExchItemData itemdata WHERE itemdata.FReport IN (").append(reportIds).append("))");
        InterTradeServerUtils.checkDelete(ctx, sb.toString(), ElimTypeEnum.exchange, isComeAndExch);
        super.delete(ctx, sql);
    }

    @Override
    protected String _removeBatch(Context ctx, List list, OrgTreeInfo tree, OrgUnitInfo orgUnit) throws BOSException, EASBizException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("ids", CslRptUtil.AryToItemString(list));
        param.put("elimType", (Object)this.getElimType());
        param.put("getItemDataId", Boolean.TRUE);
        Map result = InterTradeServerUtils.checkDelete(ctx, param);
        Set existCheckedRptIds = (Set)result.get("existCheckedRptIds");
        StringBuffer msg = (StringBuffer)result.get("msg");
        Set existItemDataIds = (Set)result.get("existItemDataIds");
        if (existItemDataIds != null) {
            list.removeAll(existItemDataIds);
        }
        int r = 0;
        StringBuffer error = new StringBuffer();
        if (msg.length() > 0) {
            error.append(msg.toString());
        }
        int mergeType = 0;
        mergeType = tree == null ? 100 : CslRptUtil.getMergeMode(ctx, tree.getId().toString()).getValue();
        for (int i = 0; i < list.size(); ++i) {
            String id = (String)list.get(i);
            ObjectStringPK pk = new ObjectStringPK(id);
            int b = InterTradeServerUtils.tryToDelete(ctx, (IObjectPK)pk, mergeType, tree, orgUnit, this.getElimType());
            if (b == 0) {
                super._delete(ctx, (IObjectPK)pk);
                ++r;
                continue;
            }
            String l = ctx.getLocale().toString();
            String sql = "select b1.FName_" + l + " as FCompany, b2.FName_" + l + " as FTargetCompany, FItemNumber from t_csl_exchItemData i join t_org_baseunit b1 on i.FCompanyId = b1.FId join t_org_baseunit b2 on i.FTargetCompanyId = b2.FId where i.FId = ?";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{pk.toString()});
            try {
                if (!rowSet.next()) continue;
                error.append(rowSet.getString("FCompany")).append(" ");
                error.append(rowSet.getString("FTargetCompany")).append(" ");
                error.append(rowSet.getString("FItemNumber")).append(" ");
                if (b == 2) {
                    error.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"222_InvestItemDataControllerBean", (Locale)ctx.getOriginLocale()));
                    error.append("\n");
                    continue;
                }
                if (b == 1) {
                    error.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"268_RPTExchItemDataControllerBean", (Locale)ctx.getOriginLocale()));
                    error.append("\n");
                    continue;
                }
                if (b != 3) continue;
                error.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"223_InvestItemDataControllerBean", (Locale)ctx.getOriginLocale()));
                error.append("\n");
                continue;
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return error.toString();
    }

    @Override
    protected String _importExchItemData(Context ctx, boolean isCovert, Map reportDatas, Map params) throws BOSException, EASBizException {
        OrgTreeInfo orgTree = (OrgTreeInfo)params.get("KeyOrgTree");
        OrgUnitInfo orgUnit = (OrgUnitInfo)params.get("KeyOrgUnit");
        int year = (Integer)params.get("Year");
        int period = (Integer)params.get("Period");
        Date day = (Date)params.get("Day");
        int periodType = (Integer)params.get("PeriodType");
        String dataCollectNumber = (String)params.get("dataCollectNumber");
        String fastMergeSoluId = (String)params.get("fastMergeSoluId");
        if (!StringUtils.isEmpty((String)fastMergeSoluId)) {
            try {
                FastMergeSoluInfo soluInfo = FastMergeUtil.getFastMergeSoluInfo(ctx, fastMergeSoluId, false);
                if (soluInfo.isIsSupportGroupReport()) {
                    fastMergeSoluId = null;
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                fastMergeSoluId = null;
            }
        }
        Connection conn = null;
        Statement st = null;
        StringBuffer error = new StringBuffer();
        try {
            conn = super.getConnection(ctx);
            st = conn.createStatement();
            params.put("ReportData", reportDatas);
            reportDatas = this.getImportData(ctx, params);
            boolean[] booleans = CSLParamUtil.batchGetParam(ctx, new String[]{"GR_CSL_OnlyImportDynaDataOfCurrentUnit", "GR_CSL_MImportDyna"});
            boolean isOnlyImportDynaDataOfCurrentUnit = booleans[0];
            Set existCheckedRptIds = null;
            boolean isCrossImportDynaData = booleans[1];
            if (isCovert) {
                String reportIds = "";
                Iterator it = reportDatas.keySet().iterator();
                while (it.hasNext()) {
                    reportIds = reportIds + ",'" + it.next() + "'";
                }
                if (reportIds.length() > 0) {
                    reportIds = reportIds.substring(1);
                    StringBuffer oql = new StringBuffer();
                    oql.append(" WHERE report.id in (").append(reportIds).append(")");
                    oql.append(" AND orgBound.id='").append(orgTree.getId().toString()).append("'");
                    IRPTInterItemData inter = RPTInterItemDataFactory.getLocalInstance(ctx);
                    if (isOnlyImportDynaDataOfCurrentUnit) {
                        oql.append(" AND importedGroup.number ='").append(orgUnit.getNumber()).append("'");
                    }
                    HashMap<String, Object> p = new HashMap<String, Object>();
                    p.put("elimType", (Object)this.getElimType());
                    p.put("reportIds", reportIds);
                    p.put("treeId", orgTree.getId().toString());
                    p.put("unitId", orgUnit.getId().toString());
                    p.put("sql", oql.toString());
                    p.put("isOnlyImportDynaDataOfCurrentUnit", isOnlyImportDynaDataOfCurrentUnit);
                    Map result = RPTInterItemDataFactory.getLocalInstance(ctx).deleteByRptIds(p);
                    existCheckedRptIds = (Set)result.get("existCheckedRptIds");
                    if (result.get("msg") != null) {
                        error.append((StringBuffer)result.get("msg"));
                    }
                }
            }
            for (String reportId : reportDatas.keySet()) {
                if (existCheckedRptIds != null && existCheckedRptIds.contains(reportId)) continue;
                List itemDatas = (List)reportDatas.get(reportId);
                CslReportInfo report = CslReportFactory.getLocalInstance(ctx).getCslReportInfo((IObjectPK)new ObjectStringPK(reportId));
                this.importDatas(ctx, isCovert, itemDatas, orgTree.getId().toString(), orgUnit.getId().toString(), report, year, period, periodType, day, st, isOnlyImportDynaDataOfCurrentUnit, fastMergeSoluId);
            }
            st.executeBatch();
            st.clearBatch();
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql execute exception : When import dyna item data", (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)conn);
        return error.toString();
    }

    private void importDatas(Context ctx, boolean isCovert, List itemDatas, String orgTreeId, String orgUnitId, CslReportInfo report, int year, int period, int periodType, Date day, Statement st, boolean isOnlyImportDynaDataOfCurrentUnit, String fastMergeSoluId) throws EASBizException, BOSException {
        String companyId = report.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICNORMALREPORT) ? report.getCompany().getId().toString() : report.getOrgUnit().getId().toString();
        String currencyId = report.getCurrency().getId().toString();
        String groupUnitLongNum = null;
        String compLongNum = null;
        String targLongNum = null;
        Map<DynaItemTypeEnum, Map<String, CslRptUtil.DynaListCompanyInfo>> dynaItemTypeIdsMap = null;
        Map<String, CslRptUtil.DynaListCompanyInfo> cslDynaItemIdsMap = null;
        boolean isDynaNormalReport = RptSrcTypeEnum.DYNAMICNORMALREPORT.equals((Object)report.getSourceType());
        if (isDynaNormalReport) {
            dynaItemTypeIdsMap = CslRptUtil.getBatchTargetComapayIDs(ctx, itemDatas, orgTreeId);
        } else {
            cslDynaItemIdsMap = CslRptUtil.getBatchComapayIDs(ctx, itemDatas, orgTreeId);
        }
        if (isOnlyImportDynaDataOfCurrentUnit) {
            groupUnitLongNum = CslRptUtil.getUnitStructureLongNumber(ctx, orgTreeId, orgUnitId);
            compLongNum = CslRptUtil.getUnitStructureLongNumber(ctx, orgTreeId, companyId);
        }
        for (int i = 0; i < itemDatas.size(); ++i) {
            String targetCompanyId;
            Map itemData = (Map)itemDatas.get(i);
            String number = (String)itemData.get("ditemNumber");
            String name = (String)itemData.get("ditemName");
            if (isDynaNormalReport) {
                targetCompanyId = CslRptUtil.getTargetCompanyPropt(name, number, (DynaItemTypeEnum)itemData.get("dynaItemType"), dynaItemTypeIdsMap, true);
                if (targetCompanyId == null) continue;
                if (isOnlyImportDynaDataOfCurrentUnit) {
                    targLongNum = CslRptUtil.getTargetCompanyPropt(name, number, (DynaItemTypeEnum)itemData.get("dynaItemType"), dynaItemTypeIdsMap, false);
                    if (compLongNum != null && !compLongNum.equals(targLongNum) && !CslRptUtil.isSameSuperior(groupUnitLongNum, compLongNum, targLongNum)) continue;
                }
                if (companyId.equals(targetCompanyId) && compLongNum != null && compLongNum.replace(groupUnitLongNum, "").lastIndexOf("!") > 0) {
                    continue;
                }
            } else {
                targetCompanyId = CslRptUtil.getCompanyPropt(number, cslDynaItemIdsMap, true, true);
                companyId = CslRptUtil.getCompanyPropt(number, cslDynaItemIdsMap, false, true);
                if (StringUtils.isEmpty((String)targetCompanyId) || StringUtils.isEmpty((String)companyId) || isOnlyImportDynaDataOfCurrentUnit && !(compLongNum = CslRptUtil.getCompanyPropt(number, cslDynaItemIdsMap, true, false)).equals(targLongNum = CslRptUtil.getCompanyPropt(number, cslDynaItemIdsMap, false, false)) && !CslRptUtil.isSameSuperior(groupUnitLongNum, compLongNum, targLongNum)) continue;
            }
            String itemNumber = (String)itemData.get("itemNumber");
            int dataElement = (Integer)itemData.get("dataElement");
            if (!isCovert) {
                StringBuffer oql = new StringBuffer();
                oql.append("select FSourceType from T_CSL_ExchItemData ");
                oql.append(" where FOrgBoundID = ? and FCompanyID = ?");
                oql.append(" and FTargetCompanyID = ? and FItemNumber = ?");
                oql.append(" and FYear = ? and FPeriod = ? and FPeriodType = ?");
                oql.append(" and FDataElement = ?");
                oql.append(" and FTargetCurrencyID = ?");
                Object[] param = new Object[]{orgTreeId, companyId, targetCompanyId, itemNumber, new Integer(year), new Integer(period), new Integer(periodType), new Integer(dataElement), currencyId};
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)oql.toString(), (Object[])param);
                try {
                    if (rowSet.next()) {
                        int sourceType = rowSet.getInt("FSourceType");
                        if (sourceType == 1) continue;
                        StringBuffer delete = new StringBuffer();
                        delete.append("delete T_CSL_ExchItemData ");
                        delete.append(" where FOrgBoundID = '").append(orgTreeId);
                        delete.append("' and FCompanyID = '").append(companyId);
                        delete.append("' and FTargetCompanyID = '").append(targetCompanyId);
                        delete.append("' and FItemNumber = '").append(itemNumber);
                        delete.append("' and FYear = ").append(year);
                        delete.append(" and FPeriod = ").append(period);
                        delete.append(" and FPeriodType = ").append(periodType);
                        delete.append(" and FTargetCurrencyId = '").append(currencyId).append("'");
                        delete.append(" and FDataElement = ").append(dataElement);
                        delete.append(" and FSourceType = ").append(2);
                        st.addBatch(delete.toString());
                    }
                }
                catch (SQLException e) {
                    throw new SQLDataException(e);
                }
            }
            StringBuffer sql = new StringBuffer();
            sql.append("insert into T_CSL_ExchItemData");
            sql.append(" (FID, FOrgBoundID, FCompanyID, FTargetCompanyID, FCurrencyID,");
            sql.append(" FTargetCurrencyID, FReport, FItemNumber, FYear, FPeriod,");
            sql.append(" FDay, FMoney, FPeriodType, FCheckageStatus, FCommitStatus,");
            sql.append(" FCommitDate, FDataElement, FSourceType, FImportedGroup, FDataCollectNumber, FFastMergeSoluId) ");
            BOSUuid id = BOSUuid.create((BOSObjectType)new RPTInterItemDataInfo().getBOSType());
            sql.append(" values('").append(id.toString());
            sql.append("', '").append(orgTreeId);
            sql.append("', '").append(companyId);
            sql.append("', '").append(targetCompanyId);
            sql.append("', '").append(report.getSourceCurrency().getId().toString());
            sql.append("', '").append(report.getCurrency().getId().toString());
            sql.append("', '").append(report.getId().toString());
            sql.append("', '").append(itemNumber);
            sql.append("', ").append(report.getYear());
            sql.append(", ").append(report.getPeriod());
            sql.append(", ").append(CslRptUtil.formatDateForSql(day));
            String value = Util.bigDecimalToPlainString((BigDecimal)((BigDecimal)itemData.get("value")));
            sql.append(", ").append(value);
            sql.append(", ").append(report.getPeriodType().getValue());
            sql.append(", ").append(1);
            if (report.getAdjustStatus().equals((Object)AdjustStatusEnum.ADJUSTED) && report.getSourceRpt() != null) {
                sql.append(", ").append(3);
            } else {
                sql.append(", ").append(report.getCommittedStatus().getValue());
            }
            sql.append(", ").append(CslRptUtil.formatDateForSql(report.getAuditTime()));
            sql.append(", ").append(dataElement);
            sql.append(", ").append(2);
            sql.append(", '").append(orgUnitId);
            String dataCollectNumber = report.getDataCollectNumber();
            if (dataCollectNumber != null && dataCollectNumber.length() != 0) {
                sql.append("','").append(dataCollectNumber).append("'");
            }
            sql.append(",'").append(fastMergeSoluId).append("'");
            sql.append(")");
            try {
                st.addBatch(sql.toString());
                continue;
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
    }

    private ElimTypeEnum getElimType() {
        return ElimTypeEnum.exchange;
    }
}

