/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.variant.Util;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.AdjustStatusEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ElimTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.IRPTExchItemData;
import com.kingdee.eas.fi.gr.cslrpt.InterTradeServerUtils;
import com.kingdee.eas.fi.gr.cslrpt.RPTExchItemDataFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTInterItemDataInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.AbstractRPTInterItemDataControllerBean;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.dynamic.DynaItemTypeEnum;
import com.kingdee.eas.fi.gr.fast.FastMergeSoluInfo;
import com.kingdee.eas.fi.gr.fast.util.FastMergeUtil;
import com.kingdee.eas.fi.gr.mobile.MobileUtil;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.fi.rpt.util.PsSql;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class RPTInterItemDataControllerBean
extends AbstractRPTInterItemDataControllerBean {
    private static final long serialVersionUID = 7701262382743966937L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.cslrpt.app.RPTInterItemDataControllerBean");
    private static final int HASCHECKED = 1;
    private static final int BASEDATA = 2;
    private static final int CANDELETE = 0;
    private static final int NOTCURGROUP = 3;

    @Override
    protected Map _getImportData(Context ctx, Map params) throws BOSException, EASBizException {
        OrgTreeInfo orgTree = (OrgTreeInfo)params.get("KeyOrgTree");
        OrgUnitInfo orgUnit = (OrgUnitInfo)params.get("KeyOrgUnit");
        int year = (Integer)params.get("Year");
        int period = (Integer)params.get("Period");
        int periodType = (Integer)params.get("PeriodType");
        int mergeMode = (Integer)params.get("MERGETYPE");
        String currencyId = (String)params.get("KEY_CURRENCY_ID");
        String fastMergeSoluId = (String)params.get("fastMergeSoluId");
        boolean isUnReceive = false;
        if (params.get("isUnReceive") != null && params.get("isUnReceive") instanceof Boolean) {
            isUnReceive = (Boolean)params.get("isUnReceive");
        }
        boolean isGetReportIDs = params.get("ISGETREPORTIDS") == null ? false : (Boolean)params.get("ISGETREPORTIDS");
        String reportsStr = null;
        String tmplName = null;
        HashMap result = new HashMap();
        boolean[] booleans = CSLParamUtil.batchGetParam(ctx, new String[]{"GR_CSL_OnlyImportDynaDataOfCurrentUnit", "GR_CSL_MImportDyna"});
        boolean isOnlyImportDynaDataOfCurrentUnit = booleans[0];
        boolean isCrossImportDynaData = booleans[1];
        if (isGetReportIDs) {
            String[] str = CslRptUtil.getAllGroupNormalReportsUsedTmplTbl(ctx, orgTree, orgUnit, currencyId, mergeMode, year, period, periodType, fastMergeSoluId, isUnReceive);
            if (str == null) {
                return result;
            }
            tmplName = str[0];
            reportsStr = str[1];
        } else {
            Set idsSet = ((Map)params.get("ReportData")).keySet();
            ArrayList reportIds = new ArrayList(idsSet);
            StringBuffer tmp = new StringBuffer();
            for (int i = 0; i < reportIds.size(); ++i) {
                tmp.append("'").append(reportIds.get(i)).append("',");
            }
            if (tmp.length() > 0) {
                reportsStr = tmp.substring(0, tmp.length() - 1);
            } else {
                return result;
            }
        }
        SQLBuilder sql = new SQLBuilder();
        sql.append(this.getDynaNormalReportInterItemDataSql(params, isGetReportIDs, reportsStr));
        if (orgUnit.isIsGrouping() && isOnlyImportDynaDataOfCurrentUnit && !isCrossImportDynaData) {
            sql.append(" union \n");
            sql.append(this.getDynaCslReportInterItemDataSql(ctx, params, isGetReportIDs, reportsStr));
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.getSQL());
        try {
            while (rowSet.next()) {
                this.wrapperMapData(rowSet, result, isGetReportIDs);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            if (!DebugLogger.isDebug && tmplName != null) {
                TempTablePool.getInstance((Context)ctx).releaseTable(tmplName);
            }
        }
        return result;
    }

    private String getDynaNormalReportInterItemDataSql(Map params, boolean isGetReportIDs, String reportsStr) {
        boolean isFilterTmpNumber = params.get("templateNumbers") != null;
        StringBuffer numbers = new StringBuffer();
        String nms = "";
        if (isFilterTmpNumber) {
            Set numberSet = (Set)params.get("templateNumbers");
            Iterator it = numberSet.iterator();
            while (it.hasNext()) {
                numbers.append("'" + it.next() + "',");
            }
        }
        if (numbers.length() > 0) {
            nms = numbers.substring(0, numbers.length() - 1);
        }
        StringBuffer sql = new StringBuffer(1000);
        String dataCollectNumber = (String)params.get("dataCollectNumber");
        OrgTreeInfo orgTree = (OrgTreeInfo)params.get("KeyOrgTree");
        sql.append(this.getSelectSql(isGetReportIDs, false));
        sql.append("  FROM T_CSL_DynaItemData a");
        sql.append("  LEFT JOIN T_CSL_CslReport report on report.fid = a.FReportId");
        sql.append(" INNER JOIN T_CSL_DynaItemDataEntry b ON a.FId = b.FItemDataId");
        sql.append(" INNER JOIN T_CSL_RptItem i ON b.FItemId = i.FNumber");
        if (isFilterTmpNumber) {
            sql.append(" INNER JOIN T_CSL_CslReport cslrpt ON cslrpt.FId = a.FReportId");
            sql.append(" INNER JOIN T_RPT_Template tmp ON tmp.FId = cslrpt.FTemplateId");
        }
        sql.append(" INNER JOIN (SELECT DISTINCT entry.FItemId, entry.FDataElement FROM T_CSL_ElimTemplet e");
        sql.append("   INNER JOIN T_CSL_ElimTempletentry entry on e.FId = entry.FTempletId");
        sql.append("   WHERE e.FElimType =").append(this.getElimType().getValue());
        sql.append("  ) t ON i.FId = t.FItemId and b.FDataElement = t.FDataElement");
        sql.append(" WHERE a.FReportId IN (").append(reportsStr).append(")");
        sql.append("   AND a.FDataCollectNumber = '").append(dataCollectNumber).append("'");
        sql.append(" and b.fvaluetype=1 ");
        if (orgTree.getLayerType().equals((Object)OrgViewType.PROFITCENTER)) {
            sql.append(" and b.FDynaItemType in (1, 2, 3, 10)");
        } else {
            sql.append(" and b.FDynaItemType in (1, 2, 3)");
        }
        if (isFilterTmpNumber) {
            sql.append(" and tmp.FNumber IN (").append(nms).append(")");
        }
        sql.append(" and i.FId not in (select distinct FDynaItemId from t_csl_dynaItem2ElimItem)");
        sql.append(" and b.FValue !=0 and b.FValue is not null ");
        sql.append(" and a.FDynaType = 1 ");
        sql.append(" and a.FDataSource = 10");
        sql.append(" union \r\n");
        sql.append(this.getSelectSql(isGetReportIDs, true));
        sql.append("  FROM T_CSL_DynaItemData a");
        sql.append(" INNER JOIN T_CSL_DynaItemDataEntry b on a.FId = b.FItemDataId");
        if (isFilterTmpNumber) {
            sql.append(" INNER JOIN T_CSL_CslReport cslrpt ON cslrpt.FId = a.FReportId");
            sql.append(" INNER JOIN T_RPT_Template tmp ON tmp.FId = cslrpt.FTemplateId");
        }
        sql.append(" INNER JOIN T_CSL_RptItem i on b.FItemId = i.FNumber");
        sql.append(" INNER JOIN T_CSL_DynaItem2ElimItem d2e on i.FId = d2e.FDynaItemId");
        sql.append(" INNER JOIN (SELECT DISTINCT entry.FItemId, entry.FDataElement from t_csl_elimTemplet e");
        sql.append(" INNER JOIN T_CSL_ElimTempletentry entry on e.FId = entry.FTempletId");
        sql.append(" WHERE e.FElimType =").append(this.getElimType().getValue());
        sql.append(") t ON d2e.FElimItemId = t.FItemId AND b.FDataElement = t.FDataElement");
        sql.append(" INNER JOIN T_CSL_RptItem i2 ON t.FItemId = i2.FId");
        sql.append(" WHERE a.FReportId IN (").append(reportsStr).append(")");
        sql.append("   AND a.FDataCollectNumber = '").append(dataCollectNumber).append("'");
        sql.append(" and b.fvaluetype=1 ");
        if (orgTree.getLayerType().equals((Object)OrgViewType.PROFITCENTER)) {
            sql.append(" AND b.FDynaItemType in (1, 2, 3, 10)");
        } else {
            sql.append(" AND b.FDynaItemType in (1, 2, 3)");
        }
        if (isFilterTmpNumber) {
            sql.append(" and tmp.FNumber IN (").append(nms).append(")");
        }
        sql.append(" AND b.FValue !=0 and b.FValue is not null ");
        sql.append(" and a.FDynaType = 1 ");
        sql.append(" and a.FDataSource = 10");
        sql.append(" group by a.FReportId, i2.FNumber, b.FKeyNumber, b.FKeyName, b.FDataElement, ");
        sql.append(" b.FValueType, b.FYear, b.FPeriod, b.FDynaItemType");
        return sql.toString();
    }

    private String getDynaCslReportInterItemDataSql(Context ctx, Map params, boolean isGetReportIDs, String reportsStr) throws EASBizException, BOSException {
        boolean isFilterTmpNumber = params.get("templateNumbers") != null;
        StringBuffer numbers = new StringBuffer();
        String nms = "";
        if (isFilterTmpNumber) {
            Set numberSet = (Set)params.get("templateNumbers");
            Iterator it = numberSet.iterator();
            while (it.hasNext()) {
                numbers.append("'" + it.next() + "',");
            }
        }
        if (numbers.length() > 0) {
            nms = numbers.substring(0, numbers.length() - 1);
        }
        boolean isFilterCommitState = true;
        int sourceType = 12;
        String fastMergeSoluId = (String)params.get("fastMergeSoluId");
        boolean isUnReceive = false;
        if (params.get("isUnReceive") != null && params.get("isUnReceive") instanceof Boolean) {
            isUnReceive = (Boolean)params.get("isUnReceive");
        }
        if (!StringUtils.isEmpty((String)fastMergeSoluId) && isUnReceive) {
            isFilterCommitState = false;
            sourceType = 35;
        } else {
            isFilterCommitState = true;
            sourceType = 12;
        }
        StringBuffer sql = new StringBuffer(1000);
        int year = (Integer)params.get("Year");
        int period = (Integer)params.get("Period");
        int periodType = (Integer)params.get("PeriodType");
        String currencyId = (String)params.get("KEY_CURRENCY_ID");
        int mergeMode = (Integer)params.get("MERGETYPE");
        OrgTreeInfo orgTree = (OrgTreeInfo)params.get("KeyOrgTree");
        OrgUnitInfo orgUnit = (OrgUnitInfo)params.get("KeyOrgUnit");
        String mimport = ParamManager.getParamValue((Context)ctx, null, (String)"GR_CSL_MImportDyna");
        IOrgStructure iStruc = OrgStructureFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("tree.id", (Object)orgTree.getId()));
        filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)orgUnit.getId()));
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("*"));
        OrgStructureCollection structInfos = iStruc.getOrgStructureCollection(view);
        if (structInfos.size() == 0) {
            return "";
        }
        String StruParentId = structInfos.get(0).getId().toString();
        String unitLongNum = structInfos.get(0).getLongNumber();
        sql.append(this.getSelectSql(isGetReportIDs, false));
        sql.append(" FROM T_CSL_DynaItemData a \n");
        sql.append(" INNER JOIN T_CSL_Cslreport report on report.fid = a.FReportId");
        sql.append(" INNER JOIN T_RPT_Template tmpl on tmpl.FId = report.ftemplateid ");
        sql.append(" INNER JOIN T_CSL_DynaItemDataEntry b on a.FId = b.FItemDataId");
        sql.append(" INNER JOIN T_CSL_RptItem i on b.FItemId = i.FNumber");
        sql.append(" inner join (");
        sql.append("select distinct entry.FItemId, entry.FDataElement from t_csl_elimTemplet e");
        sql.append(" inner join t_csl_elimTempletentry entry on e.FId = entry.FTempletId");
        sql.append(" where e.FElimType = ").append(this.getElimType().getValue());
        sql.append(") t on i.FId = t.FItemId and b.FDataElement = t.FDataElement");
        sql.append(" where b.FDynaItemType in (0, 1, 2, 3, 10)");
        sql.append(" and b.fvaluetype=1 ");
        sql.append(" and i.FId not in (select distinct FDynaItemId from t_csl_dynaItem2ElimItem)");
        sql.append(" and b.FValue !=0 and b.FValue is not null ");
        sql.append(" and tmpl.FIsSupportInnerExch = 1 \n");
        sql.append(" and a.FDataSource = " + sourceType);
        sql.append(" and a.FOrgUnitId in (");
        sql.append(" select unit.fid from t_org_Structure s            \n");
        sql.append(" join t_org_BaseUnit unit on s.funitid = unit.fid  \n ");
        sql.append(" where s.ftreeid ='").append(orgTree.getId().toString()).append("' and unit.FisGrouping = 1");
        if (mergeMode == 1) {
            if ("true".equalsIgnoreCase(mimport)) {
                sql.append(" and s.flongnumber like'" + unitLongNum + "!%') \n");
            } else {
                sql.append(" and s.fparentId ='").append(StruParentId).append("')");
            }
        } else {
            sql.append(" and s.flongnumber like'" + unitLongNum + "!%') \n");
        }
        if (isFilterTmpNumber) {
            sql.append(" and tmpl.FNumber IN (").append(nms).append(")");
        }
        sql.append(" and b.FYear = " + year);
        sql.append(" and b.FPeriod = " + period);
        sql.append(" and a.FPeriodType = " + periodType);
        sql.append(" and a.FDynaType = 6 ");
        if (isFilterCommitState) {
            sql.append(" and a.FCommitStatus = 3 ");
        } else {
            sql.append(" AND report.FFastMergeSoluId = '").append(fastMergeSoluId).append("' \n");
        }
        if (!StringUtils.isEmpty((String)currencyId)) {
            sql.append(" and a.FCurrencyID = '" + currencyId + "'");
        }
        if (!isGetReportIDs) {
            sql.append(" and a.freportid in(" + reportsStr + ")");
        }
        sql.append(" union \r\n");
        sql.append(this.getSelectSql(isGetReportIDs, true));
        sql.append(" FROM T_CSL_DynaItemData a \n");
        sql.append(" INNER JOIN T_CSL_Cslreport report on report.fid = a.FReportId");
        sql.append(" INNER JOIN T_RPT_Template tmpl on tmpl.FId = report.ftemplateid ");
        sql.append(" INNER JOIN T_CSL_DynaItemDataEntry b on a.FId = b.FItemDataId");
        sql.append(" INNER JOIN T_CSL_RptItem i on b.FItemId = i.FNumber");
        sql.append(" INNER JOIN T_CSL_DynaItem2ElimItem de on i.FId = de.FDynaItemId");
        sql.append(" inner join (");
        sql.append("select distinct entry.FItemId, entry.FDataElement from t_csl_elimTemplet e");
        sql.append(" inner join t_csl_elimTempletentry entry on e.FId = entry.FTempletId");
        sql.append(" where e.FElimType = ").append(this.getElimType().getValue());
        sql.append(") t on de.FElimItemId = t.FItemId and b.FDataElement = t.FDataElement");
        sql.append(" inner join t_csl_rptItem i2");
        sql.append(" on t.FItemId = i2.FId");
        sql.append(" where b.FDynaItemType in (0, 1, 2, 3, 10) \n");
        sql.append(" and b.fvaluetype=1 ");
        sql.append(" and b.FValue !=0 and b.FValue is not null \n");
        sql.append(" and tmpl.FIsSupportInnerExch = 1 \n");
        sql.append(" and a.FDataSource = " + sourceType);
        sql.append(" and a.FOrgUnitId in (");
        sql.append(" select unit.fid from t_org_Structure s            \n");
        sql.append(" join t_org_BaseUnit unit on s.funitid = unit.fid  \n ");
        sql.append(" where s.ftreeid ='").append(orgTree.getId().toString()).append("' and unit.FisGrouping = 1");
        if (mergeMode == 1) {
            if ("true".equalsIgnoreCase(mimport)) {
                sql.append(" and s.flongnumber like'" + unitLongNum + "!%') \n");
            } else {
                sql.append(" and s.fparentId ='").append(StruParentId).append("')");
            }
        } else {
            sql.append(" and s.flongnumber like'" + unitLongNum + "!%') \n");
        }
        if (isFilterTmpNumber) {
            sql.append(" and tmpl.FNumber IN (").append(nms).append(")");
        }
        sql.append(" and b.FYear = " + year);
        sql.append(" and b.FPeriod = " + period);
        sql.append(" and a.FPeriodType = " + periodType);
        sql.append(" and a.FDynaType = 6 ");
        if (isFilterCommitState) {
            sql.append(" AND a.FCommitStatus = 3 ");
        } else {
            sql.append(" AND report.FFastMergeSoluId = '").append(fastMergeSoluId).append("' \n");
        }
        if (!StringUtils.isEmpty((String)currencyId)) {
            sql.append(" and a.FCurrencyID = '" + currencyId + "'");
        }
        if (!isGetReportIDs) {
            sql.append(" and a.freportid in(" + reportsStr + ")");
        }
        sql.append(this.getGroupBySql(isGetReportIDs));
        return sql.toString();
    }

    private void wrapperMapData(IRowSet rowSet, Map result, boolean isGetReportIDs) throws SQLException {
        List<HashMap<String, Object>> itemData = null;
        if (isGetReportIDs) {
            String reportId = rowSet.getString("reportId");
            result.put(reportId, null);
        } else {
            HashMap<String, Object> data = new HashMap<String, Object>();
            String reportId = rowSet.getString("reportId");
            String itemId = rowSet.getString("FItemId");
            data.put("itemNumber", itemId);
            String keyNumber = rowSet.getString("FkeyNumber");
            data.put("ditemNumber", keyNumber);
            String keyName = rowSet.getString("FKeyName");
            data.put("ditemName", keyName);
            int dataElement = rowSet.getInt("FDataElement");
            data.put("dataElement", new Integer(dataElement));
            int valueType = rowSet.getInt("FValueType");
            data.put("valueType", new Integer(valueType));
            int fyear = rowSet.getInt("Fyear");
            data.put("year", new Integer(fyear));
            int fperiod = rowSet.getInt("FPeriod");
            data.put("period", new Integer(fperiod));
            BigDecimal value = rowSet.getBigDecimal("FValue");
            data.put("value", value);
            int dynaItemType = rowSet.getInt("FDynaItemType");
            data.put("dynaItemType", DynaItemTypeEnum.getEnum((int)dynaItemType));
            if (result.containsKey(reportId)) {
                itemData = (List)result.get(reportId);
            } else {
                itemData = new ArrayList();
                result.put(reportId, itemData);
            }
            itemData.add(data);
        }
    }

    private String getGroupBySql(boolean isGetReportIDs) {
        if (isGetReportIDs) {
            return "";
        }
        return " group by a.FReportId, i2.FNumber, b.FKeyNumber, b.FKeyName, b.FDataElement,  b.FValueType, b.FYear, b.FPeriod, b.FDynaItemType";
    }

    private String getSelectSql(boolean isGetReportIDs, boolean isSumValPartSql) {
        if (isGetReportIDs) {
            if (!isSumValPartSql) {
                return "select distinct case when report.FId is not NULL then report.FId else a.FReportId end as reportId \n";
            }
            return "select distinct a.FReportId as reportId \n";
        }
        if (!isSumValPartSql) {
            return "select case when report.FId is not NULL then report.FId else a.FReportId end as reportId, to_char(b.FItemId) as FItemId, b.FKeyNumber, b.FKeyName, b.FDataElement,b.FValueType, b.FYear, b.FPeriod, b.FValue, b.FDynaItemType";
        }
        return "select a.FReportId as reportId, to_char(i2.FNumber) as FItemId, b.FKeyNumber, b.FKeyName, b.FDataElement, b.FValueType, b.FYear, b.FPeriod, sum(b.FValue) as FValue, b.FDynaItemType";
    }

    @Override
    @Deprecated
    protected void _delete(Context ctx, IObjectPK pk, OrgTreeInfo tree, OrgUnitInfo orgUnit) throws BOSException, EASBizException {
        int b;
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(pk.toString());
        InterTradeServerUtils.checkDelete(ctx, this.createInCondition(idList.iterator()), this.getElimType());
        int mergeType = 100;
        if (tree != null && tree.getId() != null) {
            mergeType = CslRptUtil.getMergeMode(ctx, tree.getId().toString()).getValue();
        }
        if ((b = InterTradeServerUtils.tryToDelete(ctx, pk, mergeType, tree, orgUnit, this.getElimType())) == 0) {
            this.innerDelete(ctx, pk);
        } else {
            if (b == 2) {
                throw new EASBizException(new NumericExceptionSubItem("1", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"SelectedData_NotImported", (Locale)ctx.getOriginLocale())));
            }
            if (b == 1) {
                throw new EASBizException(new NumericExceptionSubItem("1", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"CheckedData_CantDelete", (Locale)ctx.getOriginLocale())));
            }
            if (b == 3) {
                throw new EASBizException(new NumericExceptionSubItem("1", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"269_RPTInterItemDataControllerBean", (Locale)ctx.getOriginLocale())));
            }
        }
    }

    @Override
    protected Map _delete(Context ctx, String sql, String reportIds) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        sb.append("(select itemdata.fid fid from T_CSL_InterItemData itemdata where itemdata.FReport in (").append(reportIds).append("))");
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("ids", sb.toString());
        param.put("elimType", (Object)this.getElimType());
        Map result = InterTradeServerUtils.checkDelete(ctx, param);
        Set existCheckedRptIds = (Set)result.get("existCheckedRptIds");
        if (existCheckedRptIds.size() > 0) {
            sql = sql + " and report.id not in (" + CslRptUtil.AryToItemString(existCheckedRptIds) + ")";
        }
        super.delete(ctx, sql);
        return result;
    }

    @Override
    protected void _delete(Context ctx, String sql, String reportIds, boolean isComeAndExch) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        sb.append("(select itemdata.fid fid from T_CSL_InterItemData itemdata where itemdata.FReport in (").append(reportIds).append("))");
        InterTradeServerUtils.checkDelete(ctx, sb.toString(), ElimTypeEnum.ComeAndGo, isComeAndExch);
        super.delete(ctx, sql);
    }

    private String createInCondition(Iterator iterator) {
        boolean first = true;
        StringBuffer sql = new StringBuffer("(");
        while (iterator.hasNext()) {
            if (first) {
                sql.append(" '").append(iterator.next()).append("' ");
                first = false;
                continue;
            }
            sql.append(" ,'").append(iterator.next()).append("' ");
        }
        sql.append(") ");
        return sql.toString();
    }

    @Override
    protected String _removeBatch(Context ctx, List list, OrgTreeInfo tree, OrgUnitInfo orgUnit) throws BOSException, EASBizException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("ids", CslRptUtil.AryToItemString(list));
        param.put("elimType", (Object)this.getElimType());
        param.put("getItemDataId", Boolean.TRUE);
        Map result = InterTradeServerUtils.checkDelete(ctx, param);
        Set existCheckedRptIds = (Set)result.get("existCheckedRptIds");
        StringBuffer msg = (StringBuffer)result.get("msg");
        Set existItemDataIds = (Set)result.get("existItemDataIds");
        if (existItemDataIds != null) {
            list.removeAll(existItemDataIds);
        }
        int mergeType = 0;
        mergeType = tree == null ? 100 : CslRptUtil.getMergeMode(ctx, tree.getId().toString()).getValue();
        StringBuffer error = new StringBuffer();
        if (msg.length() > 0) {
            error.append(msg.toString());
        }
        for (int i = 0; i < list.size(); ++i) {
            String id = (String)list.get(i);
            ObjectStringPK pk = new ObjectStringPK(id);
            int b = InterTradeServerUtils.tryToDelete(ctx, (IObjectPK)pk, mergeType, tree, orgUnit, this.getElimType());
            if (b == 0) {
                this.innerDelete(ctx, (IObjectPK)pk);
                continue;
            }
            String l = ctx.getLocale().toString();
            String sql = "select b1.FName_" + l + " as FCompany, b2.FName_" + l + " as FTargetCompany, FItemNumber from t_csl_interItemData i join t_org_baseunit b1 on i.FCompanyId = b1.FId join t_org_baseunit b2 on i.FTargetCompanyId = b2.FId where i.FId = ?";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{pk.toString()});
            try {
                if (!rowSet.next()) continue;
                error.append(rowSet.getString("FCompany")).append(" ");
                error.append(rowSet.getString("FTargetCompany")).append(" ");
                error.append(rowSet.getString("FItemNumber")).append(" ");
                if (b == 2) {
                    error.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"222_InvestItemDataControllerBean", (Locale)ctx.getOriginLocale()));
                    error.append(" \n ");
                    continue;
                }
                if (b == 1) {
                    error.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"268_RPTExchItemDataControllerBean", (Locale)ctx.getOriginLocale()));
                    error.append(" \n ");
                    continue;
                }
                if (b != 3) continue;
                error.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"223_InvestItemDataControllerBean", (Locale)ctx.getOriginLocale()));
                error.append(" \n ");
                continue;
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return error.toString();
    }

    @Override
    protected String _importInterItemData(Context ctx, boolean isCovert, Map reportDatas, Map params) throws BOSException, EASBizException {
        if (reportDatas == null || reportDatas.size() <= 0) {
            return null;
        }
        OrgTreeInfo orgTree = (OrgTreeInfo)params.get("KeyOrgTree");
        OrgUnitInfo orgUnit = (OrgUnitInfo)params.get("KeyOrgUnit");
        int year = (Integer)params.get("Year");
        int period = (Integer)params.get("Period");
        Date day = (Date)params.get("Day");
        int periodType = (Integer)params.get("PeriodType");
        String dataCollectNumber = (String)params.get("dataCollectNumber");
        String fastMergeSoluId = (String)params.get("fastMergeSoluId");
        if (!StringUtils.isEmpty((String)fastMergeSoluId)) {
            try {
                FastMergeSoluInfo soluInfo = FastMergeUtil.getFastMergeSoluInfo(ctx, fastMergeSoluId, false);
                if (soluInfo.isIsSupportGroupReport()) {
                    fastMergeSoluId = null;
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                fastMergeSoluId = null;
            }
        }
        Connection conn = null;
        Statement st = null;
        StringBuffer error = new StringBuffer();
        try {
            conn = super.getConnection(ctx);
            st = conn.createStatement();
            params.put("ReportData", reportDatas);
            boolean[] booleans = CSLParamUtil.batchGetParam(ctx, new String[]{"GR_CSL_OnlyImportDynaDataOfCurrentUnit", "GR_CSL_MImportDyna"});
            boolean isOnlyImportDynaDataOfCurrentUnit = booleans[0];
            boolean isCrossImportDynaData = booleans[1];
            reportDatas = this.getImportData(ctx, params);
            Set existCheckedRptIds = null;
            if (isCovert) {
                String reportIds = "";
                Iterator it = reportDatas.keySet().iterator();
                while (it.hasNext()) {
                    reportIds = reportIds + ",'" + it.next() + "'";
                }
                if (reportIds.length() > 0) {
                    reportIds = reportIds.substring(1);
                    StringBuffer oql = new StringBuffer();
                    oql.append(" WHERE report.id in (").append(reportIds).append(")");
                    oql.append(" AND orgBound.id='").append(orgTree.getId().toString()).append("'");
                    if (isOnlyImportDynaDataOfCurrentUnit) {
                        oql.append(" AND importedGroup.number ='").append(orgUnit.getNumber()).append("'");
                    }
                    HashMap<String, Object> p = new HashMap<String, Object>();
                    p.put("elimType", (Object)this.getElimType());
                    p.put("reportIds", reportIds);
                    p.put("treeId", orgTree.getId().toString());
                    p.put("unitId", orgUnit.getId().toString());
                    p.put("sql", oql.toString());
                    p.put("isOnlyImportDynaDataOfCurrentUnit", isOnlyImportDynaDataOfCurrentUnit);
                    p.put("isUnReceive", params.get("isUnReceive"));
                    Map result = this.deleteByRptIds(ctx, p);
                    existCheckedRptIds = (Set)result.get("existCheckedRptIds");
                    if (result.get("msg") != null) {
                        error.append((StringBuffer)result.get("msg"));
                    }
                }
            }
            for (String reportId : reportDatas.keySet()) {
                if (existCheckedRptIds != null && existCheckedRptIds.contains(reportId)) continue;
                List itemDatas = (List)reportDatas.get(reportId);
                CslReportInfo report = CslReportFactory.getLocalInstance(ctx).getCslReportInfo((IObjectPK)new ObjectStringPK(reportId));
                this.importDatas(ctx, isCovert, itemDatas, orgTree.getId().toString(), orgUnit.getId().toString(), report, year, period, periodType, day, st, isOnlyImportDynaDataOfCurrentUnit, fastMergeSoluId);
            }
            st.executeBatch();
            st.clearBatch();
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql execute exception : When import dyna item data", (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)conn);
        return error.toString();
    }

    private void importDatas(Context ctx, boolean isCovert, List itemDatas, String orgTreeId, String orgUnitId, CslReportInfo report, int year, int period, int periodType, Date day, Statement st, boolean isOnlyImportDynaDataOfCurrentUnit, String fastMergeSoluId) throws EASBizException, BOSException {
        String companyId = report.getSourceType().equals((Object)RptSrcTypeEnum.DYNAMICNORMALREPORT) ? report.getCompany().getId().toString() : report.getOrgUnit().getId().toString();
        String currencyId = report.getCurrency().getId().toString();
        String dataCollectNumber = report.getDataCollectNumber();
        String groupUnitLongNum = null;
        String compLongNum = null;
        String targLongNum = null;
        Map<DynaItemTypeEnum, Map<String, CslRptUtil.DynaListCompanyInfo>> dynaItemTypeIdsMap = null;
        Map<String, CslRptUtil.DynaListCompanyInfo> cslDynaItemIdsMap = null;
        boolean isDynaNormalReport = RptSrcTypeEnum.DYNAMICNORMALREPORT.equals((Object)report.getSourceType());
        if (isDynaNormalReport) {
            dynaItemTypeIdsMap = CslRptUtil.getBatchTargetComapayIDs(ctx, itemDatas, orgTreeId);
        } else {
            cslDynaItemIdsMap = CslRptUtil.getBatchComapayIDs(ctx, itemDatas, orgTreeId);
        }
        if (isOnlyImportDynaDataOfCurrentUnit) {
            groupUnitLongNum = CslRptUtil.getUnitStructureLongNumber(ctx, orgTreeId, orgUnitId);
            compLongNum = CslRptUtil.getUnitStructureLongNumber(ctx, orgTreeId, companyId);
        }
        for (int i = 0; i < itemDatas.size(); ++i) {
            String targetCompanyId;
            Map itemData = (Map)itemDatas.get(i);
            String number = (String)itemData.get("ditemNumber");
            String name = (String)itemData.get("ditemName");
            if (isDynaNormalReport) {
                targetCompanyId = CslRptUtil.getTargetCompanyPropt(name, number, (DynaItemTypeEnum)itemData.get("dynaItemType"), dynaItemTypeIdsMap, true);
                if (targetCompanyId == null) continue;
                if (isOnlyImportDynaDataOfCurrentUnit) {
                    targLongNum = CslRptUtil.getTargetCompanyPropt(name, number, (DynaItemTypeEnum)itemData.get("dynaItemType"), dynaItemTypeIdsMap, false);
                    if (compLongNum != null && !compLongNum.equals(targLongNum) && !CslRptUtil.isSameSuperior(groupUnitLongNum, compLongNum, targLongNum)) continue;
                }
                if (companyId.equals(targetCompanyId) && compLongNum != null && compLongNum.replace(groupUnitLongNum, "").lastIndexOf("!") > 0) {
                    continue;
                }
            } else {
                targetCompanyId = CslRptUtil.getCompanyPropt(number, cslDynaItemIdsMap, true, true);
                companyId = CslRptUtil.getCompanyPropt(number, cslDynaItemIdsMap, false, true);
                if (StringUtils.isEmpty((String)targetCompanyId) || StringUtils.isEmpty((String)companyId)) continue;
                if (isOnlyImportDynaDataOfCurrentUnit) {
                    targLongNum = CslRptUtil.getCompanyPropt(number, cslDynaItemIdsMap, true, false);
                    compLongNum = CslRptUtil.getCompanyPropt(number, cslDynaItemIdsMap, false, false);
                    if (!compLongNum.equals(targLongNum) && !CslRptUtil.isSameSuperior(groupUnitLongNum, compLongNum, targLongNum)) continue;
                }
            }
            String itemNumber = (String)itemData.get("itemNumber");
            int dataElement = (Integer)itemData.get("dataElement");
            if (!isCovert) {
                StringBuffer oql = new StringBuffer();
                oql.append("select FSourceType from T_Csl_InterItemData ");
                oql.append(" where FOrgBoundID = ? and FCompanyID = ?");
                oql.append(" and FTargetCompanyID = ? and FItemNumber = ?");
                oql.append(" and FYear = ? and FPeriod = ? and FPeriodType = ?");
                oql.append(" and FTargetCurrencyID = ?");
                oql.append(" and FDataElement = ").append(dataElement);
                Object[] param = new Object[]{orgTreeId, companyId, targetCompanyId, itemNumber, new Integer(year), new Integer(period), new Integer(periodType), currencyId};
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)oql.toString(), (Object[])param);
                try {
                    if (rowSet.next()) {
                        int sourceType = rowSet.getInt("FSourceType");
                        if (sourceType == 1) continue;
                        StringBuffer delete = new StringBuffer();
                        delete.append("delete t_csl_interItemData ");
                        delete.append(" where FOrgBoundID = '").append(orgTreeId);
                        delete.append("' and FCompanyID = '").append(companyId);
                        delete.append("' and FTargetCompanyID = '").append(targetCompanyId);
                        delete.append("' and FItemNumber = '").append(itemNumber);
                        delete.append("' and FYear = ").append(year);
                        delete.append(" and FPeriod = ").append(period);
                        delete.append(" and FPeriodType = ").append(periodType);
                        delete.append(" and FTargetCurrencyId = '").append(currencyId).append("'");
                        delete.append(" and FSourceType = ").append(2);
                        delete.append(" and FDataElement = ").append(dataElement);
                        st.addBatch(delete.toString());
                    }
                }
                catch (SQLException e) {
                    throw new SQLDataException(e);
                }
            }
            StringBuffer sql = new StringBuffer();
            sql.append("insert into T_CSL_InterItemData");
            sql.append(" (FID, FOrgBoundID, FCompanyID, FTargetCompanyID, FCurrencyID,");
            sql.append(" FTargetCurrencyID, FReport, FItemNumber, FYear, FPeriod,");
            sql.append(" FDay, FMoney, FPeriodType, FCheckageStatus, FCommitStatus,");
            sql.append(" FCommitDate, FSourceType, FImportedGroup,FDATAELEMENT,FDataCollectNumber, FFastMergeSoluId) ");
            BOSUuid id = BOSUuid.create((BOSObjectType)new RPTInterItemDataInfo().getBOSType());
            sql.append(" values('").append(id.toString());
            sql.append("', '").append(orgTreeId);
            sql.append("', '").append(companyId);
            sql.append("', '").append(targetCompanyId);
            sql.append("', '").append(report.getSourceCurrency().getId().toString());
            sql.append("', '").append(report.getCurrency().getId().toString());
            sql.append("', '").append(report.getId().toString());
            sql.append("', '").append(itemNumber);
            sql.append("', ").append(report.getYear());
            sql.append(", ").append(report.getPeriod());
            sql.append(", ").append(CslRptUtil.formatDateForSql(day));
            if (itemData.get("value") == null) {
                sql.append(", 0");
            } else {
                String value = Util.bigDecimalToPlainString((BigDecimal)((BigDecimal)itemData.get("value")));
                sql.append(", ").append(value);
            }
            sql.append(", ").append(report.getPeriodType().getValue());
            sql.append(", ").append(1);
            if (report.getAdjustStatus().equals((Object)AdjustStatusEnum.ADJUSTED) && report.getSourceRpt() != null) {
                sql.append(", ").append(3);
            } else {
                sql.append(", ").append(report.getCommittedStatus().getValue());
            }
            sql.append(", ").append(CslRptUtil.formatDateForSql(report.getAuditTime()));
            sql.append(", ").append(2);
            sql.append(", '").append(orgUnitId);
            sql.append("', ").append(dataElement);
            if (dataCollectNumber != null && dataCollectNumber.length() != 0) {
                sql.append(",'").append(dataCollectNumber).append("'");
            }
            if (!StringUtils.isEmpty((String)fastMergeSoluId)) {
                sql.append(",'").append(fastMergeSoluId).append("'");
            } else {
                sql.append(",NULL");
            }
            sql.append(")");
            try {
                st.addBatch(sql.toString());
                continue;
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
    }

    @Override
    protected void _deleteDynaDataByReportIds(Context ctx, String sql, String reportIds, String treeId, String unitId, ElimTypeEnum elimType) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        String tableName = this.getElimType().equals((Object)elimType) ? " T_CSL_InterItemData " : " T_CSL_ExchItemData ";
        sb.append("(select itemdata.fid fid from ").append(tableName).append(" itemdata ");
        sb.append(" join t_org_baseunit unit on unit.fid = itemdata.FImportedGroup \n");
        sb.append("where itemdata.FReport in (").append(reportIds).append(")");
        sb.append(" and itemdata.ForgBoundId ='").append(treeId).append("'");
        sb.append(" and unit.Fnumber in(").append("select fnumber from t_org_baseunit where fid = '").append(unitId).append("'))");
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("ids", sb.toString());
        param.put("elimType", (Object)this.getElimType());
        Map result = InterTradeServerUtils.checkDelete(ctx, param);
        Set existCheckedRptIds = (Set)result.get("existCheckedRptIds");
        StringBuffer msg = (StringBuffer)result.get("msg");
        if (existCheckedRptIds.size() > 0) {
            sql = sql + " and report.id not in (" + CslRptUtil.AryToItemString(existCheckedRptIds) + ")";
        }
        if (this.getElimType().equals((Object)elimType)) {
            super.delete(ctx, sql);
        } else {
            RPTExchItemDataFactory.getLocalInstance(ctx).delete(sql);
        }
    }

    @Override
    protected Map _deleteByRptIds(Context ctx, Map param) throws BOSException, EASBizException {
        ElimTypeEnum elimType = (ElimTypeEnum)((Object)param.get("elimType"));
        String reportIds = (String)param.get("reportIds");
        String treeId = (String)param.get("treeId");
        String unitId = (String)param.get("unitId");
        String sql = (String)param.get("sql");
        Boolean isOnlyImportDynaDataOfCurrentUnit = null;
        Object obj = param.get("isOnlyImportDynaDataOfCurrentUnit");
        if (obj != null && obj instanceof Boolean) {
            isOnlyImportDynaDataOfCurrentUnit = (Boolean)obj;
        }
        if (isOnlyImportDynaDataOfCurrentUnit == null) {
            isOnlyImportDynaDataOfCurrentUnit = CSLParamUtil.isOnlyImportDynaDataOfCurrentUnit(ctx);
        }
        StringBuffer sb = new StringBuffer();
        if (isOnlyImportDynaDataOfCurrentUnit.booleanValue()) {
            sb.append("(SELECT itemdata.fid FId from ").append(elimType == ElimTypeEnum.ComeAndGo ? " T_CSL_InterItemData " : " T_CSL_ExchItemData ").append(" itemdata ");
            sb.append(" JOIN T_ORG_BaseUnit unit ON unit.FId = itemdata.FImportedGroup \n");
            sb.append("WHERE itemdata.FReport IN (").append(reportIds).append(")");
            sb.append(" AND itemdata.FOrgBoundId ='").append(treeId).append("'");
            if (param.containsKey("isUnReceive") && param.get("isUnReceive") != null && ((Boolean)param.get("isUnReceive")).booleanValue()) {
                sb.append(")");
            } else {
                sb.append(" AND unit.FNumber IN (").append("SELECT FNumber FROM T_ORG_BaseUnit WHERE FId = '").append(unitId).append("'))");
            }
        } else {
            sb.append("(select itemdata.fid FId FROM ").append(elimType == ElimTypeEnum.ComeAndGo ? " T_CSL_InterItemData " : " T_CSL_ExchItemData ").append(" itemdata where itemdata.FReport in (").append(reportIds).append(")").append(" AND itemdata.FOrgBoundId ='").append(treeId).append("')");
        }
        HashMap<String, Object> p = new HashMap<String, Object>();
        p.put("ids", sb.toString());
        p.put("elimType", (Object)elimType);
        Map result = InterTradeServerUtils.checkDelete(ctx, p);
        Set existCheckedRptIds = (Set)result.get("existCheckedRptIds");
        if (existCheckedRptIds.size() > 0) {
            sql = sql + " and report.id not in (" + CslRptUtil.AryToItemString(existCheckedRptIds) + ")";
        }
        if (ElimTypeEnum.ComeAndGo.equals((Object)elimType)) {
            super.delete(ctx, sql);
        } else {
            RPTExchItemDataFactory.getLocalInstance(ctx).delete(sql);
        }
        return result;
    }

    private ElimTypeEnum getElimType() {
        return ElimTypeEnum.ComeAndGo;
    }

    @Override
    protected String _importInterAndExchItemData(Context ctx, Map params) throws BOSException, EASBizException {
        StringBuffer msg = new StringBuffer();
        Map map = null;
        params.put("ISGETREPORTIDS", true);
        map = this.getImportData(ctx, params);
        params.put("ISGETREPORTIDS", false);
        String m = this.importInterItemData(ctx, true, map, params);
        msg.append(m);
        IRPTExchItemData exchItemData = RPTExchItemDataFactory.getLocalInstance(ctx);
        params.put("ISGETREPORTIDS", true);
        map = exchItemData.getImportData(params);
        params.put("ISGETREPORTIDS", false);
        m = exchItemData.importExchItemData(true, map, params);
        msg.append(m);
        return msg.toString();
    }

    private void debug(SQLBuilder buffer, String title) {
        try {
            String kql = PsSql.getSqlWithParams((Object)buffer.getSQL(), (Object[])buffer.getParams(), (int)7, (boolean)false);
            MobileUtil.debugLog(logger, "[" + title + "]******************************************:\n" + kql);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    protected List _getItemDataCollection(Context ctx, Map params) throws BOSException, EASBizException {
        boolean isOpenOnCompany = (Boolean)params.get("isOpenOnCompany");
        OrgTreeInfo orgTree = (OrgTreeInfo)params.get("KeyOrgTree");
        OrgUnitInfo orgUnit = (OrgUnitInfo)params.get("KeyOrgUnit");
        int year = (Integer)params.get("Year");
        int period = (Integer)params.get("Period");
        int periodType = (Integer)params.get("PeriodType");
        int mergeMode = (Integer)params.get("MERGETYPE");
        ElimTypeEnum elimType = (ElimTypeEnum)((Object)params.get("elimType"));
        boolean isMulti = params.containsKey("isMulti") ? (Boolean)params.get("isMulti") : false;
        String reportFieldName = InterTradeServerUtils.getReportFieldNameNameByElimType(elimType, isMulti);
        SQLBuilder builder = new SQLBuilder();
        builder.append("SELECT DISTINCT ").append(reportFieldName).append(" \n");
        builder.append("  FROM ").append(InterTradeServerUtils.getTableNameByElimType(elimType, isMulti)).append(" d ");
        builder.append("  JOIN T_CSL_CSLReport r ON r.FId = d.").append(reportFieldName).append(" \n");
        if (!isOpenOnCompany) {
            builder.append("  JOIN T_ORG_BaseUnit u ON u.FId = d.FImportedGroup \n");
        }
        builder.append(" WHERE d.FYear = ?\n", (Object)year);
        builder.append("   AND d.FPeriod = ?\n", (Object)period);
        builder.append("   AND d.FPeriodType = ?\n", (Object)periodType);
        builder.append("   AND (d.FFastMergeSoluId IS NULL or d.FFastMergeSoluId='null' OR (d.FFastMergeSoluId IS NOT NULL AND r.FCommittedStatus = ?)) \n", (Object)3);
        if (isOpenOnCompany) {
            builder.append(" AND d.FCompanyId = ?\n", (Object)orgUnit.getId().toString());
        } else {
            builder.append(" AND u.FNumber = ?\n", (Object)orgUnit.getNumber());
        }
        builder.append(" AND r.FSourceType IN (10,12,13) \n");
        if (orgTree != null && orgTree.getId() != null) {
            builder.append(" AND d.forgboundid = ?\n", (Object)orgTree.getId().toString());
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)builder.getSQL(), (Object[])builder.getParams());
        ArrayList<String> idSet = new ArrayList<String>();
        try {
            while (rowSet.next()) {
                idSet.add(rowSet.getString("FReport"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return idSet;
    }
}

