/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CheckFormulaException;
import com.kingdee.eas.fi.gr.cslrpt.CheckFormulaItemsInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.IRPTItem;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormulaCheckResultFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemCheckFormulaCollection;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemCheckFormulaFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemCheckFormulaInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.app.AbstractRPTItemCheckFormulaControllerBean;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.StringUtil;
import com.kingdee.eas.fi.newrpt.SundryException;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RPTItemCheckFormulaControllerBean
extends AbstractRPTItemCheckFormulaControllerBean {
    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ServiceStateManager.getInstance().enableNextCallService("LOG_SERVICE");
        this.addnewCheck(ctx, (RPTItemCheckFormulaInfo)model);
        this.constructor((RPTItemCheckFormulaInfo)model, ctx);
        super._addnew(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ServiceStateManager.getInstance().enableNextCallService("LOG_SERVICE");
        this.addnewCheck(ctx, (RPTItemCheckFormulaInfo)model);
        this.constructor((RPTItemCheckFormulaInfo)model, ctx);
        return super._addnew(ctx, model);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ServiceStateManager.getInstance().enableNextCallService("LOG_SERVICE");
        this.updateCheck(ctx, model);
        this.constructor((RPTItemCheckFormulaInfo)model, ctx);
        this.deleteCheckFormulaItems(ctx, model);
        this.modifyFormulaDispense(ctx, pk, model);
        super._update(ctx, pk, model);
    }

    private void modifyFormulaDispense(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        StringBuffer oql1 = new StringBuffer();
        oql1.append("update t_csl_formulaDispense set flastUpdateUserID = '");
        oql1.append(ctx.getCaller().toString());
        oql1.append("' , FLastUpdateTime = Timestamp'");
        oql1.append(CslRptUtil.getTime());
        oql1.append("' where FCheckFormulaID ='");
        oql1.append(pk.toString());
        oql1.append("'");
        DbUtil.execute((Context)ctx, (String)oql1.toString());
    }

    private void deleteCheckFormulaItems(Context ctx, IObjectValue model) throws BOSException {
        if (model != null) {
            Object[] objParams = new Object[]{model.get("id").toString()};
            DbUtil.execute((Context)ctx, (String)"Delete From T_CSL_CheckFormulaItems where FCheckFormulaID = ?", (Object[])objParams);
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ServiceStateManager.getInstance().enableNextCallService("LOG_SERVICE");
        StringBuffer oql = new StringBuffer();
        oql.append("select number where id = '");
        oql.append(pk.toString());
        oql.append("'");
        RPTItemCheckFormulaInfo info = RPTItemCheckFormulaFactory.getLocalInstance(ctx).getRPTItemCheckFormulaInfo(oql.toString());
        String number = info.getNumber();
        super._delete(ctx, pk);
        StringBuffer oql1 = new StringBuffer();
        oql1.append("delete from t_csl_formulaDispense where FFormulaNumber = '");
        oql1.append(StringUtil.replaceAll(number, "'", "''"));
        oql1.append("' and FFormulaType = ");
        oql1.append(1);
        DbUtil.execute((Context)ctx, (String)oql1.toString());
    }

    private void addnewCheck(Context ctx, RPTItemCheckFormulaInfo model) throws BOSException, EASBizException {
        this._checkNumberBlank(ctx, (IObjectValue)model);
        this._checkNameBlank(ctx, (IObjectValue)model);
        this._checkNumberDup(ctx, (IObjectValue)model);
        this._checkNameDup(ctx, (IObjectValue)model);
    }

    private void updateCheck(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberBlank(ctx, model);
        this._checkNameBlank(ctx, model);
        this._checkNumberDup(ctx, model);
        this._checkNameDup(ctx, model);
    }

    @Override
    protected void _checkNumberDup(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        RPTItemCheckFormulaInfo dataBaseInfo = (RPTItemCheckFormulaInfo)info;
        EntityViewInfo view = this.buildIsNumExistView(dataBaseInfo);
        RPTItemCheckFormulaCollection rptItemCheckFormulaCollection = this.getRPTItemCheckFormulaCollection(ctx, view);
        if (rptItemCheckFormulaCollection.size() > 0) {
            RPTItemCheckFormulaInfo infoInDB = rptItemCheckFormulaCollection.get(0);
            throw new SundryException(SundryException.NUMEXISTINORG, new Object[]{infoInDB.getNumber(), infoInDB.getTrackRecordCreator().getName()});
        }
    }

    private EntityViewInfo buildIsNumExistView(RPTItemCheckFormulaInfo dataBaseInfo) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)dataBaseInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
            filter.setMaskString("#0 and #1");
        }
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("trackRecordCreator.name"));
        coll.add(new SelectorItemInfo("number"));
        view.setFilter(filter);
        view.setSelector(coll);
        return view;
    }

    @Override
    protected void _checkNameDup(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        RPTItemCheckFormulaInfo dataBaseInfo = (RPTItemCheckFormulaInfo)info;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("name", (Object)dataBaseInfo.getName(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
            filter.setMaskString("#0 and #1");
        }
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        IObjectPK[] pks = super._getPKList(ctx, filter, sorter);
        if (pks.length > 0) {
            throw new EASBizException(EASBizException.CHECKNAMEDUP, new Object[]{dataBaseInfo.getName()});
        }
    }

    @Override
    protected void _checkNumberBlank(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        RPTItemCheckFormulaInfo dataBaseInfo = (RPTItemCheckFormulaInfo)info;
        String number = dataBaseInfo.getNumber();
        if (number == null || number.equals("")) {
            throw new CheckFormulaException(CheckFormulaException.NUMBER_BLANK);
        }
    }

    @Override
    protected void _checkNameBlank(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        RPTItemCheckFormulaInfo dataBaseInfo = (RPTItemCheckFormulaInfo)info;
        String name = dataBaseInfo.getName();
        if (name == null || name.equals("")) {
            throw new CheckFormulaException(CheckFormulaException.NAME_BLANK);
        }
    }

    private void constructor(RPTItemCheckFormulaInfo info, Context ctx) throws BOSException, EASBizException {
        String lFormula = info.getLFormula();
        String rFormula = info.getRFormula();
        ArrayList itemList = new ArrayList();
        String tempStr = null;
        String dnumber = null;
        String str = null;
        String curYear = null;
        String curPeriod = null;
        CheckFormulaItemsInfo itemInfo = null;
        String pattern = "Item\\([^\\s^\\)]{1,}\\)|DItem\\([^\\s^\\)]{1,}\\)";
        Pattern patt = Pattern.compile(pattern);
        for (int j = 0; j < 2; ++j) {
            Matcher matcher;
            ArrayList<String> items = new ArrayList<String>();
            boolean isDItem = false;
            if (j == 0) {
                matcher = patt.matcher(lFormula);
                while (matcher.find()) {
                    items.add(matcher.group());
                }
            } else {
                matcher = patt.matcher(rFormula);
                while (matcher.find()) {
                    items.add(matcher.group());
                }
            }
            int length = items.size();
            for (int i = 0; i < length; ++i) {
                String itemFormula = (String)items.get(i);
                isDItem = itemFormula.indexOf("DItem") >= 0;
                String[] params = null;
                if (isDItem) {
                    itemFormula = itemFormula.substring(6, itemFormula.length() - 1);
                    int size = itemFormula.split(",").length;
                    params = itemFormula.split(",");
                    if (size != 6) {
                        throw new EASBizException(new NumericExceptionSubItem("1", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"270_RPTItemCheckFormulaControllerBean", (Locale)ctx.getOriginLocale())));
                    }
                    tempStr = itemFormula.split(",")[0];
                    dnumber = itemFormula.split(",")[1];
                    curYear = itemFormula.split(",")[2];
                    curPeriod = itemFormula.split(",")[3];
                } else if (itemFormula.indexOf("Item") >= 0) {
                    itemFormula = itemFormula.substring(5, itemFormula.length() - 1);
                    params = itemFormula.split(",");
                    tempStr = itemFormula.split(",")[0];
                    curYear = itemFormula.split(",")[1];
                    curPeriod = itemFormula.split(",")[2];
                } else {
                    itemFormula = itemFormula.substring(5, itemFormula.length() - 1);
                    params = itemFormula.split(",");
                    tempStr = itemFormula.split(",")[0];
                    curYear = itemFormula.split(",")[1];
                    curPeriod = itemFormula.split(",")[2];
                }
                String valueType = params[params.length - 1];
                valueType = valueType.substring(1, valueType.length() - 1);
                if (ValueTypeEnum.TXT.getName().equals(valueType)) {
                    throw new CheckFormulaException(CheckFormulaException.CONTAINTXTCOMPARE);
                }
                str = tempStr.substring(1, tempStr.length() - 1).trim();
                if (dnumber != null && dnumber.length() > 1) {
                    dnumber = dnumber.substring(1, dnumber.length() - 1).trim();
                }
                HashMap<String, String> data = new HashMap<String, String>(4);
                data.put("item", str);
                if (StringUtils.isEmpty((String)dnumber)) {
                    dnumber = null;
                }
                data.put("ditem", dnumber);
                if (itemList.contains(data)) continue;
                itemList.add(data);
            }
        }
        IRPTItem irptItem = RPTItemFactory.getLocalInstance(ctx);
        info.getItems().clear();
        for (int j = 0; j < itemList.size(); ++j) {
            itemInfo = new CheckFormulaItemsInfo();
            Map data = (Map)itemList.get(j);
            String oql = "SELECT id WHERE number = '" + data.get("item") + "'";
            if (!irptItem.exists(oql)) continue;
            itemInfo.setItem(irptItem.getRPTItemInfo(oql));
            itemInfo.setDynaItem((String)data.get("ditem"));
            info.getItems().add(itemInfo);
        }
    }

    @Override
    protected void _freezeItem(Context ctx, IObjectPK id) throws BOSException, EASBizException {
        RPTItemCheckFormulaInfo info = (RPTItemCheckFormulaInfo)this.getValue(ctx, id);
        info.setIsFreezed(true);
        this.update(ctx, id, (CoreBaseInfo)info);
        ItemFormulaCheckResultFactory.getLocalInstance(ctx).freeze(true, id.toString());
    }

    @Override
    protected void _unFreezeItem(Context ctx, IObjectPK id) throws BOSException, EASBizException {
        RPTItemCheckFormulaInfo info = (RPTItemCheckFormulaInfo)this.getValue(ctx, id);
        info.setIsFreezed(false);
        this.update(ctx, id, (CoreBaseInfo)info);
        ItemFormulaCheckResultFactory.getLocalInstance(ctx).freeze(false, id.toString());
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        RPTItemCheckFormulaInfo info = this.getRPTItemCheckFormulaInfo(ctx, pk);
        return info.getNumber() + " " + info.getName();
    }

    @Override
    protected void _updateMaintainCU(Context ctx, String id, String cuId) throws BOSException, EASBizException {
        String sql = "update T_CSL_CheckFormula set FMaintainCUId = ? where FId = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{cuId, id});
    }

    @Override
    protected String _forbid(Context ctx, String cuID, boolean isFreezed, List idList) throws BOSException, EASBizException {
        if (idList == null || idList.isEmpty()) {
            return null;
        }
        for (int i = 0; i < idList.size(); ++i) {
            this.forbid(ctx, isFreezed, idList.get(i).toString());
        }
        return null;
    }

    private void forbid(Context ctx, boolean isFreezed, String id) throws EASBizException, BOSException {
        ObjectUuidPK pk = new ObjectUuidPK(id);
        if (isFreezed) {
            this._freezeItem(ctx, (IObjectPK)pk);
        } else {
            this._unFreezeItem(ctx, (IObjectPK)pk);
        }
    }
}

