/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.gr.cslrpt.CslRptCalcException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.IItemDataProvider;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataCondition;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataProviderFactory;
import com.kingdee.eas.fi.gr.cslrpt.SumRptException;
import com.kingdee.eas.fi.gr.cslrpt.UnionVersionUtil;
import com.kingdee.eas.fi.gr.cslrpt.app.AbstractRPTItemDataServiceControllerBean;
import com.kingdee.eas.fi.gr.cslrpt.app.reportcalc.MnsRptCalcHelper;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.BalanceTypeEnum;
import com.kingdee.eas.fi.rpt.IReportCacl;
import com.kingdee.eas.fi.rpt.ReportCaclFactory;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class RPTItemDataServiceControllerBean
extends AbstractRPTItemDataServiceControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.cslrpt.app.RPTItemDataServiceControllerBean");
    private static final String T_ELIM = "T_CSL_ELIMINATION";
    private static final String T_HISELIM = "T_CSL_HISELIMINATION";
    private static final String T_ELIM_ENTRY = "T_CSL_ElIMINATIONENTRY";
    private static final String T_HISELIM_ENTRY = "T_CSL_HISElIMINATIONENTRY";
    private static final String T_ADJUST = "T_CSL_ADJUST";
    private static final String T_ADJUST_ENTRY = "T_CSL_ADJUSTENTRY";
    private static final String T_COMPANY = "T_ORG_BASEUNIT";
    private static final String T_CURRENCY = "T_BD_CURRENCY";
    private static final String T_ITEM = "T_CSL_RPTITEM";
    private static final String SEPARATOR = "|";

    @Override
    public Map _getElimDataByItems(Context ctx, ItemDataCondition condition, boolean isQueryBudget) throws SumRptException, BOSException {
        try {
            return MnsRptCalcHelper._getElimByItems(ctx, condition, isQueryBudget);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected Map _getElimDataByItems(Context ctx, Map paramMap) throws BOSException, EASBizException {
        return MnsRptCalcHelper._getElimDataByItems(ctx, paramMap);
    }

    private BigDecimal _acctItem(Context ctx, String orgBound, String currency, String convertCurrency, ArrayList company, String itemNumberStart, String itemNumberEnd, int periodType, int dataSource, int dataElement, int valueType, int startYear, int endYear, int startPeriod, int endPeriod, int isAdjusted) throws BOSException {
        IItemDataProvider ie = ItemDataProviderFactory.getLocalInstance(ctx);
        ItemDataCondition condition = new ItemDataCondition();
        if (orgBound != null && orgBound.trim().length() > 0) {
            condition.setOrgTreeNumber(orgBound);
        }
        if (company != null && company.size() > 0) {
            condition.setOrgUnit(company);
        }
        if (currency != null && currency.trim().length() > 0) {
            condition.setCurrency(currency);
        }
        if (convertCurrency != null && convertCurrency.trim().length() > 0) {
            condition.setTargetCurrency(convertCurrency);
        }
        if (itemNumberStart != null && itemNumberStart.trim().length() > 0) {
            condition.setItemNumberStart(itemNumberStart);
        }
        if (itemNumberEnd != null && itemNumberEnd.trim().length() > 0) {
            condition.setItemNumberEnd(itemNumberEnd);
        }
        condition.setRptPeriodType(periodType);
        if (dataSource == 2) {
            int[] arrDataSrc = new int[]{1, 2};
            condition.setDataSourceString(arrDataSrc);
        } else {
            condition.setDataSource(dataSource);
        }
        condition.setDataElement(dataElement);
        condition.setValueType(valueType);
        condition.setRptYearStart(startYear);
        condition.setRptYearEnd(endYear);
        condition.setRptPeriodStart(startPeriod);
        condition.setRptPeriodEnd(endPeriod);
        condition.setIsAdjusted(isAdjusted == 1);
        condition.setCommitStatus(3);
        condition.setItemNumberLevelStart(0);
        condition.setItemNumberLevelEnd(5);
        BigDecimal bgResult = null;
        try {
            bgResult = ie.getAcctItem(condition, false);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        catch (BOSException e) {
            throw e;
        }
        return bgResult;
    }

    @Override
    public BigDecimal _acctItem(Context ctx, String orgBound, String currency, String convertCurrency, int dataSource, String company, String item, int periodType, int dataElement, int valueType, int startYear, int endYear, int startPeriod, int endPeriod, int isAdjusted) throws BOSException {
        ArrayList companyNumber = CslRptUtil.stringToArrayList(company, SEPARATOR);
        String[] itemNumber = CslRptUtil.getFirstAndLast(item, SEPARATOR);
        String startItemNumber = itemNumber[0];
        String endItemNumber = itemNumber[1];
        return this._acctItem(ctx, orgBound, currency, convertCurrency, companyNumber, startItemNumber, endItemNumber, periodType, dataSource, dataElement, valueType, startYear, endYear, startPeriod, endPeriod, isAdjusted);
    }

    @Override
    public BigDecimal _adjustData(Context ctx, String orgBound, String company, String item, String sourceCurrency, String currency, int periodType, int dataSource, int dataElement, int startYear, int endYear, int startPeriod, int endPeriod, boolean isIncludeUnAuditted, int dc, int valueType, String dataCollectNumber) throws BOSException {
        String[] itemNumber = CslRptUtil.getFirstAndLast(item, SEPARATOR);
        String startItemNumber = itemNumber[0];
        String endItemNumber = itemNumber[1];
        if (dc == 0) {
            return this._adjustData(ctx, orgBound, company, startItemNumber, endItemNumber, sourceCurrency, currency, periodType, dataSource, dataElement, startYear, endYear, startPeriod, endPeriod, isIncludeUnAuditted, dc, valueType, dataCollectNumber);
        }
        if (dc == 1) {
            return this._adjustData(ctx, orgBound, company, startItemNumber, endItemNumber, sourceCurrency, currency, periodType, dataSource, dataElement, startYear, endYear, startPeriod, endPeriod, isIncludeUnAuditted, dc, valueType, dataCollectNumber);
        }
        int itemDC = 0;
        try {
            String firstItemDCSQL = "select FDc from T_CSL_RPTItem where FNumber = '" + startItemNumber + "'";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)firstItemDCSQL);
            if (rs.next()) {
                itemDC = rs.getInt("FDc");
            }
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
        BigDecimal firstSum = this._adjustData(ctx, orgBound, company, startItemNumber, endItemNumber, sourceCurrency, currency, periodType, dataSource, dataElement, startYear, endYear, startPeriod, endPeriod, isIncludeUnAuditted, itemDC, valueType, dataCollectNumber);
        itemDC = itemDC == 0 ? 1 : 0;
        BigDecimal secondSum = this._adjustData(ctx, orgBound, company, startItemNumber, endItemNumber, sourceCurrency, currency, periodType, dataSource, dataElement, startYear, endYear, startPeriod, endPeriod, isIncludeUnAuditted, itemDC, valueType, dataCollectNumber);
        BigDecimal bgResult = firstSum.subtract(secondSum);
        bgResult = CslRptUtil.FormatData(ctx, currency, bgResult);
        return bgResult;
    }

    protected BigDecimal _adjustData(Context ctx, String orgBound, String companys, String startItemNumber, String endItemNumber, String sourceCurrency, String currency, int periodType, int dataType, int dataElement, int startYear, int endYear, int startPeriod, int endPeriod, boolean isIncludeUnAuditted, int dc, int valueType, String dataCollectNumber) throws BOSException {
        try {
            Map mapOrgTree = UnionVersionUtil.getOrgTreeByPeriods(ctx, orgBound, startYear, endYear, startPeriod, endPeriod, periodType);
            Set set = mapOrgTree.keySet();
            BigDecimal bgResult = SysConstant.BIGZERO;
            Iterator ite = set.iterator();
            while (ite.hasNext()) {
                String strOrgTreeID = ite.next().toString();
                Map mapPeriod = (Map)mapOrgTree.get(strOrgTreeID);
                bgResult = bgResult.add(this.getAdjustData(ctx, strOrgTreeID, companys, startItemNumber, endItemNumber, sourceCurrency, currency, periodType, dataType, dataElement, (Integer)mapPeriod.get("KEY_STARTYEAR"), (Integer)mapPeriod.get("KEY_ENDYEAR"), (Integer)mapPeriod.get("KEY_STARTPERIOD"), (Integer)mapPeriod.get("KEY_ENDPERIOD"), isIncludeUnAuditted, dc, valueType, dataCollectNumber));
            }
            return bgResult;
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private BigDecimal getAdjustData(Context ctx, String orgBoundID, String companys, String startItemNumber, String endItemNumber, String sourceCurrency, String currency, int periodType, int dataType, int dataElement, int startYear, int endYear, int startPeriod, int endPeriod, boolean isIncludeUnAuditted, int dc, int valueType, String dataCollectNumber) throws BOSException {
        try {
            StringBuffer sbEntrySQL = new StringBuffer();
            ArrayList<Object> lstParams = new ArrayList<Object>();
            String creditOrDebit = dc == 1 ? "FDebit" : "FCredit";
            sbEntrySQL.append("Select ISNULL(sum(").append(creditOrDebit).append("),0) as result from ");
            sbEntrySQL.append("T_CSL_ADJUSTENTRY adjustentry,");
            sbEntrySQL.append("T_CSL_RPTITEM item ");
            sbEntrySQL.append(" where adjustEntry.FitemID = item.FID ");
            sbEntrySQL.append(" and item.FNumber >= ? ");
            lstParams.add(startItemNumber);
            sbEntrySQL.append(" and item.FNumber <= ? ");
            lstParams.add(endItemNumber);
            sbEntrySQL.append(" and FdataElement= ? ");
            lstParams.add(new Integer(dataElement));
            sbEntrySQL.append(" and adjustentry.FAdjustID in(");
            sbEntrySQL.append("select adjust.fid from ");
            sbEntrySQL.append("T_CSL_ADJUST adjust ,");
            sbEntrySQL.append("T_ORG_BASEUNIT company ,");
            if (!StringUtils.isEmpty((String)sourceCurrency)) {
                sbEntrySQL.append("T_BD_CURRENCY sourceCurrency, ");
            }
            sbEntrySQL.append("T_BD_CURRENCY currency ");
            sbEntrySQL.append(" where adjust.FCurrencyID = currency.fid");
            if (!StringUtils.isEmpty((String)sourceCurrency)) {
                sbEntrySQL.append(" and adjust.FSourceCurrencyID = sourceCurrency.FID ");
            }
            sbEntrySQL.append(" and adjust.FOrgUnit = company.fid");
            sbEntrySQL.append(" and adjust.FOrgBoundID = ? ");
            lstParams.add(orgBoundID);
            sbEntrySQL.append(" and company.FNumber in (?)");
            lstParams.add(companys);
            sbEntrySQL.append(" and currency.FNumber = ? ");
            lstParams.add(currency);
            if (!StringUtils.isEmpty((String)sourceCurrency)) {
                sbEntrySQL.append(" and sourceCurrency.FNumber = ? ");
                lstParams.add(sourceCurrency);
            }
            sbEntrySQL.append(" and FDataSource = ? ");
            lstParams.add(new Integer(dataType));
            sbEntrySQL.append(" and FPeriodType = ? ");
            lstParams.add(new Integer(periodType));
            sbEntrySQL.append(" AND (FYear > ? or (FYear = ? AND FPeriod >= ? )) ");
            lstParams.add(new Integer(startYear));
            lstParams.add(new Integer(startYear));
            lstParams.add(new Integer(startPeriod));
            sbEntrySQL.append(" AND (FYear < ?  or (FYear = ? AND FPeriod <= ? )) ");
            lstParams.add(new Integer(endYear));
            lstParams.add(new Integer(endYear));
            lstParams.add(new Integer(endPeriod));
            if (!isIncludeUnAuditted) {
                sbEntrySQL.append(" and FCheckedStatus = ? ");
                lstParams.add(new Integer(2));
            }
            sbEntrySQL.append(" and FvalueType= ? ");
            lstParams.add(new Integer(valueType));
            sbEntrySQL.append(" and FDataCollectNumber = ? ");
            lstParams.add(dataCollectNumber);
            logger.debug((Object)sbEntrySQL.toString());
            sbEntrySQL.append(")");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbEntrySQL.toString(), (Object[])lstParams.toArray());
            BigDecimal bgResult = null;
            if (rs.next()) {
                bgResult = rs.getBigDecimal("result");
            }
            bgResult = CslRptUtil.FormatData(ctx, currency, bgResult);
            return bgResult;
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }

    @Override
    public BigDecimal _elimData(Context ctx, String orgBound, String company, String item, String sourceCurrency, String currency, int periodType, int dataElement, int startYear, int endYear, int startPeriod, int endPeriod, boolean isIncludeUnAuditted, int dc, int valueType) throws BOSException {
        String companyNumber = this.addComma(company, SEPARATOR);
        String[] itemNumber = CslRptUtil.getFirstAndLast(item, SEPARATOR);
        String startItemNumber = itemNumber[0];
        String endItemNumber = itemNumber[1];
        if (dc == 0) {
            return this._elimData(ctx, orgBound, companyNumber, startItemNumber, endItemNumber, sourceCurrency, currency, periodType, dataElement, startYear, endYear, startPeriod, endPeriod, isIncludeUnAuditted, dc, valueType);
        }
        if (dc == 1) {
            return this._elimData(ctx, orgBound, companyNumber, startItemNumber, endItemNumber, sourceCurrency, currency, periodType, dataElement, startYear, endYear, startPeriod, endPeriod, isIncludeUnAuditted, dc, valueType);
        }
        int itemDC = 0;
        try {
            String firstItemDCSQL = "Select FDc from T_CSL_RPTItem where FNumber = '" + startItemNumber + "'";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)firstItemDCSQL);
            if (rs.next()) {
                itemDC = rs.getInt("FDc");
            }
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
        BigDecimal firstSum = this._elimData(ctx, orgBound, companyNumber, startItemNumber, endItemNumber, sourceCurrency, currency, periodType, dataElement, startYear, endYear, startPeriod, endPeriod, isIncludeUnAuditted, itemDC, valueType);
        itemDC = itemDC == 0 ? 1 : 0;
        BigDecimal secondSum = this._elimData(ctx, orgBound, companyNumber, startItemNumber, endItemNumber, sourceCurrency, currency, periodType, dataElement, startYear, endYear, startPeriod, endPeriod, isIncludeUnAuditted, itemDC, valueType);
        BigDecimal bgResult = firstSum.subtract(secondSum);
        bgResult = CslRptUtil.FormatData(ctx, currency, bgResult);
        return bgResult;
    }

    protected BigDecimal _elimData(Context ctx, String orgBound, String companyIDs, String startItemNumber, String endItemNumber, String sourceCurrency, String currency, int periodType, int dataElement, int startYear, int endYear, int startPeriod, int endPeriod, boolean isIncludeUnAuditted, int dc, int valueType) throws BOSException {
        try {
            Map mapOrgTree = UnionVersionUtil.getOrgTreeByPeriods(ctx, orgBound, startYear, endYear, startPeriod, endPeriod, periodType);
            Set set = mapOrgTree.keySet();
            BigDecimal bgResult = SysConstant.BIGZERO;
            Iterator ite = set.iterator();
            while (ite.hasNext()) {
                String strOrgTreeID = ite.next().toString();
                Map mapPeriod = (Map)mapOrgTree.get(strOrgTreeID);
                bgResult = bgResult.add(this.getElimData(ctx, strOrgTreeID, companyIDs, startItemNumber, endItemNumber, sourceCurrency, currency, periodType, dataElement, (Integer)mapPeriod.get("KEY_STARTYEAR"), (Integer)mapPeriod.get("KEY_ENDYEAR"), (Integer)mapPeriod.get("KEY_STARTPERIOD"), (Integer)mapPeriod.get("KEY_ENDPERIOD"), isIncludeUnAuditted, dc, valueType));
            }
            return bgResult;
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private BigDecimal getElimData(Context ctx, String orgBoundID, String companys, String startItemNumber, String endItemNumber, String sourceCurrency, String currency, int periodType, int dataElement, int startYear, int endYear, int startPeriod, int endPeriod, boolean isIncludeUnAuditted, int dc, int valueType) throws BOSException {
        try {
            StringBuffer elimSQL = new StringBuffer();
            if (dc == 0) {
                elimSQL.append("SELECT ISNULL(SUM(ElimEntry.FCredit),0) AS result From ");
            } else if (dc == 1) {
                elimSQL.append("SELECT ISNULL(SUM(ElimEntry.FDebit),0) AS result From ");
            }
            elimSQL.append("T_CSL_ELIMINATION Elim , ");
            elimSQL.append("T_CSL_ElIMINATIONENTRY ElimEntry , ");
            elimSQL.append("T_CSL_RPTITEM item , ");
            elimSQL.append("T_ORG_BASEUNIT company , ");
            if (!StringUtils.isEmpty((String)sourceCurrency)) {
                elimSQL.append("T_BD_CURRENCY sourceCurrency, ");
            }
            elimSQL.append("T_BD_CURRENCY currency ");
            elimSQL.append(" where ");
            if (!StringUtils.isEmpty((String)sourceCurrency)) {
                elimSQL.append(" Elim.FSourceCurrencyID = sourceCurrency.FID and ");
            }
            elimSQL.append(" Elim.FCurrencyID = currency.FID  ");
            elimSQL.append(" and ElimEntry.FCompanyId = company.FID  ");
            elimSQL.append(" and ElimEntry.FEliminationID = Elim.FID  ");
            elimSQL.append(" and ElimEntry.FItemID = item.FID  ");
            elimSQL.append(" and Elim.FOrgBoundID = '" + orgBoundID + "'");
            if (!StringUtils.isEmpty((String)sourceCurrency)) {
                elimSQL.append(" and sourceCurrency.FNumber = '" + sourceCurrency + "'");
            }
            elimSQL.append(" and currency.FNumber = '" + currency + "'");
            elimSQL.append(" and company.FNumber in(" + companys + ")");
            elimSQL.append(" and item.FNumber >= '" + startItemNumber + "'");
            elimSQL.append(" and item.FNumber <= '" + endItemNumber + "'");
            elimSQL.append(" and elim.FPeriodType = " + periodType);
            elimSQL.append(" and ElimEntry.FDataElement = " + dataElement);
            elimSQL.append(" and elim.FValueType = " + valueType);
            elimSQL.append(" AND (elim.FYear > " + startYear + " or (elim.FYear =" + startYear + " AND elim.FPeriod >=" + startPeriod + ")) ");
            elimSQL.append(" AND (elim.FYear < " + endYear + " or (elim.FYear =" + endYear + " AND elim.FPeriod <=" + endPeriod + ")) ");
            if (!isIncludeUnAuditted) {
                elimSQL.append(" and elim.FCheckedStatus = 2 ");
            }
            logger.debug((Object)elimSQL.toString());
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)elimSQL.toString());
            BigDecimal bgResult = null;
            if (rs.next()) {
                bgResult = rs.getBigDecimal("result");
            }
            bgResult = CslRptUtil.FormatData(ctx, currency, bgResult);
            return bgResult;
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }

    private String addComma(String src, String SEPARATOR) {
        if (src == null || src.trim().length() == 0) {
            return null;
        }
        if (src.indexOf(SEPARATOR) == -1) {
            return "'" + src + "'";
        }
        String[] arrSrc = src.split(SEPARATOR);
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < arrSrc.length; ++i) {
            if (arrSrc[i] == null || arrSrc[i].trim().length() <= 0) continue;
            result.append("'" + arrSrc[i] + "'");
            result.append(",");
        }
        if (result.toString().endsWith(",")) {
            result.deleteCharAt(result.lastIndexOf(","));
        }
        return result.toString();
    }

    @Override
    public BigDecimal _acctAC(Context ctx, String fiOrgUnit, String destFiOrgUnit, String acctItem, String balanceType, int startYear, int startPeriod, int endYear, int endPeriod, String currency, boolean includeUnposted) throws BOSException, EASBizException {
        BigDecimal result;
        block19: {
            if (StringUtils.isEmpty((String)fiOrgUnit)) {
                throw new CslRptCalcException(CslRptCalcException.SOURCE_COMPANY_IS_EMPTY);
            }
            if (StringUtils.isEmpty((String)destFiOrgUnit)) {
                throw new CslRptCalcException(CslRptCalcException.DEST_COMPANY_IS_EMPTY);
            }
            if (StringUtils.isEmpty((String)acctItem)) {
                throw new CslRptCalcException(CslRptCalcException.ACCT_AND_ITEM_IS_EMPTY);
            }
            IAsstActType asstActType = AsstActTypeFactory.getLocalInstance((Context)ctx);
            IReportCacl reportCacl = ReportCaclFactory.getLocalInstance((Context)ctx);
            String[] arrAcctItem = StringUtils.split((String)acctItem.trim(), (String)SEPARATOR);
            if (arrAcctItem.length <= 1) {
                throw new CslRptCalcException(CslRptCalcException.ACCT_AND_ITEM_IS_EMPTY);
            }
            if (StringUtils.isEmpty((String)balanceType)) {
                throw new CslRptCalcException(CslRptCalcException.BALANCE_TYPE_IS_EMPTY);
            }
            result = new BigDecimal("0.00");
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            FilterItemCollection fic = filter.getFilterItems();
            fic.add(new FilterItemInfo("number", (Object)arrAcctItem[1]));
            filter.setMaskString("#0");
            AsstActTypeCollection asstActTypeCL = asstActType.getAsstActTypeCollection(view);
            if (asstActTypeCL.size() <= 0) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"ASSTACCTTYPE_NOT_FOUND", (Locale)ctx.getOriginLocale()));
            }
            AsstActTypeInfo asstActTypeInfo = asstActTypeCL.get(0);
            String strAsstActType = asstActTypeInfo.getAsstHGAttribute();
            BalanceTypeEnum balType = BalanceTypeEnum.getEnum((String)balanceType.toUpperCase());
            if (strAsstActType.equalsIgnoreCase("companyOrg")) {
                if (StringUtils.isEmpty((String)arrAcctItem[2])) {
                    if (!acctItem.substring(acctItem.length() - 1, acctItem.length()).equals(SEPARATOR)) {
                        acctItem = acctItem + SEPARATOR;
                    }
                    return reportCacl.acct(fiOrgUnit, acctItem + destFiOrgUnit, balType, startYear, startPeriod, endYear, endPeriod, currency, false, includeUnposted, false);
                }
                return reportCacl.acct(fiOrgUnit, acctItem, balType, startYear, startPeriod, endYear, endPeriod, currency, false, includeUnposted, false);
            }
            if (strAsstActType.equalsIgnoreCase("customer") || strAsstActType.equalsIgnoreCase("provider")) {
                if (StringUtils.isEmpty((String)arrAcctItem[2])) {
                    String strSql = null;
                    String strCompanyTable = null;
                    String strCSFID = null;
                    ArrayList<String> params = new ArrayList<String>();
                    if (strAsstActType.equalsIgnoreCase("customer")) {
                        strCompanyTable = "T_BD_Customer CsBase,";
                        strCSFID = "FCustomerID";
                    } else {
                        strCompanyTable = "T_BD_Supplier CsBase,";
                        strCSFID = "FSupplierID";
                    }
                    strSql = "Select CsBase.FNumber Fnumber From " + strCompanyTable + " T_Org_BaseUnit inCompany Where  CsBase.FInternalCompanyID = inCompany.FID and inCompany.Fnumber = ? ";
                    params.add(destFiOrgUnit);
                    IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)strSql, (Object[])params.toArray());
                    if (!acctItem.substring(acctItem.length() - 1, acctItem.length()).equals(SEPARATOR)) {
                        acctItem = acctItem + SEPARATOR;
                    }
                    try {
                        boolean isExists = false;
                        while (rowSet.next()) {
                            isExists = true;
                            result = result.add(reportCacl.acct(fiOrgUnit, acctItem + rowSet.getString("Fnumber"), balType, startYear, startPeriod, endYear, endPeriod, currency, true, includeUnposted, false));
                        }
                        if (!isExists) {
                            throw new CslRptCalcException(CslRptCalcException.ITEMDATASERVICENOCUSTOMERNUMBER);
                        }
                        break block19;
                    }
                    catch (SQLException e) {
                        throw new SQLDataException(e);
                    }
                }
                result = result.add(reportCacl.acct(fiOrgUnit, acctItem, balType, startYear, startPeriod, endYear, endPeriod, currency, true, includeUnposted, false));
            } else {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.AssitTypeIsNotFilt", (Locale)ctx.getOriginLocale()));
            }
        }
        result = CslRptUtil.FormatData(ctx, currency, result);
        return result;
    }

    @Override
    protected Map _getElimDataEntryByItem(Context ctx, List params, String orgTreeID, String orgUnitID, String currencyID, int periodType, int iYear, int iPeriod, String dataCollectNumber, boolean isQueryBudget) throws BOSException, EASBizException {
        return MnsRptCalcHelper._getElimDataEntryByItem(ctx, params, orgTreeID, orgUnitID, currencyID, periodType, iYear, iPeriod, dataCollectNumber, isQueryBudget);
    }
}

