/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.variant.Util;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.ReportBizException;
import com.kingdee.eas.fi.gr.cslrpt.IRPTItem;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.RelatedPartyCollection;
import com.kingdee.eas.fi.gr.cslrpt.RelatedPartyFactory;
import com.kingdee.eas.fi.gr.cslrpt.RelatedPartyInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.AbstractRelatedPartySumControllerBean;
import com.kingdee.eas.fi.gr.cslrpt.app.QueryHisBudgetUtils;
import com.kingdee.eas.fi.gr.cslrpt.util.RptProperties;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.KDTableHeaderModel;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class RelatedPartySumControllerBean
extends AbstractRelatedPartySumControllerBean {
    private static String replacement = "\\_";

    protected Map _init(Context ctx, CompanyOrgUnitInfo company) throws BOSException, ReportBizException, EASBizException {
        if (company == null) {
            throw new ReportBizException(ReportBizException.COMPANY_EMPTY);
        }
        HashMap initMap = new HashMap();
        return initMap;
    }

    @Override
    protected RptRowSet _createRelatedPartySumTempTable(Context ctx, RptProperties params) throws BOSException, ReportBizException, EASBizException {
        String tableName = params.getString("tableName");
        if (!StringUtils.isEmpty((String)tableName)) {
            DbUtil.execute((Context)ctx, (String)(" drop table " + tableName));
        }
        tableName = "Tmp_Related_" + System.currentTimeMillis();
        int year = params.getInt("year");
        int period = params.getInt("period");
        int periodType = params.getInt("periodType");
        String treeId = params.getString("treeId");
        String currencyId = params.getString("currencyId");
        String orgGroup = params.getString("orgGroup");
        boolean isQueryHisBudget = params.getBoolean("isQueryHisBudget");
        String rptReceiveTabName = QueryHisBudgetUtils.getRptReceiveTabName(isQueryHisBudget);
        StringBuffer investCompany = new StringBuffer();
        investCompany.append("select t2.fid, t2.fname_" + ctx.getLocale());
        investCompany.append(" from t_org_ouPartUnionGroup t1 join t_org_baseunit t2");
        investCompany.append(" on t1.fstockControlCompanyId = t2.fid");
        investCompany.append(" where funitid = '" + orgGroup + "'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)investCompany.toString());
        String companyId = "";
        String companyName = "";
        try {
            if (!rowSet.next()) {
                throw new EASBizException(new NumericExceptionSubItem("1", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_OrgBound_InvestCompanyIsNull", (Locale)ctx.getOriginLocale())));
            }
            companyId = rowSet.getString(1);
            companyName = rowSet.getString(2);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        OrgUnitCollection attachCompanys = this.getAttachCompanys(ctx, treeId, orgGroup, companyId);
        if (attachCompanys == null || attachCompanys.isEmpty()) {
            throw new EASBizException(new NumericExceptionSubItem("1", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"RelatedPartySum_InvestCompanyIsNull", (Locale)ctx.getOriginLocale())));
        }
        StringBuffer fromWhere = new StringBuffer();
        fromWhere.append(" from t_csl_interItemData t1 join ").append(rptReceiveTabName).append(" t2");
        fromWhere.append(" on t1.freport = t2.freportid");
        fromWhere.append(" where t1.FCommitStatus = ").append(3);
        fromWhere.append(" and t1.fcompanyid in (");
        boolean isfirst = true;
        StringBuffer excludeCompanyIds = new StringBuffer();
        for (int i = 0; i < attachCompanys.size(); ++i) {
            if (!isfirst) {
                fromWhere.append(",");
                excludeCompanyIds.append(",");
            } else {
                isfirst = false;
            }
            OrgUnitInfo info = attachCompanys.get(i);
            fromWhere.append("'").append(info.getId().toString()).append("'");
            excludeCompanyIds.append("'").append(info.getId().toString()).append("'");
        }
        fromWhere.append(")");
        if (year > 0) {
            fromWhere.append(" and t1.fyear = " + year);
        }
        if (period > 0) {
            fromWhere.append(" and t1.fperiod = " + period);
        }
        if (periodType > 0) {
            fromWhere.append(" and t1.fperiodtype = " + periodType);
        }
        if (!StringUtils.isEmpty((String)treeId)) {
            fromWhere.append(" and t2.forgTreeid = '" + treeId + "'");
        }
        if (!StringUtils.isEmpty((String)currencyId)) {
            fromWhere.append(" and t1.ftargetcurrencyid = '" + currencyId + "'");
        }
        fromWhere.append(" group by t1.fitemNumber, t1.fcompanyid, t1.ftargetCompanyid");
        StringBuffer itemNumber = new StringBuffer();
        itemNumber.append("select distinct t1.fitemnumber").append(fromWhere);
        itemNumber.append(" order by t1.fitemnumber");
        rowSet = DbUtil.executeQuery((Context)ctx, (String)itemNumber.toString());
        ArrayList<String> columns = new ArrayList<String>();
        StringBuffer create = new StringBuffer();
        create.append("create table " + tableName);
        create.append(" (FId varchar(44) not null primary key,");
        create.append(" FTargetCompanyId varchar(44),");
        create.append(" FTargetCompanyName nvarchar(200),");
        create.append(" FRelatedPartyNumber nvarchar(80)");
        try {
            while (rowSet.next()) {
                String number = this.convertItemNumber(rowSet.getString(1));
                columns.add(number);
                create.append(", F" + number + " NUMERIC(21,6)");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        create.append(")");
        tableName = this._createTable(ctx, create.toString());
        String tmpTableName = "Tmp_Related_" + System.currentTimeMillis();
        StringBuffer createTmp = new StringBuffer();
        createTmp.append("create table " + tmpTableName);
        createTmp.append(" (FItemNumber nvarchar(80),");
        createTmp.append(" FCompanyId varchar(44),");
        createTmp.append(" FTargetCompanyId varchar(44),");
        createTmp.append(" FTargetCompanyName nvarchar(200),");
        createTmp.append(" FSumMoney NUMERIC(21,6))");
        tmpTableName = this._createTable(ctx, createTmp.toString());
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tmpTableName);
        sql.append(" select a.fitemnumber, a.FCompanyId, a.ftargetCompanyid, b.fname_" + ctx.getLocale());
        sql.append(" as ftargetCompanyName,");
        sql.append(" a.fsumMoney from (");
        sql.append("select t1.fitemnumber, t1.fcompanyid, t1.ftargetCompanyid, sum(t1.fmoney) as fsumMoney");
        sql.append(fromWhere).append(") a");
        sql.append(" join t_org_baseUnit b on a.ftargetCompanyid = b.fid");
        this._executeUpdate(ctx, sql.toString());
        RelatedPartyCollection relatedParties = RelatedPartyFactory.getLocalInstance(ctx).getRelatedPartyCollection();
        this.importData(ctx, companyId, tmpTableName, tableName, attachCompanys, excludeCompanyIds.toString());
        Iterator iter = relatedParties.iterator();
        while (iter.hasNext()) {
            RelatedPartyInfo relatedParty = (RelatedPartyInfo)iter.next();
            this.createTotalOfRelatedParty(ctx, relatedParty.getNumber(), tableName, columns);
        }
        DbUtil.execute((Context)ctx, (String)(" drop table " + tmpTableName));
        if (!columns.isEmpty()) {
            StringBuffer count = new StringBuffer();
            count.append("insert into " + tableName);
            count.append(" select '" + Uuid.create().toString() + ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"256_RelatedPartySumControllerBean", (Locale)ctx.getOriginLocale()));
            for (int i = 0; i < columns.size(); ++i) {
                count.append(", sum(f" + columns.get(i) + ")");
            }
            count.append(" from " + tableName);
            count.append(" where ftargetCompanyId <> '-1'");
            this._executeUpdate(ctx, count.toString());
        }
        RptRowSet rst = new RptRowSet(new String[0], (Object[][])new Object[0][]);
        rst.setProperty("tableHeader", (Object)this.createHeader(ctx, columns));
        rst.setProperty("tableName", (Object)tableName);
        rst.setProperty("companyName", (Object)companyName);
        CurrencyInfo cur = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectStringPK(currencyId));
        rst.setProperty("currencyName", (Object)cur.getName());
        return rst;
    }

    private OrgUnitCollection getAttachCompanys(Context ctx, String treeId, String orgGroup, String companyId) throws BOSException, EASBizException {
        FullOrgUnitInfo info = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectStringPK(companyId));
        OrgUnitCollection result = new OrgUnitCollection();
        result.add((OrgUnitInfo)info);
        StringBuffer sql = new StringBuffer();
        sql.append("select FLongNumber from t_org_structure");
        sql.append(" where FTreeid = '").append(treeId);
        sql.append("' and FUnitId = '").append(orgGroup).append("'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rowSet.next()) {
                String longNumber = rowSet.getString("FLongNumber");
                sql = new StringBuffer();
                sql.append("select *,unit.id, unit.name, unit.number");
                sql.append(" where tree.id = '").append(treeId);
                sql.append("' and unit.isGrouping = 0");
                sql.append(" and longNumber like '").append(longNumber).append("!%'");
                sql.append(" and unit.id in (");
                sql.append("select re.FInvestCompanyID from t_csl_relatedPartyRela re");
                sql.append(" join t_csl_relatedParty rt on re.FRelationShipId = rt.FId");
                sql.append(" where rt.FNumber = '001'");
                sql.append(" and re.FControlCompanyId = '").append(companyId);
                sql.append("')");
                OrgStructureCollection strucInfos = OrgStructureFactory.getLocalInstance((Context)ctx).getOrgStructureCollection(sql.toString());
                if (strucInfos.size() != 0) {
                    for (int i = 0; i < strucInfos.size(); ++i) {
                        result.add((OrgUnitInfo)strucInfos.get(i).getUnit());
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return result;
    }

    private KDTableHeaderModel createHeader(Context ctx, ArrayList columns) throws EASBizException, BOSException {
        int size = columns.size();
        String[][] hd = new String[1][size + 4];
        int[] align = new int[size + 4];
        int[] width = new int[size + 4];
        String[] format = new String[size + 4];
        hd[0][0] = "id";
        align[0] = 0;
        width[0] = 0;
        format[0] = "";
        hd[0][1] = "id";
        align[1] = 0;
        width[1] = 0;
        format[1] = "";
        hd[0][2] = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"RelationParty", (Locale)ctx.getOriginLocale());
        align[2] = 0;
        width[2] = 120;
        format[2] = "";
        hd[0][3] = "number";
        align[3] = 0;
        width[3] = 0;
        format[3] = "";
        IRPTItem irptItem = RPTItemFactory.getLocalInstance(ctx);
        for (int i = 0; i < size; ++i) {
            String number = (String)columns.get(i);
            number = number.replaceAll(replacement, "\\.");
            RPTItemInfo item = irptItem.getRPTItemInfo(" where number = '" + number + "'");
            hd[0][i + 4] = item.getName();
            align[i + 4] = 2;
            width[i + 4] = 100;
            format[i + 4] = "%R-{#,##0.00}f";
        }
        KDTableHeaderModel mm = new KDTableHeaderModel();
        mm.setHiddenColumnIndexices(new int[]{0, 1, 3});
        mm.setData(hd);
        mm.setAlignColumns(align);
        mm.setColumnsFormat(format);
        mm.setColumnWidths(width);
        return mm;
    }

    private boolean hasTitleOfRelatedParty(Context ctx, String relatedPartyNumber, String tableName) throws BOSException {
        String sql = "select FId from " + tableName + " where FRelatedPartyNumber = '" + relatedPartyNumber + "'";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        return rowSet.size() > 0;
    }

    private void createTitleOfRelatedParty(Context ctx, String relatedPartyNumber, String tableName) throws BOSException, EASBizException {
        RelatedPartyInfo info = RelatedPartyFactory.getLocalInstance(ctx).getRelatedPartyInfo("select id, name where number = '" + relatedPartyNumber + "'");
        String uuid = Uuid.create().toString();
        uuid = uuid.replaceAll(uuid.substring(0, 8), "00000000");
        String title = "insert into " + tableName + " (FId, FTargetCompanyId, FTargetCompanyName, FRelatedPartyNumber) values ('" + uuid + "', '" + info.getId().toString() + "', '" + info.getName() + "', '" + relatedPartyNumber + "')";
        this._executeUpdate(ctx, title);
    }

    private String getRelatedPartyNumber(Context ctx, String thisCompanyId, String thatCompanyId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select rt.FNumber from t_csl_relatedParty rt join t_csl_relatedPartyRela re");
        sql.append(" on rt.FId = re.FRelationShipID");
        sql.append(" where re.FInvestCompanyID = ? and re.FControlCompanyID = ?");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{thisCompanyId, thatCompanyId});
        try {
            String number;
            if (rowSet.next()) {
                String number2 = rowSet.getString(1);
                if (!number2.equals("001")) {
                    return number2;
                }
                return null;
            }
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{thatCompanyId, thisCompanyId});
            if (rowSet.next() && ((number = rowSet.getString(1)).equals("002") || number.equals("007"))) {
                return number;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return null;
    }

    private void importData(Context ctx, String investCompanyId, String from, String to, OrgUnitCollection attachCompanys, String excludeCompanyIds) throws BOSException, EASBizException {
        String params = "";
        String values = "";
        StringBuffer setClause = null;
        HashMap<String, BigDecimal> sum = new HashMap<String, BigDecimal>();
        int size = 0;
        for (OrgUnitInfo info : attachCompanys) {
            String companyId = info.getId().toString();
            params = "";
            values = "";
            setClause = new StringBuffer("");
            StringBuffer sql = new StringBuffer();
            sql.append("select fitemnumber, ftargetCompanyId,'  ' || ftargetCompanyName, fsumMoney");
            sql.append(" from " + from);
            sql.append(" where FCompanyId = '").append(companyId);
            sql.append("' order by ftargetCompanyId");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            String controlCompanyId = null;
            String targetCompanyName = "";
            size += rowSet.size();
            try {
                String relatedPartyNumber = null;
                while (rowSet.next()) {
                    String targetCompanyId = rowSet.getString(2);
                    if (rowSet.isFirst()) {
                        controlCompanyId = targetCompanyId;
                        relatedPartyNumber = this.getRelatedPartyNumber(ctx, controlCompanyId, investCompanyId);
                    }
                    if (StringUtils.equals((String)controlCompanyId, (String)targetCompanyId) && relatedPartyNumber == null) continue;
                    if (!StringUtils.equals((String)controlCompanyId, (String)targetCompanyId)) {
                        if (relatedPartyNumber != null) {
                            if (!this.hasTitleOfRelatedParty(ctx, relatedPartyNumber, to)) {
                                this.createTitleOfRelatedParty(ctx, relatedPartyNumber, to);
                            }
                            if (this.hasRecordInTable(ctx, to, controlCompanyId)) {
                                if (!setClause.toString().equals("")) {
                                    StringBuffer update = new StringBuffer();
                                    update.append("update " + to);
                                    update.append(" set " + setClause.toString().substring(1));
                                    update.append(" where FTargetCompanyId = '").append(controlCompanyId).append("'");
                                    this._executeUpdate(ctx, update.toString());
                                }
                            } else {
                                StringBuffer insert = new StringBuffer();
                                insert.append("insert into " + to);
                                insert.append("(fid, ftargetCompanyId, ftargetCompanyName, FRelatedPartyNumber" + params);
                                insert.append(") values ('" + Uuid.create().toString());
                                insert.append("', '" + controlCompanyId + "', '");
                                insert.append(targetCompanyName + "', '" + relatedPartyNumber);
                                insert.append("'" + values + ")");
                                this._executeUpdate(ctx, insert.toString());
                            }
                        }
                        params = "";
                        values = "";
                        setClause = new StringBuffer("");
                        controlCompanyId = targetCompanyId;
                        relatedPartyNumber = this.getRelatedPartyNumber(ctx, controlCompanyId, investCompanyId);
                    }
                    String key = "f" + this.convertItemNumber(rowSet.getString(1));
                    BigDecimal value = rowSet.getBigDecimal(4);
                    params = params + ", " + key;
                    values = values + ", " + value;
                    setClause.append(", " + key + " = ").append(key + " + " + Util.bigDecimalToPlainString((BigDecimal)value));
                    targetCompanyName = rowSet.getString(3);
                    if (sum.containsKey(key)) {
                        value = value.add((BigDecimal)sum.get(key));
                    }
                    sum.put(key, value);
                    if (!rowSet.isLast() || relatedPartyNumber == null) continue;
                    if (!this.hasTitleOfRelatedParty(ctx, relatedPartyNumber, to)) {
                        this.createTitleOfRelatedParty(ctx, relatedPartyNumber, to);
                    }
                    if (this.hasRecordInTable(ctx, to, targetCompanyId)) {
                        if (setClause.toString().equals("")) continue;
                        StringBuffer update = new StringBuffer();
                        update.append("update " + to);
                        update.append(" set " + setClause.toString().substring(1));
                        update.append(" where FTargetCompanyId = '").append(targetCompanyId).append("'");
                        this._executeUpdate(ctx, update.toString());
                        continue;
                    }
                    StringBuffer insert = new StringBuffer();
                    insert.append("insert into " + to);
                    insert.append("(fid, ftargetCompanyId, ftargetCompanyName, FRelatedPartyNumber" + params);
                    insert.append(") values ('" + Uuid.create().toString());
                    insert.append("', '" + targetCompanyId + "', '");
                    insert.append(targetCompanyName + "', '" + relatedPartyNumber);
                    insert.append("'" + values + ")");
                    this._executeUpdate(ctx, insert.toString());
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
    }

    private boolean hasRecordInTable(Context ctx, String to, String targetCompanyId) throws BOSException {
        String sql = "select FId from " + to + " where FTargetCompanyId = '" + targetCompanyId + "'";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        return rowSet.size() > 0;
    }

    private void createTotalOfRelatedParty(Context ctx, String relatedPartyNumber, String tableName, List columns) throws BOSException {
        if (!this.hasTitleOfRelatedParty(ctx, relatedPartyNumber, tableName)) {
            return;
        }
        StringBuffer count = new StringBuffer();
        count.append("insert into " + tableName);
        StringBuffer params = new StringBuffer();
        params.append("fid, ftargetCompanyId, ftargetCompanyName, FRelatedPartyNumber");
        StringBuffer select = new StringBuffer();
        String uuid = Uuid.create().toString();
        uuid = uuid.replaceAll(uuid.substring(0, 8), "zzzzzzzz");
        select.append("'" + uuid + ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"257_RelatedPartySumControllerBean", (Locale)ctx.getOriginLocale()));
        select.append(relatedPartyNumber + "'");
        for (int i = 0; i < columns.size(); ++i) {
            String key = (String)columns.get(i);
            params.append(", F" + key);
            select.append(", sum(F" + key + ")");
        }
        count.append(" (" + params.toString() + ")");
        count.append(" select " + select.toString());
        count.append(" from " + tableName);
        count.append(" where FRelatedPartyNumber = '" + relatedPartyNumber + "'");
        this._executeUpdate(ctx, count.toString());
    }

    private String convertItemNumber(String number) {
        return number.replaceAll("\\.", replacement);
    }

    @Override
    protected RptRowSet _queryRelatedPartySum(Context ctx, String tableName, int fromIndex, int length) throws BOSException, ReportBizException, EASBizException {
        RptRowSet rst;
        StringBuffer sql = new StringBuffer();
        sql.append("select * from " + tableName);
        sql.append(" order by FRelatedPartyNumber, FId");
        Connection con = null;
        try {
            con = this.getConnection(ctx);
            rst = DBUtil.executeQuery((String)sql.toString(), null, (int)fromIndex, (int)length, (Connection)con);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
        if (fromIndex > 0) {
            return rst;
        }
        StringBuffer countSql = new StringBuffer();
        countSql.append("select count(1) from ").append(tableName);
        rst.setVirtualRowCount(this._getRecordCount(ctx, countSql.toString(), null));
        if (rst.getVirtualRowCount() == 1) {
            rst.removeRow(0);
            rst.setVirtualRowCount(0);
        }
        return rst;
    }
}

