/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app.convt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.ConvertStatusEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.app.convt.ConvtParamsManager;
import com.kingdee.eas.fi.gr.cslrpt.app.convt.HistoryExchRateConvtUtil;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class AbstractHistoryRateConv {
    protected int dataElementValue;
    protected Context ctx;
    protected ConvtParamsManager pm;

    public AbstractHistoryRateConv(int dataElementValue, Context ctx, ConvtParamsManager pm) {
        this.dataElementValue = dataElementValue;
        this.ctx = ctx;
        this.pm = pm;
    }

    public void setDataElementValue(int dataElementValue) {
        this.dataElementValue = dataElementValue;
    }

    public BigDecimal caclConvertValueByHistoryExchgRate(CslReportInfo report, ItemFormula itemFormula, BigDecimal curValue, Map mapInitYearData, OrgTreeInfo orgTreeInfo) throws BOSException, EASBizException {
        switch (this.dataElementValue) {
            case 5: {
                return this.caclConvertValueByHistoryYTBegin(report, itemFormula, curValue, mapInitYearData, orgTreeInfo);
            }
            case 1: {
                return this.caclConvertValueByHistoryBeginbalance(report, itemFormula, curValue, mapInitYearData, orgTreeInfo);
            }
            case 4: {
                return this.caclConvertValueByHistoryEndbalance(report, itemFormula, curValue, mapInitYearData, orgTreeInfo);
            }
            case 2: {
                return this.caclConvertValueByHistoryAmount(report, itemFormula, curValue, mapInitYearData, orgTreeInfo);
            }
            case 3: {
                return this.caclConvertValueByHistoryYTDAmount(report, itemFormula, curValue, mapInitYearData, orgTreeInfo);
            }
        }
        return this.caclConvertValueByHistoryOtherType(report, itemFormula, curValue, mapInitYearData, orgTreeInfo);
    }

    protected BigDecimal caclConvertValueByHistoryYTBegin(CslReportInfo report, ItemFormula itemFormula, BigDecimal curValue, Map mapInitYearData, OrgTreeInfo orgTreeInfo) throws BOSException, EASBizException {
        return HistoryExchRateConvtUtil.getYearInitItemData(this.ctx, report, itemFormula, mapInitYearData, ConvertStatusEnum.Converted, orgTreeInfo, this.pm);
    }

    protected BigDecimal caclConvertValueByHistoryBeginbalance(CslReportInfo report, ItemFormula itemFormula, BigDecimal curValue, Map mapInitYearData, OrgTreeInfo orgTreeInfo) throws BOSException, EASBizException {
        return HistoryExchRateConvtUtil.getPeriodInitItemData(this.ctx, report, itemFormula, orgTreeInfo, this.pm);
    }

    protected BigDecimal caclConvertValueByHistoryOtherType(CslReportInfo report, ItemFormula itemFormula, BigDecimal curValue, Map mapInitYearData, OrgTreeInfo orgTreeInfo) throws BOSException, EASBizException {
        return this.caclConvertValueByHistory(report, itemFormula, curValue, mapInitYearData, orgTreeInfo, null);
    }

    protected BigDecimal caclConvertValueByHistory(CslReportInfo report, ItemFormula itemFormula, BigDecimal curValue, Map mapInitYearData, OrgTreeInfo orgTreeInfo, BigDecimal bgYearInitConvertedValue) throws BOSException, EASBizException {
        BigDecimal bgResultValue = null;
        switch (this.pm.getHisRateConvertType()) {
            case 1: {
                bgResultValue = HistoryExchRateConvtUtil.getConvertValueByHisRate(this.ctx, report, itemFormula, this.dataElementValue, orgTreeInfo, this.pm);
                break;
            }
            case 2: {
                bgResultValue = HistoryExchRateConvtUtil.getConvertValueByEndRate(this.ctx, report, itemFormula, mapInitYearData, curValue, this.dataElementValue, orgTreeInfo, this.pm);
                break;
            }
            case 3: {
                bgResultValue = HistoryExchRateConvtUtil.getConvertValueByAvgRate(this.ctx, report, itemFormula, mapInitYearData, curValue, this.dataElementValue, orgTreeInfo, this.pm);
                break;
            }
        }
        if (bgYearInitConvertedValue != null && bgResultValue != null) {
            return bgYearInitConvertedValue.add(bgResultValue);
        }
        if (bgYearInitConvertedValue == null) {
            return bgResultValue;
        }
        return null;
    }

    protected IRowSet getHisExchgRateRowSet(Context ctx, CslReportInfo report, ItemFormula itemFormula, OrgTreeInfo orgTreeInfo, ConvtParamsManager paramsManager) throws BOSException, EASBizException {
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer strSql = new StringBuffer();
        strSql.append(this.getHisExchgRateSQLSelect());
        strSql.append("from T_CSL_ItemHisExchgRate as ItemHisExchgRate\n\t");
        RptSrcTypeEnum rptSrcTypeEnum = report.getSourceType();
        if (rptSrcTypeEnum.equals((Object)RptSrcTypeEnum.CONSOLIDATION) || rptSrcTypeEnum.equals((Object)RptSrcTypeEnum.SUM)) {
            strSql.append("inner join T_ORG_Tree as OrgTree on ItemHisExchgRate.FOrgBoundID = OrgTree.FID\n\t");
            strSql.append("inner join T_ORG_BaseUnit as OrgUnit on ItemHisExchgRate.FOrgBoundGrpID = OrgUnit.FID\n\t");
        } else {
            strSql.append("inner join T_ORG_BaseUnit as OrgUnit on ItemHisExchgRate.FCompanyID = OrgUnit.FID\n\t");
        }
        strSql.append("inner join T_CSL_RptItem as RptItem on ItemHisExchgRate.FItemID = RptItem.FID\n\t");
        strSql.append("left outer join T_CSL_ItemHisExchgPromRate as ItemHisExchgPromRate on ItemHisExchgRate.FID = ItemHisExchgPromRate.FItemHisExchgRateID and ItemHisExchgPromRate.FCurrencyID = ?\n\t");
        params.add(paramsManager.getTargetCurrencyInfo().getId().toString());
        strSql.append("where  ");
        strSql.append(" ItemHisExchgRate.FCurrencyID = ? \n\t");
        params.add(report.getCurrency().getId().toString());
        strSql.append("and RptItem.FNumber = ? \n\t");
        params.add(itemFormula.getItemNumber());
        if (rptSrcTypeEnum.equals((Object)RptSrcTypeEnum.CONSOLIDATION) || rptSrcTypeEnum.equals((Object)RptSrcTypeEnum.SUM)) {
            strSql.append(this.getOrgUnitBoundFilterSql(orgTreeInfo.getId().toString(), report.getOrgUnit().getId().toString(), params, report, itemFormula));
        } else {
            strSql.append("and ItemHisExchgRate.FCompanyID = ? \n\t");
            params.add(report.getOrgUnit().getId().toString());
            strSql.append(" and ItemHisExchgRate.FBoundType = ?");
            params.add(new Integer(2));
        }
        strSql.append(this.getHisExchgRateSQLWhere(report, itemFormula));
        strSql.append(this.getHisExchgRateSQLOrder());
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)strSql.toString(), (Object[])params.toArray());
        return rowSet;
    }

    protected String getOrgUnitBoundFilterSql(String treeId, String unitId, List params, CslReportInfo report, ItemFormula itemFormula) throws BOSException {
        StringBuffer strSql = new StringBuffer();
        strSql.append("and ItemHisExchgRate.FOrgBoundID = ? \n\t");
        params.add(treeId);
        strSql.append("and ItemHisExchgRate.FOrgBoundGrpID = ? \n\t");
        params.add(unitId);
        strSql.append(" and ItemHisExchgRate.FBoundType = ?");
        params.add(new Integer(1));
        return strSql.toString();
    }

    protected abstract String getHisExchgRateSQLSelect();

    protected abstract String getHisExchgRateSQLWhere(CslReportInfo var1, ItemFormula var2);

    protected abstract String getHisExchgRateSQLOrder();

    protected abstract BigDecimal caclConvertValueByHistoryAmount(CslReportInfo var1, ItemFormula var2, BigDecimal var3, Map var4, OrgTreeInfo var5) throws BOSException, EASBizException;

    protected abstract BigDecimal caclConvertValueByHistoryYTDAmount(CslReportInfo var1, ItemFormula var2, BigDecimal var3, Map var4, OrgTreeInfo var5) throws BOSException, EASBizException;

    protected abstract BigDecimal caclConvertValueByHistoryEndbalance(CslReportInfo var1, ItemFormula var2, BigDecimal var3, Map var4, OrgTreeInfo var5) throws BOSException, EASBizException;
}

