/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app.convt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICtrlUnit;
import com.kingdee.eas.basedata.org.IOrgTree;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.AdjustCollection;
import com.kingdee.eas.fi.gr.cslrpt.AdjustDetailsEnum;
import com.kingdee.eas.fi.gr.cslrpt.AdjustDynamicItemCollection;
import com.kingdee.eas.fi.gr.cslrpt.AdjustDynamicItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.AdjustDynamicItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.AdjustEntryCollection;
import com.kingdee.eas.fi.gr.cslrpt.AdjustEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.AdjustFactory;
import com.kingdee.eas.fi.gr.cslrpt.AdjustInfo;
import com.kingdee.eas.fi.gr.cslrpt.ConvertModeEnum;
import com.kingdee.eas.fi.gr.cslrpt.IAdjust;
import com.kingdee.eas.fi.gr.cslrpt.IAdjustDynamicItem;
import com.kingdee.eas.fi.gr.cslrpt.ServerException;
import com.kingdee.eas.fi.gr.cslrpt.app.convt.AbstractCslConvt;
import com.kingdee.eas.fi.gr.cslrpt.app.convt.ConvtUtil;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class AdjustConvtImp
extends AbstractCslConvt {
    public AdjustConvtImp() {
        super("ADJUST");
    }

    public AdjustConvtImp(String convtType) {
        super(convtType);
    }

    @Override
    public String excConvert(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        AdjustInfo adjustInfo = (AdjustInfo)info;
        AdjustEntryCollection entry = adjustInfo.getEntries();
        AdjustEntryInfo entryInfo = null;
        ConvertModeEnum convertMode = null;
        BigDecimal curValue = null;
        ICtrlUnit iCtrlUnit = CtrlUnitFactory.getLocalInstance((Context)ctx);
        IOrgTree iOrgTree = OrgTreeFactory.getLocalInstance((Context)ctx);
        IAdjust iAdjust = AdjustFactory.getLocalInstance(ctx);
        int currencyScale = this.paramsManager.getTargetCurrencyInfo().getPrecision();
        if (currencyScale == 0) {
            currencyScale = 2;
        }
        boolean isDebit = true;
        BigDecimal zero = new BigDecimal("0");
        if (entry != null && entry.size() > 0) {
            Object adjustDynamicItems = null;
            for (int i = 0; i < entry.size(); ++i) {
                boolean isExistDefineRate;
                adjustInfo.getEntries().get(i).getAdjustDynamicItem().clear();
                curValue = null;
                entryInfo = entry.get(i);
                entryInfo.setHasAdjustDetails(AdjustDetailsEnum.NO);
                entryInfo.setId(null);
                if (entryInfo.getDebit() != null && entryInfo.getDebit().compareTo(zero) != 0) {
                    curValue = entryInfo.getDebit();
                    isDebit = true;
                } else if (entryInfo.getCredit() != null && entryInfo.getCredit().compareTo(zero) != 0) {
                    curValue = entryInfo.getCredit();
                    isDebit = false;
                }
                int dataElementValue = entryInfo.getDataElement();
                convertMode = this.paramsManager.getConvtModeByItemNum(entryInfo.getItem().getNumber());
                if (this.paramsManager.isDontConvtMode(entryInfo.getItem().getNumber())) continue;
                if (convertMode == null) {
                    throw new ServerException(ServerException.ITEM_NOT_FOUND_CONVERTMODE, new Object[]{entryInfo.getItem().getNumber()});
                }
                if (dataElementValue > 100 && !(isExistDefineRate = ConvtUtil.isExistUserDefinedRate(ctx, curValue, dataElementValue, entryInfo.getItem().getNumber(), info, this.paramsManager)) && (dataElementValue = this.paramsManager.getdataElementByInterSeq(dataElementValue)) == -1) {
                    convertMode = ConvertModeEnum.ENDPERIODEXCHANGERATE;
                    dataElementValue = 4;
                }
                if ((curValue = ConvtUtil.convertValueForAdjustOrElim(ctx, curValue, convertMode, dataElementValue, entryInfo.getItem().getNumber(), info, this.paramsManager)) != null) {
                    curValue = curValue.setScale(currencyScale, 4);
                }
                if (isDebit) {
                    entryInfo.setDebit(curValue);
                    continue;
                }
                entryInfo.setCredit(curValue);
            }
        }
        String id = null;
        int checkedStatus = -1;
        StringBuffer sql = new StringBuffer();
        ArrayList<String> params = new ArrayList<String>();
        sql.append(" select fid, FCheckedStatus from t_csl_Adjust where FConvertBeforeId= ?").append(" and FCurrencyID = ? ");
        params.add(adjustInfo.getId().toString());
        params.add(this.paramsManager.getTargetCurrencyInfo().getId().toString());
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        try {
            if (rs.next()) {
                id = rs.getString("fid");
                checkedStatus = rs.getInt("FCheckedStatus");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (id != null && checkedStatus == 2) {
            ArrayList<ObjectUuidPK> idList = new ArrayList<ObjectUuidPK>();
            idList.add(new ObjectUuidPK(id));
            iAdjust.unAudit(idList);
        }
        if (id != null) {
            iAdjust.delete((IObjectPK)new ObjectUuidPK(id));
        }
        if (!this.paramsManager.hasCodeRule()) {
            adjustInfo.setNumber("convert_" + this.paramsManager.getTargetCurrencyInfo().getNumber() + "_" + adjustInfo.getNumber());
        } else {
            adjustInfo.setNumber(null);
        }
        adjustInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        adjustInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        adjustInfo.setCurrency(this.paramsManager.getTargetCurrencyInfo());
        adjustInfo.setConvertBefore(adjustInfo.getId().toString());
        adjustInfo.setId(null);
        adjustInfo.setSourceAdjust(null);
        OrgTreeInfo orgInfo = adjustInfo.getOrgBound();
        orgInfo = iOrgTree.getOrgTreeInfo((IObjectPK)new ObjectUuidPK(orgInfo.getId().toString()));
        String cuID = orgInfo.getCU().getId().toString();
        CtrlUnitInfo cuInfo = iCtrlUnit.getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(cuID));
        orgInfo.setCU(cuInfo);
        adjustInfo.setOrgBound(orgInfo);
        IObjectPK pk = iAdjust.submit((CoreBaseInfo)adjustInfo);
        AdjustEntryCollection entries = adjustInfo.getEntries();
        for (int j = 0; j < entries.size(); ++j) {
            AdjustEntryInfo entryInfo1 = entries.get(j);
            if (!this.paramsManager.hasDispensedConvtMode(entryInfo1.getItem().getNumber())) {
                throw new ServerException(ServerException.ITEM_NOT_FOUND_CONVERTMODE, new Object[]{entryInfo1.getItem().getNumber()});
            }
            convertMode = this.paramsManager.getConvtModeByItemNum(entryInfo1.getItem().getNumber());
            this.convtDynaLinkAdjust(ctx, convertMode, entryInfo1.getDataElement(), adjustInfo, entryInfo1);
        }
        if (adjustInfo.getCheckedStatus() == CheckedStatusEnum.AUDITED) {
            params.clear();
            params.add(pk.toString());
            DbUtil.execute((Context)ctx, (String)"update t_csl_adjust set FCheckedStatus = 1 where fid= ?", (Object[])params.toArray());
            iAdjust.audit(pk, adjustInfo, ctx.getCaller());
        }
        return pk.toString();
    }

    @Override
    public IObjectCollection getBizCollectionByIdList(Context ctx, List idList) throws BOSException, EASBizException {
        IAdjust iAdj = AdjustFactory.getLocalInstance(ctx);
        AdjustCollection col = null;
        if (idList != null && idList.size() > 0) {
            StringBuffer strFilterMask = new StringBuffer();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            for (int i = 0; i < idList.size(); ++i) {
                filter.getFilterItems().add(new FilterItemInfo("id", idList.get(i)));
                if (strFilterMask.length() > 0) {
                    strFilterMask.append(" or ");
                }
                strFilterMask.append("#" + i);
            }
            filter.setMaskString(strFilterMask.toString());
            view.setFilter(filter);
            view.getSelector().addObjectCollection((IObjectCollection)this.getAdjustSelector());
            col = iAdj.getAdjustCollection(view);
        }
        if (col == null || col.size() <= 0) {
            throw new ServerException(ServerException.NOT_FOUND_CONVERT_ADJUST);
        }
        return col;
    }

    @Override
    public String getExceptionReport(IObjectValue info, Exception e) {
        AdjustInfo adjustInfo = (AdjustInfo)info;
        StringBuffer error = new StringBuffer(100);
        Locale locale = ContextUtils.getOriginalLocaleFromEnv();
        error.append("\n").append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"828_Msg_Cyconvt_Company", (Locale)locale)).append(adjustInfo.getOrgUnit().getName());
        error.append("\n").append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"829_Msg_Cyconvt_EntityName", (Locale)locale)).append(adjustInfo.getNumber());
        error.append("\n").append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"830_Msg_Cyconvt_Currency", (Locale)locale)).append(adjustInfo.getSourceCurrency().getName());
        error.append("\n").append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Msg_Cyconvt_Error", (Locale)locale)).append(e.getLocalizedMessage());
        error.append("\n");
        return error.toString();
    }

    private void convtDynaLinkAdjust(Context ctx, ConvertModeEnum convertMode, int dataElementValue, AdjustInfo adjustInfo, AdjustEntryInfo entryInfo) throws BOSException, EASBizException {
        String oldEntryId = null;
        int seq = entryInfo.getSeq();
        String oldAdjustId = adjustInfo.getConvertBefore();
        IAdjust iAdjust = AdjustFactory.getLocalInstance(ctx);
        AdjustInfo oldAdjustInfo = iAdjust.getAdjustInfo("select * where id='" + oldAdjustId + "'");
        StringBuffer sql = new StringBuffer();
        sql.append(" select fid from t_csl_adjustentry where fAdjustId = ? ");
        sql.append(" and fseq = ? ");
        ArrayList<Object> params = new ArrayList<Object>(2);
        params.add(oldAdjustId);
        params.add(new Integer(seq));
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        try {
            if (rs != null && rs.next()) {
                oldEntryId = rs.getString("fid");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        IAdjustDynamicItem iDynaItem = AdjustDynamicItemFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("adjustEntry.id", (Object)oldEntryId, CompareType.EQUALS));
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("*"));
        view.getSelector().add(new SelectorItemInfo("adjustEntry.*"));
        view.getSelector().add(new SelectorItemInfo("rptItem.*"));
        view.setFilter(filter);
        AdjustDynamicItemCollection col = iDynaItem.getAdjustDynamicItemCollection(view);
        BigDecimal curValue = null;
        int dataElementValueNew = -1;
        ConvertModeEnum convertModeNew = null;
        convertModeNew = convertMode;
        dataElementValueNew = dataElementValue;
        if (dataElementValue > 100 && (dataElementValueNew = this.paramsManager.getdataElementByInterSeq(dataElementValue)) == -1) {
            convertModeNew = ConvertModeEnum.ENDPERIODEXCHANGERATE;
            dataElementValueNew = 4;
        }
        if (col != null && col.size() > 0) {
            for (int i = 0; i < col.size(); ++i) {
                AdjustDynamicItemInfo info = col.get(i);
                curValue = info.getValue();
                if (!this.paramsManager.isDontConvtMode(info.getRptItem().getNumber()) && curValue != null) {
                    curValue = ConvtUtil.convertValueForAdjustOrElim(ctx, curValue, convertModeNew, dataElementValueNew, info.getRptItem().getNumber(), (IObjectValue)oldAdjustInfo, this.paramsManager);
                }
                if (curValue == null) continue;
                info.setValue(curValue);
                info.setAdjustEntry(entryInfo);
                info.setSeq(entryInfo.getSeq());
                info.setId(null);
                iDynaItem.submit((CoreBaseInfo)info);
            }
        }
    }

    private SelectorItemCollection getAdjustSelector() {
        SelectorItemCollection cl = new SelectorItemCollection();
        cl.add(new SelectorItemInfo("*"));
        cl.add(new SelectorItemInfo("entries.*"));
        cl.add(new SelectorItemInfo("entries.item.*"));
        cl.add(new SelectorItemInfo("currency.precision"));
        cl.add(new SelectorItemInfo("currency.name"));
        cl.add(new SelectorItemInfo("currency.number"));
        cl.add(new SelectorItemInfo("sourceCurrency.precision"));
        cl.add(new SelectorItemInfo("sourceCurrency.name"));
        cl.add(new SelectorItemInfo("sourceCurrency.number"));
        cl.add(new SelectorItemInfo("orgBound.number"));
        cl.add(new SelectorItemInfo("orgBound.name"));
        cl.add(new SelectorItemInfo("orgUnit.number"));
        cl.add(new SelectorItemInfo("orgUnit.name"));
        cl.add(new SelectorItemInfo("company.number"));
        cl.add(new SelectorItemInfo("company.name"));
        cl.add(new SelectorItemInfo("entries.adjustDynamicItem.*"));
        return cl;
    }
}

