/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app.convt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.gr.cslrpt.ConvertStatusEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.IItemFieldMapped;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataCondition;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataYearInitFactory;
import com.kingdee.eas.fi.gr.cslrpt.ItemFieldMappedFactory;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.ServerException;
import com.kingdee.eas.fi.gr.cslrpt.app.convt.AbstractHistoryRateConv;
import com.kingdee.eas.fi.gr.cslrpt.app.convt.ConvtParamsManager;
import com.kingdee.eas.fi.gr.cslrpt.app.convt.ConvtUtil;
import com.kingdee.eas.fi.gr.cslrpt.app.convt.ExchangeRateUtil;
import com.kingdee.eas.fi.gr.cslrpt.app.convt.HistoryRateConvDefineRate;
import com.kingdee.eas.fi.gr.cslrpt.app.convt.HistoryRateConvHisRate;
import com.kingdee.eas.fi.gr.cslrpt.util.CslConstant;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class HistoryExchRateConvtUtil {
    public static BigDecimal caclConvertValueByHistoryExchgRate(Context ctx, CslReportInfo report, ItemFormula itemFormula, BigDecimal curValue, Map mapInitYearData, int dataElementValue, OrgTreeInfo orgTreeInfo, ConvtParamsManager paramsManager) throws BOSException, EASBizException {
        boolean needByTargetCompany = "true".equals(itemFormula.getExt("needByTargetCompany"));
        int hisRateConvertType = paramsManager.getHisRateConvertType();
        if (needByTargetCompany) {
            paramsManager.setHisRateConvertType(1);
        }
        AbstractHistoryRateConv historyRateConv = null;
        historyRateConv = paramsManager.getHisRateConvertType() == 4 ? new HistoryRateConvDefineRate(dataElementValue, ctx, paramsManager) : new HistoryRateConvHisRate(dataElementValue, ctx, paramsManager);
        BigDecimal returnValue = historyRateConv.caclConvertValueByHistoryExchgRate(report, itemFormula, curValue, mapInitYearData, orgTreeInfo);
        if (needByTargetCompany) {
            paramsManager.setHisRateConvertType(hisRateConvertType);
        }
        return returnValue;
    }

    protected static BigDecimal getConvertValueByEndRate(Context ctx, CslReportInfo report, ItemFormula itemFormula, Map mapInitYearData, BigDecimal curValue, int dataElementValue, OrgTreeInfo orgTreeInfo, ConvtParamsManager paramsManager) throws BOSException, EASBizException {
        BigDecimal bgCurPeriodUnConvertValue = curValue;
        BigDecimal bgLastPeriodUnConvertValue = null;
        bgLastPeriodUnConvertValue = dataElementValue == 4 || dataElementValue == 3 ? HistoryExchRateConvtUtil.getYearInitItemData(ctx, report, itemFormula, mapInitYearData, ConvertStatusEnum.BeforeConvert, orgTreeInfo, paramsManager) : HistoryExchRateConvtUtil.getItemData(ctx, report, itemFormula, false, -1, orgTreeInfo, paramsManager);
        BigDecimal bgEndRate = ExchangeRateUtil.getEndExchgRateByCurPeriod(ctx, report.getPeriodType(), report.getCurrency(), paramsManager);
        if (bgCurPeriodUnConvertValue == null) {
            bgCurPeriodUnConvertValue = SysConstant.BIGZERO;
        }
        if (bgLastPeriodUnConvertValue == null) {
            bgLastPeriodUnConvertValue = SysConstant.BIGZERO;
        }
        if (paramsManager.checkIsChangeSrc2targCurrencyId(report.getCurrency().getId().toString())) {
            int precision = 2;
            if (paramsManager.getTargetCurrencyInfo() != null && paramsManager.getTargetCurrencyInfo().getPrecision() != 0) {
                precision = paramsManager.getTargetCurrencyInfo().getPrecision();
            }
            return bgCurPeriodUnConvertValue.subtract(bgLastPeriodUnConvertValue).divide(bgEndRate, precision, 4);
        }
        return bgCurPeriodUnConvertValue.subtract(bgLastPeriodUnConvertValue).multiply(bgEndRate);
    }

    protected static BigDecimal getYearInitItemData(Context ctx, CslReportInfo report, ItemFormula itemFormula, Map mapInitYearData, ConvertStatusEnum convertStatus, OrgTreeInfo orgTreeInfo, ConvtParamsManager paramsManager) throws BOSException, EASBizException {
        boolean needByTargetCompany = "true".equals(itemFormula.getExt("needByTargetCompany"));
        BigDecimal bdValue = null;
        if (!needByTargetCompany) {
            bdValue = HistoryExchRateConvtUtil.getOnlyYearInitItemData(ctx, report, itemFormula, convertStatus, orgTreeInfo, paramsManager);
        }
        BigDecimal zero = new BigDecimal(0);
        if (bdValue == null || bdValue.compareTo(zero) == 0) {
            bdValue = HistoryExchRateConvtUtil.getYearInitItemData_from_ItemHisExchgRate(ctx, report, itemFormula, convertStatus, orgTreeInfo, paramsManager);
        }
        return bdValue;
    }

    protected static BigDecimal getOnlyYearInitItemData(Context ctx, CslReportInfo report, ItemFormula itemFormula, ConvertStatusEnum convertStatus, OrgTreeInfo orgTreeInfo, ConvtParamsManager paramsManager) throws BOSException, EASBizException {
        BigDecimal bdValue = null;
        if (report.getSourceType().equals((Object)RptSrcTypeEnum.CONSOLIDATION) || report.getSourceType().equals((Object)RptSrcTypeEnum.SUM)) {
            HashMap<String, Object> mapParams = new HashMap<String, Object>(16);
            mapParams.put("OrgTreeID", orgTreeInfo.getId().toString());
            mapParams.put("OrgUnitID", report.getOrgUnit().getId().toString());
            mapParams.put("KEY_SOURCECURRENCY_ID", report.getCurrency().getId().toString());
            if (convertStatus == ConvertStatusEnum.BeforeConvert) {
                mapParams.put("KEY_CURRENCY_ID", report.getCurrency().getId().toString());
            } else {
                mapParams.put("KEY_CURRENCY_ID", paramsManager.getTargetCurrencyInfo().getId().toString());
            }
            mapParams.put("Year", new Integer(itemFormula.getYear()));
            mapParams.put("DataElement", new Integer(5));
            mapParams.put("ValueType", new Integer(1));
            mapParams.put("KEY_ITEM_NUMBER", itemFormula.getItemNumber());
            mapParams.put("KEY_CONVERTSTATUS", new Integer(convertStatus.getValue()));
            mapParams.put("KEY_DATACOLLECT_NUMBER", report.getDataCollectNumber());
            bdValue = ItemDataYearInitFactory.getLocalInstance(ctx).getYearInitValue(mapParams);
            ConvtUtil.setConvtCalcFormula(String.valueOf(bdValue), bdValue + "=" + ConvtUtil.buildYearInitDetail(mapParams));
        } else {
            HashMap<String, Object> mapParams = new HashMap<String, Object>(16);
            mapParams.put("OrgUnitID", report.getOrgUnit().getId().toString());
            mapParams.put("KEY_SOURCECURRENCY_ID", report.getCurrency().getId().toString());
            if (convertStatus == ConvertStatusEnum.BeforeConvert) {
                mapParams.put("KEY_CURRENCY_ID", report.getCurrency().getId().toString());
            } else {
                mapParams.put("KEY_CURRENCY_ID", paramsManager.getTargetCurrencyInfo().getId().toString());
            }
            mapParams.put("Year", new Integer(itemFormula.getYear()));
            mapParams.put("DataElement", new Integer(5));
            mapParams.put("ValueType", new Integer(1));
            mapParams.put("KEY_ITEM_NUMBER", itemFormula.getItemNumber());
            mapParams.put("KEY_CONVERTSTATUS", new Integer(convertStatus.getValue()));
            mapParams.put("KEY_DATACOLLECT_NUMBER", report.getDataCollectNumber());
            bdValue = ItemDataYearInitFactory.getLocalInstance(ctx).getYearInitValue(mapParams);
            ConvtUtil.setConvtCalcFormula(String.valueOf(bdValue), bdValue + "= " + ConvtUtil.buildYearInitDetail(mapParams), "+");
        }
        return bdValue;
    }

    private static String getHisExchgRateSQLSelectForDay() {
        StringBuffer strSql = new StringBuffer();
        strSql.append("select ItemHisExchgRate.FChangeDate as FChangeDate,");
        strSql.append("ItemHisExchgRate.FChangeAmount as FChangeAmount,ItemHisExchgRate.FID as FID,");
        strSql.append("ItemHisExchgRate.FIsSetPromRate as FIsSetPromRate,ItemHisExchgPromRate.FAmount as FPromAmount,");
        strSql.append("ItemHisExchgPromRate.FCurrencyID as FTargetCurrency\n\t");
        return strSql.toString();
    }

    private static IRowSet getHisExchgRateRowSet(Context ctx, CslReportInfo report, ItemFormula itemFormula, OrgTreeInfo orgTreeInfo, ConvtParamsManager paramsManager) throws BOSException, EASBizException {
        java.util.Date chgDate = FiscalPeriodHelper.getBeginOfYear(paramsManager.getFiscalPeriods(), itemFormula.getYear(), report.getPeriodType(), paramsManager.isMergeByFiscalPeriod());
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer strSql = new StringBuffer();
        strSql.append(HistoryExchRateConvtUtil.getHisExchgRateSQLSelectForDay());
        strSql.append("from T_CSL_ItemHisExchgRate as ItemHisExchgRate\n\t");
        RptSrcTypeEnum rptSrcTypeEnum = report.getSourceType();
        if (rptSrcTypeEnum.equals((Object)RptSrcTypeEnum.CONSOLIDATION) || rptSrcTypeEnum.equals((Object)RptSrcTypeEnum.SUM)) {
            strSql.append("inner join T_ORG_Tree as OrgTree on ItemHisExchgRate.FOrgBoundID = OrgTree.FID\n\t");
            strSql.append("inner join T_ORG_BaseUnit as OrgUnit on ItemHisExchgRate.FOrgBoundGrpID = OrgUnit.FID\n\t");
        } else {
            strSql.append("inner join T_ORG_BaseUnit as OrgUnit on ItemHisExchgRate.FCompanyID = OrgUnit.FID\n\t");
        }
        strSql.append("inner join T_CSL_RptItem as RptItem on ItemHisExchgRate.FItemID = RptItem.FID\n\t");
        strSql.append("left outer join T_CSL_ItemHisExchgPromRate as ItemHisExchgPromRate on ItemHisExchgRate.FID = ItemHisExchgPromRate.FItemHisExchgRateID and ItemHisExchgPromRate.FCurrencyID = ?\n\t");
        params.add(paramsManager.getTargetCurrencyInfo().getId().toString());
        strSql.append("where ItemHisExchgRate.FChangeDate < ");
        strSql.append(CslRptUtil.formatDateForSql(chgDate));
        strSql.append("and ItemHisExchgRate.FCurrencyID = ? \n\t");
        params.add(report.getCurrency().getId().toString());
        strSql.append("and RptItem.FNumber = ? \n\t");
        params.add(itemFormula.getItemNumber());
        if (rptSrcTypeEnum.equals((Object)RptSrcTypeEnum.CONSOLIDATION) || rptSrcTypeEnum.equals((Object)RptSrcTypeEnum.SUM)) {
            strSql.append("and OrgTree.FNumber = ? \n\t");
            params.add(orgTreeInfo.getNumber());
            strSql.append("and OrgUnit.FNumber = ? \n\t");
            params.add(report.getOrgUnit().getNumber());
            strSql.append(" and ItemHisExchgRate.FBoundType = ?");
            params.add(new Integer(1));
        } else {
            strSql.append("and ItemHisExchgRate.FCompanyID = ? \n\t");
            params.add(report.getOrgUnit().getId().toString());
            boolean needByTargetCompany = "true".equals(itemFormula.getExt("needByTargetCompany"));
            if (needByTargetCompany) {
                String targetCompanyId = itemFormula.getExt("16");
                strSql.append(" and ItemHisExchgRate.FPrmtTargetCompany=? ");
                params.add(targetCompanyId);
            } else {
                strSql.append(" and ItemHisExchgRate.FPrmtTargetCompany is null ");
            }
            strSql.append(" and ItemHisExchgRate.FBoundType = ?");
            params.add(new Integer(2));
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)strSql.toString(), (Object[])params.toArray());
        return rowSet;
    }

    private static BigDecimal getYearInitItemData_from_ItemHisExchgRate(Context ctx, CslReportInfo report, ItemFormula itemFormula, ConvertStatusEnum convertStatus, OrgTreeInfo orgTreeInfo, ConvtParamsManager paramsManager) throws BOSException, EASBizException {
        BigDecimal result = null;
        IRowSet rowSet = HistoryExchRateConvtUtil.getHisExchgRateRowSet(ctx, report, itemFormula, orgTreeInfo, paramsManager);
        Date hisChgDate = null;
        BigDecimal hisChgAmount = null;
        BigDecimal hisExgRate = null;
        StringBuffer calcFormulas = new StringBuffer();
        StringBuffer details = new StringBuffer();
        try {
            if (rowSet.size() > 0) {
                result = new BigDecimal(0);
            }
            while (rowSet.next()) {
                String calcFormula = "0";
                hisChgAmount = CslConstant.BGZERO;
                if (convertStatus.equals((Object)ConvertStatusEnum.BeforeConvert)) {
                    hisChgAmount = rowSet.getBigDecimal("FChangeAmount");
                    calcFormula = String.valueOf(hisChgAmount);
                } else {
                    if (rowSet.getBoolean("FIsSetPromRate") && rowSet.getString("FTargetCurrency") != null && !(hisChgAmount = rowSet.getBigDecimal("FPromAmount")).equals(CslConstant.BGZERO)) {
                        calcFormula = String.valueOf(hisChgAmount);
                        hisChgDate = rowSet.getDate("FChangeDate");
                        details.append(calcFormula).append("=").append(ConvtUtil.buildHisRateDetail(calcFormula, hisChgDate));
                    }
                    if (hisChgAmount.equals(CslConstant.BGZERO)) {
                        hisChgDate = rowSet.getDate("FChangeDate");
                        hisChgAmount = rowSet.getBigDecimal("FChangeAmount");
                        calcFormula = String.valueOf(hisChgAmount);
                        hisExgRate = paramsManager.checkIsChangeSrc2targCurrencyId(report.getCurrency().getId().toString()) ? ExchangeRateUtil.getExchangeRate(ctx, paramsManager.getExchangeTableInfo().getId().toString(), paramsManager.getTargetCurrencyInfo().getId().toString(), report.getCurrency().getId().toString(), hisChgDate) : ExchangeRateUtil.getExchangeRate(ctx, paramsManager.getExchangeTableInfo().getId().toString(), report.getCurrency().getId().toString(), paramsManager.getTargetCurrencyInfo().getId().toString(), hisChgDate);
                        if (hisExgRate == null) {
                            ArrayList<String> lstTmp = new ArrayList<String>();
                            lstTmp.add(new SimpleDateFormat("yyyy-MM-dd").format(hisChgDate));
                            lstTmp.add(report.getCurrency().getName());
                            lstTmp.add(paramsManager.getTargetCurrencyInfo().getName());
                            throw new ServerException(ServerException.NOT_FOUND_DAY_EXCHGRATE, lstTmp.toArray());
                        }
                        if (hisChgAmount != null) {
                            if (paramsManager.checkIsChangeSrc2targCurrencyId(report.getCurrency().getId().toString())) {
                                hisChgAmount = hisChgAmount.divide(hisExgRate, 2, 4);
                                calcFormula = hisChgAmount + "/" + hisExgRate;
                            } else {
                                calcFormula = hisChgAmount + "*" + hisExgRate;
                                hisChgAmount = hisChgAmount.multiply(hisExgRate);
                            }
                        }
                    }
                }
                if (calcFormulas.length() > 0) {
                    calcFormulas.append("+");
                }
                calcFormulas.append(calcFormula);
                result = result.add(hisChgAmount);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        ConvtUtil.setConvtCalcFormula(calcFormulas.toString(), details.toString(), "+");
        return result;
    }

    protected static BigDecimal getPeriodInitItemData(Context ctx, CslReportInfo report, ItemFormula itemFormula, OrgTreeInfo orgTreeInfo, ConvtParamsManager paramsManager) throws BOSException, EASBizException {
        BigDecimal bdValue = null;
        ItemDataCondition condition = new ItemDataCondition();
        IItemFieldMapped itemFieldMapped = ItemFieldMappedFactory.getLocalInstance(ctx);
        condition.setTargetCurrency(paramsManager.getTargetCurrencyInfo().getId().toString());
        condition.setCurrency(report.getCurrency().getId().toString());
        condition.setDataElement(4);
        condition.setDataSource(report.getSourceType().getValue());
        if (!paramsManager.isFromReportSystem()) {
            condition.setOrgTreeNumber(orgTreeInfo.getNumber());
        }
        ArrayList<String> lstOrgUnit = new ArrayList<String>();
        lstOrgUnit.add(report.getOrgUnit().getId().toString());
        condition.setOrgUnit(lstOrgUnit);
        int[] yearAndPeriod = FiscalPeriodHelper.getPrevYearAndPeriod(paramsManager.getFiscalPeriods(), itemFormula.getYear(), itemFormula.getPeriod(), report.getPeriodType(), paramsManager.isMergeByFiscalPeriod(), CslRptUtil.isSupport13Period(ctx));
        condition.setRptYearStart(yearAndPeriod[0]);
        condition.setRptYearEnd(yearAndPeriod[0]);
        condition.setRptPeriodStart(yearAndPeriod[1]);
        condition.setRptPeriodEnd(yearAndPeriod[1]);
        condition.setRptPeriodType(report.getPeriodType().getValue());
        condition.setCommitStatus(3);
        ArrayList<String> lstItem = new ArrayList<String>();
        lstItem.add(itemFormula.getItemNumber());
        condition.setItemList(itemFieldMapped.getHiberMapInfoByItemNumbers(lstItem));
        condition.setDataCollectNumber(report.getDataCollectNumber());
        Map mapData = paramsManager.getItemDataProviderInterFace().getAcctItems(condition);
        if (mapData.containsKey(itemFormula.getItemNumber()) && mapData.get(itemFormula.getItemNumber()) != null) {
            bdValue = (BigDecimal)mapData.get(itemFormula.getItemNumber());
            ConvtUtil.setConvtCalcFormula(String.valueOf(bdValue), bdValue + "=" + ConvtUtil.buildAcctItemDetail(condition));
        }
        return bdValue;
    }

    protected static BigDecimal getConvertValueByHisRate(Context ctx, CslReportInfo report, ItemFormula itemFormula, int dataElementValue, OrgTreeInfo orgTreeInfo, ConvtParamsManager paramsManager) throws BOSException, EASBizException {
        StringBuffer strSql = new StringBuffer();
        ArrayList<Object> lstParams = new ArrayList<Object>();
        BigDecimal resultValue = new BigDecimal("0");
        java.util.Date startChgDate = null;
        startChgDate = dataElementValue == 4 || dataElementValue == 3 ? FiscalPeriodHelper.getPeriodFirstDate(paramsManager.getYear(), 1, RptPeriodTypeEnum.YEARLY, paramsManager.getFiscalPeriods(), paramsManager.isMergeByFiscalPeriod()) : (paramsManager.getPeriod() == 13 && RptPeriodTypeEnum.MONTHLY.equals((Object)report.getPeriodType()) ? FiscalPeriodHelper.getPeriodFirstDate(paramsManager.getYear(), 12, report.getPeriodType(), paramsManager.getFiscalPeriods(), paramsManager.isMergeByFiscalPeriod()) : FiscalPeriodHelper.getPeriodFirstDate(paramsManager.getYear(), paramsManager.getPeriod(), report.getPeriodType(), paramsManager.getFiscalPeriods(), paramsManager.isMergeByFiscalPeriod()));
        java.util.Date endChgDate = FiscalPeriodHelper.getPeriodLastDate(paramsManager.getFiscalPeriods(), paramsManager.getYear(), paramsManager.getPeriod(), report.getPeriodType(), paramsManager.isMergeByFiscalPeriod());
        Calendar ca = Calendar.getInstance();
        ca.clear();
        ca.setTime(endChgDate);
        ca.add(5, 1);
        java.util.Date nextDate = ca.getTime();
        strSql.append("Select hisExchg.FChangeDate as FChangeDate,hisExchg.FChangeAmount as FChangeAmount,hisExchg.FID as FID,hisExchg.FIsSetPromRate as FIsSetPromRate,promRate.FAmount  as FPromAmount,promRate.FCurrencyID as FTargetCurrency");
        strSql.append(" From T_CSL_ItemHisExchgRate hisExchg inner join T_CSL_RptItem rptItem");
        strSql.append(" on hisExchg.FItemID = rptItem.FID ");
        strSql.append(" left outer join T_CSL_ItemHisExchgPromRate promRate");
        strSql.append(" on promRate.FItemHisExchgRateID = hisExchg.FID and promRate.FCurrencyID = ?");
        lstParams.add(paramsManager.getTargetCurrencyInfo().getId().toString());
        strSql.append(" where hisExchg.FChangeDate >= ").append(CslRptUtil.formatDateForSql(startChgDate));
        strSql.append(" and hisExchg.FChangeDate < ").append(CslRptUtil.formatDateForSql(nextDate));
        strSql.append(" and hisExchg.FCurrencyID = ?");
        lstParams.add(report.getCurrency().getId().toString());
        strSql.append(" and rptItem.FNumber = ?");
        lstParams.add(itemFormula.getItemNumber());
        if (report.getSourceType().equals((Object)RptSrcTypeEnum.NORMAL) || report.getSourceType().equals((Object)RptSrcTypeEnum.COMMITREPORT)) {
            strSql.append(" and hisExchg.FCompanyID = ?");
            lstParams.add(report.getCompany().getId().toString());
            strSql.append(" and hisExchg.FBoundType = ?");
            lstParams.add(new Integer(2));
        } else {
            FullOrgUnitInfo unit = report.getOrgUnit();
            int[] start = FiscalPeriodHelper.getYearAndPeriod(paramsManager.getFiscalPeriods(), startChgDate, report.getPeriodType(), paramsManager.isMergeByFiscalPeriod());
            int[] end = FiscalPeriodHelper.getYearAndPeriod(paramsManager.getFiscalPeriods(), endChgDate, report.getPeriodType(), paramsManager.isMergeByFiscalPeriod());
            Map mapOrgTree = FiscalPeriodHelper.getOrgTreeByPeriods(ctx, paramsManager.getFiscalPeriods(), orgTreeInfo.getNumber(), start[0], end[0], start[1], end[1], report.getPeriodType().getValue(), paramsManager.isMergeByFiscalPeriod(), paramsManager.isSupport13Period(), null, true);
            Set set = mapOrgTree.keySet();
            StringBuffer subWhere = new StringBuffer();
            Iterator ite = set.iterator();
            while (ite.hasNext()) {
                String strOrgTreeID = ite.next().toString();
                if (subWhere.length() < 1) {
                    subWhere.append(" and (");
                }
                if (subWhere.length() > 8) {
                    subWhere.append(" OR ");
                }
                subWhere.append(" (hisExchg.FOrgBoundID = ? and hisExchg.FOrgBoundGrpID = ?)");
                lstParams.add(strOrgTreeID);
                String strOrgUnitID = "";
                String unitNumber = unit.getNumber();
                String sql = "Select s.FUnitId From t_org_structure s join t_org_baseunit b on s.FUnitId=b.FId where s.FTreeId=? and b.FNumber=?";
                IRowSet rstemp = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{strOrgTreeID, unitNumber});
                try {
                    if (rstemp.next()) {
                        strOrgUnitID = rstemp.getString("FUnitId");
                    }
                }
                catch (SQLException e) {
                    throw new SQLDataException(e);
                }
                lstParams.add(strOrgUnitID);
            }
            if (subWhere.length() > 1) {
                subWhere.append(" ) ");
            }
            strSql.append(subWhere);
            strSql.append(" and hisExchg.FBoundType = ?");
            lstParams.add(new Integer(1));
        }
        boolean needByTargetCompany = "true".equals(itemFormula.getExt("needByTargetCompany"));
        if (needByTargetCompany) {
            String targetCompanyId = itemFormula.getExt("16");
            strSql.append(" and hisExchg.FPrmtTargetCompany=? ");
            lstParams.add(targetCompanyId);
        } else {
            strSql.append(" and hisExchg.FPrmtTargetCompany is null ");
        }
        String dataCollectNumber = report.getDataCollectNumber();
        if (dataCollectNumber != null && dataCollectNumber.length() != 0) {
            strSql.append(" and hisExchg.FDataCollectNumber = ? ");
            lstParams.add(dataCollectNumber);
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strSql.toString(), (Object[])lstParams.toArray());
        Date hisChgDate = null;
        BigDecimal hisChgAmount = null;
        BigDecimal hisExgRate = null;
        boolean isFind = false;
        StringBuffer calcFormulas = new StringBuffer();
        StringBuffer details = new StringBuffer();
        try {
            while (rs.next()) {
                isFind = true;
                hisChgAmount = CslConstant.BGZERO;
                String calcFormula = "0";
                if (rs.getBoolean("FIsSetPromRate") && rs.getString("FTargetCurrency") != null && !(hisChgAmount = rs.getBigDecimal("FPromAmount")).equals(CslConstant.BGZERO)) {
                    calcFormula = String.valueOf(hisChgAmount);
                    hisChgDate = rs.getDate("FChangeDate");
                    details.append(calcFormula).append("=").append(ConvtUtil.buildHisRateDetail(calcFormula, hisChgDate));
                }
                if (hisChgAmount.equals(CslConstant.BGZERO)) {
                    hisChgDate = rs.getDate("FChangeDate");
                    hisChgAmount = rs.getBigDecimal("FChangeAmount");
                    calcFormula = String.valueOf(hisChgAmount);
                    hisExgRate = paramsManager.checkIsChangeSrc2targCurrencyId(report.getCurrency().getId().toString()) ? ExchangeRateUtil.getExchangeRate(ctx, paramsManager.getExchangeTableInfo().getId().toString(), paramsManager.getTargetCurrencyInfo().getId().toString(), report.getCurrency().getId().toString(), hisChgDate) : ExchangeRateUtil.getExchangeRate(ctx, paramsManager.getExchangeTableInfo().getId().toString(), report.getCurrency().getId().toString(), paramsManager.getTargetCurrencyInfo().getId().toString(), hisChgDate);
                    if (hisExgRate == null) {
                        ArrayList<String> lstTmp = new ArrayList<String>();
                        lstTmp.add(new SimpleDateFormat("yyyy-MM-dd").format(hisChgDate));
                        lstTmp.add(report.getCurrency().getName());
                        lstTmp.add(paramsManager.getTargetCurrencyInfo().getName());
                        throw new ServerException(ServerException.NOT_FOUND_DAY_EXCHGRATE, lstTmp.toArray());
                    }
                    if (hisChgAmount != null) {
                        if (paramsManager.checkIsChangeSrc2targCurrencyId(report.getCurrency().getId().toString())) {
                            int precision = 2;
                            if (paramsManager.getTargetCurrencyInfo() != null && paramsManager.getTargetCurrencyInfo().getPrecision() != 0) {
                                precision = paramsManager.getTargetCurrencyInfo().getPrecision();
                            }
                            calcFormula = hisChgAmount + "/" + hisExgRate;
                            hisChgAmount = hisChgAmount.divide(hisExgRate, precision, 4);
                        } else {
                            calcFormula = hisChgAmount + "*" + hisExgRate;
                            hisChgAmount = hisChgAmount.multiply(hisExgRate);
                        }
                    }
                }
                if (calcFormulas.length() > 0) {
                    calcFormulas.append("+");
                }
                calcFormulas.append(calcFormula);
                resultValue = resultValue.add(hisChgAmount);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        ConvtUtil.setConvtCalcFormula(calcFormulas.toString(), details.toString(), "+");
        return resultValue;
    }

    private static BigDecimal getItemData(Context ctx, CslReportInfo report, ItemFormula itemFormula, boolean isConverted, int iPeriodOffset, OrgTreeInfo orgTreeInfo, ConvtParamsManager paramsManager) throws BOSException, EASBizException {
        IItemFieldMapped itemFieldMapped = ItemFieldMappedFactory.getLocalInstance(ctx);
        ItemDataCondition condition = new ItemDataCondition();
        if (isConverted) {
            condition.setTargetCurrency(paramsManager.getTargetCurrencyInfo().getId().toString());
        } else {
            condition.setTargetCurrency(report.getCurrency().getId().toString());
        }
        condition.setCurrency(report.getCurrency().getId().toString());
        condition.setDataElement(DataElementProvider.getDataElementInnerValue(ctx, itemFormula.getDataElementNumber()));
        condition.setDataSource(report.getSourceType().getValue());
        if (!(paramsManager.isFromReportSystem() || report.getSourceType().equals((Object)RptSrcTypeEnum.NORMAL) || report.getSourceType().equals((Object)RptSrcTypeEnum.COMMITREPORT))) {
            condition.setOrgTreeNumber(orgTreeInfo.getNumber());
        }
        ArrayList<String> lstOrgUnit = new ArrayList<String>();
        lstOrgUnit.add(report.getOrgUnit().getId().toString());
        condition.setOrgUnit(lstOrgUnit);
        int iYear = itemFormula.getYear();
        int iPeriod = itemFormula.getPeriod();
        int[] yearAndPeriod = FiscalPeriodHelper.getRptYearAndPeriod(paramsManager.getFiscalPeriods(), iYear, iPeriod, report.getPeriodType().getValue(), 0, iPeriodOffset, paramsManager.isMergeByFiscalPeriod());
        int iNewYear = yearAndPeriod[0];
        int iNewPeriod = yearAndPeriod[1];
        condition.setRptYearStart(iNewYear);
        condition.setRptYearEnd(iNewYear);
        condition.setRptPeriodStart(iNewPeriod);
        condition.setRptPeriodEnd(iNewPeriod);
        condition.setDataCollectNumber(report.getDataCollectNumber());
        condition.setRptPeriodType(report.getPeriodType().getValue());
        ArrayList<String> lstItem = new ArrayList<String>();
        lstItem.add(itemFormula.getItemNumber());
        condition.setItemList(itemFieldMapped.getHiberMapInfoByItemNumbers(lstItem));
        Map mapData = paramsManager.getItemDataProviderInterFace().getAcctItems(condition);
        if (mapData.containsKey(itemFormula.getItemNumber()) && mapData.get(itemFormula.getItemNumber()) != null) {
            return (BigDecimal)mapData.get(itemFormula.getItemNumber());
        }
        return null;
    }

    @Deprecated
    protected static BigDecimal getConvertValueByAvgRate(Context ctx, CslReportInfo report, ItemFormula itemFormula, Map mapInitYearData, BigDecimal curValue, int dataElementValue, OrgTreeInfo orgTreeInfo, ConvtParamsManager paramsManager) throws BOSException, EASBizException {
        BigDecimal bgCurPeriodUnConvertValue = curValue;
        BigDecimal bgLastPeriodUnConvertValue = null;
        bgLastPeriodUnConvertValue = dataElementValue == 4 || dataElementValue == 3 ? HistoryExchRateConvtUtil.getYearInitItemData(ctx, report, itemFormula, mapInitYearData, ConvertStatusEnum.BeforeConvert, orgTreeInfo, paramsManager) : HistoryExchRateConvtUtil.getItemData(ctx, report, itemFormula, false, -1, orgTreeInfo, paramsManager);
        BigDecimal bgAvgRate = ExchangeRateUtil.getAvgExchgRateByCurPeriod(ctx, report.getPeriodType(), report.getCurrency(), paramsManager, null);
        if (bgCurPeriodUnConvertValue == null) {
            bgCurPeriodUnConvertValue = SysConstant.BIGZERO;
        }
        if (bgLastPeriodUnConvertValue == null) {
            bgLastPeriodUnConvertValue = SysConstant.BIGZERO;
        }
        if (paramsManager.checkIsChangeSrc2targCurrencyId(report.getCurrency().getId().toString())) {
            int precision = 2;
            if (paramsManager.getTargetCurrencyInfo() != null && paramsManager.getTargetCurrencyInfo().getPrecision() != 0) {
                precision = paramsManager.getTargetCurrencyInfo().getPrecision();
            }
            return bgCurPeriodUnConvertValue.subtract(bgLastPeriodUnConvertValue).divide(bgAvgRate, precision, 4);
        }
        return bgCurPeriodUnConvertValue.subtract(bgLastPeriodUnConvertValue).multiply(bgAvgRate);
    }
}

