/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app.innertrade;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CheckageConfirmEnum;
import com.kingdee.eas.fi.gr.cslrpt.ElimTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.app.InterCheckControllerBean;
import com.kingdee.eas.fi.gr.cslrpt.app.innertrade.IExecutor;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class AuditOperator
implements IExecutor {
    protected Context _ctx;
    protected ElimTypeEnum _elimType;
    protected CheckageConfirmEnum _oprtState;
    private List<String> _ids;
    public List<String> handledIds = null;

    public AuditOperator(Context ctx, ElimTypeEnum elimType, CheckageConfirmEnum oprtState, List<String> ids) {
        this._ctx = ctx;
        this._elimType = elimType;
        this._oprtState = oprtState;
        this._ids = ids;
    }

    @Override
    public String execute() throws Exception {
        String markTypeStr;
        StringBuffer tips = new StringBuffer();
        if (this._ids == null || this._ids.size() <= 0) {
            return tips.toString();
        }
        SQLBuilder sql = this.buildSQL();
        IRowSet rs = DbUtil.executeQuery((Context)this._ctx, (String)sql.getSQL(), (Object[])sql.getParams());
        String currOprtOrgId = ContextUtil.getCurrentOrgUnit((Context)this._ctx).getId().toString();
        this.handledIds = new ArrayList<String>();
        MessageConstructor notOprtOrgMsgConst = new MessageConstructor(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.ElimUIMsg", (String)"CantAuditRecordInDiffOrg", (Locale)this._ctx.getOriginLocale()));
        MessageConstructor isCheckedMsgConst = new MessageConstructor(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.ElimUIMsg", (String)"CantAuditConfirmRecord", (Locale)this._ctx.getOriginLocale()));
        int checkedStatus = 1;
        String string = markTypeStr = ElimTypeEnum.ComeAndGo.equals((Object)this._elimType) ? "WL-" : "JY-";
        while (rs.next()) {
            String canOprtOrgId = rs.getString("FCheckedParty");
            checkedStatus = rs.getInt("FCheckedStatus");
            String number = markTypeStr + rs.getString("FNumber");
            String id = rs.getString("FID");
            if (!StringUtils.isEmpty((String)canOprtOrgId) && !currOprtOrgId.equals(canOprtOrgId)) {
                notOprtOrgMsgConst.addItem(number);
                continue;
            }
            if (2 == checkedStatus) {
                isCheckedMsgConst.addItem(number);
                continue;
            }
            if (this._oprtState.getValue() == checkedStatus) continue;
            this.handledIds.add(id);
        }
        this.updateState(this.handledIds);
        if (!StringUtils.isEmpty((String)notOprtOrgMsgConst.getMsgBuilded())) {
            tips.append(notOprtOrgMsgConst.getMsgBuilded()).append("\n");
        }
        return tips.append(isCheckedMsgConst.getMsgBuilded()).toString();
    }

    private void updateState(List<String> updateIDs) throws EASBizException, BOSException {
        if (updateIDs.size() <= 0) {
            return;
        }
        SQLBuilder sql = new SQLBuilder();
        InterCheckControllerBean.CommonTable common = new InterCheckControllerBean.CommonTable(this._elimType);
        sql.append(" update ").append(common.getMasterTable());
        sql.append(" set FCheckedStatus = ").append((Object)(CheckageConfirmEnum.Audit.equals((Object)this._oprtState) ? 0 : 1));
        if (CheckageConfirmEnum.Audit.equals((Object)this._oprtState)) {
            Timestamp date = new Timestamp(new Date().getTime());
            sql.append(",FAssessorID = ? ", (Object)ContextUtil.getCurrentUserInfo((Context)this._ctx).getId().toString());
            sql.append(",FAssessDate = ? ", (Object)date);
        } else {
            sql.append(",FAssessorID = null,FAssessDate = null ");
        }
        sql.append(" where FID in", updateIDs);
        DbUtil.execute((Context)this._ctx, (String)sql.getSQL(), (Object[])sql.getParams());
    }

    private SQLBuilder buildSQL() throws EASBizException {
        SQLBuilder sql = new SQLBuilder();
        InterCheckControllerBean.CommonTable common = new InterCheckControllerBean.CommonTable(this._elimType);
        sql.append(" select FID,FNumber,FcheckedParty,FCheckedStatus from ");
        sql.append(common.getMasterTable());
        sql.append(" where FID in", this._ids);
        return sql;
    }

    public static class MessageConstructor {
        StringBuffer msg = new StringBuffer();
        String title;

        public MessageConstructor(String title) {
            this.title = title;
        }

        public String getMsgBuilded() {
            if (this.msg.length() <= 0) {
                return "";
            }
            return this.title + "\n\r" + this.msg.toString();
        }

        public void addItem(String number) {
            if (this.msg.length() > 0) {
                this.msg.append(",");
            }
            this.msg.append(number);
        }
    }
}

