/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app.multicalculate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.MergeModeEnum;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.util.RptUtilForServer;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CompanysExpander {
    private boolean isOnlyCompany = false;
    private List<String> companys;
    private CslReportInfo reportInfo;
    private Context ctx;
    private boolean isElimRpt = false;
    private List<ExcecuteTask> excLst = new ArrayList<ExcecuteTask>();

    public CompanysExpander(Context ctx, boolean isOnlyCompany, List<String> companys, CslReportInfo reportInfo, boolean isElimRpt) {
        this.isOnlyCompany = isOnlyCompany;
        this.companys = companys;
        this.reportInfo = reportInfo;
        this.ctx = ctx;
        this.isElimRpt = isElimRpt;
    }

    public List<ExcecuteTask> expandCompanys() throws BOSException, EASBizException {
        MergeModeEnum mergeMode = CslRptUtil.getMergeMode(this.ctx, this.reportInfo.getOrgTree().getId().toString());
        if (this.isElimRpt) {
            ExcecuteTask task = new ExcecuteTask();
            task.isAutoExpandUnit = false;
            if (MergeModeEnum.DIRECT.equals((Object)mergeMode)) {
                task.companyIDs = this.getExpandCompanys(Arrays.asList(this.reportInfo.getOrgUnit().getId().toString()), true);
                task.unitIDs = Arrays.asList("NULL");
            } else {
                task.companyIDs = this.getExpandCompanys(Arrays.asList(this.reportInfo.getOrgUnit().getId().toString()), true);
                task.unitIDs = this.getExpandCompanys(Arrays.asList(this.reportInfo.getOrgUnit().getId().toString()), false);
                task.companyIDs.remove(this.reportInfo.getOrgUnit().getId().toString());
            }
            this.excLst.add(task);
            return this.excLst;
        }
        if (this.isOnlyCompany || MergeModeEnum.DIRECT.equals((Object)mergeMode)) {
            this.addCurrentRptUnitTask(mergeMode);
        } else {
            ExcecuteTask task = new ExcecuteTask();
            task.isAutoExpandUnit = false;
            task.companyIDs = this.getDirectLevelUnitIDs(this.reportInfo.getOrgUnit().getId().toString(), false);
            if (RptSrcTypeEnum.MULTIDYNAMICCSLREPORT.equals((Object)this.reportInfo.getSourceType())) {
                task.unitIDs = Arrays.asList(this.reportInfo.getOrgUnit().getId().toString());
            }
            this.excLst.add(task);
            List<String> unitIds = this.getDirectLevelUnitIDs(this.reportInfo.getOrgUnit().getId().toString(), true);
            for (String unitId : unitIds) {
                task = new ExcecuteTask();
                task.isAutoExpandUnit = true;
                task.companyIDs = this.getExpandCompanys(Arrays.asList(unitId), true);
                task.unitIDs = this.getExpandCompanys(Arrays.asList(unitId), false);
                task.unitIDs.add(this.reportInfo.getOrgUnit().getId().toString());
                task.expandUnitId = unitId;
                this.excLst.add(task);
            }
        }
        return this.excLst;
    }

    private void addCurrentRptUnitTask(MergeModeEnum mergeMode) throws BOSException {
        ExcecuteTask task = new ExcecuteTask();
        task.isAutoExpandUnit = false;
        task.companyIDs = this.getExpandCompanys(this.companys, true);
        if (MergeModeEnum.DIRECT.equals((Object)mergeMode)) {
            task.unitIDs = Arrays.asList(this.reportInfo.getOrgUnit().getId().toString());
        } else {
            task.unitIDs = this.getExpandCompanys(this.companys, false);
            task.unitIDs.add(this.reportInfo.getOrgUnit().getId().toString());
        }
        task.expandUnitId = null;
        this.excLst.add(task);
    }

    private List<String> getExpandCompanys(List<String> companyIDs, boolean isOnlyCompany) throws BOSException {
        if (companyIDs == null || companyIDs.size() == 0) {
            return companyIDs;
        }
        StringBuffer sql = new StringBuffer();
        ArrayList<String> params = new ArrayList<String>();
        sql.append(" select subOrg.FUnitID OrgID  from T_ORG_Structure subOrg ");
        sql.append(" inner join T_ORG_Structure superOrg on subOrg.FLongNumber = superOrg.FLongNumber ");
        sql.append(" or charindex(concat(superOrg.flongnumber,'!'),subOrg.flongnumber) = 1 ");
        sql.append(" inner join T_ORG_BaseUnit unit on subOrg.FUnitID = unit.FID ");
        sql.append(" where  ");
        sql.append(" subOrg.FTreeID = ? ");
        if (isOnlyCompany || this.reportInfo.getSourceType().equals((Object)RptSrcTypeEnum.MULTIDYNAMICSUMREPORT)) {
            sql.append(" and unit.FIsGrouping = 0 ");
        } else {
            sql.append(" and unit.FIsGrouping = 1 ");
        }
        sql.append(" and superOrg.FTreeID = ? ");
        sql.append(" and superOrg.FUnitID in ");
        params.add(this.reportInfo.getOrgTree().getId().toString());
        params.add(this.reportInfo.getOrgTree().getId().toString());
        sql.append(RptUtilForServer.createInEnumSql(companyIDs.iterator(), params, (Context)this.ctx));
        IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])params.toArray());
        ArrayList<String> result = new ArrayList<String>();
        try {
            while (rowSet.next()) {
                result.add(rowSet.getString("OrgID"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return result;
    }

    private List<String> getDirectLevelUnitIDs(String parentUnitId, boolean isOnlyUnit) throws BOSException {
        ArrayList<String> result = new ArrayList<String>();
        SQLBuilder sql = new SQLBuilder(100);
        sql.append(" select sub.funitid OrgID from t_org_Structure sub       \n").append(" join t_org_baseunit unit on sub.funitid = unit.fid \n").append(" join t_org_Structure s on sub.fparentId = s.fid    \n").append(" where s.FtreeId = ? ", (Object)this.reportInfo.getOrgTree().getId().toString()).append(" and s.FUnitId =? ", (Object)parentUnitId).append(" and unit.FIsGrouping = ? ", (Object)(isOnlyUnit ? 1 : 0));
        IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])sql.getParams());
        try {
            while (rowSet.next()) {
                result.add(rowSet.getString("OrgID"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return result;
    }

    public static class ExcecuteTask {
        public boolean isAutoExpandUnit;
        public String expandUnitId;
        public List<String> companyIDs;
        public List<String> unitIDs;
    }
}

