/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app.reportcalc;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.IItemDataProvider;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataProviderFactory;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.app.reportcalc.MnsRptCalcParam;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.mns.MnsColumnCollection;
import com.kingdee.eas.fi.gr.cslrpt.util.CslConstant;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import java.awt.Point;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractMnsRptCalcColumn {
    protected static final String SIGN = "#isFeignCalc";
    protected MnsRptCalcParam mnsRptCalcParam;
    protected HashMap itemNumbers;
    protected Map itemRows;
    protected Map sheetData;
    protected Map items;
    protected Context ctx;
    protected ItemFormula curFormula = null;
    protected IItemDataProvider itemDataProvider;

    public AbstractMnsRptCalcColumn(MnsRptCalcParam mnsRptCalcParam) {
        this.mnsRptCalcParam = mnsRptCalcParam;
        this.ctx = mnsRptCalcParam.ctx;
    }

    protected IItemDataProvider getItemDataProvider() throws BOSException {
        if (this.itemDataProvider == null) {
            this.itemDataProvider = ItemDataProviderFactory.getLocalInstance(this.mnsRptCalcParam.ctx);
        }
        return this.itemDataProvider;
    }

    protected void putMnsData(BigDecimal result, int col, Integer rowIndex) {
        if (col == -1 || this.sheetData == null || rowIndex == null) {
            return;
        }
        if (result != null && result.compareTo(CslConstant.BGZERO) != 0) {
            Point position = new Point(col, rowIndex);
            this.sheetData.put(position, result);
        }
    }

    protected int getDataElementInnerValue(String number) throws BOSException, EASBizException {
        return DataElementProvider.getDataElementInnerValue(this.ctx, number);
    }

    protected abstract void setMnsColumnCollection(MnsColumnCollection var1);

    protected abstract void calcData() throws BOSException, EASBizException, CloneNotSupportedException;

    protected void initParams(HashMap itemNumbers, Map itemRows, Map sheetData, Map items) {
        this.itemNumbers = itemNumbers;
        this.itemRows = itemRows;
        this.sheetData = sheetData;
        this.items = items;
    }

    protected void setCurFormula(ItemFormula curFormula) {
        this.curFormula = curFormula;
    }
}

