/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app.reportcalc;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataCondition;
import com.kingdee.eas.fi.gr.cslrpt.app.CSLServerHelper;
import com.kingdee.eas.fi.gr.cslrpt.app.reportcalc.MnsRptCalcHelper;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.MnsRptParamInfo;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class MnsRptCalcParam {
    protected Context ctx;
    protected MnsRptParamInfo mnsRptParamInfo;
    protected CslReportInfo report;
    protected ItemDataCondition condition;
    protected boolean isSupport13Period = false;
    protected boolean isMergeByFiscalPeriod = false;
    protected PeriodCollection periods = null;
    protected boolean isSupportCrossMerger = false;
    protected boolean isAutoCalcSubCombineData = false;
    private boolean isSupportGroupReport = true;
    protected HashMap orgUnits_IdNumber = null;
    protected ArrayList companys = null;
    protected ArrayList excludeCompanys = null;
    private String elimIDTable = null;
    public List prePeriodCompanyNumbers = null;
    public int calcThreadCount = 2;
    public Map<String, FullOrgUnitInfo> disposalCompnays = new HashMap<String, FullOrgUnitInfo>();

    public MnsRptCalcParam(Context ctx, MnsRptParamInfo mnsRptParamInfo) throws EASBizException, BOSException {
        this.ctx = ctx;
        this.mnsRptParamInfo = mnsRptParamInfo;
        if (!this.isSupportCrossMerger && mnsRptParamInfo.isSupportCrossMerger()) {
            this.isSupportCrossMerger = true;
        }
        this.calcThreadCount = CSLParamUtil.getIntCslParamValue(ctx, "mnsCalcThreadCount");
        if (this.calcThreadCount <= 0) {
            this.calcThreadCount = 2;
        }
        this.init();
    }

    public List getPrePeriodCompanyNumbers(int year, int period, RptPeriodTypeEnum periodTypeEnum) throws EASBizException, BOSException {
        if (this.prePeriodCompanyNumbers == null) {
            this.prePeriodCompanyNumbers = new ArrayList();
            try {
                Timestamp lastDate = new Timestamp(FiscalPeriodHelper.getPeriodLastDate(this.periods, year, period, periodTypeEnum, this.isMergeByFiscalPeriod).getTime());
                SQLBuilder sql = new SQLBuilder();
                sql.append("select distinct tree.fid ftreeId,struct.fid from t_org_structure struct ");
                sql.append(" inner join t_org_baseunit unit on unit.fid=struct.funitid ");
                sql.append(" inner join t_org_tree tree on tree.fid=struct.ftreeid ");
                sql.append(" where tree.fnumber=? ", (Object)this.report.getOrgTree().getNumber()).append(" and unit.fnumber=? ", (Object)this.report.getOrgUnit().getNumber());
                sql.append(" and tree.fstartdate<=? ", (Object)lastDate).append(" and (tree.fenddate>=?  or tree.fenddate is null ) ", (Object)lastDate);
                IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.getSQL(), (Object[])sql.getParams());
                String structId = null;
                String treeId = null;
                if (rowSet != null && rowSet.next()) {
                    treeId = rowSet.getString("ftreeId");
                    if (this.report.getOrgTree().getId().toString().equals(treeId)) {
                        if (this.orgUnits_IdNumber != null && !this.orgUnits_IdNumber.isEmpty()) {
                            this.prePeriodCompanyNumbers = new ArrayList(this.orgUnits_IdNumber.keySet());
                        }
                        return this.prePeriodCompanyNumbers;
                    }
                    structId = rowSet.getString("fid");
                    if (!StringUtils.isEmpty((String)structId)) {
                        sql.reset();
                        sql.append("select distinct unit.fnumber from t_org_structure struct ");
                        sql.append(" inner join t_org_baseunit unit on unit.fid=struct.funitid ");
                        sql.append(" where struct.ftreeid=? ", (Object)treeId);
                        sql.append(" and struct.fparentid=? ", (Object)structId);
                        rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.getSQL(), (Object[])sql.getParams());
                        while (rowSet != null && rowSet.next()) {
                            this.prePeriodCompanyNumbers.add(rowSet.getString("fnumber"));
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        return this.prePeriodCompanyNumbers;
    }

    public String getElimIDTable() {
        return this.elimIDTable;
    }

    public void setElimIDTable(String elimIDTable) {
        this.elimIDTable = elimIDTable;
    }

    private void init() throws EASBizException, BOSException {
        if (this.mnsRptParamInfo == null || StringUtils.isEmpty((String)this.mnsRptParamInfo.getReportID())) {
            throw new BOSException("current report is null!");
        }
        this.report = CslReportFactory.getLocalInstance(this.ctx).getCslReportInfo((IObjectPK)new ObjectUuidPK(this.mnsRptParamInfo.getReportID()), this.getSelectors(false));
        if (this.report == null) {
            throw new BOSException("current report is null!");
        }
        this.condition = new ItemDataCondition();
        this.condition = CSLParamUtil.getSysParams(this.ctx, this.condition);
        this.isSupport13Period = this.condition.isSupport13Period();
        this.isMergeByFiscalPeriod = this.condition.isMergeByFiscalPeriod();
        if (this.isMergeByFiscalPeriod) {
            this.periods = FiscalPeriodHelper.getPeriodCollection(this.ctx, this.report);
        }
        if (!this.isSupportCrossMerger) {
            boolean[] values = CSLParamUtil.batchGetParam4OrgTree(this.ctx, new String[]{"GR_CSL_SupportCrossMerger", "GR_CSL_AutoCalcSubCombineData"}, this.report.getOrgTree().getId().toString());
            this.isSupportCrossMerger = values[0];
            this.isAutoCalcSubCombineData = values[1];
        }
        this.isAutoCalcSubCombineData = false;
        if (!this.isSupportCrossMerger) {
            this.condition.setOrgTreeNumber(this.report.getOrgTree().getNumber());
            this.condition.setOrgTreeId2(this.report.getOrgTree().getId().toString());
            this.companys = CSLServerHelper.getCslOrgs(this.ctx, this.report.getOrgTree(), (OrgUnitInfo)this.report.getOrgUnit());
            this.orgUnits_IdNumber = new HashMap();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(this.companys), CompareType.INCLUDE));
            view.setFilter(filter);
            view.getSelector().add("number");
            view.getSelector().add("id");
            if (this.isAutoCalcSubCombineData) {
                view.getSelector().add("isUnion");
                view.getSelector().add("isGrouping");
                this.mnsRptParamInfo.clearCompanyMap();
                this.mnsRptParamInfo.clearUnionMap();
            }
            FullOrgUnitCollection orgUnits = FullOrgUnitFactory.getLocalInstance((Context)this.ctx).getFullOrgUnitCollection(view);
            OrgTreeInfo treeInfo = this.report.getOrgTree();
            String orgUnitId = null;
            for (int i = 0; i < orgUnits.size(); ++i) {
                orgUnitId = orgUnits.get(i).getId().toString();
                this.orgUnits_IdNumber.put(orgUnits.get(i).getNumber(), orgUnitId);
                if (!this.isAutoCalcSubCombineData) continue;
                if (orgUnits.get(i).isIsUnion() || orgUnits.get(i).isIsGrouping()) {
                    this.mnsRptParamInfo.addUnion(treeInfo, orgUnitId);
                }
                this.mnsRptParamInfo.addCompany(treeInfo, orgUnitId);
            }
        }
        this.condition.setIsAdjusted(!this.mnsRptParamInfo.isBeforeAdjust());
        this.condition.setIncludeSendBackedReport(this.mnsRptParamInfo.isIncludeSendBacked());
        this.condition.setIncludeUnAuditElim(this.mnsRptParamInfo.isIncludeUnAuditElim());
        this.condition.setElimTypeFilter(this.mnsRptParamInfo.getElimTypeFilter());
        this.condition.setFastMergeSoluId(this.mnsRptParamInfo.getFastMergeSoluId());
        this.condition.setAdjustTypeFilter(this.mnsRptParamInfo.getAdjustTypeFilter());
        this.condition.setSupportGroupReport(this.mnsRptParamInfo.isSupportGroupReport());
        this.setSupportGroupReport(this.mnsRptParamInfo.isSupportGroupReport());
        this.initItemDataCondition();
        this.mnsRptParamInfo.backCompanyMap();
    }

    private SelectorItemCollection getSelectors(boolean WidthData) {
        return MnsRptCalcHelper.getSelectors(WidthData);
    }

    private void initItemDataCondition() {
        this.condition.setTargetCurrency(this.report.getCurrency().getId().toString());
        RptPeriodTypeEnum rptPeriodType = this.report.getPeriodType();
        this.condition.setRptPeriodType(rptPeriodType.getValue());
        this.condition.setCommitStatus(3);
        int[] dataSrc = new int[]{1, 7, 3};
        this.condition.setDataSourceString(dataSrc);
        this.condition.setDataCollectNumber(this.report.getDataCollectNumber());
    }

    public boolean isSupportGroupReport() {
        return this.isSupportGroupReport;
    }

    public void setSupportGroupReport(boolean isSupportGroupReport) {
        this.isSupportGroupReport = isSupportGroupReport;
    }

    public ArrayList getExcludeCompanys() {
        return this.excludeCompanys;
    }

    public void setExcludeCompanys(ArrayList excludeCompanys) {
        this.excludeCompanys = excludeCompanys;
    }

    public CslReportInfo getReport() {
        return this.report;
    }

    public void setReport(CslReportInfo report) {
        this.report = report;
    }

    public MnsRptParamInfo getMnsRptCalcParam() {
        return this.mnsRptParamInfo;
    }

    public boolean isSupportCrossMerger() {
        return this.isSupportCrossMerger;
    }
}

