/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.app.reportcalc.dynarpt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataCondition;
import com.kingdee.eas.fi.gr.cslrpt.app.reportcalc.DynaParamInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.reportcalc.DynaRptCalcServerHelper;
import com.kingdee.eas.fi.gr.cslrpt.app.reportcalc.ElimDataUtil;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.DynaCslRptParamInfo;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DynaCslRptCellLink {
    private Context ctx;
    private Map mapParams;
    private int valueType;
    private int isQueryBudget;
    private DynaParamInfo paramInfo;
    private String orgTreeId = null;
    private String orgUnitId = null;
    private String ext = null;

    public DynaCslRptCellLink(Context ctx, Map mapParams) {
        this.ctx = ctx;
        this.mapParams = mapParams;
        this.valueType = (Integer)mapParams.get("ValueType");
        this.isQueryBudget = (Integer)mapParams.get("ISQUERYBUDGET");
        this.orgTreeId = (String)mapParams.get("OrgTreeID");
        this.orgUnitId = (String)mapParams.get("OrgUnitID");
        this.paramInfo = new DynaParamInfo();
        this.paramInfo.doOffset = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRowSet executeQuery() throws EASBizException, BOSException {
        String unitMap2SerialString = (String)this.mapParams.get("unitMap2SerialString");
        this.ext = this.ctx.getLocale().getLanguage();
        if (unitMap2SerialString == null) {
            OrgTreeInfo orgTree = new OrgTreeInfo();
            orgTree.put("id", (Object)this.orgTreeId);
            FullOrgUnitInfo orgUnit = new FullOrgUnitInfo();
            orgUnit.put("id", (Object)this.orgUnitId);
            ArrayList lstOrg = CslRptUtil.getCslOrgs(this.ctx, orgTree, (OrgUnitInfo)orgUnit);
            if (lstOrg == null || lstOrg.size() <= 0) {
                return null;
            }
            this.paramInfo.dynaCslRptParamInfo = null;
            this.paramInfo.companyIDs = CslRptUtil.changeIdList2String(lstOrg);
            this.paramInfo.isSupportCrossMerger = false;
        } else {
            DynaCslRptParamInfo dynaCslRptParamInfo = new DynaCslRptParamInfo();
            dynaCslRptParamInfo.parseStr2UnitMap(unitMap2SerialString);
            this.paramInfo.dynaCslRptParamInfo = dynaCslRptParamInfo;
            this.paramInfo.isSupportCrossMerger = true;
            this.paramInfo.companyIDs = null;
        }
        try {
            IRowSet rs;
            if (this.paramInfo.doOffset && this.paramInfo.isSupportCrossMerger && this.valueType != 3) {
                ItemDataCondition condition = new ItemDataCondition();
                condition.setValueType((Integer)this.mapParams.get("ValueType"));
                condition.setTargetCurrency((String)this.mapParams.get("KEY_CURRENCY_ID"));
                condition.setRptPeriodType((Integer)this.mapParams.get("PeriodType"));
                condition.setRptYearStart((Integer)this.mapParams.get("Year"));
                condition.setRptPeriodStart((Integer)this.mapParams.get("Period"));
                condition.setDataCollectNumber((String)this.mapParams.get("KEY_DATACOLLECT_NUMBER"));
                this.paramInfo.dynaCslRptParamInfo.backCompanyMap();
                this.paramInfo.tempElimIDTable = ElimDataUtil.getTempElimIDTable(this.ctx, condition, this.paramInfo.dynaCslRptParamInfo, this.orgTreeId, this.orgUnitId);
                this.paramInfo.dynaCslRptParamInfo.reSetCompanyMap();
            }
            ArrayList params = new ArrayList(40);
            String sql = this.getQuerySql(params);
            IRowSet iRowSet = rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])params.toArray());
            return iRowSet;
        }
        finally {
            if (!StringUtils.isEmpty((String)this.paramInfo.tempElimIDTable)) {
                TempTablePool.getInstance((Context)this.ctx).releaseTable(this.paramInfo.tempElimIDTable);
            }
        }
    }

    private String getQuerySql(List params) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer(700);
        if (this.valueType != 3) {
            sql.append("select FKeyNumber,sum(FValue), FDataType FROM (");
        }
        sql.append(this.fetchDyReportQuerySql(params));
        if (this.valueType != 3) {
            sql.append(" UNION ALL \n");
            sql.append(this.fetchAdjustQuerySql(params));
            if (this.paramInfo.doOffset) {
                sql.append(" UNION ALL \n");
                sql.append(this.fetchEliminationQuerySql(params));
            }
            sql.append(" ) as t group by FKeyNumber, FDataType ");
            sql.append(" Order by FKeyNumber, FDataType desc");
        }
        return sql.toString();
    }

    private String fetchDyReportQuerySql(List params) throws BOSException, EASBizException {
        String[] dyItemTables = CslRptUtil.getDyItemTables(this.ctx, (Integer)this.mapParams.get("Year"), (Integer)this.mapParams.get("Period"), (Integer)this.mapParams.get("Year"), (Integer)this.mapParams.get("Period"));
        StringBuffer dyReportSql = new StringBuffer(200);
        String FValue = null;
        FValue = this.valueType == 3 ? "FTextValue" : "FValue";
        dyReportSql.append(" SELECT u.FName_").append(this.ext).append(" AS FKeyNumber, de.").append(FValue).append(" AS FValue, case when d.FDataType =1 then 0 else d.FDataType end as FDataType \n").append(" FROM").append(dyItemTables[1]).append(" de \n").append(" INNER JOIN ").append(dyItemTables[0]).append(" d \n").append("    ON de.FItemDataID = d.FID and d.FDataSource in(12,10)\n").append(" INNER JOIN T_ORG_BASEUNIT u on u.FID = d.FOrgUnitID \n");
        if (this.isQueryBudget == 1) {
            dyReportSql.append(" inner join t_csl_HisRptreceived rc on rc.freportid = d.freportid \n");
        } else {
            dyReportSql.append(" inner join t_csl_rptreceived rc on rc.freportid = d.freportid \n");
        }
        if (this.paramInfo.isSupportCrossMerger) {
            dyReportSql.append(" WHERE ");
            dyReportSql.append(this.getCompanyMapSql("rc.FOrgTreeID", "d.FOrgUnitID"));
        } else {
            dyReportSql.append(" WHERE d.FOrgUnitID IN (").append(this.paramInfo.companyIDs).append(")\n");
            dyReportSql.append(" AND  rc.FOrgTreeID = ? ");
            params.add(this.orgTreeId);
        }
        dyReportSql.append(" AND d.FCurrencyID = ? ").append(" AND de.FItemID = ? ").append(" AND de.FDataElement = ? ").append(" AND de.FValueType = ? ").append(" AND de.FYear = ? ").append(" AND de.FPeriod = ?\t").append(" AND de.FKeyNumber = ?").append(" AND d.FCommitStatus = ?").append(" AND d.FDataCollectNumber = ?").append("    AND d.FDynaType = 1 ").append(" AND d.FDataType =").append(0);
        params.add(this.mapParams.get("KEY_CURRENCY_ID"));
        params.add(this.mapParams.get("KEY_ITEM_NUMBER"));
        params.add(this.mapParams.get("DataElement"));
        params.add(this.mapParams.get("ValueType"));
        params.add(this.mapParams.get("Year"));
        params.add(this.mapParams.get("Period"));
        params.add(this.mapParams.get("KEY_DYNAITEM_NUMBER"));
        params.add(new Integer(3));
        params.add(this.mapParams.get("KEY_DATACOLLECT_NUMBER"));
        return dyReportSql.toString();
    }

    private String fetchAdjustQuerySql(List params) throws BOSException, EASBizException {
        StringBuffer adjustSql = new StringBuffer(200);
        adjustSql.append(" select t5.FName_").append(this.ext).append(" as FKeyNumber \n");
        adjustSql.append(" ,sum(t3.fvalue) as FValue,0 as FDynaType \n");
        if (this.isQueryBudget == 1) {
            adjustSql.append(" From T_CSL_HisAdjust t1 ");
            adjustSql.append(" inner join T_CSL_HisAdjustEntry t2 ");
            adjustSql.append(" on t1.FID=t2.fadjustid ");
            adjustSql.append(" inner join t_Csl_HisAdjustdynamicitem t3 ");
        } else {
            adjustSql.append(" From T_CSL_Adjust t1 ");
            adjustSql.append(" inner join T_CSL_AdjustEntry t2 ");
            adjustSql.append(" on t1.FID=t2.fadjustid ");
            adjustSql.append(" inner join t_Csl_Adjustdynamicitem t3 ");
        }
        adjustSql.append(" on t2.FID=t3.FAdjustEntryID ");
        adjustSql.append(" inner join T_CSL_RptItem rptItem ");
        adjustSql.append(" on t3.FRptItemID=rptItem.FID ");
        adjustSql.append(" inner join T_ORG_Tree t4 ON t1.Forgboundid = t4.FID ");
        adjustSql.append(" INNER JOIN T_ORG_BaseUnit t5 ON t1.FOrgUnit = t5.FID");
        if (this.paramInfo.isSupportCrossMerger) {
            adjustSql.append(" WHERE ");
            adjustSql.append(this.getCompanyMapSql("t1.FOrgBoundID", "t1.FOrgUnit"));
        } else {
            adjustSql.append(" WHERE t1.FOrgUnit IN (").append(this.paramInfo.companyIDs).append(")");
            adjustSql.append("    and t1.FOrgBoundID = ? ");
            params.add(this.orgTreeId);
        }
        adjustSql.append(" and t1.FCurrencyID = ? ");
        adjustSql.append(" and rptItem.FNumber = ? ");
        adjustSql.append(" and t2.FDataElement = ? ");
        adjustSql.append(" and t1.FDataSource in (1,3) ");
        adjustSql.append(" and t1.FValueType = ? ");
        adjustSql.append(" and t1.FYear = ? ");
        adjustSql.append(" and t1.FPeriod = ? ");
        adjustSql.append(" and t1.FCheckedStatus = ?\n");
        adjustSql.append(" and t3.FKeyLongNumber = ?\n");
        adjustSql.append(" and t1.FDataCollectNumber = ? \n");
        adjustSql.append(" group by t5.FName_").append(this.ext).append(",FKeyName \n");
        params.add(this.mapParams.get("KEY_CURRENCY_ID"));
        params.add(this.mapParams.get("KEY_ITEM_NUMBER"));
        params.add(this.mapParams.get("DataElement"));
        params.add(this.mapParams.get("ValueType"));
        params.add(this.mapParams.get("Year"));
        params.add(this.mapParams.get("Period"));
        params.add(new Integer(2));
        params.add(this.mapParams.get("KEY_DYNAITEM_NUMBER"));
        params.add(this.mapParams.get("KEY_DATACOLLECT_NUMBER"));
        return adjustSql.toString();
    }

    private String fetchEliminationQuerySql(List params) throws BOSException, EASBizException {
        StringBuffer elimSql = new StringBuffer(200);
        elimSql.append(" SELECT N'").append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"CslRptItemDataNameElim", (Locale)this.ctx.getOriginLocale())).append("' AS FKeyNumber \n").append(" , de.FValue AS FValue , 100 as FDataType\n");
        if (this.isQueryBudget == 1) {
            elimSql.append(" FROM t_csl_HisElimDynaItemEntry de  \n").append(" INNER JOIN t_csl_HisElimINatiONEntry ee ON de.FelimINatiONEntryID=ee.FID  \n").append(" INNER JOIN t_csl_HisElimINatiON e ON ee.FElimINatiONID = e.FID \n");
        } else {
            elimSql.append(" FROM t_csl_elimDynaItemEntry de    \n").append(" INNER JOIN t_csl_elimINatiONEntry ee ON de.FelimINatiONEntryID=ee.FID  \n").append(" INNER JOIN t_csl_elimINatiON e ON ee.FElimINatiONID = e.FID \n");
        }
        elimSql.append(" INNER JOIN T_CSL_RptItem ri ON ri.FId = de.FRptItemID \n");
        if (this.paramInfo.isSupportCrossMerger && this.paramInfo.tempElimIDTable != null) {
            elimSql.append(" INNER JOIN ").append(this.paramInfo.tempElimIDTable).append(" tmp ON tmp.FID = e.FID ");
            elimSql.append(" WHERE ");
        } else {
            elimSql.append(" WHERE e.FOrgUnit = ? ");
            elimSql.append(" AND ");
            params.add(this.orgUnitId);
        }
        elimSql.append(" e.FCurrencyID = ?").append(" AND ri.fNumber = ?").append(" AND ee.FDataElement = ?").append(" AND e.FValueType = ?").append(" AND e.FYear = ?").append(" AND e.FPeriod= ?").append(" AND e.FOrgBoundID = ?").append(" AND e.FCheckedStatus = 2 ").append(" AND de.FKeyLongNumber = ?").append(" AND e.FDataCollectNumber = ?");
        params.add(this.mapParams.get("KEY_CURRENCY_ID"));
        params.add(this.mapParams.get("KEY_ITEM_NUMBER"));
        params.add(this.mapParams.get("DataElement"));
        params.add(this.mapParams.get("ValueType"));
        params.add(this.mapParams.get("Year"));
        params.add(this.mapParams.get("Period"));
        params.add(this.orgTreeId);
        params.add(this.mapParams.get("KEY_DYNAITEM_NUMBER"));
        params.add(this.mapParams.get("KEY_DATACOLLECT_NUMBER"));
        return elimSql.toString();
    }

    private String getCompanyMapSql(String orgTreeSql, String companySql) throws BOSException {
        return DynaRptCalcServerHelper.getOrgTreeCompanySql(this.ctx, orgTreeSql, companySql, this.paramInfo, null);
    }
}

