/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.articulation;

import com.kingdee.eas.fi.gr.cslrpt.articulation.ArticulationCheckResult;
import com.kingdee.eas.fi.gr.cslrpt.articulation.articulationinfo.ArticulationInfo;
import com.kingdee.eas.fi.gr.cslrpt.articulation.articulationinfo.Formula;
import com.kingdee.eas.fi.gr.cslrpt.articulation.articulationinfo.ItemFormulaInfo;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ArticulationCheckResultAdapter {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.cslrpt.articulation.ArticulationCheckResultAdapter");

    public static List getArticulationCheckResult(Map reportArticulationResult) {
        ArrayList resultList = new ArrayList();
        if (reportArticulationResult == null) {
            return resultList;
        }
        Iterator it = reportArticulationResult.keySet().iterator();
        while (it.hasNext()) {
            HashMap<String, Object> reportResultMap = new HashMap<String, Object>();
            String reportId = (String)it.next();
            reportResultMap.put("KEY_ID", reportId);
            ArticulationCheckResult articulationCheckResult = (ArticulationCheckResult)reportArticulationResult.get(reportId);
            if (!articulationCheckResult.isDispenseArticulation() || articulationCheckResult.isPassArticulation()) {
                reportResultMap.put("KEY_CHECK_FLAG", Boolean.TRUE);
            } else if (!StringUtils.isEmpty((String)articulationCheckResult.getCheckMessage())) {
                reportResultMap.put("KEY_CHECK_FLAG", Boolean.FALSE);
            }
            if (!StringUtils.isEmpty((String)articulationCheckResult.getCheckMessage())) {
                reportResultMap.put("KEY_CHECK_MESSAGE", articulationCheckResult.getCheckMessage());
            }
            resultList.add(reportResultMap);
            List errorrArticulationItemFormulaInfoList = ArticulationCheckResultAdapter.getErrorArticulationItemFormulaInfoList(articulationCheckResult);
            resultList.addAll(errorrArticulationItemFormulaInfoList);
        }
        return resultList;
    }

    private static List getErrorArticulationItemFormulaInfoList(ArticulationCheckResult articulationCheckResult) {
        ArrayList resultList = new ArrayList();
        for (ArticulationInfo articulationInfo : articulationCheckResult.getErrorArticulationList()) {
            if (!articulationInfo.isAvailable()) continue;
            HashMap<String, Object> itemSite = new HashMap<String, Object>();
            itemSite.put("KEY_ID", articulationInfo.getId());
            itemSite.put("KEY_CHECK_TYPE", new Integer(articulationInfo.getArticulationCheckType()));
            for (Map.Entry entry : articulationInfo.getDetailFormulaMap().entrySet()) {
                Map extendedProperty;
                Formula formula = (Formula)entry.getValue();
                if (!(formula.getFunctionExpr() instanceof FunctionExpr)) continue;
                FunctionExpr functionExpr = (FunctionExpr)formula.getFunctionExpr();
                String formulaName = functionExpr.funcionName;
                if (!Formula.isItemFormula(formulaName) && !Formula.isAcctItemFormula(formulaName) || (extendedProperty = formula.getExtendedProperty()).get("itemFormulaInfo") == null) continue;
                ItemFormulaInfo itemFormulaInfo = (ItemFormulaInfo)extendedProperty.get("itemFormulaInfo");
                HashMap<String, Object> itemInfoMap = new HashMap<String, Object>();
                itemInfoMap.put("sheetId", itemFormulaInfo.getSheetId());
                itemInfoMap.put("row", new Integer(itemFormulaInfo.getRow()));
                itemInfoMap.put("col", new Integer(itemFormulaInfo.getCol()));
                itemInfoMap.put("reportId", itemFormulaInfo.getReportId());
                itemInfoMap.put("itemNumber", itemFormulaInfo.getItemNumber());
                itemInfoMap.put("dataElement", new Integer(itemFormulaInfo.getDataElement()));
                itemInfoMap.put("valueType", new Integer(itemFormulaInfo.getValueType()));
                if (formulaName.equalsIgnoreCase("DITEM") || formulaName.equalsIgnoreCase("DYITEM")) {
                    itemInfoMap.put("ditemNumber", itemFormulaInfo.getKeyNumber());
                }
                itemSite.put(functionExpr.toString(), itemInfoMap);
            }
            resultList.add(itemSite);
        }
        return resultList;
    }
}

