/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.articulation;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CSLPropertyAdapter;
import com.kingdee.eas.fi.gr.cslrpt.CslReportCollection;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCheckResultTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemCheckFormulaInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemDiffIndexInfo;
import com.kingdee.eas.fi.gr.cslrpt.articulation.ArticulationCheckResult;
import com.kingdee.eas.fi.gr.cslrpt.articulation.IArticulationService;
import com.kingdee.eas.fi.gr.cslrpt.articulation.articulationinfo.ArticulationInfo;
import com.kingdee.eas.fi.gr.cslrpt.articulation.articulationinfo.BtwTableArticulationInfo;
import com.kingdee.eas.fi.gr.cslrpt.articulation.articulationinfo.Formula;
import com.kingdee.eas.fi.gr.cslrpt.articulation.articulationinfo.ItemDiffArticulationInfo;
import com.kingdee.eas.fi.gr.cslrpt.articulation.articulationinfo.ItemFormulaInfo;
import com.kingdee.eas.fi.gr.cslrpt.articulation.articulationprocessor.AbstractArticulationProcessor;
import com.kingdee.eas.fi.gr.cslrpt.articulation.articulationprocessor.ArticulationProcessorFactory;
import com.kingdee.eas.fi.gr.cslrpt.articulation.articulationprocessor.IArticulationProcessor;
import com.kingdee.eas.fi.gr.cslrpt.articulation.batchquery.AcctDyItemLocationBatchQuery;
import com.kingdee.eas.fi.gr.cslrpt.articulation.batchquery.CellPostilBatchQuery;
import com.kingdee.eas.fi.gr.cslrpt.articulation.batchquery.ItemFormulaInfoBatchQuery;
import com.kingdee.eas.fi.gr.cslrpt.articulation.report.MessageDisplayFactory;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CheckFormulaIfClauseUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.ParameterContext;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.newrpt.formula.FormulaRuntimeFactory;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.formula.ReportCalculateContext;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.IntExpr;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ArticulationService
implements IArticulationService {
    private static Logger logger = Logger.getLogger(ArticulationService.class);
    private int catchSize = 0;

    /*
     * WARNING - void declaration
     */
    @Override
    public Map checkArticulation(Context ctx, List idList, int articulationCheckType) throws BOSException, EASBizException {
        void var13_15;
        if (idList == null || idList.size() == 0) {
            return null;
        }
        boolean[] values = CSLParamUtil.batchGetParam(ctx, new String[]{"GR_CSL_CHECKFORMULA_001", "GR_CSL_MergeByFiscalPeriod", "GR_CSL_Support13Period", "GR_CSL_SupportOtherDS"});
        boolean isCheckArticulationItemInfoNoExist = values[0];
        boolean isMergeByFiscalPeriod = values[1];
        boolean isSupport13Period = values[2];
        boolean isSupportOtherDS = values[3];
        boolean isCheckAllTrees = CSLParamUtil.getBooleanCslParamValue(ctx, "KEY_CSLPARAM_IsCheckAllTrees");
        Map cslReportMap = new HashMap();
        if (idList.get(0) instanceof CslReportInfo) {
            ArrayList<String> newIds = new ArrayList<String>(idList.size());
            for (Object e : idList) {
                if (!(e instanceof CslReportInfo)) continue;
                newIds.add(((CslReportInfo)e).getId().toString());
                cslReportMap.put(((CslReportInfo)e).getId().toString(), e);
            }
            idList = newIds;
        } else {
            cslReportMap = this.getCslReportMapByIdList(ctx, idList);
        }
        HashMap reportArticulationResult = new HashMap();
        Map cslparams = RptUtil.getCslParams((Context)ctx, (String[])new String[]{"KEY_CSLPARAM_CHECKFORMULA_DITEMBATCH_SIZE", "KEY_CSLPARAM_CHECKFORMULA_ITEMBATCH_SIZE"});
        Object var13_14 = null;
        CslReportInfo firstRptInfo = (CslReportInfo)cslReportMap.get(idList.iterator().next());
        HashMap<String, ArticulationCheckResult> batchReportArticulationResult = new HashMap<String, ArticulationCheckResult>();
        HashMap<String, List> articulationCatch = new HashMap<String, List>();
        int batchSize = 0;
        this.catchSize = 0;
        for (String reportId : idList) {
            CslReportInfo rptInfo = (CslReportInfo)cslReportMap.get(reportId);
            if (RptSrcTypeEnum.DYNACSLELIMREPORT_FASTMERGE.equals((Object)rptInfo.getSourceType()) || RptSrcTypeEnum.DYNACSLELIMREPORT.equals((Object)rptInfo.getSourceType()) || RptSrcTypeEnum.MULTIDYNAMICCSLELIMREPORT.equals((Object)rptInfo.getSourceType()) || RptSrcTypeEnum.MULTIDYNAMICCSLELIMREPORT_FASTMERGE.equals((Object)rptInfo.getSourceType())) continue;
            ParameterContext parameterContext = new ParameterContext(ctx);
            parameterContext.setAttribute("isSupportOtherDS", new Boolean(isSupportOtherDS));
            List articulationList = this.getArticulationInfoList(ctx, rptInfo, parameterContext, articulationCheckType, articulationCatch);
            ArticulationCheckResult artiCheckResult = new ArticulationCheckResult(rptInfo);
            batchReportArticulationResult.put(reportId, artiCheckResult);
            if (articulationList.isEmpty()) {
                artiCheckResult.setCheckResultCode(1);
                continue;
            }
            if (var13_15 == null) {
                FormulaRuntimeFactory.FormulaRuntimeEnv formulaRuntimeEnv = this.getCalculateFormulaRuntimeEnv(ctx, firstRptInfo, isMergeByFiscalPeriod);
            }
            this.getParameterContext(ctx, rptInfo, parameterContext, cslparams, isSupportOtherDS, isMergeByFiscalPeriod, isSupport13Period, isCheckArticulationItemInfoNoExist);
            List<OrgTreeInfo> orgBoundList = this.getOrgBoundList(ctx, rptInfo, isCheckAllTrees);
            for (int i = 0; i < orgBoundList.size(); ++i) {
                OrgTreeInfo treeInfo = orgBoundList.get(i);
                parameterContext.setAttribute("orgTreeInfo", treeInfo);
                parameterContext.setAttribute("orgUnitNumber", this.getOrgUnitNumber(ctx, treeInfo, rptInfo));
                List<ArticulationInfo> orgBoundArticulationList = this.processArticulationPerOrgBound(ctx, treeInfo, articulationList, parameterContext, articulationCheckType);
                batchSize += orgBoundArticulationList.size();
                artiCheckResult.addOrgTreeArticulation(treeInfo.getNumber(), orgBoundArticulationList);
                this.fillFormulaIntoCalculateBook(ctx, (FormulaRuntimeFactory.FormulaRuntimeEnv)var13_15, rptInfo, treeInfo, orgBoundArticulationList, articulationCheckType);
            }
            if (batchSize <= 10000) continue;
            this.calcAndcheck(ctx, (FormulaRuntimeFactory.FormulaRuntimeEnv)var13_15, firstRptInfo, batchReportArticulationResult, articulationCheckType, cslReportMap, cslparams, values);
            reportArticulationResult.putAll(batchReportArticulationResult);
            batchReportArticulationResult.clear();
            batchSize = 0;
            Object var13_17 = null;
        }
        if (!batchReportArticulationResult.isEmpty()) {
            this.calcAndcheck(ctx, (FormulaRuntimeFactory.FormulaRuntimeEnv)var13_15, firstRptInfo, batchReportArticulationResult, articulationCheckType, cslReportMap, cslparams, values);
            reportArticulationResult.putAll(batchReportArticulationResult);
        }
        articulationCatch.clear();
        return reportArticulationResult;
    }

    private List getArticulationInfoList(Context ctx, CslReportInfo rptInfo, ParameterContext parameterContext, int articulationCheckType, Map<String, List> articulationCatch) throws BOSException, EASBizException {
        StringBuffer rptKey = new StringBuffer();
        rptKey.append(rptInfo.getTemplate().getNumber());
        int tmpType = rptInfo.getTemplate().getTemplateType().getValue();
        if (tmpType == 2) {
            tmpType = 6;
        } else if (tmpType == 12) {
            tmpType = 10;
        } else if (tmpType == 16) {
            tmpType = 15;
        }
        rptKey.append(tmpType);
        if (articulationCheckType == 3) {
            rptKey.append(rptInfo.getCurrency().getId().toString());
            rptKey.append(rptInfo.getYear());
            rptKey.append(rptInfo.getPeriod());
        }
        if (articulationCatch.containsKey(rptKey.toString())) {
            return articulationCatch.get(rptKey.toString());
        }
        IArticulationProcessor artiProcessor = ArticulationProcessorFactory.getArticulationProcessor(articulationCheckType);
        List articulationList = artiProcessor.getArticulationInfoList(ctx, rptInfo, parameterContext);
        if (this.catchSize + articulationList.size() > 20000) {
            articulationCatch.clear();
            this.catchSize = 0;
        }
        articulationCatch.put(rptKey.toString(), articulationList);
        this.catchSize += articulationList.size();
        return articulationList;
    }

    private void calcAndcheck(Context ctx, FormulaRuntimeFactory.FormulaRuntimeEnv formulaRuntimeEnv, CslReportInfo firstRptInfo, Map batchReportArticulationResult, int articulationCheckType, Map cslReportMap, Map cslparams, boolean[] values) throws BOSException, EASBizException {
        boolean isCheckArticulationItemInfoNoExist = values[0];
        boolean isMergeByFiscalPeriod = values[1];
        boolean isSupport13Period = values[2];
        boolean isSupportOtherDS = values[3];
        if (formulaRuntimeEnv == null) {
            formulaRuntimeEnv = this.getCalculateFormulaRuntimeEnv(ctx, firstRptInfo, isMergeByFiscalPeriod);
        }
        formulaRuntimeEnv.getCalculateBook().calc();
        this.saveCheckFormulaBook(formulaRuntimeEnv.getCalculateBook());
        ParameterContext parameterContext = new ParameterContext(ctx);
        parameterContext.setAttribute("isSupport13Period", new Boolean(isSupport13Period));
        parameterContext.setAttribute("isSupportOtherDS", new Boolean(isSupportOtherDS));
        this.getArticulationCheckResult(batchReportArticulationResult, formulaRuntimeEnv, parameterContext, articulationCheckType);
        this.getArticalationItemPositeion(ctx, batchReportArticulationResult, cslReportMap, cslparams, isSupportOtherDS, isMergeByFiscalPeriod, isSupport13Period, isCheckArticulationItemInfoNoExist);
        this.getArticulationCheckMessage(batchReportArticulationResult, parameterContext, articulationCheckType);
        this.clearOtherResult(batchReportArticulationResult);
    }

    private void clearOtherResult(Map reportArticulationResult) throws BOSException, EASBizException {
        if (reportArticulationResult != null) {
            for (String reportId : reportArticulationResult.keySet()) {
                ArticulationCheckResult articulationCheckResult = (ArticulationCheckResult)reportArticulationResult.get(reportId);
                articulationCheckResult.getOrgTreeArticulationMap().clear();
            }
        }
    }

    private String getOrgUnitNumber(Context ctx, OrgTreeInfo orgTreeInfo, CslReportInfo rptInfo) {
        String number = "";
        if (rptInfo.getOrgUnit() != null && rptInfo.getOrgUnit().getNumber() != null) {
            number = rptInfo.getOrgUnit().getNumber().toString();
        }
        return number;
    }

    private Map getCslReportMapByIdList(Context ctx, List idList) throws BOSException {
        if (idList == null || idList.isEmpty()) {
            return null;
        }
        ICslReport iCslReport = CslReportFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(new FilterInfo());
        HashSet idSet = new HashSet(idList);
        view.getFilter().getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("template.number"));
        sic.add(new SelectorItemInfo("template.templateType"));
        sic.add(new SelectorItemInfo("template.group"));
        sic.add(new SelectorItemInfo("sourceCurrency.number"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("orgUnit.number"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("orgTree.number"));
        sic.add(new SelectorItemInfo("dataCollect.*"));
        sic.add(new SelectorItemInfo("dataCollect.id"));
        sic.add(new SelectorItemInfo("dataCollect.number"));
        view.setSelector(sic);
        CslReportCollection collection = iCslReport.getCslReportCollection(view);
        HashMap<String, CslReportInfo> reportMap = new HashMap<String, CslReportInfo>();
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            CslReportInfo cslReportInfo = (CslReportInfo)it.next();
            reportMap.put(cslReportInfo.getId().toString(), cslReportInfo);
        }
        return reportMap;
    }

    private void getArticulationCheckResult(Map reportArticulationResult, FormulaRuntimeFactory.FormulaRuntimeEnv formulaRuntimeEnv, ParameterContext parameterContext, int type) throws BOSException, EASBizException {
        IArticulationProcessor processor = ArticulationProcessorFactory.getArticulationProcessor(type);
        Sheet sheet = formulaRuntimeEnv.getCalculateSheet();
        for (int row = 0; row <= sheet.getMaxRowIndex(); ++row) {
            processor.compareCalculateValue(reportArticulationResult, sheet, row);
        }
    }

    private void getArticulationCheckMessage(Map reportArticulationResult, ParameterContext parameterContext, int type) {
        IArticulationProcessor processor = ArticulationProcessorFactory.getArticulationProcessor(type);
        for (Map.Entry entry : reportArticulationResult.entrySet()) {
            ArticulationCheckResult result = (ArticulationCheckResult)entry.getValue();
            boolean isPass = true;
            for (Object obj : result.getErrorArticulationList()) {
                boolean isRequestAnnotation;
                boolean articulationHasPostil;
                if (obj instanceof BtwTableArticulationInfo) {
                    ArticulationInfo articulInfo;
                    int formulaCheckResultType = ((BtwTableArticulationInfo)obj).getCheckFormulaInfo().getCheckResult().getValue();
                    if (formulaCheckResultType == 3) {
                        articulationHasPostil = ((AbstractArticulationProcessor)processor).isArticulationHasPostil((BtwTableArticulationInfo)obj);
                        if (((BtwTableArticulationInfo)obj).isPassArticulation() || articulationHasPostil || !((BtwTableArticulationInfo)obj).isAvailable()) continue;
                        isPass = false;
                        break;
                    }
                    if (formulaCheckResultType == 2 || (articulInfo = (ArticulationInfo)obj).isPassArticulation() || !articulInfo.isAvailable()) continue;
                    isPass = false;
                    break;
                }
                if (obj instanceof ItemDiffArticulationInfo && (isRequestAnnotation = ((ItemDiffArticulationInfo)obj).getItemDiffIndexInfo().isIsRequestLabel())) {
                    articulationHasPostil = ((AbstractArticulationProcessor)processor).isArticulationHasPostil((ItemDiffArticulationInfo)obj);
                    if (((ItemDiffArticulationInfo)obj).isPassArticulation() || articulationHasPostil || !((ItemDiffArticulationInfo)obj).isAvailable()) continue;
                    isPass = false;
                    break;
                }
                ArticulationInfo articulInfo = (ArticulationInfo)obj;
                if (articulInfo.isPassArticulation() || !articulInfo.isAvailable()) continue;
                isPass = false;
                break;
            }
            result.setCheckResultCode(isPass ? 2 : 3);
            parameterContext.setAttribute("reportCheckFormulaResult", result);
            String reportMessage = MessageDisplayFactory.getMessageDisplay(type).getReportMessage(parameterContext);
            result.setCheckMessage(reportMessage);
        }
    }

    private void getArticalationItemPositeion(Context ctx, Map reportArticulationResult, Map cslReportMap, Map cslparams, boolean isSupportOtherDS, boolean isMergeByFiscalPeriod, boolean isSupport13Period, boolean isCheckArticulationItemInfoNoExist) throws BOSException, EASBizException {
        for (Object reportId : reportArticulationResult.keySet()) {
            CslReportInfo rptInfo = (CslReportInfo)cslReportMap.get(reportId);
            List arrticulatList = ((ArticulationCheckResult)reportArticulationResult.get(reportId)).getErrorArticulationList();
            if (arrticulatList == null || arrticulatList.isEmpty()) continue;
            HashMap<OrgTreeInfo, ArrayList<ArticulationInfo>> orgTree_ArtInfoMap = new HashMap<OrgTreeInfo, ArrayList<ArticulationInfo>>();
            for (Object info : arrticulatList) {
                ArticulationInfo artInfo = (ArticulationInfo)info;
                ArrayList<ArticulationInfo> artInfos = (ArrayList<ArticulationInfo>)orgTree_ArtInfoMap.get(artInfo.getOrgTreeInfo());
                if (artInfos == null) {
                    artInfos = new ArrayList<ArticulationInfo>();
                    orgTree_ArtInfoMap.put(artInfo.getOrgTreeInfo(), artInfos);
                }
                artInfos.add(artInfo);
            }
            for (OrgTreeInfo orgTreeInfo : orgTree_ArtInfoMap.keySet()) {
                ParameterContext parameterContext = this.getParameterContext(ctx, rptInfo, null, cslparams, isSupportOtherDS, isMergeByFiscalPeriod, isSupport13Period, isCheckArticulationItemInfoNoExist);
                parameterContext.setAttribute("orgTreeInfo", orgTreeInfo);
                parameterContext.setAttribute("orgUnitNumber", this.getOrgUnitNumber(ctx, orgTreeInfo, rptInfo));
                this.queryItemFormulaInfo(ctx, (List)orgTree_ArtInfoMap.get(orgTreeInfo), parameterContext);
                this.queryAcctDyItemFormulaInfo(ctx, (List)orgTree_ArtInfoMap.get(orgTreeInfo), parameterContext);
                this.queryItemFormulaCellPostil(ctx, (List)orgTree_ArtInfoMap.get(orgTreeInfo), parameterContext);
            }
        }
    }

    private ParameterContext getParameterContext(Context ctx, CslReportInfo rptInfo, ParameterContext parameterContext, Map cslparams, boolean isSupportOtherDS, boolean isMergeByFiscalPeriod, boolean isSupport13Period, boolean isCheckArticulationItemInfoNoExist) throws BOSException, EASBizException {
        if (parameterContext == null) {
            parameterContext = new ParameterContext(ctx);
            parameterContext.setAttribute("isSupportOtherDS", new Boolean(isSupportOtherDS));
        }
        PeriodCollection periodCollection = this.getPeriodCollection(ctx, rptInfo, isMergeByFiscalPeriod);
        ICalculateContextProvider calculateContextProvider = this.getCalculateContextProvider(ctx, rptInfo, isMergeByFiscalPeriod);
        parameterContext.setAttribute("cslReportInfo", rptInfo);
        parameterContext.setAttribute("calculateContextProvider", calculateContextProvider);
        parameterContext.setAttribute("periodCollection", periodCollection);
        parameterContext.setAttribute("isMergeByFiscalPeriod", new Boolean(isMergeByFiscalPeriod));
        parameterContext.setAttribute("isSupport13Period", new Boolean(isSupport13Period));
        parameterContext.setAttribute("isCheckArticulationItemInfoNoExist", new Boolean(isCheckArticulationItemInfoNoExist));
        parameterContext.setAttribute("KEY_CSLPARAM_CHECKFORMULA_DITEMBATCH_SIZE", cslparams.get("KEY_CSLPARAM_CHECKFORMULA_DITEMBATCH_SIZE"));
        parameterContext.setAttribute("KEY_CSLPARAM_CHECKFORMULA_ITEMBATCH_SIZE", cslparams.get("KEY_CSLPARAM_CHECKFORMULA_ITEMBATCH_SIZE"));
        return parameterContext;
    }

    private void fillFormulaIntoCalculateBook(Context ctx, FormulaRuntimeFactory.FormulaRuntimeEnv formulaRuntimeEnv, CslReportInfo cslReportInfo, OrgTreeInfo orgTreeInfo, List<ArticulationInfo> orgBoundCheckFormulaList, int articulationCheckType) throws EASBizException {
        IArticulationProcessor articulationProcessor = ArticulationProcessorFactory.getArticulationProcessor(articulationCheckType);
        Sheet calculateSheet = formulaRuntimeEnv.getCalculateSheet();
        int row = calculateSheet.getMaxRowIndex() + 1;
        for (int i = 0; i < orgBoundCheckFormulaList.size(); ++i) {
            ArticulationInfo articulationInfo = orgBoundCheckFormulaList.get(i);
            if (!articulationInfo.isAvailable()) continue;
            articulationProcessor.fillFormulaIntoCalculateBook(ctx, calculateSheet, row, articulationInfo, cslReportInfo, orgTreeInfo);
            ++row;
        }
    }

    private FormulaRuntimeFactory.FormulaRuntimeEnv getCalculateFormulaRuntimeEnv(Context ctx, CslReportInfo reportInfo, boolean isMergeByFiscalPeriod) throws BOSException {
        FormulaRuntimeFactory.FormulaRuntimeEnv formulaRuntimeEnv = null;
        try {
            ICalculateContextProvider calculateContextProvider = this.getCalculateContextProvider(ctx, reportInfo, isMergeByFiscalPeriod);
            formulaRuntimeEnv = FormulaRuntimeFactory.getInstance().getFormulaRuntime(calculateContextProvider);
        }
        catch (Exception ex) {
            throw new BOSException("init formula runtime error", (Throwable)ex);
        }
        return formulaRuntimeEnv;
    }

    private PeriodCollection getPeriodCollection(Context ctx, CslReportInfo reportInfo, boolean isMergeByFiscalPeriod) throws EASBizException, BOSException {
        PeriodCollection periods = null;
        if (isMergeByFiscalPeriod) {
            if (this.isCslReport(reportInfo.getSourceType()) && reportInfo.getOrgTree() != null) {
                periods = FiscalPeriodHelper.getPeriodCollection(ctx, reportInfo.getOrgTree());
            } else if (reportInfo.getCompany() != null) {
                periods = FiscalPeriodHelper.getPeriodCollection(ctx, reportInfo.getCompany().getId().toString());
            }
        }
        return periods;
    }

    private boolean isCslReport(RptSrcTypeEnum rptSourceType) {
        return RptSrcTypeEnum.CONSOLIDATION.equals((Object)rptSourceType) || RptSrcTypeEnum.SUM.equals((Object)rptSourceType) || RptSrcTypeEnum.DYNAMICCSLREPORT.equals((Object)rptSourceType) || RptSrcTypeEnum.DYNAMICSUMREPORT.equals((Object)rptSourceType) || RptSrcTypeEnum.MANUSCRIPT.equals((Object)rptSourceType) || RptSrcTypeEnum.SUM_FASTMERGE.equals((Object)rptSourceType) || RptSrcTypeEnum.MANUSCRIPT_FASTMERGE.equals((Object)rptSourceType) || RptSrcTypeEnum.CONSOLIDATION_FASTMERGE.equals((Object)rptSourceType) || RptSrcTypeEnum.DYNAMICSUMREPORT_FASTMERGE.equals((Object)rptSourceType) || RptSrcTypeEnum.DYNAMICCSLREPORT_FASTMERGE.equals((Object)rptSourceType);
    }

    private List getOrgBoundArticulationList(Context ctx, List checkFormulaList, ParameterContext parameterContext, OrgTreeInfo orgTreeInfo, int articulationCheckType) throws BOSException {
        ArrayList<ArticulationInfo> orgBoundArticulationList = new ArrayList<ArticulationInfo>();
        IArticulationProcessor articulationProcessor = ArticulationProcessorFactory.getArticulationProcessor(articulationCheckType);
        for (ArticulationInfo articulationInfo : checkFormulaList) {
            ArticulationInfo newArticulationInfo = articulationProcessor.newArticulationInfoInstance(articulationInfo, orgTreeInfo);
            this.checkIfClauseFormula(ctx, newArticulationInfo, parameterContext);
            newArticulationInfo.paserFormula(ctx);
            orgBoundArticulationList.add(newArticulationInfo);
        }
        return orgBoundArticulationList;
    }

    private List<ArticulationInfo> processArticulationPerOrgBound(Context ctx, OrgTreeInfo orgTreeInfo, List<ArticulationInfo> artiList, ParameterContext parameterContext, int articulationCheckType) throws BOSException, EASBizException {
        ArrayList<ArticulationInfo> orgBoundArticulationList = new ArrayList<ArticulationInfo>();
        IArticulationProcessor articulationProcessor = ArticulationProcessorFactory.getArticulationProcessor(articulationCheckType);
        for (int i = 0; i < artiList.size(); ++i) {
            ArticulationInfo newArticulationInfo = articulationProcessor.newArticulationInfoInstance(artiList.get(i), orgTreeInfo);
            this.checkIfClauseFormula(ctx, newArticulationInfo, parameterContext);
            if (!newArticulationInfo.isAvailable()) continue;
            newArticulationInfo.paserFormula(ctx);
            orgBoundArticulationList.add(newArticulationInfo);
        }
        this.fillFormulaParameter(ctx, orgBoundArticulationList, parameterContext, articulationCheckType);
        return orgBoundArticulationList;
    }

    private void fillFormulaParameter(Context ctx, List articulationList, ParameterContext parameterContext, int articulationCheckType) {
        IArticulationProcessor articulationProcessor = ArticulationProcessorFactory.getArticulationProcessor(articulationCheckType);
        for (ArticulationInfo articulationInfo : articulationList) {
            if (!articulationInfo.isAvailable()) continue;
            articulationProcessor.fillFormulaParameter(ctx, articulationInfo, parameterContext);
        }
    }

    private List<Formula> getItemFormulaList(List<ArticulationInfo> orgBoundArticulationList) {
        ArrayList<Formula> itemFormulaList = new ArrayList<Formula>();
        for (ArticulationInfo articulationInfo : orgBoundArticulationList) {
            for (Map.Entry entry : articulationInfo.getDetailFormulaMap().entrySet()) {
                FunctionExpr functionExpr;
                Formula formula = (Formula)entry.getValue();
                if (!(formula.getFunctionExpr() instanceof FunctionExpr) || !this.isItemFormula(functionExpr = (FunctionExpr)formula.getFunctionExpr())) continue;
                itemFormulaList.add(formula);
            }
        }
        return itemFormulaList;
    }

    private List<Formula> getAcctItemFormulaList(List<ArticulationInfo> orgBoundArticulationList) {
        ArrayList<Formula> itemFormulaList = new ArrayList<Formula>();
        for (int i = 0; i < orgBoundArticulationList.size(); ++i) {
            ArticulationInfo articulationInfo = orgBoundArticulationList.get(i);
            for (Map.Entry entry : articulationInfo.getDetailFormulaMap().entrySet()) {
                FunctionExpr functionExpr;
                Formula formula = (Formula)entry.getValue();
                if (!(formula.getFunctionExpr() instanceof FunctionExpr) || !this.isAcctItemFormula(functionExpr = (FunctionExpr)formula.getFunctionExpr())) continue;
                itemFormulaList.add(formula);
            }
        }
        return itemFormulaList;
    }

    private boolean isAcctItemFormula(FunctionExpr functionExpr) {
        return Formula.isAcctItemFormula(functionExpr.funcionName);
    }

    private boolean isItemFormula(FunctionExpr functionExpr) {
        return Formula.isItemFormula(functionExpr.funcionName);
    }

    private List getQueryCellPostilItemFormulaList(List orgBoundArticulationList) {
        ArrayList<Formula> itemFormulaList = new ArrayList<Formula>();
        for (ArticulationInfo articulationInfo : orgBoundArticulationList) {
            ItemDiffArticulationInfo itemDiffArticulationInfo;
            RPTItemDiffIndexInfo itemDiffIndexInfo;
            boolean isRequestLabel;
            BtwTableArticulationInfo btwTableArticulationInfo;
            RPTItemCheckFormulaInfo checkFormulaInfo;
            FormulaCheckResultTypeEnum checkResult;
            if (articulationInfo.getArticulationCheckType() == 2 ? (checkResult = (checkFormulaInfo = (btwTableArticulationInfo = (BtwTableArticulationInfo)articulationInfo).getCheckFormulaInfo()).getCheckResult()).getValue() != 3 : articulationInfo.getArticulationCheckType() == 3 && !(isRequestLabel = (itemDiffIndexInfo = (itemDiffArticulationInfo = (ItemDiffArticulationInfo)articulationInfo).getItemDiffIndexInfo()).isIsRequestLabel())) continue;
            for (Map.Entry entry : articulationInfo.getDetailFormulaMap().entrySet()) {
                FunctionExpr functionExpr;
                Formula formula = (Formula)entry.getValue();
                if (!(formula.getFunctionExpr() instanceof FunctionExpr) || !this.isItemFormula(functionExpr = (FunctionExpr)formula.getFunctionExpr()) && !this.isAcctItemFormula(functionExpr)) continue;
                itemFormulaList.add(formula);
            }
        }
        return itemFormulaList;
    }

    private void queryItemFormulaInfo(Context ctx, List<ArticulationInfo> orgBoundArticulationList, ParameterContext parameterContext) throws EASBizException, BOSException {
        List<Formula> itemFormulaList = this.getItemFormulaList(orgBoundArticulationList);
        ItemFormulaInfoBatchQuery itemFormulaInfoBatchQuery = new ItemFormulaInfoBatchQuery(ctx, parameterContext);
        itemFormulaInfoBatchQuery.init(itemFormulaList);
        itemFormulaInfoBatchQuery.executeItemFormulaInfoBatchQuery();
        this.verifyItemFormulaAvailable(itemFormulaList, parameterContext);
    }

    private void queryAcctDyItemFormulaInfo(Context ctx, List<ArticulationInfo> orgBoundArticulationList, ParameterContext parameterContext) throws EASBizException, BOSException {
        List<Formula> itemFormulaList = this.getAcctItemFormulaList(orgBoundArticulationList);
        AcctDyItemLocationBatchQuery batchQuery = new AcctDyItemLocationBatchQuery(ctx, parameterContext);
        if (itemFormulaList.size() == 0) {
            return;
        }
        batchQuery.init(itemFormulaList);
        batchQuery.executeItemFormulaInfoBatchQuery();
        this.verifyItemFormulaAvailable(itemFormulaList, parameterContext);
    }

    private void queryItemFormulaCellPostil(Context ctx, List orgBoundArticulationList, ParameterContext parameterContext) throws BOSException {
        List itemFormulaList = this.getQueryCellPostilItemFormulaList(orgBoundArticulationList);
        CellPostilBatchQuery cellPostilBatchQuery = new CellPostilBatchQuery(ctx, parameterContext);
        for (Formula formula : itemFormulaList) {
            Map extendedProperty = formula.getExtendedProperty();
            ItemFormulaInfo itemFormulaInfo = (ItemFormulaInfo)extendedProperty.get("itemFormulaInfo");
            if (itemFormulaInfo == null) continue;
            cellPostilBatchQuery.registerFormula(itemFormulaInfo);
        }
        cellPostilBatchQuery.executeCellPostilBatchQuery();
    }

    private void verifyItemFormulaAvailable(List<Formula> itemFormulaList, ParameterContext parameterContext) {
        Boolean isCheck = (Boolean)parameterContext.getAttribute("isCheckArticulationItemInfoNoExist");
        for (int i = 0; i < itemFormulaList.size(); ++i) {
            Formula f = itemFormulaList.get(i);
            ArticulationInfo articulationInfo = f.getArticulationInfo();
            if (f.getExtendedProperty().get("itemFormulaInfo") != null) continue;
            articulationInfo.setStatusCode(2);
            if (isCheck.booleanValue()) {
                f.setAvailable(false);
                if (!articulationInfo.isAvailable()) continue;
                articulationInfo.setAvailable(false);
                continue;
            }
            f.setFunctionExpr((Expression)new IntExpr(new BigDecimal(0.0).toBigInteger()));
        }
    }

    private void checkIfClauseFormula(Context ctx, ArticulationInfo articulationInfo, ParameterContext parameterContext) {
        boolean ifClause;
        String ifClauseFormula = articulationInfo.getIfClause();
        if (!StringUtils.isEmpty((String)ifClauseFormula) && !(ifClause = CheckFormulaIfClauseUtil.computeIfClause(ctx, ifClauseFormula, parameterContext))) {
            articulationInfo.setStatusCode(1);
            articulationInfo.setAvailable(false);
        }
    }

    private ICalculateContextProvider getCalculateContextProvider(Context ctx, CslReportInfo rptInfo, boolean isMergeByFiscalPeriod) throws BOSException {
        ReportCalculateContext calcContext = new ReportCalculateContext(ctx);
        CSLPropertyAdapter adapter = new CSLPropertyAdapter(rptInfo, ctx, isMergeByFiscalPeriod);
        adapter.setExtraProperty("isIncludeUnCommit", true);
        calcContext.setReportAdapter((IReportPropertyAdapter)adapter);
        try {
            ReportVariables reportVariables = ReportVariables.loadFromBook((Book)rptInfo.getBook());
            calcContext.setReportVariables(reportVariables);
        }
        catch (Exception ex) {
            throw new BOSException("UnpackBook Exception", (Throwable)ex);
        }
        return calcContext;
    }

    private List<OrgTreeInfo> getOrgBoundList(Context ctx, CslReportInfo rptInfo, boolean isCheckAllTrees) throws BOSException, SQLDataException {
        SQLBuilder builder = new SQLBuilder();
        builder.append("SELECT t.FId, t.FNumber, t.FName_" + ctx.getLocale() + " FName");
        builder.append("  FROM T_ORG_Tree t");
        builder.append("  JOIN T_CSL_RptReceived rec");
        builder.append("    ON t.FId = rec.FOrgtreeId");
        builder.append(" WHERE rec.FReportId = ?", (Object)rptInfo.getId().toString());
        builder.append(" ORDER BY t.FNumber");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)builder.getSQL(), (Object[])builder.getParams());
        ArrayList<OrgTreeInfo> ls = new ArrayList<OrgTreeInfo>();
        try {
            while (rs.next()) {
                OrgTreeInfo t = new OrgTreeInfo();
                t.setId(BOSUuid.read((String)rs.getString("FID")));
                t.setNumber(rs.getString("FNumber"));
                t.setName(rs.getString("FName"));
                ls.add(t);
                if (isCheckAllTrees) continue;
                break;
            }
        }
        catch (SQLException e1) {
            throw new SQLDataException(e1);
        }
        return ls;
    }

    private Map getGroupTemplateIdMap(Context ctx, Map cslReportmap) throws BOSException {
        if (cslReportmap == null || cslReportmap.isEmpty()) {
            return new HashMap(0);
        }
        Iterator iter = cslReportmap.keySet().iterator();
        CslReportInfo rptInfo = null;
        StringBuffer sql = new StringBuffer("select FId, ");
        sql.append(" (case when FGroupTemplateID is null then FId else FGroupTemplateID end) FGroupTemplateID ");
        sql.append(" from t_rpt_template where fid in (");
        while (iter.hasNext()) {
            rptInfo = (CslReportInfo)cslReportmap.get(iter.next());
            sql.append("'").append(rptInfo.getTemplate().getId().toString()).append("',");
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(")");
        IRowSet idRows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, String> groupTemplateIdMap = new HashMap<String, String>(cslReportmap.size());
        try {
            while (idRows.next()) {
                groupTemplateIdMap.put(idRows.getString("FId"), idRows.getString("FGroupTemplateID"));
            }
        }
        catch (SQLException e1) {
            throw new SQLDataException(e1);
        }
        return groupTemplateIdMap;
    }

    private void saveCheckFormulaBook(Book book) {
        String easInstanceHome = System.getProperty("EAS_INSTANCE_HOME");
        if (!StringUtils.isEmpty((String)easInstanceHome) && DebugLogger.isDebug) {
            try {
                IOHelper.saveToFile((Book)book, (String)(easInstanceHome + "/btwCheckBook.data"));
            }
            catch (IOException e) {
                logger.error((Object)"save btwCheckBookData error", (Throwable)e);
            }
        }
    }
}

