/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.FormulaCalcUnit;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.log.AutoItemLog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.BizFormulaDefine;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.ActionFactory;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.eas.fi.gr.cslrpt.util.ResourceDebugUtil;
import java.math.BigDecimal;
import java.text.MessageFormat;

public class CheckCalcResult {
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", CheckCalcResult.class);
    private AutoItemLog reportLog;
    private Context ctx;

    public CheckCalcResult(AutoItemLog reportLog) {
        this.reportLog = reportLog;
        this.ctx = ContextUtils.getContextFromSession();
    }

    public boolean exec(FormulaCalcUnit calcUnit, boolean recordLog) throws EASBizException, BOSException {
        return this.exec(calcUnit.getResult(), calcUnit, recordLog);
    }

    public boolean exec(Object result, FormulaCalcUnit calcUnit, boolean recordLog) throws EASBizException, BOSException {
        if (result instanceof Number) {
            if (recordLog) {
                String msg = ResourceDebugUtil.res("show.the.value.with.format", this.ctx.getOriginLocale());
                String formula = ActionFactory.get(BizFormulaDefine.class).showFormula(calcUnit.getItemFormula().formulaString(false), calcUnit.getItemFormula().getName());
                this.reportLog.success(calcUnit.getTemplate(), calcUnit.getCalcContext().getCompany(), MessageFormat.format(msg, formula, result), this.reportLog.convertItemKey(calcUnit.getItemFormula()));
            }
            return true;
        }
        if (result == null) {
            if (recordLog) {
                String msg = ResourceDebugUtil.res("show.the.value.with.format", this.ctx.getOriginLocale());
                String formula = ActionFactory.get(BizFormulaDefine.class).showFormula(calcUnit.getItemFormula().formulaString(false), calcUnit.getItemFormula().getName());
                this.reportLog.success(calcUnit.getTemplate(), calcUnit.getCalcContext().getCompany(), MessageFormat.format(msg, formula, new BigDecimal(0)), this.reportLog.convertItemKey(calcUnit.getItemFormula()));
            }
            return true;
        }
        if (result instanceof String) {
            if (((String)result).startsWith("#BAD FUNCTION")) {
                if (recordLog) {
                    String formulaErrorInfo = ((String)result).substring("#BAD FUNCTION".length());
                    if (formulaErrorInfo.startsWith("!:")) {
                        formulaErrorInfo = formulaErrorInfo.substring("!:".length());
                    } else if (formulaErrorInfo.startsWith("! :")) {
                        formulaErrorInfo = formulaErrorInfo.substring("! :".length());
                    }
                    this.recordLog(calcUnit, formulaErrorInfo);
                }
                calcUnit.setExceptionResult(true);
                return false;
            }
            if (recordLog) {
                this.recordLog(calcUnit, ResourceDebugUtil.res("error.string.value", this.ctx.getOriginLocale()) + ":" + result);
            }
        } else if (result instanceof Exception) {
            this.recordLog(calcUnit, "(" + ResourceDebugUtil.res("exception", this.ctx.getOriginLocale()) + ")" + ((Exception)result).getMessage());
        } else if (recordLog) {
            this.recordLog(calcUnit, ResourceDebugUtil.res("unknown.type.value", this.ctx.getOriginLocale()) + ":" + result);
        }
        calcUnit.setExceptionResult(true);
        return false;
    }

    public void recordLog(FormulaCalcUnit calcUnit, String formulaErrorInfo) throws EASBizException, BOSException {
        this.reportLog.fail(calcUnit.getTemplate(), calcUnit.getCalcContext().getCompany(), MessageFormat.format(ResourceDebugUtil.res("fail.to.execute.value.formula.with.format", this.ctx.getOriginLocale()), ActionFactory.get(BizFormulaDefine.class).showFormula(calcUnit.getItemFormula().formulaString(false), calcUnit.getItemFormula().getName()), formulaErrorInfo), this.reportLog.convertItemKey(calcUnit.getItemFormula()));
    }
}

