/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.FormulaSchemeCollection;
import com.kingdee.eas.fi.gr.cslrpt.FormulaSchemeInfo;
import com.kingdee.eas.fi.gr.cslrpt.IDynFormulaDefine;
import com.kingdee.eas.fi.gr.cslrpt.IFormulaScheme;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.RemoveSameGroupFormulaScheme;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.basepoint.ReportEntityForTemplate;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.QuerySheetParams;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.GeneralUtil;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.util.Set;

public class SaveFormulaScheme {
    private static final ILog log = LogFactory.getLog("AUTOITEM", SaveFormulaScheme.class);
    protected DBHandler dao;

    public SaveFormulaScheme(DBHandler dao) {
        this.dao = dao;
    }

    public void save(TemplateInfo template, OrgUnitInfo company, FormulaSchemeCollection schemes) throws EASBizException, BOSException {
        this.removeRepeat(template, company);
        this.dbSave(schemes, template, company);
        this.smallVersionDiffHandle(template, schemes);
    }

    protected void dbSave(FormulaSchemeCollection schemes, TemplateInfo template, OrgUnitInfo company) throws BOSException, EASBizException {
        log.info("db save {0}", new Object[]{schemes});
        IFormulaScheme formulaSchemeDao = this.dao.get(IFormulaScheme.class);
        DBHandler dao = new DBHandler(null);
        QuerySheetParams querySheetParams = new QuerySheetParams(dao);
        FormulaSchemeInfo scheme = null;
        ReportEntityForTemplate templateEntity = new ReportEntityForTemplate(template, querySheetParams);
        IObjectPK pk = null;
        int size = schemes.size();
        for (int i = 0; i < size; ++i) {
            scheme = schemes.get(i);
            scheme.setTemplate(template);
            if (company != null) {
                scheme.setCompany(company.castToFullOrgUnitInfo());
            }
            scheme.setEnvParam(templateEntity.getSheetParam(scheme.getFormulaSheetID()));
            pk = formulaSchemeDao.save((CoreBaseInfo)scheme);
            scheme.setId(BOSUuid.read((String)pk.toString()));
        }
    }

    protected void smallVersionDiffHandle(TemplateInfo template, FormulaSchemeCollection schemes) throws BOSException, EASBizException {
        if (template.getGroupTemplate() == null || template.getGroupTemplate().getId() == null) {
            return;
        }
        log.info("dealing small version(groupTemplate:{0})", new Object[]{template.getGroupTemplate().getId()});
        Set<String> excludeIds = new RemoveSameGroupFormulaScheme(this.dao).exec(template);
        if (excludeIds.isEmpty()) {
            return;
        }
        FormulaSchemeInfo scheme = null;
        int i = 0;
        while (i < schemes.size()) {
            scheme = schemes.get(i);
            if (excludeIds.contains(scheme.getId().toString())) {
                schemes.removeObject(i);
                continue;
            }
            ++i;
        }
    }

    protected void removeRepeat(TemplateInfo template, OrgUnitInfo company) throws BOSException, EASBizException {
        FilterInfo repeatFilter = new FilterInfo();
        repeatFilter.appendFilterItem("template.number", (Object)template.getNumber());
        if (company != null && company.getId() != null) {
            repeatFilter.appendFilterItem("company", (Object)company.getId().toString());
        } else {
            repeatFilter.getFilterItems().add(new FilterItemInfo("company", null, CompareType.EQUALS));
        }
        if (this.dao.get(IFormulaScheme.class).exists(repeatFilter)) {
            log.info("delete Existing formula scheme (filter:)", new Object[]{repeatFilter});
            Object[] schemeIds = this.dao.get(IFormulaScheme.class).delete(repeatFilter);
            Set<String> schemeIdSet = GeneralUtil.toStringSet(schemeIds);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("formulaScheme", schemeIdSet, CompareType.INCLUDE));
            this.dao.get(IDynFormulaDefine.class).delete(filter);
        }
    }
}

