/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.AutoItemBusinessFacadeFactory;
import com.kingdee.eas.fi.gr.cslrpt.AutoItemException;
import com.kingdee.eas.fi.gr.cslrpt.CheckFormulaException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextCompanyCollection;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextCompanyInfo;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextFactory;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextInfo;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextTemplateCollection;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcLogFactory;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcLogStatus;
import com.kingdee.eas.fi.gr.cslrpt.FormulaProcessCollection;
import com.kingdee.eas.fi.gr.cslrpt.FormulaProcessFactory;
import com.kingdee.eas.fi.gr.cslrpt.FormulaProcessInfo;
import com.kingdee.eas.fi.gr.cslrpt.SingleDataUpdateWayEnum;
import com.kingdee.eas.fi.gr.cslrpt.TempletDispenseFactory;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.ctx.CheckAndSupplyFormulaCalcContext;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.log.AutoItemLog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.log.thread.ILogThread;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.log.thread.LogThread;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.ActionFactory;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.eas.fi.gr.cslrpt.util.ResourceDebugUtil;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveSchmRptInfo;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveExecParams;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveParams;
import com.kingdee.eas.fi.gr.weaverpt.app.AbstractRptWeaveExecute;
import com.kingdee.eas.fi.gr.weaverpt.app.RptWeaveExecAddNew;
import com.kingdee.eas.fi.gr.weaverpt.app.RptWeaveExecCalc;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.ReportCollection;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.TemplateCollection;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Uuid;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class CalculateByFormulaCalcContext {
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", CalculateByFormulaCalcContext.class);
    private static final int MAX_CALCUNIT_SIZE = 10000;
    protected DBHandler dao;
    private static HashMap processMap = new HashMap();

    private static HashMap getProcessMap() {
        return processMap;
    }

    private static void setProcessMap(HashMap processMap) {
        CalculateByFormulaCalcContext.processMap = processMap;
    }

    public CalculateByFormulaCalcContext(DBHandler dao) {
        this.dao = dao;
    }

    public void exec(FormulaCalcContextInfo formulaCalcContext, String executeTaskId) throws EASBizException, BOSException {
        String finishDescription = "";
        int calcTotalTempSize = 0;
        int calcTotalCompSize = 0;
        int finishedReportNum = 0;
        Uuid previousCalcFlag = null;
        Uuid currentCalcFlag = Uuid.randomUUID();
        AutoItemLog reportLog = this.prepareLog(formulaCalcContext, executeTaskId);
        this.isContextExe(reportLog);
        try {
            LOG.error("[record]ready");
            reportLog.ready();
            this.checkParamComplete(formulaCalcContext);
            this.updateFormulaCalcContext(formulaCalcContext);
            FormulaCalcContextTemplateCollection templates = formulaCalcContext.getTemplates();
            FormulaCalcContextCompanyCollection savedCompanys = (FormulaCalcContextCompanyCollection)((Object)formulaCalcContext.getCompanys().clone());
            calcTotalTempSize = templates.size();
            calcTotalCompSize = savedCompanys.size();
            OrgType typeOrgType = formulaCalcContext.getOrgType();
            this.deleteReportAndCslrpt(formulaCalcContext, templates, savedCompanys);
            this.addFormulaPrcess(formulaCalcContext, calcTotalCompSize * calcTotalTempSize);
            this.calcRptPerTmpPerOrg(formulaCalcContext, calcTotalTempSize, calcTotalCompSize, finishedReportNum, previousCalcFlag, currentCalcFlag, reportLog, templates, savedCompanys, typeOrgType);
        }
        catch (Exception e) {
            LOG.error("exec error.", e);
            finishDescription = e.getMessage();
            if (finishDescription == null) {
                finishDescription = e.toString();
            }
            throw new BOSException((Throwable)e);
        }
        finally {
            if (!finishDescription.equals("")) {
                reportLog.finish(finishDescription);
            } else {
                reportLog.finish();
            }
            LOG.error("[record]finish");
        }
    }

    private void calcRptPerTmpPerOrg(FormulaCalcContextInfo formulaCalcContext, int calcTotalTempSize, int calcTotalCompSize, int finishedReportNum, Uuid previousCalcFlag, Uuid currentCalcFlag, AutoItemLog reportLog, FormulaCalcContextTemplateCollection templates, FormulaCalcContextCompanyCollection savedCompanys, OrgType typeOrgType) throws EASBizException, BOSException {
        if (this.isManuStopped(formulaCalcContext)) {
            return;
        }
        for (int i = 0; i < calcTotalTempSize; ++i) {
            TemplateInfo template = templates.get(i).getTemplate();
            template.setOrgType(typeOrgType);
            reportLog.processing(0, 0, 0, currentCalcFlag, previousCalcFlag);
            for (int j = 0; j < calcTotalCompSize; ++j) {
                FormulaCalcContextCompanyInfo companyEntity = savedCompanys.get(j);
                this.calculate(formulaCalcContext, template, companyEntity, reportLog);
                this.updateFormulaPrcess(formulaCalcContext, ++finishedReportNum);
            }
        }
    }

    private void updateFormulaCalcContext(FormulaCalcContextInfo formulaCalcContext) throws EASBizException, BOSException {
        formulaCalcContext.setExeYear(formulaCalcContext.getYear());
        formulaCalcContext.setExePeriod(formulaCalcContext.getPeriod());
        SelectorItemCollection selector = new SelectorItemCollection();
        if (formulaCalcContext.containsKey("rptautoweave_isfromui")) {
            selector.add("dispatchPeriod");
        } else {
            selector.add("dataUpdateType");
            formulaCalcContext.setCurrentCurrency(formulaCalcContext.getDispatchCurrency());
        }
        selector.add("currentCurrency");
        selector.add("exeYear");
        selector.add("exePeriod");
        FormulaCalcContextFactory.getLocalInstance(this.dao.getContext()).updatePartial(formulaCalcContext, selector);
    }

    private TemplateInfo getVersionIfExist(TemplateInfo templateInfo, FormulaCalcContextCompanyInfo companyEntity) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select t2.fid fid from t_rpt_template t2 ");
        sql.append(" inner join (");
        sql.append(" select tmp.fgroup fgroup,max(tmp.fauditedtime) fauditedtime  from t_csl_templetdispense dis ");
        sql.append(" inner join t_rpt_template tmp on tmp.fid=dis.fdispensesrcid ");
        sql.append(" where dis.fcompanyid=? and tmp.fgroup=? and tmp.fisfreezed=0 ");
        sql.append(" group by tmp.fgroup ) t1 on t1.fgroup = t2.fgroup and t1.fauditedtime=t2.fauditedtime ");
        String templateId = null;
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)this.dao.getContext(), (String)sql.toString(), (Object[])new Object[]{companyEntity.getCompany().getId().toString(), templateInfo.getGroup()});
            if (rowSet != null && rowSet.next()) {
                templateId = rowSet.getString("FID");
            }
        }
        catch (Exception e) {
            LOG.error("getVersionIfExist error", e);
            throw new BOSException((Throwable)e);
        }
        if (templateId != null) {
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add("id");
            selectors.add("number");
            selectors.add("name");
            selectors.add("periodType");
            selectors.add("templateType");
            selectors.add("data");
            selectors.add("group");
            selectors.add("groupTemplate");
            selectors.add("isFreezed");
            selectors.add("dynaRptType");
            selectors.add("sheetParam.*");
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("groupTemplate", (Object)templateId));
            filter.getFilterItems().add(new FilterItemInfo("company", (Object)companyEntity.getCompany().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("versionStatus", (Object)1));
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)templateId));
            filter.getFilterItems().add(new FilterItemInfo("isFreezed", (Object)0));
            filter.setMaskString(" (#0 and #1 and #2) or #3 and #4");
            view.setFilter(filter);
            TemplateCollection coll = TemplateFactory.getLocalInstance((Context)this.dao.getContext()).getTemplateCollection(view);
            for (int i = 0; i < coll.size(); ++i) {
                if (coll.get(i).getGroupTemplate() != null) {
                    return coll.get(i);
                }
                templateInfo = coll.get(i);
            }
            return templateInfo;
        }
        return null;
    }

    private boolean isManuStopped(FormulaCalcContextInfo formulaCalcContext) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("context", (Object)formulaCalcContext.getId().toString());
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)6));
        return FormulaCalcLogFactory.getLocalInstance(this.dao.getContext()).exists(filter);
    }

    private IObjectPK addFormulaPrcess(FormulaCalcContextInfo formulaCalcContext, int total) throws EASBizException, BOSException {
        FormulaProcessInfo formulaProcessInfo = new FormulaProcessInfo();
        formulaProcessInfo.setTotalNum(total);
        formulaProcessInfo.setFinishedNum(0);
        formulaProcessInfo.setContext(formulaCalcContext);
        return FormulaProcessFactory.getLocalInstance(this.dao.getContext()).addnew(formulaProcessInfo);
    }

    private void updateFormulaPrcess(FormulaCalcContextInfo formulaCalcContext, int finishedNum) throws BOSException, EASBizException {
        SelectorItemCollection updateselector = new SelectorItemCollection();
        updateselector.add("id");
        updateselector.add("finishedNum");
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection querySelector = new SelectorItemCollection();
        querySelector.add("id");
        querySelector.add("context");
        FilterInfo filter = new FilterInfo();
        FilterItemCollection col = filter.getFilterItems();
        col.add(new FilterItemInfo("context", (Object)formulaCalcContext.getId()));
        view.setFilter(filter);
        FormulaProcessCollection formulaProcessCollection = FormulaProcessFactory.getLocalInstance(this.dao.getContext()).getFormulaProcessCollection(view);
        FormulaProcessInfo formulaProcessInfo = formulaProcessCollection.get(0);
        if (formulaProcessInfo != null) {
            formulaProcessInfo.setFinishedNum(finishedNum);
            FormulaProcessFactory.getLocalInstance(this.dao.getContext()).updatePartial(formulaProcessInfo, updateselector);
        }
    }

    private void checkParamComplete(FormulaCalcContextInfo formulaCalcContext) throws BOSException, EASBizException {
        new CheckAndSupplyFormulaCalcContext(this.dao).exec(formulaCalcContext);
    }

    private void calculate(FormulaCalcContextInfo formulaCalcContext, TemplateInfo template, FormulaCalcContextCompanyInfo companyEntity, AutoItemLog reportLog) throws EASBizException, BOSException {
        LOG.error("[record]start_calculate");
        try {
            TemplateInfo curTemplate = this.getVersionIfExist(template, companyEntity);
            if (curTemplate == null) {
                throw new CheckFormulaException(CheckFormulaException.NOTEXISTTEMP);
            }
            AutoItemBusinessFacadeFactory.getLocalInstance(this.dao.getContext()).addAndCalcRpt(formulaCalcContext, curTemplate, companyEntity, reportLog);
        }
        catch (Exception e) {
            LOG.error("calculate error", e);
            reportLog.fail(template, (OrgUnitInfo)companyEntity.getCompany(), e.getCause() != null ? e.getCause().getMessage() : e.getMessage(), "");
        }
        LOG.error("[record]end_calculate");
    }

    public void addAndCalc(FormulaCalcContextInfo formulaCalcContext, TemplateInfo template, FormulaCalcContextCompanyInfo companyEntity, AutoItemLog reportLog) throws Exception, BOSException, EASBizException {
        RptWeaveParams schmParam = this.buildRptWeaveParams(formulaCalcContext, template, companyEntity);
        ArrayList<AbstractRptWeaveExecute> execList = new ArrayList<AbstractRptWeaveExecute>();
        execList.add(new RptWeaveExecAddNew(schmParam, this.dao.getContext()));
        execList.add(new RptWeaveExecCalc(schmParam, this.dao.getContext()));
        for (Object e : execList) {
            AbstractRptWeaveExecute rptWeaveExecute = (AbstractRptWeaveExecute)e;
            rptWeaveExecute.execute();
            String successMeg = "";
            if (rptWeaveExecute instanceof RptWeaveExecCalc) {
                successMeg = ResourceDebugUtil.res("FormulaCalcSuccessed", this.dao.getContext().getOriginLocale());
            }
            reportLog.success(template, (OrgUnitInfo)companyEntity.getCompany(), successMeg, "");
        }
        RptWeaveExecParams execParam = (RptWeaveExecParams)schmParam.getObject("rpt_weave_execparams");
        if (execParam != null && !StringUtils.isEmpty((String)execParam.getCslrptId())) {
            this.updateRptSourceType(execParam.getCslrptId());
        }
    }

    private void isTemplateDispensed(TemplateInfo template, FormulaCalcContextCompanyInfo companyEntity) throws EASBizException, BOSException {
        FilterInfo filterTemplateFID = new FilterInfo();
        filterTemplateFID.getFilterItems().add(new FilterItemInfo("dispenseSrcID", (Object)template.getId().toString(), CompareType.EQUALS));
        if (template.getGroupTemplate() != null) {
            FilterInfo filterGroupTemplateID = new FilterInfo();
            filterGroupTemplateID.getFilterItems().add(new FilterItemInfo("dispenseSrcID", (Object)template.getGroupTemplate().getId().toString(), CompareType.EQUALS));
            filterTemplateFID.mergeFilter(filterGroupTemplateID, "OR");
        }
        FilterInfo orgFilter = new FilterInfo();
        orgFilter.getFilterItems().add(new FilterItemInfo("company", (Object)companyEntity.getCompany().getId().toString(), CompareType.EQUALS));
        filterTemplateFID.mergeFilter(orgFilter, "AND");
        boolean existDispensed = TempletDispenseFactory.getLocalInstance(this.dao.getContext()).exists(filterTemplateFID);
        if (!existDispensed) {
            throw new CheckFormulaException(CheckFormulaException.NOTEXISTTEMP);
        }
    }

    private void deleteReportAndCslrpt(FormulaCalcContextInfo formulaCalcContext, FormulaCalcContextTemplateCollection templates, FormulaCalcContextCompanyCollection savedCompanys) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection rptSelector = new SelectorItemCollection();
        rptSelector.add("id");
        FilterInfo filter = new FilterInfo();
        FilterItemCollection col = filter.getFilterItems();
        col.add(new FilterItemInfo("cslReport.FormulaCalc", (Object)formulaCalcContext.getId().toString()));
        col.add(new FilterItemInfo("year", (Object)formulaCalcContext.getYear()));
        col.add(new FilterItemInfo("period", (Object)formulaCalcContext.getPeriod()));
        col.add(new FilterItemInfo("currency", (Object)formulaCalcContext.getCurrentCurrency().getId().toString()));
        col.add(new FilterItemInfo("cslReport.sourceType", (Object)100));
        if (formulaCalcContext.getDataUpdateType().equals((Object)SingleDataUpdateWayEnum.ADD)) {
            Set<String> tmpGroups = this.getTmpGroupSet(templates);
            Set<String> orgIds = this.getOrgIDSet(savedCompanys);
            col.add(new FilterItemInfo("template.group", tmpGroups, CompareType.INCLUDE));
            col.add(new FilterItemInfo("company", orgIds, CompareType.INCLUDE));
        }
        view.setFilter(filter);
        ReportCollection reportCol = ReportFactory.getLocalInstance((Context)this.dao.getContext()).getReportCollection(view);
        int size = reportCol.size();
        for (int i = 0; i < size; ++i) {
            ReportInfo reportInfo = reportCol.get(i);
            ReportFactory.getLocalInstance((Context)this.dao.getContext()).delete((IObjectPK)new ObjectUuidPK(reportInfo.getId()));
        }
    }

    private Set<String> getOrgIDSet(FormulaCalcContextCompanyCollection savedCompanys) {
        HashSet<String> orgIds = new HashSet<String>();
        int orgSize = savedCompanys.size();
        for (int i = 0; i < orgSize; ++i) {
            FormulaCalcContextCompanyInfo companyEntity = savedCompanys.get(i);
            orgIds.add(companyEntity.getCompany().getId().toString());
        }
        return orgIds;
    }

    private Set<String> getTmpGroupSet(FormulaCalcContextTemplateCollection templates) {
        HashSet<String> tmpGroups = new HashSet<String>();
        int templateSize = templates.size();
        for (int i = 0; i < templateSize; ++i) {
            TemplateInfo template = templates.get(i).getTemplate();
            tmpGroups.add(template.getGroup());
        }
        return tmpGroups;
    }

    private void updateRptSourceType(String cslrptId) throws BOSException, EASBizException {
        Connection cn = null;
        Statement st = null;
        try {
            ReportInfo report = ReportFactory.getLocalInstance((Context)this.dao.getContext()).getReportInfo("select cslReport.id where id='" + cslrptId + "'");
            cslrptId = report.getCslReport().getId().toString();
            cn = EJBFactory.getConnection((Context)this.dao.getContext());
            st = cn.createStatement();
            StringBuffer sql = new StringBuffer();
            sql.append("update t_rpt_report set fsourcetype = '").append(100).append("' where fcslReportid='").append(cslrptId).append("'");
            st.addBatch(sql.toString());
            sql.append("update t_csl_cslreport set fsourcetype = '").append(100).append("' where fid='").append(cslrptId).append("'");
            st.addBatch(sql.toString());
            sql.setLength(0);
            sql.append("update t_csl_itemdata set fdatasource = '").append(100).append("' where freportid='").append(cslrptId).append("'");
            st.addBatch(sql.toString());
            sql.setLength(0);
            sql.append("update t_csl_itemdataentry set fdatasource = '").append(100).append("' where freportid='").append(cslrptId).append("'");
            st.addBatch(sql.toString());
            sql.setLength(0);
            sql.append("update t_csl_dynaitemdata set fdatasource = '").append(100).append("' where freportid='").append(cslrptId).append("'");
            st.addBatch(sql.toString());
            st.executeBatch();
            st.clearBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(null, st, cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(null, (Statement)st, (Connection)cn);
    }

    private void addFormulaCalcToCsl(FormulaCalcContextInfo formulaCalcContext, RptWeaveParams schmParam) throws BOSException, EASBizException {
        SelectorItemCollection updateselector = new SelectorItemCollection();
        updateselector.add("id");
        updateselector.add("FormulaCalc");
        CslReportInfo cslReportInfo = new CslReportInfo();
        RptWeaveExecParams execParam = (RptWeaveExecParams)schmParam.getObject("rpt_weave_execparams");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection col = filter.getFilterItems();
        col.add(new FilterItemInfo("id", (Object)BOSUuid.read((String)execParam.getCslrptId())));
        view.setFilter(filter);
        ReportCollection reportCol = ReportFactory.getLocalInstance((Context)this.dao.getContext()).getReportCollection(view);
        ReportInfo reportInfo = reportCol.get(0);
        cslReportInfo = reportInfo.getCslReport();
        if (cslReportInfo != null) {
            cslReportInfo.setFormulaCalc(formulaCalcContext);
            CslReportFactory.getLocalInstance(this.dao.getContext()).updatePartial((CoreBaseInfo)cslReportInfo, updateselector);
        }
    }

    private AutoItemLog prepareLog(FormulaCalcContextInfo formulaCalcContext, String executeTaskId) throws BOSException {
        ILogThread logThread = ActionFactory.get(LogThread.class);
        logThread.start();
        AutoItemLog reportLog = new AutoItemLog(this.dao, formulaCalcContext, executeTaskId, logThread);
        return reportLog;
    }

    private void isContextExe(AutoItemLog reportLog) throws BOSException, EASBizException, AutoItemException {
        if (reportLog.existLogStatus(new FormulaCalcLogStatus[]{FormulaCalcLogStatus.READY, FormulaCalcLogStatus.PROCESSING}, true)) {
            throw new AutoItemException(AutoItemException.CHECKDUPLICATED);
        }
    }

    private RptWeaveParams buildRptWeaveParams(FormulaCalcContextInfo formulaCalcContext, TemplateInfo template, FormulaCalcContextCompanyInfo companyEntity) {
        RptWeaveParams schmParam = new RptWeaveParams();
        schmParam.setObject("KEY_TEMPLATE", template);
        schmParam.setObject("KEY_COMPANY", companyEntity.getCompany());
        schmParam.setObject("currency", formulaCalcContext.getCurrentCurrency());
        schmParam.setInt("Period", formulaCalcContext.getPeriod());
        schmParam.setInt("Year", formulaCalcContext.getYear());
        RptAutoWeaveSchmRptInfo schmRptInfo = new RptAutoWeaveSchmRptInfo();
        schmRptInfo.setCurrency(formulaCalcContext.getCurrentCurrency());
        schmParam.setObject("rpt_weave_rptSchmObj", schmRptInfo);
        RptWeaveExecParams execParam = new RptWeaveExecParams();
        execParam.setUserId(formulaCalcContext.getLastUpdateUser().getId().toString());
        schmParam.setObject("rpt_weave_execparams", execParam);
        schmParam.setBoolean("rptautoweave_isfromgeextractdataf", true);
        schmParam.setObject("rptautoweave_extractdatafid", formulaCalcContext);
        return schmParam;
    }
}

