/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.GetBookFormulaFromCsRef;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.IFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.BizFormulaDefine;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.ActionFactory;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.StringFormulaParser;
import java.util.List;

public class ConvertRefFormula {
    private DBHandler dao;
    private boolean onlyFindItemFormula;

    public ConvertRefFormula(DBHandler dao, boolean onlyFindItemFormula) {
        this.dao = dao;
        this.onlyFindItemFormula = onlyFindItemFormula;
    }

    public boolean isMeet(IFormula formula) {
        if (formula == null) {
            return false;
        }
        List<IFormula> csrefs = formula.getFormula("CSREF");
        return !csrefs.isEmpty();
    }

    public IFormula exec(IFormula formula) throws EASBizException, BOSException {
        while (this.isMeet(formula)) {
            formula = this.getBookFormula(formula);
        }
        return formula;
    }

    public boolean isMeet(String formulaStr) {
        StringFormulaParser stringFormulaParser = ActionFactory.get(StringFormulaParser.class);
        stringFormulaParser.setFormulaDefine(ActionFactory.get(BizFormulaDefine.class));
        IFormula formula = stringFormulaParser.parse(formulaStr);
        return this.isMeet(formula);
    }

    public IFormula exec(String formulaStr) throws EASBizException, BOSException {
        StringFormulaParser stringFormulaParser = ActionFactory.get(StringFormulaParser.class);
        stringFormulaParser.setFormulaDefine(ActionFactory.get(BizFormulaDefine.class));
        IFormula formula = stringFormulaParser.parse(formulaStr);
        return this.exec(formula);
    }

    private IFormula getBookFormula(IFormula formula) throws EASBizException, BOSException {
        List<IFormula> csrefs = formula.getFormula("CSREF");
        if (!csrefs.isEmpty()) {
            GetBookFormulaFromCsRef getBookFormulaFromCsRef = new GetBookFormulaFromCsRef(this.dao, this.onlyFindItemFormula);
            IFormula replacedFormula = null;
            BizFormulaDefine bizFormulaDefine = new BizFormulaDefine();
            for (IFormula csref : csrefs) {
                bizFormulaDefine.fillWhole(csref);
                replacedFormula = getBookFormulaFromCsRef.exec(csref);
                if (replacedFormula == null) continue;
                formula.replace(csref, replacedFormula);
            }
            return getBookFormulaFromCsRef.exec(formula);
        }
        return null;
    }
}

