/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc;

import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextInfo;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.ContextKey;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.SheetParam;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.ItemContext;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.StringUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;

public class FormulaCalcContextCell {
    protected ItemContext itemContext;
    protected SheetParam sheetParam;

    public FormulaCalcContextCell(FormulaCalcContextInfo define, CompanyOrgUnitInfo company, RptSheetParamInfo sheetParam) {
        if (define != null) {
            this.updateItemContext(define, (OrgUnitInfo)company);
        }
        this.sheetParam = sheetParam == null ? (SheetParam)SheetParam.DEFAULT.clone() : new SheetParam(sheetParam);
    }

    public FormulaCalcContextCell(ItemContext itemContext, RptSheetParamInfo sheetParam) {
        this.itemContext = itemContext;
        this.sheetParam = sheetParam == null ? (SheetParam)SheetParam.DEFAULT.clone() : new SheetParam(sheetParam);
    }

    protected void updateItemContext(FormulaCalcContextInfo define, OrgUnitInfo company) {
        if (define == null) {
            return;
        }
        if (this.itemContext == null) {
            this.itemContext = new ItemContext(company, define.getCurrentCurrency(), define.getPeriodType(), define.getYear(), define.getPeriod());
        } else {
            if (company != null) {
                this.itemContext.setCompany(company);
            }
            this.itemContext.setCurrency(define.getCurrentCurrency());
            this.itemContext.setPeriodType(define.getPeriodType());
            this.itemContext.setYear(define.getYear());
            this.itemContext.setPeriod(define.getPeriod());
        }
    }

    public ContextKey getContextKey() {
        return new ContextKey(this.itemContext.getCompany(), this.itemContext.getCurrency(), this.itemContext.getYear(), this.itemContext.getPeriod(), this.itemContext.getPeriodType());
    }

    public String getSheetParam() {
        return this.sheetParam.serialString();
    }

    public void setDefine(FormulaCalcContextInfo define, OrgUnitInfo company) {
        this.updateItemContext(define, company);
    }

    public void setSheetParam(RptSheetParamInfo sheetParam) {
        this.sheetParam = new SheetParam(sheetParam);
    }

    public OrgUnitInfo getCompany() {
        return this.itemContext.getCompany();
    }

    public String toString() {
        return StringUtil.toStringByReflect(this);
    }

    public CurrencyInfo getCurrency() {
        if (this.itemContext == null) {
            return null;
        }
        return this.itemContext.getCurrency();
    }

    public RptPeriodTypeEnum getPeriodType() {
        if (this.itemContext == null) {
            return null;
        }
        return this.itemContext.getPeriodType();
    }
}

