/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.CalcContext;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.SheetParam;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import java.util.HashSet;

public class GetCalcContextFromReport {
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", GetCalcContextFromReport.class);

    public CalcContext exec(ReportInfo report) {
        Book book;
        CurrencyInfo currency = report.getCurrency();
        FullOrgUnitInfo company = report.getCompany();
        HashSet<SheetParam> sheetParams = new HashSet<SheetParam>(0);
        try {
            book = report.getBook();
        }
        catch (Exception e) {
            LOG.error("", e);
            return null;
        }
        ReportVariables reportVariables = (ReportVariables)book.getUserObjectValue("VARIABLES");
        SheetParam sheetParam = null;
        for (int i = 0; i < book.getSheetCount(); ++i) {
            if (reportVariables == null) {
                sheetParam = this.defaultSheetParam(book.getSheetName(i), book.getSheet(i));
                continue;
            }
            sheetParam = new SheetParam(book.getSheetName(i), reportVariables);
            sheetParams.add(sheetParam);
        }
        return new CalcContext((OrgUnitInfo)company, (ReportBaseInfo)report, currency, sheetParams);
    }

    protected SheetParam defaultSheetParam(String sheetName, Sheet sheet) {
        return new SheetParam(sheetName, false, false, false, false, false, false);
    }
}

