/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.log;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextInfo;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcLogInfo;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcLogStatus;
import com.kingdee.eas.fi.gr.cslrpt.IFormulaCalcLog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.log.IBatchLogTask;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class FailLogTask
implements IBatchLogTask<FailLogTask> {
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", FailLogTask.class);
    private String executeTaskId;
    private FormulaCalcContextInfo calcContext;
    private TemplateInfo template;
    private OrgUnitInfo company;
    private String errorDetail;
    private String itemKey;
    private IFormulaCalcLog formulaCalcLogDao;
    private FormulaCalcLogInfo failLogInfo = new FormulaCalcLogInfo();
    private List<FailLogTask> batchTasks = new ArrayList<FailLogTask>(10);

    @Override
    public void run() {
        this.failLogInfo.setId(BOSUuid.create((BOSObjectType)this.failLogInfo.getBOSType()));
        this.failLogInfo.setExecuteTaskId(this.executeTaskId);
        this.failLogInfo.setContext(this.calcContext);
        this.failLogInfo.setTemplate(this.template);
        if (this.company != null) {
            this.failLogInfo.setCompany(this.company.castToFullOrgUnitInfo());
        } else {
            this.failLogInfo.setCompany(null);
        }
        this.failLogInfo.setStatus(FormulaCalcLogStatus.FAILURE);
        if (this.errorDetail == null) {
            return;
        }
        if (this.errorDetail.length() > 255) {
            this.failLogInfo.setDescription(this.errorDetail.substring(0, 255));
        } else {
            this.failLogInfo.setDescription(this.errorDetail);
        }
        this.failLogInfo.setItemKey(this.itemKey);
    }

    public void setParams(String executeTaskId, FormulaCalcContextInfo calcContext, TemplateInfo template, OrgUnitInfo company, String errorDetail, String itemKey, IFormulaCalcLog formulaCalcLogDao) {
        this.executeTaskId = executeTaskId;
        this.calcContext = calcContext;
        this.template = template;
        this.company = company;
        this.errorDetail = errorDetail;
        this.itemKey = itemKey;
        this.formulaCalcLogDao = formulaCalcLogDao;
    }

    @Override
    public void batchRun() {
        CoreBaseCollection infos = new CoreBaseCollection();
        FormulaCalcLogInfo info = null;
        HashSet<String> excludeDup = new HashSet<String>(this.batchTasks.size());
        TemplateInfo templateInfo = null;
        FullOrgUnitInfo companyInfo = null;
        for (FailLogTask log : this.batchTasks) {
            log.run();
            info = log.getFailLogInfo();
            templateInfo = info.getTemplate();
            companyInfo = info.getCompany();
            if (templateInfo == null) {
                templateInfo = log.template;
            }
            if (companyInfo == null) {
                companyInfo = log.company;
            }
            if (excludeDup.contains(companyInfo.getId().toString() + "," + templateInfo.getId().toString() + "," + info.getItemKey())) continue;
            excludeDup.add(templateInfo.getId().toString() + "," + templateInfo.getId().toString() + "," + info.getItemKey());
            infos.add((CoreBaseInfo)info);
        }
        try {
            this.formulaCalcLogDao.addnewBatchData(infos);
        }
        catch (EASBizException e) {
            LOG.error("", e);
        }
        catch (BOSException e) {
            LOG.error("", e);
        }
    }

    public FormulaCalcLogInfo getFailLogInfo() {
        return this.failLogInfo;
    }

    @Override
    public void addBatchTask(FailLogTask task) {
        this.batchTasks.add(task);
    }
}

