/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.log;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextInfo;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcLogInfo;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcLogStatus;
import com.kingdee.eas.fi.gr.cslrpt.IFormulaCalcLog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.log.IsAnyExecuteTask;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.log.thread.ILogTask;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import java.sql.Timestamp;
import java.util.HashSet;

public class FinishLogTask
implements ILogTask {
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", FinishLogTask.class);
    private String executeTaskId;
    private FormulaCalcContextInfo calcContext;
    private String discreption;
    private IFormulaCalcLog formulaCalcLogDao;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        FilterInfo filter = new FilterInfo();
        if (!IsAnyExecuteTask.exec(this.executeTaskId)) {
            filter.appendFilterItem("executeTaskId", (Object)this.executeTaskId);
        }
        filter.appendFilterItem("context", (Object)this.calcContext.getId().toString());
        HashSet<Integer> unnormalStatus = new HashSet<Integer>(2);
        unnormalStatus.add(0);
        unnormalStatus.add(1);
        unnormalStatus.add(4);
        filter.getFilterItems().add(new FilterItemInfo("status", unnormalStatus, CompareType.INCLUDE));
        try {
            IObjectPK[] readyLogPKs = this.formulaCalcLogDao.getPKList(filter, null);
            if (readyLogPKs.length == 0) {
                LOG.error("when update finish status,report log with ready status or process status or finish status not be found!({0})", new Object[]{this.calcContext});
                FormulaCalcLogInfo finishLogInfo = new FormulaCalcLogInfo();
                finishLogInfo.setExecuteTaskId(this.executeTaskId);
                finishLogInfo.setContext(this.calcContext);
                finishLogInfo.setStatus(FormulaCalcLogStatus.FINISH);
                finishLogInfo.setDescription(this.discreption);
                finishLogInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
                this.formulaCalcLogDao.addnew(finishLogInfo);
                return;
            }
            FormulaCalcLogInfo processLogInfo = new FormulaCalcLogInfo();
            processLogInfo.setId(BOSUuid.read((String)readyLogPKs[0].toString()));
            processLogInfo.setStatus(FormulaCalcLogStatus.FINISH);
            processLogInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
            processLogInfo.setDescription(this.discreption);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("status");
            selector.add("lastUpdateTime");
            selector.add("description");
            this.formulaCalcLogDao.updatePartial(processLogInfo, selector);
        }
        catch (EASBizException e) {
            LOG.error("", e);
            return;
        }
        catch (BOSException e) {
            LOG.error("", e);
            return;
        }
        finally {
            LOG.error("finish log task");
        }
    }

    public void setParams(String executeTaskId, FormulaCalcContextInfo calcContext, IFormulaCalcLog formulaCalcLogDao) {
        this.executeTaskId = executeTaskId;
        this.calcContext = calcContext;
        this.formulaCalcLogDao = formulaCalcLogDao;
    }

    public void setParams(String executeTaskId, FormulaCalcContextInfo calcContext, IFormulaCalcLog formulaCalcLogDao, String description) {
        this.executeTaskId = executeTaskId;
        this.calcContext = calcContext;
        this.formulaCalcLogDao = formulaCalcLogDao;
        this.discreption = description;
    }
}

