/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.log;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextInfo;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcLogInfo;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcLogStatus;
import com.kingdee.eas.fi.gr.cslrpt.IFormulaCalcLog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.log.IsAnyExecuteTask;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.log.thread.ILogTask;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.FileUtil;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Uuid;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;

public class ProcessingLogTask
implements ILogTask {
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", ProcessingLogTask.class);
    private String executeTaskId;
    private FormulaCalcContextInfo calcContext;
    private int templateLevelPartSize;
    private int templatePreLevelPart;
    private int templateLevelSize;
    private Uuid currentCalcFlag;
    private Uuid previousCalcFlag;
    private IFormulaCalcLog formulaCalcLogDao;
    private DBHandler dao;

    @Override
    public void run() {
        IObjectPK[] readyLogPKs;
        FilterInfo filter = new FilterInfo();
        boolean isAnyExecuteTask = IsAnyExecuteTask.exec(this.executeTaskId);
        if (!isAnyExecuteTask) {
            filter.appendFilterItem("executeTaskId", (Object)this.executeTaskId);
        }
        filter.appendFilterItem("context", (Object)this.calcContext.getId().toString());
        filter.appendFilterItem("status", (Object)0);
        filter.appendFilterItem("status", (Object)1);
        if (!isAnyExecuteTask) {
            filter.setMaskString(" #0 and #1 and (#2 or #3) ");
        } else {
            filter.setMaskString("#0 and (#1 or #2) ");
        }
        try {
            readyLogPKs = this.formulaCalcLogDao.getPKList(filter, null);
        }
        catch (EASBizException e) {
            LOG.error("", e);
            return;
        }
        catch (BOSException e) {
            LOG.error("", e);
            return;
        }
        if (readyLogPKs.length == 0) {
            LOG.error("report log with ready status not be found!({0})", new Object[]{this.calcContext});
            return;
        }
        FormulaCalcLogInfo processLogInfo = new FormulaCalcLogInfo();
        processLogInfo.setId(BOSUuid.read((String)readyLogPKs[0].toString()));
        processLogInfo.setStatus(FormulaCalcLogStatus.PROCESSING);
        int calcUnitCountBeforeThis = 0;
        try {
            calcUnitCountBeforeThis = this.queryCalcUnitSize(this.previousCalcFlag);
        }
        catch (BOSException e) {
            LOG.error("", e);
            return;
        }
        processLogInfo.setDescription(this.buildDescription(this.templateLevelPartSize, this.templatePreLevelPart, this.templateLevelSize, calcUnitCountBeforeThis, this.currentCalcFlag));
        processLogInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("status");
        selector.add("description");
        selector.add("lastUpdateTime");
        try {
            this.formulaCalcLogDao.updatePartial(processLogInfo, selector);
        }
        catch (EASBizException e) {
            LOG.error("", e);
            return;
        }
        catch (BOSException e) {
            LOG.error("", e);
            return;
        }
    }

    private int queryCalcUnitSize(Uuid currentCalcFlag) throws BOSException {
        if (currentCalcFlag == null) {
            return 0;
        }
        String queryCurrentCalcRecordSizeSql = FileUtil.readContent("com/kingdee/eas/fi/gr/cslrpt/autoitem/biz/log/queryCurrentCalcRecordSize.sql");
        IRowSet calcUnitSize = this.dao.getExecuteSQL().executeQuery(queryCurrentCalcRecordSizeSql, new Object[]{currentCalcFlag.toString()});
        try {
            if (calcUnitSize.next()) {
                return calcUnitSize.getInt("record_size");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return 0;
    }

    private String buildDescription(int templateLevelPartSize, int templatePreLevelPart, int templateLevelSize, int calcUnitCountBeforeThis, Uuid currentCalcFlag) {
        String messageFormat = "{0},{1}/{2}/{3},{4}";
        return MessageFormat.format(messageFormat, currentCalcFlag, templateLevelPartSize + "", templatePreLevelPart + "", templateLevelSize + "", calcUnitCountBeforeThis + "");
    }

    public void setParams(String executeTaskId, FormulaCalcContextInfo calcContext, int templateLevelPartSize, int templatePreLevelPart, int templateLevelSize, Uuid currentCalcFlag, Uuid previousCalcFlag, IFormulaCalcLog formulaCalcLogDao, DBHandler dao) {
        this.executeTaskId = executeTaskId;
        this.calcContext = calcContext;
        this.templateLevelPartSize = templateLevelPartSize;
        this.templatePreLevelPart = templatePreLevelPart;
        this.templateLevelSize = templateLevelSize;
        this.currentCalcFlag = currentCalcFlag;
        this.previousCalcFlag = previousCalcFlag;
        this.formulaCalcLogDao = formulaCalcLogDao;
        this.dao = dao;
    }
}

