/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.log.thread;

import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.log.IBatchLogTask;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.log.thread.ILogTask;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.log.thread.ILogThread;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class LogThread
implements ILogThread {
    private List<ILogTask> tasks = new ArrayList<ILogTask>(8);
    private Set<IBatchLogTask<?>> lazyTasks = new HashSet(2);
    private Set<Class<?>> batchTypes = new HashSet(2);
    private Thread thread;

    public LogThread() {
        this.newThread();
    }

    private void newThread() {
        this.thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ILogTask task = null;
                int circleShortNum = 0;
                while (true) {
                    List list = LogThread.this.tasks;
                    synchronized (list) {
                        Iterator it = LogThread.this.tasks.iterator();
                        while (it.hasNext()) {
                            task = (ILogTask)it.next();
                            try {
                                task.run();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            it.remove();
                        }
                        if (++circleShortNum > 3) {
                            try {
                                LogThread.this.tasks.wait();
                                circleShortNum = 0;
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            }
        }, "AutoItem's LogThread");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addList(ILogTask logTask) {
        List<ILogTask> list = this.tasks;
        synchronized (list) {
            this.tasks.add(logTask);
            this.tasks.notifyAll();
        }
    }

    @Override
    public void end() {
        this.batchTypes.clear();
        this.lazyTasks.clear();
    }

    @Override
    public void start() {
        if (!this.thread.isAlive()) {
            this.thread.setDaemon(false);
            this.thread.start();
        }
    }

    @Override
    public <T extends ILogTask> void addForBatch(IBatchLogTask<T> task) {
        if (!this.batchTypes.contains(task.getClass())) {
            task.addBatchTask(task);
            this.lazyTasks.add(task);
            this.batchTypes.add(task.getClass());
            return;
        }
        for (IBatchLogTask<?> batch : this.lazyTasks) {
            if (!batch.getClass().equals(task.getClass())) continue;
            batch.addBatchTask(task);
        }
    }

    @Override
    public void execBatch() {
        Iterator<IBatchLogTask<?>> it = this.lazyTasks.iterator();
        while (it.hasNext()) {
            IBatchLogTask<?> batch = it.next();
            batch.batchRun();
            it.remove();
        }
    }
}

