/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.parser;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.DynFormulaDefineInfo;
import com.kingdee.eas.fi.gr.cslrpt.FormulaSchemeCollection;
import com.kingdee.eas.fi.gr.cslrpt.FormulaSchemeInfo;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.assist.CreateFormulaScheme;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.CheckWheatheFilled;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.IBasePoint;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.IFindFormulaScheme;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.basepoint.EliminationBasePoint;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.basepoint.IsEliminationBasePoint;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.IFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.parser.FindNormalScheme;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.GetEliminationAsstNum;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.GetEliminationItemKey;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.ActionFactory;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.CellUtil;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.NextCell;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;

public class FindEliminationScheme
implements IFindFormulaScheme {
    private static final ILog log = LogFactory.getLog("AUTOITEM", FindEliminationScheme.class);
    private DBHandler dao;

    public FindEliminationScheme(DBHandler dao) {
        this.dao = dao;
    }

    @Override
    public boolean isMeet(IBasePoint basePoint) {
        return ActionFactory.get(IsEliminationBasePoint.class).is(basePoint);
    }

    @Override
    public FormulaSchemeCollection parse(IBasePoint eliminationBasePoint) {
        EliminationBasePoint basePoint = (EliminationBasePoint)eliminationBasePoint;
        FormulaSchemeCollection schemes = new FormulaSchemeCollection();
        int[] pos = new int[]{basePoint.getRow(), basePoint.getCol()};
        int spreadStyle = 0;
        Sheet sheet = basePoint.getSheet();
        Cell cell = null;
        Cell valueFormulaCell = null;
        int[] valueFormulaPos = null;
        ItemFormula itemFormula = null;
        ItemFormula valueItemFormula = null;
        NextCell nextCell = ActionFactory.get(NextCell.class);
        while ((cell = sheet.getCell((pos = nextCell.circle(pos, spreadStyle, true))[0], pos[1], false)) != null && (itemFormula = CellUtil.getItemFormula(cell)) != null && itemFormula.getFormula() != null) {
            log.info("find a cell with item formula({0})", new Object[]{itemFormula.getFormula()});
            valueFormulaPos = nextCell.circle(pos, spreadStyle, false);
            valueFormulaCell = sheet.getCell(valueFormulaPos[0], valueFormulaPos[1], false);
            if (valueFormulaCell == null) {
                log.info("value formula({0}) not be found under item formula cell({1})({2})", new Object[]{valueFormulaPos, itemFormula, pos});
                continue;
            }
            int[] fillMaxPos = new int[2];
            if (new CheckWheatheFilled().isFilled(valueFormulaCell, spreadStyle, Integer.MAX_VALUE, fillMaxPos)) {
                FormulaSchemeCollection normalSchemes = new FindNormalScheme(this.dao).parse(sheet, new int[]{valueFormulaCell.getRow(), valueFormulaCell.getCol()}, fillMaxPos, basePoint);
                log.info("find filled schemes ({0}) in dynamice base fill parse", new Object[]{normalSchemes});
                schemes.addCollection(normalSchemes);
                continue;
            }
            valueItemFormula = CellUtil.getItemFormula(valueFormulaCell);
            if (valueItemFormula != null) continue;
            if (valueFormulaCell.getFormula() == null || "".equals(valueFormulaCell.getFormula()) || !valueFormulaCell.getFormula().toUpperCase().startsWith("=ACCTAC")) {
                log.info("value formula({0}) not be found under item formula cell({1})({2})", new Object[]{valueFormulaPos, itemFormula, pos});
                continue;
            }
            FormulaSchemeInfo scheme = this.create(valueFormulaCell, itemFormula, basePoint.getEnvParam());
            if (scheme == null) continue;
            log.info("find a scheme:{0}", new Object[]{scheme});
            scheme.setEnvParam(basePoint.getEnvParam());
            schemes.add(scheme);
        }
        return schemes;
    }

    private FormulaSchemeInfo create(Cell cell, ItemFormula itemFormula, RptSheetParamInfo sheetParam) {
        FormulaSchemeInfo scheme;
        try {
            scheme = new CreateFormulaScheme(this.dao).by(cell, itemFormula);
        }
        catch (EASBizException e) {
            log.error("", e);
            return null;
        }
        catch (BOSException e) {
            log.error("", e);
            return null;
        }
        DynFormulaDefineInfo dynDefineInfo = new DynFormulaDefineInfo();
        dynDefineInfo.setFormulaScheme(scheme);
        dynDefineInfo.setIsLevelManualSum(false);
        dynDefineInfo.setIsLevelSum(false);
        scheme.getDynFormulaDefine().add(dynDefineInfo);
        String itemKey = "ITEM";
        itemKey = new GetEliminationItemKey().exec(sheetParam.getReportClass());
        String asstNum = new GetEliminationAsstNum().exec(itemKey);
        scheme.setItemKey(itemKey);
        IFormula newFormula = scheme.getItemFormula();
        newFormula.setName(itemKey);
        newFormula.getParams().add(1, "");
        dynDefineInfo.setAssistNum(asstNum);
        dynDefineInfo.setAssistName(ActionFactory.get(GetEliminationAsstNum.class).name(itemKey));
        return scheme;
    }
}

