/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.parser;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.FormulaSchemeCollection;
import com.kingdee.eas.fi.gr.cslrpt.FormulaSchemeInfo;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.assist.CircleBookCell;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.assist.CreateFormulaScheme;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.assist.ICircleBookCellHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.IBasePoint;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.IFindFormulaScheme;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.basepoint.IsNormalBasePoint;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.basepoint.NormalBasePoint;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.ActionFactory;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;

public class FindNormalScheme
implements IFindFormulaScheme {
    private static final ILog log = LogFactory.getLog("AUTOITEM", FindNormalScheme.class);
    private DBHandler dao;

    public FindNormalScheme(DBHandler dao) {
        this.dao = dao;
    }

    @Override
    public boolean isMeet(IBasePoint basePoint) {
        return ActionFactory.get(IsNormalBasePoint.class).is(basePoint);
    }

    public FormulaSchemeCollection parse(Sheet sheet, int[] startPos, int[] endPos, final IBasePoint basePoint) {
        final FormulaSchemeCollection schemes = new FormulaSchemeCollection();
        new CircleBookCell().circle(sheet, startPos, endPos, new ICircleBookCellHandler(){

            @Override
            public int cell(Book book, Sheet sheet, Cell cell) {
                if (cell.getSheet() == null) {
                    return 0;
                }
                Object itemFormula = cell.getUserObjectValue("ITEM");
                if (!(itemFormula instanceof ItemFormula)) {
                    return 0;
                }
                FormulaSchemeInfo scheme = FindNormalScheme.this.create(cell, itemFormula);
                if (scheme == null) {
                    return 0;
                }
                scheme.setEnvParam(basePoint.getEnvParam());
                schemes.add(scheme);
                return 0;
            }
        });
        return schemes;
    }

    @Override
    public FormulaSchemeCollection parse(IBasePoint basePoint) {
        NormalBasePoint normalBasePoint = (NormalBasePoint)basePoint;
        if (normalBasePoint.getSheet() == null) {
            return new FormulaSchemeCollection();
        }
        return this.parse(normalBasePoint.getSheet(), new int[]{normalBasePoint.getStartRow(), normalBasePoint.getStartCol()}, new int[]{normalBasePoint.getEndRow(), normalBasePoint.getEndCol()}, basePoint);
    }

    protected FormulaSchemeInfo create(Cell cell, Object itemFormula) {
        FormulaSchemeInfo scheme;
        try {
            scheme = new CreateFormulaScheme(this.dao).by(cell);
        }
        catch (EASBizException e) {
            log.error("", e);
            return null;
        }
        catch (BOSException e) {
            log.error("", e);
            return null;
        }
        if (scheme == null) {
            return null;
        }
        return scheme;
    }
}

