/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.parser.refact;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.DynFormulaDefineInfo;
import com.kingdee.eas.fi.gr.cslrpt.FormulaSchemeInfo;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.assist.ConvertCellFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.assist.CreateFormulaScheme;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.assist.HandleReferExprForItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.IBasePoint;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.ConvertRefFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.FreezeCellFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.IFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.parser.refact.DynaBaseFillInfoHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.parser.refact.IImportOtherHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.parser.refact.IInfoHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.parser.refact.NormalInfoHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.CellUtil;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.StringUtil;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.eas.fi.gr.dynamic.DItemGradeEntryInfo;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class DynaArfiFillClassificInfoHandler
implements IInfoHandler<FormulaSchemeInfo>,
IImportOtherHandler<FormulaSchemeInfo> {
    private static final ILog log = LogFactory.getLog("AUTOITEM", DynaBaseFillInfoHandler.class);
    final Collection<FormulaSchemeInfo> schemes = new ArrayList<FormulaSchemeInfo>();
    private DBHandler dao;
    private IBasePoint basePoint;

    public DynaArfiFillClassificInfoHandler(DBHandler dao, IBasePoint basePoint) {
        this.dao = dao;
        this.basePoint = basePoint;
    }

    @Override
    public Collection<FormulaSchemeInfo> infos() {
        return this.schemes;
    }

    @Override
    public boolean checkItemFormula(ItemFormula itemFormula) {
        return itemFormula != null && !StringUtils.isEmpty((String)itemFormula.getFormula());
    }

    @Override
    public boolean checkValueFormula(String valueItemFormula) {
        return !StringUtils.isEmpty((String)valueItemFormula);
    }

    @Override
    public void put(ItemFormula itemFormula, String valueFormula, Cell firstValueFormulaCell, Map<?, ?> others) {
        DynaParameters dynaParam = (DynaParameters)others.get("dynaParam");
        DItemGradeEntryInfo gradeEntry = (DItemGradeEntryInfo)others.get("gradeEntry");
        Cell sumCell = (Cell)others.get("sumCell");
        int[] subSumStart = (int[])others.get("subSumStart");
        int[] subSumEnd = (int[])others.get("subSumEnd");
        FormulaSchemeInfo scheme = this.create(firstValueFormulaCell, itemFormula, dynaParam, gradeEntry);
        if (scheme != null) {
            FreezeCellFormula freezeCellFormula = new FreezeCellFormula(sumCell);
            freezeCellFormula.freeze();
            String sumFormula = this.getFormulaWithoutAsstItem(sumCell, subSumStart, subSumEnd, this.basePoint.getSheet());
            for (int i = 0; i < scheme.getDynFormulaDefine().size(); ++i) {
                scheme.getDynFormulaDefine().get(i).setSumFormula(sumFormula);
            }
            freezeCellFormula.release();
            scheme.setEnvParam(this.basePoint.getEnvParam());
            this.schemes.add(scheme);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFormulaWithoutAsstItem(Cell sumCell, int[] subSumStart, int[] subSumEnd, Sheet sheet) {
        String subSumFormula;
        String sumFormula = sumCell.getFormula();
        if (sumFormula.indexOf(subSumFormula = this.getSubSumFormula(subSumStart, subSumEnd, sheet)) >= 0) {
            if (StringUtils.isEmpty((String)(sumFormula = StringUtil.removeFormula(sumFormula, subSumFormula)))) {
                return null;
            }
            if (StringUtil.isBigDecimal(sumFormula)) {
                return "=constant(" + sumFormula + ")";
            }
            FreezeCellFormula freezeCellFormula = new FreezeCellFormula(sumCell);
            freezeCellFormula.freeze();
            try {
                IFormula valueFormulaAfter;
                sumCell.setFormula("=" + sumFormula);
                ConvertCellFormula convertCellFormula = new ConvertCellFormula();
                convertCellFormula.registerHandle(new HandleReferExprForItemFormula());
                convertCellFormula.exec(sumCell, true);
                sumFormula = CellUtil.getValueFormula(sumCell);
                ConvertRefFormula convertRefFormula = new ConvertRefFormula(this.dao, true);
                if (convertRefFormula.isMeet(sumFormula) && (valueFormulaAfter = convertRefFormula.exec(sumFormula)) != null) {
                    sumFormula = "=" + valueFormulaAfter.formulaString(true);
                }
            }
            catch (EASBizException e) {
                log.warn("", e);
            }
            catch (BOSException e) {
                log.warn("", e);
            }
            finally {
                freezeCellFormula.release();
            }
        }
        if ((sumFormula = sumFormula.trim()).startsWith("=")) {
            return sumFormula.substring(1);
        }
        return sumFormula;
    }

    private String getSubSumFormula(int[] start, int[] end, Sheet sheet) {
        return "SUM(" + CellUtil.name(start[0], start[1]) + ":" + CellUtil.name(end[0], end[1]) + ")";
    }

    private FormulaSchemeInfo create(Cell cell, ItemFormula itemFormula, DynaParameters dynaParam, DItemGradeEntryInfo gradeEntry) {
        FormulaSchemeInfo scheme;
        try {
            scheme = new CreateFormulaScheme(this.dao).by(cell, itemFormula);
        }
        catch (EASBizException e) {
            log.error("", e);
            return null;
        }
        catch (BOSException e) {
            log.error("", e);
            return null;
        }
        if (scheme == null) {
            return null;
        }
        DynFormulaDefineInfo dynDefineInfo = new DynFormulaDefineInfo();
        dynDefineInfo.setFormulaScheme(scheme);
        dynDefineInfo.setAssistNum(gradeEntry.getDetailAsstType().getProperityName());
        dynDefineInfo.setAssistName(gradeEntry.getDetailAsstType().getProperityAlias());
        dynDefineInfo.setIsLevelManualSum(true);
        dynDefineInfo.setIsLevelSum(true);
        dynDefineInfo.setLevelName(gradeEntry.getName());
        dynDefineInfo.setLevelOrderNum(gradeEntry.getNumber() + (gradeEntry.isLeaf() ? ".D" : ""));
        scheme.getDynFormulaDefine().add(dynDefineInfo);
        scheme.setDynaAsstType(gradeEntry.getDetailAsstType().getProperityName());
        return scheme;
    }

    @Override
    public IInfoHandler<FormulaSchemeInfo> other(String key) {
        if ("normal".equals(key)) {
            return new NormalInfoHandler(this.dao, this.basePoint);
        }
        return null;
    }
}

