/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.parser.refact;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.DynFormulaDefineInfo;
import com.kingdee.eas.fi.gr.cslrpt.FormulaSchemeInfo;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.assist.CreateFormulaScheme;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.IBasePoint;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.IFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.parser.refact.IImportOtherHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.parser.refact.IInfoHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.parser.refact.NormalInfoHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.GetEliminationAsstNum;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.GetEliminationItemKey;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.ActionFactory;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EliminationInfoHandler
implements IInfoHandler<FormulaSchemeInfo>,
IImportOtherHandler<FormulaSchemeInfo> {
    private static final ILog log = LogFactory.getLog("AUTOITEM", EliminationInfoHandler.class);
    final Collection<FormulaSchemeInfo> schemes = new ArrayList<FormulaSchemeInfo>();
    private DBHandler dao;
    private IBasePoint basePoint;

    public EliminationInfoHandler(DBHandler dao, IBasePoint basePoint) {
        this.dao = dao;
        this.basePoint = basePoint;
    }

    @Override
    public Collection<FormulaSchemeInfo> infos() {
        return this.schemes;
    }

    @Override
    public boolean checkItemFormula(ItemFormula itemFormula) {
        return itemFormula != null && !StringUtils.isEmpty((String)itemFormula.getFormula());
    }

    @Override
    public boolean checkValueFormula(String valueItemFormula) {
        String reg = "(?i)=acctac";
        Pattern p = Pattern.compile(reg);
        if (!StringUtils.isEmpty((String)valueItemFormula)) {
            Matcher matcher = p.matcher(valueItemFormula);
            return matcher.find();
        }
        return false;
    }

    @Override
    public void put(ItemFormula itemFormula, String valueFormula, Cell itemCell, Map<?, ?> others) {
        FormulaSchemeInfo scheme = this.create(itemCell, itemFormula, this.basePoint.getEnvParam());
        if (scheme == null) {
            return;
        }
        log.info("find a scheme:{0}", new Object[]{scheme});
        scheme.setEnvParam(this.basePoint.getEnvParam());
        this.schemes.add(scheme);
    }

    private FormulaSchemeInfo create(Cell cell, ItemFormula itemFormula, RptSheetParamInfo sheetParam) {
        FormulaSchemeInfo scheme;
        try {
            scheme = new CreateFormulaScheme(this.dao).by(cell, itemFormula);
        }
        catch (EASBizException e) {
            log.error("", e);
            return null;
        }
        catch (BOSException e) {
            log.error("", e);
            return null;
        }
        DynFormulaDefineInfo dynDefineInfo = new DynFormulaDefineInfo();
        dynDefineInfo.setFormulaScheme(scheme);
        dynDefineInfo.setIsLevelManualSum(false);
        dynDefineInfo.setIsLevelSum(false);
        scheme.getDynFormulaDefine().add(dynDefineInfo);
        String itemKey = "ITEM";
        itemKey = new GetEliminationItemKey().exec(sheetParam.getReportClass());
        String asstNum = new GetEliminationAsstNum().exec(itemKey);
        scheme.setItemKey(itemKey);
        IFormula newFormula = scheme.getItemFormula();
        newFormula.setName(itemKey);
        newFormula.getParams().add(1, "");
        dynDefineInfo.setAssistNum(asstNum);
        dynDefineInfo.setAssistName(ActionFactory.get(GetEliminationAsstNum.class).name(itemKey));
        return scheme;
    }

    @Override
    public IInfoHandler<FormulaSchemeInfo> other(String key) {
        if ("normal".equals(key)) {
            return new NormalInfoHandler(this.dao, this.basePoint);
        }
        return null;
    }
}

