/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.report;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.AutoItemException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectInfo;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.report.CreateReportNumber;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.report.NewReportParam;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.StringFormat;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.eas.fi.gr.cslrpt.util.ResourceDebugUtil;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveUtil;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveCalcHelper;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.CommittedStatusEnum;
import com.kingdee.eas.fi.rpt.IReport;
import com.kingdee.eas.fi.rpt.IRptSheetParam;
import com.kingdee.eas.fi.rpt.IsSupportGroupReportEnum;
import com.kingdee.eas.fi.rpt.PublicStatusEnum;
import com.kingdee.eas.fi.rpt.PublishedStatusEnum;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportCollection;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.ReportTypeCollection;
import com.kingdee.eas.fi.rpt.ReportTypeEnum;
import com.kingdee.eas.fi.rpt.ReportTypeFactory;
import com.kingdee.eas.fi.rpt.RptHandleStatusEnum;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSheetParamCollection;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.RptTypeRelaInfo;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.TemplateReportSavePointCollection;
import com.kingdee.eas.fi.rpt.TemplateReportSavePointFactory;
import com.kingdee.eas.fi.rpt.TemplateReportSavePointInfo;
import com.kingdee.eas.fi.rpt.VirtualSheetParamInfo;
import com.kingdee.eas.fi.rpt.util.RptUtilForServer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;

public class CreateEmptyReportByTemplate {
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", CreateEmptyReportByTemplate.class);
    private DBHandler dao;

    public CreateEmptyReportByTemplate(DBHandler dao) {
        this.dao = dao;
    }

    protected ReportInfo exec(NewReportParam defaultReport) throws BOSException, EASBizException {
        TemplateInfo templateInfo = defaultReport.getTemplate();
        OrgUnitInfo company = defaultReport.getCompany();
        UserInfo user = defaultReport.getCreator();
        if (!this.checkAddNewPermission((IObjectPK)new ObjectUuidPK(user.getId().toString()), (IObjectPK)new ObjectUuidPK(company.getId().toString()), defaultReport.getOrgType())) {
            String exception = MessageFormat.format(ResourceDebugUtil.res("current.user.have.not.permission.of.adding.report.with.format"), user.getNumber(), company);
            throw new AutoItemException(AutoItemException.FAIL_TO_CREATE_REPORT, new Object[]{exception});
        }
        int periodType = templateInfo.getPeriodType().getValue();
        int period = defaultReport.getPeriod();
        int year = defaultReport.getYear();
        CurrencyInfo currency = defaultReport.getCurrency();
        String cslrptId = RptWeaveCalcHelper.getRptidInSameVersion(templateInfo, company, currency, periodType, period, year, this.dao.getContext());
        if (cslrptId != null) {
            ReportInfo reportInfo;
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("isCommitReport"));
            ICslReport iReport = this.dao.get(ICslReport.class);
            CslReportInfo cslrptInfo = iReport.getCslReportInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)cslrptId)), sic);
            if (cslrptInfo.isIsCommitReport()) {
                LOG.debug("Success,It has the commited Report");
                reportInfo = CreateEmptyReportByTemplate.getReportInfoByCslrpt(this.dao.getContext(), cslrptInfo.getId().toString());
                if (reportInfo != null) {
                    reportInfo.put("existedReport", (Object)Boolean.TRUE);
                    return reportInfo;
                }
            }
            reportInfo = this.addNewReport(defaultReport);
            reportInfo.setCslReport(cslrptInfo);
            return reportInfo;
        }
        return this.addNewReport(defaultReport);
    }

    public static ReportInfo getReportInfoByCslrpt(Context ctx, String cslReportID) throws BOSException {
        IReport iReport = null;
        iReport = ctx == null ? ReportFactory.getRemoteInstance() : ReportFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add("*");
        sic.add("savePoint.*");
        sic.add("sheetParam.*");
        sic.add("orgRela.*");
        sic.add("postils.*");
        sic.add("template.*");
        sic.add("currency.*");
        sic.add("sourcecurrency.*");
        sic.add("company.*");
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("cslReport", (Object)cslReportID);
        filter.getFilterItems().add(filterItem);
        view.setFilter(filter);
        ReportCollection rptColl = iReport.getReportCollection(view);
        ReportInfo info = null;
        if (rptColl.size() > 0) {
            info = rptColl.get(0);
        }
        return info;
    }

    public boolean checkAddNewPermission(IObjectPK userPK, IObjectPK orgPK, OrgType orgType) throws BOSException {
        try {
            IPermission ip = this.dao.get(IPermission.class);
            String permissionStr = "rpt_report_addnew";
            if (OrgType.ProfitCenter.equals((Object)orgType)) {
                permissionStr = "prof_rpt_update";
            }
            ip.checkFunctionPermission(userPK, orgPK, permissionStr);
            return true;
        }
        catch (EASBizException e) {
            LOG.error("", e);
            return false;
        }
    }

    private void setRptNumber(ReportBaseInfo baseInfo, String templateNumber, int year, int period, CurrencyInfo currency) throws BOSException, EASBizException {
        boolean isCodingRule = CodingRuleManagerFactory.getLocalInstance((Context)this.dao.getContext()).isExist((IObjectValue)baseInfo, baseInfo.getCompany().getId().toString(), "sourceType");
        if (!isCodingRule) {
            String number = new CreateReportNumber(this.dao, new StringFormat("AT{template}-{year}-{period}-{orderNum:5}", '0')).exec(templateNumber, year, period, currency);
            baseInfo.setNumber(number);
        }
    }

    public ReportInfo addNewReport(NewReportParam defaultReport) throws EASBizException, BOSException {
        Calendar calendar;
        LOG.info("addNewReport-----------------");
        TemplateInfo templateInfo = defaultReport.getTemplate();
        templateInfo = RptAutoWeaveUtil.getTemplateInfo(this.dao.getContext(), templateInfo.getId().toString());
        int periodType = templateInfo.getPeriodType().getValue();
        int period = defaultReport.getPeriod();
        int year = defaultReport.getYear();
        ReportInfo reportInfo = new ReportInfo();
        reportInfo.setSourceType(RptSrcTypeEnum.NORMAL);
        if (templateInfo.getTemplateType().equals((Object)RptTmpTypeEnum.COMMONREPORT) || templateInfo.getTemplateType().equals((Object)RptTmpTypeEnum.COMMONPUBLICTEMPLATE)) {
            reportInfo.setSourceType(RptSrcTypeEnum.NORMAL);
        } else if (templateInfo.getTemplateType().equals((Object)RptTmpTypeEnum.GROUPREPORT) || templateInfo.getTemplateType().equals((Object)RptTmpTypeEnum.GROUPCOMMREPORT)) {
            reportInfo.setSourceType(RptSrcTypeEnum.COMMITREPORT);
        } else if (templateInfo.getTemplateType().equals((Object)RptTmpTypeEnum.DYNAMICNORMALREPORT) || templateInfo.getTemplateType().equals((Object)RptTmpTypeEnum.RPTDYNAMICREPORT)) {
            reportInfo.setSourceType(RptSrcTypeEnum.DYNAMICNORMALREPORT);
        } else if (templateInfo.getTemplateType().equals((Object)RptTmpTypeEnum.MULTIDYNAMICCSLREPORT) || templateInfo.getTemplateType().equals((Object)RptTmpTypeEnum.MULTIRPTDYNAMICREPORT)) {
            reportInfo.setSourceType(RptSrcTypeEnum.MULTIDYNAMICNORMALREPORT);
        }
        reportInfo.setYear(year);
        reportInfo.setPeriod((short)period);
        reportInfo.setPublicStatus(PublicStatusEnum.PUBLIC);
        reportInfo.setPublishedStatus(PublishedStatusEnum.UNPUBLISHED);
        reportInfo.setId(BOSUuid.create((BOSObjectType)reportInfo.getBOSType()));
        reportInfo.setAuditedStatus(AuditedStatusEnum.UNAUDITED);
        reportInfo.setCommittedStatus(CommittedStatusEnum.UNCOMMITTED);
        reportInfo.setIsSupportGroup(IsSupportGroupReportEnum.NOTSUPPORT);
        OrgUnitInfo orgUnitInfo = defaultReport.getCompany();
        reportInfo.setCompany(orgUnitInfo);
        reportInfo.setCU(orgUnitInfo.getCU());
        reportInfo.setName(templateInfo.getName());
        CurrencyInfo currency = defaultReport.getCurrency();
        reportInfo.setCurrency(currency);
        reportInfo.setTemplate(templateInfo);
        reportInfo.setExchangeRate(new BigDecimal("1"));
        reportInfo.setPeriodType(templateInfo.getPeriodType());
        reportInfo.setHandleStatus(RptHandleStatusEnum.FINISHED);
        DataCollectInfo dataCollectSelected = RptAutoWeaveUtil.getDataColl();
        reportInfo.setDataCollect(dataCollectSelected);
        reportInfo.setDataCollectNumber(dataCollectSelected.getNumber());
        this.setSavePoint(templateInfo, reportInfo, orgUnitInfo);
        if (periodType == 1) {
            Date default_GR_Date = null;
            default_GR_Date = reportInfo.getPeriod() == 13 ? RPTDateUtil.getEndOfMonth(reportInfo.getYear(), 12) : RPTDateUtil.getEndOfMonth(reportInfo.getYear(), reportInfo.getPeriod());
            reportInfo.setStartDate(default_GR_Date);
            reportInfo.setEndDate(default_GR_Date);
        } else if (periodType == 2) {
            reportInfo.setStartDate(RPTDateUtil.getPeriodFirstDate(reportInfo.getYear(), reportInfo.getPeriod() + 1 - 1, RptPeriodTypeEnum.WEEKLY));
            reportInfo.setEndDate(RPTDateUtil.getPeriodLastDate(reportInfo.getYear(), reportInfo.getPeriod() + 1 - 1, RptPeriodTypeEnum.WEEKLY));
        } else if (periodType == 3) {
            if (reportInfo.getPeriod() == 13) {
                calendar = Calendar.getInstance();
                calendar.set(1, reportInfo.getYear());
                calendar.set(2, 11);
                calendar.set(5, 31);
                Date date = new Date(calendar.getTimeInMillis());
                reportInfo.setStartDate(date);
                reportInfo.setEndDate(date);
            } else {
                reportInfo.setStartDate(RPTDateUtil.getPeriodFirstDate(reportInfo.getYear(), reportInfo.getPeriod() + 1 - 1, RptPeriodTypeEnum.MONTHLY));
                reportInfo.setEndDate(RPTDateUtil.getPeriodLastDate(reportInfo.getYear(), reportInfo.getPeriod() + 1 - 1, RptPeriodTypeEnum.MONTHLY));
            }
        } else if (periodType == 4) {
            reportInfo.setStartDate(RPTDateUtil.getPeriodFirstDate(reportInfo.getYear(), reportInfo.getPeriod() + 1 - 1, RptPeriodTypeEnum.QUARTERLY));
            reportInfo.setEndDate(RPTDateUtil.getPeriodLastDate(reportInfo.getYear(), reportInfo.getPeriod() + 1 - 1, RptPeriodTypeEnum.QUARTERLY));
        } else if (periodType == 5) {
            reportInfo.setStartDate(RPTDateUtil.getPeriodFirstDate(reportInfo.getYear(), reportInfo.getPeriod() + 1 - 1, RptPeriodTypeEnum.SEMIYEARLY));
            reportInfo.setEndDate(RPTDateUtil.getPeriodLastDate(reportInfo.getYear(), reportInfo.getPeriod() + 1 - 1, RptPeriodTypeEnum.SEMIYEARLY));
        } else if (periodType == 6) {
            reportInfo.setPeriod((short)1);
            reportInfo.setStartDate(RPTDateUtil.getPeriodFirstDate(reportInfo.getYear(), reportInfo.getPeriod() + 1 - 1, RptPeriodTypeEnum.YEARLY));
            reportInfo.setEndDate(RPTDateUtil.getPeriodLastDate(reportInfo.getYear(), reportInfo.getPeriod() + 1 - 1, RptPeriodTypeEnum.YEARLY));
        } else {
            calendar = Calendar.getInstance();
            reportInfo.setStartDate(new Date(calendar.getTimeInMillis()));
            reportInfo.setEndDate(new Date(calendar.getTimeInMillis()));
        }
        this.setRptNumber((ReportBaseInfo)reportInfo, templateInfo.getNumber(), year, period, currency);
        reportInfo.setIsOpenAutoCalc(false);
        reportInfo.setPublicStatus(PublicStatusEnum.PUBLIC);
        reportInfo.setIsSupportAdjust(false);
        reportInfo.setCreator(defaultReport.getCreator());
        reportInfo.setOrgType(defaultReport.getOrgType());
        Book book = null;
        try {
            book = reportInfo.getTemplate().getBook();
            RptUtilForServer.LockBookExpTank((Book)book);
            reportInfo.setBook(book);
        }
        catch (Exception e) {
            LOG.info("addNewReport", e);
            throw new BOSException((Throwable)e);
        }
        reportInfo.getSheetParam().addCollection(this.queryTemplateParams((VirtualSheetParamInfo)reportInfo, defaultReport.getTemplate()));
        return reportInfo;
    }

    private void setSavePoint(TemplateInfo templateInfo, ReportInfo reportInfo, OrgUnitInfo orgUnitInfo) throws BOSException {
        try {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)orgUnitInfo.getId().toString()));
            filterInfo.getFilterItems().add(new FilterItemInfo("template.id", (Object)templateInfo.getId().toString()));
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("*"));
            view.setFilter(filterInfo);
            TemplateReportSavePointCollection ccc = TemplateReportSavePointFactory.getLocalInstance((Context)this.dao.getContext()).getCollection(view);
            if (ccc != null && ccc.size() > 0) {
                TemplateReportSavePointInfo spInfo = ccc.get(0);
                ByteArrayInputStream ins = new ByteArrayInputStream(spInfo.getIds());
                ObjectInputStream in = new ObjectInputStream(ins);
                HashSet<String> ids = new HashSet<String>();
                String firstId = null;
                int count = in.readInt();
                for (int j = 0; j < count; ++j) {
                    if (j == 0) {
                        firstId = in.readObject().toString();
                        ids.add(firstId);
                        continue;
                    }
                    ids.add(in.readObject().toString());
                }
                filterInfo = new FilterInfo();
                if (count > 1) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
                } else {
                    filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)firstId));
                }
                EntityViewInfo entityView = new EntityViewInfo();
                entityView.setFilter(filterInfo);
                entityView.getSelector().add(new SelectorItemInfo("rptTypeStd.seq"));
                entityView.getSorter().add(new SorterItemInfo("rptTypeStd.seq"));
                entityView.getSelector().add(new SelectorItemInfo("*"));
                ReportTypeCollection r = ReportTypeFactory.getLocalInstance((Context)this.dao.getContext()).getReportTypeCollection(entityView);
                if (r != null && r.size() > 0) {
                    for (int k = 0; k < r.size(); ++k) {
                        RptTypeRelaInfo temp = new RptTypeRelaInfo();
                        temp.setRptType(r.get(k));
                        temp.setRelaType(ReportTypeEnum.REPORT);
                        temp.setReport((VirtualSheetParamInfo)reportInfo);
                        reportInfo.getSavePoint().add(temp);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public RptSheetParamCollection queryTemplateParams(VirtualSheetParamInfo reportInfo, TemplateInfo temp) throws BOSException {
        String tempId = temp.getId().toString();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("sheetName"));
        sic.add(new SelectorItemInfo("startYear"));
        sic.add(new SelectorItemInfo("endYear"));
        sic.add(new SelectorItemInfo("startPeriod"));
        sic.add(new SelectorItemInfo("endPeriod"));
        sic.add(new SelectorItemInfo("startDate"));
        sic.add(new SelectorItemInfo("endDate"));
        sic.add(new SelectorItemInfo("isIncludingUnposted"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("relaType"));
        sic.add(new SelectorItemInfo("sheetID"));
        sic.add(new SelectorItemInfo("report.id"));
        sic.add(new SelectorItemInfo("reportClass"));
        sic.add(new SelectorItemInfo("postil.*"));
        sic.add(new SelectorItemInfo("dfData.*"));
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("report", (Object)tempId);
        filter.getFilterItems().add(filterItem);
        view.setFilter(filter);
        RptSheetParamCollection rptSheetParamCollection = this.dao.get(IRptSheetParam.class).getRptSheetParamCollection(view);
        if (rptSheetParamCollection != null && rptSheetParamCollection.size() > 0) {
            for (int j = 0; j < rptSheetParamCollection.size(); ++j) {
                RptSheetParamInfo info = rptSheetParamCollection.get(j);
                info.setRelaType(ReportTypeEnum.REPORT);
                info.setId(null);
                info.setStatus(1);
                info.setReport(reportInfo);
            }
        }
        return rptSheetParamCollection;
    }
}

