/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.report;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.basepoint.ReportEntityForReport;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.CalcContext;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.CalcuateAndFillCellFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.CellFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.FindValueFormulaWithoutItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.GetCalcContextFromReport;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.report.FillItemValue;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.report.FindItemFormulaFromBook;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.report.IFillSheet;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.report.IFillSheetAndValue;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.report.IFillValue;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.report.IFindItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.IsNormalSheet;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.QuerySheetParams;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.ItemContext;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.ActionFactory;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.AutoItemItemFormula;
import com.kingdee.eas.fi.rpt.ReportInfo;
import java.util.Collection;
import java.util.HashMap;

public class FillNormalSheetAndValue
implements IFillSheetAndValue {
    DBHandler dao;

    public FillNormalSheetAndValue(DBHandler dao) {
        this.dao = dao;
    }

    @Override
    public IFillSheet buildFillSheetHandler() {
        return IFillSheet.EMPTY_OBJECT;
    }

    @Override
    public IFindItemFormula buildFindItemFormula() {
        return new FindItemFormulaFromBook();
    }

    @Override
    public IFillValue buildFillValueHandler() {
        return new FillItemValue(this.dao);
    }

    public boolean serial(ReportInfo report, boolean existNotFill) throws BOSException, EASBizException {
        Book book;
        boolean bookAutoCalculate = false;
        try {
            book = report.getBook();
            book.getUndoManager().enable(false);
            bookAutoCalculate = book.isAutoCalculate();
            book.setAutoCalculate(false);
        }
        catch (Exception e) {
            return false;
        }
        QuerySheetParams query = new QuerySheetParams(this.dao);
        ReportEntityForReport reportEntity = new ReportEntityForReport(report, query);
        IsNormalSheet isNormalSheet = ActionFactory.get(IsNormalSheet.class);
        IFindItemFormula findItemFormulaFromBook = this.buildFindItemFormula();
        IFillValue fillItemValue = this.buildFillValueHandler();
        ItemContext itemContext = new ItemContext((OrgUnitInfo)report.getCompany(), report.getCurrency(), report.getPeriodType(), report.getYear(), report.getPeriod());
        Sheet sheet = null;
        HashMap<AutoItemItemFormula, Cell> itemFormulas = new HashMap<AutoItemItemFormula, Cell>();
        boolean success = false;
        CalcContext newCalcContext = ActionFactory.get(GetCalcContextFromReport.class).exec(report);
        FindValueFormulaWithoutItemFormula find = ActionFactory.get(FindValueFormulaWithoutItemFormula.class);
        CalcuateAndFillCellFormula calculateAndFill = new CalcuateAndFillCellFormula(this.dao);
        for (int i = 0; i < book.getSheetCount(); ++i) {
            sheet = book.getSheet(i);
            if (!isNormalSheet.is(reportEntity, sheet)) continue;
            itemFormulas.clear();
            itemFormulas.putAll(findItemFormulaFromBook.exec(sheet, this.dao));
            fillItemValue.exec(itemContext, itemFormulas, false, report.getOrgType());
            success = true;
            Collection<CellFormula> valueFormulas = find.exec(sheet);
            calculateAndFill.exec(valueFormulas, newCalcContext);
        }
        try {
            report.setBook(book);
            book.setAutoCalculate(bookAutoCalculate);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return success;
    }
}

