/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.facade;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextInfo;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.EItemQueryUnit;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.IItemDao;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.ItemKeyTable;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.QueryEItem;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.GetEItemTable;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.IItemSourceType;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.ItemSource;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.ItemValue;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.ItemValueSet;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.ExecuteSQL;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.ActionFactory;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.FileUtil;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.StringUtil;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.util.Uuid;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class EItemDao
implements IItemDao {
    private static final ILog LOG = LogFactory.getLog("AUTOITEM", EItemDao.class);
    protected DBHandler dao;

    public EItemDao(DBHandler dao) {
        this.dao = dao;
    }

    @Override
    public void saveItemData(ItemSource itemSource, int calcLevelInOneProcess, OrgType orgType) throws BOSException {
        LOG.info("start save ditem's data:{0}", new Object[]{itemSource});
        GetEItemTable GET_TABLE = ActionFactory.get(GetEItemTable.class);
        EItemQueryUnit rptQueryInfo = new EItemQueryUnit(itemSource.getCompany(), itemSource.getItemType(), null, itemSource.getYear(), itemSource.getPeriod(), itemSource.getPeriodType(), itemSource.getDataElement(), itemSource.getCurrency(), null);
        Collection<ItemSource> existedItemSources = new QueryEItem(this.dao).queryItemSource(rptQueryInfo);
        boolean mustReturn = false;
        for (ItemSource existedItemSource : existedItemSources) {
            if (existedItemSource != null && existedItemSource.getSourceType() instanceof FormulaCalcContextInfo) {
                BOSUuid oldCtxId = ((FormulaCalcContextInfo)existedItemSource.getSourceType()).getItemSourceId();
                if (oldCtxId == null) continue;
                if (itemSource.getSourceType().getItemSourceType() == 100 && oldCtxId.equals((Object)itemSource.getSourceType().getItemSourceId())) {
                    LOG.info("repeat ditem context(type:{2},id:{0},entryid:{1}) be found!it will be deleted", new Object[]{existedItemSource.getId(), existedItemSource.getEntrys(), 100});
                    if (calcLevelInOneProcess > 1) continue;
                    this.deleteItemValues(existedItemSource, itemSource, true);
                    continue;
                }
                this.deleteItemValues(existedItemSource, itemSource, false);
                continue;
            }
            if (existedItemSource == null || !(existedItemSource.getSourceType() instanceof ReportBaseInfo)) continue;
            LOG.info("repeat item context(type:{2},id:{0},entryid:{1}) be found!it will be deleted", new Object[]{existedItemSource.getId(), existedItemSource.getEntrys(), IItemSourceType.SOURCE_TYPE_REPORT});
            this.excludeItemValues(existedItemSource, itemSource);
            if (!itemSource.getItemValues().isEmpty()) continue;
            mustReturn = true;
        }
        if (mustReturn) {
            return;
        }
        HashMap insertTableParams = new HashMap();
        HashMap updateTableParams = new HashMap();
        String insertSql = null;
        ArrayList<Object[]> paramsList = null;
        String entryId = null;
        for (ItemValue itemValue : itemSource.getItemValues()) {
            insertSql = GET_TABLE.getTable(itemValue.getType());
            BigDecimal result = itemValue.getResult() instanceof BigDecimal ? (BigDecimal)itemValue.getResult() : new BigDecimal("0");
            paramsList = (ArrayList<Object[]>)insertTableParams.get(insertSql);
            if (paramsList == null) {
                paramsList = new ArrayList<Object[]>();
                insertTableParams.put(insertSql, paramsList);
            }
            entryId = Uuid.create().toString();
            if ("REITEM".equalsIgnoreCase(itemValue.getType())) {
                paramsList.add(new Object[]{entryId, itemValue.getNumber(), itemValue.getDynaItem(), itemSource.getCompany().getId().toString(), itemSource.getCurrency().getId().toString(), itemSource.getCurrency().getId().toString(), itemSource.getYear(), itemSource.getPeriod(), itemSource.getPeriodType().getValue(), new Timestamp(System.currentTimeMillis()), itemSource.getDataElement(), itemSource.getSourceType().getItemSourceId().toString(), result, 100, 1, this.dao.getContext().getCaller() + "", new Timestamp(System.currentTimeMillis()), itemSource.getCompany().getId().toString()});
                continue;
            }
            paramsList.add(new Object[]{entryId, itemValue.getNumber(), itemValue.getDynaItem(), itemSource.getCompany().getId().toString(), itemSource.getCurrency().getId().toString(), itemSource.getCurrency().getId().toString(), itemSource.getYear(), itemSource.getPeriod(), itemSource.getPeriodType().getValue(), new Timestamp(System.currentTimeMillis()), itemSource.getDataElement(), itemSource.getSourceType().getItemSourceId().toString(), result, 1, 100, 1});
        }
        String insertItemDataEntry = FileUtil.readContent("com/kingdee/eas/fi/gr/cslrpt/autoitem/facade/sql/insertEItemData.sql");
        String updateItemDataEntry = FileUtil.readContent("com/kingdee/eas/fi/gr/cslrpt/autoitem/facade/sql/updateEItemData.sql");
        String insertREItemDataEntry = FileUtil.readContent("com/kingdee/eas/fi/gr/cslrpt/autoitem/facade/sql/insertREItemData.sql");
        MessageFormat sqlFormat = new MessageFormat(insertItemDataEntry);
        ExecuteSQL executeSQL = this.dao.getExecuteSQL();
        for (String tableName : insertTableParams.keySet()) {
            insertSql = GET_TABLE.getTable("REITEM").equalsIgnoreCase(tableName) ? insertREItemDataEntry : sqlFormat.format(new Object[]{tableName});
            executeSQL.executeBatchAndReturn(insertSql, (List)insertTableParams.get(tableName));
        }
        for (String tableName : updateTableParams.keySet()) {
            executeSQL.executeBatchAndReturn(MessageFormat.format(updateItemDataEntry, tableName), (List)updateTableParams.get(tableName));
        }
    }

    @Override
    public void saveItemValue(ItemSource itemSource, Map<String, ItemKeyTable> itemKeyTable, int calcLevelInOneProcess) throws BOSException {
    }

    @Override
    public void deleteItemSource(ItemSource itemSource, int calcLevelInOneProcess) throws BOSException {
        HashSet<String> deleteIds = new HashSet<String>(1);
        deleteIds.addAll(itemSource.getEntrys().keySet());
        LOG.info("delete eitem context.ids:{0}", new Object[]{deleteIds});
        this.deleteItemData(itemSource, deleteIds);
    }

    protected void deleteItemData(ItemSource itemSource, Collection<String> deleteIds) throws BOSException {
        String idSql = StringUtil.toSql(deleteIds, true);
        String deleteItemValueSql = null;
        String deleteItemValueFormatSql = FileUtil.readContent("com/kingdee/eas/fi/gr/cslrpt/autoitem/facade/sql/deleteEItemData.sql");
        GetEItemTable GET_TABLE = ActionFactory.get(GetEItemTable.class);
        MessageFormat sqlFormat = new MessageFormat(deleteItemValueFormatSql);
        if ("LEITEM".equalsIgnoreCase(itemSource.getItemType())) {
            deleteItemValueSql = sqlFormat.format(new Object[]{GET_TABLE.getTable("LEITEM"), idSql});
            LOG.debug("delete leitem value sql is {0}", new Object[]{deleteItemValueSql});
        } else if ("CEITEM".equalsIgnoreCase(itemSource.getItemType())) {
            deleteItemValueSql = sqlFormat.format(new Object[]{GET_TABLE.getTable("CEITEM"), idSql});
            LOG.debug("delete ceitem value sql is {0}", new Object[]{deleteItemValueSql});
        } else if ("REITEM".equalsIgnoreCase(itemSource.getItemType())) {
            deleteItemValueSql = sqlFormat.format(new Object[]{GET_TABLE.getTable("REITEM"), idSql});
            LOG.debug("delete reitem value sql is {0}", new Object[]{deleteItemValueSql});
        } else {
            return;
        }
        this.dao.getExecuteSQL().execute(deleteItemValueSql);
    }

    protected void deleteItemValues(ItemSource itemSourceForDuplicItemValue, ItemSource currentItemSource, boolean deleteAllItemData) throws BOSException {
        ItemValueSet currentItemValues = currentItemSource.getItemValues();
        HashSet<String> itemValueEntrysForWantToRemove = new HashSet<String>(currentItemValues.size());
        for (ItemValue existedItemValue : itemSourceForDuplicItemValue.getItemValues()) {
            if (deleteAllItemData) {
                itemValueEntrysForWantToRemove.add(existedItemValue.getItemDataEntryId());
                continue;
            }
            for (ItemValue currentItemValue : currentItemValues) {
                if (!currentItemValue.getNumber().equals(existedItemValue.getNumber()) || !currentItemValue.getDynaItem().equals(existedItemValue.getDynaItem())) continue;
                itemValueEntrysForWantToRemove.add(existedItemValue.getItemDataEntryId());
            }
        }
        this.deleteItemData(itemSourceForDuplicItemValue, itemValueEntrysForWantToRemove);
    }

    protected void excludeItemValues(ItemSource itemSourceForDuplicItemValue, ItemSource currentItemSource) {
        ItemValueSet currentItemValues = currentItemSource.getItemValues();
        for (ItemValue existedItemValue : itemSourceForDuplicItemValue.getItemValues()) {
            Iterator it = currentItemValues.iterator();
            while (it.hasNext()) {
                ItemValue currentItemValue = (ItemValue)it.next();
                if (!currentItemValue.getNumber().equals(existedItemValue.getNumber()) || !currentItemValue.getDynaItem().equals(existedItemValue.getDynaItem())) continue;
                it.remove();
            }
        }
    }
}

