/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.csl;

import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.HandleMultiItemValue;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.ItemResult;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.csl.AdjustItemQueryUnit;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.csl.QueryAdjustItemData;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.csl.SplitedAdjustItemQueryUnit;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.FileSQL;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.ObjectMatcher;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;

public class QueryDynaAdjustItemData
extends QueryAdjustItemData {
    private static final ILog LOG = LogFactory.getLog("AUTO_ITEM", QueryDynaAdjustItemData.class);

    public QueryDynaAdjustItemData(DBHandler dao) {
        super(dao);
    }

    @Override
    protected void matchData(Map<AdjustItemQueryUnit, ItemResult> itemValues, ObjectMatcher<AdjustItemQueryUnit> itemMatcher, IRowSet dataRs) throws SQLException {
        Set<AdjustItemQueryUnit> finds = null;
        BigDecimal newValue = null;
        String sourceId = null;
        int sourceType = -1;
        ItemResult preResult = null;
        String targetCompanyName = null;
        boolean debitOrCredit = true;
        String dynaLongNumber = null;
        String dynaName = null;
        finds = itemMatcher.get(new Object[]{dataRs.getString("forgboundid"), dataRs.getString("forgunit"), dataRs.getInt("fperiodType"), dataRs.getString("fCurrencyId"), dataRs.getInt("fyear"), dataRs.getInt("fperiod"), dataRs.getInt("fdataElement"), dataRs.getString("FItemNumber")});
        if (finds != null) {
            if (finds.size() > 1) {
                LOG.debug("too many matcher exception.", new Object[0]);
            }
            dynaLongNumber = dataRs.getString("FKeyLongNumber");
            dynaName = dataRs.getString("FKeyName");
            sourceType = dataRs.getInt("sourceType");
            newValue = dataRs.getBigDecimal("debit_value");
            if (newValue == null) {
                newValue = dataRs.getBigDecimal("credit_value");
                debitOrCredit = false;
            }
            for (AdjustItemQueryUnit find : finds) {
                SplitedAdjustItemQueryUnit newFind = new SplitedAdjustItemQueryUnit(find);
                newFind.updateDynaInfo(dynaLongNumber, dynaName, "");
                preResult = new HandleMultiItemValue().newResult(newValue, sourceId, sourceType);
                preResult.setDynaName(targetCompanyName);
                preResult.setDebitOrCredit(debitOrCredit);
                itemValues.put(newFind, preResult);
            }
        }
    }

    @Override
    protected String defineMainQuerySQL() {
        return new FileSQL("com/kingdee/eas/fi/gr/cslrpt/autoitem/facade/item/csl/queryDynaAdjustItemData.sql").sql();
    }
}

