/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.sys;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.IBizCtrl;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.ExecuteSQL;
import com.kingdee.eas.framework.ICoreBase;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;

public class DBHandler {
    private static final Logger log = Logger.getLogger(DBHandler.class);
    protected Context ctx;

    public DBHandler(Context ctx) {
        this.ctx = ctx;
    }

    public <T> T get(Class<T> daoType) throws BOSException {
        if (!(ICoreBase.class.isAssignableFrom(daoType) || IBizCtrl.class.isAssignableFrom(daoType) || IDynamicObject.class.equals(daoType))) {
            if (IMetaDataLoader.class.equals(daoType)) {
                if (this.isClient()) {
                    return (T)MetaDataLoaderFactory.getRemoteMetaDataLoader();
                }
                return (T)MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx);
            }
            throw new RuntimeException("daoType [" + daoType.getName() + "] is not assignable from ICoreBase/IBizCtrl/IDynamicObject.");
        }
        try {
            Class<T> factoryInstance = this.getFactoryInstanceBy(daoType);
            if (this.isClient()) {
                Method remoteMethod = factoryInstance.getMethod("getRemoteInstance", new Class[0]);
                remoteMethod.setAccessible(true);
                return (T)remoteMethod.invoke(factoryInstance, new Object[0]);
            }
            Method localMethod = factoryInstance.getMethod("getLocalInstance", this.ctx.getClass());
            localMethod.setAccessible(true);
            return (T)localMethod.invoke(factoryInstance, this.ctx);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (SecurityException e) {
            log.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            log.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            log.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    protected boolean isClient() {
        return this.ctx == null || this.ctx.get((Object)"isBVTTestCase") != null;
    }

    protected <T> Class<T> getFactoryInstanceBy(Class<T> daoType) throws ClassNotFoundException {
        String iDaoTypeName = daoType.getName();
        String factoryTypeName = iDaoTypeName.replaceAll("([a-zA-Z_0-9\\.]+)\\.I([a-zA-Z_0-9]+)", "$1.$2Factory");
        return Class.forName(factoryTypeName);
    }

    public ExecuteSQL getExecuteSQL() {
        return new ExecuteSQL(this);
    }

    public Context getContext() {
        return this.ctx;
    }

    public String getLocale() {
        if (this.ctx == null) {
            return "L2";
        }
        return this.ctx.getLocale().toString();
    }
}

