/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.sys;

import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.IParameterSetting;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;

public class StringSQL {
    protected StringBuffer buffer = new StringBuffer();
    protected boolean appendSeperatorWhenAppend = false;

    public StringSQL() {
        this(false);
    }

    public StringSQL(boolean appendSeperatorWhenAppend) {
        this.appendSeperatorWhenAppend = appendSeperatorWhenAppend;
    }

    public StringSQL append(Object sql) {
        this.buffer.append(sql);
        return this;
    }

    public StringSQL append(String sql) {
        this.buffer.append(sql);
        if (this.appendSeperatorWhenAppend) {
            this.buffer.append("\t\n");
        }
        return this;
    }

    public StringSQL append(String sqlFormat, String[] params) {
        return this.append(MessageFormat.format(sqlFormat, params));
    }

    public String toString() {
        return this.buffer.toString();
    }

    public String sql() {
        return this.buffer.toString();
    }

    public boolean isEmpty() {
        return this.buffer.length() > 0;
    }

    public int indexOf(String str) {
        return this.buffer.indexOf(str);
    }

    public String substring(int i) {
        return this.buffer.substring(i);
    }

    public int lastIndexOf(String string) {
        return this.buffer.lastIndexOf(string);
    }

    public void clear() {
        this.buffer.setLength(0);
    }

    public ResultSet prepareExecuteQuery(Connection con) throws SQLException {
        PreparedStatement ps = con.prepareStatement(this.toString());
        return ps.executeQuery();
    }

    public ResultSet prepareExecuteQuery(Connection con, IParameterSetting parameterSetting) throws SQLException {
        PreparedStatement ps = con.prepareStatement(this.toString());
        parameterSetting.exec(ps);
        return ps.executeQuery();
    }

    public void prepareExecute(Connection con, IParameterSetting parameterSetting) throws SQLException {
        PreparedStatement ps = con.prepareStatement(this.toString());
        if (parameterSetting != null) {
            parameterSetting.exec(ps);
        }
        ps.execute();
        ps.close();
    }

    public StringSQL delete(int start, int end) {
        this.buffer.delete(start, end);
        return this;
    }

    public StringSQL deleteAt(int pos) {
        this.buffer.deleteCharAt(pos);
        return this;
    }

    public int length() {
        return this.buffer.length();
    }
}

