/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.util;

import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.formula.ParseExpression;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.formula.expr.BoolExpr;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.formula.expr.IExpr;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.formula.expr.IHasSubExpr;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.formula.expr.JoinExpr;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.formula.expr.LogicExpr;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.formula.expr.MultiExpr;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.formula.expr.NumberExpr;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.formula.expr.StringExpr;
import java.util.ArrayList;
import java.util.List;

public class CalculateStringExpression {
    public Object exec(String exprForStr) throws UnKnownChar {
        ParseExpression parser = new ParseExpression();
        IExpr expr = parser.exec(exprForStr);
        return this.exec(expr);
    }

    public Object exec(IExpr expr) throws UnKnownChar {
        if (expr instanceof IHasSubExpr) {
            List<IExpr> subs = ((IHasSubExpr)expr).sub();
            ArrayList<Object> results = new ArrayList<Object>(subs.size());
            Object result = null;
            boolean isNumber = true;
            boolean isString = true;
            boolean isBoolean = true;
            for (IExpr sub : subs) {
                result = this.exec(sub);
                results.add(result);
                isNumber &= result instanceof Number;
                isString &= result instanceof String;
                isBoolean &= result instanceof Boolean;
            }
            if (results.isEmpty()) {
                return null;
            }
            if (results.size() == 1) {
                return results.get(0);
            }
            if (expr instanceof MultiExpr) {
                List<JoinExpr> joins = ((MultiExpr)expr).joins();
                if (joins.size() != results.size() - 1) {
                    return null;
                }
                if (isBoolean) {
                    boolean sum = (Boolean)results.get(0);
                    boolean secondStr = true;
                    String join = null;
                    block13: for (int i = 1; i < results.size(); ++i) {
                        secondStr = (Boolean)results.get(i);
                        join = joins.get(i - 1).getJoin();
                        if (join.length() != 1) continue;
                        switch (join.charAt(0)) {
                            case '&': {
                                sum &= secondStr;
                                continue block13;
                            }
                            default: {
                                throw new UnKnownChar(join.charAt(0));
                            }
                        }
                    }
                    return sum;
                }
                if (isNumber) {
                    double sum = ((Number)results.get(0)).doubleValue();
                    double secondNum = 0.0;
                    String join = null;
                    block14: for (int i = 1; i < results.size(); ++i) {
                        secondNum = ((Number)results.get(i)).doubleValue();
                        join = joins.get(i - 1).getJoin();
                        if (join.length() == 1) {
                            switch (join.charAt(0)) {
                                case '+': {
                                    sum += secondNum;
                                    continue block14;
                                }
                                case '-': {
                                    sum -= secondNum;
                                    continue block14;
                                }
                                case '*': {
                                    sum *= secondNum;
                                    continue block14;
                                }
                                case '/': {
                                    sum /= secondNum;
                                    continue block14;
                                }
                                default: {
                                    throw new UnKnownChar(join.charAt(0));
                                }
                            }
                        }
                        throw new UnKnownChar(' ');
                    }
                    return sum;
                }
                if (isString) {
                    StringBuffer sum = new StringBuffer((String)results.get(0));
                    String secondStr = null;
                    String join = null;
                    block15: for (int i = 1; i < results.size(); ++i) {
                        secondStr = (String)results.get(i);
                        join = joins.get(i - 1).getJoin();
                        if (join.length() != 1) continue;
                        switch (join.charAt(0)) {
                            case '&': 
                            case '+': {
                                sum.append(secondStr);
                                continue block15;
                            }
                            default: {
                                throw new UnKnownChar(join.charAt(0));
                            }
                        }
                    }
                    return sum.toString();
                }
            } else if (expr instanceof LogicExpr) {
                LogicExpr logic = (LogicExpr)expr;
                if (subs.size() != 2 || !isNumber) {
                    throw new UnKnownChar(' ');
                }
                String join = logic.getJoin().getJoin();
                double first = ((Number)results.get(0)).doubleValue();
                double second = ((Number)results.get(1)).doubleValue();
                if (">".equals(join)) {
                    return first > second;
                }
                if (">=".equals(join)) {
                    return first >= second;
                }
                if ("<".equals(join)) {
                    return first < second;
                }
                if ("<=".equals(join)) {
                    return first <= second;
                }
            }
        } else {
            if (expr instanceof NumberExpr) {
                return ((NumberExpr)expr).getNumber();
            }
            if (expr instanceof StringExpr) {
                return ((StringExpr)expr).getContent();
            }
            if (expr instanceof BoolExpr) {
                return ((BoolExpr)expr).isValue();
            }
        }
        throw new UnKnownChar(' ');
    }

    public static class UnKnownChar
    extends Exception {
        private static final long serialVersionUID = 1655636583768799639L;
        private char unknownChar;

        public UnKnownChar(char unknownChar) {
            this.unknownChar = unknownChar;
        }

        public char getUnknownChar() {
            return this.unknownChar;
        }
    }
}

