/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.autoitem.util.formula;

import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.CombineFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.IFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.calc.SingleFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.CellType;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.ChangeInt;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.ChangeIntWrap;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.IChangeIntWrap;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.MultiChangeInt;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.formula.GetExprLevel;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.formula.expr.BlockExpr;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.formula.expr.BoolExpr;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.formula.expr.CellExpr;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.formula.expr.FormulaExpr;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.formula.expr.IExpr;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.formula.expr.IHasSubExpr;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.formula.expr.JoinExpr;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.formula.expr.NumberExpr;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.formula.expr.StringExpr;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.formula.expr.UnKnownExpr;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ConvertExpr2Formula {
    public IFormula exec(IExpr expr) {
        GetExprLevel getExprLevel = new GetExprLevel();
        getExprLevel.exec(expr);
        Map<IExpr, IChangeIntWrap> levels = getExprLevel.getLevels();
        return this.exec(expr, levels);
    }

    public IFormula exec(IExpr expr, Map<IExpr, IChangeIntWrap> levels) {
        if (expr instanceof FormulaExpr) {
            FormulaExpr formulaExpr = (FormulaExpr)expr;
            SingleFormula formula = new SingleFormula();
            formula.setName(formulaExpr.getName());
            this.setLevelBy(expr, levels, formula);
            ArrayList<Object> params = new ArrayList<Object>(formulaExpr.sub().size());
            Object param = null;
            int size = formulaExpr.sub().size();
            for (int i = 0; i < size; ++i) {
                param = this.type(formulaExpr.sub().get(i), levels);
                params.add(param);
            }
            formula.setParams(params);
            return formula;
        }
        if (expr instanceof IHasSubExpr) {
            IHasSubExpr formulaExpr = (IHasSubExpr)expr;
            List<IExpr> subExprs = formulaExpr.sub();
            Object param = null;
            ArrayList<SingleFormula> subFormula = new ArrayList<SingleFormula>(subExprs.size());
            CombineFormula formula = new CombineFormula(subFormula, "");
            this.setLevelBy(expr, levels, formula);
            List<JoinExpr> joins = formulaExpr.joins();
            int size = subExprs.size();
            for (int i = 0; i < size; ++i) {
                param = this.type(subExprs.get(i), levels);
                String join = "";
                if (i - 1 >= 0 && i - 1 < joins.size()) {
                    join = joins.get(i - 1).getJoin();
                }
                if (param == null) {
                    return null;
                }
                if (param instanceof IFormula) {
                    formula.addFunc((IFormula)param, join);
                    continue;
                }
                if (param instanceof String) {
                    formula.getFormulaExpress().append("\"" + param + "\"" + join);
                    continue;
                }
                if (param instanceof CellType) {
                    formula.addParam("", param);
                    continue;
                }
                formula.getFormulaExpress().append(join + param);
            }
            if (formulaExpr instanceof BlockExpr) {
                formula.getFormulaExpress().insert(0, "(");
                formula.getFormulaExpress().append(")");
            }
            return formula;
        }
        return null;
    }

    protected boolean setLevelBy(IExpr expr, Map<IExpr, IChangeIntWrap> levels, IFormula formula) {
        IChangeIntWrap level = levels.get(expr);
        if (level == null) {
            return false;
        }
        formula.setLevel(level);
        return true;
    }

    @Deprecated
    public IFormula exec(IExpr expr, IChangeIntWrap formulaLevel) {
        if (expr instanceof FormulaExpr) {
            FormulaExpr formulaExpr = (FormulaExpr)expr;
            SingleFormula formula = new SingleFormula();
            formula.setName(formulaExpr.getName());
            MultiChangeInt multiCalcLevel = new MultiChangeInt();
            multiCalcLevel.add(new ChangeInt(null, formulaLevel.getValue()));
            if (formulaLevel instanceof ChangeIntWrap) {
                ((ChangeIntWrap)formulaLevel).replace(multiCalcLevel);
            } else {
                formulaLevel = new ChangeIntWrap(multiCalcLevel);
            }
            formula.setLevel(formulaLevel);
            boolean haveSubFormula = false;
            ArrayList<Object> params = new ArrayList<Object>(formulaExpr.sub().size());
            Object param = null;
            int size = formulaExpr.sub().size();
            for (int i = 0; i < size; ++i) {
                ChangeIntWrap subLevel = new ChangeIntWrap(new ChangeInt(null, 0));
                param = this.type(formulaExpr.sub().get(i), subLevel);
                if (param instanceof IFormula) {
                    multiCalcLevel.add(new ChangeInt(subLevel, 1));
                    haveSubFormula = true;
                }
                params.add(param);
            }
            formula.setParams(params);
            if (!haveSubFormula) {
                formulaLevel.addForSerial(-formulaLevel.getValue());
            }
            return formula;
        }
        if (expr instanceof IHasSubExpr) {
            IHasSubExpr formulaExpr = (IHasSubExpr)expr;
            List<IExpr> subExprs = formulaExpr.sub();
            Object param = null;
            ArrayList<SingleFormula> subFormula = new ArrayList<SingleFormula>(subExprs.size());
            CombineFormula formula = new CombineFormula(subFormula, "");
            MultiChangeInt multiCalcLevel = new MultiChangeInt();
            multiCalcLevel.add(new ChangeInt(null, formulaLevel.getValue()));
            if (formulaLevel instanceof ChangeIntWrap) {
                ((ChangeIntWrap)formulaLevel).replace(multiCalcLevel);
            } else {
                formulaLevel = new ChangeIntWrap(multiCalcLevel);
            }
            formula.setLevel(formulaLevel);
            List<JoinExpr> joins = formulaExpr.joins();
            boolean haveSubFormula = false;
            int size = subExprs.size();
            for (int i = 0; i < size; ++i) {
                ChangeIntWrap subLevel = new ChangeIntWrap(new ChangeInt(null, 0));
                param = this.type(subExprs.get(i), subLevel);
                String join = "";
                if (i - 1 >= 0 && i - 1 < joins.size()) {
                    join = joins.get(i - 1).getJoin();
                }
                if (param == null) {
                    return null;
                }
                if (param instanceof IFormula) {
                    formula.addFunc((IFormula)param, join);
                    multiCalcLevel.add(new ChangeInt(subLevel, 1));
                    haveSubFormula = true;
                    continue;
                }
                if (param instanceof String) {
                    formula.getFormulaExpress().append("\"" + param + "\"" + join);
                    continue;
                }
                if (param instanceof CellType) {
                    formula.addParam("", param);
                    continue;
                }
                formula.getFormulaExpress().append(join + param);
            }
            if (formulaExpr instanceof BlockExpr) {
                formula.getFormulaExpress().insert(0, "(");
                formula.getFormulaExpress().append(")");
            }
            if (!haveSubFormula) {
                formulaLevel.addForSerial(-formulaLevel.getValue());
            }
            return formula;
        }
        return null;
    }

    protected Object type(IExpr expr, Map<IExpr, IChangeIntWrap> levels) {
        IFormula formula = this.exec(expr, levels);
        if (formula != null) {
            return formula;
        }
        if (expr instanceof NumberExpr) {
            return ((NumberExpr)expr).getNumber();
        }
        if (expr instanceof BoolExpr) {
            return ((BoolExpr)expr).isValue();
        }
        if (expr instanceof StringExpr) {
            return ((StringExpr)expr).getContent();
        }
        if (expr instanceof UnKnownExpr) {
            return ((UnKnownExpr)expr).getContent();
        }
        if (expr instanceof CellExpr) {
            return new CellType(((CellExpr)expr).getCellRange());
        }
        return null;
    }

    @Deprecated
    protected Object type(IExpr expr, IChangeIntWrap formulaLevel) {
        IFormula formula = this.exec(expr, formulaLevel);
        if (formula != null) {
            if (formulaLevel.getValue() < 0) {
                formulaLevel.addForSerial(-formulaLevel.getValue());
            }
            return formula;
        }
        if (expr instanceof NumberExpr) {
            return ((NumberExpr)expr).getNumber();
        }
        if (expr instanceof BoolExpr) {
            return ((BoolExpr)expr).isValue();
        }
        if (expr instanceof StringExpr) {
            return ((StringExpr)expr).getContent();
        }
        if (expr instanceof UnKnownExpr) {
            return ((UnKnownExpr)expr).getContent();
        }
        if (expr instanceof CellExpr) {
            return new CellType(((CellExpr)expr).getCellRange());
        }
        return null;
    }
}

