/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.elimreport;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.fi.gr.cslrpt.CSLReportCalculatorFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslParamBox;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.DynaSumMethodEnum;
import com.kingdee.eas.fi.gr.cslrpt.ElimReportFacadeFactory;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.ICSLReportCalculator;
import com.kingdee.eas.fi.gr.cslrpt.IElimReportFacade;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.elimreport.BuildElimRptBookInfo;
import com.kingdee.eas.fi.gr.cslrpt.elimreport.ElimReportUtils;
import com.kingdee.eas.fi.gr.cslrpt.elimreport.FormulaItemData;
import com.kingdee.eas.fi.gr.cslrpt.elimreport.ICatchDataSource;
import com.kingdee.eas.fi.gr.cslrpt.elimreport.IItemData;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.RptCalcHelper;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.DyRptSaveHelper;
import com.kingdee.eas.fi.gr.cslrpt.util.RptProperties;
import com.kingdee.eas.fi.gr.cslrpt.util.SumHelper;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import java.awt.Point;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CatchDynaCslElimRptDataSource
implements ICatchDataSource {
    private CslParamBox paramBox;

    @Override
    public void catchDataSource(BuildElimRptBookInfo buildInfo) throws Exception {
        this.initCslParamBox(buildInfo);
        Map<Object, Object> tableValues = this.getTableValues(buildInfo);
        ICSLReportCalculator calculator = null;
        IElimReportFacade elimReportFaced = null;
        if (buildInfo.getCtx() == null) {
            calculator = CSLReportCalculatorFactory.getRemoteInstance();
            elimReportFaced = ElimReportFacadeFactory.getRemoteInstance();
        } else {
            calculator = CSLReportCalculatorFactory.getLocalInstance(buildInfo.getCtx());
            elimReportFaced = ElimReportFacadeFactory.getLocalInstance(buildInfo.getCtx());
        }
        Map sumResult = null;
        if (buildInfo.isSupportCrossMerger()) {
            boolean doOffset = true;
            boolean includeDiffTable = false;
            sumResult = calculator.calculateDynaCslRpt(buildInfo.getDynaCslRptParamInfo(), tableValues, doOffset, includeDiffTable);
        } else {
            sumResult = calculator.calculateDynaSumRpt(buildInfo.getSrcCslRptInfo().getId().toString(), buildInfo.getCompanyList(), tableValues, true, false);
        }
        buildInfo.storeOriginalData(this.surgeSumResult(tableValues, sumResult, buildInfo));
        buildInfo.setTableScanValues(tableValues);
        RptProperties condition = new RptProperties();
        condition.setString("pk", buildInfo.getSrcCslRptInfo().getId().toString());
        condition.setInt("dynaType", buildInfo.getDynaCslRptParamInfo().getSumMethod().getValue());
        Book book = buildInfo.getSrcCslRptInfo().getBook();
        HashMap<String, Integer> sheetSumMthRela = new HashMap<String, Integer>();
        HashMap<String, Integer> calcSumMthRela = new HashMap<String, Integer>();
        int size = book.getSheetCount();
        for (int i = 0; i < size; ++i) {
            Sheet table = book.getSheet(i);
            DynaSumMethodEnum sumMethod = DynamicTemplateUtility.getSheetSumMethod((Sheet)table);
            if (sumMethod == null) continue;
            calcSumMthRela.put(table.getID(), sumMethod.getValue());
            if (ElimReportUtils.isSumByName(sumMethod)) {
                sumMethod = DynaSumMethodEnum.SUM_BY_NAME;
            } else if (ElimReportUtils.isSumByListDetail(sumMethod)) {
                sumMethod = DynaSumMethodEnum.LIST_DETAIL_COMP_NAME;
            }
            sheetSumMthRela.put(table.getID(), sumMethod.getValue());
        }
        condition.setObject("sheetSumMthRela", sheetSumMthRela);
        condition.setObject("calcSumMthRela", calcSumMthRela);
        Map modifiedData = elimReportFaced.getReportItemData(condition);
        this.correctPoint(modifiedData, buildInfo);
        buildInfo.storeModifiedData(modifiedData);
    }

    private void correctPoint(Map<String, List<IItemData>> modifiedData, BuildElimRptBookInfo buildInfo) throws Exception {
        if (!buildInfo.isDyRptSaveUpdateItem4CM()) {
            Book book = buildInfo.getSrcCslRptInfo().getBook();
            Map<String, NameMappedPoint> nameMappedPoint = this.getNameMappedPoint(book);
            if (modifiedData == null || modifiedData.size() == 0 || nameMappedPoint.size() == 0) {
                return;
            }
            for (Map.Entry<String, List<IItemData>> entry : modifiedData.entrySet()) {
                NameMappedPoint mapped = nameMappedPoint.get(entry.getKey());
                if (mapped == null) continue;
                for (IItemData itemData : entry.getValue()) {
                    mapped.correctPoint(itemData.getPosition(), itemData);
                }
            }
        }
    }

    private Map<String, List<IItemData>> surgeSumResult(Map<Object, Object> tableValues, Map sumResult, BuildElimRptBookInfo buildInfo) throws Exception {
        HashMap<String, List<IItemData>> originalData = new HashMap<String, List<IItemData>>();
        if (tableValues == null || tableValues.size() == 0 || sumResult == null || sumResult.size() == 0) {
            return originalData;
        }
        FormulaItemData itemData = null;
        for (Map.Entry entry : sumResult.entrySet()) {
            String sheetId = (String)entry.getKey();
            if (entry.getValue() == null || ((Map)entry.getValue()).size() == 0 || tableValues.get(sheetId) == null || ((Map)tableValues.get(sheetId)).size() == 0) continue;
            Map tabSheetMap = (Map)tableValues.get(sheetId);
            Map sumSheetMap = (Map)entry.getValue();
            for (Map.Entry entry2 : sumSheetMap.entrySet()) {
                Point basePoint = (Point)entry2.getKey();
                Map sumPointMap = (Map)entry2.getValue();
                Map tabPointMap = (Map)tabSheetMap.get(basePoint);
                if (sumPointMap == null || sumPointMap.size() == 0 || tabPointMap == null || tabPointMap.size() == 0) continue;
                Map tabFormulaMap = (Map)tabPointMap.get("formulas");
                Map<Point, ItemFormula> pointFormulaMap = this.initFormulasParam(tabFormulaMap);
                DynaParameters param = DynaParameters.getInstanceFromString((String)((String)tabPointMap.get("param")));
                for (Map.Entry entry3 : sumPointMap.entrySet()) {
                    Map valuesMap = (Map)entry3.getValue();
                    String keyNumber = ElimReportUtils.isSumByName(param.getSumMethod()) ? (String)entry3.getKey() : (String)valuesMap.get("KEY_DITEM_NAME");
                    String keyName = (String)valuesMap.get("KEY_DITEM_NAME");
                    if (!buildInfo.isDyRptSaveUpdateItem4CM()) {
                        keyNumber = (String)entry3.getKey();
                    }
                    Map pointMap = (Map)valuesMap.get("KEY_POINT_VALUE");
                    if (valuesMap == null || valuesMap.size() == 0) continue;
                    for (Map.Entry entry4 : pointMap.entrySet()) {
                        Point point = (Point)entry4.getKey();
                        Object value = entry4.getValue();
                        if (value == null || pointFormulaMap.get(point).getValueType() == 3 || value instanceof Number && new BigDecimal(((Number)value).toString()).compareTo(new BigDecimal("0.0")) == 0) continue;
                        if (!originalData.containsKey(sheetId)) {
                            ArrayList lst = new ArrayList();
                            originalData.put(sheetId, lst);
                        }
                        itemData = new FormulaItemData(pointFormulaMap.get(point), keyNumber, value);
                        itemData.setKeyName(keyName);
                        ((List)originalData.get(sheetId)).add(itemData);
                    }
                }
            }
        }
        return originalData;
    }

    private Map<String, NameMappedPoint> getNameMappedPoint(Book book) {
        HashMap<String, NameMappedPoint> nameMappedPoint = new HashMap<String, NameMappedPoint>();
        int size = book.getSheetCount();
        for (int i = 0; i < size; ++i) {
            Sheet sheet = book.getSheet(i);
            ArrayList basePointList = DynamicTemplateUtility.getBasePointList((Sheet)sheet);
            if (basePointList == null || basePointList.isEmpty()) continue;
            Point firstBasePoint = (Point)basePointList.get(0);
            DynaParameters params = DynamicTemplateUtility.getDynaParameters((Sheet)sheet, (Point)firstBasePoint);
            int spreadStyle = params.getSpreadStyle();
            boolean hasDItem = DyRptSaveHelper.hasDItem(sheet, basePointList);
            if (hasDItem) continue;
            nameMappedPoint.put(sheet.getID(), new NameMappedPoint(spreadStyle, DyRptSaveHelper.getDynaNameMap(sheet, basePointList, true)));
        }
        return nameMappedPoint;
    }

    private Map<Point, ItemFormula> initFormulasParam(Map tabFormulaMap) throws Exception {
        HashMap<Point, ItemFormula> formulas = new HashMap<Point, ItemFormula>();
        if (tabFormulaMap != null) {
            for (Map.Entry entry : tabFormulaMap.entrySet()) {
                formulas.put((Point)entry.getKey(), this.initFormulaYearAndPeriod((ItemFormula)entry.getValue()));
            }
        }
        return formulas;
    }

    private ItemFormula initFormulaYearAndPeriod(ItemFormula formula) throws Exception {
        RptCalcHelper.offsetYearAndPeriod(this.paramBox.isMergeByFiscalPeriod(), this.paramBox.isSupport13Period(), (RptPeriodTypeEnum)this.paramBox.getAttribute("periodType"), (Integer)this.paramBox.getAttribute("year"), (Integer)this.paramBox.getAttribute("period"), formula, (PeriodCollection)this.paramBox.getAttribute("periods"));
        return formula;
    }

    private void initCslParamBox(BuildElimRptBookInfo buildInfo) throws Exception {
        boolean[] values = CSLParamUtil.batchGetParam(buildInfo.getCtx(), new String[]{"GR_CSL_MergeByFiscalPeriod", "GR_CSL_Support13Period"});
        this.paramBox = new CslParamBox();
        this.paramBox.setMergeByFiscalPeriod(values[0]);
        this.paramBox.setSupport13Period(values[1]);
        PeriodCollection periods = null;
        CslReportInfo cslreportInfo = buildInfo.getSrcCslRptInfo();
        if (this.paramBox.isMergeByFiscalPeriod()) {
            periods = FiscalPeriodHelper.getPeriodCollection(buildInfo.getCtx(), cslreportInfo);
            this.paramBox.setAttribute("periods", periods);
        }
        this.paramBox.setAttribute("periodType", cslreportInfo.getPeriodType());
        this.paramBox.setAttribute("year", cslreportInfo.getYear());
        this.paramBox.setAttribute("period", cslreportInfo.getPeriod());
    }

    private Map<Object, Object> getTableValues(BuildElimRptBookInfo buildInfo) throws Exception {
        Book book = buildInfo.getSrcCslRptInfo().getBook();
        HashMap<String, Sheet> tables = new HashMap<String, Sheet>();
        HashMap<Object, Object> tableValues = new HashMap<Object, Object>();
        int size = book.getSheetCount();
        for (int i = 0; i < size; ++i) {
            Sheet table = book.getSheet(i);
            DynaSumMethodEnum sumMethod = DynamicTemplateUtility.getSheetSumMethod((Sheet)table);
            if (!ElimReportUtils.isSumByName(sumMethod) && !ElimReportUtils.isSumByListDetail(sumMethod)) continue;
            Map tableMap = SumHelper.scanDynaTable(table, sumMethod == null ? buildInfo.getDynaCslRptParamInfo().getSumMethod() : sumMethod, buildInfo.getDynaCslRptParamInfo().isOnlyList(), buildInfo.getDynaCslRptParamInfo().isShowTotal(), buildInfo.getDynaCslRptParamInfo().isOnlyListCompany());
            if (table == null) continue;
            tables.put(table.getID(), table);
            tableValues.put(table.getID(), tableMap);
        }
        return tableValues;
    }

    class NameMappedPoint {
        private int spreadStyle;
        private Map map;

        protected NameMappedPoint(int spreadStyle, Map map) {
            this.spreadStyle = spreadStyle;
            this.map = map;
        }

        public void correctPoint(Point point, IItemData itemData) {
            if (this.map == null || this.map.size() == 0) {
                return;
            }
            String strKey = itemData.getKey();
            int lastIndex = strKey.lastIndexOf("]");
            String itemKey = strKey.substring(0, strKey.indexOf("]") + 1) + strKey.substring(strKey.lastIndexOf("[", lastIndex - 4), lastIndex + 1);
            Object basePoint = this.map.get(itemKey);
            if (basePoint != null) {
                Map curMap = (Map)this.map.get(basePoint);
                String key = (String)itemData.extObj();
                for (Map.Entry entry : curMap.entrySet()) {
                    if (!((String)entry.getValue()).equals(key)) continue;
                    if (this.spreadStyle == 0) {
                        point.x = ((Point)entry.getKey()).y;
                        break;
                    }
                    point.y = ((Point)entry.getKey()).x;
                    break;
                }
            }
        }
    }
}

